block pendulum_PositionDetector "Pendula stimuli"
  import Modelica.Blocks;
  import Modelica.Blocks.Interfaces;
  extends Modelica.Blocks.Icons.Block;
  Modelica.Blocks.Interfaces.RealInput angle "Connector of Real input signal 1" annotation(
    Placement(transformation(extent = {{-120, -10}, {-100, 10}})));
  Modelica.Blocks.Interfaces.BooleanOutput zeroCrossing "Connector of Real output signal" annotation(
    Placement(transformation(extent = {{100, -10}, {120, 10}})));
parameter Real a_threshold = 0.019;
parameter Real a0 = 0.0;
equation
  zeroCrossing = ((angle+a0) < a_threshold) and ((angle+a0) > -a_threshold);
//algorithm
  //when sample(0, 0.002) then
  //if((a0 < a_threshold) and (a0 > -a_threshold)) then
  //  zeroCrossing := true;
  //else
  //  zeroCrossing := false;
  //end if;
  //end when;   
  annotation(
    Documentation(info = "<html>
<p>
Example Block for test.
</p>
</html>"));
end pendulum_PositionDetector;