block pendel_Stimulator_FB "Pendula stimuli"
  import Modelica.Blocks;
  import Modelica.Blocks.Interfaces;
  extends Modelica.Blocks.Icons.Block;
  Modelica.Blocks.Interfaces.BooleanInput zeroCrossing "Connector of Real input signal 1" annotation(
    Placement(transformation(extent = {{-120, -10}, {-100, 10}})));
  Modelica.Blocks.Interfaces.BooleanOutput impuls "Connector of Real output signal" annotation(
    Placement(transformation(extent = {{100, 50}, {120, 70}})));
  Modelica.Blocks.Interfaces.IntegerOutput cto "Connector of Real output signal" annotation(
    Placement(transformation(extent = {{100, -70}, {120, -50}})));
Integer ct;
parameter Integer ctRange = 5; //range where the ct is proper for impuls
parameter Integer ctPeriod = 50; //period for ct adequat to step time and pendulum period
algorithm
  when initial() then
    impuls := false;
  end when;
  when sample(0, 0.02) then
     if( not zeroCrossing and ct >=5) then //the end of the zerocrossing signal:
       ct := div(ct - ctRange, 2)          //middle value of zeroCrossing width 
           - ctPeriod + ctRange;           //set to negativ value (-45)
     end if;  
     //
     if(ct ==(ctPeriod + ctRange) and zeroCrossing) then
       ct := ctRange;          //counter reset to start in positive range
       impuls := true;         //impuls without knowledge of pendula position
     //
     elseif(ct <ctRange and ct > -ctRange and zeroCrossing) then
       ct := ctRange;          //counter about 0, and zeroCrossing
       impuls := true;         //synchronized impuls
     else  
       impuls := false;
     end if;      
     ct := ct +1;
     cto := ct;
  end when;
  annotation(
    Documentation(info = "<html>
<p>
Example Block for test.
</p>
</html>"));
end pendel_Stimulator_FB;
