block pendel_FB "A pendulum as demo"
  extends Modelica.Blocks.Icons.Block;

  Modelica.Blocks.Interfaces.RealInput u "Additional force for pendulum" annotation (Placement(
        transformation(extent={{-120,-10},{-100,10}})));
  Modelica.Blocks.Interfaces.RealOutput y "The angle of pendulum" annotation (Placement(
        transformation(extent={{-20,-100},{20,-140}})));
  parameter Real m = 0.1;      //mass in kg
  parameter Real l = 0.249;     //length in m: l = g/(pi*pi) * T*T/4 =~ 0.994 * T*T/4 
  parameter Real g = 9.81;     //gravitation of earth
  parameter Real kf = 0.01;    //newton per (m/s)*(m/s) for friction
  //
  Real v;                  //velocity of pendulum
  Real angle(start = 0.1); //The angle of pendulum;
  Real fg, ff; //The actual force in direction of pendulum
equation
  der(v) = (fg - ff + u)/m;     //newtons lore for accelaration, force and mass
  fg = (-m * g * sin(angle));
  ff = sign(v) * kf * l * 2 * Modelica.Constants.pi * v*v;
  der(angle) = v / l;  //derivation of angle, the angle velocity and the absolute velocity
  y = angle;
  annotation(
    Diagram,
    Icon(graphics = {Ellipse(origin = {-26, -69}, fillColor = {170, 85, 0}, fillPattern = FillPattern.Sphere, extent = {{-22, 23}, {10, -11}}, endAngle = 360), Line(origin = {-13, 1}, points = {{11, 59}, {-15, -47}}, color = {170, 85, 0}, thickness = 2)}));end pendel_FB;