#include "myTestFnAlloc_Mdlwrp.h" //first include the own header
#include "myTestFnAlloc.h"        //after them the header of used routines
#include <emC/Handle_ptr64_emC.h>      
#include <stdio.h>
#include <stdlib.h>   //for malloc and free
#include "omc/c/ModelicaUtilities.h"


int ctorAlloc_MyTestFnAlloc_Mdlwrp(int thizInit, double y0)
{
  if(thizInit !=0) return thizInit; //it is initialized already, more as one call is possible and acceptable
  //
  MyTestFnAlloc_s* thiz = (MyTestFnAlloc_s*)malloc(sizeof(MyTestFnAlloc_s));
  memset(thiz, 0, sizeof(MyTestFnAlloc_s));
  //
  uint32 hthiz = registerPtr_Handle2Ptr(thiz, "MyTestFnAlloc");
  if(hthiz == 0) { ModelicaError("any Problem with Handle2Ptr"); }
  else {
    ModelicaMessage("ctor myTestFnAlloc_Mdlwrp\n");
    //
    //call the core routine
    ctor_MyTestFnAlloc(thiz, (float)y0);
    //
  }
  //hthiz = -2; //uncomment to force an exception because faulty handle
  return hthiz;
}


void dtorFree_MyTestFnAlloc_Mdlwrp(int hthiz)
{
  if(hthiz !=0){
    MyTestFnAlloc_s* thiz = (MyTestFnAlloc_s*)clearHandle_Handle2Ptr(hthiz);
    if(thiz !=null && thiz->signum == signum_MyTestFnAlloc) {
      //
      //call the core routine
      dtor_MyTestFnAlloc(thiz);  //call the core routine
      free(thiz);
    }
  }
}


double step_MyTestFnAlloc_Mdlwrp(int hthiz, double u, double k1)
{ if(hthiz == 0) return -1; //not initalized
  MyTestFnAlloc_s* thiz = (MyTestFnAlloc_s*)ptr_Handle2Ptr(hthiz);
  if(thiz !=null && thiz->signum == signum_MyTestFnAlloc) {
    //
    //call the core routine
    return step_MyTestFnAlloc(thiz, (float)u, (float)k1);  
    //
  }
  else {
    ModelicaError("faulty instance for step_MyTestFnAlloc_Mdlwrp");
    return -1; 
  }
}


double step2_MyTestFnAlloc_Mdlwrp(int hthiz, double k1, double stepin)
{ if(hthiz == 0) return -1; //not initalized
  MyTestFnAlloc_s* thiz = (MyTestFnAlloc_s*)ptr_Handle2Ptr(hthiz);
  if(thiz !=null && thiz->signum == signum_MyTestFnAlloc) {
    //
    //call the core routine
    return step2_MyTestFnAlloc(thiz, (float)k1);  
    //
  }
  else {
    ModelicaError("faulty instance for step2_MyTestFnAlloc_Mdlwrp");
    return -1; 
  }
}


void getCt_MyTestFnAlloc_Mdlwrp(int hthiz, int* ct1, int* ct2)
{ if(hthiz == 0) return; //not initalized
  MyTestFnAlloc_s* thiz = (MyTestFnAlloc_s*)ptr_Handle2Ptr(hthiz);
  if(thiz !=null && thiz->signum == signum_MyTestFnAlloc) {
    //
    //call the core routine
    return getCt_MyTestFnAlloc(thiz, ct1, ct2);  
    //
  }
  else {
    ModelicaError("faulty instance for getCt_MyTestFnAlloc_Mdlwrp");
  }
}
