#ifndef __myTestFnAlloc_h__
#define __myTestFnAlloc_h__
#include <applstdef_emC.h>  //for some application specific but common definition

/**Data structure for example
 */
typedef struct MyTestFnAlloc_t {
  
  /**Mark the data with a signum for check. */
  char const* signum;
  
  /**Some user example data. */
  float q1, q2;
  
  int32 ct1, ct2;
} MyTestFnAlloc_s;   //Note: _t _s suffix is style for reflection generation and C++-class-usage.

/**The definition of an address for signum of data. */
extern_C char const* signum_MyTestFnAlloc;

/**The constructor for the example class. 
 * @arg y0 start value
 */
void ctor_MyTestFnAlloc(MyTestFnAlloc_s* thiz, float y0);

/**The destructor, here empty. */
void dtor_MyTestFnAlloc(MyTestFnAlloc_s* thiz);

/**Step routine for the example class.
 * @arg u input
 * @arg k1 any example parameter
 * @return output
 */
float step_MyTestFnAlloc(MyTestFnAlloc_s* thiz, float u, float k1);

/**Step2 routine for the example class.
 * @arg k1 any example parameter
 * @return output
 */
float step2_MyTestFnAlloc(MyTestFnAlloc_s* thiz, float k1);


inline void getCt_MyTestFnAlloc(MyTestFnAlloc_s* thiz, int* ct1, int*ct2) { *ct1 = thiz->ct1; *ct2 = thiz->ct2; }


#endif //__myTestFnAlloc_h__
