block MyTestFnCrecord_FB
  extends Modelica.Blocks.Icons.Block;
  Modelica.Blocks.Interfaces.RealInput u "comment" annotation (Placement(
        transformation(extent={{-120,-10},{-100,10}})));
  Modelica.Blocks.Interfaces.RealOutput y "comment" annotation (Placement(
        transformation(extent={{100,-10},{120,10}})));
  Modelica.Blocks.Interfaces.RealOutput testInit "comment" annotation (Placement(
        transformation(extent={{100,-90},{120,-70}})));
  parameter Real k1 = 0.01; 
  
  record Data
    Real q1, q2;
  end Data;   
  Data data; 
  protected 
  function fn
    input Data thiz;
    input  Real u;
    input  Real k;
    output Real y;
    external "C"  y = mytestFnRecord(thiz, u,k);
    annotation( //Include="#include \"myTestFnRecord.h\"",  //Note: cannot include, twice definition
                Library = "myTestFnRecord.o");
  end fn;

//initial equation
//    data.q1 = 5.2;
//    data.q2 = -3;
  
algorithm
  when initial() then
    data.q1 := 1.2;
    data.q2 := data.q2 +1;
    testInit := data.q2;
    y := 0;
  end when;
  when sample(0, 0.001) then
    y := fn(data, u, k1);
  end when;  

end MyTestFnCrecord_FB;