block MyTestFnAlloc_FB

  extends Modelica.Blocks.Icons.Block;
  Modelica.Blocks.Interfaces.RealInput u "comment" annotation (Placement(
        transformation(extent={{-120,-10},{-100,10}})));
  Modelica.Blocks.Interfaces.RealOutput y "comment" annotation (Placement(
        transformation(extent={{100,-10},{120,10}})));
  Modelica.Blocks.Interfaces.IntegerOutput thizout "comment" annotation (Placement(
        transformation(extent={{100,-90},{120,-70}})));
  //parameter Real k1 = 0.01; 
  parameter Real k1 = 0.005;
  parameter Real y0 = 1.2;
  parameter Real Tstep = 0.01;
  Integer ct;
  protected Integer thiz;
   
  function ctorAlloc
    input Integer thizInit;
    input Real y0;
    output Integer thiz;
    external "C"  thiz = ctorAlloc_MyTestFnAlloc_Mdlwrp(thizInit, y0);
    annotation
    ( Include = "#include \"myTestFnAlloc_Mdlwrp.h\""
    , Library = "libmyTestFnAlloc.a"
    );
  end ctorAlloc;
  function dtor
    input Integer thiz;
    external "C"  dtorFree_MyTestFnAlloc_Mdlwrp(thiz);
  end dtor;
  function step
    input Integer thiz;
    input Real u;
    input Real k1;
    output Real y;
    external "C"  y = step_MyTestFnAlloc_Mdlwrp(thiz, u, k1);
  end step;

algorithm
  when initial() then
    thiz := ctorAlloc(thiz, y0);
    Modelica.Utilities.Streams.print("Info from: " + getInstanceName()); 
    thizout := thiz; 
    y := 0;  //only formally, modelica warning
    ct := 0;
  end when;
  when terminal() then
    dtor(thiz);
  end when;
  when sample(0, Tstep) then
    y := step(thiz, u, k1);
    ct := ct +1;
  end when;  


end MyTestFnAlloc_FB;
