/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.xmlSimple;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.vishia.util.Assert;
import org.vishia.xmlSimple.XmlNode;

public class SimpleXmlOutputter {
    public static final int version = 20121130;
    int mode;
    String newline = "\r\n";
    String sIdent = "\r\n                                                                                            ";

    public void write(OutputStreamWriter outputStreamWriter, XmlNode xmlNode) throws IOException {
        String string = outputStreamWriter.getEncoding();
        Charset charset = Charset.forName(string);
        String string2 = charset.displayName();
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"" + string2 + "\"?>" + this.newline);
        outputStreamWriter.write("<!-- written with org.vishia.xmlSimple.SimpleXmlOutputter -->");
        this.writeNode(bufferedWriter, xmlNode, 0);
        bufferedWriter.write(this.newline);
        bufferedWriter.close();
    }

    /*
     * WARNING - void declaration
     */
    protected void writeNode(Writer writer, XmlNode xmlNode, int n) throws IOException {
        void var7_15;
        boolean bl;
        String string;
        Object object;
        List<String[]> list;
        String string2;
        if (n >= 0 && n < this.sIdent.length() / 2) {
            writer.write(this.sIdent.substring(0, 2 + n * 2));
        }
        if ((string2 = xmlNode.getName()).equals("em")) {
            Assert.stop();
        }
        String string3 = xmlNode.getNamespaceKey() != null ? xmlNode.getNamespaceKey() + ":" + string2 : string2;
        Assert.check(!string3.startsWith("@"));
        writer.write(SimpleXmlOutputter.elementStart(string3));
        if ((this.mode & ModeBits.writeAttribsInAlphabeticOrder.maskbit) != 0) {
            list = xmlNode.getAttributes();
            if (list != null) {
                for (Map.Entry entry : list.entrySet()) {
                    object = (String)entry.getKey();
                    string = (String)entry.getValue();
                    writer.write(SimpleXmlOutputter.attribute((String)object, string));
                }
            }
        } else {
            list = xmlNode.getAttributeList();
            if (list != null) {
                for (String[] stringArray : list) {
                    writer.write(SimpleXmlOutputter.attribute(stringArray[0], stringArray[1]));
                }
            }
        }
        if (xmlNode.getNamespaces() != null) {
            for (Map.Entry entry : xmlNode.getNamespaces().entrySet()) {
                String string4 = (String)entry.getKey();
                object = (String)entry.getValue();
                writer.write(SimpleXmlOutputter.attribute("xmlns:" + string4, (String)object));
            }
        }
        list = xmlNode.iterChildren();
        boolean bl2 = false;
        boolean bl3 = false;
        if (list != null) {
            while (list.hasNext()) {
                boolean bl4;
                object = (XmlNode)list.next();
                if (object.isTextNode()) {
                    string = object.text();
                    if (!bl4) {
                        writer.write(SimpleXmlOutputter.elementTagEnd());
                        bl4 = true;
                    }
                    writer.write(SimpleXmlOutputter.convertString(string).toString());
                    n = -1;
                    continue;
                }
                if (object.getName().startsWith("@")) continue;
                if (!bl4) {
                    writer.write(SimpleXmlOutputter.elementTagEnd());
                    bl4 = true;
                }
                this.writeNode(writer, (XmlNode)object, n >= 0 ? n + 1 : -1);
                bl = true;
            }
        } else {
            object = xmlNode.text();
            if (object != null && ((String)object).length() > 0) {
                writer.write(SimpleXmlOutputter.elementTagEnd());
                boolean bl5 = true;
                writer.write(SimpleXmlOutputter.convertString((String)object).toString());
            }
        }
        if (var7_15 != false) {
            if (bl && n >= 0 && n < this.sIdent.length() / 2) {
                writer.write(this.sIdent.substring(0, 2 + n * 2));
            }
            writer.write(SimpleXmlOutputter.elementEnd(string3));
        } else {
            writer.write(SimpleXmlOutputter.elementShortEnd());
        }
    }

    public static String elementStart(String string) {
        return "<" + string;
    }

    public static String elementTagEnd() {
        return ">";
    }

    public static String elementShortEnd() {
        return "/>";
    }

    public static String elementEnd(String string) {
        return "</" + string + ">";
    }

    public static String attribute(String string, String string2) {
        return " " + string + "=\"" + SimpleXmlOutputter.convertString(string2) + "\" ";
    }

    public static CharSequence convertString(String string) {
        StringBuilder[] stringBuilderArray = new StringBuilder[1];
        String[] stringArray = new String[]{string};
        int n = stringArray[0].indexOf(38);
        if (n >= 0) {
            SimpleXmlOutputter.convert(stringBuilderArray, stringArray, n, '&', "&amp;");
        }
        if ((n = stringArray[0].indexOf(60)) >= 0) {
            SimpleXmlOutputter.convert(stringBuilderArray, stringArray, n, '<', "&lt;");
        }
        if ((n = stringArray[0].indexOf(62)) >= 0) {
            SimpleXmlOutputter.convert(stringBuilderArray, stringArray, n, '>', "&gt;");
        }
        if ((n = stringArray[0].indexOf(34)) >= 0) {
            SimpleXmlOutputter.convert(stringBuilderArray, stringArray, n, '\"', "&quot;");
        }
        if ((n = stringArray[0].indexOf(39)) >= 0) {
            SimpleXmlOutputter.convert(stringBuilderArray, stringArray, n, '\'', "&apos;");
        }
        if ((n = stringArray[0].indexOf(10)) >= 0) {
            SimpleXmlOutputter.convert(stringBuilderArray, stringArray, n, '\n', "&#x0a;");
        }
        if ((n = stringArray[0].indexOf(13)) >= 0) {
            SimpleXmlOutputter.convert(stringBuilderArray, stringArray, n, '\n', "&#x0d;");
        }
        if (stringBuilderArray[0] == null) {
            return string;
        }
        return stringBuilderArray[0];
    }

    private static void convert(StringBuilder[] stringBuilderArray, String[] stringArray, int n, char c, String string) {
        if (stringBuilderArray[0] == null) {
            stringBuilderArray[0] = new StringBuilder(stringArray[0]);
        }
        do {
            stringBuilderArray[0].replace(n, n + 1, string);
            stringArray[0] = stringBuilderArray[0].toString();
        } while ((n = stringArray[0].indexOf(c, n + string.length())) >= 0);
    }

    static enum ModeBits {
        writeNl(1),
        writeNlAftertext(2),
        writeAttribsInAlphabeticOrder(16);

        final int maskbit;

        private ModeBits(int n2) {
            this.maskbit = n2;
        }
    }
}

