/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.xmlReader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.vishia.util.Assert;
import org.vishia.util.DataAccess;
import org.vishia.util.Debugutil;
import org.vishia.util.FileSystem;
import org.vishia.util.IndexMultiTable;
import org.vishia.util.StringFunctions;
import org.vishia.util.StringPart;
import org.vishia.util.StringPartFromFileLines;
import org.vishia.xmlReader.XmlCfg;

public class XmlJzReader {
    public static final String version = "2018-08-15";
    XmlCfg cfg = new XmlCfg();
    final XmlCfg cfgCfg;
    int sizeBuffer = 20000;
    int debugStopLine = -1;
    Map<String, String> namespaces = new IndexMultiTable<String, String>(IndexMultiTable.providerString);

    public XmlJzReader() {
        this.cfgCfg = XmlCfg.newCfgCfg();
    }

    public void setDebugStop(int n) {
        this.debugStopLine = n;
    }

    public void XXXXreadXmlCfg(File file) {
        this.cfg = new XmlCfg();
    }

    public String readXml(File file, Object object, XmlCfg xmlCfg) {
        String string = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            String string2 = FileSystem.normalizePath(file.getAbsoluteFile()).toString();
            string = this.readXml(fileInputStream, string2, object, xmlCfg);
            ((InputStream)fileInputStream).close();
        }
        catch (IOException iOException) {
            string = "XmlReader.readXml(...) file not found: " + file.getAbsolutePath();
        }
        return string;
    }

    public String readZipXml(File file, String string, Object object) {
        String string2 = null;
        try {
            ZipFile zipFile = new ZipFile(file);
            ZipEntry zipEntry = zipFile.getEntry(string);
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            String string3 = file.getAbsolutePath() + ":" + string;
            string2 = this.readXml(inputStream, string3, object, this.cfg);
            inputStream.close();
            zipFile.close();
        }
        catch (Exception exception) {
            string2 = exception.getMessage();
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readXml(InputStream inputStream, String string, Object object, XmlCfg xmlCfg) {
        String string2 = null;
        try (StringPartFromFileLines stringPartFromFileLines = null;){
            stringPartFromFileLines = new StringPartFromFileLines(inputStream, string, this.sizeBuffer, "encoding", null);
            this.readXml(stringPartFromFileLines, object, xmlCfg);
        }
        return string2;
    }

    private void readXml(StringPartFromFileLines stringPartFromFileLines, Object object, XmlCfg xmlCfg) throws Exception {
        stringPartFromFileLines.setIgnoreWhitespaces(true);
        stringPartFromFileLines.seekEnd("<");
        if (stringPartFromFileLines.scan("?").scanOk()) {
            stringPartFromFileLines.seekEnd("?>");
            stringPartFromFileLines.scanOk();
        }
        while (stringPartFromFileLines.seekEnd("<").found()) {
            stringPartFromFileLines.scanOk();
            stringPartFromFileLines.readnextContentFromFile(this.sizeBuffer * 2 / 3);
            if (stringPartFromFileLines.scan().scan("!--").scanOk()) {
                stringPartFromFileLines.seekEnd("-->");
                continue;
            }
            this.parseElement(stringPartFromFileLines, object, xmlCfg.rootNode);
        }
        Debugutil.stop();
    }

    private void parseElement(StringPartFromFileLines stringPartFromFileLines, Object object, XmlCfg.XmlCfgNode xmlCfgNode) throws Exception {
        CharSequence charSequence;
        XmlCfg.XmlCfgNode xmlCfgNode2;
        int n = -7777;
        if (this.debugStopLine >= 0 && (n = stringPartFromFileLines.getLineAndColumn(null)) == this.debugStopLine) {
            Debugutil.stop();
        }
        if (!stringPartFromFileLines.scanIdentifier(null, "-:.").scanOk()) {
            throw new IllegalArgumentException("tag name expected");
        }
        String string = stringPartFromFileLines.getLastScannedString().toString();
        if (string.contains("   ")) {
            Debugutil.stop();
        }
        if (string.equals("Object")) {
            Debugutil.stop();
        }
        Object object2 = null;
        if (xmlCfgNode == null) {
            object2 = null;
            xmlCfgNode2 = null;
        } else {
            if (object == null) {
                Debugutil.stop();
            }
            Assert.check(object != null);
            if (string.toString().contains("   ")) {
                Debugutil.stop();
            }
            if (string.toString().startsWith("Object@")) {
                Debugutil.stop();
            }
            if (xmlCfgNode.subnodes == null) {
                xmlCfgNode2 = null;
            } else {
                xmlCfgNode2 = xmlCfgNode.subnodes.get(string);
                if (xmlCfgNode2 == null) {
                    xmlCfgNode2 = xmlCfgNode.subnodes.get("?");
                }
            }
            if (string.toString().contains("   ")) {
                Debugutil.stop();
            }
        }
        Map[] mapArray = new Map[1];
        List[] listArray = new List[1];
        if (n == this.debugStopLine) {
            Debugutil.stop();
        }
        if ((charSequence = this.parseAttributes(stringPartFromFileLines, string, xmlCfgNode2, listArray, mapArray)).length() > string.length()) {
            xmlCfgNode2 = xmlCfgNode.subnodes == null ? null : xmlCfgNode.subnodes.get(charSequence);
        }
        Object object3 = object2 = xmlCfgNode2 == null ? null : this.getDataForTheElement(object, xmlCfgNode2, charSequence, mapArray);
        if (listArray[0] != null) {
            if (object2 == null) {
                System.err.println("Problem storing attribute values, getDataForTheElement \"" + xmlCfgNode2.elementStorePath + "\" returns null");
            } else {
                for (AttribToStore attribToStore : listArray[0]) {
                    this.storeAttrData(object2, attribToStore.daccess, attribToStore.name, attribToStore.value);
                }
            }
        }
        if (!stringPartFromFileLines.scan("/").scan(">").scanOk()) {
            if (stringPartFromFileLines.scan(">").scanOk()) {
                Object object4 = null;
                while (!stringPartFromFileLines.scan().scan("<").scan("/").scanOk()) {
                    stringPartFromFileLines.readnextContentFromFile(this.sizeBuffer / 2);
                    if (stringPartFromFileLines.scan("<").scanOk()) {
                        if (stringPartFromFileLines.scan("!--").scanOk()) {
                            stringPartFromFileLines.seekEnd("-->");
                            continue;
                        }
                        this.parseElement(stringPartFromFileLines, object2, xmlCfgNode2);
                        continue;
                    }
                    if (object4 == null && object2 != null) {
                        object4 = new StringBuilder(500);
                    }
                    this.parseContent(stringPartFromFileLines, (StringBuilder)object4);
                }
                stringPartFromFileLines.readnextContentFromFile(this.sizeBuffer / 2);
                if (!stringPartFromFileLines.scanIdentifier(null, "-:.").scanOk()) {
                    throw new IllegalArgumentException("</tag expected");
                }
                stringPartFromFileLines.setLengthMax();
                if (!stringPartFromFileLines.scan(">").scanOk()) {
                    throw new IllegalArgumentException("</tag > expected");
                }
                if (object4 != null && object2 != null) {
                    this.storeContent((StringBuilder)object4, xmlCfgNode2, object2, mapArray);
                }
            } else {
                throw new IllegalArgumentException("either \">\" or \"/>\" expected");
            }
        }
        stringPartFromFileLines.setLengthMax();
    }

    private CharSequence parseAttributes(StringPartFromFileLines stringPartFromFileLines, CharSequence charSequence, XmlCfg.XmlCfgNode xmlCfgNode, List<AttribToStore>[] listArray, Map<String, String>[] mapArray) throws Exception {
        CharSequence charSequence2 = charSequence;
        StringBuilder stringBuilder = null;
        while (stringPartFromFileLines.scanIdentifier(null, "-:").scan("=").scanOk()) {
            String string = stringPartFromFileLines.getLastScannedString();
            if (!stringPartFromFileLines.scanQuotion("\"", "\"", null).scanOk()) {
                throw new IllegalArgumentException("attr value expected");
            }
            if (xmlCfgNode != null) {
                Object object;
                Object object2;
                int n;
                String string2 = stringPartFromFileLines.getLastScannedString().toString();
                if (string.equals("xmlinput:class")) {
                    Debugutil.stop();
                }
                if ((n = StringFunctions.indexOf((CharSequence)string, ':')) >= 0) {
                    String string3;
                    object2 = string.subSequence(0, n);
                    CharSequence charSequence3 = string.subSequence(n + 1, string.length());
                    if (StringFunctions.equals((CharSequence)object2, "xmlns")) {
                        string3 = string2.toString();
                        this.namespaces.put(charSequence3.toString(), string3);
                        object = null;
                    } else {
                        String string4;
                        string3 = this.namespaces.get(object2);
                        object = string3 == null ? null : (xmlCfgNode.cfg.xmlnsAssign != null ? ((string4 = xmlCfgNode.cfg.xmlnsAssign.get(string3)) == null ? null : string4 + ":" + charSequence3) : string);
                    }
                } else {
                    object = string;
                }
                if (object != null) {
                    object2 = null;
                    if (xmlCfgNode.attribs != null && (object2 = xmlCfgNode.attribs.get(object)) == null) {
                        object2 = xmlCfgNode.attribs.get("?");
                    }
                    if (object2 != null) {
                        if (((XmlCfg.AttribDstCheck)object2).bUseForCheck) {
                            if (stringBuilder == null) {
                                stringBuilder = new StringBuilder(64);
                                stringBuilder.append(charSequence);
                                charSequence2 = stringBuilder;
                            }
                            stringBuilder.append("@").append((CharSequence)object).append("=\"").append(string2).append("\"");
                        } else if (((XmlCfg.AttribDstCheck)object2).daccess != null) {
                            if (listArray[0] == null) {
                                listArray[0] = new LinkedList<AttribToStore>();
                            }
                            listArray[0].add(new AttribToStore(((XmlCfg.AttribDstCheck)object2).daccess, object.toString(), string2));
                        } else if (((XmlCfg.AttribDstCheck)object2).storeInMap != null) {
                            if (mapArray[0] == null) {
                                mapArray[0] = new TreeMap<String, String>();
                            }
                            mapArray[0].put(((XmlCfg.AttribDstCheck)object2).storeInMap, string2);
                        }
                    } else if (xmlCfgNode.attribsUnspec != null) {
                        if (listArray[0] == null) {
                            listArray[0] = new LinkedList<AttribToStore>();
                        }
                        listArray[0].add(new AttribToStore(xmlCfgNode.attribsUnspec, object.toString(), string2));
                    }
                }
            }
            stringPartFromFileLines.readnextContentFromFile(this.sizeBuffer / 2);
        }
        return charSequence2;
    }

    Object getDataForTheElement(Object object, XmlCfg.XmlCfgNode xmlCfgNode, CharSequence charSequence, Map<String, String>[] mapArray) {
        Object object2;
        if (xmlCfgNode.elementStorePath == null) {
            object2 = object;
        } else {
            try {
                int n = xmlCfgNode.elementStorePath.nrArgNames();
                if (n > 0) {
                    Object[] objectArray = new Object[n];
                    for (int i = 0; i < n; ++i) {
                        String string = xmlCfgNode.elementStorePath.argName(i);
                        if (mapArray != null && mapArray[0] != null) {
                            objectArray[i] = mapArray[0].get(string);
                            if (objectArray[i] != null) continue;
                            Debugutil.stop();
                            continue;
                        }
                        if (!string.equals("tag")) continue;
                        objectArray[i] = charSequence;
                    }
                    object2 = DataAccess.invokeMethod(xmlCfgNode.elementStorePath, null, object, true, false, objectArray);
                } else {
                    object2 = DataAccess.access(xmlCfgNode.elementStorePath, object, true, false, false, null);
                }
            }
            catch (Exception exception) {
                object2 = null;
                CharSequence charSequence2 = Assert.exceptionInfo("", exception, 1, 30);
                System.err.println("error getDataForTheElement: " + xmlCfgNode.elementStorePath);
                System.err.println("help: ");
                System.err.println(charSequence2);
            }
        }
        return object2;
    }

    void storeAttrData(Object object, DataAccess.DatapathElement datapathElement, CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence.equals("xmlinput:class")) {
            Debugutil.stop();
        }
        try {
            int n = datapathElement.nrArgNames();
            if (n > 0) {
                Object[] objectArray = new Object[n];
                for (int i = 0; i < n; ++i) {
                    String string = datapathElement.argName(i);
                    if (string.equals("name")) {
                        objectArray[i] = charSequence;
                        continue;
                    }
                    if (string.equals("value")) {
                        objectArray[i] = charSequence2;
                        continue;
                    }
                    throw new IllegalArgumentException("argname");
                }
                DataAccess.invokeMethod(datapathElement, null, object, true, false, objectArray);
            } else {
                DataAccess.storeValue(datapathElement, object, (Object)charSequence2, true);
            }
        }
        catch (Exception exception) {
            System.err.println("error storeAttrData: " + exception.getMessage());
        }
    }

    private void setOutputAttr(Object object, DataAccess.DatapathElement datapathElement, CharSequence charSequence, CharSequence charSequence2) {
        if (datapathElement.equals("@") && object instanceof Map) {
            Map map = (Map)object;
            map.put("@" + charSequence, charSequence2.toString());
        }
    }

    private void parseContent(StringPartFromFileLines stringPartFromFileLines, StringBuilder stringBuilder) throws IOException {
        boolean bl;
        int n = stringBuilder == null ? 0 : stringBuilder.length() - 1;
        stringPartFromFileLines.seekNoWhitespace();
        boolean bl2 = false;
        do {
            stringPartFromFileLines.lento('<');
            boolean bl3 = bl = !stringPartFromFileLines.found();
            if (bl) {
                if (bl2) {
                    throw new IllegalArgumentException("Format error in XML file, missing \"<\", file: " + stringPartFromFileLines.getInputfile());
                }
                stringPartFromFileLines.setLengthMax();
            } else {
                stringPartFromFileLines.lenBacktoNoWhiteSpaces();
            }
            StringPart.Part part = stringPartFromFileLines.getCurrentPart();
            stringPartFromFileLines.fromEnd();
            if (stringBuilder != null && stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            if (stringBuilder != null) {
                stringBuilder.append(part);
            }
            bl2 = stringPartFromFileLines.readnextContentFromFile(this.sizeBuffer / 2);
        } while (bl);
        if (stringBuilder != null) {
            while ((n = stringBuilder.indexOf("&", n + 1)) >= 0) {
                if (StringFunctions.startsWith(stringBuilder, n + 1, n + 4, "lt;")) {
                    stringBuilder.replace(n, n + 4, "<");
                    continue;
                }
                if (StringFunctions.startsWith(stringBuilder, n + 1, n + 4, "gt;")) {
                    stringBuilder.replace(n, n + 4, ">");
                    continue;
                }
                if (StringFunctions.startsWith(stringBuilder, n + 1, n + 4, "amp;")) {
                    stringBuilder.replace(n, n + 4, "&");
                    continue;
                }
                if (!StringFunctions.startsWith(stringBuilder, n + 1, n + 4, "auml;")) continue;
                stringBuilder.replace(n, n + 4, "\u00e4");
            }
        }
    }

    private void storeContent(StringBuilder stringBuilder, XmlCfg.XmlCfgNode xmlCfgNode, Object object, Map<String, String>[] mapArray) {
        DataAccess.DatapathElement datapathElement = xmlCfgNode.contentStorePath;
        if (datapathElement != null) {
            try {
                int n = datapathElement.nrArgNames();
                if (datapathElement.isOperation()) {
                    Object[] objectArray = new Object[n];
                    for (int i = 0; i < n; ++i) {
                        String string = datapathElement.argName(i);
                        if (mapArray[0] != null && (objectArray[i] = mapArray[0].get(string)) != null) continue;
                        if (string.equals("text")) {
                            objectArray[i] = stringBuilder;
                            continue;
                        }
                        throw new IllegalArgumentException("argname");
                    }
                    DataAccess.invokeMethod(datapathElement, null, object, true, false, objectArray);
                } else {
                    DataAccess.storeValue(datapathElement, object, (Object)stringBuilder, true);
                }
            }
            catch (Exception exception) {
                System.err.println("error storeContent: " + exception.getMessage());
            }
        }
    }

    public XmlCfg readCfg(File file) {
        this.readXml(file, (Object)this.cfg.rootNode, this.cfgCfg);
        this.cfg.finishReadCfg(this.namespaces);
        return this.cfg;
    }

    public XmlCfg readCfgFromJar(Class<?> clazz, String string) throws IOException {
        String string2 = "jar:" + string;
        InputStream inputStream = clazz.getResourceAsStream(string);
        if (inputStream == null) {
            throw new FileNotFoundException(string2);
        }
        this.readXml(inputStream, string2, this.cfg.rootNode, this.cfgCfg);
        inputStream.close();
        this.cfg.finishReadCfg(this.namespaces);
        return this.cfg;
    }

    public String readXml(File file, Object object) {
        return this.readXml(file, object, this.cfg);
    }

    static class AttribToStore {
        final DataAccess.DatapathElement daccess;
        final String name;
        final String value;

        AttribToStore(DataAccess.DatapathElement datapathElement, String string, String string2) {
            this.daccess = datapathElement;
            this.name = string;
            this.value = string2;
        }
    }
}

