/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.xmlReader;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import org.vishia.util.Assert;
import org.vishia.util.Debugutil;
import org.vishia.util.IndexMultiTable;
import org.vishia.util.StringFunctions_B;
import org.vishia.xmlReader.XmlCfg;
import org.vishia.xmlReader.XmlJzReader;
import org.vishia.xmlSimple.SimpleXmlOutputter;
import org.vishia.xmlSimple.XmlException;
import org.vishia.xmlSimple.XmlNode;
import org.vishia.xmlSimple.XmlNodeSimple;

public class XmlJzCfgAnalyzer {
    public static final String version = "2018-08-15";
    int debugStopLineXmlInp = -1;
    final XmlStructureData xmlStructData = new XmlStructureData();
    XmlStructureNode xmlStructTree = new XmlStructureNode(null, "root", this.xmlStructData);

    public void setDebugStop(int n) {
        this.debugStopLineXmlInp = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCfgTemplate(File file) {
        OutputStreamWriter outputStreamWriter = null;
        try {
            XmlNodeSimple xmlNodeSimple = new XmlNodeSimple("xmlinput:root");
            xmlNodeSimple.addNamespaceDeclaration("xmlinput", "www.vishia.org/XmlReader-xmlinput");
            for (XmlStructureNode object2 : this.xmlStructData.cfgSubtreeList) {
                Object object;
                Object object3;
                assert (object2.sSubtreenode != null);
                XmlNode xmlNode = xmlNodeSimple.addNewNode("subtree", "xmlinput");
                if (object2.sSubtreenode.equals("ObjectList_A")) {
                    Debugutil.stop();
                }
                xmlNode.setAttribute("name", "xmlinput", object2.sSubtreenode);
                xmlNode.setAttribute("class", "xmlinput", object2.sSubtreenode);
                if (object2.attribs != null) {
                    for (Map.Entry<String, String> entry : object2.attribs.entrySet()) {
                        object3 = entry.getKey();
                        object = entry.getValue();
                        xmlNode.setAttribute((String)object3, (String)object);
                    }
                }
                this.wrSetAddContentAttrib(object2, xmlNode);
                if (object2.nodes == null) continue;
                for (Map.Entry<String, Object> entry : object2.nodes.entrySet()) {
                    object3 = (XmlStructureNode)entry.getValue();
                    object = new XmlNodeSimple(((XmlStructureNode)object3).tag);
                    xmlNode.addContent((XmlNode)object);
                    this.addWrNode((XmlNode)object, (XmlStructureNode)object3, 999);
                }
            }
            XmlNode xmlNode = xmlNodeSimple.addNewNode("cfg", "xmlinput");
            this.addWrNode(xmlNode, this.xmlStructTree, 999);
            SimpleXmlOutputter simpleXmlOutputter = new SimpleXmlOutputter();
            outputStreamWriter = new FileWriter(file);
            simpleXmlOutputter.write(outputStreamWriter, xmlNodeSimple);
            outputStreamWriter.close();
        }
        catch (IOException | XmlException exception) {
            CharSequence charSequence = Assert.exceptionInfo("unexpected", exception, 0, 100);
            System.err.append(charSequence);
        }
        finally {
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {
                    System.err.append("cannot close" + file.getAbsolutePath());
                }
            }
        }
        Debugutil.stop();
    }

    private void wrSetAddContentAttrib(XmlStructureNode xmlStructureNode, XmlNode xmlNode) throws XmlException {
        CharSequence charSequence;
        if (xmlStructureNode.attribs != null) {
            StringBuilder stringBuilder = new StringBuilder(100);
            charSequence = stringBuilder;
            int n = 40;
            for (Map.Entry<String, String> entry : xmlStructureNode.attribs.entrySet()) {
                String string = entry.getKey();
                String string2 = entry.getValue();
                xmlNode.setAttribute(string, string2);
                if (!string2.startsWith("!@")) continue;
                stringBuilder.append((char)n).append(string2.substring(2));
                n = 44;
            }
            stringBuilder.append(')');
        } else {
            charSequence = "()";
        }
        if (xmlStructureNode.onlySingle) {
            xmlNode.setAttribute("data", "xmlinput", "!set_" + xmlStructureNode.tagIdent + charSequence);
        } else {
            xmlNode.setAttribute("data", "xmlinput", "!add_" + xmlStructureNode.tagIdent + charSequence);
        }
    }

    private void addWrNode(XmlNode xmlNode, XmlStructureNode xmlStructureNode, int n) throws XmlException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (xmlStructureNode.nodes != null || xmlStructureNode.attribs != null) {
            this.wrSetAddContentAttrib(xmlStructureNode, xmlNode);
            if (xmlStructureNode.sSubtreenode != null) {
                String string = xmlStructureNode.sSubtreenode;
                xmlNode.setAttribute("subtree", "xmlinput", string);
            } else {
                if (xmlStructureNode.nodes != null || xmlStructureNode.attribs != null && (xmlStructureNode.bText || xmlStructureNode.attribs.size() > 1)) {
                    xmlNode.setAttribute("class", "xmlinput", xmlStructureNode.tagIdent);
                }
                if (xmlStructureNode.nodes != null) {
                    for (Map.Entry<String, XmlStructureNode> entry : xmlStructureNode.nodes.entrySet()) {
                        XmlStructureNode xmlStructureNode2 = entry.getValue();
                        String string = entry.getKey();
                        XmlNodeSimple xmlNodeSimple = new XmlNodeSimple(string);
                        xmlNode.addContent(xmlNodeSimple);
                        this.addWrNode(xmlNodeSimple, xmlStructureNode2, n - 1);
                    }
                }
            }
            if (xmlStructureNode.bText) {
                xmlNode.addContent("!set_text(text)");
            }
        } else if (xmlStructureNode.onlySingle) {
            xmlNode.addContent("!set_" + xmlStructureNode.tag + "(text)");
        } else {
            xmlNode.addContent("!add_" + xmlStructureNode.tag + "(text)");
        }
    }

    public void readXmlStruct(File file) {
        XmlJzReader xmlJzReader = new XmlJzReader();
        if (this.debugStopLineXmlInp > 0) {
            xmlJzReader.setDebugStop(this.debugStopLineXmlInp);
        }
        xmlJzReader.readXml(file, (Object)this.xmlStructTree, XmlJzCfgAnalyzer.newCfgReadStruct());
        this.xmlStructData.checkCfgSubtree();
        Debugutil.stop();
    }

    public static XmlCfg newCfgReadStruct() {
        XmlCfg xmlCfg = new XmlCfg();
        xmlCfg.rootNode = new XmlCfg.XmlCfgNode(null, xmlCfg, null);
        XmlCfg.XmlCfgNode xmlCfgNode = new XmlCfg.XmlCfgNode(null, xmlCfg, "?");
        xmlCfg.rootNode.addSubnode(xmlCfgNode.tag.toString(), xmlCfgNode);
        xmlCfgNode.addSubnode(xmlCfgNode.tag.toString(), xmlCfgNode);
        xmlCfgNode.setNewElementPath("!addElement(tag)");
        xmlCfgNode.addAttribStorePath("?", "!setAttribute(name)");
        xmlCfgNode.setContentStorePath("!setTextOccurrence()");
        return xmlCfg;
    }

    public static void main(String[] stringArray) {
        XmlJzCfgAnalyzer xmlJzCfgAnalyzer = new XmlJzCfgAnalyzer();
        xmlJzCfgAnalyzer.readXmlStruct(new File(stringArray[0]));
        xmlJzCfgAnalyzer.writeCfgTemplate(new File(stringArray[1]));
    }

    static class XmlStructureNode {
        final String tag;
        final String tagIdent;
        String sSubtreenode;
        boolean bText = false;
        boolean XXXbDetermineWithParent = false;
        boolean bDependencyChecked;
        boolean onlySingle = true;
        final XmlStructureNode parent;
        Map<String, XmlStructureNode> nodes;
        Map<String, String> nodesLocal;
        Map<String, String> attribs;
        int nrofAttributes = 0;
        boolean bNewAttributes = false;
        final XmlStructureData xmlStructData;

        XmlStructureNode(XmlStructureNode xmlStructureNode, String string, XmlStructureData xmlStructureData) {
            this.parent = xmlStructureNode;
            this.tag = string;
            this.tagIdent = StringFunctions_B.replaceNonIdentifierChars(string, 'A').toString();
            this.xmlStructData = xmlStructureData;
        }

        public XmlStructureNode addElement(String string) {
            XmlStructureNode xmlStructureNode;
            if (string.contains("   ")) {
                Debugutil.stop();
            }
            if (string.equals("Document")) {
                Debugutil.stop();
            }
            if (this.nodes == null) {
                this.nodes = new IndexMultiTable<String, XmlStructureNode>(IndexMultiTable.providerString);
            }
            if (this.nodesLocal == null) {
                this.nodesLocal = new TreeMap<String, String>();
            }
            if (string.equals("Culture")) {
                Debugutil.stop();
            }
            if ((xmlStructureNode = this.nodes.get(string)) == null) {
                xmlStructureNode = new XmlStructureNode(this, string, this.xmlStructData);
                this.nodes.put(string, xmlStructureNode);
                this.xmlStructData.addStructureNodeOccurence(xmlStructureNode);
            }
            if (this.nodesLocal.get(string) != null) {
                xmlStructureNode.onlySingle = false;
            }
            this.nodesLocal.put(string, string);
            xmlStructureNode.nodesLocal = null;
            return xmlStructureNode;
        }

        public void setAttribute(String string) {
            if (this.attribs == null) {
                this.attribs = new TreeMap<String, String>();
                this.bNewAttributes = true;
                this.attribs.put(string, "!@" + string);
            } else if (this.attribs.get(string) == null) {
                this.bNewAttributes = true;
                this.attribs.put(string, "!@" + string);
            }
        }

        public void setTextOccurrence() {
            this.bText = true;
        }

        public String toString() {
            return this.tag + (this.attribs != null ? " attr:" + this.attribs.toString() : "") + (this.nodes != null ? " nodes:" + this.nodes.toString() : "");
        }
    }

    static class XmlStructureData {
        IndexMultiTable<String, CfgSubtreeType> allElementTypes = new IndexMultiTable(IndexMultiTable.providerString);
        IndexMultiTable<String, CfgSubtreeType2> allElementTypes2 = new IndexMultiTable(IndexMultiTable.providerString);
        Map<String, XmlStructureNode> cfgSubtreeByName = new IndexMultiTable<String, XmlStructureNode>(IndexMultiTable.providerString);
        List<XmlStructureNode> cfgSubtreeList = new ArrayList<XmlStructureNode>();

        XmlStructureData() {
        }

        private void createCfgSubtree(XmlStructureNode xmlStructureNode, char c) {
            CfgSubtreeType2 cfgSubtreeType2 = new CfgSubtreeType2(xmlStructureNode);
            xmlStructureNode.sSubtreenode = c < 'A' ? xmlStructureNode.tag : xmlStructureNode.tag + '_' + c;
            if (xmlStructureNode.attribs != null) {
                for (Map.Entry<String, Object> entry : xmlStructureNode.attribs.entrySet()) {
                    cfgSubtreeType2.attributeNames.put(entry.getKey(), entry.getKey());
                }
            }
            if (xmlStructureNode.nodes != null) {
                for (Map.Entry<String, Object> entry : xmlStructureNode.nodes.entrySet()) {
                    cfgSubtreeType2.nodeNames.put(entry.getKey(), entry.getKey());
                }
            }
            this.allElementTypes2.add(xmlStructureNode.tag, cfgSubtreeType2);
            this.cfgSubtreeByName.put(xmlStructureNode.sSubtreenode, xmlStructureNode);
        }

        void addStructureNodeOccurence(XmlStructureNode xmlStructureNode) {
            CfgSubtreeType cfgSubtreeType = this.allElementTypes.get(xmlStructureNode.tag);
            if (cfgSubtreeType == null) {
                cfgSubtreeType = new CfgSubtreeType();
                this.allElementTypes.put(xmlStructureNode.tag, cfgSubtreeType);
            }
            cfgSubtreeType.occurrence.add(xmlStructureNode);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void checkStructureNodeOccurence(XmlStructureNode xmlStructureNode) {
            CfgSubtreeType2 cfgSubtreeType2;
            boolean bl;
            char c;
            ListIterator<CfgSubtreeType2> listIterator;
            block19: {
                block18: {
                    if (xmlStructureNode.nodes == null && xmlStructureNode.attribs == null) {
                        return;
                    }
                    listIterator = this.allElementTypes2.iterator(xmlStructureNode.tag);
                    c = '@';
                    bl = false;
                    if (xmlStructureNode.tag.equals("AttributeList")) {
                        Debugutil.stop();
                    }
                    if (!listIterator.hasNext()) break block18;
                    cfgSubtreeType2 = (CfgSubtreeType2)listIterator.next();
                    if (cfgSubtreeType2.tag.equals(xmlStructureNode.tag)) break block19;
                }
                this.createCfgSubtree(xmlStructureNode, '\u0000');
                return;
            }
            do {
                String string;
                c = (char)(c + 1);
                int n = 0;
                int n2 = 0;
                if (xmlStructureNode.attribs != null) {
                    for (Map.Entry entry : xmlStructureNode.attribs.entrySet()) {
                        String string2 = (String)entry.getKey();
                        if (cfgSubtreeType2.attributeNames.get(string2) != null) {
                            ++n;
                        }
                        ++n2;
                    }
                }
                TreeMap treeMap = new TreeMap();
                if (xmlStructureNode.nodes != null) {
                    for (Map.Entry<String, XmlStructureNode> entry : xmlStructureNode.nodes.entrySet()) {
                        string = entry.getKey();
                        if (treeMap.get(string) == null) {
                            treeMap.put(string, string);
                            if (cfgSubtreeType2.nodeNames.get(entry.getKey()) != null) {
                                ++n;
                            }
                            ++n2;
                            continue;
                        }
                        assert (false);
                    }
                }
                if (n >= (n2 + 3) / 4) {
                    bl = true;
                    cfgSubtreeType2.occurrence.add(xmlStructureNode);
                    xmlStructureNode.sSubtreenode = cfgSubtreeType2.representative.sSubtreenode;
                    assert (xmlStructureNode.sSubtreenode != null);
                    if (xmlStructureNode.attribs != null) {
                        for (Map.Entry<String, String> entry : xmlStructureNode.attribs.entrySet()) {
                            string = entry.getKey();
                            if (cfgSubtreeType2.attributeNames.get(string) != null) continue;
                            cfgSubtreeType2.attributeNames.put(string, string);
                            cfgSubtreeType2.representative.attribs.put(string, entry.getValue());
                        }
                    }
                    if (xmlStructureNode.nodes == null) break;
                    for (Map.Entry<String, XmlStructureNode> entry : xmlStructureNode.nodes.entrySet()) {
                        string = entry.getKey();
                        treeMap.put(string, string);
                        if (cfgSubtreeType2.nodeNames.get(entry.getKey()) != null) continue;
                        cfgSubtreeType2.nodeNames.put(string, string);
                        cfgSubtreeType2.representative.nodes.put(string, entry.getValue());
                    }
                    break;
                }
                if (bl || !listIterator.hasNext()) break;
                cfgSubtreeType2 = (CfgSubtreeType2)listIterator.next();
            } while (cfgSubtreeType2.tag.equals(xmlStructureNode.tag));
            if (bl) return;
            this.createCfgSubtree(xmlStructureNode, c);
        }

        private void checkCfgSubtree() {
            Object object;
            for (Map.Entry<String, CfgSubtreeType> entry : this.allElementTypes.entrySet()) {
                object = entry.getValue();
                if (((CfgSubtreeType)object).occurrence.size() <= 1) continue;
                for (XmlStructureNode xmlStructureNode : ((CfgSubtreeType)object).occurrence) {
                    this.checkStructureNodeOccurence(xmlStructureNode);
                }
            }
            for (Map.Entry<String, Object> entry : this.allElementTypes2.entrySet()) {
                object = (CfgSubtreeType2)entry.getValue();
                XmlStructureNode xmlStructureNode = ((CfgSubtreeType2)entry.getValue()).representative;
                if (xmlStructureNode.bDependencyChecked) continue;
                xmlStructureNode.bDependencyChecked = true;
                this.checkUsageSubtreenode((CfgSubtreeType2)object, xmlStructureNode, 99);
            }
            for (Map.Entry<String, Object> entry : this.allElementTypes2.entrySet()) {
                object = (CfgSubtreeType2)entry.getValue();
                this.processDependingCfgSubtree((CfgSubtreeType2)object, 99);
            }
        }

        private void processDependingCfgSubtree(CfgSubtreeType2 cfgSubtreeType2, int n) {
            if (n < 50) {
                Debugutil.stop();
            }
            assert (n >= 0);
            if (!cfgSubtreeType2.bSort) {
                if (cfgSubtreeType2.dependings.size() == 0) {
                    this.cfgSubtreeList.add(cfgSubtreeType2.representative);
                    cfgSubtreeType2.bSort = true;
                } else {
                    cfgSubtreeType2.bSort = true;
                    for (CfgSubtreeType2 cfgSubtreeType22 : cfgSubtreeType2.dependings) {
                        this.processDependingCfgSubtree(cfgSubtreeType22, n - 1);
                    }
                    this.cfgSubtreeList.add(cfgSubtreeType2.representative);
                }
            }
        }

        private void checkUsageSubtreenode(CfgSubtreeType2 cfgSubtreeType2, XmlStructureNode xmlStructureNode, int n) {
            assert (n >= 0);
            if (xmlStructureNode.nodes != null) {
                block0: for (Map.Entry<String, XmlStructureNode> entry : xmlStructureNode.nodes.entrySet()) {
                    XmlStructureNode xmlStructureNode2 = entry.getValue();
                    if (xmlStructureNode2.sSubtreenode != null) {
                        if (xmlStructureNode2.bDependencyChecked) continue;
                        xmlStructureNode2.bDependencyChecked = true;
                        ListIterator<CfgSubtreeType2> listIterator = this.allElementTypes2.iterator(xmlStructureNode2.tag);
                        while (listIterator.hasNext()) {
                            CfgSubtreeType2 cfgSubtreeType22 = (CfgSubtreeType2)listIterator.next();
                            if (!cfgSubtreeType22.tag.equals(xmlStructureNode2.tag)) continue block0;
                            if (!cfgSubtreeType22.representative.sSubtreenode.equals(xmlStructureNode2.sSubtreenode)) continue;
                            cfgSubtreeType2.dependings.add(cfgSubtreeType22);
                            this.checkUsageSubtreenode(cfgSubtreeType22, cfgSubtreeType22.representative, n - 1);
                            continue block0;
                        }
                        continue;
                    }
                    this.checkUsageSubtreenode(cfgSubtreeType2, xmlStructureNode2, n - 1);
                }
            }
        }

        static class CfgSubtreeType2 {
            final String tag;
            List<XmlStructureNode> occurrence = new ArrayList<XmlStructureNode>();
            XmlStructureNode representative;
            List<CfgSubtreeType2> dependings = new ArrayList<CfgSubtreeType2>();
            boolean bSort;
            Map<String, String> attributeNames = new TreeMap<String, String>();
            Map<String, String> nodeNames = new TreeMap<String, String>();

            public CfgSubtreeType2(XmlStructureNode xmlStructureNode) {
                this.tag = xmlStructureNode.tag;
                this.representative = xmlStructureNode;
                this.occurrence.add(xmlStructureNode);
            }

            public String toString() {
                return "" + this.occurrence.size() + " * " + this.occurrence.get(0).toString();
            }
        }

        static class CfgSubtreeType {
            List<XmlStructureNode> occurrence = new ArrayList<XmlStructureNode>();

            public String toString() {
                return "" + this.occurrence.size() + " * " + this.occurrence.get(0).toString();
            }
        }
    }
}

