/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.vishia.mainCmd.MainCmd;
import org.vishia.util.FileSystem;

public class Zip {
    public static final int version = 20130120;
    private final List<Src> listSrc = new LinkedList<Src>();
    private Manifest manifest;

    public void addSource(String string) {
        this.listSrc.add(new Src(string, null));
    }

    public void addSource(File file, String string) {
        this.listSrc.add(new Src(string, file));
    }

    public void setManifest(File file) throws IOException {
        this.manifest = new Manifest();
        FileInputStream fileInputStream = new FileInputStream(file);
        this.manifest.read(fileInputStream);
        Attributes attributes = this.manifest.getMainAttributes();
        String string = attributes.getValue(Attributes.Name.MANIFEST_VERSION);
        if (string == null) {
            attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exec(File file, int n, String string) throws IOException {
        StringBuilder stringBuilder = null;
        byte[] byArray = new byte[16384];
        ZipOutputStream zipOutputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            zipOutputStream = this.manifest != null ? new JarOutputStream((OutputStream)fileOutputStream, this.manifest) : new ZipOutputStream(fileOutputStream);
            zipOutputStream.setLevel(n);
            for (Src src : this.listSrc) {
                ArrayList<FileSystem.FileAndBasePath> arrayList = new ArrayList<FileSystem.FileAndBasePath>();
                FileSystem.addFilesWithBasePath(src.dir, src.path, arrayList);
                for (FileSystem.FileAndBasePath fileAndBasePath : arrayList) {
                    if (!fileAndBasePath.file.isFile()) continue;
                    ZipEntry zipEntry = null;
                    InputStream inputStream = null;
                    String string2 = fileAndBasePath.localPath;
                    if (string2.startsWith("/")) {
                        string2 = string2.substring(1);
                    }
                    try {
                        int n2;
                        zipEntry = this.manifest != null ? new JarEntry(string2) : new ZipEntry(string2);
                        zipEntry.setTime(fileAndBasePath.file.lastModified());
                        zipOutputStream.putNextEntry(zipEntry);
                        inputStream = new FileInputStream(fileAndBasePath.file);
                        while ((n2 = inputStream.read(byArray)) > 0) {
                            zipOutputStream.write(byArray, 0, n2);
                        }
                    }
                    catch (IOException iOException) {
                        if (stringBuilder == null) {
                            stringBuilder = new StringBuilder();
                        }
                        stringBuilder.append(iOException.getMessage()).append("\n");
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (zipEntry == null) continue;
                        zipOutputStream.closeEntry();
                    }
                }
            }
            zipOutputStream.close();
        }
        finally {
            try {
                if (zipOutputStream != null) {
                    zipOutputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException("Archiver.createJar - unexpected IOException");
            }
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException("Archiver.createJar - unexpected IOException");
            }
        }
        this.listSrc.clear();
        if (stringBuilder == null) {
            return null;
        }
        return stringBuilder.toString();
    }

    public String exec(Args args) throws IOException {
        this.listSrc.addAll(args.listSrc);
        return this.exec(args.fOut, args.compress, args.comment);
    }

    public static String zipfiles(File file, File file2, String string, int n, String string2) throws IOException {
        Zip zip = new Zip();
        zip.addSource(string);
        return zip.exec(file, n, string2);
    }

    public static void main(String[] stringArray) {
        Args args = new Args();
        Cmdline cmdline = new Cmdline(args);
        try {
            cmdline.parseArguments(stringArray);
        }
        catch (ParseException parseException) {
            cmdline.setExitErrorLevel(5);
            cmdline.exit();
        }
        Zip zip = new Zip();
        try {
            zip.exec(args);
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
    }

    static class Cmdline
    extends MainCmd {
        final Args args;
        MainCmd.SetArgument setCompress = new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                char c;
                if (string.length() == 1 && (c = string.charAt(0)) >= '0' && c <= '9') {
                    args.compress = c - 48;
                    return true;
                }
                return false;
            }
        };
        MainCmd.SetArgument setInput = new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                args.listSrc.add(new Src(string, null));
                return true;
            }
        };
        MainCmd.SetArgument setOutput = new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                args.fOut = new File(string);
                return true;
            }
        };
        MainCmd.Argument[] argList = new MainCmd.Argument[]{new MainCmd.Argument("-compress", ":0..9 set the compression rate 0=non .. 90max", this.setCompress), new MainCmd.Argument("-o", ":ZIP.zip file for zip output", this.setOutput), new MainCmd.Argument("", "INPUT file possible with wildcards also in path like \"path/** /dir* /name*.ext*\"", this.setInput)};

        @Override
        protected boolean checkArguments() {
            return this.args.fOut != null;
        }

        Cmdline(Args args) {
            this.args = args;
            super.addAboutInfo("Zip routine from Java");
            super.addAboutInfo("made by HSchorrig, 2013-02-09 - 2014-06-15");
            super.addHelpInfo("args: -compress:# -o:ZIP.zip { INPUT}");
            super.addArgument(this.argList);
            super.addStandardHelpInfo();
        }
    }

    public static class Args {
        public final List<Src> listSrc = new ArrayList<Src>();
        public int compress = 5;
        public File fOut;
        public String comment = "";
    }

    static class Src {
        String path;
        File dir;

        Src(String string, File file) {
            this.path = string;
            this.dir = file;
        }
    }
}

