/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.util;

import org.vishia.util.PathCheck;
import org.vishia.util.SortedTreeWalkerCallback;

public class TreeWalkerPathCheck
implements SortedTreeWalkerCallback<String> {
    public static final String sVersion = "2015-05-25";
    final PathCheck check;
    private CurrDirChildren curr;

    public TreeWalkerPathCheck(String string) {
        this.check = new PathCheck(string);
    }

    @Override
    public void start(String string) {
    }

    @Override
    public SortedTreeWalkerCallback.Result offerParentNode(String string) {
        PathCheck pathCheck = this.curr != null ? this.curr.pathCheck : this.check;
        PathCheck pathCheck2 = pathCheck.check(string, true);
        if (pathCheck2 == null) {
            return SortedTreeWalkerCallback.Result.skipSubtree;
        }
        this.curr = new CurrDirChildren(string, pathCheck2, this.curr);
        return SortedTreeWalkerCallback.Result.cont;
    }

    @Override
    public SortedTreeWalkerCallback.Result finishedParentNode(String string, SortedTreeWalkerCallback.Counters counters) {
        this.curr = this.curr.parent;
        return SortedTreeWalkerCallback.Result.cont;
    }

    @Override
    public SortedTreeWalkerCallback.Result offerLeafNode(String string, Object object) {
        PathCheck pathCheck;
        assert (this.curr != null);
        PathCheck pathCheck2 = this.curr.pathCheck;
        PathCheck pathCheck3 = pathCheck = pathCheck2.next != null ? null : pathCheck2.check(string, false);
        if (pathCheck == null) {
            return SortedTreeWalkerCallback.Result.skipSubtree;
        }
        return SortedTreeWalkerCallback.Result.cont;
    }

    @Override
    public void finished(String string, SortedTreeWalkerCallback.Counters counters) {
    }

    @Override
    public boolean shouldAborted() {
        return false;
    }

    private class CurrDirChildren {
        String dir;
        final Counters cnt = new Counters();
        int levelProcessMarked;
        PathCheck pathCheck;
        CurrDirChildren parent;

        CurrDirChildren(String string, PathCheck pathCheck, CurrDirChildren currDirChildren) {
            this.dir = string;
            this.parent = currDirChildren;
            this.pathCheck = pathCheck;
            this.levelProcessMarked = currDirChildren == null ? 0 : currDirChildren.levelProcessMarked - 1;
        }

        public String toString() {
            return this.dir + ": " + this.pathCheck;
        }
    }

    public static class Counters {
        public long nrofBytes;
        public int nrofParents;
        public int nrofLeafss;
        public int nrofParentSelected;
        public int nrofLeafSelected;

        public void clear() {
            this.nrofBytes = 0L;
            this.nrofLeafSelected = 0;
            this.nrofParentSelected = 0;
            this.nrofLeafss = 0;
            this.nrofParents = 0;
        }
    }
}

