/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import org.vishia.util.Debugutil;
import org.vishia.util.FileSystem;
import org.vishia.util.IntegerBlockArray;
import org.vishia.util.StringFunctions;
import org.vishia.util.StringPartScan;

public class StringPartFromFileLines
extends StringPartScan {
    public static final String version = "2016-09-25";
    final char[] cBuffer;
    int zBuffer;
    final Charset charset;
    private char cExpectedSesoncNl;
    int nLineCt = 0;
    boolean bEof;
    boolean bLesserReadAsExpected;
    Reader inpr;
    int nrFirstLineInPositions;
    IntegerBlockArray linePositions = new IntegerBlockArray(1000);
    int endIxLinePosition;
    String sNewline = "\n";

    public StringPartFromFileLines(File file) throws FileNotFoundException, IOException, IllegalCharsetNameException, UnsupportedCharsetException {
        this(file, 0, null, null);
    }

    public StringPartFromFileLines(File file, int n, String string, Charset charset) throws FileNotFoundException, IOException, IllegalCharsetNameException, UnsupportedCharsetException {
        this(new FileInputStream(file), FileSystem.normalizePath(file).toString(), n <= 0 || file.length() < (long)(n + 10) ? (int)file.length() + 1 : n, string, charset);
        if (this.bLesserReadAsExpected) {
            this.inpr.close();
            this.inpr = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public StringPartFromFileLines(InputStream inputStream, String string, int n, String string2, Charset charset) throws IOException, IllegalCharsetNameException, UnsupportedCharsetException {
        int n2;
        String string3;
        this.setInputfile(string);
        this.bEof = false;
        this.cBuffer = new char[n];
        byte[] byArray = new byte[207];
        this.linePositions.set(++this.endIxLinePosition, 0);
        boolean bl = false;
        int n3 = inputStream.read(byArray, 0, byArray.length - 7);
        int n4 = 0;
        if (byArray[0] == -1 && byArray[1] == -2) {
            bl = true;
            n4 = 2;
        } else if (byArray[0] == -2 && byArray[1] == -1) {
            bl = true;
            n4 = 2;
        }
        if (string2 != null) {
            string3 = new String(byArray, n4, n3);
            n2 = string3.indexOf(10);
            if (n2 >= 0 && n2 < n3) {
                n2 = string3.indexOf(10, n2 + 1);
            }
            if (n2 < 0) {
                n2 = n3;
            }
            StringPartScan stringPartScan = new StringPartScan(string3.substring(0, n2));
            stringPartScan.setIgnoreWhitespaces(true);
            if (stringPartScan.seek(string2, 1).found() && stringPartScan.scan("=").scanOk()) {
                String string4;
                stringPartScan.seekNoWhitespace();
                if (stringPartScan.getCurrentChar() == '\"') {
                    string4 = stringPartScan.seek(1).lentoQuotionEnd('\"', 100).getCurrentPart().toString();
                    if (string4.length() > 0) {
                        string4 = string4.substring(0, string4.length() - 1);
                    }
                } else {
                    string4 = stringPartScan.lentoIdentifier(null, "-").getCurrentPart().toString();
                }
                if (string4.length() <= 0) {
                    stringPartScan.close();
                    throw new IllegalArgumentException("charset requested with \"" + string2 + "\", this String was found but the encoding name found in file is faulty");
                }
                this.charset = Charset.forName(string4);
            } else {
                this.charset = charset == null ? Charset.defaultCharset() : charset;
            }
            stringPartScan.close();
        } else {
            this.charset = charset == null ? Charset.defaultCharset() : charset;
        }
        this.inpr = new InputStreamReader(inputStream, this.charset);
        if (this.charset.equals(Charset.forName("UTF-8"))) {
            int n5 = n3 - 1;
            while ((byArray[n5] & 0xC0) == 128) {
                --n5;
            }
            n2 = StringFunctions.nrofBytesUTF8(byArray[n5]);
            int n6 = n5 + n2 - n3;
            if (n6 > 0) {
                int n7 = inputStream.read(byArray, n3, n6);
                if (n7 != n6) {
                    Debugutil.stop();
                }
                n3 += n7;
            }
        }
        string3 = new String(byArray, n4, n3 - n4, this.charset);
        this.zBuffer = string3.length();
        n2 = 0;
        while (true) {
            if (n2 >= this.zBuffer) {
                this.evalLineIndices(0, this.zBuffer);
                this.readnextContentFromFile(0);
                this.assign(new CharSq(0, -1));
                return;
            }
            this.cBuffer[n2] = string3.charAt(n2);
            ++n2;
        }
    }

    @Override
    public int getLineAndColumn(int[] nArray) {
        int n = this.linePositions.binarySearch(this.begin, this.endIxLinePosition);
        if (n < 0) {
            n = -n - 2;
        }
        if (nArray != null) {
            int n2 = this.linePositions.get(n);
            nArray[0] = this.begin - n2 + 1;
        }
        return n + this.nrFirstLineInPositions;
    }

    private void evalLineIndices(int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            char c = this.cBuffer[n3++];
            if (this.cExpectedSesoncNl != '\u0000') {
                if (c == this.cExpectedSesoncNl) {
                    this.linePositions.set(++this.endIxLinePosition, n3);
                    c = '\u0000';
                } else {
                    this.linePositions.set(++this.endIxLinePosition, n3 - 1);
                }
                this.cExpectedSesoncNl = '\u0000';
            }
            if (c == '\r') {
                this.cExpectedSesoncNl = (char)10;
                continue;
            }
            if (c != '\n') continue;
            this.cExpectedSesoncNl = (char)13;
        }
    }

    public boolean readnextContentFromFile(int n) throws IOException {
        int n2;
        int n3;
        boolean bl = false;
        if (this.begin >= n && this.begin >= this.cBuffer.length / 8) {
            int n4;
            n3 = this.begin / 2;
            n2 = this.zBuffer - n3;
            for (n4 = 0; n4 < n2; ++n4) {
                this.cBuffer[n4] = this.cBuffer[n4 + n3];
            }
            this.begin -= n3;
            this.begiMin -= n3;
            this.beginLast -= n3;
            this.beginScan -= n3;
            this.end -= n3;
            this.endLast -= n3;
            this.endMax -= n3;
            this.absPos0 += n3;
            this.zBuffer -= n3;
            n4 = 0;
            for (int i = 0; i < this.endIxLinePosition; ++i) {
                int n5 = this.linePositions.get(i);
                if (n5 < n3) {
                    ++this.nrFirstLineInPositions;
                    continue;
                }
                this.linePositions.set(n4++, n5 -= n3);
            }
            this.endIxLinePosition = n4;
        }
        if (this.bEof) {
            return true;
        }
        n3 = this.cBuffer.length - this.zBuffer;
        if (n3 >= n) {
            n2 = this.inpr.read(this.cBuffer, this.zBuffer, n3);
            if (n2 > 0) {
                this.evalLineIndices(this.zBuffer, this.zBuffer + n2);
                this.zBuffer += n2;
                this.endMax = this.endLast = this.zBuffer;
                this.end = this.endLast;
                boolean bl2 = this.bLesserReadAsExpected = n2 < n3;
                if (this.bLesserReadAsExpected) {
                    Debugutil.stop();
                }
            } else {
                this.bLesserReadAsExpected = true;
                this.bEof = n2 < 0;
            }
            return this.bLesserReadAsExpected;
        }
        return false;
    }

    @Override
    public void close() {
        if (this.inpr != null) {
            try {
                this.inpr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.inpr = null;
        }
        this.nLineCt = 0;
        super.close();
    }

    private class CharSq
    implements CharSequence {
        int pos0;
        int end;

        CharSq(int n, int n2) {
            this.pos0 = n;
            this.end = n2;
        }

        @Override
        public int length() {
            return this.end == -1 ? StringPartFromFileLines.this.zBuffer : this.end - this.pos0;
        }

        @Override
        public char charAt(int n) {
            return StringPartFromFileLines.this.cBuffer[n + this.pos0];
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            return new CharSq(n, n2);
        }

        @Override
        public String toString() {
            String string = new String(StringPartFromFileLines.this.cBuffer, this.pos0, this.length());
            return string;
        }
    }
}

