/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.util;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import org.vishia.util.FileSystem;
import org.vishia.util.StringFunctions;

public class FilepathFilter
implements FilenameFilter {
    public static final String version = "2015-01-03";
    final PathFilter pathFilter;
    final NameFilter nameFilter;
    final List<NameFilter> listNameFilter;
    final List<NameFilter> listExcludeNameFilter;
    final boolean bAllTree;

    public FilepathFilter(CharSequence charSequence) {
        if (charSequence == null || charSequence.length() == 0) {
            this.pathFilter = null;
            this.listNameFilter = null;
            this.listExcludeNameFilter = null;
            this.nameFilter = null;
            this.bAllTree = false;
        } else {
            String string = charSequence.toString();
            int n = string.lastIndexOf(47) + 1;
            if (n == 0) {
                this.bAllTree = false;
                this.pathFilter = null;
            } else {
                this.pathFilter = new PathFilter(string.substring(0, n - 1));
                this.bAllTree = this.pathFilter.bAlltree1;
            }
            if (charSequence.charAt(n) == ':' || StringFunctions.equals(charSequence, n, n + 2, " :")) {
                int n2;
                int n3;
                this.nameFilter = null;
                ArrayList<NameFilter> arrayList = null;
                ArrayList<NameFilter> arrayList2 = null;
                int n4 = n3 = n + charSequence.charAt(n) == 58 ? 1 : 2;
                do {
                    int n5;
                    if (charSequence.charAt(n3) == ' ') {
                        ++n3;
                    }
                    if ((n2 = string.indexOf(58, n3 + 1)) < 0) {
                        n2 = charSequence.length();
                    }
                    int n6 = n5 = charSequence.charAt(n2 - 1) == ' ' ? n2 - 1 : n2;
                    if (charSequence.charAt(n3) == ':') {
                        if (arrayList2 == null) {
                            arrayList2 = new ArrayList<NameFilter>();
                        }
                        arrayList2.add(new NameFilter(string.substring(n3 + 1, n5)));
                        continue;
                    }
                    if (arrayList == null) {
                        arrayList = new ArrayList<NameFilter>();
                    }
                    arrayList.add(new NameFilter(string.substring(n3, n5)));
                } while ((n3 = n2 + 1) < charSequence.length());
                this.listExcludeNameFilter = arrayList2;
                this.listNameFilter = arrayList;
            } else {
                this.listExcludeNameFilter = null;
                this.listNameFilter = null;
                this.nameFilter = new NameFilter(string.substring(n));
            }
        }
    }

    public boolean checkName(String string) {
        if (this.listExcludeNameFilter != null) {
            for (NameFilter nameFilter : this.listExcludeNameFilter) {
                if (!nameFilter.checkName(string)) continue;
                return false;
            }
        }
        if (this.nameFilter != null) {
            return this.nameFilter.checkName(string);
        }
        if (this.listNameFilter == null) {
            return true;
        }
        for (NameFilter nameFilter : this.listNameFilter) {
            if (!nameFilter.checkName(string)) continue;
            return true;
        }
        return false;
    }

    public boolean checkDir(CharSequence charSequence) {
        return this.pathFilter == null ? true : this.pathFilter.checkPath(charSequence);
    }

    @Override
    public boolean accept(File file, String string) {
        CharSequence charSequence = FileSystem.normalizePath(file);
        if (this.bAllTree) {
            return true;
        }
        return this.checkDir(charSequence) && this.checkName(string);
    }

    private static void check(boolean bl) {
        if (!bl) {
            System.out.println("failure");
        }
    }

    public static void test() {
        boolean bl = true;
        FilepathFilter filepathFilter = new FilepathFilter("prod/**/sub*/that/test*.*");
        bl &= filepathFilter.checkDir("prod/a/b/subx1/that");
        FilepathFilter filepathFilter2 = new FilepathFilter("prod/**/test*.*");
        bl &= filepathFilter2.checkDir("prod/a/b");
        FilepathFilter filepathFilter3 = new FilepathFilter(" : save* : :*.bak");
        bl &= filepathFilter3.checkName("save1.txt");
        bl &= !filepathFilter3.checkName("save2.bak");
    }

    static class PathFilter {
        final String sStartPath;
        final String sEndPath;
        final String sContainPath;
        final boolean bAlltree1;
        final boolean bAlltree2;
        final int pos1;
        final int posEndFromEnd;
        final int posContainPath;
        final int posContainPathFromEnd;

        PathFilter(String string) {
            int n = string.length();
            this.pos1 = string.indexOf(42);
            int n2 = string.indexOf(42, this.pos1 + 2);
            if (this.pos1 >= 0) {
                int n3;
                this.bAlltree1 = n > this.pos1 + 1 && string.charAt(this.pos1 + 1) == '*';
                this.sStartPath = this.pos1 > 0 ? string.substring(0, this.pos1) : null;
                boolean bl = this.bAlltree2 = n > n2 + 1 && string.charAt(n2 + 1) == '*';
                int n4 = n2 >= 0 ? n2 + (this.bAlltree2 ? 2 : 1) : (n3 = this.pos1 + (this.bAlltree1 ? 2 : 1));
                if (n3 < n) {
                    this.sEndPath = string.substring(n3);
                    this.posEndFromEnd = n - n3;
                } else {
                    this.sEndPath = null;
                    this.posEndFromEnd = 0;
                }
                if (n2 < 0) {
                    this.posContainPathFromEnd = -1;
                    this.posContainPath = -1;
                    this.sContainPath = null;
                } else {
                    this.posContainPath = this.pos1;
                    this.posContainPathFromEnd = n - n2 + (n2 - this.posContainPath);
                    this.sContainPath = string.substring(this.posContainPath + (this.bAlltree1 ? 2 : 1), n2);
                }
            } else {
                this.sStartPath = string;
                this.sEndPath = null;
                this.sContainPath = null;
                this.posContainPathFromEnd = -1;
                this.posContainPath = -1;
                this.bAlltree2 = false;
                this.bAlltree1 = false;
                this.posEndFromEnd = 0;
            }
        }

        public boolean checkPath(CharSequence charSequence) {
            int n;
            boolean bl = true;
            if (this.sStartPath != null && !StringFunctions.startsWith(charSequence, this.sStartPath)) {
                return false;
            }
            if (this.sEndPath != null && !StringFunctions.endsWith(charSequence, this.sEndPath)) {
                return false;
            }
            if (this.sContainPath != null) {
                n = StringFunctions.indexOf(charSequence, this.sContainPath);
                if (n < this.posContainPath && n > this.posContainPathFromEnd) {
                    return false;
                }
            } else {
                n = charSequence.length() - this.posEndFromEnd;
            }
            if (!this.bAlltree1 && StringFunctions.indexOf(charSequence, this.pos1, n, '/') >= 0) {
                return false;
            }
            if (this.bAlltree1) {
                return true;
            }
            return bl;
        }
    }

    static class NameFilter {
        final String sStartName;
        final String sEndName;
        final String sContainName;
        final int posContainName;
        final int posContainNameFromEnd;

        NameFilter(String string) {
            int n = string.length();
            int n2 = string.indexOf(42);
            int n3 = string.indexOf(42, n2 + 1);
            if (n2 >= 0) {
                this.sStartName = n2 > 0 ? string.substring(0, n2) : null;
                int n4 = n3 >= 0 ? n3 + 1 : n2 + 1;
                String string2 = this.sEndName = n4 < n ? string.substring(n4) : null;
                if (n3 < 0 || n3 == n2 + 1) {
                    this.posContainNameFromEnd = -1;
                    this.posContainName = -1;
                    this.sContainName = null;
                } else {
                    this.posContainName = n2 + 1;
                    this.posContainNameFromEnd = n - n3 - (n3 - this.posContainName);
                    this.sContainName = string.substring(this.posContainName, n3);
                }
            } else {
                this.sStartName = string;
                this.sEndName = null;
                this.sContainName = null;
                this.posContainNameFromEnd = -1;
                this.posContainName = -1;
            }
        }

        public boolean checkName(String string) {
            int n;
            if (this.sStartName != null && !string.startsWith(this.sStartName)) {
                return false;
            }
            if (this.sEndName != null && !string.endsWith(this.sEndName)) {
                return false;
            }
            return this.sContainName == null || (n = string.indexOf(this.sContainName)) >= this.posContainName || n <= string.length() - this.posContainNameFromEnd;
        }
    }
}

