/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.util;

import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.vishia.util.Assert;
import org.vishia.util.CalculatorExpr;
import org.vishia.util.Debugutil;
import org.vishia.util.StringFunctions;
import org.vishia.util.TreeNodeBase;

public class DataAccess {
    public static final String sVersion = "2018-08-28";
    private static final Class<?> ifcMainCmdLogging_ifc = DataAccess.getClass("org.vishia.mainCmd.MainCmdLogging_ifc");
    private static Map<String, Conversion> idxConversions = DataAccess.initConversion();
    private static String debugIdent;
    private static String debugMethod;
    protected List<DatapathElement> datapath;

    public DataAccess(String string) {
        this.datapath = new ArrayList<DatapathElement>();
        if ("$+%!".indexOf(string.charAt(0)) >= 0) {
            DatapathElement datapathElement = new DatapathElement(string);
            this.datapath.add(datapathElement);
        } else {
            String[] stringArray;
            for (String string2 : stringArray = string.split("\\.")) {
                DatapathElement datapathElement = new DatapathElement(string2);
                this.datapath.add(datapathElement);
            }
        }
    }

    public DataAccess(String string, char c) {
        this.datapath = new ArrayList<DatapathElement>();
        String[] stringArray = string.split("\\.");
        DatapathElement datapathElement = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            datapathElement = new DatapathElement(string2);
            this.datapath.add(datapathElement);
        }
        if (c >= 'A' && c <= 'Z' && datapathElement != null) {
            datapathElement.whatisit = c;
        }
    }

    public DataAccess() {
    }

    public final List<DatapathElement> datapath() {
        return this.datapath;
    }

    public void add_datapathElement(DatapathElement datapathElement) {
        if (this.datapath == null) {
            this.datapath = new ArrayList<DatapathElement>();
        }
        this.datapath.add(datapathElement);
    }

    public Object access(Object object, boolean bl, boolean bl2) throws Exception {
        return DataAccess.access(this.datapath, object, bl, bl2, false, null);
    }

    public static void storeValue(List<DatapathElement> list, Object object, Object object2, boolean bl) throws Exception {
        Dst dst = new Dst();
        Object object3 = DataAccess.access(list, object, bl, false, true, dst);
        if (object3 instanceof Variable) {
            Variable variable = (Variable)object3;
            variable.setValue(object2);
        } else {
            dst.set(object2);
        }
    }

    public static void storeValue(DatapathElement datapathElement, Object object, Object object2, boolean bl) throws Exception {
        Dst dst = new Dst();
        Object object3 = DataAccess.access(datapathElement, object, bl, false, true, dst);
        if (object3 instanceof Variable) {
            Variable variable = (Variable)object3;
            variable.setValue(object2);
        } else {
            dst.set(object2);
        }
    }

    public void storeValue(Object object, Object object2, boolean bl) throws Exception {
        DataAccess.storeValue(this.datapath, object, object2, bl);
    }

    static Map<String, Conversion> initConversion() {
        TreeMap<String, Conversion> treeMap = new TreeMap<String, Conversion>();
        treeMap.put("org.vishia.util.CalculatorExpr$Value:int", Conversions.calcValue2int);
        treeMap.put("java.lang.Long:int", Conversions.long2int);
        treeMap.put("java.lang.Integer:boolean", Conversions.int2bool);
        treeMap.put("java.lang.Integer:byte", Conversions.int2byte);
        treeMap.put("java.lang.Integer:short", Conversions.int2short);
        treeMap.put("java.lang.Integer:int", Conversions.obj2obj);
        treeMap.put("java.lang.Integer:long", Conversions.int2long);
        treeMap.put("java.lang.Integer:float", Conversions.int2float);
        treeMap.put("java.lang.Integer:double", Conversions.int2double);
        treeMap.put("java.lang.Integer:char", Conversions.int2char);
        treeMap.put("java.lang.Float:float", Conversions.obj2obj);
        treeMap.put("java.lang.Float:double", Conversions.float2double);
        treeMap.put("java.lang.Double:double", Conversions.obj2obj);
        treeMap.put("java.lang.Double:float", Conversions.double2float);
        treeMap.put("java.lang.Number:boolean", Conversions.number2bool);
        treeMap.put("java.lang.Number:char", Conversions.number2char);
        treeMap.put("java.lang.Boolean:boolean", Conversions.obj2obj);
        treeMap.put("java.lang.Object:boolean", Conversions.obj2bool);
        treeMap.put("java.lang.CharSequence:char", Conversions.charSeq2char);
        treeMap.put("java.lang.CharSequence:java.lang.String", Conversions.charSequence2String);
        return treeMap;
    }

    private static final Class<?> getClass(String string) {
        try {
            return Class.forName(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static List<DatapathElement> expandElements(CharSequence charSequence, char n) {
        int n2;
        int n3;
        LinkedList<DatapathElement> linkedList = new LinkedList<DatapathElement>();
        int n4 = charSequence.charAt(0);
        if ("&@$".indexOf(n4) >= 0) {
            n3 = 0;
        } else {
            n3 = -1;
            n4 = n;
        }
        int n5 = charSequence.length();
        do {
            if ((n2 = StringFunctions.indexOf(charSequence, '.', n3 + 1)) < 0) {
                n2 = n5;
            }
            String string = charSequence.subSequence(n3 + 1, n2).toString();
            DatapathElement datapathElement = new DatapathElement(string);
            datapathElement.whatisit = n4;
            n4 = 46;
            linkedList.add(datapathElement);
        } while ((n3 = n2) < n5);
        return linkedList;
    }

    public static Object access(CharSequence charSequence, Object object, boolean bl, boolean bl2, boolean bl3, Dst dst) throws Exception {
        List<DatapathElement> list = DataAccess.expandElements(charSequence, '.');
        return DataAccess.access(list, object, bl, bl2, bl3, dst);
    }

    public static Object access(List<DatapathElement> list, Object list2, boolean bl, boolean bl2, boolean bl3, Dst dst) throws Exception {
        Object object;
        Object object2;
        Iterator<DatapathElement> iterator = list.iterator();
        DatapathElement datapathElement = iterator.next();
        if ("+%".indexOf(datapathElement.whatisit) < 0 && datapathElement.ident != null && datapathElement.ident.contains(".")) {
            object2 = DataAccess.expandElements(datapathElement.ident, datapathElement.whatisit);
            iterator = object2.iterator();
            datapathElement = iterator.next();
        }
        object2 = list2;
        while (datapathElement != null) {
            if (debugIdent != null && datapathElement.ident != null && datapathElement.ident.equals(debugIdent)) {
                DataAccess.debug();
            }
            object2 = DataAccess.access(datapathElement, object2, bl, bl2, bl3, dst);
            datapathElement = iterator.hasNext() ? iterator.next() : null;
        }
        if (object2 instanceof Variable && !bl3) {
            object = (Variable)object2;
            object2 = ((Variable)object).value;
        }
        if (object2 == null) {
            return null;
        }
        if (bl2) {
            if (object2.getClass().isArray()) {
                return object2;
            }
            if (object2 instanceof Iterable || object2 instanceof Map) {
                return object2;
            }
            object = new LinkedList();
            object.add(object2);
            return object;
        }
        return object2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object access(DatapathElement datapathElement, Object variable, boolean bl, boolean bl2, boolean bl3, Dst dst) throws Exception {
        boolean bl4;
        Class clazz;
        if (variable instanceof Variable) {
            clazz = variable;
            bl4 = ((Variable)((Object)clazz)).type == 'C';
            variable = ((Variable)((Object)clazz)).value;
        } else {
            bl4 = false;
        }
        switch (datapathElement.whatisit) {
            case '.': 
            case '@': {
                if (bl4) {
                    return DataAccess.getDataFromField(datapathElement.ident, null, bl, (Class)((Object)variable), dst, 0);
                }
                if (variable == null) return variable;
                return DataAccess.getDataPriv(datapathElement.ident, variable, bl, bl2, true, dst);
            }
            case '+': {
                return DataAccess.invokeNew(datapathElement);
            }
            case '(': {
                if (variable == null) return variable;
                clazz = bl4 && variable instanceof Class ? (Class)((Object)variable) : variable.getClass();
                return DataAccess.invokeMethod(datapathElement, clazz, variable, bl, false);
            }
            case '%': {
                return datapathElement.operation_ || datapathElement.argNames != null || datapathElement.fnArgs != null ? DataAccess.invokeStaticMethod(datapathElement) : DataAccess.getStaticValue(datapathElement);
            }
            case '$': {
                if (variable instanceof Map) {
                    clazz = (Map)((Object)variable);
                    variable = clazz.get("$" + datapathElement.ident);
                }
                if (variable == null) {
                    variable = System.getenv(datapathElement.ident);
                }
                if (variable == null) {
                    variable = System.getProperty(datapathElement.ident);
                }
                if (variable != null) return variable;
                throw new NoSuchElementException("DataAccess - environment variable not found; " + datapathElement.ident);
            }
            default: {
                boolean bl5;
                char c = datapathElement.whatisit;
                if (datapathElement.whatisit >= 'a' && datapathElement.whatisit <= 'z') {
                    bl5 = true;
                    c = (char)(c - 32);
                } else {
                    bl5 = false;
                }
                if (c >= 'A' && c <= 'Z') {
                    if (!(variable instanceof Map)) throw new IllegalArgumentException("DataAccess.storeValue - destination should be Map<String, DataAccess.Variable>; " + dst);
                    Map map = (Map)((Object)variable);
                    Variable<Object> variable2 = new Variable<Object>(datapathElement.whatisit, datapathElement.ident, null, bl5);
                    map.put(datapathElement.ident, variable2);
                    variable = variable2;
                } else if (bl4) {
                    variable = DataAccess.getDataFromField(datapathElement.ident, null, bl, (Class)((Object)variable), dst, 0);
                } else if (variable != null) {
                    variable = DataAccess.getDataPriv(datapathElement.ident, variable, bl, bl2, bl3, dst);
                }
                if (datapathElement.indices == null) return variable;
                return DataAccess.getArrayElement(variable, datapathElement.indices);
            }
        }
    }

    protected static Object invokeNew(DatapathElement datapathElement) throws Exception {
        Constructor<?>[] constructorArray;
        Class<?> clazz;
        if (datapathElement instanceof DatapathElementClass && ((DatapathElementClass)datapathElement).clazz != null) {
            clazz = ((DatapathElementClass)datapathElement).clazz;
        } else {
            constructorArray = datapathElement.ident;
            if (debugIdent != null && constructorArray.equals(debugIdent)) {
                DataAccess.debug();
            }
            ClassLoader classLoader = DataAccess.getClassLoader(datapathElement);
            clazz = classLoader.loadClass((String)constructorArray);
        }
        constructorArray = clazz.getConstructors();
        boolean bl = false;
        Object var4_5 = null;
        if (constructorArray.length == 0 && datapathElement.fnArgs == null) {
            var4_5 = clazz.newInstance();
            bl = var4_5 != null;
        } else {
            for (Constructor<?> constructor : constructorArray) {
                bl = false;
                Object object = constructor.getParameterTypes();
                Object[] objectArray = DataAccess.checkAndConvertArgTypes(datapathElement.fnArgs, object);
                if (objectArray == null) continue;
                bl = true;
                try {
                    var4_5 = constructor.newInstance(objectArray);
                    break;
                }
                catch (IllegalAccessException illegalAccessException) {
                    CharSequence charSequence = Assert.stackInfo(" called ", 3, 5);
                    throw new NoSuchMethodException("DataAccess - method access problem: " + clazz.getName() + "." + datapathElement.ident + "(...)" + charSequence);
                }
                catch (InstantiationException instantiationException) {
                    CharSequence charSequence = Assert.stackInfo(" called ", 3, 5);
                    throw new NoSuchMethodException("DataAccess - new invocation problem: " + clazz.getName() + "." + datapathElement.ident + "(...)" + charSequence);
                }
            }
        }
        if (!bl) {
            StringBuilder stringBuilder = new StringBuilder(1000);
            stringBuilder.append("DataAccess - constructor not found in class, ").append(clazz.getName()).append(", ").append(datapathElement.ident).append("(");
            if (datapathElement.fnArgs != null) {
                for (Object object : datapathElement.fnArgs) {
                    stringBuilder.append(object.getClass()).append(", ");
                }
            }
            stringBuilder.append(");, stackInfo: ");
            CharSequence charSequence = Assert.stackInfo(stringBuilder, 3, 8);
            throw new NoSuchMethodException(charSequence.toString());
        }
        return var4_5;
    }

    public static Object invokeMethod(DatapathElement datapathElement, Class<?> clazz, Object object, boolean bl, boolean bl2) throws InvocationTargetException, NoSuchMethodException, Exception {
        return DataAccess.invokeMethod(datapathElement, clazz, object, bl, bl2, null);
    }

    public static Object invokeMethod(DatapathElement datapathElement, Class<?> clazz, Object object, boolean bl, boolean bl2, Object[] objectArray) throws InvocationTargetException, NoSuchMethodException, Exception {
        Object object2;
        Class<?> clazz2;
        Object object3 = null;
        Class<?> clazz3 = clazz2 = clazz == null ? object.getClass() : clazz;
        if (datapathElement.ident.equals("execX")) {
            Assert.stop();
        }
        boolean bl3 = false;
        boolean bl4 = false;
        block4: do {
            if (!bl && (clazz3.getModifiers() & 1) == 0) continue;
            for (Object object4 : object2 = bl ? clazz3.getDeclaredMethods() : clazz3.getMethods()) {
                bl3 = false;
                if (!((Method)object4).getName().equals(datapathElement.ident)) continue;
                if (debugMethod != null && (debugMethod.equals(datapathElement.ident) || debugMethod.equals(""))) {
                    DataAccess.debug();
                    if (debugMethod.equals("")) {
                        debugMethod = null;
                    }
                }
                bl4 = true;
                ((Method)object4).setAccessible(bl);
                Class<?>[] classArray = ((Method)object4).getParameterTypes();
                Object[] objectArray2 = objectArray != null ? objectArray : datapathElement.fnArgs;
                Object[] objectArray3 = DataAccess.checkAndConvertArgTypes(objectArray2, classArray);
                if (objectArray3 == null) continue;
                bl3 = true;
                try {
                    object3 = ((Method)object4).invoke(object, objectArray3);
                    continue block4;
                }
                catch (IllegalAccessException illegalAccessException) {
                    CharSequence charSequence = Assert.stackInfo(" called ", 3, 5);
                    throw new NoSuchMethodException("DataAccess - method access problem: " + clazz3.getName() + "." + datapathElement.ident + "(...)" + charSequence);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Assert.stop();
                    throw invocationTargetException;
                }
                catch (Exception exception) {
                    throw exception;
                }
            }
        } while (!bl3 && (clazz3 = clazz3.getSuperclass()) != null);
        if (!bl3 && !bl2) {
            object2 = new StringBuilder(1000);
            if (bl4) {
                ((StringBuilder)object2).append("DataAccess - method parameters don't match in class, ");
            } else {
                ((StringBuilder)object2).append("DataAccess - method not found in class, ");
            }
            ((StringBuilder)object2).append(clazz2.getName()).append(", ").append(datapathElement.ident).append("(");
            if (datapathElement.fnArgs != null) {
                for (Object object4 : datapathElement.fnArgs) {
                    ((StringBuilder)object2).append(object4.getClass()).append(", ");
                }
            }
            ((StringBuilder)object2).append(");, stackInfo: ");
            CharSequence charSequence = Assert.stackInfo((CharSequence)object2, 3, 5);
            if (debugMethod != null && debugMethod.equals("")) {
                DataAccess.debug();
                debugMethod = null;
            }
            throw new NoSuchMethodException(charSequence.toString());
        }
        return object3;
    }

    protected static Object invokeStaticMethod(DatapathElement datapathElement) throws Exception {
        Object object;
        String string;
        Class<?> clazz;
        if (datapathElement instanceof DatapathElementClass && ((DatapathElementClass)datapathElement).clazz != null) {
            clazz = ((DatapathElementClass)datapathElement).clazz;
            string = datapathElement.ident;
        } else {
            int n = datapathElement.ident.lastIndexOf(46);
            String string2 = datapathElement.ident.substring(0, n);
            string = datapathElement.ident.substring(n + 1);
            object = DataAccess.getClassLoader(datapathElement);
            clazz = ((ClassLoader)object).loadClass(string2);
        }
        Method[] methodArray = clazz.getMethods();
        boolean bl = false;
        object = null;
        for (Method method : methodArray) {
            Class<?>[] classArray;
            Object[] objectArray;
            bl = false;
            Object object2 = method.getName();
            if (!((String)object2).equals(string)) continue;
            if (debugMethod != null && (debugMethod.equals(datapathElement.ident) || debugMethod.equals(""))) {
                DataAccess.debug();
                if (debugMethod.equals("")) {
                    debugMethod = null;
                }
            }
            if ((objectArray = DataAccess.checkAndConvertArgTypes(datapathElement.fnArgs, classArray = method.getParameterTypes())) == null) continue;
            if ((method.getModifiers() & 8) == 0) {
                throw new IllegalArgumentException("DataAccess - invokeStaticMethod on non static method, " + string);
            }
            bl = true;
            try {
                object = method.invoke(null, objectArray);
                break;
            }
            catch (IllegalAccessException illegalAccessException) {
                CharSequence charSequence = Assert.stackInfo(" called ", 3, 5);
                throw new NoSuchMethodException("DataAccess - method access problem: " + clazz.getName() + "." + datapathElement.ident + "(...)" + charSequence);
            }
        }
        if (!bl) {
            StringBuilder stringBuilder = new StringBuilder(1000);
            stringBuilder.append("DataAccess - static method not found: ").append(datapathElement.ident).append("(");
            if (datapathElement.fnArgs != null) {
                for (Object object2 : datapathElement.fnArgs) {
                    if (object2 == null) {
                        stringBuilder.append("null, ");
                        continue;
                    }
                    stringBuilder.append(object2.getClass()).append(", ");
                }
            }
            stringBuilder.append(")|, ");
            CharSequence charSequence = Assert.stackInfo(stringBuilder, 3, 5);
            if (debugMethod != null && debugMethod.equals("")) {
                DataAccess.debug();
                debugMethod = null;
            }
            throw new NoSuchMethodException(charSequence.toString());
        }
        return object;
    }

    protected static Object getStaticValue(DatapathElement datapathElement) throws Exception {
        String string;
        Class<?> clazz;
        if (datapathElement instanceof DatapathElementClass && ((DatapathElementClass)datapathElement).clazz != null) {
            clazz = ((DatapathElementClass)datapathElement).clazz;
            string = datapathElement.ident;
        } else {
            int n = datapathElement.ident.lastIndexOf(46);
            String string2 = datapathElement.ident.substring(0, n);
            string = datapathElement.ident.substring(n + 1);
            ClassLoader classLoader = DataAccess.getClassLoader(datapathElement);
            clazz = classLoader.loadClass(string2);
        }
        return DataAccess.getDataFromField(string, null, false, clazz, null, 0);
    }

    private static ClassLoader getClassLoader(DatapathElement datapathElement) {
        ClassLoader classLoader = datapathElement.getClass().getClassLoader();
        if (datapathElement instanceof DatapathElementClass) {
            DatapathElementClass datapathElementClass = (DatapathElementClass)datapathElement;
            if (datapathElementClass.loader != null) {
                classLoader = datapathElementClass.loader;
            }
        }
        return classLoader;
    }

    /*
     * WARNING - void declaration
     */
    protected static Object[] checkAndConvertArgTypes(Object[] objectArray, Class<?>[] classArray) {
        int n;
        Object[] objectArray2 = null;
        if (classArray.length == 1 && classArray[0].isArray() && classArray[0].getName().equals("[Ljava.lang.String;")) {
            if (objectArray == null) {
                objectArray2 = new Object[]{new String[0]};
            } else {
                String[] stringArray = new String[objectArray.length];
                objectArray2 = new Object[]{stringArray};
                n = -1;
                for (Object object : objectArray) {
                    if (!(object instanceof CharSequence)) {
                        objectArray2 = null;
                        break;
                    }
                    stringArray[++n] = ((CharSequence)object).toString();
                }
            }
        }
        if (objectArray2 == null) {
            if (classArray.length == 0 && objectArray == null) {
                objectArray2 = new Object[]{};
            } else if (objectArray != null && (classArray.length == objectArray.length || classArray.length > 0 && classArray.length < objectArray.length && classArray[classArray.length - 1].isArray())) {
                Object object;
                String[] stringArray;
                boolean bl = true;
                n = 0;
                Object var5_7 = null;
                Conversion[] conversionArray = new Conversion[objectArray.length];
                int n2 = -1;
                int n3 = -1;
                boolean bl2 = false;
                while (bl && ++n3 < objectArray.length) {
                    stringArray = objectArray[n3];
                    bl = false;
                    ++n2;
                    if (stringArray == null) {
                        bl = true;
                        conversionArray[n2] = Conversions.obj2obj;
                    } else {
                        object = null;
                        Class<?> clazz = stringArray.getClass();
                        if (classArray[n].isArray() && stringArray instanceof List && DataAccess.istypeof(((List)stringArray).get(0), classArray[n].getComponentType())) {
                            object = Conversions.list2array;
                        } else if (n == classArray.length - 1 && classArray[n].isArray() && (objectArray.length > n + 1 || objectArray.length == n + 1 && !clazz.isArray())) {
                            Class<?> clazz2 = classArray[n].getComponentType();
                            bl2 = true;
                        } else {
                            Class<?> clazz3 = classArray[n];
                        }
                        if (object == null) {
                            void var5_8;
                            object = DataAccess.checkArgTypes(var5_8, clazz, stringArray);
                        }
                        if (object != null) {
                            conversionArray[n2] = object;
                            bl = true;
                        }
                        if (!bl) break;
                    }
                    if (n >= classArray.length - 1) continue;
                    ++n;
                }
                if (bl) {
                    stringArray = bl2 ? ((object = classArray[classArray.length - 1].getComponentType()) == String.class ? new String[objectArray.length - classArray.length + 1] : new String[objectArray.length - classArray.length + 1]) : null;
                    object = objectArray2 = new Object[classArray.length];
                    n = 0;
                    n2 = -1;
                    for (Object object2 : objectArray) {
                        Object object3;
                        ++n2;
                        if (object == objectArray2) {
                            if (n >= classArray.length - 1 && stringArray != null) {
                                objectArray2[n] = stringArray;
                                object = stringArray;
                                n = 0;
                                Class<?> clazz = classArray[n].getComponentType();
                            } else {
                                Class<?> clazz = classArray[n];
                            }
                        }
                        assert (conversionArray[n2] != null);
                        object[n] = object3 = conversionArray[n2].convert(object2);
                        ++n;
                    }
                } else {
                    objectArray2 = null;
                }
            } else {
                objectArray2 = null;
            }
        }
        return objectArray2;
    }

    public static Conversion checkArgTypes(Class<?> clazz, Class<?> clazz2, Object object) {
        Conversion conversion = null;
        Class<?> clazz3 = clazz2;
        while (conversion == null && clazz3 != null) {
            conversion = DataAccess.checkIfcTypes(clazz, clazz3, object);
            if (conversion != null) continue;
            clazz3 = clazz3.getSuperclass();
        }
        return conversion;
    }

    private static Conversion checkIfcTypes(Class<?> clazz, Class<?> clazz2, Object object) {
        Conversion conversion = DataAccess.checkTypes(clazz, clazz2, object);
        if (conversion == null) {
            Class<?>[] classArray = clazz2.getInterfaces();
            int n = -1;
            int n2 = classArray.length;
            while (conversion == null && ++n < n2) {
                Class<?> clazz3 = classArray[n];
                conversion = DataAccess.checkIfcTypes(clazz, clazz3, object);
            }
        }
        return conversion;
    }

    public static Conversion checkTypes(Class<?> clazz, Class<?> clazz2, Object object) {
        if (clazz == clazz2) {
            return Conversions.obj2obj;
        }
        String string = clazz2.getName() + ":" + clazz.getName();
        Conversion conversion = idxConversions.get(string);
        if (conversion != null && !conversion.canConvert(object)) {
            conversion = null;
        }
        return conversion;
    }

    public static final boolean istypeof(Object object, String string) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(string);
        return DataAccess.istypeof(object, clazz);
    }

    public static final boolean istypeof(Object object, Class clazz) {
        if (object == null) {
            return false;
        }
        Class<?> clazz2 = object.getClass();
        do {
            if (clazz2 != clazz) continue;
            return true;
        } while ((clazz2 = clazz2.getSuperclass()) != Object.class);
        return false;
    }

    public static Object getData(String string, Object object, boolean bl, boolean bl2, boolean bl3, Dst dst) throws NoSuchFieldException, IllegalAccessException {
        Object object2;
        if (object instanceof Variable) {
            Variable variable = (Variable)object;
            object2 = variable.value;
        } else {
            object2 = object;
        }
        return DataAccess.getDataPriv(string, object2, bl, bl2, bl3, dst);
    }

    private static Object getDataPriv(String string, Object object, boolean bl, boolean bl2, boolean bl3, Dst dst) throws NoSuchFieldException, IllegalAccessException {
        Object object2;
        if (string.equals("cellx")) {
            Debugutil.stop();
        }
        List<Object> list = null;
        if (string.equals("[]")) {
            if (object instanceof Object[]) {
                return new Integer(((Object[])object).length);
            }
            if (object instanceof Collection) {
                return new Integer(((Collection)object).size());
            }
            if (object instanceof Map) {
                return new Integer(((Map)object).size());
            }
            throw new IllegalArgumentException("is not a container or array, " + string);
        }
        if (object instanceof Map) {
            object2 = (Map)object;
            list = (List<Object>)object2.get(string);
            if (list == null && !object2.containsKey(string)) {
                throw new NoSuchFieldException(string);
            }
        } else {
            try {
                list = DataAccess.getDataFromField(string, object, bl, dst);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if (object instanceof TreeNodeBase) {
                    TreeNodeBase treeNodeBase = (TreeNodeBase)object;
                    list = bl2 ? treeNodeBase.listChildren(string) : treeNodeBase.getChild(string);
                    if (list == null) {
                        throw new NoSuchFieldException(string + " ;in TreeNode, contains; " + treeNodeBase.toString());
                    }
                }
                throw noSuchFieldException;
            }
        }
        if (!bl3 && list instanceof Variable) {
            object2 = (Variable)((Object)list);
            list = ((Variable)object2).value;
        }
        return list;
    }

    public static Object getDataFromField(String string, Object object, boolean bl, Dst dst) throws NoSuchFieldException, IllegalAccessException {
        return DataAccess.getDataFromField(string, object, bl, object.getClass(), dst, 0);
    }

    private static Object getDataFromField(String string, Object object, boolean bl, Class<?> clazz, Dst dst, int n) throws NoSuchFieldException, IllegalAccessException {
        AnnotatedElement annotatedElement;
        if (n > 100) {
            throw new IllegalArgumentException("recursion error");
        }
        Object object2 = null;
        boolean bl2 = false;
        try {
            annotatedElement = clazz.getDeclaredField(string);
            annotatedElement.setAccessible(bl);
            if (dst != null) {
                dst.field = annotatedElement;
                dst.obj = object;
            }
            object2 = annotatedElement.get(object);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            bl2 = true;
        }
        if (bl2 && (annotatedElement = clazz.getSuperclass()) != null) {
            try {
                object2 = DataAccess.getDataFromField(string, object, bl, annotatedElement, dst, n + 1);
                bl2 = false;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                bl2 = true;
            }
        }
        if (bl2 && (annotatedElement = clazz.getEnclosingClass()) != null) {
            Object object3 = DataAccess.getEnclosingInstance(object);
            try {
                object2 = DataAccess.getDataFromField(string, object3, bl, annotatedElement, dst, n + 1);
                bl2 = false;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                bl2 = true;
            }
        }
        if (bl2) {
            throw new NoSuchFieldException(string + " ;in class ;" + clazz.getCanonicalName() + ", data," + (object == null ? "" : object.toString()));
        }
        return object2;
    }

    public static Object getEnclosingInstance(Object object) {
        return DataAccess.getEnclosingInstance(0, object);
    }

    private static Object getEnclosingInstance(int n, Object object) {
        Object object2;
        boolean bl = false;
        if (n > 10) {
            object2 = null;
        } else {
            String string = "this$" + n;
            try {
                Field field = object.getClass().getDeclaredField(string);
                field.setAccessible(true);
                object2 = field.get(object);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                bl = true;
                object2 = null;
            }
            catch (IllegalAccessException illegalAccessException) {
                object2 = null;
            }
        }
        if (bl) {
            object2 = DataAccess.getEnclosingInstance(n + 1, object);
        }
        return object2;
    }

    public static boolean isReferenceToEnclosing(Field field) {
        return field.getName().startsWith("this$");
    }

    public static boolean isOrExtends(Class<?> clazz, Class<?> clazz2) {
        Class<?> clazz3 = clazz;
        do {
            if (clazz3 != clazz2) continue;
            return true;
        } while ((clazz3 = clazz3.getSuperclass()) != null);
        return false;
    }

    public static String getStringFromObject(Object object, String string) {
        String string2;
        Object object2;
        if (object instanceof Variable) {
            Variable variable = (Variable)object;
            object2 = variable.value;
        } else {
            object2 = object;
        }
        if (object2 == null) {
            string2 = "";
        } else if (object2 instanceof String) {
            string2 = (String)object2;
        } else if (object2 instanceof Integer) {
            if (string != null) {
                try {
                    string2 = String.format(string, object2);
                }
                catch (Exception exception) {
                    string2 = "<??format:" + string + " exception:" + exception.getMessage() + "??>";
                }
            } else {
                int n = (Integer)object2;
                string2 = Integer.toString(n);
            }
        } else {
            string2 = object.toString();
        }
        return string2;
    }

    public static int getInt(Object object) {
        if (object instanceof Byte) {
            return ((Byte)object).byteValue();
        }
        if (object instanceof Short) {
            return ((Short)object).shortValue();
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Long) {
            return (int)((Long)object).longValue();
        }
        if (object instanceof Float) {
            return (int)((Float)object).floatValue();
        }
        if (object instanceof Double) {
            return (int)((Double)object).doubleValue();
        }
        return 0;
    }

    public static float getFloat(Object object) {
        if (object instanceof Byte) {
            return ((Byte)object).byteValue();
        }
        if (object instanceof Short) {
            return ((Short)object).shortValue();
        }
        if (object instanceof Integer) {
            return ((Integer)object).intValue();
        }
        if (object instanceof Long) {
            return ((Long)object).longValue();
        }
        if (object instanceof Float) {
            return ((Float)object).floatValue();
        }
        if (object instanceof Double) {
            return (float)((Double)object).doubleValue();
        }
        return 0.0f;
    }

    public static int getLengthOfArray(Object object) {
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            Object[] objectArray = (Object[])object;
            return objectArray.length;
        }
        return -1;
    }

    public static Object getArrayElement(Object object, int ... nArray) {
        int n = 0;
        Object object2 = object;
        Class<?> clazz = object.getClass();
        while (clazz.isArray() && n < nArray.length) {
            float[] fArray;
            if ((clazz = clazz.getComponentType()) == Integer.TYPE) {
                fArray = (float[])object2;
                object2 = Float.valueOf(fArray[nArray[n]]);
                continue;
            }
            if (clazz == Character.TYPE) {
                fArray = (float[])object2;
                object2 = Float.valueOf(fArray[nArray[n]]);
                continue;
            }
            if (clazz == Long.TYPE) {
                fArray = (float[])object2;
                object2 = Float.valueOf(fArray[nArray[n]]);
                continue;
            }
            if (clazz == Short.TYPE) {
                fArray = (float[])object2;
                object2 = Float.valueOf(fArray[nArray[n]]);
                continue;
            }
            if (clazz == Byte.TYPE) {
                fArray = (float[])object2;
                object2 = Float.valueOf(fArray[nArray[n]]);
                continue;
            }
            if (clazz == Boolean.TYPE) {
                fArray = (float[])object2;
                object2 = Float.valueOf(fArray[nArray[n]]);
                continue;
            }
            if (clazz == Float.TYPE) {
                fArray = (float[])object2;
                object2 = Float.valueOf(fArray[nArray[n]]);
                continue;
            }
            if (clazz == Double.TYPE) {
                fArray = (float[])object2;
                object2 = Float.valueOf(fArray[nArray[n]]);
                continue;
            }
            object2 = ((Object[])object2)[nArray[n]];
        }
        return object2;
    }

    public static int setBit(int n, int n2, boolean bl) {
        return bl ? n | n2 : n & ~n2;
    }

    public static Variable<Object> createOrReplaceVariable(Map<String, Variable<Object>> map, String string, char c, Object object, boolean bl) throws IllegalAccessException {
        Variable<Object> variable = map.get(string);
        if (variable == null) {
            variable = new Variable<Object>(c, string, object);
            variable.isConst = bl;
            map.put(string, variable);
        } else {
            if (variable.isConst && !bl) {
                throw new IllegalAccessException("DataAccess.setVariable - modification of const; " + variable.name);
            }
            variable.value = object;
            variable.type = c;
            variable.isConst = bl;
        }
        return variable;
    }

    public static Variable<Object> getVariable(Map<String, Variable<Object>> map, String string, boolean bl) throws NoSuchFieldException {
        Variable<Object> variable = map.get(string);
        if (variable != null) {
            return variable;
        }
        if (bl) {
            throw new NoSuchFieldException("DataAccess.getVariable - not found; " + string);
        }
        return null;
    }

    public String toString() {
        return this.datapath != null ? this.datapath.toString() : "emtpy DataAccess";
    }

    public CharSequence idents() {
        int n;
        int n2 = n = this.datapath == null ? 0 : this.datapath.size();
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return this.datapath.get((int)0).ident;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (DatapathElement datapathElement : this.datapath) {
            stringBuilder.append(datapathElement.ident).append(".");
        }
        return stringBuilder;
    }

    public static void debugIdent(String string) {
        debugIdent = string;
    }

    public static void debugMethod(String string) {
        debugMethod = string;
    }

    protected static void debug() {
        Debugutil.stop();
    }

    public void writeStruct(Appendable appendable) throws IOException {
        String string = "";
        for (DatapathElement datapathElement : this.datapath) {
            appendable.append(string);
            datapathElement.writeStruct(appendable);
            string = ".";
        }
    }

    public short shortFromUnsignedByte(byte by) {
        return by >= 0 ? (short)by : (short)(by + 256);
    }

    public int intFromUnsignedShort(short n) {
        return n >= 0 ? n : n + 32768;
    }

    public static class Test {
        public static void testArrayElement() {
            float[][] fArray = new float[5][3];
            Object object = DataAccess.getArrayElement(fArray, 2);
            System.out.println(object);
        }
    }

    public static final class Variable<T> {
        protected char type;
        protected Class<? extends T> clazz;
        protected boolean isConst;
        protected final String name;
        protected T value;

        public Variable(char c, String string, T t) {
            this.type = c;
            this.name = string;
            this.value = t;
            if (t != null) {
                Class<?> clazz = t.getClass();
                this.clazz = clazz;
            }
        }

        public Variable(char c, String string, T t, boolean bl) {
            this(c, string, t);
            this.isConst = bl;
        }

        public Variable(Variable<T> variable) {
            this.type = variable.type;
            this.name = variable.name;
            this.isConst = variable.isConst;
            this.clazz = variable.clazz;
            this.value = variable.value instanceof Appendable && variable.value instanceof CharSequence ? variable.value : variable.value;
        }

        public String name() {
            return this.name;
        }

        public T value() {
            return this.value;
        }

        public char type() {
            return this.type;
        }

        public boolean isConst() {
            return this.isConst;
        }

        public void setValue(T t) {
            this.value = t;
        }

        public String toString() {
            return "Variable " + this.type + " " + this.name + " = " + this.value;
        }
    }

    public static final class Dst {
        protected Field field;
        protected Object obj;

        public void set(Object object) throws IllegalArgumentException, IllegalAccessException {
            Conversion conversion = DataAccess.checkArgTypes(this.field.getType(), object.getClass(), object);
            if (conversion == null) {
                throw new IllegalArgumentException("DataAccess - cannot assign; " + this.field + " = " + object);
            }
            Object object2 = conversion.convert(object);
            this.field.set(this.obj, object2);
        }
    }

    public static final class ObjMethod {
        public final Method method;
        public final Object obj;

        public ObjMethod(Method method, Object object) {
            this.method = method;
            this.obj = object;
        }
    }

    public static class DatapathElementClass
    extends DatapathElement {
        ClassLoader loader;
        Class<?> clazz;

        public void set_javapath(String string) {
            this.ident = string;
        }

        public void set_loader(ClassLoader classLoader) {
            this.loader = classLoader;
        }

        public void set_Class(Class<?> clazz) {
            this.clazz = clazz;
        }
    }

    public static class DatapathElement {
        protected String ident;
        protected char whatisit = (char)46;
        protected Object[] fnArgs;
        private String[] argNames;
        int[] indices;
        private boolean operation_;

        protected DatapathElement() {
        }

        public DatapathElement(String string) {
            this.set(string);
        }

        public void set_operation(boolean bl) {
            this.operation_ = bl;
        }

        public void set_operation() {
            this.operation_ = true;
        }

        public boolean isOperation() {
            return this.operation_;
        }

        public int nrArgNames() {
            return this.argNames == null ? 0 : this.argNames.length;
        }

        public String argName(int n) {
            return this.argNames[n];
        }

        public void set(String string) {
            char c = string.charAt(0);
            int n = 1;
            if ("$@+%".indexOf(c) >= 0) {
                this.whatisit = c;
            } else {
                this.whatisit = (char)46;
                n = 0;
            }
            int n2 = string.indexOf(40);
            if (n2 != -1) {
                this.whatisit = (char)(this.whatisit == '%' ? 37 : 40);
                this.operation_ = true;
                int n3 = n2;
                int n4 = string.length();
                LinkedList<String> linkedList = null;
                while (n3 >= 0 && n3 < n4) {
                    int n5 = string.indexOf(44, n3 + 1);
                    if (n5 > n3 || (n5 = string.indexOf(41, n3 + 1)) > n3 || (n5 = n4) > n3 + 1) {
                        String string2 = string.substring(n3 + 1, n5).trim();
                        if (string2.length() > 0) {
                            if (linkedList == null) {
                                linkedList = new LinkedList<String>();
                            }
                            linkedList.add(string2);
                        }
                        n3 = n5;
                        continue;
                    }
                    n3 = -1;
                }
                if (linkedList != null) {
                    this.argNames = new String[linkedList.size()];
                    linkedList.toArray(this.argNames);
                }
            } else {
                n2 = string.length();
            }
            this.ident = string.substring(n, n2);
        }

        public void set_ident(String string) {
            this.ident = string;
        }

        public void set_whatisit(String string) {
            this.whatisit = string.charAt(0);
        }

        public String ident() {
            return this.ident;
        }

        public void setIdent(String string) {
            this.ident = string;
        }

        public void setActualArguments(Object ... objectArray) {
            this.fnArgs = objectArray;
        }

        public void setActualArgumentArray(Object[] objectArray) {
            this.fnArgs = objectArray;
        }

        public void writeStruct(Appendable appendable) throws IOException {
            appendable.append(this.whatisit);
            if (this.whatisit >= 'A' && this.whatisit <= 'Z') {
                appendable.append(':');
            }
            appendable.append(this.ident);
            if (this.fnArgs != null) {
                String string = "(";
                for (Object object : this.fnArgs) {
                    appendable.append(string).append(object.toString());
                    string = ", ";
                }
                appendable.append(")");
            }
        }

        public String toString() {
            if (this.whatisit == '\u0000') {
                return this.ident + ":?";
            }
            if (this.whatisit != '(') {
                return this.ident + ":" + this.whatisit;
            }
            return this.ident + "(...)";
        }
    }

    public static class SetDatapathElement
    extends DatapathElement {
        protected final Object dbgParent;

        public SetDatapathElement(Object object) {
            this.dbgParent = object;
        }

        public SetDatapathElement() {
            this.dbgParent = null;
        }

        public void set_javapath(String string) {
            this.ident = string;
        }

        @Override
        public void set_ident(String string) {
            this.ident = string;
        }

        public void set_index(int n) {
            int n2;
            if (this.indices != null) {
                this.indices = new int[1];
                n2 = 0;
            } else {
                this.indices = new int[1];
                n2 = 0;
            }
            this.indices[n2] = n;
        }
    }

    public static class DataAccessSet
    extends DataAccess {
        public SetDatapathElement new_datapathElement() {
            return new SetDatapathElement();
        }

        public final void add_datapathElement(SetDatapathElement setDatapathElement) {
            super.add_datapathElement(setDatapathElement);
        }

        public DatapathElementClass newDatapathElementClass() {
            return new DatapathElementClass();
        }

        public final void add_datapathElementClass(DatapathElementClass datapathElementClass) {
            super.add_datapathElement(datapathElementClass);
        }

        public SetDatapathElement new_startDatapath() {
            return new SetDatapathElement();
        }

        public final void add_startDatapath(SetDatapathElement setDatapathElement) {
            super.add_datapathElement(setDatapathElement);
        }

        public final void set_envVariable(String string) {
            if (this.datapath == null) {
                this.datapath = new ArrayList();
            }
            DatapathElement datapathElement = new DatapathElement();
            datapathElement.whatisit = (char)36;
            datapathElement.ident = string;
            this.datapath.add(datapathElement);
        }

        public final void set_startVariable(String string) {
            if (this.datapath == null) {
                this.datapath = new ArrayList();
            }
            DatapathElement datapathElement = new DatapathElement();
            datapathElement.whatisit = (char)64;
            datapathElement.ident = string;
            this.datapath.add(datapathElement);
        }

        public final DatapathElementClass new_newJavaClass() {
            DatapathElementClass datapathElementClass = this.newDatapathElementClass();
            datapathElementClass.whatisit = (char)43;
            return datapathElementClass;
        }

        public final void add_newJavaClass(DatapathElementClass datapathElementClass) {
            this.add_datapathElement(datapathElementClass);
        }

        public final DatapathElementClass new_staticJavaMethod() {
            DatapathElementClass datapathElementClass = this.newDatapathElementClass();
            datapathElementClass.whatisit = (char)37;
            return datapathElementClass;
        }

        public final void add_staticJavaMethod(DatapathElementClass datapathElementClass) {
            this.add_datapathElement(datapathElementClass);
        }

        public final void setTypeToLastElement(char c) {
            int n = this.datapath.size() - 1;
            if (n >= 0) {
                DatapathElement datapathElement = (DatapathElement)this.datapath.get(n);
                datapathElement.whatisit = c;
            }
        }
    }

    private static class Conversions {
        protected static Conversion calcValue2int = new Conversion(){

            @Override
            public Object convert(Object object) {
                return new Integer(((CalculatorExpr.Value)object).intValue());
            }

            @Override
            public boolean canConvert(Object object) {
                return true;
            }

            public String toString() {
                return "calcValue:int";
            }
        };
        protected static Conversion long2int = new Conversion(){

            @Override
            public Object convert(Object object) {
                return new Integer(((Long)object).intValue());
            }

            @Override
            public boolean canConvert(Object object) {
                long l = (Long)object;
                return l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE;
            }

            public String toString() {
                return "long:int";
            }
        };
        protected static Conversion int2char = new Conversion(){

            @Override
            public Object convert(Object object) {
                return new Character((char)((Integer)object).intValue());
            }

            @Override
            public boolean canConvert(Object object) {
                return true;
            }

            public String toString() {
                return "int:double";
            }
        };
        protected static Conversion int2bool = new Conversion(){

            @Override
            public Object convert(Object object) {
                return new Boolean((Integer)object != 0);
            }

            @Override
            public boolean canConvert(Object object) {
                return true;
            }

            public String toString() {
                return "int:long";
            }
        };
        protected static Conversion int2byte = new Conversion(){

            @Override
            public Object convert(Object object) {
                return new Byte((byte)((Integer)object).intValue());
            }

            @Override
            public boolean canConvert(Object object) {
                int n = (Integer)object;
                return n <= 127 && n >= -128;
            }

            public String toString() {
                return "int:long";
            }
        };
        protected static Conversion int2short = new Conversion(){

            @Override
            public Object convert(Object object) {
                return new Short((byte)((Integer)object).intValue());
            }

            @Override
            public boolean canConvert(Object object) {
                int n = (Integer)object;
                return n <= Short.MAX_VALUE && n >= Short.MIN_VALUE;
            }

            public String toString() {
                return "int:long";
            }
        };
        protected static Conversion int2long = new Conversion(){

            @Override
            public Object convert(Object object) {
                return new Long(((Integer)object).intValue());
            }

            @Override
            public boolean canConvert(Object object) {
                return true;
            }

            public String toString() {
                return "int:long";
            }
        };
        protected static Conversion int2float = new Conversion(){

            @Override
            public Object convert(Object object) {
                return new Float(((Integer)object).intValue());
            }

            @Override
            public boolean canConvert(Object object) {
                return true;
            }

            public String toString() {
                return "int:float";
            }
        };
        protected static Conversion int2double = new Conversion(){

            @Override
            public Object convert(Object object) {
                return new Double(((Integer)object).intValue());
            }

            @Override
            public boolean canConvert(Object object) {
                return true;
            }

            public String toString() {
                return "int:double";
            }
        };
        protected static Conversion number2char = new Conversion(){

            @Override
            public Object convert(Object object) {
                return new Character((char)((Number)object).longValue());
            }

            @Override
            public boolean canConvert(Object object) {
                return true;
            }

            public String toString() {
                return "int:double";
            }
        };
        protected static Conversion double2float = new Conversion(){

            @Override
            public Object convert(Object object) {
                return new Float(((Double)object).floatValue());
            }

            @Override
            public boolean canConvert(Object object) {
                return true;
            }

            public String toString() {
                return "double:float";
            }
        };
        protected static Conversion float2double = new Conversion(){

            @Override
            public Object convert(Object object) {
                return new Double(((Float)object).floatValue());
            }

            @Override
            public boolean canConvert(Object object) {
                return true;
            }

            public String toString() {
                return "float:double";
            }
        };
        protected static Conversion number2bool = new Conversion(){

            @Override
            public Object convert(Object object) {
                return new Boolean(((Number)object).longValue() != 0L);
            }

            @Override
            public boolean canConvert(Object object) {
                return true;
            }

            public String toString() {
                return "number:bool";
            }
        };
        protected static Conversion obj2bool = new Conversion(){

            @Override
            public Object convert(Object object) {
                return new Boolean(object != null);
            }

            @Override
            public boolean canConvert(Object object) {
                return true;
            }

            public String toString() {
                return "obj:bool";
            }
        };
        protected static Conversion charSequence2String = new Conversion(){

            @Override
            public Object convert(Object object) {
                return object.toString();
            }

            @Override
            public boolean canConvert(Object object) {
                return true;
            }

            public String toString() {
                return "CharSequence:String";
            }
        };
        protected static Conversion charSeq2char = new Conversion(){

            @Override
            public Object convert(Object object) {
                return new Character(((CharSequence)object).charAt(0));
            }

            @Override
            public boolean canConvert(Object object) {
                return ((CharSequence)object).length() == 1;
            }

            public String toString() {
                return "CharSequence:char";
            }
        };
        protected static Conversion list2array = new Conversion(){

            @Override
            public Object convert(Object object) {
                List list = (List)object;
                Object e = list.get(0);
                int n = list.size();
                Class<?> clazz = e.getClass();
                Object[] objectArray = (Object[])Array.newInstance(clazz, n);
                int n2 = -1;
                for (Object e2 : list) {
                    objectArray[++n2] = e2;
                }
                return objectArray;
            }

            @Override
            public boolean canConvert(Object object) {
                return true;
            }

            public String toString() {
                return "obj:obj";
            }
        };
        protected static Conversion obj2obj = new Conversion(){

            @Override
            public Object convert(Object object) {
                return object;
            }

            @Override
            public boolean canConvert(Object object) {
                return true;
            }

            public String toString() {
                return "obj:obj";
            }
        };

        private Conversions() {
        }
    }

    private static interface Conversion {
        public Object convert(Object var1);

        public boolean canConvert(Object var1);
    }
}

