/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.stateMGen;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.script.ScriptException;
import org.vishia.cmd.JZtxtcmdExecuter;
import org.vishia.jztxtcmd.JZtxtcmd;
import org.vishia.mainCmd.MainCmdLogging_ifc;
import org.vishia.mainCmd.MainCmd_ifc;
import org.vishia.states.StateComposite;
import org.vishia.states.StateCompositeFlat;
import org.vishia.states.StateMachine;
import org.vishia.states.StateParallel;
import org.vishia.states.StateSimple;
import org.vishia.util.DataAccess;
import org.vishia.util.DataShow;
import org.vishia.zbnf.ZbnfJavaOutput;
import org.vishia.zcmd.Zbnf2Text;

public class StateMGen {
    public static final String sVersion = "2014-06-26";
    final MainCmd_ifc console;
    GenStateMachine genStm;

    public static void main(String[] stringArray) {
        Zbnf2Text.Args args = new Zbnf2Text.Args();
        Zbnf2Text.CmdLineText cmdLineText = new Zbnf2Text.CmdLineText(args, stringArray);
        boolean bl = true;
        try {
            cmdLineText.parseArguments();
        }
        catch (Exception exception) {
            cmdLineText.setExitErrorLevel(5);
            bl = false;
        }
        if (bl) {
            StateMGen stateMGen = new StateMGen(cmdLineText);
            try {
                stateMGen.execute(args);
            }
            catch (Exception exception) {
                stateMGen.console.report("Uncatched Exception on main level:", exception);
                stateMGen.console.setExitErrorLevel(3);
            }
        }
        cmdLineText.exit();
    }

    public StateMGen(MainCmd_ifc mainCmd_ifc) {
        this.console = mainCmd_ifc;
    }

    void execute(Zbnf2Text.Args args) throws IOException, IllegalAccessException {
        ZbnfResultData zbnfResultData = this.parseAndStoreInput(args);
        if (zbnfResultData != null) {
            FileWriter fileWriter;
            if (args.sFileSrcData != null) {
                fileWriter = new FileWriter(args.sFileSrcData);
                if (args.sFileSrcData.endsWith(".html") || args.sFileSrcData.endsWith(".htm")) {
                    DataShow.outHtml(zbnfResultData, fileWriter);
                } else if (args.sFileSrcData.endsWith(".xml")) {
                    DataShow.dataTreeXml(zbnfResultData, fileWriter, 20);
                } else {
                    DataShow.dataTree(zbnfResultData, fileWriter, 20);
                }
                ((Writer)fileWriter).close();
            }
            this.prepareStateData(zbnfResultData);
            if (args.sFileSrcData != null) {
                Object object;
                if (args.sFileSrcData.endsWith(".html")) {
                    object = args.sFileSrcData.substring(0, args.sFileSrcData.length() - 5) + ".dst.html";
                    fileWriter = new FileWriter((String)object);
                    DataShow.outHtml(this.genStm, fileWriter);
                } else if (args.sFileSrcData.endsWith(".htm")) {
                    object = args.sFileSrcData.substring(0, args.sFileSrcData.length() - 4) + ".dst.htm";
                    fileWriter = new FileWriter((String)object);
                    DataShow.dataTreeXml(this.genStm, fileWriter, 20);
                } else if (args.sFileSrcData.endsWith(".xml")) {
                    object = args.sFileSrcData.substring(0, args.sFileSrcData.length() - 4) + ".dst.xml";
                    fileWriter = new FileWriter((String)object);
                    DataShow.dataTreeXml(this.genStm, fileWriter, 20);
                } else {
                    object = args.sFileSrcData + ".dst";
                    fileWriter = new FileWriter((String)object);
                    DataShow.dataTree(this.genStm, fileWriter, 20);
                }
                ((Writer)fileWriter).close();
            }
            fileWriter = args.sScriptCheck != null ? new FileWriter(args.sScriptCheck) : null;
            for (Zbnf2Text.Out out : args.listOut) {
                File file;
                File file2 = new File(out.sFileOut);
                File file3 = new File(out.sFileScript);
                File file4 = file = args.sScriptCheck == null ? null : new File(args.sScriptCheck);
                if (fileWriter != null) {
                    fileWriter.append("===================").append(out.sFileScript);
                }
                FileWriter fileWriter2 = new FileWriter(file2);
                JZtxtcmdExecuter jZtxtcmdExecuter = new JZtxtcmdExecuter(this.console);
                LinkedList<DataAccess.Variable<Object>> linkedList = new LinkedList<DataAccess.Variable<Object>>();
                linkedList.add(new DataAccess.Variable<String>('S', "sOutfile", file2.getAbsolutePath(), true));
                linkedList.add(new DataAccess.Variable<GenStateMachine>('O', "stm", this.genStm, true));
                try {
                    JZtxtcmd.execute(jZtxtcmdExecuter, file3, (Appendable)fileWriter2, linkedList, this.console.currdir(), true, file, (MainCmdLogging_ifc)this.console);
                    this.console.writeInfoln("SUCCESS outfile: " + file2.getAbsolutePath());
                }
                catch (ScriptException scriptException) {
                    this.console.writeError(scriptException.getMessage());
                }
                ((Writer)fileWriter2).close();
            }
            if (fileWriter != null) {
                fileWriter.close();
            }
        } else {
            this.console.writeInfoln("ERROR");
        }
    }

    void prepareStateData(ZbnfResultData zbnfResultData) {
        this.genStm = new GenStateMachine(zbnfResultData);
        StateMachine.StateCompositeTop stateCompositeTop = this.genStm.stateTop();
        stateCompositeTop.setAuxInfo(new GenStateInfo(null));
        this.genStm.rootStates.add(stateCompositeTop);
        this.gatherStatesOfComposite(stateCompositeTop, stateCompositeTop, zbnfResultData);
        this.gatherAllTransitions();
        this.genStm.prepare();
    }

    StateCompositeFlat gatherStatesOfComposite(StateCompositeFlat stateCompositeFlat, StateComposite stateComposite, ZbnfStateCompositeBase zbnfStateCompositeBase) {
        GenStateInfo genStateInfo = (GenStateInfo)stateComposite.auxInfo();
        assert (genStateInfo != null);
        for (ZbnfState zbnfState : zbnfStateCompositeBase.subStates) {
            StateSimple stateSimple;
            if (zbnfState.isPrepared) continue;
            if (zbnfState.subStates != null && zbnfState.subStates.size() > 0) {
                StateSimple stateSimple2;
                if (zbnfState.stateParallel) {
                    stateSimple2 = new GenStateParallel(stateCompositeFlat, stateComposite, this.genStm, zbnfState);
                    stateSimple = this.gatherStatesOfParallel((StateParallel)stateSimple2, stateComposite, zbnfState);
                } else {
                    StateComposite stateComposite2;
                    if (zbnfState.hasHistory) {
                        stateSimple2 = new GenStateComposite(stateCompositeFlat, stateComposite, this.genStm, zbnfState);
                        stateComposite2 = (StateComposite)stateSimple2;
                        this.genStm.rootStates.add(stateComposite2);
                    } else {
                        stateSimple2 = new GenStateCompositeFlat(stateCompositeFlat, stateComposite, this.genStm, zbnfState);
                        stateComposite2 = stateComposite;
                    }
                    stateSimple = this.gatherStatesOfComposite((StateCompositeFlat)stateSimple2, stateComposite2, zbnfState);
                }
            } else {
                stateSimple = new GenStateSimple(stateCompositeFlat, stateComposite, this.genStm, zbnfState);
            }
            stateCompositeFlat.addState(stateSimple.hashCode(), stateSimple);
            this.genStm.allStates.put(stateSimple.getName(), stateSimple);
            this.genStm.listStates.add(stateSimple);
        }
        return stateCompositeFlat;
    }

    StateParallel gatherStatesOfParallel(StateParallel stateParallel, StateComposite stateComposite, ZbnfStateCompositeBase zbnfStateCompositeBase) {
        GenStateInfo genStateInfo = (GenStateInfo)stateComposite.auxInfo();
        assert (genStateInfo != null);
        for (ZbnfState zbnfState : zbnfStateCompositeBase.subStates) {
            StateSimple stateSimple;
            if (zbnfState.isPrepared) continue;
            if (zbnfState.subStates != null && zbnfState.subStates.size() > 0) {
                if (zbnfState.stateParallel) {
                    throw new IllegalArgumentException("the next level of StateParallel cannot be a StateParallel");
                }
                StateComposite stateComposite2 = null;
                GenStateComposite genStateComposite = new GenStateComposite(stateParallel, stateComposite2, this.genStm, zbnfState);
                StateComposite stateComposite3 = genStateComposite;
                this.genStm.rootStates.add(stateComposite3);
                stateSimple = this.gatherStatesOfComposite(genStateComposite, stateComposite3, zbnfState);
            } else {
                stateSimple = new GenStateSimple(stateParallel, stateComposite, this.genStm, zbnfState);
            }
            stateParallel.addState(stateSimple.hashCode(), stateSimple);
            this.genStm.allStates.put(stateSimple.getName(), stateSimple);
            this.genStm.listStates.add(stateSimple);
        }
        return stateParallel;
    }

    void gatherAllTransitions() {
        for (StateSimple stateSimple : this.genStm.listStates) {
            int n;
            StateSimple.PlugStateSimpleToGenState plugStateSimpleToGenState = new StateSimple.PlugStateSimpleToGenState(stateSimple);
            GenStateInfo genStateInfo = (GenStateInfo)stateSimple.auxInfo();
            ZbnfState zbnfState = genStateInfo.zsrcState;
            if (zbnfState.trans == null || zbnfState.trans.size() <= 0 || (n = zbnfState.trans.size()) <= 0) continue;
            plugStateSimpleToGenState.createTransitions(n);
            for (ZbnfTrans zbnfTrans : zbnfState.trans) {
                Object object;
                Object object2;
                Object object3;
                int n2 = zbnfTrans.dstStates != null ? 1 + zbnfTrans.dstStates.size() : 1;
                int[] nArray = new int[n2];
                int n3 = -1;
                if (zbnfTrans.dstStates != null) {
                    object3 = zbnfTrans.dstStates.iterator();
                    while (object3.hasNext()) {
                        object2 = object3.next();
                        object = this.genStm.allStates.get(object2);
                        if (object == null) {
                            throw new IllegalArgumentException("faulty dst state in transition;" + (String)object2 + "; from state " + stateSimple.getName());
                        }
                        nArray[++n3] = object.hashCode();
                    }
                }
                if ((object3 = this.genStm.allStates.get(zbnfTrans.dstState)) == null) {
                    throw new IllegalArgumentException("faulty dst state in transition;" + zbnfTrans.dstState + "; from state " + stateSimple.getName());
                }
                nArray[++n3] = object3.hashCode();
                if (zbnfTrans.joinStates != null) {
                    StateSimple stateSimple2 = stateSimple;
                    stateSimple2.getClass();
                    object2 = new StateSimple.TransJoin(stateSimple2, "Trans_" + stateSimple.getName() + zbnfTrans.nrTrans, nArray);
                    object = new int[zbnfTrans.joinStates.size()];
                    int n4 = -1;
                    for (String string : zbnfTrans.joinStates) {
                        StateSimple stateSimple3 = this.genStm.allStates.get(string);
                        if (stateSimple3 == null) {
                            throw new IllegalArgumentException("faulty join state in transition;" + string + "; from state " + stateSimple.getName());
                        }
                        object[++n4] = stateSimple3.hashCode();
                    }
                    ((StateSimple.TransJoin)object2).srcStates((int[])object);
                } else {
                    object2 = new GenStateTrans(zbnfTrans, stateSimple, nArray);
                }
                if (zbnfTrans.time != null) {
                    genStateInfo.timeCondition = zbnfTrans.time;
                    object = (GenStateInfo)stateSimple.compositeState().auxInfo();
                    ((GenStateInfo)object).hasTimer = true;
                }
                plugStateSimpleToGenState.addTransition((StateSimple.Trans)object2);
            }
        }
    }

    private ZbnfResultData parseAndStoreInput(Zbnf2Text.Args args) {
        ZbnfResultData zbnfResultData = new ZbnfResultData();
        File file = new File(args.sFileIn);
        File file2 = new File(args.sFileSyntax);
        String string = ZbnfJavaOutput.parseFileAndFillJavaObject(zbnfResultData.getClass(), zbnfResultData, file, file2, this.console, 1200);
        if (string != null) {
            this.console.writeError("ERROR Parsing file: " + file.getAbsolutePath() + "\n" + string);
            return null;
        }
        this.console.writeInfoln("SUCCESS parsed: " + file.getAbsolutePath());
        return zbnfResultData;
    }

    void stop() {
    }

    static class GenStateTrans
    extends StateSimple.Trans {
        public final ZbnfTrans zsrcTrans;

        GenStateTrans(ZbnfTrans zbnfTrans, StateSimple stateSimple, int[] nArray) {
            StateSimple stateSimple2 = stateSimple;
            stateSimple2.getClass();
            super(stateSimple2, "Trans_" + stateSimple.getName() + zbnfTrans.nrTrans, nArray);
            this.zsrcTrans = zbnfTrans;
        }
    }

    static class GenStateParallel
    extends StateParallel {
        GenStateParallel(StateSimple stateSimple, StateComposite stateComposite, GenStateMachine genStateMachine, ZbnfState zbnfState) {
            super(zbnfState.stateName, genStateMachine, zbnfState.nrofSubstates == 0 ? null : new StateComposite[zbnfState.nrofSubstates]);
            super.setAuxInfo(new GenStateInfo(zbnfState));
            this.enclState = stateSimple;
            this.compositeState = stateComposite;
            this.stateId = zbnfState.stateName;
        }
    }

    static class GenStateComposite
    extends StateComposite {
        GenStateComposite(StateSimple stateSimple, StateComposite stateComposite, GenStateMachine genStateMachine, ZbnfState zbnfState) {
            super(zbnfState.stateName, genStateMachine, zbnfState.nrofSubstates == 0 ? null : new StateSimple[zbnfState.nrofSubstates]);
            super.setAuxInfo(new GenStateInfo(zbnfState));
            this.enclState = stateSimple;
            this.compositeState = stateComposite;
            this.stateId = zbnfState.stateName;
        }
    }

    static class GenStateCompositeFlat
    extends StateCompositeFlat {
        GenStateCompositeFlat(StateCompositeFlat stateCompositeFlat, StateComposite stateComposite, GenStateMachine genStateMachine, ZbnfState zbnfState) {
            super(zbnfState.stateName, genStateMachine, zbnfState.nrofSubstates == 0 ? null : new StateSimple[zbnfState.nrofSubstates]);
            super.setAuxInfo(new GenStateInfo(zbnfState));
            this.enclState = stateCompositeFlat;
            this.compositeState = stateComposite;
            this.stateId = zbnfState.stateName;
        }
    }

    static class GenStateSimple
    extends StateSimple {
        GenStateSimple(StateSimple stateSimple, StateComposite stateComposite, StateMachine stateMachine, ZbnfState zbnfState) {
            super.setAuxInfo(new GenStateInfo(zbnfState));
            this.enclState = stateSimple;
            this.compositeState = stateComposite;
            this.stateMachine = stateMachine;
            this.stateId = zbnfState.stateName;
        }
    }

    static class GenStateInfo {
        public final ZbnfState zsrcState;
        public String timeCondition;
        public boolean hasTimer;

        public GenStateInfo(ZbnfState zbnfState) {
            this.zsrcState = zbnfState;
        }
    }

    public static class GenStateMachine
    extends StateMachine {
        public final ZbnfResultData zbnfSrc;
        public final List<StateComposite> rootStates = new LinkedList<StateComposite>();
        public final List<StateSimple> listStates = new LinkedList<StateSimple>();
        Map<String, StateSimple> allStates = new TreeMap<String, StateSimple>();

        GenStateMachine(ZbnfResultData zbnfResultData) {
            super(new StateSimple[zbnfResultData.subStates.size()]);
            this.zbnfSrc = zbnfResultData;
        }

        StateMachine.StateCompositeTop stateTop() {
            return this.stateTop;
        }

        void prepare() {
            this.stateTop.prepare();
        }
    }

    public static class ZbnfResultData
    extends ZbnfStateCompositeBase {
        public XXXStateStructure stateStructure;
        public List<String> includeLines = new LinkedList<String>();
        public List<String> statefnargs = new LinkedList<String>();
        public StringBuilder formalArgs;
        public StringBuilder callingArgs;
        private final Map<String, String> idxStateVariables = new HashMap<String, String>();
        final Map<String, String> variables = new TreeMap<String, String>();

        public ZbnfNameValue new_variable() {
            return new ZbnfNameValue();
        }

        public void add_variable(ZbnfNameValue zbnfNameValue) {
            this.variables.put(zbnfNameValue.name, zbnfNameValue.value);
        }

        public void set_statefnarg(String string) {
            string = string.trim();
            int n = string.lastIndexOf(32) + 1;
            String string2 = string.substring(n);
            this.statefnargs.add(string);
            if (this.formalArgs == null) {
                this.formalArgs = new StringBuilder(string);
                this.callingArgs = new StringBuilder(string2);
            } else {
                this.formalArgs.append(", ").append(string);
                this.callingArgs.append(", ").append(string2);
            }
        }

        public void set_includeLine(String string) {
            this.includeLines.add(string);
        }
    }

    public static class ZbnfNameValue {
        public String name;
        public String value;
    }

    public static class ZbnfDstState {
        public String name;
        private List<ZbnfDstState> entrySubStates;

        public String toString() {
            return this.name;
        }
    }

    public static class ZbnfTrans {
        public String description;
        public int nrTrans = 0;
        public String additionaldescription;
        public String tododescription;
        public String cond;
        public String time;
        private List<String> joinStatesSrc;
        public List<String> joinStates;
        public String event;
        public String code;
        private final List<ZbnfTrans> subCondition = new LinkedList<ZbnfTrans>();
        private ZbnfDstState dstStateTree;
        public List<String> dstStates;
        public String dstState;

        public ZbnfTrans new_subCondition() {
            return new ZbnfTrans();
        }

        public void add_subCondition(ZbnfTrans zbnfTrans) {
            this.subCondition.add(zbnfTrans);
        }

        public void set_dstState(String string) {
            this.dstState = string;
        }

        public void set_fork() {
            if (this.dstStates == null) {
                this.dstStates = new LinkedList<String>();
            }
            this.dstStates.add(this.dstState);
            this.dstState = null;
        }

        public void set_condP(String string) {
            int n = string.lastIndexOf(41);
            this.cond = n > 0 ? string.substring(0, n) : string;
        }

        public void set_timeP(String string) {
            int n = string.lastIndexOf(41);
            this.time = n > 0 ? string.substring(0, n) : string;
        }

        public void set_joinState(String string) {
            if (this.joinStatesSrc == null) {
                this.joinStatesSrc = new LinkedList<String>();
            }
            this.joinStatesSrc.add(string);
        }

        public void set_history() {
        }

        public ZbnfJoinState new_joinState() {
            return new ZbnfJoinState();
        }

        public void add_joinState(ZbnfJoinState zbnfJoinState) {
            if (this.joinStates == null) {
                this.joinStates = new LinkedList<String>();
            }
            this.joinStates.add(zbnfJoinState.name);
        }
    }

    public static class ZbnfJoinState {
        public String name;
    }

    public static class ZbnfExit {
        public String description;
        public String additionaldescription;
        public String tododescription;
        public String code;
    }

    public static class ZbnfEntry {
        public String description;
        public String additionaldescription;
        public String tododescription;
        public String code;
    }

    public static class ZbnfState
    extends ZbnfStateCompositeBase {
        public String stateName;
        public String stateNr;
        public boolean stateParallel;
        public String description;
        public String shortdescription;
        public String additionaldescription;
        public String tododescription;
        public boolean hasHistory;
        public ZbnfEntry entry;
        public ZbnfExit exit;
        public ZbnfEntry instate;
        public List<ZbnfTrans> trans;
        boolean isPrepared = false;

        public ZbnfEntry new_instate() {
            return new ZbnfEntry();
        }

        public void set_instate(ZbnfEntry zbnfEntry) {
            this.instate = zbnfEntry;
        }

        public void set_hasHistory() {
            this.hasHistory = true;
        }

        public String toString() {
            return this.stateName;
        }
    }

    public static class ZbnfStateCompositeBase {
        List<ZbnfState> subStates;
        int nrofSubstates;
        final Map<String, ZbnfState> XXXidxSrcStates = new TreeMap<String, ZbnfState>();

        public ZbnfState new_state() {
            return new ZbnfState();
        }

        public void add_state(ZbnfState zbnfState) {
            ++this.nrofSubstates;
            if (this.subStates == null) {
                this.subStates = new ArrayList<ZbnfState>();
            }
            this.subStates.add(zbnfState);
            this.XXXidxSrcStates.put(zbnfState.stateName, zbnfState);
        }
    }

    public static class ZbnfConstDef {
        public String description;
        public List<String> ident;
        public String code;
    }

    public static class XXXStateStructure {
        public final List<XXXCompositeState> compositeStates = new LinkedList<XXXCompositeState>();

        public XXXCompositeState new_CompositeState() {
            return new XXXCompositeState();
        }

        public void add_CompositeState(XXXCompositeState xXXCompositeState) {
            this.compositeStates.add(xXXCompositeState);
        }
    }

    public static class XXXParallelState
    extends XXXCompositeState {
    }

    public static class XXXCompositeState {
        public String stateName;
        public String description;
        public List<XXXSimpleState> simpleState;
        public List<XXXCompositeState> compositeState;
        public List<XXXParallelState> parallelState;
    }

    public static class XXXSimpleState {
        public String stateName;
        public String enclState;
        public String description;
    }
}

