/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.msgDispatch;

import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.vishia.bridgeC.OS_TimeStamp;
import org.vishia.bridgeC.Va_list;
import org.vishia.msgDispatch.LogMessage;

public class LogMessageStream
implements LogMessage {
    public static final int version = 20120702;
    final FileDescriptor fd;
    final OutputStream out;
    byte[] sNewLine = new byte[]{13, 10};
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("MMM-dd HH:mm:ss.SSS: ");

    public static LogMessage create(FileDescriptor fileDescriptor) {
        return new LogMessageStream(fileDescriptor);
    }

    public LogMessageStream(FileDescriptor fileDescriptor) {
        this.fd = fileDescriptor;
        this.out = new FileOutputStream(fileDescriptor);
    }

    public LogMessageStream(OutputStream outputStream) {
        this.out = outputStream;
        this.fd = null;
    }

    @Override
    public boolean sendMsgVaList(int n, OS_TimeStamp oS_TimeStamp, String string, Va_list va_list) {
        String string2 = "?";
        try {
            string2 = this.dateFormat.format(oS_TimeStamp) + "; " + n + "; " + String.format(string, va_list.get());
        }
        catch (Exception exception) {
            string2 = this.dateFormat.format(oS_TimeStamp) + "; " + n + "; " + string;
        }
        try {
            this.out.write(string2.getBytes());
            this.out.write(this.sNewLine);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean isOnline() {
        return true;
    }

    @Override
    public boolean sendMsg(int n, String string, Object ... objectArray) {
        String string2 = this.dateFormat.format(new Date(System.currentTimeMillis())) + "; " + n + "; " + String.format(string, objectArray);
        try {
            this.out.write(string2.getBytes());
            this.out.write(this.sNewLine);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    @Override
    public boolean sendMsgTime(int n, OS_TimeStamp oS_TimeStamp, String string, Object ... objectArray) {
        String string2 = this.dateFormat.format(oS_TimeStamp) + "; " + n + "; " + String.format(string, objectArray);
        try {
            this.out.write(string2.getBytes());
            this.out.write(this.sNewLine);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }
}

