/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.jztxtcmd;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import org.vishia.cmd.CmdExecuter;
import org.vishia.cmd.JZtxtcmdEngine;
import org.vishia.cmd.JZtxtcmdExecuter;
import org.vishia.cmd.JZtxtcmdScript;
import org.vishia.mainCmd.MainCmd;
import org.vishia.mainCmd.MainCmdLoggingStream;
import org.vishia.mainCmd.MainCmdLogging_ifc;
import org.vishia.util.DataAccess;
import org.vishia.util.FileSystem;
import org.vishia.util.StringFormatter;
import org.vishia.util.StringPartFromFileLines;
import org.vishia.util.StringPartScan;
import org.vishia.xmlSimple.SimpleXmlOutputter;
import org.vishia.xmlSimple.XmlNode;
import org.vishia.zbnf.ZbnfJavaOutput;
import org.vishia.zbnf.ZbnfParser;

public class JZtxtcmd
implements JZtxtcmdEngine,
Compilable {
    public static final String version = "2019-02-20";
    final ZbnfParser parserGenCtrl;
    final MainCmdLogging_ifc log;

    public static void main(String[] stringArray) {
        try {
            int n = JZtxtcmd.smain(stringArray);
            System.exit(n);
        }
        catch (Exception exception) {
            Throwable throwable = exception.getCause();
            if (throwable == null) {
                throwable = exception;
            }
            System.err.println("JZcmd.main() - uncaught ERROR; ");
            throwable.printStackTrace(System.err);
            System.exit(3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static int smain(String[] stringArray) throws ScriptException {
        String string = null;
        Args args = new Args();
        CmdLine cmdLine = new CmdLine(args, stringArray);
        cmdLine.setReportLevel(0);
        try {
            cmdLine.parseArguments();
        }
        catch (Exception exception) {
            string = "JZcmd - Argument error ;" + exception.getMessage();
            cmdLine.report(string, exception);
            cmdLine.setExitErrorLevel(5);
        }
        if (args.sFileScript == null) {
            cmdLine.writeHelpInfo(null);
        } else if (string == null) {
            Object object;
            File file = new File(args.sFileScript);
            int n = 1;
            JZtxtcmdExecuter jZtxtcmdExecuter = new JZtxtcmdExecuter(cmdLine);
            TreeMap<String, DataAccess.Variable<Object>> treeMap = args.userArgs.size() > 0 ? new TreeMap<String, DataAccess.Variable<Object>>() : null;
            try {
                for (String object22 : args.userArgs) {
                    DataAccess.createOrReplaceVariable(treeMap, "$" + n, 'S', object22, true);
                    ++n;
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ScriptException("JZcmd.smain - cannot set user argument; " + n);
            }
            Object object3 = null;
            Object var9_12 = null;
            if (args.sFileTextOut != null) {
                object = null;
                try {
                    object = new File(args.sFileTextOut);
                    object3 = new FileWriter((File)object);
                    FileWriter fileWriter = object3;
                }
                catch (IOException iOException) {
                    string = "JZcmd - cannot create output text file," + ((File)object).getAbsolutePath();
                }
            } else {
                PrintStream printStream = System.out;
            }
            if (string == null) {
                void var9_16;
                object = cmdLine.currdir();
                JZtxtcmd.execute(jZtxtcmdExecuter, file, (Appendable)var9_16, treeMap, (String)object, true, args.fileTestXml, (MainCmdLogging_ifc)cmdLine);
            }
            if (object3 != null) {
                try {
                    ((OutputStreamWriter)object3).close();
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
            if (string != null) {
                cmdLine.writeError(string);
            }
        }
        return cmdLine.getExitErrorLevel();
    }

    public JZtxtcmd() throws ScriptException {
        this(null);
    }

    public JZtxtcmd(MainCmdLogging_ifc mainCmdLogging_ifc) throws ScriptException {
        this.log = mainCmdLogging_ifc == null ? new MainCmdLoggingStream(System.out) : mainCmdLogging_ifc;
        this.parserGenCtrl = new ZbnfParser(this.log);
        try {
            this.parserGenCtrl.setSyntax(" $comment=(?...?).\n $endlineComment=\\#\\#.  ##The ## is the start chars for an endline-comment or commented line in the generator script.\n $keywords= new | cmd | cmd_check | start \n   | debug | java \n   | stdout | stdin | stderr \n   | subtext | sub | main | call | cd | CD | REM | Rem | rem \n   | Pipe | StringBuffer | Stringjar | String | List | Openfile | Fileset | Obj | Set | set | include | zbatch \n   | break | XXXreturn | exit | onerror | instanceof | for | while | do | if | elsif | else | not | NOT | and | AND | or | OR \n   | throw . \n \n JZtxtcmd::= \n [<*|==JZtxtcmd==?>==JZtxtcmd== ]\n [<*|==JZcmd==?>==JZcmd== ]\n [{ ! checkjzTc = <textValue?checkJZcmdFile> ; \n  | ! checkJZcmd = <textValue?checkJZcmdFile> ; \n  | ! checkXml = <textValue?checkXmlFile> ; \n }]\n [{ [REM|Rem|rem] <*\\n\\r?> ##Remark like in batch files\n  | include <include> ; \n  | currdir = <textDatapath?cd> ;\n }] \n { [//] ==endJZcmd==<*\\e?> \n | [REM|Rem|rem] <*\\n\\r?> ##Remark like in batch files\n | //JZtxtcmd       ##ignore //JZtxtcmd, it may be a comment for another language\n | //JZcmd      ##ignore //JZcmd, it may be a comment for another language\n | //<*\\n\\r?> ##line comment in C style\n | /*<*|*/?>*/ ##block commment in C style\n | <DefVariable?> ; \n | <statement?>\n | subtext  <subtext?subroutine> \n | sub <subroutine> \n | class <subClass> \n | main ( ) \\{ <statementBlock?mainRoutine> \\} \n } \\e.\n \n \n include::= [$<$?envVar>[/|\\\\]][ <\"\"?path> | <*;\\ ?path>].\n \n \n subClass::= <$?name> \\{ \n { <DefVariable?> ; \n | subtext  <subtext?subroutine> \n | sub <subroutine> \n | class <subClass> \n } \\}. \n \n \n subroutine::= <$?name> [( [ use-locals<?useLocals> | { add-locals<?addLocals> | <DefVariable?formalArgument> ? , } |] ) [=] | = <?useLocals>] \\{ [<statementBlock>] \\}. \n \n subtext::= <$?name> [( [ use-locals<?useLocals> | { add-locals<?addLocals> | <DefVariable?formalArgument> ? , } |] ) [=] | = <?useLocals>]  \\<:\\><textExpr>\\<\\.\\>.\n \n \n statementBlock::= { <statement?> }.\n \n statement::=\n   \\{ [<statementBlock>] \\} \n | REM <*\\n\\r?> ##Remark like in batch files\n | ::{:}                ##Skip over :::\n | =={=}                ##Skip over :::\n | //JZtxtcmd       ##ignore //JZtxtcmd, it may be a comment for another language\n | //JZcmd      ##ignore //JZcmd, it may be a comment for another language\n | //<*|\\n|\\r|\\<+?>     ##line commment in C style but only till <+\n | /*<*|*/?>*/          ##block commment in C style\n | text = <objExpr?createTextOut> ;    ##set text output\n | currdir = <textDatapath?cd> ;   ##set current directory\n | [cd|CD] [<textValue?cd> | <*\\ ;?cd> ; ]  ##change current directory \n | mkdir <textValue?mkdir> ;                 ##create any directory if not exists \n | <DefVariable?> ; \n | for <forCtrl> \n | if <ifCtrl> \n | while <whileCtrl> \n | do <dowhileCtrl> \n | start <cmdLine?cmdStart> \n | zmake <zmake> \n | move <srcdst?move> ; \n | copy <srcdst?copy> ; \n | [rm|del] <oneArg?del> ; \n | break <?breakBlock> ; \n | return <?return> ; \n | exit <#?exitScript> ;\n | throw on errorlevel <#?throwonerror> \n | throw <textDatapath?throw> \n | onerror <onerror> \n | errortoOutput off <?errorToOutput=0> \n | errortoOutput <?errorToOutput=1> \n | if errorlevel <iferrorlevel> \n | debug [<textValue?debug>| <?debug>] ; \n | debugOp <textValue?debugOp> ; \n | <callSubroutine?call> \n | <threadBlock> \n | \\<+:create\\><textExpr?createTextOut>\\<\\.+\\> \n | \\<+:append\\><textExpr?appendTextOut>\\<\\.+\\> \n | \\<+ <textOut> \n | \\<:\\><textExpr?.indent=-3>\\<\\.\\> [;] \n | <cmdLineWait?cmdWait> \n | <assignExpr> \n | ; \n .\n \n \n srcdst::= [{ -n<?newTimestamp>| -w<?overwr> | -r<overwro>}] [ src=] <textValue?src> [ dst=] <textValue?dst> .\n oneArg::= <textValue?src> .\n \n \n DefVariable::=\n   String\\  <DefStringVar?textVariable> \n | Stringjar\\  <DefSpecVar?Stringjar> \n | Num\\  <DefNumVar> \n | Bool\\  <DefBoolVar> \n | Pipe\\  <DefSpecVar?Pipe> \n | List\\  <DefList?List> \n | Map\\  <DefMapVar> \n | Obj\\  <DefObjVar> \n | Class\\  <DefClassVar> \n | Classpath\\  <DefClasspath> \n | Openfile\\  <Openfile> \n | Fileset\\  <DefFileset> \n | Filepath\\ <DefFilepath> \n | Subtextvar\\ <subtext?DefSubtext> \n | Subroutinevar\\ <subroutine?DefSubtext> \n | Set\\  <DefStringVar?setEnvVar> \n | set\\  <DefStringVar?setEnvVar> \n | SET\\  <DefStringVar?setEnvVar> \n .\n \n DefNumVar::= [const <?const>] <definePath?defVariable>  [ = <numExpr>].\n \n DefBoolVar::= [const <?const>] <definePath?defVariable>  [ = <boolExpr>].\n \n DefList::= [const <?const>] <definePath?defVariable>  \n[ = \\[ {<?element> \\{ <dataStruct?dataSet> \\} ? , } \\]  ##some { dataSet, ...} \n| = \\[ <dataStruct?>   \\]  ##some String or variable (const) definitions in the container.\n| = <objExpr?> [!;]\n| = \\[ { <objExpr?objElement> ? , } \\]\n|].\n \n DefSpecVar::= [const <?const>] <definePath?defVariable>  [ = <objExpr?>].\n \n DefObjVar::= [const <?const>] <definePath?defVariable> [ : <$\\.?type>]  [ = <objExpr?>].\n \n DefClassVar::= [const] <definePath?defVariable>  = \n   [: <dataAccess?loader> : ]  ## a datapath to a ClassLoader instance, a Classpath variable. \n   <textValue?>.               ## The package path maybe contained in any expression\n \n DefClasspath::= [const] <definePath?defVariable>  = [ : <$?parentClasspath> : ] { <filesetAccess> ? , }.\n \n DefStringVar::= [const <?const>] <definePath?defVariable> [ = <textDatapath?>].\n \n DefMapVar::= [const <?const>] <definePath?defVariable> [ = \\{ <dataStruct> \\}  ].\n \n Openfile::= [const <?const>] <definePath?defVariable> = <textDatapath?> .\n \n \n definePath::= <$-?startVariable>[ [?\\. \\>] \\.{ <defineSubelement?datapathElement> ? [?\\. \\>] \\.}].\n \n defineSubelement::= <$-?ident> [( [{ <objExpr?argument> ? ,}])<?whatisit=(>].\n \n \n DefFileset::= <definePath?defVariable> [ =  ( \n [ commonpath = [<\"\"?commonPath>|<*;,)(\\ \\r\\n?commonPath>] , ] \n { [{ //JZcmd | //JZtxtcmd | //<*\\n\\r?>}] \n     [ <\"\"?filePath>             ##filePath in \"\"\n     | <*;,)(\\ \\r\\n?filePath>   ##filePath without \"\"\n     ]    [{ //JZcmd | //<*\\n\\r?>}] ? , } \n ) ] .\n \n DefFilepath::= <definePath?defVariable> [ = <textValue?> ]. \n \n \n \n \n XXXFilepath::=<\"\"?!prepFilePath>|<*;\\ \\r\\n,)?!prepFilePath>. \n \n prepFilePath::=<$NoWhiteSpaces><! *?>\n [ &$<$?@envVariable> [\\\\|/|]      ##path can start with a environment variable's content\n | &<$?@scriptVariable> [\\\\|/|]    ##path can start with a scriptvariable's content\n | [<!.?@drive>:]                  ## only 1 char with followed : is the drive letter\n   [ [/|\\\\]<?@absPath>]            ## starting with / maybe after d: is absolute path\n |]\n [ <*:?@pathbase>[?:=]:]           ## all until : is pathbase, but not till a :=\n [ <toLastChar:/\\\\?@path>[\\\\|/|]] ## all until last \\ or / is path\n [ <toLastChar:.?@name>              ## all until exclusive dot is the name\n   <*\\e?@ext>                       ## from dot to end is the extension\n | <*\\e?@name>                      ## No dot is found, all is the name.\n ] . \n \n \n \n \n \n textDatapath::=  <\"\"?text> | \\<:\\><textExpr>\\<\\.\\> | [& [?(] ] <dataAccess> .\n \n textValue::=  <\"\"?text> | \\<:\\><textExpr>\\<\\.\\> | & <dataAccess> | <*;,)(\\ \\r\\n\\>?text> .\n \n textValueTextExpr::=  <\"\"?text> | \\<:\\><textExpr>\\<\\.\\> | & <dataAccess> | <*:;,)(\\ \\r\\n\\>?text> .\n \n \n objExpr::= \n   Filepath : <textValue?Filepath> ## A textValue which builds a Filepath in the currdir \n | Fileset : <filesetAccess>  \n | \\{ <dataStruct> \\}              ## It is a Map of Variables. \n | <\"\"?text>                       ## It is a constant text. \n | \\<:\\><textExpr>\\<\\.\\>           ## It is a text assembled in runtime. \n | <numExpr>.                      ## special detection of a simple dataAccess.\n \n dataStruct::= { <DefVariable?> ; } | { <DefStringVar?textVariable> ? , }.\n \n \n \n \n dataAccess::= \n [ $<$?envVariable> \n | [<?startVariable> $<#?>| $<$?>]    ## $1 .. $999 are the arguments of JZcmd, $name for environment \n | [|java\\ ] new\\  <staticJavaAccess?newJavaClass> \n | [%|java\\ ] <staticJavaAccess?staticJavaMethod> \n | <dataPath?> \n ].\n \n \n ## Access to a Java class constructor or static method or field\n staticJavaAccess::=\n   [ & <dataAccess?Class_Var> : [<$\\.$?javapath>]       ## access via Class variable .element\n   | [: <dataAccess?Classpath_Var> : ] <$\\.$?javapath>  ## [Classpath] package.path.Class.element\n   ] [( <?operation> [ { <objExpr?argument> ? , } ])].   ## arguments\n \n dataPath::= \n [ File : <textValue?File>     ##creates a file object with given path\n | <startDatapath> \n ] [ [?\\. \\>] \\.{ <datapathElement> ? [?\\. \\>] \\.}].\n \n ## A datapath cannot start with an JZcmd keyword! \n startDatapath::= <?whatisit=@> \n [ & ( <dataPath> )  ##takes the result of <dataPath> as name of an element or method. \n | <$-?ident> \n ][\n   ( [{ <objExpr?argument> ? ,}]) <?whatisit=(>   ##a method\n | \\[ <#?index> \\] <?whatisit=\\[>   ##an indexed array access\n |].\n \n datapathElement::= \n [ & ( <dataPath> ) ##takes the result of <dataPath> as name of an element or method.\n | ##Field or method identifier, use regex for the second datapath element, it can be a JZcmd keyword too! \n   [<?ident> [@] [\\[\\]   ##[] instead name for length operation. \n   | <![\\\\w-]+?>]        ##name as regex or [] for length of array or size() of container\n   ]\n ][\n   ( [{ <objExpr?argument> ? ,}]) <?whatisit=(>   ##a method\n | \\[ <#?index> \\] <?whatisit=\\[>   ##an indexed array access\n |].\n \n \n \n \n condition::=<andExpr?> [{\\|\\| <?boolCheckOrOperation> <andExpr?boolOrOperation>}].\n \n andExpr::= <boolExpr?> [{ && <?boolCheckAndOperation> <boolExpr?boolAndOperation>}].\n \n boolExpr::= [<?boolNot> ! | not| NOT|]\n [ ( <condition?parenthesisExpr>) \n | <numExpr?> [<cmpOperation>]\n ].\n \n cmpOperation::=[ \\?[<?cmpOperator>gt|ge|lt|le|eq|ne|instanceof] |  [<?cmpOperator> != | == | \\>= | \\> | \\<= | \\< ]] <numExpr?>.\n \n instanceof::=<objExpr> instanceof <staticJavaAccess>.\n \n conditionInText::=<andExprInText?> [{\\|\\| <?boolCheckOrOperation> <andExprInText?boolOrOperation>}].\n \n andExprInText::= <boolExprInText?> [{ && <?boolCheckAndOperation> <boolExprInText?boolAndOperation>}].\n \n boolExprInText::= [<?boolNot> ! | not|]\n [ ( <conditionInText?parenthesisExpr>) \n | <numExpr?> [<cmpOperationInText?cmpOperation>]\n ].\n \n cmpOperationInText::=[ \\?[<?cmpOperator>gt|ge|lt|le|eq|ne|instanceof] |  [<?cmpOperator> != | == ]] <numExpr?>.\n \n \n numExpr::=  bool ( <boolExpr?> ) \n | <multExpr?> [{ + <multExpr?addOperation> | - <multExpr?subOperation>}]\n .\n \n \n multExpr::= <value?> [{ * <value?multOperation> | / <value?divOperation> }].\n \n value::= 0x<#x?intValue> | <#-?intValue>[?\\.] | <#f?doubleValue> |    ##unary - associated to value.\n [{[<?unaryOperator> ! | ~ | - | +]}]     ##additional unary operators.\n [ 0x<#x?intValue> | <#?intValue>  ##ones of kind of value:\n | '<!.?charValue>' | <\"\"?textValue> \n | ( <numExpr?parenthesisExpr> ) \n | [& [?(] ] <dataAccess>   ## & is optional, don't confuse with &(variable) \n ].\n \n \n textExpr::=<$NoWhiteSpaces>\n { [?\\<\\.]                             ##abort on <. \n [ \\<&-<*\\>?>\\>                          ##<&- it is comment> \n | \\<:---\\><*|---\\>?>\\<---\\> ##<:---> comment <---> not confused with XML <--- will be produced as output --->\n | \\<:-<*\\>?>\\><textExpr?>\\<\\.-<*\\>?>\\> ##<:-comment> comment <.- > \n | \\#\\#<*\\r\\n?>   ##comment to eol in a text Expression\n | \\<:\\{  <statementBlock?>  <!\\\\s*>  \\}\\>  ##one or more statements inside a text expression, do not produce an output text. \n | \\<:indent:[<#?nIndent>][[?\\>]<!\\.?cIndent>]\\>\n | \\<:for:<forInText?forCtrl>\n | \\<:if: <ifInText?ifCtrl>\n | \\<:hasNext\\> <textExpr?hasNext> \\<\\.hasNext\\>\n | \\<:subtext : <callSubtext?call>\n | \\<:call : <callSubtext?call>\n | \\<:scriptdir<?scriptdir>\\>\n | \\<:debug-break\\> <?breakBlock>     ##ends the text, especially for test. \n | \\<:debug[:<textValue?debug>| <?debug>]\\>\n | \\<:debugOp:<textValue?debugOp>\\>\n | \\<&<dataText>\n | \\<: [<?transliteration>n|r|t|b|[\\<|#|\\\"]<*\\>?>] \\>\n | \\<:[<#?utf16code>|x<#x?utf16code>]\\>\n | \\<:lf\\><?newline>\n | \\<:\\ \\><!\\\\s*?> [ \\#\\#<*\\r\\n?> <!\\\\s*?> ]\n | \\<:s\\><?skipWhiteSpaces>\n | \\<:@<setColumn>\\>  \n | \\<:<DefVariable?> \\>  \n | \\<:=<assignInTextExpr?assignExpr>  \n | \\<:\\><textExpr?.indent=-3>\\<\\.\\>\n | <*|\\<:|\\<&|\\#\\#|\\<\\.?plainText>\n ]\n }.\n \n \n dataText::=<dataAccess>[ \\:\\?[<\"\"?errorText>|<*\\>:?errorText>]][ \\: [<\"\"?formatText>|<*\\>?formatText>]] \\>.     ##<*expr: format>\n \n textOut::= [<dataPath?assign>] [:n<?newline>] \\> \n   [<textExpr>]\n   [ \\<\\.+\\>                     ## end text variants: \n   | \\<\\.n+\\><?newline>  \n   | \\<\\.+n\\><?newline> \n   | \\<\\.+n+flush\\><?newline><?flush>  \n   | \\<\\.+flush\\><?flush>\n   | \\<\\.+n+close\\><?close>  \n   | \\<\\.+close\\><?close> \n   ].\n \n setColumn::=<numExpr> [ : <numExpr?minSpaces>] | : <numExpr?minSpaces>.\n \n \n assignInTextExpr::= <dataPath?assign>[[ = | += <?append>] <objExpr?> \\> | \\> <textExpr>  \\<\\.=\\> ].\n \n forCtrl::= ( <$?forVariable> : <dataAccess?forContainer> [ && <condition> ] )  [\\{ [<statementBlock>] \\} | ; ] .\n \n forInText::= <$?forVariable> : <dataAccess?forContainer> [ && <condition> ] \\> <textExpr> \\<\\.for[ : <$?@checkForVariable> ]\\>. \n ##name is the name of the container element data reference\n \n ifCtrl::= <ifBlock> [{ elsif <ifBlock>  }][ else \\{ [<statementBlock?elseBlock>] \\} ].\n \n ifBlock::= ( <condition> ) [ \\{ [ <statementBlock> ] \\} | ; ] .\n \n ifInText::= <ifBlockInText?ifBlock> [{ \\<:elsif : <ifBlockInText?ifBlock>  }][ \\<:else\\> <textExpr?elseBlock> ] \\<\\.if\\>.\n \n ifBlockInText::= <conditionInText?condition> \\> <textExpr>.\n \n whileCtrl::= ( <condition> ) [ \\{ [<statementBlock>] \\} | ; ] .\n \n dowhileCtrl::=  \\{ [<statementBlock>] \\} while ( <condition> ) ; .\n \n \n onerror::= [ <#?errorLevel> \n            | [<?errortype> notfound | cmd | file | internal | exit ]\n            |]\n            \\{ [<statementBlock>] \\}.\n \n \n callSubroutine::= [{ <dataPath?assign> [ = | += <?append>] }] call <textValue?callName> ( [{ <namedArgument?actualArgument> ? , }] ) ; .\n \n callSubtext::=<textValueTextExpr?callName> [ : { <namedArgument?actualArgument> ? , }] \\>.\n \n namedArgument::= <$?name> = <objExpr?>.\n \n \n zmake::= [ : <$-?name> :[?=] ]     ##optional : name : of the zmake target, not ends with := \n          <textValue?zmakeOutput> := <textValue?callName> \n          ( { <namedArgument?actualArgument> | <filesetAccess> ? ,} ).\n \n \n ## An accessPath is a Filepath, see prepFilepath::=, but analyzed on Java level. \n filesetAccess::= [ <\"\"?accessPath> | \\<:\\><textExpr>\\<\\.\\> \n                  | & <dataAccess>      \n                  | <*\\ \\r\\n,)&?accessPath> ##will be converted to Filepath maybe with ':'\n                  |] [ & <dataAccess?zmakeFilesetVariable>] .    \n \n \n cmdLineWait::=[{ <dataPath?assign> += }] cmd\\  <cmdLine?>.\n \n cmdLine::= [\\!argsCheck!<?argsCheck>] <textValue?> [{[?;[\\ |\\n|\\r]] [ \\<\\:arg\\><textExpr?actualArgument>\\<\\.arg\\> | \\<\\:args:<dataAccess?argList>\\> |<textValue?actualArgument>] }] \n   [ \\<:stdout:[ pipe<?pipe>| [$]<$?stdoutVariable>] \\>] ;.\n \n iferrorlevel::= <#?errorLevel> \\{ [<statementBlock>] \\}.\n \n \n \n assignExpr::= [{ <dataPath?assign> [ = | += <?append>] }] <objExpr?> ;.\n \n \n threadBlock::= Thread <dataPath?defThreadVar> = [thread] \\{ <statementBlock> \\} \n              | thread \\{ <statementBlock> \\}.\n \n");
        }
        catch (ParseException parseException) {
            throw new ScriptException("JZcmd.ctor - internal syntax error; " + parseException.getMessage());
        }
    }

    public static CharSequence execute(File file, JZtxtcmdExecuter.ExecuteLevel executeLevel) throws IllegalAccessException {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        MainCmdLogging_ifc mainCmdLogging_ifc = executeLevel.log();
        JZtxtcmdExecuter jZtxtcmdExecuter = new JZtxtcmdExecuter(mainCmdLogging_ifc);
        try {
            JZtxtcmdScript jZtxtcmdScript = JZtxtcmd.translateAndSetGenCtrl(file, null, mainCmdLogging_ifc);
            jZtxtcmdExecuter.execute(jZtxtcmdScript, true, bl, (Appendable)stringBuilder, executeLevel.localVariables, executeLevel.currdir());
        }
        catch (Throwable throwable) {
            String string = throwable.getMessage();
            System.err.println(string);
        }
        return stringBuilder.toString();
    }

    public static CharSequence execSub(File file, String string, Map<String, DataAccess.Variable<Object>> map, JZtxtcmdExecuter.ExecuteLevel executeLevel, Appendable appendable) {
        StringFormatter stringFormatter = appendable == null ? null : new StringFormatter(appendable, false, "\n", 300);
        MainCmdLogging_ifc mainCmdLogging_ifc = executeLevel.log();
        short s = 0;
        String string2 = "";
        try {
            DataAccess.Variable<Object> variable;
            JZtxtcmdScript jZtxtcmdScript = JZtxtcmd.translateAndSetGenCtrl(file, null, mainCmdLogging_ifc);
            JZtxtcmdScript.Subroutine subroutine = jZtxtcmdScript.getSubroutine(string);
            s = executeLevel.exec_Subroutine(subroutine, map, stringFormatter, -1);
            if (s == -5 && (variable = executeLevel.localVariables.get("error")) != null) {
                string2 = variable.value().toString();
            }
        }
        catch (Exception exception) {
            string2 = exception.getMessage();
            System.err.println(string2);
        }
        return string2;
    }

    public static CharSequence execSub(File file, String string, Map<String, DataAccess.Variable<Object>> map, JZtxtcmdExecuter.ExecuteLevel executeLevel) {
        return JZtxtcmd.execSub(file, string, map, executeLevel, null);
    }

    @Override
    public Object evalSub(File file, String string, Map<String, DataAccess.Variable<Object>> map, JZtxtcmdExecuter.ExecuteLevel executeLevel) throws ScriptException {
        JZtxtcmdScript jZtxtcmdScript = this.compile(file, null);
        JZtxtcmdScript.Subroutine subroutine = jZtxtcmdScript.getSubroutine(string);
        return executeLevel.evalSubroutine(subroutine, map, null, -1);
    }

    public static void execute(String string) throws ScriptException {
        StringPartScan stringPartScan = new StringPartScan(string);
        MainCmdLoggingStream mainCmdLoggingStream = new MainCmdLoggingStream(System.out);
        JZtxtcmdExecuter jZtxtcmdExecuter = new JZtxtcmdExecuter(mainCmdLoggingStream);
        JZtxtcmd.execute(jZtxtcmdExecuter, null, stringPartScan, null, null, null, true, null, mainCmdLoggingStream);
    }

    public static void execute(File file, MainCmdLogging_ifc mainCmdLogging_ifc) throws ScriptException {
        JZtxtcmd.execute(null, file, null, null, true, null, mainCmdLogging_ifc);
    }

    public static void execute(JZtxtcmdExecuter jZtxtcmdExecuter, File file, Appendable appendable, Map<String, DataAccess.Variable<Object>> map, String string, boolean bl, File file2, MainCmdLogging_ifc mainCmdLogging_ifc) throws ScriptException {
        int n = (int)file.length();
        StringPartFromFileLines stringPartFromFileLines = null;
        try {
            stringPartFromFileLines = new StringPartFromFileLines(file, n, "encoding", null);
        }
        catch (IOException iOException) {
            String string2 = iOException.getMessage();
            throw new ScriptException("JZcmd - Error script file not found; " + file.getAbsolutePath() + "; " + string2);
        }
        if (stringPartFromFileLines != null) {
            JZtxtcmd.execute(jZtxtcmdExecuter, file, stringPartFromFileLines, appendable, map, string, bl, file2, mainCmdLogging_ifc);
        }
    }

    public static void execute(JZtxtcmdExecuter jZtxtcmdExecuter, File file, Appendable appendable, List<DataAccess.Variable<Object>> list, String string, boolean bl, File file2, MainCmdLogging_ifc mainCmdLogging_ifc) throws ScriptException {
        int n = (int)file.length();
        StringPartFromFileLines stringPartFromFileLines = null;
        try {
            stringPartFromFileLines = new StringPartFromFileLines(file, n, "encoding", null);
        }
        catch (IOException iOException) {
            String string2 = iOException.getMessage();
            throw new ScriptException("JZcmd - Error script file not found; " + file.getAbsolutePath() + "; " + string2);
        }
        if (stringPartFromFileLines != null) {
            JZtxtcmdScript jZtxtcmdScript = null;
            jZtxtcmdScript = JZtxtcmd.translateAndSetGenCtrl(stringPartFromFileLines, mainCmdLogging_ifc, file2, file);
            JZtxtcmdExecuter jZtxtcmdExecuter2 = jZtxtcmdExecuter == null ? new JZtxtcmdExecuter(mainCmdLogging_ifc) : jZtxtcmdExecuter;
            jZtxtcmdExecuter2.execute(jZtxtcmdScript, bl, true, appendable, list, string);
        }
    }

    public static void execute(JZtxtcmdExecuter jZtxtcmdExecuter, File file, Appendable appendable, String string, boolean bl, File file2, MainCmdLogging_ifc mainCmdLogging_ifc) throws ScriptException {
        int n = (int)file.length();
        StringPartFromFileLines stringPartFromFileLines = null;
        try {
            stringPartFromFileLines = new StringPartFromFileLines(file, n, "encoding", null);
        }
        catch (IOException iOException) {
            String string2 = iOException.getMessage();
            throw new ScriptException("JZcmd - Error script file not found; " + file.getAbsolutePath() + "; " + string2);
        }
        if (stringPartFromFileLines != null) {
            JZtxtcmdScript jZtxtcmdScript = null;
            jZtxtcmdScript = JZtxtcmd.translateAndSetGenCtrl(stringPartFromFileLines, mainCmdLogging_ifc, file2, file);
            JZtxtcmdExecuter jZtxtcmdExecuter2 = jZtxtcmdExecuter == null ? new JZtxtcmdExecuter(mainCmdLogging_ifc) : jZtxtcmdExecuter;
            jZtxtcmdExecuter2.execute(jZtxtcmdScript, bl, true, appendable, string);
        }
    }

    public static void execute(JZtxtcmdExecuter jZtxtcmdExecuter, File file, StringPartScan stringPartScan, Appendable appendable, Map<String, DataAccess.Variable<Object>> map, String string, boolean bl, File file2, MainCmdLogging_ifc mainCmdLogging_ifc) throws ScriptException {
        JZtxtcmdScript jZtxtcmdScript = null;
        jZtxtcmdScript = JZtxtcmd.translateAndSetGenCtrl(stringPartScan, mainCmdLogging_ifc, file2, file);
        JZtxtcmdExecuter jZtxtcmdExecuter2 = jZtxtcmdExecuter == null ? new JZtxtcmdExecuter(mainCmdLogging_ifc) : jZtxtcmdExecuter;
        jZtxtcmdExecuter2.execute(jZtxtcmdScript, bl, true, appendable, map, string);
    }

    public static JZtxtcmdScript translateAndSetGenCtrl(File file, MainCmdLogging_ifc mainCmdLogging_ifc) throws ScriptException {
        return JZtxtcmd.translateAndSetGenCtrl(file, null, mainCmdLogging_ifc);
    }

    public static JZtxtcmdScript translateAndSetGenCtrl(File file, File file2, MainCmdLogging_ifc mainCmdLogging_ifc) throws ScriptException {
        int n = (int)file.length();
        StringPartScan stringPartScan = null;
        try {
            stringPartScan = new StringPartFromFileLines(file, n, "encoding", null);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            if (stringPartScan != null) {
                stringPartScan.close();
            }
            throw new ScriptException("JZcmd.translate - illegal CharSet in file; ", file.getAbsolutePath(), -1);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            if (stringPartScan != null) {
                stringPartScan.close();
            }
            throw new ScriptException("JZcmd.translate - illegal CharSet in file; ", file.getAbsolutePath(), -1);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ScriptException("JZcmd.translate - file not found; ", file.getAbsolutePath(), -1);
        }
        catch (IOException iOException) {
            throw new ScriptException("JZcmd.translate - any file error; ", file.getAbsolutePath(), -1);
        }
        JZtxtcmdScript jZtxtcmdScript = JZtxtcmd.translateAndSetGenCtrl(stringPartScan, mainCmdLogging_ifc, file2, file);
        stringPartScan.close();
        return jZtxtcmdScript;
    }

    public JZtxtcmdScript compile(File file, File file2) throws ScriptException {
        StringPartFromFileLines stringPartFromFileLines;
        int n = (int)file.length();
        try {
            stringPartFromFileLines = new StringPartFromFileLines(file, n, "encoding", null);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            throw new ScriptException("JZcmd.translate - illegal CharSet in file; ", file.getAbsolutePath(), -1);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            throw new ScriptException("JZcmd.translate - illegal CharSet in file; ", file.getAbsolutePath(), -1);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ScriptException("JZcmd.translate - file not found; ", file.getAbsolutePath(), -1);
        }
        catch (IOException iOException) {
            throw new ScriptException("JZcmd.translate - any file error; ", file.getAbsolutePath(), -1);
        }
        return this.compile(stringPartFromFileLines, file2, file);
    }

    public static JZtxtcmdScript translateAndSetGenCtrl(String string, MainCmdLogging_ifc mainCmdLogging_ifc) throws ScriptException {
        return JZtxtcmd.translateAndSetGenCtrl(new StringPartScan(string), mainCmdLogging_ifc, null, null);
    }

    public static JZtxtcmdScript translateAndSetGenCtrl(StringPartScan stringPartScan, MainCmdLogging_ifc mainCmdLogging_ifc) throws ScriptException {
        return JZtxtcmd.translateAndSetGenCtrl(stringPartScan, mainCmdLogging_ifc, null, null);
    }

    public static String readJZcmdCfg(JZtxtcmdScript.AddSub2List addSub2List, File file, MainCmdLogging_ifc mainCmdLogging_ifc, CmdExecuter cmdExecuter) {
        String string = null;
        try {
            JZtxtcmdScript jZtxtcmdScript = JZtxtcmd.translateAndSetGenCtrl(file, new File(file.getParentFile(), file.getName() + ".check.xml"), mainCmdLogging_ifc);
            jZtxtcmdScript.addContentToSelectContainer(addSub2List);
            if (cmdExecuter != null) {
                cmdExecuter.initJZcmdExecuter(jZtxtcmdScript, null, mainCmdLogging_ifc);
            }
        }
        catch (Throwable throwable) {
            mainCmdLogging_ifc.writeError("JZcmdScript error,", throwable);
            string = "JZcmdScript error," + throwable.getMessage();
        }
        return string;
    }

    @Deprecated
    public static JZtxtcmdScript translateAndSetGenCtrl(StringPartScan stringPartScan, MainCmdLogging_ifc mainCmdLogging_ifc, File file, File file2) throws ScriptException {
        JZtxtcmd jZtxtcmd = new JZtxtcmd(mainCmdLogging_ifc);
        JZtxtcmdScript jZtxtcmdScript = new JZtxtcmdScript(mainCmdLogging_ifc, file2, jZtxtcmd);
        File file3 = FileSystem.getDir(file2);
        JZtxtcmdScript.ZbnfJZcmdScript zbnfJZcmdScript = new JZtxtcmdScript.ZbnfJZcmdScript(jZtxtcmdScript);
        jZtxtcmd.translateAndSetGenCtrl(stringPartScan, zbnfJZcmdScript, file3, file);
        return jZtxtcmdScript;
    }

    @Deprecated
    private JZtxtcmdScript compile(StringPartScan stringPartScan, File file, File file2) throws ScriptException {
        JZtxtcmdScript jZtxtcmdScript = new JZtxtcmdScript(this.log, file2, this);
        File file3 = FileSystem.getDir(file2);
        JZtxtcmdScript.ZbnfJZcmdScript zbnfJZcmdScript = new JZtxtcmdScript.ZbnfJZcmdScript(jZtxtcmdScript);
        this.translateAndSetGenCtrl(stringPartScan, zbnfJZcmdScript, file3, file);
        return jZtxtcmdScript;
    }

    @Deprecated
    private void translateAndSetGenCtrl(StringPartScan stringPartScan, JZtxtcmdScript.ZbnfJZcmdScript zbnfJZcmdScript, File file, File file2) throws ScriptException {
        Object object;
        Object object2;
        this.parserGenCtrl.setXmlSrcline(file2 != null);
        boolean bl = this.parserGenCtrl.parse(stringPartScan);
        if (!bl) {
            String string = this.parserGenCtrl.getSyntaxErrorReport();
            throw new ScriptException("\n" + string, stringPartScan.getInputfile(), -1, -1);
        }
        if (file2 != null) {
            object2 = this.parserGenCtrl.getResultTree();
            object = new SimpleXmlOutputter();
            try {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new FileOutputStream(file2));
                ((SimpleXmlOutputter)object).write(outputStreamWriter, (XmlNode)object2);
                outputStreamWriter.close();
            }
            catch (IOException iOException) {
                throw new ScriptException(iOException);
            }
        }
        object2 = new ZbnfJavaOutput(this.log);
        zbnfJZcmdScript.scriptfile = new JZtxtcmdScript.Scriptfile();
        try {
            ((ZbnfJavaOutput)object2).setContent(JZtxtcmdScript.ZbnfJZcmdScript.class, zbnfJZcmdScript, this.parserGenCtrl.getFirstParseResult());
        }
        catch (Exception exception) {
            throw new ScriptException(exception);
        }
        if (zbnfJZcmdScript.isXmlSrcNecessary()) {
            zbnfJZcmdScript.setXmlSrc(this.parserGenCtrl.getResultTree());
        }
        object = zbnfJZcmdScript.scriptfile.getMainRoutine();
        if (zbnfJZcmdScript.scriptfile.includes != null) {
            for (JZtxtcmdScript.JZcmdInclude jZcmdInclude : zbnfJZcmdScript.scriptfile.includes) {
                StringPartFromFileLines stringPartFromFileLines;
                String string;
                Object object3;
                if (jZcmdInclude.envVar != null) {
                    object3 = System.getenv(jZcmdInclude.envVar);
                    if (object3 == null) {
                        throw jZcmdInclude.scriptException("JZcmd.include - cannot find environment variable;" + jZcmdInclude.envVar);
                    }
                    string = (String)object3 + '/' + jZcmdInclude.path;
                } else {
                    string = jZcmdInclude.path;
                }
                object3 = FileSystem.isAbsolutePath(string) ? new File(string) : new File(file, string);
                if (!((File)object3).exists()) {
                    System.err.printf("TextGenScript - translateAndSetGenCtrl, included file not found; %s\n", ((File)object3).getAbsolutePath());
                    throw new ScriptException("JZcmd.compile - included file not found: ", ((File)object3).getAbsolutePath(), -1, -1);
                }
                File file3 = FileSystem.getDir((File)object3);
                int n = (int)((File)object3).length();
                try {
                    stringPartFromFileLines = new StringPartFromFileLines((File)object3, n, "encoding", null);
                }
                catch (Exception exception) {
                    throw new ScriptException(exception);
                }
                this.translateAndSetGenCtrl(stringPartFromFileLines, zbnfJZcmdScript, file3, file2);
            }
        }
        if (object != null) {
            zbnfJZcmdScript.setMainRoutine((JZtxtcmdScript.Subroutine)object);
        }
    }

    @Override
    public CompiledScript compile(String string) throws ScriptException {
        StringPartScan stringPartScan = new StringPartScan(string);
        JZtxtcmdScript jZtxtcmdScript = new JZtxtcmdScript(this.log, null, this);
        JZtxtcmdScript.ZbnfJZcmdScript zbnfJZcmdScript = new JZtxtcmdScript.ZbnfJZcmdScript(jZtxtcmdScript);
        try {
            this.translateAndSetGenCtrl(stringPartScan, zbnfJZcmdScript, null, null);
        }
        catch (Exception exception) {
            throw new ScriptException(exception);
        }
        return jZtxtcmdScript;
    }

    @Override
    public CompiledScript compile(Reader reader) throws ScriptException {
        char[] cArray;
        int n;
        int n2 = 8192;
        try {
            while ((n = reader.read(cArray = new char[n2 = 2 * n2])) == n2 && n2 < 5000000) {
            }
            if (n == n2) {
                throw new ScriptException("script to long; " + n);
            }
        }
        catch (IOException iOException) {
            throw new ScriptException(iOException);
        }
        String string = new String(cArray, 0, n);
        return this.compile(string);
    }

    @Override
    public Bindings createBindings() {
        return null;
    }

    @Override
    public Object eval(String string) throws ScriptException {
        return null;
    }

    @Override
    public Object eval(Reader reader) throws ScriptException {
        return null;
    }

    @Override
    public Object eval(String string, ScriptContext scriptContext) throws ScriptException {
        return null;
    }

    @Override
    public Object eval(Reader reader, ScriptContext scriptContext) throws ScriptException {
        return null;
    }

    @Override
    public Object eval(String string, Bindings bindings) throws ScriptException {
        return null;
    }

    @Override
    public Object eval(Reader reader, Bindings bindings) throws ScriptException {
        return null;
    }

    @Override
    public Object get(String string) {
        return null;
    }

    @Override
    public Bindings getBindings(int n) {
        return null;
    }

    @Override
    public ScriptContext getContext() {
        JZtxtcmdExecuter jZtxtcmdExecuter = new JZtxtcmdExecuter();
        return jZtxtcmdExecuter.scriptLevel();
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return null;
    }

    @Override
    public void put(String string, Object object) {
    }

    @Override
    public void setBindings(Bindings bindings, int n) {
    }

    @Override
    public void setContext(ScriptContext scriptContext) {
    }

    private static class CmdLine
    extends MainCmd {
        public final Args argData;
        protected final MainCmd.Argument[] argList = new MainCmd.Argument[]{new MainCmd.Argument("", "INPUT    pathTo JZcmd-File to execute", new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                if (argData.sFileScript == null) {
                    argData.sFileScript = string;
                } else {
                    argData.userArgs.add(string);
                }
                return true;
            }
        }), new MainCmd.Argument("-t", ":OUTEXT pathTo text-File for output", new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                argData.sFileTextOut = string;
                return true;
            }
        }), new MainCmd.Argument("-debug", ":INPUT.xml pathTo XML output of parsed script", new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                argData.fileTestXml = new File(string);
                try {
                    FileSystem.mkDirPath(argData.fileTestXml);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println("JZcmd.main - faulty path for -debug;" + string);
                    return false;
                }
                return true;
            }
        }), new MainCmd.Argument("-u", ":userArgs", new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                argData.userArgs.add(string);
                return true;
            }
        })};

        protected CmdLine(Args args, String[] stringArray) {
            super(stringArray);
            this.argData = args;
            super.addAboutInfo("Compilation and Execution of JZcmd-Files");
            super.addAboutInfo("made by HSchorrig, Version 1.0, 2013-07-11..2014-06-09");
            super.addHelpInfo("args JZcmd_SCRIPTFILE [-t:OUTEXT] [-debug:SCRIPTFILE.xml]");
            super.addArgument(this.argList);
            super.addHelpInfo("==Standard arguments of MainCmd==");
            super.addStandardHelpInfo();
            super.addHelpInfo("==Syntax of a JZcmd script==");
            super.addHelpInfo(" $comment=(?...?).\n $endlineComment=\\#\\#.  ##The ## is the start chars for an endline-comment or commented line in the generator script.\n $keywords= new | cmd | cmd_check | start \n   | debug | java \n   | stdout | stdin | stderr \n   | subtext | sub | main | call | cd | CD | REM | Rem | rem \n   | Pipe | StringBuffer | Stringjar | String | List | Openfile | Fileset | Obj | Set | set | include | zbatch \n   | break | XXXreturn | exit | onerror | instanceof | for | while | do | if | elsif | else | not | NOT | and | AND | or | OR \n   | throw . \n \n JZtxtcmd::= \n [<*|==JZtxtcmd==?>==JZtxtcmd== ]\n [<*|==JZcmd==?>==JZcmd== ]\n [{ ! checkjzTc = <textValue?checkJZcmdFile> ; \n  | ! checkJZcmd = <textValue?checkJZcmdFile> ; \n  | ! checkXml = <textValue?checkXmlFile> ; \n }]\n [{ [REM|Rem|rem] <*\\n\\r?> ##Remark like in batch files\n  | include <include> ; \n  | currdir = <textDatapath?cd> ;\n }] \n { [//] ==endJZcmd==<*\\e?> \n | [REM|Rem|rem] <*\\n\\r?> ##Remark like in batch files\n | //JZtxtcmd       ##ignore //JZtxtcmd, it may be a comment for another language\n | //JZcmd      ##ignore //JZcmd, it may be a comment for another language\n | //<*\\n\\r?> ##line comment in C style\n | /*<*|*/?>*/ ##block commment in C style\n | <DefVariable?> ; \n | <statement?>\n | subtext  <subtext?subroutine> \n | sub <subroutine> \n | class <subClass> \n | main ( ) \\{ <statementBlock?mainRoutine> \\} \n } \\e.\n \n \n include::= [$<$?envVar>[/|\\\\]][ <\"\"?path> | <*;\\ ?path>].\n \n \n subClass::= <$?name> \\{ \n { <DefVariable?> ; \n | subtext  <subtext?subroutine> \n | sub <subroutine> \n | class <subClass> \n } \\}. \n \n \n subroutine::= <$?name> [( [ use-locals<?useLocals> | { add-locals<?addLocals> | <DefVariable?formalArgument> ? , } |] ) [=] | = <?useLocals>] \\{ [<statementBlock>] \\}. \n \n subtext::= <$?name> [( [ use-locals<?useLocals> | { add-locals<?addLocals> | <DefVariable?formalArgument> ? , } |] ) [=] | = <?useLocals>]  \\<:\\><textExpr>\\<\\.\\>.\n \n \n statementBlock::= { <statement?> }.\n \n statement::=\n   \\{ [<statementBlock>] \\} \n | REM <*\\n\\r?> ##Remark like in batch files\n | ::{:}                ##Skip over :::\n | =={=}                ##Skip over :::\n | //JZtxtcmd       ##ignore //JZtxtcmd, it may be a comment for another language\n | //JZcmd      ##ignore //JZcmd, it may be a comment for another language\n | //<*|\\n|\\r|\\<+?>     ##line commment in C style but only till <+\n | /*<*|*/?>*/          ##block commment in C style\n | text = <objExpr?createTextOut> ;    ##set text output\n | currdir = <textDatapath?cd> ;   ##set current directory\n | [cd|CD] [<textValue?cd> | <*\\ ;?cd> ; ]  ##change current directory \n | mkdir <textValue?mkdir> ;                 ##create any directory if not exists \n | <DefVariable?> ; \n | for <forCtrl> \n | if <ifCtrl> \n | while <whileCtrl> \n | do <dowhileCtrl> \n | start <cmdLine?cmdStart> \n | zmake <zmake> \n | move <srcdst?move> ; \n | copy <srcdst?copy> ; \n | [rm|del] <oneArg?del> ; \n | break <?breakBlock> ; \n | return <?return> ; \n | exit <#?exitScript> ;\n | throw on errorlevel <#?throwonerror> \n | throw <textDatapath?throw> \n | onerror <onerror> \n | errortoOutput off <?errorToOutput=0> \n | errortoOutput <?errorToOutput=1> \n | if errorlevel <iferrorlevel> \n | debug [<textValue?debug>| <?debug>] ; \n | debugOp <textValue?debugOp> ; \n | <callSubroutine?call> \n | <threadBlock> \n | \\<+:create\\><textExpr?createTextOut>\\<\\.+\\> \n | \\<+:append\\><textExpr?appendTextOut>\\<\\.+\\> \n | \\<+ <textOut> \n | \\<:\\><textExpr?.indent=-3>\\<\\.\\> [;] \n | <cmdLineWait?cmdWait> \n | <assignExpr> \n | ; \n .\n \n \n srcdst::= [{ -n<?newTimestamp>| -w<?overwr> | -r<overwro>}] [ src=] <textValue?src> [ dst=] <textValue?dst> .\n oneArg::= <textValue?src> .\n \n \n DefVariable::=\n   String\\  <DefStringVar?textVariable> \n | Stringjar\\  <DefSpecVar?Stringjar> \n | Num\\  <DefNumVar> \n | Bool\\  <DefBoolVar> \n | Pipe\\  <DefSpecVar?Pipe> \n | List\\  <DefList?List> \n | Map\\  <DefMapVar> \n | Obj\\  <DefObjVar> \n | Class\\  <DefClassVar> \n | Classpath\\  <DefClasspath> \n | Openfile\\  <Openfile> \n | Fileset\\  <DefFileset> \n | Filepath\\ <DefFilepath> \n | Subtextvar\\ <subtext?DefSubtext> \n | Subroutinevar\\ <subroutine?DefSubtext> \n | Set\\  <DefStringVar?setEnvVar> \n | set\\  <DefStringVar?setEnvVar> \n | SET\\  <DefStringVar?setEnvVar> \n .\n \n DefNumVar::= [const <?const>] <definePath?defVariable>  [ = <numExpr>].\n \n DefBoolVar::= [const <?const>] <definePath?defVariable>  [ = <boolExpr>].\n \n DefList::= [const <?const>] <definePath?defVariable>  \n[ = \\[ {<?element> \\{ <dataStruct?dataSet> \\} ? , } \\]  ##some { dataSet, ...} \n| = \\[ <dataStruct?>   \\]  ##some String or variable (const) definitions in the container.\n| = <objExpr?> [!;]\n| = \\[ { <objExpr?objElement> ? , } \\]\n|].\n \n DefSpecVar::= [const <?const>] <definePath?defVariable>  [ = <objExpr?>].\n \n DefObjVar::= [const <?const>] <definePath?defVariable> [ : <$\\.?type>]  [ = <objExpr?>].\n \n DefClassVar::= [const] <definePath?defVariable>  = \n   [: <dataAccess?loader> : ]  ## a datapath to a ClassLoader instance, a Classpath variable. \n   <textValue?>.               ## The package path maybe contained in any expression\n \n DefClasspath::= [const] <definePath?defVariable>  = [ : <$?parentClasspath> : ] { <filesetAccess> ? , }.\n \n DefStringVar::= [const <?const>] <definePath?defVariable> [ = <textDatapath?>].\n \n DefMapVar::= [const <?const>] <definePath?defVariable> [ = \\{ <dataStruct> \\}  ].\n \n Openfile::= [const <?const>] <definePath?defVariable> = <textDatapath?> .\n \n \n definePath::= <$-?startVariable>[ [?\\. \\>] \\.{ <defineSubelement?datapathElement> ? [?\\. \\>] \\.}].\n \n defineSubelement::= <$-?ident> [( [{ <objExpr?argument> ? ,}])<?whatisit=(>].\n \n \n DefFileset::= <definePath?defVariable> [ =  ( \n [ commonpath = [<\"\"?commonPath>|<*;,)(\\ \\r\\n?commonPath>] , ] \n { [{ //JZcmd | //JZtxtcmd | //<*\\n\\r?>}] \n     [ <\"\"?filePath>             ##filePath in \"\"\n     | <*;,)(\\ \\r\\n?filePath>   ##filePath without \"\"\n     ]    [{ //JZcmd | //<*\\n\\r?>}] ? , } \n ) ] .\n \n DefFilepath::= <definePath?defVariable> [ = <textValue?> ]. \n \n \n \n \n XXXFilepath::=<\"\"?!prepFilePath>|<*;\\ \\r\\n,)?!prepFilePath>. \n \n prepFilePath::=<$NoWhiteSpaces><! *?>\n [ &$<$?@envVariable> [\\\\|/|]      ##path can start with a environment variable's content\n | &<$?@scriptVariable> [\\\\|/|]    ##path can start with a scriptvariable's content\n | [<!.?@drive>:]                  ## only 1 char with followed : is the drive letter\n   [ [/|\\\\]<?@absPath>]            ## starting with / maybe after d: is absolute path\n |]\n [ <*:?@pathbase>[?:=]:]           ## all until : is pathbase, but not till a :=\n [ <toLastChar:/\\\\?@path>[\\\\|/|]] ## all until last \\ or / is path\n [ <toLastChar:.?@name>              ## all until exclusive dot is the name\n   <*\\e?@ext>                       ## from dot to end is the extension\n | <*\\e?@name>                      ## No dot is found, all is the name.\n ] . \n \n \n \n \n \n textDatapath::=  <\"\"?text> | \\<:\\><textExpr>\\<\\.\\> | [& [?(] ] <dataAccess> .\n \n textValue::=  <\"\"?text> | \\<:\\><textExpr>\\<\\.\\> | & <dataAccess> | <*;,)(\\ \\r\\n\\>?text> .\n \n textValueTextExpr::=  <\"\"?text> | \\<:\\><textExpr>\\<\\.\\> | & <dataAccess> | <*:;,)(\\ \\r\\n\\>?text> .\n \n \n objExpr::= \n   Filepath : <textValue?Filepath> ## A textValue which builds a Filepath in the currdir \n | Fileset : <filesetAccess>  \n | \\{ <dataStruct> \\}              ## It is a Map of Variables. \n | <\"\"?text>                       ## It is a constant text. \n | \\<:\\><textExpr>\\<\\.\\>           ## It is a text assembled in runtime. \n | <numExpr>.                      ## special detection of a simple dataAccess.\n \n dataStruct::= { <DefVariable?> ; } | { <DefStringVar?textVariable> ? , }.\n \n \n \n \n dataAccess::= \n [ $<$?envVariable> \n | [<?startVariable> $<#?>| $<$?>]    ## $1 .. $999 are the arguments of JZcmd, $name for environment \n | [|java\\ ] new\\  <staticJavaAccess?newJavaClass> \n | [%|java\\ ] <staticJavaAccess?staticJavaMethod> \n | <dataPath?> \n ].\n \n \n ## Access to a Java class constructor or static method or field\n staticJavaAccess::=\n   [ & <dataAccess?Class_Var> : [<$\\.$?javapath>]       ## access via Class variable .element\n   | [: <dataAccess?Classpath_Var> : ] <$\\.$?javapath>  ## [Classpath] package.path.Class.element\n   ] [( <?operation> [ { <objExpr?argument> ? , } ])].   ## arguments\n \n dataPath::= \n [ File : <textValue?File>     ##creates a file object with given path\n | <startDatapath> \n ] [ [?\\. \\>] \\.{ <datapathElement> ? [?\\. \\>] \\.}].\n \n ## A datapath cannot start with an JZcmd keyword! \n startDatapath::= <?whatisit=@> \n [ & ( <dataPath> )  ##takes the result of <dataPath> as name of an element or method. \n | <$-?ident> \n ][\n   ( [{ <objExpr?argument> ? ,}]) <?whatisit=(>   ##a method\n | \\[ <#?index> \\] <?whatisit=\\[>   ##an indexed array access\n |].\n \n datapathElement::= \n [ & ( <dataPath> ) ##takes the result of <dataPath> as name of an element or method.\n | ##Field or method identifier, use regex for the second datapath element, it can be a JZcmd keyword too! \n   [<?ident> [@] [\\[\\]   ##[] instead name for length operation. \n   | <![\\\\w-]+?>]        ##name as regex or [] for length of array or size() of container\n   ]\n ][\n   ( [{ <objExpr?argument> ? ,}]) <?whatisit=(>   ##a method\n | \\[ <#?index> \\] <?whatisit=\\[>   ##an indexed array access\n |].\n \n \n \n \n condition::=<andExpr?> [{\\|\\| <?boolCheckOrOperation> <andExpr?boolOrOperation>}].\n \n andExpr::= <boolExpr?> [{ && <?boolCheckAndOperation> <boolExpr?boolAndOperation>}].\n \n boolExpr::= [<?boolNot> ! | not| NOT|]\n [ ( <condition?parenthesisExpr>) \n | <numExpr?> [<cmpOperation>]\n ].\n \n cmpOperation::=[ \\?[<?cmpOperator>gt|ge|lt|le|eq|ne|instanceof] |  [<?cmpOperator> != | == | \\>= | \\> | \\<= | \\< ]] <numExpr?>.\n \n instanceof::=<objExpr> instanceof <staticJavaAccess>.\n \n conditionInText::=<andExprInText?> [{\\|\\| <?boolCheckOrOperation> <andExprInText?boolOrOperation>}].\n \n andExprInText::= <boolExprInText?> [{ && <?boolCheckAndOperation> <boolExprInText?boolAndOperation>}].\n \n boolExprInText::= [<?boolNot> ! | not|]\n [ ( <conditionInText?parenthesisExpr>) \n | <numExpr?> [<cmpOperationInText?cmpOperation>]\n ].\n \n cmpOperationInText::=[ \\?[<?cmpOperator>gt|ge|lt|le|eq|ne|instanceof] |  [<?cmpOperator> != | == ]] <numExpr?>.\n \n \n numExpr::=  bool ( <boolExpr?> ) \n | <multExpr?> [{ + <multExpr?addOperation> | - <multExpr?subOperation>}]\n .\n \n \n multExpr::= <value?> [{ * <value?multOperation> | / <value?divOperation> }].\n \n value::= 0x<#x?intValue> | <#-?intValue>[?\\.] | <#f?doubleValue> |    ##unary - associated to value.\n [{[<?unaryOperator> ! | ~ | - | +]}]     ##additional unary operators.\n [ 0x<#x?intValue> | <#?intValue>  ##ones of kind of value:\n | '<!.?charValue>' | <\"\"?textValue> \n | ( <numExpr?parenthesisExpr> ) \n | [& [?(] ] <dataAccess>   ## & is optional, don't confuse with &(variable) \n ].\n \n \n textExpr::=<$NoWhiteSpaces>\n { [?\\<\\.]                             ##abort on <. \n [ \\<&-<*\\>?>\\>                          ##<&- it is comment> \n | \\<:---\\><*|---\\>?>\\<---\\> ##<:---> comment <---> not confused with XML <--- will be produced as output --->\n | \\<:-<*\\>?>\\><textExpr?>\\<\\.-<*\\>?>\\> ##<:-comment> comment <.- > \n | \\#\\#<*\\r\\n?>   ##comment to eol in a text Expression\n | \\<:\\{  <statementBlock?>  <!\\\\s*>  \\}\\>  ##one or more statements inside a text expression, do not produce an output text. \n | \\<:indent:[<#?nIndent>][[?\\>]<!\\.?cIndent>]\\>\n | \\<:for:<forInText?forCtrl>\n | \\<:if: <ifInText?ifCtrl>\n | \\<:hasNext\\> <textExpr?hasNext> \\<\\.hasNext\\>\n | \\<:subtext : <callSubtext?call>\n | \\<:call : <callSubtext?call>\n | \\<:scriptdir<?scriptdir>\\>\n | \\<:debug-break\\> <?breakBlock>     ##ends the text, especially for test. \n | \\<:debug[:<textValue?debug>| <?debug>]\\>\n | \\<:debugOp:<textValue?debugOp>\\>\n | \\<&<dataText>\n | \\<: [<?transliteration>n|r|t|b|[\\<|#|\\\"]<*\\>?>] \\>\n | \\<:[<#?utf16code>|x<#x?utf16code>]\\>\n | \\<:lf\\><?newline>\n | \\<:\\ \\><!\\\\s*?> [ \\#\\#<*\\r\\n?> <!\\\\s*?> ]\n | \\<:s\\><?skipWhiteSpaces>\n | \\<:@<setColumn>\\>  \n | \\<:<DefVariable?> \\>  \n | \\<:=<assignInTextExpr?assignExpr>  \n | \\<:\\><textExpr?.indent=-3>\\<\\.\\>\n | <*|\\<:|\\<&|\\#\\#|\\<\\.?plainText>\n ]\n }.\n \n \n dataText::=<dataAccess>[ \\:\\?[<\"\"?errorText>|<*\\>:?errorText>]][ \\: [<\"\"?formatText>|<*\\>?formatText>]] \\>.     ##<*expr: format>\n \n textOut::= [<dataPath?assign>] [:n<?newline>] \\> \n   [<textExpr>]\n   [ \\<\\.+\\>                     ## end text variants: \n   | \\<\\.n+\\><?newline>  \n   | \\<\\.+n\\><?newline> \n   | \\<\\.+n+flush\\><?newline><?flush>  \n   | \\<\\.+flush\\><?flush>\n   | \\<\\.+n+close\\><?close>  \n   | \\<\\.+close\\><?close> \n   ].\n \n setColumn::=<numExpr> [ : <numExpr?minSpaces>] | : <numExpr?minSpaces>.\n \n \n assignInTextExpr::= <dataPath?assign>[[ = | += <?append>] <objExpr?> \\> | \\> <textExpr>  \\<\\.=\\> ].\n \n forCtrl::= ( <$?forVariable> : <dataAccess?forContainer> [ && <condition> ] )  [\\{ [<statementBlock>] \\} | ; ] .\n \n forInText::= <$?forVariable> : <dataAccess?forContainer> [ && <condition> ] \\> <textExpr> \\<\\.for[ : <$?@checkForVariable> ]\\>. \n ##name is the name of the container element data reference\n \n ifCtrl::= <ifBlock> [{ elsif <ifBlock>  }][ else \\{ [<statementBlock?elseBlock>] \\} ].\n \n ifBlock::= ( <condition> ) [ \\{ [ <statementBlock> ] \\} | ; ] .\n \n ifInText::= <ifBlockInText?ifBlock> [{ \\<:elsif : <ifBlockInText?ifBlock>  }][ \\<:else\\> <textExpr?elseBlock> ] \\<\\.if\\>.\n \n ifBlockInText::= <conditionInText?condition> \\> <textExpr>.\n \n whileCtrl::= ( <condition> ) [ \\{ [<statementBlock>] \\} | ; ] .\n \n dowhileCtrl::=  \\{ [<statementBlock>] \\} while ( <condition> ) ; .\n \n \n onerror::= [ <#?errorLevel> \n            | [<?errortype> notfound | cmd | file | internal | exit ]\n            |]\n            \\{ [<statementBlock>] \\}.\n \n \n callSubroutine::= [{ <dataPath?assign> [ = | += <?append>] }] call <textValue?callName> ( [{ <namedArgument?actualArgument> ? , }] ) ; .\n \n callSubtext::=<textValueTextExpr?callName> [ : { <namedArgument?actualArgument> ? , }] \\>.\n \n namedArgument::= <$?name> = <objExpr?>.\n \n \n zmake::= [ : <$-?name> :[?=] ]     ##optional : name : of the zmake target, not ends with := \n          <textValue?zmakeOutput> := <textValue?callName> \n          ( { <namedArgument?actualArgument> | <filesetAccess> ? ,} ).\n \n \n ## An accessPath is a Filepath, see prepFilepath::=, but analyzed on Java level. \n filesetAccess::= [ <\"\"?accessPath> | \\<:\\><textExpr>\\<\\.\\> \n                  | & <dataAccess>      \n                  | <*\\ \\r\\n,)&?accessPath> ##will be converted to Filepath maybe with ':'\n                  |] [ & <dataAccess?zmakeFilesetVariable>] .    \n \n \n cmdLineWait::=[{ <dataPath?assign> += }] cmd\\  <cmdLine?>.\n \n cmdLine::= [\\!argsCheck!<?argsCheck>] <textValue?> [{[?;[\\ |\\n|\\r]] [ \\<\\:arg\\><textExpr?actualArgument>\\<\\.arg\\> | \\<\\:args:<dataAccess?argList>\\> |<textValue?actualArgument>] }] \n   [ \\<:stdout:[ pipe<?pipe>| [$]<$?stdoutVariable>] \\>] ;.\n \n iferrorlevel::= <#?errorLevel> \\{ [<statementBlock>] \\}.\n \n \n \n assignExpr::= [{ <dataPath?assign> [ = | += <?append>] }] <objExpr?> ;.\n \n \n threadBlock::= Thread <dataPath?defThreadVar> = [thread] \\{ <statementBlock> \\} \n              | thread \\{ <statementBlock> \\}.\n \n");
        }

        @Override
        protected void callWithoutArguments() {
        }

        @Override
        protected boolean checkArguments() {
            return this.argData.sFileScript != null;
        }
    }

    private static class Args {
        String sFileScript;
        String sFileTextOut;
        File fileTestXml;
        List<String> userArgs = new ArrayList<String>();

        private Args() {
        }
    }
}

