/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.header2Reflection;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.vishia.byteData.Field_Jc;
import org.vishia.header2Reflection.BinOutPrep;
import org.vishia.mainCmd.MainCmdLogging_ifc;
import org.vishia.util.Debugutil;
import org.vishia.util.FileSystem;
import org.vishia.util.StringFunctions;
import org.vishia.util.StringPart;
import org.vishia.util.StringPartFromFileLines;
import org.vishia.zbnf.ZbnfParseResultItem;
import org.vishia.zbnf.ZbnfParser;

@Deprecated
public class Header2Reflection {
    public static final String version = "2016-12-02";
    MainCmdLogging_ifc console;
    private final List<FileIn> listFileIn = new LinkedList<FileIn>();
    private ZbnfParser parser;
    private String sFileZbnf;
    private String sFileReflectionTypes;
    private String sFileReflectionTypesOut;
    private File fileReflectionBlockedTypes;
    private boolean bNewFileReflectionTypesOut = false;
    boolean c_only = false;
    private String sFileAllC;
    private String sFileBin;
    private boolean bCheckNewness = true;
    boolean fileBinBigEndian;
    boolean fileBinHex;
    private String sFileOffset;
    private String sOutDir = null;
    private String sOutDirAbs;
    private String sOffsetDirAbs;
    private final String[] sExprTokens = new String[]{"@@@", "$$$"};
    private final String[] sPlaceholderType = new String[]{"%%%"};
    private String sExprOffsField = "((int32)(&((@@@*)(0x1000))->$$$) ";
    private String sExprOffsBase = "(int32)(@@@*)0x1000)";
    private String sExprOffsObj = "(int32)&((@@@*)0x1000)->base.object)";
    private String sExprOffsCppObj = "(int32)(static_cast<ObjectJc*>((@@@*)0x1000)))";
    private String sExprOffsObjJcpp = "(int32)(static_cast<ObjectJc*>(static_cast<ObjectJcpp*>((@@@*)0x1000))))";
    private String sExprSizeType = "sizeof(%%%)";
    private final String sLinefeed = "\n";
    StringBuilder leaderTextC;
    StringBuilder trailerTextC;
    StringBuilder leaderTextH;
    StringBuilder trailerTextH;
    StringBuilder leaderTextOffs;
    StringBuilder trailerTextOffs;
    private static final String scalarTypes = "0-void:1-bool:1-boolean:4-float:4-float32:8-double:1-char:4-int:2-short:1-byte:4-int32:4-uint32:2-int16:2-uint16:1-int8:2-uint8:";
    static final String sSyntaxReflectionTypes = "$setLinemode. \nReflectionTypes::=\n{ \\n\n| \\<leaderTextOffs  [ = <textFile?leaderTextOffs>  \\> | \\> \\n<lines?leaderTextOffs>]\n| \\<trailerTextOffs [ = <textFile?trailerTextOffs> \\> | \\> \\n<lines?trailerTextOffs>]\n| \\<leaderTextC     [ = <textFile?leaderTextC>     \\> | \\> \\n<lines?leaderTextC>]\n| \\<trailerTextC    [ = <textFile?trailerTextC>    \\> | \\> \\n<lines?trailerTextC>]\n| \\<leaderTextH     [ = <textFile?leaderTextH>     \\> | \\> \\n<lines?leaderTextH>]\n| \\<trailerTextH    [ = <textFile?trailerTextH>    \\> | \\> \\n<lines?trailerTextH>]\n| exprOffsField = <\"\"?exprOffsField> \\n\n| exprOffsBase = <\"\"?exprOffsBase> \\n\n| exprOffsObj = <\"\"?exprOffsObj> \\n\n| exprOffsObjJcpp = <\"\"?exprOffsObjJcpp> \\n\n| exprOffsCppObj = <\"\"?exprOffsCppObj> \\n\n| exprSizeType = <\"\"?exprSizeType> \\n\n| <blockedFile> \\n \n|<?c_only> c_only \\n\n|<?define> #define <$?name> <*\\r\\n?value> \n| <reflectionType> \\n \n| \\n\n} \\e.\nblockedFile::= % <* ,\\r\\n?path>.\nreflectionType::= [<?sign>#|-] <* ,\\r\\n?type> \n| [<?sign>=|@] <* =?type> = [ <$?deftype>| 0x<#x?defvalue>| <#?defvalue>] \n| [<?sign>!|!] <* =?type> = [ <$?deftype>].\nlines::={[? \\<END\\>]<*\\n?line>\\n} \\<END\\> \\n.\ntextFile::= <\"\"?fileName>.\n";
    private final TreeMap<String, TypeEntry> identifierRelacements = new TreeMap();
    private final TreeMap<String, TypeEntry> types = new TreeMap();
    private final TreeMap<String, List<TypeEntry>> typesByFilename = new TreeMap();
    private BufferedWriter fileH;
    private BufferedWriter fileC;
    private BufferedWriter fileAllC;
    private BufferedWriter fileAllH;
    private BufferedWriter fileOffs;
    private StringBuilder bufferOffsArray;
    private Date dateNow;
    private int secondsAfter1970Now;
    private final SimpleDateFormat dataFormat = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss");
    BinOutPrep binOutPrep;
    final Map<String, String> idxDefines = new TreeMap<String, String>();

    public void setSyntax(String string) {
        this.sFileZbnf = string;
    }

    public void setCheckNewness(boolean bl) {
        this.bCheckNewness = bl;
    }

    public void setReflectionTypes(String string) {
        this.sFileReflectionTypes = string;
    }

    public void setReflectionTypesOut(String string, boolean bl) {
        this.sFileReflectionTypesOut = string;
        this.bNewFileReflectionTypesOut = bl;
    }

    public void setReflectionBlockedTypes(String string) {
        this.fileReflectionBlockedTypes = new File(string);
    }

    public void setConfig(String string) {
        this.fileReflectionBlockedTypes = new File(string);
    }

    public void setCfg(String string) {
        this.fileReflectionBlockedTypes = new File(string);
    }

    public boolean setOutC(String string) {
        boolean bl = true;
        this.sFileAllC = string.replace('\\', '/');
        try {
            FileSystem.mkDirPath(this.sFileAllC);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.console.writeError("Error path: " + string);
            bl = false;
        }
        return bl;
    }

    public boolean setOutOffset(String string) {
        boolean bl = true;
        this.sFileOffset = string.replace('\\', '/');
        try {
            FileSystem.mkDirPath(this.sFileOffset);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.console.writeError("Error path: " + string);
            bl = false;
        }
        return bl;
    }

    public boolean setOutBin(String string, boolean bl, boolean bl2) {
        boolean bl3 = true;
        this.sFileBin = string.replace('\\', '/');
        this.fileBinBigEndian = bl;
        this.fileBinHex = bl2;
        try {
            FileSystem.mkDirPath(this.sFileBin);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.console.writeError("Error path: " + string);
            bl3 = false;
        }
        return bl3;
    }

    public boolean setOutDir(String string) {
        boolean bl = true;
        this.sOutDir = string.replace('\\', '/');
        try {
            FileSystem.mkDirPath(this.sOutDir);
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl = false;
        }
        return bl;
    }

    public boolean addInputFilemask(String string) {
        boolean bl = true;
        int n = string.indexOf(58, 2);
        FileIn fileIn = new FileIn();
        File file = null;
        if (n > 2) {
            String string2 = string.substring(0, n);
            file = new File(string2);
            if (file.exists()) {
                try {
                    string = string.substring(n + 1);
                    String string3 = file.getCanonicalPath();
                    fileIn.posPath = string3.length();
                }
                catch (IOException iOException) {
                    bl = false;
                    this.console.writeError("input dir exception:" + file.getAbsolutePath());
                }
            } else {
                bl = false;
                File file2 = new File(".");
                String string4 = file2.getAbsolutePath();
                this.console.writeError("input dir not found:" + string2 + ", current Dir =" + string4);
            }
        } else {
            fileIn.posPath = -1;
        }
        if (bl) {
            bl = FileSystem.addFileToList(file, string, fileIn.listFileIn);
            if (!bl) {
                bl = false;
                if (file != null) {
                    this.console.writeError("input files not found:" + string + " in dir:" + file.getAbsolutePath());
                } else {
                    this.console.writeError("input files not found:" + string);
                }
            }
            this.listFileIn.add(fileIn);
        }
        return bl;
    }

    public Header2Reflection(MainCmdLogging_ifc mainCmdLogging_ifc) {
        this.console = mainCmdLogging_ifc;
        this.parser = new ZbnfParser(this.console, 10);
        this.parser.setReportIdents(1, 4, 5, 6);
    }

    public void execute() throws Exception {
        System.out.printf("Header2Reflection made by Hartmut Schorrig, version %s\n", version);
        if (this.readBlockedFilesAndTypes()) {
            if (this.init()) {
                boolean bl = false;
                File file = this.sFileAllC != null ? new File(this.sFileAllC) : null;
                long l = 0L;
                for (FileIn fileIn : this.listFileIn) {
                    for (File object : fileIn.listFileIn) {
                        if (!object.exists()) {
                            this.console.reportln(1, "File not found: " + object.getAbsolutePath());
                            continue;
                        }
                        long l2 = object.lastModified();
                        if (l2 <= l) continue;
                        l = l2;
                    }
                }
                this.secondsAfter1970Now = (int)(l / 1000L);
                this.dateNow = new Date(l);
                if (this.bCheckNewness && this.fileAllC != null && file.exists() && file.lastModified() > l) {
                    bl = true;
                }
                if (!bl) {
                    if (file != null) {
                        this.sOutDirAbs = file.getCanonicalPath().replace('\\', '/');
                        this.fileAllC = new BufferedWriter(new FileWriter(file));
                        int n = this.sFileAllC.lastIndexOf(46);
                        int n2 = this.sFileAllC.lastIndexOf(47);
                        String string = this.sFileAllC.substring(0, n) + ".h";
                        String string2 = this.sFileAllC.substring(n2 + 1, n) + ".h";
                        String string3 = this.sFileAllC.substring(n2 + 1, n);
                        this.fileAllH = new BufferedWriter(new FileWriter(new File(string)));
                        if (this.leaderTextC != null) {
                            this.fileAllC.append(this.leaderTextC);
                        }
                        this.fileAllC.write("\n/*This file is generated from Header2Reflection. */");
                        this.fileAllC.write("\n#define protected public  //only active inside this compilation unit");
                        this.fileAllC.write("\n#define private public    //  to enable the access to all elements.");
                        this.fileAllC.write("\n#include <Jc/ReflectionJc.h>");
                        this.fileAllC.write("\n#include <stddef.h>");
                        this.fileAllH.write("\n#ifndef __" + string3 + "_h__\n");
                        this.fileAllH.write("\n#define __" + string3 + "_h__\n");
                        if (this.leaderTextH != null) {
                            this.fileAllH.append(this.leaderTextH);
                        }
                        this.fileAllH.write("\n#include \"Jc/ReflectionJc.h\"");
                    }
                    if (this.sFileOffset != null) {
                        Iterator<FileIn> iterator = new File(this.sFileOffset);
                        this.sOffsetDirAbs = ((File)((Object)iterator)).getCanonicalPath().replace('\\', '/');
                        this.fileOffs = new BufferedWriter(new FileWriter((File)((Object)iterator)));
                        if (this.leaderTextOffs != null) {
                            this.fileOffs.append(this.leaderTextOffs);
                        }
                        this.fileOffs.append("\n/*This file is generated from Header2Reflection. */");
                        this.fileOffs.write("\n#include <os_types_def.h>");
                        this.fileOffs.write("\n#include <stddef.h>");
                        this.fileOffs.write("\n#define protected public  //only active inside this compilation unit");
                        this.fileOffs.write("\n#define private public    //  to enable the access to all elements.\n\n");
                        this.fileOffs.write("\n/**The seconds after 1970 where the this file and the apprpriated reflection in binfile where created.");
                        this.fileOffs.write("\n * It is " + this.dataFormat.format(this.dateNow) + "*/");
                        this.fileOffs.write("\nconst int reflectionOffsGenerationTime = " + this.secondsAfter1970Now + ";\n");
                        this.bufferOffsArray = new StringBuilder();
                    }
                    if (this.sFileBin != null) {
                        this.binOutPrep = new BinOutPrep(this.sFileBin, null, this.fileBinBigEndian, this.fileBinHex, this.secondsAfter1970Now);
                    }
                    for (FileIn fileIn : this.listFileIn) {
                        for (File file2 : fileIn.listFileIn) {
                            String string = file2.getCanonicalPath().replace('\\', '/');
                            string = string.substring(fileIn.posPath + 1);
                            this.translate(file2, string);
                        }
                    }
                    if (this.fileAllC != null) {
                        if (this.trailerTextC != null) {
                            this.fileAllC.append(this.trailerTextC);
                        }
                        this.fileAllC.close();
                        if (this.trailerTextH != null) {
                            this.fileAllH.append(this.trailerTextH);
                        }
                        this.fileAllH.write("\n#endif // ___h__\n");
                        this.fileAllH.close();
                    }
                    if (this.fileOffs != null) {
                        this.fileOffs.append("\n\n/**Array of all offsets: ------------------------------------------------------------------------*/");
                        this.fileOffs.append("\nint32* reflectionOffsetArrays[] = \n{ null");
                        this.fileOffs.append(this.bufferOffsArray);
                        this.fileOffs.append("\n};\n");
                        if (this.trailerTextOffs != null) {
                            this.fileOffs.append(this.trailerTextOffs);
                        }
                        this.fileOffs.close();
                    }
                    if (this.binOutPrep != null) {
                        this.binOutPrep.postProcessBinOut();
                        this.binOutPrep.close();
                    }
                    this.console.writeInfoln("...finished.");
                } else {
                    this.console.writeInfoln("...no newer files, nothing to do.");
                }
            }
        } else {
            this.console.writeError("read Reflection types failed.");
        }
    }

    private boolean readBlockedFilesAndTypes() throws ParseException, IllegalCharsetNameException, UnsupportedCharsetException, FileNotFoundException, IOException {
        ZbnfParser zbnfParser = new ZbnfParser(this.console, 10);
        this.console.writeInfoln("read ctrl-file: " + this.fileReflectionBlockedTypes.getAbsolutePath());
        zbnfParser.setSyntax(sSyntaxReflectionTypes);
        StringPartFromFileLines stringPartFromFileLines = null;
        stringPartFromFileLines = new StringPartFromFileLines(this.fileReflectionBlockedTypes, -1, null, null);
        boolean bl = zbnfParser.parse(stringPartFromFileLines);
        if (!bl) {
            this.console.writeError(zbnfParser.getSyntaxErrorReport());
            this.stop();
        } else {
            zbnfParser.reportStore(this.console, 4);
            List list = zbnfParser.getFirstParseResult().listChildren();
            for (ZbnfParseResultItem zbnfParseResultItem : list) {
                String string;
                String string2 = zbnfParseResultItem.getSemantic();
                if (string2.equals("c_only")) {
                    this.c_only = true;
                    continue;
                }
                if (string2.equals("exprOffsField")) {
                    this.sExprOffsField = zbnfParseResultItem.getParsedString();
                    continue;
                }
                if (string2.equals("exprOffsBase")) {
                    this.sExprOffsBase = zbnfParseResultItem.getParsedString();
                    continue;
                }
                if (string2.equals("exprOffsObj")) {
                    this.sExprOffsObj = zbnfParseResultItem.getParsedString();
                    continue;
                }
                if (string2.equals("exprOffsObjJcpp")) {
                    this.sExprOffsObjJcpp = zbnfParseResultItem.getParsedString();
                    continue;
                }
                if (string2.equals("exprOffsCppObj")) {
                    this.sExprOffsCppObj = zbnfParseResultItem.getParsedString();
                    continue;
                }
                if (string2.equals("exprSizeType")) {
                    this.sExprSizeType = zbnfParseResultItem.getParsedString();
                    continue;
                }
                if (string2.equals("define")) {
                    String string3 = zbnfParseResultItem.getChildString("name");
                    string = zbnfParseResultItem.getChildString("value");
                    this.idxDefines.put(string3, string);
                    continue;
                }
                if (string2.equals("reflectionType")) {
                    int n;
                    String string4;
                    char c = ((ZbnfParseResultItem)zbnfParseResultItem.getChild("sign")).getParsedText().charAt(0);
                    string = ((ZbnfParseResultItem)zbnfParseResultItem.getChild("type")).getParsedString();
                    ZbnfParseResultItem zbnfParseResultItem2 = (ZbnfParseResultItem)zbnfParseResultItem.getChild("deftype");
                    ZbnfParseResultItem zbnfParseResultItem3 = (ZbnfParseResultItem)zbnfParseResultItem.getChild("defvalue");
                    if (zbnfParseResultItem3 != null) {
                        string4 = null;
                        n = (int)zbnfParseResultItem3.getParsedInteger();
                    } else if ("=@!".indexOf(c) >= 0) {
                        string4 = zbnfParseResultItem2.getParsedString();
                        n = -1;
                    } else {
                        string4 = null;
                        n = -1;
                    }
                    TypeEntry typeEntry = new TypeEntry(string, string4, c, n);
                    this.identifierRelacements.put(string, typeEntry);
                    continue;
                }
                if (string2.equals("blockedFile")) {
                    this.stop();
                    continue;
                }
                if (string2.equals("leaderTextC")) {
                    this.leaderTextC = this.getLeaderTrailerText(zbnfParseResultItem, this.leaderTextC);
                    continue;
                }
                if (string2.equals("trailerTextC")) {
                    this.trailerTextC = this.getLeaderTrailerText(zbnfParseResultItem, this.trailerTextC);
                    continue;
                }
                if (string2.equals("leaderTextH")) {
                    this.leaderTextH = this.getLeaderTrailerText(zbnfParseResultItem, this.leaderTextH);
                    continue;
                }
                if (string2.equals("trailerTextH")) {
                    this.trailerTextH = this.getLeaderTrailerText(zbnfParseResultItem, this.trailerTextH);
                    continue;
                }
                if (string2.equals("leaderTextOffs")) {
                    this.leaderTextOffs = this.getLeaderTrailerText(zbnfParseResultItem, this.leaderTextOffs);
                    continue;
                }
                if (string2.equals("trailerTextOffs")) {
                    this.trailerTextOffs = this.getLeaderTrailerText(zbnfParseResultItem, this.trailerTextOffs);
                    continue;
                }
                throw new RuntimeException("unknown syntax definition: " + string2);
            }
        }
        return bl;
    }

    private StringBuilder getLeaderTrailerText(ZbnfParseResultItem zbnfParseResultItem, StringBuilder stringBuilder) {
        Object object;
        Object object2;
        List list;
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder(500);
        }
        if ((list = zbnfParseResultItem.listChildren("line")) != null) {
            object2 = list.iterator();
            while (object2.hasNext()) {
                object = (ZbnfParseResultItem)object2.next();
                stringBuilder.append(object.getParsedString()).append("\n");
            }
        }
        if ((object2 = zbnfParseResultItem.getChildString("fileName")) != null) {
            object = this.fileReflectionBlockedTypes.getParent() + "/" + (String)object2;
            File file = new File((String)object);
            if (!file.exists()) {
                stringBuilder.append("/*ERROR Header2Reflection - file not found: ").append((String)object).append("*/").append("\n");
            } else {
                String string = FileSystem.readFile(file);
                stringBuilder.append(string);
            }
        }
        return stringBuilder;
    }

    private boolean XXXreadReflectionTypes() throws ParseException, IllegalCharsetNameException, UnsupportedCharsetException, FileNotFoundException, IOException {
        ZbnfParser zbnfParser = new ZbnfParser(this.console, 10);
        this.console.writeInfoln("read reflection types: " + this.sFileReflectionTypes);
        zbnfParser.setSyntax(sSyntaxReflectionTypes);
        StringPartFromFileLines stringPartFromFileLines = null;
        stringPartFromFileLines = new StringPartFromFileLines(new File(this.sFileReflectionTypes), -1, null, null);
        boolean bl = zbnfParser.parse(stringPartFromFileLines);
        if (!bl) {
            this.console.writeError(zbnfParser.getSyntaxErrorReport());
            this.stop();
        } else {
            List list = zbnfParser.getFirstParseResult().listChildren("reflectionType");
            BufferedWriter bufferedWriter = null;
            if (this.bNewFileReflectionTypesOut) {
                bufferedWriter = new BufferedWriter(new FileWriter(new File(this.sFileReflectionTypesOut)));
                bufferedWriter.write("//********Generated Reflectiontypes*****************************************\n");
            }
            for (ZbnfParseResultItem zbnfParseResultItem : list) {
                List list2;
                String string;
                char c = ((ZbnfParseResultItem)zbnfParseResultItem.getChild("sign")).getParsedString().charAt(0);
                String string2 = ((ZbnfParseResultItem)zbnfParseResultItem.getChild("path")).getParsedString();
                int n = string2.lastIndexOf("/");
                String string3 = string2.substring(n + 1);
                LinkedList<Object> linkedList = new LinkedList<Object>();
                this.typesByFilename.put(string3, linkedList);
                if ("#.".indexOf(c) < 0) {
                    int n2 = string2.lastIndexOf(".");
                    if (n2 < n) {
                        n2 = string2.length();
                    }
                    string = string2.substring(n + 1, n2);
                    TypeEntry typeEntry = new TypeEntry(string2, string, c, 0);
                    this.types.put(string, typeEntry);
                    linkedList.add(typeEntry);
                }
                if (c == '#' || c == '-') {
                    TypeEntry typeEntry = new TypeEntry(string2, "###", '#', 0);
                    linkedList.add(typeEntry);
                }
                if ((list2 = zbnfParseResultItem.listChildren("type")) != null) {
                    for (ZbnfParseResultItem zbnfParseResultItem2 : list2) {
                        string = ((ZbnfParseResultItem)zbnfParseResultItem2.getChild("name")).getParsedString();
                        c = ((ZbnfParseResultItem)zbnfParseResultItem2.getChild("sign")).getParsedString().charAt(0);
                        TypeEntry typeEntry = new TypeEntry(string2, string, c, 0);
                        this.types.put(string, typeEntry);
                        linkedList.add(typeEntry);
                    }
                }
                if (c != '#' && c != '-' || bufferedWriter == null) continue;
                bufferedWriter.write("" + c + " " + string2 + "\n");
            }
            if (bufferedWriter != null) {
                bufferedWriter.flush();
                bufferedWriter.close();
            }
        }
        return bl;
    }

    private void writeReflectionTypes() throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(new File(this.sFileReflectionTypesOut), true));
        bufferedWriter.append("//***********************************************************************************\n");
        bufferedWriter.append("//from " + this.sFileAllC + "\n");
        Set<Map.Entry<String, List<TypeEntry>>> set = this.typesByFilename.entrySet();
        for (Map.Entry<String, List<TypeEntry>> entry : set) {
            List<TypeEntry> list = entry.getValue();
            if (list.size() <= 0 || list.get((int)0).sign == '#' || list.get((int)0).sign == '-') continue;
            String string = ". " + entry.getKey();
            for (TypeEntry typeEntry : list) {
                if (typeEntry.sign == '#' || typeEntry.sign == '-') continue;
                string = string + ", " + typeEntry.sign + " " + typeEntry.sType;
            }
            bufferedWriter.append(string + "\n");
        }
        bufferedWriter.close();
    }

    private boolean init() throws IllegalCharsetNameException, UnsupportedCharsetException, FileNotFoundException, IOException {
        Object object;
        boolean bl = true;
        if (this.sFileZbnf == null) {
            object = System.getenv("ZBNFJAX_HOME");
            if (object == null) {
                this.console.writeError("No -z:SYNTAX option, and the environment variable ZBNFJAX_HOME is unknown, abort.");
                bl = false;
            } else {
                this.sFileZbnf = (String)object + "/zbnf/Cheader.zbnf";
            }
        }
        if (bl) {
            object = new File(this.sFileZbnf);
            String string = FileSystem.readFile((File)object);
            if (string == null) {
                this.console.writeError("fault SYNTAX file, abort:" + this.sFileZbnf);
                bl = false;
            } else {
                this.parser = new ZbnfParser(this.console, 10);
                try {
                    this.parser.setSyntax(string);
                }
                catch (ParseException parseException) {
                    this.console.writeError("Headersyntax fault in " + this.sFileZbnf, parseException);
                    this.parser.reportSyntax(this.console, 4);
                    bl = false;
                }
                this.parser.setReportIdents(1, 3, 5, 6);
            }
        }
        return bl;
    }

    private void translate(File file, String string) throws IllegalCharsetNameException, UnsupportedCharsetException, FileNotFoundException, IOException, ParseException {
        String string2 = file.getName();
        this.console.writeInfoln("generate from " + string2 + "...");
        TypeEntry typeEntry = this.identifierRelacements.get(string);
        if (typeEntry == null || typeEntry.sign != '#' && typeEntry.sign != '-') {
            StringPartFromFileLines stringPartFromFileLines = null;
            stringPartFromFileLines = new StringPartFromFileLines(file, -1, null, null);
            boolean bl = this.parser.parse(stringPartFromFileLines);
            if (!bl) {
                String string3 = this.parser.getFoundedInputOnError();
                string3 = this.parser.getExpectedSyntaxOnError();
                string3 = this.parser.getSyntaxErrorReport();
                this.console.writeError(string3);
                this.stop();
            } else {
                Object object;
                this.parser.reportStore(this.console, 4);
                if (this.sOutDir != null) {
                    object = new File(this.sOutDir);
                    this.sOutDirAbs = ((File)object).getCanonicalPath().replace('\\', '/') + "/";
                    this.fileC = new BufferedWriter(new FileWriter(new File(this.sOutDir + "/Reflection_" + string2 + ".c")));
                    this.fileH = new BufferedWriter(new FileWriter(new File(this.sOutDir + "/Reflection_" + string2 + ".h")));
                } else {
                    this.fileC = this.fileAllC;
                    this.fileH = null;
                }
                object = this.parser.getFirstParseResult();
                if (object.getSemantic().equals("Cheader")) {
                    String string4;
                    String string5;
                    Iterator<ZbnfParseResultItem> iterator = object.iteratorChildren();
                    if (this.fileH != null) {
                        this.fileH.write("\n#ifndef __" + string2 + "_h__\n");
                        this.fileH.write("\n#define __" + string2 + "_h__\n");
                    }
                    if (FileSystem.isAbsolutePathOrDrive(string)) {
                        string5 = FileSystem.relativatePath(string, this.sOutDirAbs);
                        string4 = this.sOffsetDirAbs != null ? FileSystem.relativatePath(string, this.sOffsetDirAbs) : null;
                    } else {
                        string4 = string5 = string;
                    }
                    this.fileC.write("\n#include \"" + string5 + "\"\n");
                    if (this.fileH != null) {
                        this.fileH.flush();
                    }
                    this.fileC.flush();
                    if (this.fileOffs != null) {
                        this.fileOffs.write("\n\n\n#include \"" + string4 + "\"\n");
                    }
                    while (iterator.hasNext()) {
                        object = iterator.next();
                        String string6 = object.getSemantic();
                        if (!string6.equals("outside") && !string6.equals("CLASS_C")) continue;
                        String string7 = null;
                        if (string6.equals("CLASS_C")) {
                            string7 = ((ZbnfParseResultItem)object.getChild("@name")).getParsedString();
                        }
                        this.searchAndTranslateClassDef((ZbnfParseResultItem)object, string7, string);
                    }
                    if (this.fileH != null) {
                        this.fileH.write("#endif //__" + string2 + "_h__\n");
                        this.fileH.flush();
                    }
                    this.fileC.flush();
                }
            }
        } else {
            this.console.writeInfo(" ignored.");
        }
    }

    private void searchAndTranslateClassDef(ZbnfParseResultItem zbnfParseResultItem, String string, String string2) throws IOException {
        String string3 = string + "_s";
        String string4 = string + "_i";
        Iterator<ZbnfParseResultItem> iterator = zbnfParseResultItem.iteratorChildren();
        while (iterator.hasNext()) {
            String string5;
            Object object;
            ZbnfParseResultItem zbnfParseResultItem2 = iterator.next();
            String string6 = zbnfParseResultItem2.getSemantic();
            if (string6.equals("structDefinition") || string6.equals("unionDefinition") || !this.c_only && string6.equals("classDef")) {
                ZbnfParseResultItem zbnfParseResultItem3 = (ZbnfParseResultItem)zbnfParseResultItem2.getChild("description");
                String string7 = zbnfParseResultItem3 == null ? null : zbnfParseResultItem3.getChildString("refl");
                ZbnfParseResultItem zbnfParseResultItem4 = (ZbnfParseResultItem)zbnfParseResultItem2.getChild("@name");
                if (zbnfParseResultItem4 == null) {
                    zbnfParseResultItem4 = (ZbnfParseResultItem)zbnfParseResultItem2.getChild("@tagname");
                    if (zbnfParseResultItem4 != null) {
                        object = zbnfParseResultItem4.getParsedString();
                        string5 = "struct " + (String)object;
                    } else {
                        object = null;
                        string5 = null;
                    }
                } else {
                    object = zbnfParseResultItem4.getParsedString();
                    string5 = object;
                }
                if (object != null) {
                    if (string6.equals("unionDefinition")) {
                        this.stop();
                    }
                    if (((String)object).equals("ObjectJcMTB")) {
                        this.stop();
                    }
                    if (((String)object).equals("ObjectJcpp")) {
                        this.stop();
                    }
                    if (((String)object).equals("ObjectJc")) {
                        this.stop();
                    }
                    if (string7 != null) {
                        this.stop();
                    }
                    if (string7 != null && string7.equals("no") || string != null && !string.equals(object) && !string3.equals(object) && !string4.equals(object)) continue;
                    boolean bl = string6.equals("classDef");
                    ConverterClass converterClass = new ConverterClass(null);
                    converterClass.convertClass((String)object, string5, null, null, zbnfParseResultItem2, string2, bl);
                    continue;
                }
                this.stop();
                continue;
            }
            if (string6.equals("conditionBlock")) {
                boolean bl = true;
                object = (ZbnfParseResultItem)zbnfParseResultItem2.getChild("conditionDef");
                if (object != null) {
                    string5 = object.getParsedString();
                    boolean bl2 = bl = this.idxDefines.get(string5) != null;
                }
                if (!bl) continue;
                this.searchAndTranslateClassDef(zbnfParseResultItem2, string, string2);
                continue;
            }
            if (!string6.equals("defineDefinition") || (object = (ZbnfParseResultItem)zbnfParseResultItem2.getChild("@name")) == null) continue;
            string5 = object.getParsedString();
            this.idxDefines.put(string5, string5);
        }
    }

    void stop() {
    }

    private class ConverterClass {
        boolean cppClass;
        boolean bObjectJcpp = false;
        boolean bClassBasedOnObjectJc = false;
        boolean bStructHasFirstObjectJc = false;
        boolean bObjectifcBaseJcpp = false;
        String sReflectionClassName;
        String sCppClassName;
        String sTypeName;
        int bitfieldPos;
        int bitfieldByte;
        String lastOffsetBeforeBitfield = null;
        String lastType;
        final TreeMap<String, String> innerTypes;
        static final int mObjectJc_Modifier_reflectJc = 0x4000000;
        static final int mObjectifcBaseJcpp_Modifier_reflectJc = 0x8000000;
        int nrofAttributes;
        boolean bFirst;
        StringBuffer sbCfile = new StringBuffer(50000);
        StringBuffer sbForward = new StringBuffer(5000);
        String sSeparator = "\n    ";

        ConverterClass(TreeMap<String, String> treeMap) {
            this.innerTypes = new TreeMap();
            if (treeMap != null) {
                this.innerTypes.putAll(treeMap);
            }
        }

        private void convertClass(String string, String string2, String string3, String string4, ZbnfParseResultItem zbnfParseResultItem, String string5, boolean bl) throws IOException {
            Object object;
            Object object22;
            List list;
            this.cppClass = bl;
            this.sReflectionClassName = string4 != null ? string4 + "_" + string : string;
            this.sCppClassName = string3 != null ? string3 + "::" + string : string;
            String string6 = this.sTypeName = string3 != null ? string3 + "::" + string : string2;
            if (string.equals("ListItr_LinkedListJcpp")) {
                Header2Reflection.this.stop();
            }
            if (string.equals("ObjectJcpp")) {
                Header2Reflection.this.stop();
            }
            if (string.equals("ObjectJc")) {
                Header2Reflection.this.stop();
            }
            String string7 = "0 ";
            int n = 0;
            Header2Reflection.this.console.writeInfo(string2 + "...");
            if (Header2Reflection.this.fileAllH != null) {
                Header2Reflection.this.fileAllH.write("\nextern_C const ClassJc reflection_" + this.sReflectionClassName + ";");
                Header2Reflection.this.fileAllH.write("\n#define REFLECTION_" + this.sReflectionClassName + " &reflection_" + this.sReflectionClassName);
            }
            if ((list = zbnfParseResultItem.listChildren("classVisibilityBlock")) != null) {
                for (Object object22 : list) {
                    this.convertInnerClassAndStruct(this.sCppClassName, this.sReflectionClassName, (ZbnfParseResultItem)object22, this.innerTypes, string5, bl);
                }
            }
            this.convertInnerClassAndStruct(this.sCppClassName, this.sReflectionClassName, zbnfParseResultItem, this.innerTypes, string5, bl);
            if (bl) {
                Header2Reflection.this.fileC.append("\n#if defined(__CPLUSGEN) && defined(__cplusplus)\n");
            }
            List list2 = zbnfParseResultItem.listChildren("superclass");
            object22 = (TypeEntry)Header2Reflection.this.identifierRelacements.get(string);
            if (object22 != null && ((TypeEntry)object22).sign == '!') {
                object = ((TypeEntry)object22).sPath;
                this.testBasedOnObject((String)object);
            }
            if (list2 != null) {
                object22 = list2.iterator();
                while (object22.hasNext()) {
                    object = (ZbnfParseResultItem)object22.next();
                    String string8 = ((ZbnfParseResultItem)object.getChild("name")).getParsedString();
                    this.testBasedOnObject(string8);
                }
            }
            if (this.sReflectionClassName.equals("ObjectJc")) {
                this.bClassBasedOnObjectJc = false;
            } else if (this.sReflectionClassName.equals("bObjectifcBaseJcpp")) {
                this.bObjectifcBaseJcpp = false;
            }
            int n2 = this.sCppClassName.length();
            if (n2 <= 31) {
                object22 = this.sCppClassName;
            } else {
                int n3 = 17;
                object22 = this.sCppClassName.substring(0, 13) + "_" + this.sCppClassName.substring(n2 - n3, n2);
            }
            int n4 = Header2Reflection.this.binOutPrep != null ? Header2Reflection.this.binOutPrep.addClass(this.sCppClassName, (String)object22) : 0;
            if (Header2Reflection.this.fileOffs != null) {
                Header2Reflection.this.fileOffs.append("\n\nint32 reflectionOffset_" + this.sReflectionClassName + "[] =\n{ " + n4 + "   //index of offset table");
                Header2Reflection.this.bufferOffsArray.append("\n, &reflectionOffset_" + this.sReflectionClassName + "[0]");
            }
            this.nrofAttributes = 0;
            this.bFirst = true;
            this.convertElementsInClass(zbnfParseResultItem, null);
            Header2Reflection.this.fileC.append("\n\nextern_C const ClassJc reflection_" + this.sReflectionClassName + ";  //the just defined reflection_");
            if (this.nrofAttributes > 0) {
                Header2Reflection.this.fileC.append(this.sbForward);
                this.sbForward.setLength(0);
                Header2Reflection.this.fileC.append("\nconst struct Reflection_Fields_" + this.sReflectionClassName + "_t");
                Header2Reflection.this.fileC.append("\n{ ObjectArrayJc head;");
                Header2Reflection.this.fileC.append("\n  FieldJc data[" + this.nrofAttributes + "];");
                Header2Reflection.this.fileC.append("\n} reflection_Fields_" + this.sReflectionClassName + " =");
                Header2Reflection.this.fileC.append("\n{ CONST_ObjectArrayJc(FieldJc, " + this.nrofAttributes + ", OBJTYPE_FieldJc, null, &reflection_Fields_" + this.sReflectionClassName + ")");
                Header2Reflection.this.fileC.append("\n, {");
                Header2Reflection.this.fileC.append(this.sbCfile);
                this.sbCfile.setLength(0);
                Header2Reflection.this.fileC.append("\n} };\n\n");
            }
            if (Header2Reflection.this.fileOffs != null) {
                Header2Reflection.this.fileOffs.append("\n};\n");
            }
            this.sbCfile.append("\nconst ClassJc reflection_" + this.sReflectionClassName + " =");
            this.sbCfile.append("\n{ CONST_ObjectJc(OBJTYPE_ClassJc + sizeof(ClassJc), &reflection_" + this.sReflectionClassName + ", &reflection_ClassJc)");
            this.sbCfile.append("\n, \"" + (String)object22 + "\"");
            if (this.sReflectionClassName.equals("ObjectJc")) {
                string7 = string7 + " |mObjectJc_Modifier_reflectJc";
                n |= 0x4000000;
            }
            if (this.bObjectJcpp) {
                assert (bl);
                this.sbCfile.append("\n, (int)(static_cast<ObjectJc*>(static_cast<ObjectJcpp*>((" + this.sCppClassName + "*)0x1000))) - 0x1000     //posObjectJc");
                string7 = string7 + " |mObjectJc_Modifier_reflectJc";
                n |= 0x4000000;
            } else if (this.bStructHasFirstObjectJc) {
                this.sbCfile.append("\n, 0");
                string7 = string7 + " |mObjectJc_Modifier_reflectJc";
                n |= 0x4000000;
            } else if (this.bClassBasedOnObjectJc) {
                if (Header2Reflection.this.c_only || !bl) {
                    this.sbCfile.append("\n, (int)&((" + this.sCppClassName + "*)0x1000)->base.object) - 0x1000     //posObjectJc");
                } else {
                    this.sbCfile.append("\n, (int)(static_cast<ObjectJc*>((" + this.sCppClassName + "*)0x1000)) - 0x1000     //posObjectJc");
                }
                string7 = string7 + " |mObjectJc_Modifier_reflectJc";
                n |= 0x4000000;
            } else if (this.bObjectifcBaseJcpp) {
                assert (bl);
                this.sbCfile.append("\n, (int)(static_cast<ObjectifcBaseJcpp*>((" + this.sCppClassName + "*)0x1000)) - 0x1000     //posObjectJc");
                string7 = string7 + " |mObjectifcBaseJcpp_Modifier_reflectJc";
                n |= 0x8000000;
            } else {
                this.sbCfile.append("\n, 0");
            }
            this.sbCfile.append("\n, sizeof(" + this.sCppClassName + ")");
            if (this.nrofAttributes > 0) {
                this.sbCfile.append("\n, (FieldJcArray const*)&reflection_Fields_" + this.sReflectionClassName + "  //attributes and associations");
                if (Header2Reflection.this.binOutPrep != null) {
                    Header2Reflection.this.binOutPrep.setAttributRef(this.nrofAttributes);
                }
            } else {
                this.sbCfile.append("\n, null  //attributes");
            }
            this.sbCfile.append("\n, null  //method");
            this.sbCfile.append("\n, null  //superclass");
            this.sbCfile.append("\n, null  //interfaces");
            this.sbCfile.append("\n, " + string7);
            this.sbCfile.append("\n};\n\n\n");
            Header2Reflection.this.fileC.append(this.sbCfile.toString());
            if (bl) {
                Header2Reflection.this.fileC.append("\n#endif //C++-class\n");
            }
        }

        private void convertElementsInClass(ZbnfParseResultItem zbnfParseResultItem, String string) throws IOException {
            List list = zbnfParseResultItem.listChildren();
            for (ZbnfParseResultItem zbnfParseResultItem2 : list) {
                this.convertElement(zbnfParseResultItem2, string);
            }
        }

        private void convertElement(ZbnfParseResultItem zbnfParseResultItem, String string) throws IOException {
            String string2;
            int n = zbnfParseResultItem.getInputLine();
            String string3 = zbnfParseResultItem.getInputFile();
            if (n >= 0 && n < 41 && StringFunctions.equals(string3, "D:/xxx/+bus_header/lib_Ctrl_Smlk.h")) {
                Header2Reflection.this.stop();
            }
            if ((string2 = zbnfParseResultItem.getSemantic()).equals("implicitStructAttribute")) {
                String string4 = zbnfParseResultItem.getChildString("@name");
                this.convertElementsInClass(zbnfParseResultItem, string4);
            } else if (string2.equals("implicitUnionAttribute")) {
                String string5 = zbnfParseResultItem.getChildString("@name");
                this.convertElementsInClass(zbnfParseResultItem, string5);
            } else if (string2.equals("attribute")) {
                if (this.convertAttribute(this.bFirst, this.sSeparator, this.sCppClassName, this.sReflectionClassName, string, zbnfParseResultItem, this.sbCfile, this.sbForward, this.cppClass)) {
                    ++this.nrofAttributes;
                    this.sSeparator = "\n  , ";
                    this.bFirst = false;
                }
            } else if (string2.equals("classVisibilityBlock")) {
                this.convertElementsInClass(zbnfParseResultItem, null);
            } else if (string2.equals("variante")) {
                this.lastOffsetBeforeBitfield = null;
                ZbnfParseResultItem zbnfParseResultItem2 = zbnfParseResultItem.firstChild();
                this.convertElement(zbnfParseResultItem2, null);
            } else if (string2.equals("structDefinition")) {
                String string6 = zbnfParseResultItem.getChildString("@name");
                this.convertElementsInClass(zbnfParseResultItem, string6);
            } else if (string2.equals("structContentInsideCondition")) {
                boolean bl = true;
                ZbnfParseResultItem zbnfParseResultItem3 = (ZbnfParseResultItem)zbnfParseResultItem.getChild("conditionDef");
                if (zbnfParseResultItem3 != null) {
                    String string7 = zbnfParseResultItem3.getParsedString();
                    boolean bl2 = bl = Header2Reflection.this.idxDefines.get(string7) != null;
                }
                if (bl) {
                    this.convertElementsInClass(zbnfParseResultItem, string);
                }
            }
        }

        void testBasedOnObject(String string) {
            if (string.equals("ObjectJcpp") || string.equals("Object_Jcpp")) {
                this.bObjectJcpp = true;
            } else if (string.equals("ObjectJc") || string.equals("ObjectJc_h") || string.equals("Object_Jc")) {
                this.bClassBasedOnObjectJc = true;
            } else if (string.equals("ObjectifcBaseJcpp") || string.equals("ObjectifcBase_Jcpp")) {
                this.bObjectifcBaseJcpp = true;
            }
        }

        void convertInnerClassAndStruct(String string, String string2, ZbnfParseResultItem zbnfParseResultItem, TreeMap<String, String> treeMap, String string3, boolean bl) throws IOException {
            List list = zbnfParseResultItem.listChildren("classDef");
            if (list != null) {
                for (ZbnfParseResultItem zbnfParseResultItem2 : list) {
                    String string4 = ((ZbnfParseResultItem)zbnfParseResultItem2.getChild("@name")).getParsedString();
                    this.innerTypes.put(string4, string2);
                    ConverterClass converterClass = new ConverterClass(treeMap);
                    converterClass.convertClass(string4, string4, string, string2, zbnfParseResultItem2, string3, bl);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean convertAttribute(boolean bl, String string, String string2, String string3, String string4, ZbnfParseResultItem zbnfParseResultItem, StringBuffer stringBuffer, StringBuffer stringBuffer2, boolean bl2) throws IOException {
            int n;
            Object object;
            Object object2;
            int n2;
            Object object3;
            Object object4;
            Object object5;
            String string5;
            String string6 = zbnfParseResultItem.getChildString("@name");
            String string7 = string6 == null ? null : (string5 = string4 == null ? string6 : string4 + "-" + string6);
            if (string5 != null && string5.equals("var1")) {
                Header2Reflection.this.stop();
            }
            if (bl && Header2Reflection.this.binOutPrep != null) {
                Header2Reflection.this.binOutPrep.addFieldHead();
            }
            boolean bl3 = false;
            boolean bl4 = false;
            String string8 = null;
            String string9 = null;
            int n3 = 0;
            ZbnfParseResultItem zbnfParseResultItem2 = (ZbnfParseResultItem)zbnfParseResultItem.getChild("description");
            if (zbnfParseResultItem2 != null) {
                string8 = zbnfParseResultItem2.getChildString("containerElementType");
                if (string8 != null) {
                    string9 = zbnfParseResultItem2.getChildString("containerType");
                    boolean bl5 = bl4 = zbnfParseResultItem2.getChild("referencedContainerElement") != null;
                }
                if ((object5 = zbnfParseResultItem2.listChildren("refl")) != null) {
                    object4 = object5.iterator();
                    while (object4.hasNext()) {
                        ZbnfParseResultItem zbnfParseResultItem3 = (ZbnfParseResultItem)object4.next();
                        object3 = zbnfParseResultItem3.getParsedString();
                        if (!((String)object3).startsWith("arrayLength")) continue;
                        n2 = ((String)object3).indexOf(61);
                        if (n2 < 0) throw new IllegalArgumentException(" Annotation refl: arrayLength = value: \"= value\" is missed. ");
                        if (((String)object3).length() < n2 + 1) {
                            throw new IllegalArgumentException(" Annotation refl: arrayLength = value: \"= value\" is missed. ");
                        }
                        object2 = ((String)object3).substring(n2 + 1).trim();
                        object = (TypeEntry)Header2Reflection.this.identifierRelacements.get(object2);
                        if (object != null && ((TypeEntry)object).sType == null) {
                            n3 = ((TypeEntry)object).value;
                            continue;
                        }
                        try {
                            n3 = Integer.parseInt((String)object2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            n3 = 1;
                            throw new IllegalArgumentException(" Annotation refl: arrayLength = " + (String)object2 + ": This value isn't a number and it isn't found in the replacements. \nHint: You can add a replacement writing a line \"@ident = [0x]value\" in the config-file.");
                        }
                    }
                }
            }
            if ((object5 = (ZbnfParseResultItem)zbnfParseResultItem.getChild("type")) == null) {
                if (zbnfParseResultItem.getChild("@implicitStruct") == null) {
                    Header2Reflection.this.stop();
                    return false;
                }
                object3 = (ZbnfParseResultItem)zbnfParseResultItem.getChild("@tagname");
                object4 = object3 != null ? object3.getParsedString() : string5;
                n = 0;
            } else {
                object3 = (ZbnfParseResultItem)object5.getChild("@name");
                if (object3 == null) {
                    Header2Reflection.this.stop();
                    return false;
                }
                object4 = object3.getParsedString();
                n = object5.getChild("@pointer") != null || object5.getChild("@constPointer") != null || object5.getChild("@volatilePointer") != null || object5.getChild("@cppRef") != null ? 1 : (object5.getChild("@volatilePointer2") != null || object5.getChild("@pointerRef") != null || object5.getChild("@pointer2") != null ? 2 : 0);
                int n4 = n2 = object5.getChild("@forward") != null ? 1 : 0;
                if (((String)object4).equals("ObjectJc") && bl) {
                    this.bStructHasFirstObjectJc = true;
                }
                if (((String)object4).equals("char")) {
                    Header2Reflection.this.stop();
                }
                if ((object2 = (TypeEntry)Header2Reflection.this.identifierRelacements.get(object4)) != null) {
                    if (((TypeEntry)object2).sign == (n2 != 0 ? (char)'@' : '=')) {
                        object4 = ((TypeEntry)object2).sPath;
                    }
                } else if (n2 != 0 && ((String)object4).endsWith("_t")) {
                    if (((String)object4).equals("Type_t")) {
                        Debugutil.stop();
                    }
                    object4 = ((String)object4).substring(0, ((String)object4).length() - 2);
                }
            }
            if (string8 != null) {
                object4 = string8;
            }
            if (string5 != null && string5.equals("TEST")) {
                Header2Reflection.this.stop();
            }
            if (string5 == null) {
                object3 = null;
            } else {
                n2 = string5.length();
                if (n2 <= 29) {
                    object3 = string5;
                } else {
                    int n5 = 15;
                    object3 = string5.substring(0, 13) + "_" + string5.substring(n2 - n5, n2);
                }
                stringBuffer.append(string + "{ \"" + (String)object3 + "\"");
            }
            ZbnfParseResultItem zbnfParseResultItem4 = (ZbnfParseResultItem)zbnfParseResultItem.getChild("bitField");
            int n6 = zbnfParseResultItem4 != null ? (int)zbnfParseResultItem4.getParsedInteger() : -1;
            object = new FieldTypeInfos();
            this.setFieldTypeInfos((String)object4, stringBuffer2, (FieldTypeInfos)object, n6);
            int n7 = 0;
            ZbnfParseResultItem zbnfParseResultItem5 = (ZbnfParseResultItem)zbnfParseResultItem.getChild("arraysize");
            if (string5 != null) {
                String string10;
                Object object6;
                Object object7;
                int n8 = 0;
                if (n6 >= 0) {
                    assert (zbnfParseResultItem5 == null);
                    n7 = (n6 << 12 & 0xF000) + (this.bitfieldByte << 3) + this.bitfieldPos;
                    stringBuffer.append("\n    , 0x" + Integer.toHexString(n7));
                    stringBuffer.append(" //bitfield nrofBits=" + n6);
                    stringBuffer.append(", bitPos=").append(this.bitfieldByte).append(".").append(this.bitfieldPos);
                } else if (zbnfParseResultItem5 == null) {
                    if (n3 > 0) {
                        n7 = n3;
                        stringBuffer.append("\n    , " + n7).append("   //nrofArrayElements per Annotation");
                    } else {
                        n7 = 0;
                        stringBuffer.append("\n    , 0   //no Array, no Bitfield");
                    }
                } else {
                    object7 = zbnfParseResultItem5.iteratorChildren();
                    while (object7.hasNext()) {
                        object6 = object7.next();
                        if (object6.getSemantic().equals("@value")) {
                            n7 = (int)object6.getParsedInteger();
                            continue;
                        }
                        if (object6.getSemantic().equals("@symbolValue")) {
                            string10 = object6.getParsedString();
                            TypeEntry typeEntry = (TypeEntry)Header2Reflection.this.identifierRelacements.get(string10);
                            if (typeEntry != null && typeEntry.value > 0) {
                                n7 = typeEntry.value;
                                continue;
                            }
                            n7 = 0;
                            Header2Reflection.this.console.writeWarning("symbolic arraysize: " + string10 + " - no value.");
                            continue;
                        }
                        if (!object6.getSemantic().equals("binaryOperator")) continue;
                        Header2Reflection.this.console.writeWarning("not supported yet: binary operator in arraysize ");
                    }
                    stringBuffer.append("\n    , " + n7).append("   //nrofArrayElements");
                }
                if (n6 >= 0) {
                    stringBuffer.append("\n    , REFLECTION_BITFIELD");
                    stringBuffer.append("\n    , kBitfield_Modifier_reflectJc");
                    n8 |= 0x70000;
                } else if (((FieldTypeInfos)object).bytesScalarType >= 0) {
                    stringBuffer.append("\n    , REFLECTION_" + (String)object4);
                    stringBuffer.append("\n    , (" + ((FieldTypeInfos)object).bytesScalarType + "<<kBitPrimitiv_Modifier_reflectJc)");
                    n8 = ((FieldTypeInfos)object).bytesScalarType << 16;
                } else {
                    if (((FieldTypeInfos)object).useReflection) {
                        stringBuffer.append("\n    , &reflection_" + (String)object4);
                    } else {
                        stringBuffer.append("\n    , REFLECTION_void");
                    }
                    stringBuffer.append("\n    , 0");
                }
                if (string9 != null) {
                    if (string9.equals("ObjectArrayJc")) {
                        stringBuffer.append("| kObjectArrayJc_Modifier_reflectJc");
                        n8 |= 0x200000;
                    }
                    if (n > 0) {
                        stringBuffer.append("| kReferencedContainer_Modifier_reflectJc");
                        n8 |= 0x20000000;
                    } else {
                        stringBuffer.append("| kEmbeddedContainer_Modifier_reflectJc");
                        n8 |= 0x10000000;
                    }
                    n = bl4 ? 1 : 0;
                } else if (n3 > 0 && n > 0) {
                    stringBuffer.append("| kReferencedContainer_Modifier_reflectJc");
                    n8 |= 0x20000000;
                    --n;
                }
                if (n > 0) {
                    stringBuffer.append("| mReference_Modifier_reflectJc");
                    n8 |= 0x2000000;
                }
                if (zbnfParseResultItem5 != null && n7 > 1) {
                    stringBuffer.append(" |kStaticArray_Modifier_reflectJc|kEmbeddedContainer_Modifier_reflectJc");
                    n8 |= 0x10800000;
                }
                if (n3 > 0) {
                    stringBuffer.append(" |kStaticArray_Modifier_reflectJc");
                    n8 |= 0x800000;
                }
                stringBuffer.append(" //bitModifiers");
                if (n6 < 0) {
                    object7 = this.buildOffset(this.sTypeName, string5, bl2);
                    this.bitfieldPos = 0;
                    this.bitfieldByte = 0;
                    this.lastOffsetBeforeBitfield = object7;
                    this.lastType = (String)object4 + "****".substring(0, n);
                } else if (this.lastOffsetBeforeBitfield == null) {
                    object7 = "0";
                } else {
                    object6 = new StringBuilder(299);
                    ((StringBuilder)object6).append(this.lastOffsetBeforeBitfield + " + ");
                    object7 = StringPart.replace(Header2Reflection.this.sExprSizeType, Header2Reflection.this.sPlaceholderType, new String[]{this.lastType}, (StringBuilder)object6).toString();
                }
                if (Header2Reflection.this.fileOffs != null) {
                    object6 = n > 0 ? "void*" : object4;
                    string10 = StringPart.replace(Header2Reflection.this.sExprSizeType, Header2Reflection.this.sPlaceholderType, new String[]{object6}, null).toString();
                    Header2Reflection.this.fileOffs.write("\n    , (" + string10 + "<<16) | (" + (String)object7 + ")");
                    stringBuffer.append("\n    , -1   //offset in extra file");
                } else {
                    stringBuffer.append("\n    , (int16)" + (String)object7);
                }
                stringBuffer.append("\n    , 0  //offsetToObjectifcBase");
                stringBuffer.append("\n    , &reflection_" + string3);
                stringBuffer.append("\n    }");
                if (Header2Reflection.this.binOutPrep != null && string5 != null) {
                    Header2Reflection.this.binOutPrep.addField((String)object3, ((FieldTypeInfos)object).typeIdent, (String)object4, n8, n7);
                }
            }
            if (n6 >= 0) {
                this.bitfieldPos += n6;
                if (this.bitfieldPos > 8) {
                    this.bitfieldPos -= 8;
                    ++this.bitfieldByte;
                }
            }
            if (string5 == null) return false;
            return true;
        }

        String buildOffset(String string, String string2, boolean bl) {
            String string3 = string2.replace('-', '.');
            CharSequence[] charSequenceArray = new String[]{string, string3};
            String string4 = StringPart.replace(Header2Reflection.this.sExprOffsField, Header2Reflection.this.sExprTokens, charSequenceArray, null).toString();
            if (this.bObjectJcpp) {
                assert (bl);
                string4 = string4 + "-" + StringPart.replace(Header2Reflection.this.sExprOffsObjJcpp, Header2Reflection.this.sExprTokens, charSequenceArray, null);
            } else {
                string4 = this.bClassBasedOnObjectJc ? (Header2Reflection.this.c_only || !bl ? string4 + "-" + StringPart.replace(Header2Reflection.this.sExprOffsObj, Header2Reflection.this.sExprTokens, charSequenceArray, null) : string4 + "-" + StringPart.replace(Header2Reflection.this.sExprOffsCppObj, Header2Reflection.this.sExprTokens, charSequenceArray, null)) : string4 + "-" + StringPart.replace(Header2Reflection.this.sExprOffsBase, Header2Reflection.this.sExprTokens, charSequenceArray, null);
            }
            return string4;
        }

        void setFieldTypeInfos(String string, StringBuffer stringBuffer, FieldTypeInfos fieldTypeInfos, int n) {
            boolean bl;
            int n2;
            int n3;
            Field_Jc.TypeSizeIdent typeSizeIdent = Field_Jc.getTypeSizeIdent(string);
            if (n > 0) {
                n3 = 7;
                n2 = 23;
                bl = true;
            } else if (typeSizeIdent != null) {
                n3 = typeSizeIdent.size;
                n2 = typeSizeIdent.ident;
                bl = true;
            } else {
                n3 = -1;
                if (string.startsWith("MT_")) {
                    bl = false;
                    n2 = 0;
                } else {
                    String string2 = this.innerTypes.get(string);
                    if (string2 != null) {
                        string = string2 + "_" + string;
                        n2 = 0;
                        bl = true;
                    } else {
                        TypeEntry typeEntry = (TypeEntry)Header2Reflection.this.identifierRelacements.get(string);
                        if (typeEntry != null && (typeEntry.sign == '#' || typeEntry.sign == '-')) {
                            bl = false;
                            n2 = 0;
                        } else {
                            bl = true;
                            n2 = -1;
                        }
                    }
                    if (bl) {
                        stringBuffer.append("\nextern_C const ClassJc reflection_" + string + ";");
                    }
                }
            }
            fieldTypeInfos.bytesScalarType = n3;
            fieldTypeInfos.typeIdent = n2;
            fieldTypeInfos.useReflection = bl;
        }

        byte[] int2bytes4(int n) {
            byte[] byArray = new byte[]{(byte)(n >> 24), (byte)(n >> 16), (byte)(n >> 8), (byte)n};
            return byArray;
        }

        public String toString() {
            String string = "" + this.bitfieldPos + this.innerTypes;
            return string;
        }
    }

    static class FieldTypeInfos {
        int bytesScalarType;
        boolean useReflection;
        int typeIdent;

        FieldTypeInfos() {
        }
    }

    private static class TypeEntry {
        final String sType;
        final String sPath;
        final int value;
        char sign;

        TypeEntry(String string, String string2, char c, int n) {
            this.sType = string;
            this.sPath = string2;
            this.sign = c;
            this.value = n;
        }
    }

    static class FileIn {
        final List<File> listFileIn = new LinkedList<File>();
        int posPath;

        FileIn() {
        }
    }
}

