/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.fileRemote;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.vishia.event.EventCmdtypeWithBackEvent;
import org.vishia.event.EventConsumer;
import org.vishia.event.EventSource;
import org.vishia.event.EventTimerThread;
import org.vishia.fileLocalAccessor.FileAccessorLocalJava6;
import org.vishia.fileRemote.FileCluster;
import org.vishia.fileRemote.FileMark;
import org.vishia.fileRemote.FileRemoteAccessor;
import org.vishia.fileRemote.FileRemoteCallback;
import org.vishia.fileRemote.FileRemoteCallbackCmp;
import org.vishia.fileRemote.FileRemoteCallbackCopy;
import org.vishia.fileRemote.FileRemoteProgressTimeOrder;
import org.vishia.util.Assert;
import org.vishia.util.Debugutil;
import org.vishia.util.FileSystem;
import org.vishia.util.IndexMultiTable;
import org.vishia.util.MarkMask_ifc;
import org.vishia.util.SortedTreeWalkerCallback;
import org.vishia.util.StringFunctions;
import org.vishia.util.StringPart;
import org.vishia.util.TreeNodeNamed_ifc;

public class FileRemote
extends File
implements MarkMask_ifc,
TreeNodeNamed_ifc {
    private static final long serialVersionUID = -5568304770699633308L;
    public static final int version = 20130524;
    public static final int modeCopyReadOnlyMask = 15;
    public static final int modeCopyReadOnlyNever = 1;
    public static final int modeCopyReadOnlyOverwrite = 3;
    public static final int modeCopyReadOnlyAks = 0;
    public static final int modeCopyExistMask = 240;
    public static final int modeCopyExistNewer = 16;
    public static final int modeCopyExistOlder = 32;
    public static final int modeCopyExistAll = 48;
    public static final int modeCopyExistSkip = 64;
    public static final int modeCopyExistAsk = 0;
    public static final int modeCopyCreateMask = 3840;
    public static final int modeCopyCreateNever = 512;
    public static final int modeCopyCreateYes = 768;
    public static final int modeCopyCreateAsk = 0;
    public static final int modeCmprLogNotEqualFiles = 1;
    public static final int modeCmprLogMissing2File = 2;
    public static final int modeCmprLogMissing1File = 4;
    public static final int modeCmprLogComparedFiles = 8;
    public static final int mExist = 1;
    public static final int mCanRead = 2;
    public static final int mCanWrite = 4;
    public static final int mHidden = 8;
    public static final int mDirectory = 16;
    public static final int mFile = 32;
    public static final int mExecute = 64;
    public static final int mExecuteAny = 128;
    public static final int mRelativePath = 256;
    public static final int mAbsPath = 512;
    public static final int mSymLinkedPath = 1024;
    public static final int mCanReadGrp = 2048;
    public static final int mCanWriteGrp = 4096;
    public static final int mExecuteGrp = 8192;
    public static final int mCanReadAny = 16384;
    public static final int mCanWriteAny = 32768;
    public static final int mRoot = 0x100000;
    public static final int mShouldRefresh = 0x10000000;
    public static final int mThreadIsRunning = 0x20000000;
    public static final int mRefreshChildPending = 0x40000000;
    public static final int mTested = Integer.MIN_VALUE;
    private static FileRemoteAccessorSelector accessorSelector;
    private static int ctIdent;
    private final int _ident;
    public static final FileCluster clusterOfApplication;
    public final FileCluster itsCluster;
    protected FileRemoteAccessor device;
    public FileMark mark;
    public long timeRefresh;
    public long timeChildren;
    protected final String sDir;
    protected final String sFile;
    protected String sCanonicalPath;
    protected long date;
    protected long dateCreation;
    protected long dateLastAccess;
    protected long length;
    protected int flags;
    FileRemote parent;
    private Map<String, FileRemote> children;
    Object oFile;
    EventSource evSrc = new EventSource("FileLocalAccessor"){

        @Override
        public void notifyDequeued() {
        }

        @Override
        public void notifyConsumed(int n) {
        }

        @Override
        public void notifyRelinquished(int n) {
        }
    };
    private final InternalAccess acc_ = new InternalAccess();

    protected FileRemote(FileCluster fileCluster, FileRemoteAccessor fileRemoteAccessor, FileRemote fileRemote, CharSequence charSequence, long l, long l2, long l3, long l4, int n, Object object, boolean bl) {
        super(fileRemote == null ? charSequence.toString() : fileRemote.getPath() + "/" + charSequence);
        if (fileRemote != null) {
            this.parent = fileRemote;
            this.sDir = fileRemote.getAbsolutePath();
            this.sFile = charSequence.toString();
            if (fileCluster != null && fileCluster != fileRemote.itsCluster) {
                throw new IllegalArgumentException("FileRemote.ctor - Mismatching cluster association; parent.itsCluster=" + fileRemote.itsCluster.toString() + ";  parameter cluster=" + fileCluster.toString() + ";");
            }
            this.itsCluster = fileRemote.itsCluster;
        } else {
            this.parent = null;
            int n2 = StringFunctions.lastIndexOf(charSequence, '/');
            if (n2 >= 0) {
                int n3 = charSequence.length();
                this.sDir = charSequence.subSequence(0, n2).toString();
                this.sFile = n2 == 0 && n3 == 1 || n2 == 2 && charSequence.charAt(1) == ':' && n3 == 3 ? "/" : charSequence.subSequence(n2 + 1, charSequence.length()).toString();
            } else {
                this.sDir = "";
                this.sFile = charSequence.toString();
            }
            this.itsCluster = fileCluster == null ? clusterOfApplication : fileCluster;
        }
        this._ident = ++ctIdent;
        this.device = fileRemoteAccessor;
        this.flags = n;
        Assert.check(this.sDir != null);
        Assert.check(l >= 0L);
        this.oFile = object;
        this.length = l;
        this.date = l2;
        this.dateCreation = l3;
        this.dateLastAccess = l4;
        this.sCanonicalPath = this.sDir + (this.sFile != null ? "/" + this.sFile : "");
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        if (fileRemote != null) {
            fileRemote.putNewChild(this);
        }
    }

    public FileRemote child(CharSequence charSequence) {
        return this.child(charSequence, 0, 0, 0L, 0L, 0L);
    }

    public FileRemote subdir(CharSequence charSequence) {
        return this.child(charSequence, 16, 0, 0L, 0L, 0L);
    }

    private FileRemote child(CharSequence charSequence, int n, int n2, long l, long l2, long l3) {
        FileRemote fileRemote;
        StringPart stringPart;
        CharSequence charSequence2 = FileSystem.normalizePath(charSequence);
        int n3 = StringFunctions.indexOf(charSequence2, '/', 0);
        if (n3 >= 0) {
            stringPart = new StringPart(charSequence2, 0, charSequence2.length());
            charSequence2 = stringPart.lento('/');
        } else {
            stringPart = null;
        }
        FileRemote fileRemote2 = this;
        boolean bl = true;
        int n4 = 0;
        StringBuilder stringBuilder = new StringBuilder(100);
        do {
            stringBuilder.setLength(0);
            fileRemote2.setPathTo(stringBuilder).append('/').append(charSequence2);
            FileRemote fileRemote3 = fileRemote = fileRemote2.children == null ? null : fileRemote2.children.get(charSequence2);
            if (fileRemote == null) {
                if (stringPart != null) {
                    fileRemote = this.itsCluster.getFile(stringBuilder, null, false);
                } else if ((n & 0x10) != 0) {
                    fileRemote = this.itsCluster.getFile(stringBuilder, null, false);
                    fileRemote.length = n2;
                    fileRemote.date = l;
                    fileRemote.dateLastAccess = l3;
                    fileRemote.dateCreation = l2;
                    fileRemote.flags = n4;
                } else {
                    fileRemote = new FileRemote(this.itsCluster, this.device, fileRemote2, charSequence2, n2, l, l2, l3, n, null, true);
                }
            }
            if (stringPart != null) {
                fileRemote2 = fileRemote;
                charSequence2 = stringPart.fromEnd().seek(1).lento('/');
                if (stringPart.found()) continue;
                n4 = 32;
                stringPart.len0end();
                if (stringPart.length() == 0) {
                    bl = false;
                }
                stringPart = null;
                continue;
            }
            bl = false;
        } while (bl);
        return fileRemote;
    }

    public FileRemote getChild(CharSequence charSequence) {
        return this.children == null ? null : this.children.get(charSequence);
    }

    public Map<String, FileRemote> children() {
        return this.children;
    }

    public void cleanChildren() {
        this.children = null;
        this.flags |= 0x10000000;
    }

    public static Map<String, FileRemote> createChildrenList() {
        return new IndexMultiTable<String, FileRemote>(IndexMultiTable.providerString);
    }

    public static boolean setAccessorSelector(FileRemoteAccessorSelector fileRemoteAccessorSelector) {
        boolean bl = accessorSelector != null;
        accessorSelector = fileRemoteAccessorSelector;
        return bl;
    }

    static FileRemoteAccessorSelector getAccessorSelector() {
        if (accessorSelector == null) {
            accessorSelector = FileAccessorLocalJava6.selectLocalFileAlways;
        }
        return accessorSelector;
    }

    public static FileRemote fromFile(File file) {
        if (file instanceof FileRemote) {
            return (FileRemote)file;
        }
        return FileRemote.fromFile(clusterOfApplication, file);
    }

    public static FileRemote fromFile(FileCluster fileCluster, File file) {
        FileRemote fileRemote;
        if (file instanceof FileRemote) {
            return (FileRemote)file;
        }
        String string = file.getAbsolutePath();
        long l = 0L;
        long l2 = 0L;
        int n = 0;
        if (file.exists()) {
            n |= 1;
            l = file.length();
            l2 = file.lastModified();
            if (file.isDirectory()) {
                n |= 0x10;
            }
            if (file.canRead()) {
                n |= 0x4802;
            }
            if (file.canWrite()) {
                n |= 0x9004;
            }
            if (file.canExecute()) {
                n |= 0x20C0;
            }
            if (file.isHidden()) {
                n |= 8;
            }
        }
        FileRemoteAccessor fileRemoteAccessor = FileRemote.getAccessorSelector().selectFileRemoteAccessor(file.getAbsolutePath());
        File file2 = file.getParentFile();
        if (file2 != null) {
            FileRemote fileRemote2 = fileCluster.getDir(file2.getAbsolutePath());
            fileRemote = fileRemote2.child(file.getName());
        } else {
            Object var10_9 = null;
            fileRemote = fileCluster.getDir(file.getAbsolutePath());
        }
        fileRemote.length = l;
        fileRemote.flags = n;
        fileRemote.date = l2;
        fileRemote.oFile = file;
        return fileRemote;
    }

    public static FileRemote getDir(CharSequence charSequence) {
        return clusterOfApplication.getDir(charSequence);
    }

    public static FileRemote getFile(CharSequence charSequence, CharSequence charSequence2) {
        return clusterOfApplication.getFile(charSequence, charSequence2);
    }

    public static CharSequence cmprDirs(int n, File file, File file2, String string, List<String> list) {
        FileRemote fileRemote = FileRemote.fromFile(file);
        FileRemote fileRemote2 = FileRemote.fromFile(file2);
        if (fileRemote.device == null) {
            fileRemote.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(fileRemote.getAbsolutePath());
        }
        CallbackCmpDirs callbackCmpDirs = new CallbackCmpDirs(n);
        FileRemoteCallbackCmp fileRemoteCallbackCmp = new FileRemoteCallbackCmp(fileRemote, fileRemote2, callbackCmpDirs, null);
        fileRemote.device.walkFileTree(fileRemote, true, true, false, string, 0L, 0, fileRemoteCallbackCmp);
        if ((n & 1) == 0 && callbackCmpDirs.bNotEqual) {
            if (callbackCmpDirs.ret == null) {
                callbackCmpDirs.ret = new StringBuilder();
            }
            callbackCmpDirs.ret.append("not equal");
        }
        return callbackCmpDirs.ret;
    }

    public FileRemoteAccessor device() {
        return this.device;
    }

    void putNewChild(FileRemote fileRemote) {
        if (this.children == null) {
            this.children = FileRemote.createChildrenList();
        }
        if (fileRemote.parent != this) {
            if (fileRemote.parent != null) {
                throw new IllegalStateException("faulty parent-child");
            }
            fileRemote.parent = this;
        }
        this.children.put(fileRemote.sFile, fileRemote);
        fileRemote.flags &= 0xBFFFFFFF;
    }

    public void setShouldRefresh() {
        this.flags |= 0x10000000;
    }

    public void setDirShouldRefresh() {
        if (this.parent != null) {
            this.parent.setShouldRefresh();
        }
    }

    public boolean shouldRefresh() {
        return (this.flags & 0x10000000) != 0;
    }

    public long setMarked(int n) {
        if (this.mark == null) {
            this.mark = new FileMark(this);
        }
        this.mark.setMarked(n, this);
        return this.length();
    }

    public long resetMarked(int n) {
        if (this.mark != null) {
            this.mark.setNonMarked(n, this);
            return this.length();
        }
        return 0L;
    }

    public long resetMarkedRecurs(int n, int[] nArray) {
        return this.resetMarkedRecurs(n, nArray, 0);
    }

    private long resetMarkedRecurs(int n, int[] nArray, int n2) {
        long l = this.length();
        if (nArray != null) {
            nArray[0] = nArray[0] + 1;
        }
        if (this.mark != null) {
            this.mark.setNonMarked(n, this);
        }
        if (n2 > 1000) {
            throw new RuntimeException("FileRemote - resetMarkedRecurs,too many recursion");
        }
        if (this.children != null) {
            for (Map.Entry<String, FileRemote> entry : this.children.entrySet()) {
                FileRemote fileRemote = entry.getValue();
                l += fileRemote.resetMarkedRecurs(n, nArray, n2 + 1);
            }
        }
        return l;
    }

    @Override
    public int getMark() {
        if (this.sFile.equals("ReleaseNotes.topic")) {
            Debugutil.stop();
        }
        return this.mark == null ? 0 : this.mark.getMark();
    }

    @Override
    public int setNonMarked(int n, Object object) {
        if (this.mark == null) {
            return 0;
        }
        return this.mark.setNonMarkedRecursively(n, object, false);
    }

    public int setNonMarkedRecursively(int n, Object object) {
        if (this.mark == null) {
            return 0;
        }
        return this.mark.setNonMarkedRecursively(n, object, true);
    }

    @Override
    public int setMarked(int n, Object object) {
        if (this.sFile.equals("ReleaseNotes.topic")) {
            Debugutil.stop();
        }
        if (this.mark == null) {
            this.mark = new FileMark(this);
        }
        return this.mark.setMarked(n, object);
    }

    public boolean isMarked(int n) {
        return this.mark != null && (this.mark.getMark() & n) != 0;
    }

    public void _setProperties(long l, long l2, long l3, long l4, int n, Object object) {
        this.length = l;
        this.date = l2;
        this.dateCreation = l3;
        this.dateLastAccess = l4;
        this.flags = n;
        this.oFile = object;
    }

    public void refreshProperties(CallbackEvent callbackEvent) {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        this.device.refreshFileProperties(this, callbackEvent);
    }

    public void refreshPropertiesAndChildren(CallbackEvent callbackEvent) {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        this.device.refreshFilePropertiesAndChildren(this, callbackEvent);
    }

    public void refreshPropertiesAndChildren(FileRemoteCallback fileRemoteCallback, boolean bl) {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        this.device.walkFileTree(this, bl, true, false, null, 0L, 1, fileRemoteCallback);
    }

    public void refreshPropertiesAndChildren() {
        FileRemoteCallback fileRemoteCallback = null;
        this.refreshPropertiesAndChildren(fileRemoteCallback, true);
    }

    public void refreshAndMark(boolean bl, String string, long l, int n, FileRemoteCallback fileRemoteCallback, FileRemoteProgressTimeOrder fileRemoteProgressTimeOrder) {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        CallbackMark callbackMark = new CallbackMark(fileRemoteCallback, fileRemoteProgressTimeOrder);
        this.device.walkFileTree(this, false, true, bl, string, l, n, callbackMark);
    }

    public void refreshAndCompare(FileRemote fileRemote, int n, String string, int n2, FileRemoteCallback fileRemoteCallback, FileRemoteProgressTimeOrder fileRemoteProgressTimeOrder) {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        FileRemoteCallbackCmp fileRemoteCallbackCmp = new FileRemoteCallbackCmp(this, fileRemote, fileRemoteCallback, fileRemoteProgressTimeOrder);
        this.device.walkFileTree(this, false, true, false, string, n2, n, fileRemoteCallbackCmp);
    }

    public void copyDirTreeTo(FileRemote fileRemote, int n, String string, int n2, FileRemoteCallback fileRemoteCallback, FileRemoteProgressTimeOrder fileRemoteProgressTimeOrder) {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        FileRemoteCallbackCopy fileRemoteCallbackCopy = new FileRemoteCallbackCopy(fileRemote, fileRemoteCallback, fileRemoteProgressTimeOrder);
        boolean bl = fileRemoteCallback == null;
        boolean bl2 = false;
        boolean bl3 = false;
        this.device.walkFileTreeCheck(this, bl, bl2, bl3, string, n2, n, fileRemoteCallbackCopy);
    }

    public void setSymbolicLinkedPath(String string) {
        this.flags |= 0x400;
        this.sCanonicalPath = string;
    }

    public void setCanonicalAbsPath(String string) {
        this.flags |= 0x200;
        this.flags &= 0xFFFFFBFF;
        this.sCanonicalPath = string;
    }

    public boolean sameDevice(FileRemote fileRemote) {
        return this.device.equals(fileRemote.device);
    }

    public ReadableByteChannel openRead(long l) {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        return this.device.openRead(this, l);
    }

    public InputStream openInputStream(long l) {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        return this.device.openInputStream(this, l);
    }

    public OutputStream openOutputStream(long l) {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        return this.device.openOutputStream(this, l);
    }

    public WritableByteChannel openWrite(long l) {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        return this.device.openWrite(this, l);
    }

    @Override
    public long length() {
        if ((this.flags & Integer.MIN_VALUE) == 0) {
            if (this.device == null) {
                this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
            }
            this.device.refreshFileProperties(this, null);
        }
        return this.length;
    }

    @Override
    public long lastModified() {
        if ((this.flags & Integer.MIN_VALUE) == 0) {
            if (this.device == null) {
                this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
            }
            this.device.refreshFileProperties(this, null);
        }
        return this.date;
    }

    public long creationTime() {
        if ((this.flags & Integer.MIN_VALUE) == 0) {
            if (this.device == null) {
                this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
            }
            this.device.refreshFileProperties(this, null);
        }
        return this.dateCreation;
    }

    public long lastAccessTime() {
        if ((this.flags & Integer.MIN_VALUE) == 0) {
            if (this.device == null) {
                this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
            }
            this.device.refreshFileProperties(this, null);
        }
        return this.dateLastAccess;
    }

    @Override
    public boolean setLastModified(long l) {
        this.date = l;
        if (this.oFile != null) {
            if (this.device == null) {
                this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
            }
            return this.device.setLastModified(this, l);
        }
        return super.setLastModified(l);
    }

    public Object oFile() {
        return this.oFile;
    }

    public void setFileObject(Object object) {
        this.oFile = object;
    }

    public int getFlags() {
        return this.flags;
    }

    @Override
    public String getName() {
        return this.sFile;
    }

    @Override
    public String getParent() {
        FileRemote fileRemote = this.getParentFile();
        if (fileRemote == null) {
            return this.sDir;
        }
        return ((File)fileRemote).getAbsolutePath();
    }

    @Override
    public String getPath() {
        return this.getPathChars().toString();
    }

    public CharSequence getPathChars() {
        int n;
        int n2 = n = this.sFile == null ? 0 : this.sFile.length();
        if (n > 0) {
            int n3 = this.sDir == null ? 0 : this.sDir.length();
            StringBuilder stringBuilder = new StringBuilder(n3 + 1 + n);
            if (n3 > 0) {
                stringBuilder.append(this.sDir);
                if (this.sDir.charAt(n3 - 1) != '/' && this.sFile.charAt(0) != '/') {
                    stringBuilder.append('/');
                }
            }
            stringBuilder.append(this.sFile);
            return stringBuilder;
        }
        return this.sDir;
    }

    public StringBuilder setPathTo(StringBuilder stringBuilder) {
        int n;
        int n2 = n = this.sFile == null ? 0 : this.sFile.length();
        if (n > 0) {
            int n3;
            int n4 = n3 = this.sDir == null ? 0 : this.sDir.length();
            if (n3 > 0) {
                stringBuilder.append(this.sDir);
                if (this.sDir.charAt(n3 - 1) != '/' && this.sFile.charAt(0) != '/') {
                    stringBuilder.append('/');
                }
            }
            stringBuilder.append(this.sFile);
        } else {
            stringBuilder.append(this.sDir);
        }
        return stringBuilder;
    }

    @Override
    public String getCanonicalPath() {
        return this.sCanonicalPath;
    }

    public CharSequence isChild(CharSequence charSequence) {
        if (this.sFile != null) {
            return null;
        }
        CharSequence charSequence2 = FileSystem.normalizePath(charSequence);
        int n = this.sDir.length();
        int n2 = charSequence2.length();
        if (n2 > n && StringFunctions.startsWith(charSequence2, this.sDir) && charSequence2.charAt(n) == '/') {
            return charSequence2.subSequence(n + 1, n2);
        }
        return null;
    }

    public CharSequence isParent(CharSequence charSequence) {
        int n;
        CharSequence charSequence2 = FileSystem.normalizePath(charSequence);
        CharSequence charSequence3 = this.getPathChars();
        int n2 = charSequence3.length();
        if (n2 > (n = charSequence2.length()) && StringFunctions.startsWith(charSequence3, charSequence2) && charSequence3.charAt(n) == '/') {
            return charSequence2;
        }
        return null;
    }

    @Override
    public FileRemote getParentFile() {
        if (this.parent == null) {
            String string;
            int n = this.sDir.length();
            if (this.sFile.equals("/")) {
                string = null;
            } else if (this.sFile == null || this.sFile.length() == 0) {
                if (n > 1) {
                    int n2 = this.sDir.lastIndexOf(47, n - 1);
                    if (n2 == 0 || n2 == 2 && this.sDir.charAt(1) == ':') {
                        ++n2;
                    }
                    string = n2 > 0 ? this.sDir.substring(0, n2) : null;
                } else {
                    string = null;
                }
            } else if (n == 0 || n == 2 && this.sDir.charAt(1) == ':') {
                int n3 = n;
                string = this.sDir.substring(0, n3) + "/";
            } else {
                int n4 = n;
                string = this.sDir.substring(0, n4);
            }
            if (string != null) {
                this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
                this.parent = this.itsCluster.getFile(string, null);
                if (this.parent.children == null) {
                    this.parent.children = FileRemote.createChildrenList();
                    this.parent.children.put(this.sFile, this);
                    this.parent.timeChildren = 0L;
                }
            }
        }
        return this.parent;
    }

    public boolean isTested() {
        return (this.flags & Integer.MIN_VALUE) == Integer.MIN_VALUE;
    }

    public boolean isTested(long l) {
        if (this.timeRefresh < l) {
            return false;
        }
        return !this.isDirectory() || this.timeChildren >= l;
    }

    @Override
    public boolean exists() {
        if ((this.flags & Integer.MIN_VALUE) == 0) {
            if (this.device == null) {
                this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
            }
            this.device.refreshFileProperties(this, null);
        }
        return (this.flags & 1) != 0;
    }

    @Override
    public boolean isFile() {
        if ((this.flags & Integer.MIN_VALUE) == 0) {
            if (this.device == null) {
                this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
            }
            this.device.refreshFileProperties(this, null);
        }
        return (this.flags & 0x20) != 0;
    }

    @Override
    public boolean isHidden() {
        if ((this.flags & Integer.MIN_VALUE) == 0) {
            if (this.device == null) {
                this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
            }
            this.device.refreshFileProperties(this, null);
        }
        return (this.flags & 8) != 0;
    }

    @Override
    public boolean isDirectory() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isRoot() {
        return this.sFile.equals("/");
    }

    @Override
    public boolean canWrite() {
        if ((this.flags & Integer.MIN_VALUE) == 0) {
            if (this.device == null) {
                this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
            }
            this.device.refreshFileProperties(this, null);
        }
        return (this.flags & 4) != 0;
    }

    @Override
    public boolean canRead() {
        if ((this.flags & Integer.MIN_VALUE) == 0) {
            if (this.device == null) {
                this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
            }
            this.device.refreshFileProperties(this, null);
        }
        return (this.flags & 2) != 0;
    }

    @Override
    public boolean canExecute() {
        if ((this.flags & Integer.MIN_VALUE) == 0) {
            if (this.device == null) {
                this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
            }
            this.device.refreshFileProperties(this, null);
        }
        return (this.flags & 0x40) != 0;
    }

    public boolean isSymbolicLink() {
        if ((this.flags & Integer.MIN_VALUE) == 0) {
            if (this.device == null) {
                this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
            }
            this.device.refreshFileProperties(this, null);
        }
        return (this.flags & 0x400) != 0;
    }

    @Override
    public String getAbsolutePath() {
        String string = this.getPath();
        return string;
    }

    public FileRemote[] listFiles() {
        if (this.children == null) {
            if (this.device == null) {
                this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
            }
            this.device.refreshFilePropertiesAndChildren(this, null);
        }
        if (this.children == null) {
            return null;
        }
        FileRemote[] fileRemoteArray = new FileRemote[this.children.size()];
        int n = -1;
        for (Map.Entry<String, FileRemote> entry : this.children.entrySet()) {
            if (n + 1 >= fileRemoteArray.length) {
                System.err.println("Bug in IndexMultiTable");
                continue;
            }
            fileRemoteArray[++n] = entry.getValue();
        }
        return fileRemoteArray;
    }

    @Override
    public File[] listFiles(FileFilter fileFilter) {
        if (this.children == null) {
            if (this.device == null) {
                this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
            }
            this.device.refreshFilePropertiesAndChildren(this, null);
        }
        List<File> list = this.device.getChildren(this, fileFilter);
        File[] fileArray = new File[list.size()];
        return list.toArray(fileArray);
    }

    @Override
    public boolean createNewFile() throws IOException {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        return this.device.createNewFile(this, null);
    }

    @Override
    public boolean delete() {
        boolean bl;
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        if ((bl = this.device.delete(this, null)) && this.parent != null && this.parent.children != null) {
            this.parent.children.remove(this.sFile);
        }
        return bl;
    }

    public void delete(CallbackEvent callbackEvent) {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        this.device.delete(this, callbackEvent);
    }

    public void deleteChecked(CallbackEvent callbackEvent, int n) {
        CmdEvent cmdEvent = callbackEvent.getOpponent();
        if (cmdEvent.occupy(this.evSrc, true)) {
            cmdEvent.filesrc = this;
            cmdEvent.filedst = null;
            cmdEvent.modeCopyOper = n;
            cmdEvent.sendEvent(Cmd.delChecked);
        }
    }

    public void delete(String string, boolean bl, CallbackEvent callbackEvent) {
        boolean bl2;
        LinkedList<File> linkedList = new LinkedList<File>();
        try {
            bl2 = FileSystem.addFileToList((File)this, string, linkedList);
            for (File file : linkedList) {
                if (file.isDirectory()) {
                    if (FileSystem.rmdir(file)) continue;
                    bl2 = false;
                    continue;
                }
                if (!file.canWrite()) {
                    file.setWritable(true);
                }
                if (file.delete()) continue;
                bl2 = false;
            }
        }
        catch (Exception exception) {
            bl2 = false;
        }
        if (callbackEvent != null) {
            callbackEvent.occupy(this.evSrc, true);
            callbackEvent.successCode = bl2 ? 0 : -1;
            callbackEvent.sendEvent(CallbackCmd.done);
        }
    }

    public void deleteMarkedInThread(int n, FileRemoteCallback fileRemoteCallback) {
        DeleteThread deleteThread = new DeleteThread(n, this, fileRemoteCallback);
        deleteThread.start();
    }

    public void deleteMarked(int n, FileRemoteCallback fileRemoteCallback) {
        SortedTreeWalkerCallback.Counters counters = new SortedTreeWalkerCallback.Counters();
        if (fileRemoteCallback != null) {
            fileRemoteCallback.start(this);
        }
        if (FileRemote.deleteMarkedSub(counters, n, this, 10000, fileRemoteCallback)) {
            this.delete();
        }
        if (fileRemoteCallback != null) {
            fileRemoteCallback.finished(this, counters);
        }
    }

    private static boolean deleteMarkedSub(SortedTreeWalkerCallback.Counters counters, int n, FileRemote fileRemote, int n2, FileRemoteCallback fileRemoteCallback) {
        Map<String, FileRemote> map;
        SortedTreeWalkerCallback.Counters counters2 = new SortedTreeWalkerCallback.Counters();
        boolean bl = true;
        if (fileRemote.isDirectory() && (map = fileRemote.children()) != null) {
            System.out.println("FileRemote.deleteMarkedSub - offerDir; " + fileRemote.getAbsolutePath());
            SortedTreeWalkerCallback.Result result = fileRemoteCallback.offerParentNode(fileRemote);
            if (result == SortedTreeWalkerCallback.Result.cont) {
                Iterator<Map.Entry<String, FileRemote>> iterator = map.entrySet().iterator();
                while (result == SortedTreeWalkerCallback.Result.cont && iterator.hasNext()) {
                    try {
                        boolean bl2;
                        Map.Entry<String, FileRemote> entry = iterator.next();
                        FileRemote fileRemote2 = entry.getValue();
                        if (fileRemote2.isDirectory()) {
                            ++counters2.nrofParents;
                            ++counters.nrofParents;
                            if (n2 > 1) {
                                bl2 = FileRemote.deleteMarkedSub(counters, n, fileRemote2, n2 - 1, fileRemoteCallback);
                            } else {
                                System.out.println("FileRemote.deleteMarkedSub - offer empty dir; " + fileRemote2.getName());
                                result = fileRemoteCallback != null ? fileRemoteCallback.offerLeafNode(fileRemote2, null) : SortedTreeWalkerCallback.Result.cont;
                                bl2 = result == SortedTreeWalkerCallback.Result.skipSubtree;
                            }
                        } else {
                            ++counters2.nrofLeafss;
                            ++counters.nrofLeafss;
                            result = fileRemoteCallback != null ? fileRemoteCallback.offerLeafNode(fileRemote2, null) : SortedTreeWalkerCallback.Result.cont;
                            boolean bl3 = bl2 = result == SortedTreeWalkerCallback.Result.cont;
                        }
                        if (bl2) {
                            if (FileRemote.checkAndDelete(fileRemote2, iterator, n)) {
                                ++counters2.nrofLeafSelected;
                                ++counters.nrofLeafSelected;
                                continue;
                            }
                            bl = false;
                            continue;
                        }
                        bl = false;
                    }
                    catch (Exception exception) {
                        System.err.println(Assert.exceptionInfo("FileRemote unexpected - deleteMarkedSub", exception, 0, 20, true));
                    }
                }
                if (result != SortedTreeWalkerCallback.Result.terminate) {
                    result = fileRemoteCallback.finishedParentNode(fileRemote, counters2);
                }
            }
        } else {
            SortedTreeWalkerCallback.Result result = fileRemoteCallback.offerLeafNode(fileRemote, null);
            if (result != SortedTreeWalkerCallback.Result.cont) {
                bl = false;
            }
        }
        return bl;
    }

    private static boolean checkAndDelete(FileRemote fileRemote, Iterator<Map.Entry<String, FileRemote>> iterator, int n) {
        boolean bl;
        int n2 = fileRemote.getMark();
        if ((n2 & n) != 0) {
            if (fileRemote.device == null) {
                fileRemote.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(fileRemote.getAbsolutePath());
            }
            System.out.println("FileRemote.deleteMarkedSub - delete File, " + fileRemote.getName());
            boolean bl2 = fileRemote.device.delete(fileRemote, null);
            if (bl2) {
                iterator.remove();
                bl = true;
            } else {
                System.err.println("FileRemote.delete - can't delete, >>>" + fileRemote.getAbsolutePath() + "<<<");
                bl = false;
            }
        } else {
            System.out.println("FileRemote.deleteMarkedSub - offer file not marked, " + fileRemote.getName());
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean mkdir() {
        return this.mkdir(false, null);
    }

    @Override
    public boolean mkdirs() {
        return this.mkdir(true, null);
    }

    public boolean mkdir(boolean bl, CallbackEvent callbackEvent) {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        return this.device.mkdir(this, bl, callbackEvent);
    }

    public void check(String string, String string2, CallbackEvent callbackEvent) {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        CmdEvent cmdEvent = this.device.prepareCmdEvent(500, callbackEvent);
        cmdEvent.filesrc = this;
        cmdEvent.filedst = null;
        cmdEvent.namesSrc = string;
        cmdEvent.maskSrc = string2;
        cmdEvent.sendEvent(Cmd.check);
    }

    public void copyChecked(String string, String string2, int n, FileRemoteCallback fileRemoteCallback, FileRemoteProgressTimeOrder fileRemoteProgressTimeOrder) {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        this.device.copyChecked(this, string, string2, n, fileRemoteCallback, fileRemoteProgressTimeOrder);
    }

    public void copyTo(FileRemote fileRemote, CallbackEvent callbackEvent, int n) {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        if (fileRemote.device == null) {
            fileRemote.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(fileRemote.getAbsolutePath());
        }
        CmdEvent cmdEvent = this.device.prepareCmdEvent(500, callbackEvent);
        cmdEvent.filesrc = this;
        cmdEvent.filedst = fileRemote;
        cmdEvent.modeCopyOper = n;
        cmdEvent.sendEvent(Cmd.copyChecked);
    }

    public void XXXcopyTo(FileRemote fileRemote, int n) {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        if (fileRemote.device == null) {
            fileRemote.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(fileRemote.getAbsolutePath());
        }
    }

    public void moveTo(String string, FileRemote fileRemote, CallbackEvent callbackEvent) {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        CmdEvent cmdEvent = this.device.prepareCmdEvent(500, callbackEvent);
        cmdEvent.filesrc = this;
        cmdEvent.namesSrc = string;
        cmdEvent.filedst = fileRemote;
        cmdEvent.sendEvent(Cmd.move);
    }

    public void chgProps(String string, int n, int n2, long l, CallbackEvent callbackEvent) {
        CmdEvent cmdEvent = this.device.prepareCmdEvent(500, callbackEvent);
        cmdEvent.filesrc = this;
        cmdEvent.filedst = null;
        cmdEvent.newName = string;
        cmdEvent.maskFlags = n;
        cmdEvent.newFlags = n2;
        cmdEvent.newDate = l;
        cmdEvent.sendEvent(Cmd.chgProps);
    }

    public void chgPropsRecursive(int n, int n2, long l, CallbackEvent callbackEvent) {
        CmdEvent cmdEvent = this.device.prepareCmdEvent(500, callbackEvent);
        cmdEvent.filesrc = this;
        cmdEvent.filedst = null;
        cmdEvent.newName = null;
        cmdEvent.maskFlags = n;
        cmdEvent.newFlags = n2;
        cmdEvent.newDate = l;
        cmdEvent.sendEvent(Cmd.chgPropsRecurs);
    }

    public void walkFileTree(int n, FileRemoteCallback fileRemoteCallback) {
        fileRemoteCallback.start(this);
        FileRemote.walkSubTree(this, n <= 0 ? Integer.MAX_VALUE : n, fileRemoteCallback);
        fileRemoteCallback.finished(this, null);
    }

    public void walkFileTreeThread(int n, FileRemoteCallback fileRemoteCallback) {
        WalkThread walkThread = new WalkThread(this, n, fileRemoteCallback);
        walkThread.start();
    }

    private static SortedTreeWalkerCallback.Result walkSubTree(FileRemote fileRemote, int n, FileRemoteCallback fileRemoteCallback) {
        SortedTreeWalkerCallback.Counters counters = new SortedTreeWalkerCallback.Counters();
        Map<String, FileRemote> map = fileRemote.children();
        SortedTreeWalkerCallback.Result result = SortedTreeWalkerCallback.Result.cont;
        result = fileRemoteCallback.offerParentNode(fileRemote);
        if (result == SortedTreeWalkerCallback.Result.cont && map != null) {
            Iterator<Map.Entry<String, FileRemote>> iterator = map.entrySet().iterator();
            while (result == SortedTreeWalkerCallback.Result.cont && iterator.hasNext()) {
                try {
                    Map.Entry<String, FileRemote> entry = iterator.next();
                    FileRemote fileRemote2 = entry.getValue();
                    if (fileRemote2.isDirectory()) {
                        ++counters.nrofParents;
                        if (n > 1) {
                            result = FileRemote.walkSubTree(fileRemote2, n - 1, fileRemoteCallback);
                            continue;
                        }
                        result = fileRemoteCallback.offerLeafNode(fileRemote2, null);
                        continue;
                    }
                    ++counters.nrofLeafss;
                    result = fileRemoteCallback.offerLeafNode(fileRemote2, null);
                }
                catch (Exception exception) {
                    System.err.println(Assert.exceptionInfo("FileRemote unexpected - walkSubtree", exception, 0, 20, true));
                }
            }
        }
        if (result != SortedTreeWalkerCallback.Result.terminate) {
            result = fileRemoteCallback.finishedParentNode(fileRemote, counters);
        }
        return result;
    }

    public void countAllFileLength(CallbackEvent callbackEvent) {
        CmdEvent cmdEvent = this.device.prepareCmdEvent(500, callbackEvent);
        cmdEvent.filesrc = this;
        cmdEvent.filedst = null;
        cmdEvent.sendEvent(Cmd.countLength);
    }

    public void abortAction() {
        CmdEvent cmdEvent = this.device.prepareCmdEvent(500, null);
        cmdEvent.filesrc = this;
        cmdEvent.filedst = null;
        cmdEvent.sendEvent(Cmd.abortAll);
    }

    public CharSequence getStateDevice() {
        return this.device == null ? "no-device" : this.device.getStateInfo();
    }

    public int ident() {
        return this._ident;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public InternalAccess internalAccess() {
        return this.acc_;
    }

    static {
        ctIdent = 0;
        clusterOfApplication = new FileCluster();
    }

    static class DeleteThread
    extends Thread {
        final int mark;
        final FileRemoteCallback callback;
        final FileRemote startdir;

        DeleteThread(int n, FileRemote fileRemote, FileRemoteCallback fileRemoteCallback) {
            super("walkFileTreeThread");
            this.mark = n;
            this.callback = fileRemoteCallback;
            this.startdir = fileRemote;
        }

        @Override
        public void run() {
            try {
                this.startdir.deleteMarked(this.mark, this.callback);
            }
            catch (Exception exception) {
                System.out.println("FileRemote - walkFileTreeThread");
            }
        }
    }

    static class WalkThread
    extends Thread {
        final int depth;
        final FileRemoteCallback callback;
        final FileRemote startdir;

        WalkThread(FileRemote fileRemote, int n, FileRemoteCallback fileRemoteCallback) {
            super("walkFileTreeThread");
            this.depth = n;
            this.callback = fileRemoteCallback;
            this.startdir = fileRemote;
        }

        @Override
        public void run() {
            try {
                this.startdir.walkFileTree(this.depth, this.callback);
            }
            catch (Exception exception) {
                System.out.println("FileRemote - walkFileTreeThread");
            }
        }
    }

    public class CallbackMark
    implements FileRemoteCallback {
        final FileRemoteCallback callbackUser;
        final FileRemoteProgressTimeOrder timeOrderProgress;
        FileRemote startDir;
        long nrofBytes;
        int nrofFiles;

        public CallbackMark(FileRemoteCallback fileRemoteCallback, FileRemoteProgressTimeOrder fileRemoteProgressTimeOrder) {
            this.callbackUser = fileRemoteCallback;
            this.timeOrderProgress = fileRemoteProgressTimeOrder;
        }

        @Override
        public void start(FileRemote fileRemote) {
            this.startDir = fileRemote;
        }

        @Override
        public void finished(FileRemote fileRemote, SortedTreeWalkerCallback.Counters counters) {
            if (this.callbackUser != null) {
                this.callbackUser.finished(fileRemote, counters);
            }
        }

        @Override
        public SortedTreeWalkerCallback.Result offerParentNode(FileRemote fileRemote) {
            if (this.callbackUser != null) {
                return this.callbackUser.offerParentNode(fileRemote);
            }
            return SortedTreeWalkerCallback.Result.cont;
        }

        @Override
        public SortedTreeWalkerCallback.Result finishedParentNode(FileRemote fileRemote, SortedTreeWalkerCallback.Counters counters) {
            boolean bl = true;
            if (counters.nrofParents + counters.nrofLeafss > 0 && counters.nrofParentSelected == counters.nrofParents && counters.nrofLeafSelected == counters.nrofLeafss) {
                fileRemote.setMarked(1);
            } else if (counters.nrofParentSelected > 0 || counters.nrofLeafSelected > 0) {
                fileRemote.setMarked(2);
            } else {
                bl = false;
            }
            if (bl) {
                FileRemote fileRemote2 = fileRemote;
                while (fileRemote2 != null) {
                    fileRemote2.setMarked(2);
                    if (fileRemote2 != this.startDir) {
                        fileRemote2 = fileRemote2.parent;
                        continue;
                    }
                    fileRemote2 = null;
                }
            }
            if (this.callbackUser != null) {
                return this.callbackUser.finishedParentNode(fileRemote, counters);
            }
            return SortedTreeWalkerCallback.Result.cont;
        }

        @Override
        public SortedTreeWalkerCallback.Result offerLeafNode(FileRemote fileRemote, Object object) {
            ++this.nrofFiles;
            if (!fileRemote.isDirectory()) {
                fileRemote.setMarked(1);
            }
            long l = fileRemote.length();
            this.nrofBytes += l;
            if (this.callbackUser != null) {
                return this.callbackUser.offerLeafNode(fileRemote, object);
            }
            return SortedTreeWalkerCallback.Result.cont;
        }

        @Override
        public boolean shouldAborted() {
            if (this.callbackUser != null) {
                return this.callbackUser.shouldAborted();
            }
            return false;
        }
    }

    public static class ChildrenEvent
    extends EventCmdtypeWithBackEvent<CallbackCmd, CmdEvent> {
        private final Queue<FileRemote> newChildren = new ConcurrentLinkedQueue<FileRemote>();
        private long startTime;
        public long orderNr;
        public FileRemote srcFile;
        private final EventSource evSrcCmd;
        public FileFilter filter;
        public int depth;
        protected boolean finished;
        protected boolean aborted;
        public FileRemoteCallback callbackChildren = new FileRemoteCallback(){

            @Override
            public SortedTreeWalkerCallback.Result offerParentNode(FileRemote fileRemote) {
                return SortedTreeWalkerCallback.Result.cont;
            }

            @Override
            public SortedTreeWalkerCallback.Result finishedParentNode(FileRemote fileRemote, SortedTreeWalkerCallback.Counters counters) {
                return SortedTreeWalkerCallback.Result.cont;
            }

            @Override
            public SortedTreeWalkerCallback.Result offerLeafNode(FileRemote fileRemote, Object object) {
                this.offerChild(fileRemote);
                return SortedTreeWalkerCallback.Result.cont;
            }

            @Override
            public void finished(FileRemote fileRemote, SortedTreeWalkerCallback.Counters counters) {
                if (0 != this.occupyRecall(4000, evSrcCmd, false)) {
                    finished = true;
                    this.sendEvent();
                }
            }

            @Override
            public void start(FileRemote fileRemote) {
                startTime = System.currentTimeMillis();
                finished = false;
            }

            @Override
            public boolean shouldAborted() {
                return aborted;
            }
        };

        public ChildrenEvent(EventConsumer eventConsumer, EventTimerThread eventTimerThread, EventSource eventSource) {
            super(null, eventConsumer, eventTimerThread, new CmdEvent());
            this.evSrcCmd = eventSource;
        }

        public CmdEvent prepareCmd(int n, FileRemote fileRemote, FileRemoteAccessor fileRemoteAccessor) {
            CmdEvent cmdEvent;
            int n2 = 2;
            if (this.srcFile != null) {
                cmdEvent = this.getOpponent();
                this.aborted = true;
                this.srcFile = null;
                n2 = cmdEvent.occupyRecall(n, this.evSrcCmd, false);
                if (n2 == 1) {
                    cmdEvent.sendEvent(Cmd.abortAll);
                }
            }
            if (n2 != 0) {
                cmdEvent = fileRemoteAccessor.prepareCmdEvent(500, this);
                ++this.orderNr;
                this.srcFile = fileRemote;
                this.aborted = false;
                return cmdEvent;
            }
            return null;
        }

        @Override
        public CmdEvent getOpponent() {
            return (CmdEvent)super.getOpponent();
        }

        public boolean isFinished() {
            return this.finished;
        }

        public FileRemote poll() {
            FileRemote fileRemote = this.newChildren.poll();
            if (fileRemote == null) {
                this.startTime = System.currentTimeMillis();
            }
            return fileRemote;
        }

        protected void offerChild(FileRemote fileRemote) {
            this.newChildren.offer(fileRemote);
            long l = System.currentTimeMillis();
            if (l - this.startTime > 300L && !this.isOccupied()) {
                this.occupy(this.evSrcCmd, false);
                this.finished = false;
                this.sendEvent();
            }
        }
    }

    public class InternalAccess {
        public int setFlagBit(int n) {
            FileRemote.this.flags |= n;
            return FileRemote.this.flags;
        }

        public int clrFlagBit(int n) {
            FileRemote.this.flags &= ~n;
            return FileRemote.this.flags;
        }

        public int clrFlagBitChildren(int n, int n2) {
            int n3 = 1;
            if (n2 > 1000) {
                throw new IllegalArgumentException("too many recursion in directory tree");
            }
            this.clrFlagBit(n);
            if (FileRemote.this.children != null) {
                for (Map.Entry entry : FileRemote.this.children.entrySet()) {
                    if (entry == null) continue;
                    n3 += ((FileRemote)entry.getValue()).internalAccess().clrFlagBitChildren(n, n2 + 1);
                }
            }
            return n3;
        }

        public int setFlagBits(int n, int n2) {
            FileRemote.this.flags &= ~n;
            FileRemote.this.flags |= n2;
            return FileRemote.this.flags;
        }

        public void setLengthAndDate(long l, long l2, long l3, long l4) {
            FileRemote.this.date = l2;
            FileRemote.this.dateLastAccess = l4;
            FileRemote.this.dateCreation = l3;
            FileRemote.this.length = l;
        }

        public int setOrClrFlagBit(int n, boolean bl) {
            FileRemote.this.flags = bl ? (FileRemote.this.flags |= n) : (FileRemote.this.flags &= ~n);
            return FileRemote.this.flags;
        }

        public void setRefreshed() {
            FileRemote.this.flags &= 0xEFFFFFFF;
            FileRemote.this.timeRefresh = System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setChildrenRefreshed() {
            if (FileRemote.this.children != null) {
                Map map = FileRemote.this.children;
                synchronized (map) {
                    Iterator iterator = FileRemote.this.children.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        FileRemote fileRemote = (FileRemote)entry.getValue();
                        if (fileRemote == null) {
                            Debugutil.stop();
                            continue;
                        }
                        if ((fileRemote.flags & 0x40000000) == 0) continue;
                        iterator.remove();
                    }
                }
            }
            FileRemote.this.flags &= 0xEFFFFFFF;
            FileRemote.this.timeRefresh = FileRemote.this.timeChildren = System.currentTimeMillis();
        }

        public void newChildren() {
            if (FileRemote.this.children == null) {
                FileRemote.this.children = FileRemote.createChildrenList();
            } else {
                Iterator iterator = FileRemote.this.children.entrySet().iterator();
                while (iterator.hasNext()) {
                    FileRemote fileRemote = (FileRemote)iterator.next().getValue();
                    if (fileRemote == null) {
                        Debugutil.stop();
                        continue;
                    }
                    fileRemote.flags |= 0x40000000;
                }
            }
        }

        public FileRemote newChild(CharSequence charSequence, long l, long l2, long l3, long l4, int n, Object object) {
            return new FileRemote(FileRemote.this.itsCluster, FileRemote.this.device, FileRemote.this, charSequence, l, l2, l3, FileRemote.this.dateLastAccess, n, object, true);
        }

        public void putNewChild(FileRemote fileRemote) {
            FileRemote.this.putNewChild(fileRemote);
        }
    }

    protected class CallbackWait
    implements EventConsumer {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int processEvent(EventObject eventObject) {
            FileRemote fileRemote = FileRemote.this;
            synchronized (fileRemote) {
                FileRemote.this.notify();
            }
            return 1;
        }
    }

    public static enum CallbackCmd {
        free,
        reserve,
        done,
        nok,
        error,
        errorDelete,
        doneCheck,
        nrofFilesAndBytes,
        copyDir,
        askErrorSrcOpen,
        askErrorDstCreate,
        askDstOverwr,
        askDstReadonly,
        askDstNotAbletoOverwr,
        askErrorCopy,
        acknAbortAll,
        acknAbortDir,
        acknAbortFile,
        start,
        last;

    }

    public static class CallbackEvent
    extends EventCmdtypeWithBackEvent<CallbackCmd, CmdEvent> {
        private static final long serialVersionUID = 1L;
        private FileRemote filesrc;
        private FileRemote filedst;
        private final EventSource evSrcCmd;
        String newName;
        int maskFlags;
        int newFlags;
        long newDate;
        public char[] fileName = new char[100];
        public long nrofBytesInFile;
        public long nrofBytesAll;
        public int nrofFiles;
        public int successCode;
        public int promilleCopiedFiles;
        public int promilleCopiedBytes;

        public CallbackEvent(EventConsumer eventConsumer, EventTimerThread eventTimerThread, EventSource eventSource) {
            super(null, eventConsumer, eventTimerThread, new CmdEvent());
            this.evSrcCmd = eventSource;
        }

        public CallbackEvent(EventSource eventSource, FileRemote fileRemote, FileRemote fileRemote2, EventConsumer eventConsumer, EventTimerThread eventTimerThread, EventSource eventSource2) {
            super(null, eventConsumer, eventTimerThread, new CmdEvent(eventSource2, fileRemote, fileRemote2, null, null));
            this.filesrc = fileRemote;
            this.filedst = fileRemote2;
            this.evSrcCmd = eventSource2;
        }

        public boolean occupy(EventSource eventSource, FileRemote fileRemote, boolean bl) {
            boolean bl2 = this.occupy(eventSource, bl);
            if (bl2) {
                this.filesrc = fileRemote;
            }
            return bl2;
        }

        public boolean occupy(EventSource eventSource, int n, boolean bl) {
            boolean bl2 = this.occupy(eventSource, bl);
            if (bl2) {
                this.orderId = n;
            }
            return bl2;
        }

        public void setFileSrc(FileRemote fileRemote) {
            this.filesrc = fileRemote;
        }

        @Override
        public boolean sendEvent(CallbackCmd callbackCmd) {
            return super.sendEvent(callbackCmd);
        }

        @Override
        public CallbackCmd getCmd() {
            return (CallbackCmd)((Object)super.getCmd());
        }

        @Override
        public CmdEvent getOpponent() {
            return (CmdEvent)super.getOpponent();
        }

        public FileRemote getFileSrc() {
            return this.filesrc;
        }

        public FileRemote getFileDst() {
            return this.filedst;
        }
    }

    public static class CmdEvent
    extends EventCmdtypeWithBackEvent<Cmd, CallbackEvent> {
        private static final long serialVersionUID = 1L;
        public FileRemote filesrc;
        public FileRemote filedst;
        public String namesSrc;
        public String maskSrc;
        public String nameDst;
        public int modeCopyOper;
        String newName;
        int maskFlags;
        int newFlags;
        long newDate;

        public CmdEvent(EventSource eventSource, EventConsumer eventConsumer, EventTimerThread eventTimerThread, CallbackEvent callbackEvent) {
            super(eventSource, eventConsumer, eventTimerThread, callbackEvent);
        }

        public CmdEvent() {
        }

        public CmdEvent(EventSource eventSource, FileRemote fileRemote, FileRemote fileRemote2, EventConsumer eventConsumer, EventTimerThread eventTimerThread) {
            super(eventSource, eventConsumer, eventTimerThread, null);
        }

        @Override
        public CallbackEvent getOpponent() {
            return (CallbackEvent)super.getOpponent();
        }

        @Override
        public boolean sendEvent(Cmd cmd) {
            return super.sendEvent(cmd);
        }

        @Override
        public Cmd getCmd() {
            return (Cmd)((Object)super.getCmd());
        }

        public final FileRemote filesrc() {
            return this.filesrc;
        }

        public final FileRemote filedst() {
            return this.filedst;
        }

        public final int modeCopyOper() {
            return this.modeCopyOper;
        }

        public final String newName() {
            return this.newName;
        }

        public final int maskFlags() {
            return this.maskFlags;
        }

        public final int newFlags() {
            return this.newFlags;
        }

        public final long newDate() {
            return this.newDate;
        }
    }

    public static enum Ecmp {
        ends,
        starts,
        contains,
        equals,
        always;

    }

    public static enum Cmd {
        noCmd,
        reserve,
        check,
        move,
        moveChecked,
        copyChecked,
        chgProps,
        chgPropsRecurs,
        countLength,
        delete,
        delChecked,
        compare,
        mkDir,
        mkDirs,
        abortAll,
        last;

    }

    static class CallbackCmpDirs
    implements FileRemoteCallback {
        final int modeLog;
        StringBuilder ret;
        boolean bNotEqual;
        boolean bMissing2Files;
        boolean bSomeEqual;

        CallbackCmpDirs(int n) {
            this.modeLog = n;
        }

        @Override
        public void start(FileRemote fileRemote) {
        }

        @Override
        public SortedTreeWalkerCallback.Result offerParentNode(FileRemote fileRemote) {
            return null;
        }

        @Override
        public SortedTreeWalkerCallback.Result finishedParentNode(FileRemote fileRemote, SortedTreeWalkerCallback.Counters counters) {
            return null;
        }

        @Override
        public SortedTreeWalkerCallback.Result offerLeafNode(FileRemote fileRemote, Object object) {
            int n = (Integer)object;
            if ((n & 0x8000000) != 0) {
                if ((this.modeLog & 1) != 0) {
                    this.appendFilepath("not equal", fileRemote);
                } else {
                    this.bNotEqual = true;
                }
            } else if ((n & 0x1000000) != 0) {
                if ((this.modeLog & 2) != 0) {
                    this.appendFilepath("alone    ", fileRemote);
                } else {
                    this.bMissing2Files = true;
                }
            } else if ((n & 0x4000000) != 0) {
                if ((this.modeLog & 8) != 0) {
                    this.appendFilepath("ok       ", fileRemote);
                } else {
                    this.bSomeEqual = true;
                }
            }
            return SortedTreeWalkerCallback.Result.cont;
        }

        void appendFilepath(String string, FileRemote fileRemote) {
            if (this.ret == null) {
                this.ret = new StringBuilder(1000);
            }
            this.ret.append(string).append(": ").append(fileRemote.sCanonicalPath).append('\n');
        }

        @Override
        public void finished(FileRemote fileRemote, SortedTreeWalkerCallback.Counters counters) {
        }

        @Override
        public boolean shouldAborted() {
            return false;
        }
    }

    public static interface FileRemoteAccessorSelector {
        public FileRemoteAccessor selectFileRemoteAccessor(String var1);
    }
}

