/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.fileRemote;

import java.util.ListIterator;
import java.util.Map;
import org.vishia.fileRemote.FileRemote;
import org.vishia.util.Debugutil;
import org.vishia.util.FileSystem;
import org.vishia.util.IndexMultiTable;
import org.vishia.util.StringFunctions;
import org.vishia.util.StringPart;

public class FileCluster {
    public static final String version = "2017-08-30";
    protected IndexMultiTable<String, FileRemote> idxPaths = new IndexMultiTable(IndexMultiTable.providerString);

    public FileRemote getDir(CharSequence charSequence) {
        return this.getFile(charSequence, null);
    }

    public FileRemote getFile(CharSequence charSequence, CharSequence charSequence2) {
        return this.getFile(charSequence, charSequence2, true);
    }

    FileRemote getFile(CharSequence charSequence, CharSequence charSequence2, boolean bl) {
        Object object;
        String string;
        CharSequence charSequence3 = FileSystem.normalizePath(charSequence);
        if (!FileSystem.isAbsolutePath(charSequence3)) {
            throw new IllegalArgumentException("absolute path expected, " + charSequence3);
        }
        int n = charSequence3.length();
        if (charSequence3.charAt(n - 1) == '/' && n > 3) {
            Debugutil.stop();
            string = charSequence3.subSequence(0, n - 1).toString();
            --n;
        } else {
            string = charSequence3.toString();
        }
        int n2 = charSequence2 == null ? 16 : 0;
        FileRemote fileRemote = this.idxPaths.search(string);
        if (fileRemote == null) {
            fileRemote = this.createOrgetChild(string);
        } else {
            object = fileRemote.getPathChars();
            int n3 = object.length();
            int n4 = StringFunctions.comparePos(string, 0, (CharSequence)object, 0, -1);
            if (n4 != 0) {
                if (n4 - 1 == n3 && bl && string.length() >= n3 && string.charAt(n3) == '/') {
                    StringPart stringPart = new StringPart(string + '/', n3 + 1, string.length() + 1);
                    fileRemote = fileRemote.subdir(stringPart);
                } else {
                    fileRemote = this.createOrgetChild(string);
                }
            }
        }
        object = charSequence2 != null ? fileRemote.child(charSequence2) : fileRemote;
        while (!fileRemote.isRoot()) {
            FileRemote fileRemote2;
            if (fileRemote.parent != null) {
                fileRemote2 = fileRemote.parent;
            } else {
                int n5;
                CharSequence charSequence4;
                int n6;
                CharSequence charSequence5 = fileRemote.getPathChars();
                int n7 = StringFunctions.lastIndexOf(charSequence5, '/');
                if (n7 == (n6 = StringFunctions.indexOf(charSequence5, '/', 0))) {
                    charSequence4 = charSequence5.subSequence(0, n7 + 1);
                    n5 = 0x100010;
                } else {
                    charSequence4 = charSequence5.subSequence(0, n7);
                    n5 = 16;
                }
                fileRemote2 = this.idxPaths.get(charSequence4);
                if (fileRemote2 == null) {
                    fileRemote2 = new FileRemote(this, fileRemote.device, null, charSequence4, 0L, 0L, 0L, 0L, n5, null, true);
                    this.idxPaths.put(charSequence4.toString(), fileRemote2);
                }
                fileRemote.parent = fileRemote2;
            }
            Map<String, FileRemote> map = fileRemote2.children();
            if (map == null || map.get(fileRemote.getName()) == null) {
                fileRemote2.putNewChild(fileRemote);
            }
            fileRemote = fileRemote2;
        }
        return object;
    }

    private FileRemote createOrgetChild(String string) {
        FileRemote fileRemote;
        int n = string.lastIndexOf(47);
        assert (n >= 0);
        if (n == 0 || n == 2 && string.charAt(1) == ':') {
            fileRemote = new FileRemote(this, null, null, string, 0L, 0L, 0L, 0L, 16, null, true);
            this.idxPaths.put(string, fileRemote);
        } else {
            String string2 = string.substring(0, n);
            FileRemote fileRemote2 = this.getFile(string2, null, true);
            if (fileRemote2 == null) {
                fileRemote2 = this.createOrgetChild(string2);
            }
            if (fileRemote2 == null) {
                fileRemote2 = new FileRemote(this, null, null, string2, 0L, 0L, 0L, 0L, 16, null, true);
                this.idxPaths.put(string2, fileRemote2);
            }
            fileRemote = fileRemote2.child(string.substring(n + 1));
            this.idxPaths.put(string, fileRemote);
        }
        return fileRemote;
    }

    public ListIterator<FileRemote> listSubdirs(String string) {
        return this.idxPaths.iterator(string);
    }

    public FileRemote XXXgetFile(CharSequence charSequence, CharSequence charSequence2, boolean bl) {
        Object object;
        Object object2;
        int n;
        CharSequence charSequence3;
        int n2;
        Object object3;
        Object object4;
        String string;
        int n3;
        CharSequence charSequence4 = FileSystem.normalizePath(charSequence);
        if (charSequence4.charAt((n3 = charSequence4.length()) - 1) == '/' && n3 > 3) {
            Debugutil.stop();
            string = charSequence.subSequence(0, n3 - 1).toString();
            --n3;
        } else {
            string = charSequence4.toString();
        }
        int n4 = charSequence2 == null ? 16 : 0;
        boolean bl2 = false;
        boolean bl3 = false;
        ListIterator<FileRemote> listIterator = this.idxPaths.iterator(string);
        if (listIterator.hasNext()) {
            object4 = listIterator.next();
            listIterator.previous();
        } else if (listIterator.hasPrevious()) {
            object4 = listIterator.previous();
        } else {
            object4 = new FileRemote(this, null, null, string, 0L, 0L, 0L, 0L, n4, null, true);
            System.out.println("FileCluster - create FileRemote because no found previous, the first one; " + string);
            this.idxPaths.put(string, (FileRemote)object4);
            bl2 = true;
            bl3 = false;
        }
        while (!bl2) {
            bl3 = true;
            bl2 = false;
            object3 = ((FileRemote)object4).getAbsolutePath();
            int n5 = ((String)object3).length();
            n2 = StringFunctions.comparePos(string, 0, (CharSequence)object3, 0, -1);
            if (n2 == 0) {
                bl3 = false;
                bl2 = true;
            } else if (n2 == n5) {
                if (((String)object3).length() < string.length() && string.charAt(n5) == '/') {
                    charSequence3 = new StringPart(string, n5 + 1, string.length());
                    object4 = ((FileRemote)object4).child(charSequence3);
                    bl3 = false;
                    bl2 = true;
                }
            } else if (n2 == -n3 && ((String)object3).charAt(n3) == '/') {
                charSequence3 = null;
                String string2 = "";
                n = -1;
                while ((n5 = ((String)object3).lastIndexOf(47)) >= n3) {
                    if (charSequence3 == null) {
                        CharSequence charSequence5 = charSequence3 = listIterator.hasPrevious() ? listIterator.previous() : null;
                        if (charSequence3 != null) {
                            string2 = ((FileRemote)((Object)charSequence3)).getAbsolutePath();
                            n = string2.length();
                        }
                    }
                    object3 = ((String)object3).substring(0, n5);
                    if (((FileRemote)object4).parent == null) {
                        int n6 = charSequence3 != null ? StringFunctions.comparePos(string2, (CharSequence)object3) : 0;
                        if (-n6 == n) {
                            if (n == n5) {
                                object2 = charSequence3;
                                charSequence3 = null;
                                string2 = null;
                                n = 0;
                            } else {
                                object = ((String)object3).substring(n, n5);
                                object2 = ((FileRemote)((Object)charSequence3)).getChild((CharSequence)object);
                            }
                        } else {
                            object2 = new FileRemote(this, ((FileRemote)object4).device, null, (CharSequence)object3, 0L, 0L, 0L, 0L, n4, null, true);
                            this.idxPaths.put((String)object3, (FileRemote)object2);
                            System.out.println("FileCluster - create FileRemote for parent; " + string);
                        }
                        ((FileRemote)object2).putNewChild((FileRemote)object4);
                        object4 = object2;
                        continue;
                    }
                    object4 = ((FileRemote)object4).parent;
                    bl3 = false;
                    if (((FileRemote)object4).getAbsolutePath().equals(object3)) continue;
                    throw new IllegalStateException("FileCluster - faulty parent found.");
                }
                bl2 = true;
            }
            if (bl2) continue;
            if (!listIterator.hasPrevious()) {
                object4 = new FileRemote(this, null, null, string, 0L, 0L, 0L, 0L, n4, null, true);
                System.out.println("FileCluster - create FileRemote because nonfound entry; " + string);
                bl2 = true;
                bl3 = true;
                continue;
            }
            object4 = listIterator.previous();
        }
        if (bl3) {
            String string3;
            listIterator.next();
            if (string.charAt(n3 - 1) == '/') {
                --n3;
            }
            while (listIterator.hasNext() && n3 < (n2 = (string3 = ((FileRemote)(object3 = listIterator.next())).getAbsolutePath()).length()) && StringFunctions.startsWith(string3, string)) {
                charSequence3 = string3.subSequence(n3 + 1, n2);
                int n7 = 0;
                FileRemote fileRemote = object4;
                while ((n = StringFunctions.indexOf(charSequence3, '/', n7)) > n7) {
                    object2 = charSequence3.subSequence(n7, n);
                    object = fileRemote.getChild((CharSequence)object2);
                    if (object == null) {
                        object = fileRemote.internalAccess().newChild((CharSequence)object2, 0L, 0L, 0L, 0L, 16, null);
                        fileRemote.putNewChild((FileRemote)object);
                    }
                    fileRemote = object;
                    n7 = n + 1;
                }
                fileRemote.putNewChild((FileRemote)object3);
            }
            this.idxPaths.put(string.toString(), (FileRemote)object4);
        }
        object3 = charSequence2 != null ? ((FileRemote)object4).child(charSequence2) : object4;
        Object object5 = object4;
        while (((FileRemote)object5).parent != null) {
            object5 = ((FileRemote)object5).parent;
        }
        while (!((FileRemote)object5).isRoot()) {
            int n8;
            CharSequence charSequence6;
            int n9;
            CharSequence charSequence7 = ((FileRemote)object5).getPathChars();
            int n10 = StringFunctions.lastIndexOf(charSequence7, '/');
            if (n10 == (n9 = StringFunctions.indexOf(charSequence7, '/', 0))) {
                charSequence6 = charSequence7.subSequence(0, n10 + 1);
                n8 = 0x100010;
            } else {
                charSequence6 = charSequence7.subSequence(0, n10);
                n8 = 16;
            }
            object2 = new FileRemote(this, ((FileRemote)object5).device, null, charSequence6, 0L, 0L, 0L, 0L, n8, null, true);
            ((FileRemote)object5).parent = object2;
            this.idxPaths.put(charSequence6.toString(), (FileRemote)object2);
            object5 = object2;
        }
        return object3;
    }

    FileRemote XXXcheck(CharSequence charSequence, CharSequence charSequence2) {
        StringBuilder stringBuilder;
        CharSequence charSequence3 = FileSystem.normalizePath(charSequence);
        StringBuilder stringBuilder2 = stringBuilder = charSequence3 instanceof StringBuilder ? (StringBuilder)charSequence3 : new StringBuilder(charSequence3);
        if (charSequence2 != null) {
            if (stringBuilder.charAt(stringBuilder.length() - 1) != '/') {
                stringBuilder.append('/');
            }
            stringBuilder.append(charSequence2);
        }
        String string = stringBuilder.toString();
        FileRemote fileRemote = this.idxPaths.get(string);
        return fileRemote;
    }
}

