/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.cmd;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.script.ScriptException;
import org.vishia.cmd.JZtxtcmdExecuter;
import org.vishia.cmd.JZtxtcmdScript;
import org.vishia.mainCmd.MainCmdLogging_ifc;
import org.vishia.util.DataAccess;
import org.vishia.util.Debugutil;
import org.vishia.util.StringPart;

public class CmdExecuter
implements Closeable {
    public static final String version = "2016-09-18";
    private final ProcessBuilder processBuilder;
    private Process process;
    private ExecuteAfterFinish executeAfterCmd;
    private Charset charsetCmd = Charset.defaultCharset();
    boolean bRunThreads = true;
    private final OutThread outThread = new OutThread(true);
    private final OutThread errThread = new OutThread(false);
    final Thread threadExecOut;
    final Thread threadExecIn = null;
    final Thread threadExecError;
    ConcurrentLinkedQueue<CmdQueueEntry> cmdQueue;
    private JZtxtcmdExecuter jzcmdExecuter;
    String[] sConsoleInvocation = new String[]{"cmd.exe", "/C"};

    public CmdExecuter() {
        this.processBuilder = new ProcessBuilder("");
        this.threadExecOut = new Thread((Runnable)this.outThread, "execOut");
        this.threadExecError = new Thread((Runnable)this.errThread, "execError");
        this.threadExecOut.start();
        this.threadExecError.start();
    }

    public void initJZcmdExecuter(JZtxtcmdScript jZtxtcmdScript, String string, MainCmdLogging_ifc mainCmdLogging_ifc) throws Throwable {
        if (this.jzcmdExecuter == null) {
            this.jzcmdExecuter = new JZtxtcmdExecuter(mainCmdLogging_ifc);
        }
        this.jzcmdExecuter.initialize(jZtxtcmdScript, false, string);
    }

    public void setCurrentDir(File file) {
        this.processBuilder.directory(file);
    }

    public void setCharsetForOutput(String string) {
        this.charsetCmd = Charset.forName(string);
    }

    public Map<String, String> environment() {
        return this.processBuilder.environment();
    }

    public void specifyConsoleInvocation(String string) {
        this.sConsoleInvocation = CmdExecuter.splitArgs(string);
    }

    public void addCmd(String string, String string2, Appendable appendable, File file, ExecuteAfterFinish executeAfterFinish) {
        String[] stringArray = CmdExecuter.splitArgs(string);
        LinkedList<Appendable> linkedList = new LinkedList<Appendable>();
        linkedList.add(appendable);
        this.addCmd(stringArray, string2, linkedList, null, file, executeAfterFinish);
    }

    public void addCmd(String[] stringArray, String string, List<Appendable> list, List<Appendable> list2, File file, ExecuteAfterFinish executeAfterFinish) {
        if (this.cmdQueue == null) {
            this.cmdQueue = new ConcurrentLinkedQueue();
        }
        CmdQueueEntry cmdQueueEntry = new CmdQueueEntry();
        cmdQueueEntry.cmd = stringArray;
        cmdQueueEntry.input = string;
        cmdQueueEntry.out = list;
        cmdQueueEntry.err = list2;
        cmdQueueEntry.currentDir = file;
        cmdQueueEntry.executeAfterFinish = executeAfterFinish;
        this.cmdQueue.offer(cmdQueueEntry);
    }

    public void addCmd(JZtxtcmdScript.Subroutine subroutine, List<DataAccess.Variable<Object>> list, Appendable appendable, File file) {
        if (this.jzcmdExecuter == null) {
            throw new IllegalArgumentException("The CmdExecuter should be initiaized with initJZcmdExecuter(script,...)");
        }
        if (this.cmdQueue == null) {
            this.cmdQueue = new ConcurrentLinkedQueue();
        }
        CmdQueueEntry cmdQueueEntry = new CmdQueueEntry();
        cmdQueueEntry.jzsub = subroutine;
        cmdQueueEntry.args = list;
        cmdQueueEntry.out1 = appendable;
        cmdQueueEntry.out = new LinkedList<Appendable>();
        cmdQueueEntry.out.add(appendable);
        cmdQueueEntry.currentDir = file;
        this.cmdQueue.offer(cmdQueueEntry);
    }

    public void clearCmdQueue() {
        if (this.cmdQueue != null) {
            this.cmdQueue.clear();
        }
    }

    public CmdQueueEntry executeCmdQueue(boolean bl) {
        CmdQueueEntry cmdQueueEntry = null;
        while (this.cmdQueue != null && (cmdQueueEntry = this.cmdQueue.poll()) != null) {
            if (cmdQueueEntry.jzsub != null) {
                try {
                    this.jzcmdExecuter.execSub(cmdQueueEntry.jzsub, cmdQueueEntry.args, true, cmdQueueEntry.out1, cmdQueueEntry.currentDir, this);
                }
                catch (ScriptException scriptException) {
                    String string = "execute JZsub, scriptexception, " + scriptException.getMessage();
                    try {
                        cmdQueueEntry.out1.append(string);
                    }
                    catch (IOException iOException) {}
                }
                continue;
            }
            if (cmdQueueEntry.currentDir != null) {
                this.setCurrentDir(cmdQueueEntry.currentDir);
            }
            cmdQueueEntry.errorCmd = this.execute(cmdQueueEntry.cmd, false, cmdQueueEntry.input, cmdQueueEntry.out, cmdQueueEntry.err, cmdQueueEntry.executeAfterFinish);
            if (cmdQueueEntry.errorCmd == 0 || !bl) continue;
            break;
        }
        return cmdQueueEntry;
    }

    public int execute(String string, String string2, Appendable appendable, Appendable appendable2) {
        String[] stringArray = CmdExecuter.splitArgs(string);
        return this.execute(stringArray, string2, appendable, appendable2);
    }

    public int execute(String string, String string2, Appendable appendable, Appendable appendable2, boolean bl) {
        String[] stringArray = bl ? this.sConsoleInvocation : null;
        String[] stringArray2 = CmdExecuter.splitArgs(string, stringArray, null);
        return this.execute(stringArray2, string2, appendable, appendable2);
    }

    public int execute(String[] stringArray, String string, Appendable appendable, Appendable appendable2) {
        LinkedList<Appendable> linkedList;
        LinkedList<Appendable> linkedList2;
        boolean bl = true;
        if (appendable != null) {
            bl = false;
            linkedList2 = new LinkedList<Appendable>();
            linkedList2.add(appendable);
        } else {
            linkedList2 = null;
        }
        if (appendable2 != null && appendable2 != appendable) {
            bl = false;
            linkedList = new LinkedList<Appendable>();
            linkedList.add(appendable2);
        } else {
            linkedList = null;
        }
        return this.execute(stringArray, bl, string, linkedList2, linkedList, null);
    }

    public int execute(String[] stringArray, String string, List<Appendable> list, List<Appendable> list2) {
        return this.execute(stringArray, list == null && list2 == null, string, list, list2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(String[] stringArray, boolean bl, String string, List<Appendable> list, List<Appendable> list2, ExecuteAfterFinish executeAfterFinish) {
        int n;
        this.executeAfterCmd = executeAfterFinish;
        this.processBuilder.command(stringArray);
        if (list2 == null) {
            this.processBuilder.redirectErrorStream(true);
        }
        try {
            Object object;
            this.process = this.processBuilder.start();
            if (list2 != null) {
                this.errThread.bProcessIsRunning = true;
                this.errThread.processOut = new BufferedReader(new InputStreamReader(this.process.getErrorStream(), this.charsetCmd));
                this.errThread.outs = list2;
                object = this.errThread;
                synchronized (object) {
                    this.errThread.notify();
                }
            }
            if (list != null) {
                this.outThread.bProcessIsRunning = true;
                this.outThread.processOut = new BufferedReader(new InputStreamReader(this.process.getInputStream(), this.charsetCmd));
                this.outThread.outs = list;
                object = this.outThread;
                synchronized (object) {
                    this.outThread.notify();
                }
            }
            if (string != null) {
                object = this.process.getOutputStream();
                ((OutputStream)object).write(string.getBytes());
            }
            if (string != null || list != null || list2 != null) {
                n = this.process.waitFor();
                this.outThread.bProcessIsRunning = false;
                this.errThread.bProcessIsRunning = false;
                object = this.outThread;
                synchronized (object) {
                    if (this.outThread.processOut != null) {
                        this.outThread.wait();
                    }
                }
                object = this.errThread;
                synchronized (object) {
                    if (this.errThread.processOut != null) {
                        this.errThread.wait();
                    }
                }
            }
            n = bl ? 0 : this.process.waitFor();
            object = this;
            synchronized (object) {
                this.process = null;
            }
        }
        catch (Exception exception) {
            if (list2 != null) {
                try {
                    String string2 = "CmdExecuter - Problem;" + exception.getMessage();
                    for (Appendable appendable : list2) {
                        appendable.append(string2);
                    }
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            } else {
                throw new RuntimeException(exception);
            }
            n = -1;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean abortCmd() {
        boolean bl = false;
        CmdExecuter cmdExecuter = this;
        synchronized (cmdExecuter) {
            if (this.process != null) {
                this.process.destroy();
                bl = true;
            }
            this.outThread.outs = null;
            this.errThread.outs = null;
        }
        return bl;
    }

    public boolean abortAllCmds() {
        this.cmdQueue.clear();
        return this.abortCmd();
    }

    public static String[] splitArgs(String string) {
        return CmdExecuter.splitArgs(string, null, null);
    }

    public static String[] splitArgs(String string, String[] stringArray, String[] stringArray2) {
        int n;
        StringPart stringPart = new StringPart(string);
        stringPart.setIgnoreWhitespaces(true);
        stringPart.setIgnoreEndlineComment("##");
        int n2 = -1;
        int[] nArray = new int[1000];
        int n3 = 0;
        while (stringPart.length() > 0) {
            stringPart.seekNoWhitespaceOrComments();
            n3 = (int)stringPart.getCurrentPosition();
            if (stringPart.length() > 0 && stringPart.getCurrentChar() == '\"') {
                nArray[++n2] = n3 + 1;
                stringPart.lentoQuotionEnd('\"', Integer.MAX_VALUE);
                n = stringPart.length();
                if (n <= 2) {
                    stringPart.setLengthMax();
                    n = stringPart.length() - 1;
                } else {
                    --n;
                }
            } else {
                nArray[++n2] = n3;
                stringPart.lentoAnyCharOutsideQuotion(" \t\n\r", Integer.MAX_VALUE);
                stringPart.len0end();
                n = stringPart.length();
            }
            nArray[++n2] = n3 + n;
            stringPart.fromEnd();
        }
        stringPart.close();
        n = (n2 + 1) / 2;
        if (stringArray != null) {
            n += stringArray.length;
        }
        if (stringArray2 != null) {
            n += stringArray2.length;
        }
        String[] stringArray3 = new String[n];
        int n4 = 0;
        if (stringArray != null) {
            for (String string2 : stringArray) {
                stringArray3[n4++] = string2;
            }
        }
        n2 = -1;
        while (n4 < stringArray3.length) {
            stringArray3[n4] = string.substring(nArray[++n2], nArray[++n2]);
            ++n4;
        }
        if (stringArray2 != null) {
            for (String string2 : stringArray) {
                stringArray3[n4++] = string2;
            }
        }
        return stringArray3;
    }

    void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.bRunThreads = false;
        while (this.outThread != null && this.outThread.state == 'r' || this.errThread != null && this.errThread.state == 'r') {
            CmdExecuter cmdExecuter = this;
            synchronized (cmdExecuter) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void finalize() {
        this.bRunThreads = false;
    }

    public static final void main(String[] stringArray) {
        CmdExecuter cmdExecuter = new CmdExecuter();
        cmdExecuter.execute("cmd /C", null, null, null);
        cmdExecuter.close();
        cmdExecuter.finalize();
    }

    class InThread
    implements Runnable {
        boolean bRunExec = false;
        BufferedWriter processIn;
        BufferedReader userInput;

        InThread() {
        }

        @Override
        public void run() {
            while (CmdExecuter.this.bRunThreads) {
                if (this.bRunExec) {
                    boolean bl = true;
                    try {
                        if (this.processIn.append("") != null) {
                            bl = false;
                        }
                    }
                    catch (IOException iOException) {
                        CmdExecuter.this.stop();
                    }
                    if (bl) {
                        this.bRunExec = false;
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    CmdExecuter.this.process.destroy();
                    continue;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    class OutThread
    implements Runnable {
        BufferedReader processOut;
        List<Appendable> outs;
        private final boolean isOutThread;
        char state = (char)46;
        boolean bProcessIsRunning;

        OutThread(boolean bl) {
            this.isOutThread = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.state = (char)114;
            while (CmdExecuter.this.bRunThreads) {
                try {
                    Object object;
                    if (this.processOut != null && this.outs != null) {
                        if (this.outs != null && this.processOut.ready()) {
                            object = this.processOut.readLine();
                            if (object != null) {
                                for (Appendable appendable : this.outs) {
                                    try {
                                        appendable.append((CharSequence)object).append("\n");
                                    }
                                    catch (Exception exception) {}
                                }
                            } else {
                                this.processOut = null;
                            }
                        } else if (!this.bProcessIsRunning) {
                            if (this.isOutThread && CmdExecuter.this.executeAfterCmd != null) {
                                try {
                                    int n = CmdExecuter.this.process.exitValue();
                                    CmdExecuter.this.executeAfterCmd.exec(n, this.outs == null ? null : this.outs.get(0), CmdExecuter.this.errThread == null || ((CmdExecuter)CmdExecuter.this).errThread.outs == null ? null : ((CmdExecuter)CmdExecuter.this).errThread.outs.get(0));
                                }
                                catch (Exception exception) {
                                    System.err.println("CmdExecuter - exception in executeAfterCmd");
                                }
                                CmdExecuter.this.executeAfterCmd = null;
                            }
                            this.outs = null;
                        } else {
                            Thread.sleep(100L);
                        }
                    } else {
                        try {
                            object = this;
                            synchronized (object) {
                                this.wait(1000L);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (this.outs != null || this.processOut == null) continue;
                    object = this;
                    synchronized (object) {
                        this.processOut.close();
                        this.processOut = null;
                        this.notify();
                    }
                }
                catch (Exception exception) {
                    Debugutil.stop();
                }
            }
            this.state = (char)120;
        }
    }

    public static interface ExecuteAfterFinish {
        public void exec(int var1, Appendable var2, Appendable var3);
    }

    public static class CmdQueueEntry {
        public String[] cmd;
        public JZtxtcmdScript.Subroutine jzsub;
        List<DataAccess.Variable<Object>> args;
        public String input;
        Appendable out1;
        public List<Appendable> out;
        public List<Appendable> err;
        public File currentDir;
        public ExecuteAfterFinish executeAfterFinish;
        public int errorCmd;
    }
}

