/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.byteData;

import org.vishia.byteData.ByteDataAccessBase;
import org.vishia.byteData.RawDataAccess;

public class Object_Jc
extends ByteDataAccessBase {
    public static final int kPos_objIdentSize = 16;
    private static final int kPos_ownAdress = 0;
    private static final int kPos_reflectionClassAdress = 8;
    public static final int sizeof_Object_Jc = 24;
    public static final int mArray_objectIdentSize = 0x40000000;
    public static final int mInitialized_objectIdentSize = Integer.MIN_VALUE;
    public static final int mSizeBits_typeSizeIdent = 0x30000000;
    public static final int kIsSmallSize_typeSizeIdent = 0;
    public static final int mIsMediumSize_typeSizeIdent = 0x10000000;
    public static final int mIsLargeSize_typeSizeIdent = 0x20000000;
    private static final int mSizeSmall_typeSizeIdent = 65535;
    public static final int mIdentSmall_typeSizeIdent = 0xFFF0000;
    public static final int kBitIdentSmall_objectIdentSize = 16;
    private static final int mSizeMedium_typeSizeIdent = 1048575;
    public static final int mIdentMedium_typeSizeIdent = 0xFF00000;
    public static final int kBitIdentMedium_objectIdentSize = 20;
    private static final int mSizeLarge_typeSizeIdent = 0xFFFFFF;
    public static final int mIdentLarge_typeSizeIdent = 0x1F000000;
    public static final int kBitIdentLarge_objectIdentSize = 24;
    public static final int OBJTYPE_Class_Jc = 0xFF80000;
    public static final int OBJTYPE_ReflectionImageBaseAddress_Jc = 0xFF70000;
    public static final int OBJTYPE_Field_Jc = 0xFF50000;

    public Object_Jc() {
        super(24);
        this.setBigEndian(false);
    }

    public Object_Jc(int n) {
        super(n);
        this.setBigEndian(false);
    }

    public int getSizeObject() {
        int n = 0;
        int n2 = this.getInt32(16);
        n = (n2 & 0x20000000) != 0 ? n2 & 0xFFFFFF : ((n2 & 0x10000000) != 0 ? n2 & 0xFFFFF : n2 & 0xFFFF);
        return n;
    }

    public int nrofArrayDimensions() {
        int n = this.getInt32(16);
        return n >> 30 & 3;
    }

    public int getOwnAdress() {
        return this.getInt32(0);
    }

    public int getReflectionClass() {
        return this.getInt32(8);
    }

    protected int getIdent(int n) {
        int n2;
        int n3;
        int n4 = 0;
        int n5 = this.getInt32(16 + n);
        if ((n5 & 0x20000000) != 0) {
            n3 = 24;
            n2 = 0x1F000000;
        } else if ((n5 & 0x10000000) != 0) {
            n3 = 20;
            n2 = 0xFF00000;
        } else {
            n3 = 16;
            n2 = 0xFFF0000;
        }
        n4 = (n5 & n2) >> n3;
        return n4;
    }

    public int getIdent() {
        return this.getIdent(0);
    }

    public void setIdentSize(boolean bl, boolean bl2, int n, int n2) {
        int n3 = 0;
        if ((n2 & 0xFF000000) != 0) {
            throw new IllegalArgumentException("size is too much: " + n2);
        }
        if ((n2 & 0xFFFF0000) != 0) {
            if ((n2 & 0xFFF00000) != 0) {
                int n4 = n << 24;
                if ((n4 & 0xE0FFFFFF) != 0) {
                    throw new IllegalArgumentException("large size, indent too great, max is 31: " + n);
                }
                n3 = 0x20000000 + n2 + n4;
            } else {
                int n5 = n << 20;
                if ((n5 & 0xF00FFFFF) != 0) {
                    throw new IllegalArgumentException("medium size, indent too great, max is 255: " + n);
                }
                n3 = 0x20000000 + n2 + n5;
            }
        } else {
            int n6 = n << 16;
            if ((n6 & 0xF000FFFF) != 0) {
                throw new IllegalArgumentException("small size, indent too great, max is 4095: " + n);
            }
            n3 = n2 + n6;
        }
        if (bl2) {
            n3 |= 0x40000000;
        }
        if (bl) {
            n3 |= Integer.MIN_VALUE;
        }
        this.setInt32(16, n3);
    }

    public boolean isObjectJcArray() {
        return (this.getInt32(16) & 0x40000000) != 0;
    }

    public final int getIntVal(int n, int n2) {
        return (int)this._getLong(n, n2);
    }

    public final float getFloatVal(int n) {
        return Float.intBitsToFloat((int)this._getLong(n, 4));
    }

    public final double getDoubleVal(int n) {
        return Double.longBitsToDouble(this._getLong(n, 8));
    }

    public void castToRawDataAccess(RawDataAccess rawDataAccess) {
        this.assignCasted(rawDataAccess, 0, -1);
    }

    public String showContent(Appendable appendable) {
        try {
            appendable.append("@0x").append(Integer.toHexString(super.getPositionInBuffer()));
            appendable.append(": ObjectJc own=0x").append(Integer.toHexString(this.getOwnAdress()));
            appendable.append(" id=0x").append(Integer.toHexString(this.getIdent()));
            appendable.append("=").append(Integer.toString(this.getIdent()));
            appendable.append(" size");
            if (this.isObjectJcArray()) {
                appendable.append("[]");
            }
            appendable.append("=0x").append(Integer.toHexString(this.getSizeObject()));
            appendable.append("=").append(Integer.toString(this.getSizeObject()));
            appendable.append(" refl @0x").append(Integer.toHexString(this.getReflectionClass()));
            return appendable.toString();
        }
        catch (Exception exception) {
            return "Exception on Appendable: " + exception.getMessage();
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200);
        return this.showContent(stringBuilder);
    }
}

