/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.byteData;

import java.util.Map;
import java.util.TreeMap;
import org.vishia.byteData.ByteDataAccess;
import org.vishia.byteData.ByteDataAccessBase;
import org.vishia.byteData.Object_Jc;

public class Field_Jc
extends ByteDataAccessBase {
    private static final int kPosName = 0;
    public static final int kLengthName = 30;
    private static final int kPos_nrofArrayElements = 30;
    public static final int kPos_type = 32;
    private static final int kPos_bitModifiers = 36;
    private static final int kPos_position = 40;
    private static final int kPos_offsetToObjectifcBase = 42;
    private static final int kPos_declaringClass = 44;
    public static final int sizeOf_Field_Jc = 48;
    public static final int REFLECTION_void = 1;
    public static final int REFLECTION_int64 = 2;
    public static final int REFLECTION_uint64 = 3;
    public static final int REFLECTION_int32 = 4;
    public static final int REFLECTION_uint32 = 5;
    public static final int REFLECTION_int16 = 6;
    public static final int REFLECTION_uint16 = 7;
    public static final int REFLECTION_int8 = 8;
    public static final int REFLECTION_uint8 = 9;
    public static final int REFLECTION_int = 10;
    public static final int REFLECTION_uint = 11;
    public static final int REFLECTION_float = 12;
    public static final int REFLECTION_double = 13;
    public static final int REFLECTION_char = 14;
    public static final int REFLECTION_bool = 15;
    public static final int REFLECTION_boolean = 15;
    public static final int REFLECTION_String = 16;
    public static final int REFLECTION_bitfield = 23;
    public static final int mOffsIsProxyIx4Target_FieldJc = 32768;
    private static final Map<String, TypeSizeIdent> scalarTypeProperties = new TreeMap<String, TypeSizeIdent>();
    public static final int REFLECTION_Object_Jc = 65;
    public static final int REFLECTION_ObjectRefValues_Jc = 68;
    public static final int REFLECTION_Class_Jc = 69;
    public static final int REFLECTION_Class_Jc_t = 69;
    public static final int XXXOBJTYPE_Field_Jc = 0xFF50000;
    public static final int INIZ_ID_FieldJc = 4085;

    public static TypeSizeIdent getTypeSizeIdent(String string) {
        if (scalarTypeProperties.size() == 0) {
            scalarTypeProperties.put("void", new TypeSizeIdent(8, 1));
            scalarTypeProperties.put("int64", new TypeSizeIdent(8, 2));
            scalarTypeProperties.put("uint34", new TypeSizeIdent(8, 3));
            scalarTypeProperties.put("int32", new TypeSizeIdent(4, 4));
            scalarTypeProperties.put("uint32", new TypeSizeIdent(4, 5));
            scalarTypeProperties.put("int16", new TypeSizeIdent(2, 6));
            scalarTypeProperties.put("uint16", new TypeSizeIdent(2, 7));
            scalarTypeProperties.put("int8", new TypeSizeIdent(1, 8));
            scalarTypeProperties.put("uint8", new TypeSizeIdent(1, 9));
            scalarTypeProperties.put("int", new TypeSizeIdent(4, 10));
            scalarTypeProperties.put("uint", new TypeSizeIdent(4, 11));
            scalarTypeProperties.put("float", new TypeSizeIdent(4, 12));
            scalarTypeProperties.put("double", new TypeSizeIdent(8, 13));
            scalarTypeProperties.put("char", new TypeSizeIdent(1, 14));
            scalarTypeProperties.put("bool", new TypeSizeIdent(1, 15));
            scalarTypeProperties.put("boolean", new TypeSizeIdent(1, 15));
        }
        return scalarTypeProperties.get(string);
    }

    public Field_Jc() {
        super(48);
    }

    public int getTypeSize(int n) {
        int n2 = 0;
        switch (n) {
            case 2: 
            case 3: 
            case 13: {
                n2 = 8;
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                n2 = 4;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
            case 8: 
            case 9: 
            case 14: {
                n2 = 1;
                break;
            }
            default: {
                n2 = 4;
            }
        }
        return n2;
    }

    public String getName() {
        return this.getString(0, 30);
    }

    public void setName(String string) {
        super.setString(0, 30, string);
    }

    public String getValue(Object_Jc object_Jc) {
        String string = "";
        int n = object_Jc.getLengthHead() + this.getPosValue();
        switch (this.getType()) {
            case 2: 
            case 3: 
            case 13: {
                string = string + this.convert2String(object_Jc.getInt64(n));
                break;
            }
            case 4: 
            case 10: 
            case 15: {
                string = string + this.convert2String(object_Jc.getInt32(n));
                break;
            }
            case 5: 
            case 11: {
                string = string + this.convert2String(object_Jc.getInt32(n));
                break;
            }
            case 6: {
                string = string + this.convert2String(object_Jc.getInt16(n));
                break;
            }
            case 7: {
                string = string + this.convert2String(object_Jc.getUint16(n));
                break;
            }
            case 8: {
                string = string + this.convert2String(object_Jc.getInt8(n));
                break;
            }
            case 9: {
                string = string + this.convert2String(object_Jc.getUint8(n));
                break;
            }
            case 12: {
                string = string + object_Jc.getFloat(n);
                break;
            }
            case 14: {
                string = string + object_Jc.getChar(n);
                break;
            }
            default: {
                string = string + "###";
            }
        }
        return string;
    }

    private String convert2String(int n) {
        String string = n + " [0x" + Integer.toHexString(n) + "]";
        return string;
    }

    private String convert2String(double d) {
        String string = d + " [0x" + Double.toHexString(d) + "]";
        return string;
    }

    public int getTypeSize() {
        int n = 0;
        int n2 = this.getType();
        switch (n2) {
            case 65: {
                n = 24;
                break;
            }
            case 68: {
                n = 4;
                break;
            }
            case 69: {
                n = 88;
                break;
            }
            default: {
                n = this.getTypeSize(n2);
            }
        }
        return n;
    }

    public int getType() {
        return this.getInt32(32);
    }

    public int getModifiers() {
        return this.getInt32(36);
    }

    public int getNrofBytesPrimitiveType() {
        int n = this.getModifiers();
        return n >> 16 & 0xF;
    }

    public int getDeclClass() {
        return this.getInt32(44);
    }

    public float getFloat(ByteDataAccess byteDataAccess) throws IllegalArgumentException {
        int n = this.getInt32(40);
        return byteDataAccess.getFloat(n);
    }

    public long getInt32(ByteDataAccess byteDataAccess) {
        int n = this.getInt32(40);
        return byteDataAccess.getInt32(n);
    }

    public long getInt16(ByteDataAccess byteDataAccess) {
        int n = this.getInt32(40);
        return byteDataAccess.getInt16(n);
    }

    public short getPosValue() {
        return this.getInt16(40);
    }

    public void set_nrofArrayElements(int n) {
        super.setInt16(30, n);
    }

    public void set_type(int n) {
        this.setInt32(32, n);
    }

    public void set_bitModifiers(int n) {
        super.setInt32(36, n);
    }

    public void set_position(int n) {
        super.setInt16(40, n);
    }

    public void set_offsetToObjectifcBase(int n) {
        super.setInt32(42, n);
    }

    public int setOffs_declaringClass(int n) {
        int n2 = this.getPositionInBuffer() + 44;
        super.setInt32(44, n - n2);
        return n2;
    }

    public int getPositionInBuffer_type() {
        return this.getPositionInBuffer() + 32;
    }

    public static enum EModifier {
        kBitPrimitiv_Modifier(16),
        mPrimitiv_Modifier(983040),
        kBitfield_Modifier(458752),
        kHandlePtr_Modifier(589824),
        mStatic_Modifier(8),
        kObjectArrayJc_Modifier(0x200000),
        kStaticArray_Modifier(0x800000),
        kEmbedded_Modifier_reflectJc(0x1000000),
        kReference_Modifier(0x2000000),
        mReference_Modifier(0x2000000),
        mObjectJc_Modifier(0x4000000),
        mObjectifcBaseJcpp_Modifier(0x8000000),
        mObjectJcBased_Modifier(0xC000000),
        kEmbeddedContainer_Modifier(0x10000000),
        kReferencedContainer_Modifier(0x20000000),
        kEnhancedRefContainer_Modifier(0x30000000);

        public int e;

        private EModifier(int n2) {
            this.e = n2;
        }
    }

    public static class TypeSizeIdent {
        public final int size;
        public final int ident;

        public TypeSizeIdent(int n, int n2) {
            this.size = n;
            this.ident = n2;
        }
    }
}

