/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.byteData;

import java.util.Map;
import java.util.TreeMap;
import org.vishia.bridgeC.ConcurrentLinkedQueue;
import org.vishia.bridgeC.IllegalArgumentExceptionJc;
import org.vishia.byteData.RawDataAccess;
import org.vishia.byteData.VariableAccessArray_ifc;
import org.vishia.mainCmd.Report;

public class ByteDataSymbolicAccess {
    public static final int versionStamp = 20120422;
    protected final Report log;
    private final Map<String, Variable> indexVariable = new TreeMap<String, Variable>();
    private byte[] data;
    private int ixStartData;
    private int nrofData;
    private long timeRequestNewValue;
    private final ConcurrentLinkedQueue<Runnable> runOnRecv = new ConcurrentLinkedQueue();
    private long timeSetNewValue;
    private final RawDataAccess dataAccess = new RawDataAccess();

    public ByteDataSymbolicAccess(Report report) {
        this.log = report;
    }

    public final void addVariable(String string, Variable variable) {
        this.indexVariable.put(string, variable);
    }

    public void assignData(byte[] byArray, long l) {
        this.assignData(byArray, byArray.length, 0, l);
    }

    public void assignData(byte[] byArray, int n, int n2, long l) {
        this.data = byArray;
        this.ixStartData = n2;
        this.nrofData = n;
        assert (n2 + n <= this.data.length);
        try {
            this.dataAccess.assign(this.data, n, n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.dataAccess.setBigEndian(true);
        this.timeSetNewValue = l;
        this.timeRequestNewValue = 0L;
    }

    public void copyNewData(byte[] byArray, int n, int n2, long l) {
        int n3 = n2 > this.data.length ? this.data.length : n2;
        System.arraycopy(byArray, n, this.data, 0, n3);
        this.timeSetNewValue = l;
    }

    public int lengthData() {
        return this.data == null ? 0 : this.data.length;
    }

    public long isRequestedNewData() {
        return this.timeRequestNewValue;
    }

    public Variable getVariable(String string) {
        return this.indexVariable.get(string);
    }

    public Variable getVariableAssert(String string) throws NoSuchFieldException {
        Variable variable = this.indexVariable.get(string);
        if (variable == null) {
            throw new NoSuchFieldException("ByteDataSymbolicAccess - Variable not found; " + string);
        }
        return variable;
    }

    public double getDouble(String string) {
        Variable variable = this.indexVariable.get(string);
        if (variable == null) {
            throw new IllegalArgumentException("not found:" + string);
        }
        return this.getDouble(variable, -1);
    }

    public double getDouble(Variable variable, int n) {
        return variable.getDouble(n);
    }

    public float getFloat(String string) {
        int[] nArray = new int[1];
        String string2 = ByteDataSymbolicAccess.separateIndex(string, nArray);
        Variable variable = this.indexVariable.get(string2);
        if (variable == null) {
            return 9.999999f;
        }
        return variable.getFloat(nArray);
    }

    public float getFloat(Variable variable) {
        return this.getFloat(variable, -1);
    }

    public float getFloat(Variable variable, int n) {
        return variable.getFloat(n);
    }

    public int getInt(String string) {
        Variable variable = this.indexVariable.get(string);
        if (variable == null) {
            throw new IllegalArgumentException("not found:" + string);
        }
        return this.getInt(variable, -1);
    }

    public int getInt(Variable variable, int n) {
        return variable.getInt(n);
    }

    public boolean getBool(String string) {
        Variable variable = this.indexVariable.get(string);
        if (variable == null) {
            throw new IllegalArgumentException("not found:" + string);
        }
        return this.getBool(variable, -1);
    }

    public boolean getBool(Variable variable, int n) {
        int n2;
        boolean bl = false;
        int n3 = n2 = n < 0 ? variable.bytePos : variable.bytePos + (n >> 3);
        if (n2 > this.data.length - 4) {
            throw new IllegalArgumentException("file to short: " + this.data.length + ", necessary: " + n2);
        }
        switch (variable.typeChar) {
            case 'I': {
                bl = 0 != this.dataAccess.getIntVal(n2, 4);
                break;
            }
            case 'J': {
                bl = 0 != this.dataAccess.getIntVal(n2, 8);
                break;
            }
            case 'S': {
                bl = 0 != this.dataAccess.getIntVal(n2, 2);
                break;
            }
            case 'B': {
                bl = 0 != this.dataAccess.getIntVal(n2, 1);
                break;
            }
            case 'Z': {
                byte by = (byte)this.dataAccess.getIntVal(n2, 1);
                bl = (by & variable.bitMask) != 0;
                break;
            }
            default: {
                new IllegalArgumentException("fault type, expected: float, found: " + variable.typeChar);
            }
        }
        return bl;
    }

    public void setFloat(String string, float f) {
        Variable variable = this.indexVariable.get(string);
        if (variable == null) {
            throw new IllegalArgumentException("not found:" + string);
        }
        variable.setFloat(f, -1);
    }

    public void setFloat(Variable variable, int n, float f) {
        variable.setFloat(f, n);
    }

    public void setInt(String string, int n) {
        Variable variable = this.indexVariable.get(string);
        if (variable == null) {
            throw new IllegalArgumentException("not found:" + string);
        }
        this.setInt(variable, -1, n);
    }

    public void setInt(Variable variable, int n, int n2) {
        variable.setInt(n2, n);
    }

    public static String separateIndex(String string, int[] nArray) {
        int n;
        String string2;
        int n2 = string.indexOf(91);
        String string3 = string2 = n2 < 0 ? string : string.substring(0, n2);
        if (n2 >= 0) {
            int n3 = string.indexOf(93, n2 + 1);
            String string4 = string.substring(n2 + 1, n3);
            n = Integer.parseInt(string4);
        } else {
            n = -1;
        }
        if (nArray != null) {
            nArray[0] = n;
        }
        return string2;
    }

    public class Variable
    implements VariableAccessArray_ifc {
        public final ByteDataSymbolicAccess bytes;
        public String name;
        public String nameShow;
        private char typeChar;
        public int bytePos;
        public int bitMask;
        public int nrofBytes;
        public int nrofArrayElements;

        public char getTypeChar() {
            return this.typeChar;
        }

        public void set_typeChar(String string) {
            this.typeChar = string.charAt(0);
        }

        public Variable(ByteDataSymbolicAccess byteDataSymbolicAccess2) {
            this.bytes = byteDataSymbolicAccess2;
        }

        @Override
        public char getType() {
            return this.typeChar;
        }

        @Override
        public int getDimension(int n) {
            if (n == 0) {
                return this.nrofArrayElements <= 1 ? 0 : 1;
            }
            if (n == 1) {
                return this.nrofArrayElements <= 1 ? 0 : this.nrofArrayElements;
            }
            return 0;
        }

        @Override
        public int getInt(int ... nArray) {
            int n;
            int n2 = 0;
            int n3 = this.getNrofBytes();
            int n4 = n = nArray.length == 0 || nArray[0] < 0 ? this.bytePos : this.bytePos + nArray[0] * n3;
            if (n > ByteDataSymbolicAccess.this.data.length - n3) {
                throw new IllegalArgumentException("file to short: " + ByteDataSymbolicAccess.this.data.length + ", requested: " + n + n3);
            }
            switch (this.typeChar) {
                case 'D': {
                    n2 = (int)ByteDataSymbolicAccess.this.dataAccess.getDoubleVal(n);
                    break;
                }
                case 'F': {
                    n2 = (int)ByteDataSymbolicAccess.this.dataAccess.getFloatVal(n);
                    break;
                }
                case 'B': 
                case 'I': 
                case 'J': 
                case 'S': {
                    n2 = ByteDataSymbolicAccess.this.dataAccess.getIntVal(n, -n3);
                    break;
                }
                case 'Z': {
                    n2 = (ByteDataSymbolicAccess.this.dataAccess.getIntVal(n, 1) & this.bitMask) == 0 ? 0 : 1;
                    break;
                }
                default: {
                    new IllegalArgumentExceptionJc("fault type, expected: int, found: ", this.typeChar);
                }
            }
            return n2;
        }

        @Override
        public int setInt(int n, int ... nArray) {
            int n2;
            int n3 = this.getNrofBytes();
            int n4 = n2 = nArray.length == 0 || nArray[0] < 0 ? this.bytePos : this.bytePos + nArray[0] * n3;
            if (n2 > ByteDataSymbolicAccess.this.data.length - n3) {
                throw new IllegalArgumentException("file to short: " + ByteDataSymbolicAccess.this.data.length + ", requested: " + n2 + n3);
            }
            switch (this.typeChar) {
                case 'D': {
                    ByteDataSymbolicAccess.this.dataAccess.setDoubleVal(n2, n);
                    break;
                }
                case 'F': {
                    ByteDataSymbolicAccess.this.dataAccess.setFloatVal(n2, n);
                    break;
                }
                case 'B': 
                case 'I': 
                case 'J': 
                case 'S': {
                    ByteDataSymbolicAccess.this.dataAccess.setIntVal(n2, n3, n);
                    break;
                }
                case 'Z': {
                    byte by = (byte)ByteDataSymbolicAccess.this.dataAccess.getIntVal(n2, 1);
                    by = n == 0 ? (byte)(by & ~this.bitMask) : (byte)(by | this.bitMask);
                    ByteDataSymbolicAccess.this.dataAccess.setIntVal(n2, 1, by);
                    break;
                }
                default: {
                    new IllegalArgumentException("fault type, expected: float, found: " + this.typeChar);
                }
            }
            return n;
        }

        @Override
        public long getLong(int ... nArray) {
            int n;
            long l = 0L;
            int n2 = this.getNrofBytes();
            int n3 = n = nArray.length == 0 || nArray[0] < 0 ? this.bytePos : this.bytePos + nArray[0] * n2;
            if (n > ByteDataSymbolicAccess.this.data.length - n2) {
                throw new IllegalArgumentException("file to short: " + ByteDataSymbolicAccess.this.data.length + ", requested: " + n + n2);
            }
            switch (this.typeChar) {
                case 'D': {
                    l = (int)ByteDataSymbolicAccess.this.dataAccess.getDoubleVal(n);
                    break;
                }
                case 'F': {
                    l = (int)ByteDataSymbolicAccess.this.dataAccess.getFloatVal(n);
                    break;
                }
                case 'B': 
                case 'I': 
                case 'J': 
                case 'L': 
                case 'S': {
                    l = ByteDataSymbolicAccess.this.dataAccess.getIntVal(n, -n2);
                    break;
                }
                case 'Z': {
                    l = (ByteDataSymbolicAccess.this.dataAccess.getIntVal(n, 1) & this.bitMask) == 0 ? 0L : 1L;
                    break;
                }
                default: {
                    new IllegalArgumentExceptionJc("fault type, expected: int, found: ", this.typeChar);
                }
            }
            return l;
        }

        @Override
        public long setLong(long l, int ... nArray) {
            int n;
            int n2 = this.getNrofBytes();
            int n3 = n = nArray.length == 0 || nArray[0] < 0 ? this.bytePos : this.bytePos + nArray[0] * n2;
            if (n > ByteDataSymbolicAccess.this.data.length - n2) {
                throw new IllegalArgumentException("file to short: " + ByteDataSymbolicAccess.this.data.length + ", requested: " + n + n2);
            }
            switch (this.typeChar) {
                case 'D': {
                    ByteDataSymbolicAccess.this.dataAccess.setDoubleVal(n, l);
                    break;
                }
                case 'F': {
                    ByteDataSymbolicAccess.this.dataAccess.setFloatVal(n, l);
                    break;
                }
                case 'B': 
                case 'I': 
                case 'J': 
                case 'L': 
                case 'S': {
                    ByteDataSymbolicAccess.this.dataAccess.setIntVal(n, n2, l);
                    break;
                }
                case 'Z': {
                    byte by = (byte)ByteDataSymbolicAccess.this.dataAccess.getIntVal(n, 1);
                    by = l == 0L ? (byte)(by & ~this.bitMask) : (byte)(by | this.bitMask);
                    ByteDataSymbolicAccess.this.dataAccess.setIntVal(n, 1, by);
                    break;
                }
                default: {
                    new IllegalArgumentException("fault type, expected: float, found: " + this.typeChar);
                }
            }
            return l;
        }

        @Override
        public String getString(int ... nArray) {
            return null;
        }

        @Override
        public String setString(String string, int ... nArray) {
            return null;
        }

        @Override
        public float getFloat(int ... nArray) {
            int n;
            float f = 0.0f;
            int n2 = this.getNrofBytes();
            int n3 = n = nArray.length == 0 || nArray[0] < 0 ? this.bytePos : this.bytePos + nArray[0] * n2;
            if (n > ByteDataSymbolicAccess.this.data.length - n2) {
                throw new IllegalArgumentException("file to short: " + ByteDataSymbolicAccess.this.data.length + ", requested: " + n + n2);
            }
            switch (this.typeChar) {
                case 'D': {
                    f = (float)ByteDataSymbolicAccess.this.dataAccess.getDoubleVal(n);
                    break;
                }
                case 'F': {
                    f = ByteDataSymbolicAccess.this.dataAccess.getFloatVal(n);
                    break;
                }
                case 'B': 
                case 'I': 
                case 'J': 
                case 'S': {
                    f = ByteDataSymbolicAccess.this.dataAccess.getIntVal(n, -n2);
                    break;
                }
                default: {
                    new IllegalArgumentException("fault type, expected: float, found: " + this.typeChar);
                }
            }
            return f;
        }

        @Override
        public float setFloat(float f, int ... nArray) {
            int n;
            int n2 = this.getNrofBytes();
            int n3 = n = nArray.length == 0 || nArray[0] < 0 ? this.bytePos : this.bytePos + nArray[0] * n2;
            if (n > ByteDataSymbolicAccess.this.data.length - n2) {
                throw new IllegalArgumentException("file to short: " + ByteDataSymbolicAccess.this.data.length + ", requested: " + n + n2);
            }
            switch (this.typeChar) {
                case 'D': {
                    ByteDataSymbolicAccess.this.dataAccess.setDoubleVal(n, f);
                    break;
                }
                case 'F': {
                    ByteDataSymbolicAccess.this.dataAccess.setFloatVal(n, f);
                    break;
                }
                case 'B': 
                case 'I': 
                case 'J': 
                case 'S': {
                    ByteDataSymbolicAccess.this.dataAccess.setIntVal(n, n2, (int)f);
                    break;
                }
                default: {
                    new IllegalArgumentException("fault type, expected: float, found: " + this.typeChar);
                }
            }
            return f;
        }

        @Override
        public double getDouble(int ... nArray) {
            int n;
            double d = 0.0;
            int n2 = this.getNrofBytes();
            int n3 = n = nArray.length == 0 || nArray[0] < 0 ? this.bytePos : this.bytePos + nArray[0] * n2;
            if (n > ByteDataSymbolicAccess.this.data.length - n2) {
                throw new IllegalArgumentException("file to short: " + ByteDataSymbolicAccess.this.data.length + ", requested: " + n + n2);
            }
            switch (this.typeChar) {
                case 'D': {
                    d = ByteDataSymbolicAccess.this.dataAccess.getDoubleVal(n);
                    break;
                }
                case 'F': {
                    d = ByteDataSymbolicAccess.this.dataAccess.getFloatVal(n);
                    break;
                }
                case 'B': 
                case 'I': 
                case 'J': 
                case 'S': {
                    d = ByteDataSymbolicAccess.this.dataAccess.getIntVal(n, -n2);
                    break;
                }
                default: {
                    new IllegalArgumentException("fault type, expected: float, found: " + this.typeChar);
                }
            }
            return d;
        }

        @Override
        public double setDouble(double d, int ... nArray) {
            return d;
        }

        private int getNrofBytes() {
            int n = 0;
            switch (this.typeChar) {
                case 'D': {
                    n = 8;
                    break;
                }
                case 'F': {
                    n = 4;
                    break;
                }
                case 'J': {
                    n = 8;
                    break;
                }
                case 'I': {
                    n = 4;
                    break;
                }
                case 'S': {
                    n = 2;
                    break;
                }
                case 'B': {
                    n = 1;
                }
            }
            return n;
        }

        @Override
        public void requestValue(long l) {
            ByteDataSymbolicAccess.this.timeRequestNewValue = l;
        }

        @Override
        public void requestValue() {
            this.requestValue(System.currentTimeMillis());
        }

        @Override
        public void requestValue(long l, Runnable runnable) {
            ByteDataSymbolicAccess.this.timeRequestNewValue = l;
            int n = 10;
            while (ByteDataSymbolicAccess.this.runOnRecv.remove(runnable)) {
                if (--n >= 0) continue;
                throw new IllegalArgumentExceptionJc("ByteDataSymbolicAccess - requestValue catastrophicalCount", runnable.hashCode());
            }
            boolean bl = ByteDataSymbolicAccess.this.runOnRecv.offer(runnable);
            if (!bl) {
                throw new IllegalArgumentExceptionJc("ByteDataSymbolicAccess - requestValue run cannot be added", runnable.hashCode());
            }
        }

        @Override
        public boolean isRequestedValue(long l, boolean bl) {
            if (ByteDataSymbolicAccess.this.timeRequestNewValue == 0L) {
                return false;
            }
            long l2 = ByteDataSymbolicAccess.this.timeRequestNewValue - ByteDataSymbolicAccess.this.timeSetNewValue;
            long l3 = ByteDataSymbolicAccess.this.timeRequestNewValue - l;
            return (ByteDataSymbolicAccess.this.timeSetNewValue == 0L || l2 >= 0L) && l3 >= 0L;
        }

        @Override
        public boolean isRefreshed() {
            return ByteDataSymbolicAccess.this.timeSetNewValue - ByteDataSymbolicAccess.this.timeRequestNewValue > 0L;
        }

        @Override
        public long getLastRefreshTime() {
            return ByteDataSymbolicAccess.this.timeSetNewValue;
        }

        @Override
        public void setRefreshed(long l) {
            ByteDataSymbolicAccess.this.timeSetNewValue = l;
        }

        @Override
        public double getDouble() {
            return this.getDouble(0);
        }

        @Override
        public float getFloat() {
            return this.getFloat(0);
        }

        @Override
        public int getInt() {
            return this.getInt(0);
        }

        @Override
        public long getLong() {
            return this.getLong(0);
        }

        @Override
        public String getString() {
            return this.getString(0);
        }

        @Override
        public double setDouble(double d) {
            return this.setDouble(d, 0);
        }

        @Override
        public float setFloat(float f) {
            return this.setFloat(f, 0);
        }

        @Override
        public int setInt(int n) {
            return this.setInt(n, 0);
        }

        @Override
        public long setLong(long l) {
            return this.setLong(l, 0);
        }

        @Override
        public String setString(String string) {
            return this.setString(string, 0);
        }
    }
}

