<?xml version="1.0" encoding="ISO-8859-1" ?>
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0"
  xmlns:xs="XSL"
>
<!-- conversion of a ZBNF-parsed DocuCtrl-File to an ANT.xml-File -->
<!-- made by Hartmut Schorrig

 2009-06-09 HScho corr: copy.special.xsl should execute first, because it contains some xslp-preparations.
 2009-01-08 HScho new: xsl:template match="document": html-output depends on docuGctr, the generating script.
                  corr: variable name="dependsOnTools" select="'true'"
                  rem: The conditions of generating are changes volatile, and a new generation process should be start than.



-->
<xsl:import href="../../xsl/gen/ZmakeStd.xsl" />

<xsl:output method="xml" encoding="ISO-8859-1"/>
<xsl:param name="ctrl" select="'?'" /><!-- it is a control parameter from outside. -->

<xsl:variable name="dependsOnTools" select="'true'" />


<xsl:template match= "/">
  <xsl:comment> Generated by DocuGenCtrl2Ant.xslp </xsl:comment>
  <xsl:text>

  </xsl:text>

  <project name="DocuGen" default="DocuGen" basedir=".">

  <property environment="env" />

  <!-- property name="tmp" value="../tmp" / -->
  <property name="tmp" value="{'${'}env.TMP_ZBNFJAX{'}'}" />
  <!--since 2009-12-10 test: if the tmp have to be an absolute path, use tmpAbs.
      Another solution, yet used: set the TMP_ZBNFJAX absolute always.
    -->
  <property name="tmpAbs" value="{'${'}env.TMP_ZBNFJAX{'}'}" />

  <import file="{'${'}env.ZBNFJAX_HOME{'}'}/XmlDocu_xsl/DocuGenStd.ant.xml"/>

  <!-- the common ANT-target of document generation depends on all documents, but does nothing else. -->
  <xsl:variable name="allTargets">
    <xsl:text>copy.special.xsl,</xsl:text><!-- copy of standard xsl-scripts -->
    <!-- NOTE xsl: first depends from all target, than documents, because the targets should be translated before. -->
    <xsl:for-each select="GenCtrl/target">
      <xsl:text></xsl:text><xsl:call-template name="targetName"></xsl:call-template><xsl:text>,</xsl:text>
    </xsl:for-each>
    <xsl:if test="GenCtrl/hrefCtrl" >hrefAssociations2Xml, </xsl:if><!-- generate href...xml to use for CorrectHref -->
    <xsl:for-each select="GenCtrl/document">
      <xsl:text></xsl:text><xsl:value-of select="@ident" /><xsl:text>.html,</xsl:text>
    </xsl:for-each>
    <xsl:text>__dummyTarget__</xsl:text>
  </xsl:variable>
  <target name="DocuGen" description="DocuGenCtr2Ant.xslp:The whole documentation of this folder" depends="{$allTargets}" />



  <!-- generating ANT-targets for all found documents: -->
  <xsl:apply-templates select="GenCtrl/document" />

  <!-- generating ANT-targets for all found preparing statements, in src  prepXml: , in ZBNF prepXml::= -->
  <xsl:apply-templates select="GenCtrl/prepXml" />

  <xsl:for-each select="GenCtrl/target">
    <xsl:variable name="targetfile"><xsl:for-each select="output"><xsl:call-template name="absPathfile" /></xsl:for-each></xsl:variable>
    <!-- targets without isUptodate and wiht special target frame: -->
    <xsl:choose><xsl:when test="@translator='TextTopic2Xml'"><xsl:call-template name="TextTopic2Xml"/>
    </xsl:when><xsl:when test="@translator='StateMachine2Xml'"><xsl:call-template name="StateMachine2Xml"/>
    </xsl:when><xsl:otherwise>
      <xsl:call-template name="genTarget_ZmakeStd" />
    </xsl:otherwise></xsl:choose>
  </xsl:for-each>



  <!-- convert all import.xslp to import.xsl, store it in the tmp directory: -->
  <xsl:for-each select="GenCtrl/import[@type='.xslp']">
    <xsl:variable name="inputfile"><xsl:text>${env.ZBNFJAX_HOME}/</xsl:text><xsl:value-of select="@dir" /><xsl:text></xsl:text><xsl:choose><xsl:when test="boolean(@dir)"><xsl:text>/</xsl:text></xsl:when></xsl:choose><xsl:text></xsl:text><xsl:value-of select="@href" /><xsl:text>.xslp</xsl:text></xsl:variable>
    <target name="{@href}.xslp" depends="isUptodate_{@href}.xslp" unless="isUptodate_{@href}.xslp" description="DocuGenCtr2Ant.xslp:import">
    <xsl:comment><xsl:text>convert import: </xsl:text><xsl:value-of select="@href" /><xsl:text>.xslp to {'${'}tmp{'}'}/</xsl:text><xsl:value-of select="@href" /><xsl:text>.xsl. </xsl:text></xsl:comment>
      <echo message="use and Xsltpre: {$inputfile}" />
      <exec dir="{'${'}curDir{'}'}" executable= "java" failonerror="true">
        <arg line ="-cp {'${'}env.JAVACP_XSLT{'}'} org.vishia.xmlSimple.Xsltpre" />
        <arg line ="--report:{'${'}tmp{'}'}/xsltpre.rpt --rlevel:324 " />
        <arg line ="-i{$inputfile} -o{'${'}tmp{'}'}/{@href}.xsl"/>
      </exec>
    </target>
    <target name="isUptodate_{@href}.xslp" description="DocuGenCtr2Ant.xslp:import_isUptodate">
      <uptodate property="isUptodate_{@href}.xslp" targetfile="{'${'}tmp{'}'}/{@href}.xsl" >
        <xsl:variable name="srcfile"><xsl:text>${env.ZBNFJAX_HOME}/</xsl:text><xsl:value-of select="@dir" /><xsl:text></xsl:text><xsl:choose><xsl:when test="boolean(@dir)"><xsl:text>/</xsl:text></xsl:when></xsl:choose><xsl:text></xsl:text><xsl:value-of select="@href" /><xsl:text>.xslp</xsl:text></xsl:variable>
        <srcfiles file="{$srcfile}" />
      </uptodate>
    </target>
  </xsl:for-each>


  <xsl:text>





</xsl:text>
  <xsl:variable name="importDepends">
    <xsl:for-each select="GenCtrl/import[@type='.xslp']">
      <xsl:text></xsl:text><xsl:value-of select="@href" /><xsl:text>.xslp,</xsl:text>
    </xsl:for-each>
      <xsl:text>dummyTarget</xsl:text><!-- only because the last , is fault. -->
  </xsl:variable>
  <xsl:comment>
              NOTE: the depends targets are conversions from xslp with Xsltpre, they copies there content into tmp.
              The content was produces from the import block of textual GenCtrl. All this files are imported
              in every generateted "docuGenCtrl.xsl" to produce XhtmlPre. They are the "special.xsl"-Files.
              Because the generated "docuGenCtrl.xsl" is placed in the tmp directory, the imports may also placed there.
  </xsl:comment>
  <target name="copy.special.xsl" depends="{$importDepends}" description="DocuGenCtr2Ant.xslp:copy.special.xsl">
    <echo message="copy *.xsl" />
    <copy todir="{'${tmpAbs}'}" >
      <xsl:for-each select="GenCtrl/import[@type='.xsl']">
          <fileset dir="{'${'}env.ZBNFJAX_HOME{'}'}/{@dir}" includes="{@href}.xsl" />
      </xsl:for-each>
    </copy>
  </target>


  <target name="__dummyTarget__" >
  </target>




  <target name="hrefAssociations2Xml" depends="isUptodate_hrefAssociations2Xml" unless="isUptodate_hrefAssociations2Xml" description="DocuGenCtr2Ant.xslp:hrefAssociation">
    <echo message="hrefAssociations2Xml" />
    <exec dir="{$curDir}" executable= "java" failonerror="true">
      <arg line ="-cp {'${'}env.JAVACP_ZBNF{'}'} org.vishia.zbnf.Zbnf2Xml" />
      <arg line ="--rlevel:334 --report:{'${tmp}'}/hrefAssociations2Xml.rpt"/>
      <arg line ="-i:{'${'}curDir{'}'}/{GenCtrl/hrefCtrl/@path}{GenCtrl/hrefCtrl/@file}{GenCtrl/hrefCtrl/@ext} -s:{'${'}env.ZBNFJAX_HOME{'}'}/XmlDocu_xsl/DocuGenCtrl.zbnf -x:{'${tmp}'}/{GenCtrl/hrefCtrl/@file}.xml"/>
    </exec>
  </target>
  <target name="isUptodate_hrefAssociations2Xml" description="DocuGenCtr2Ant.xslp:isuptodateHrefAss">
    <uptodate property="isUptodate_hrefAssociations2Xml" targetfile="{'${tmp}'}/{GenCtrl/hrefCtrl/@file}.xml">
      <srcfiles file="{'${curDir}'}/{GenCtrl/hrefCtrl/@path}{GenCtrl/hrefCtrl/@file}{GenCtrl/hrefCtrl/@ext}" />
    </uptodate>
  </target>



  <target name="dummyTarget">
  </target>



  <xsl:call-template name="genXsltpreStandardTargets" />

  <target name="ZmakeDummy"></target>

</project>

</xsl:template>






<xsl:template match="document">
  <xsl:text>
  </xsl:text>
  <xsl:comment>********************************************************************************************* </xsl:comment>
  <xsl:text>
  </xsl:text>
  <xsl:comment><xsl:text>Generate the output document. It is html, it may be other outputs, see using $ctrl ="</xsl:text><xsl:value-of select="$ctrl" /><xsl:text>" </xsl:text></xsl:comment>
  <xsl:text>
  </xsl:text>

  <target name="{@ident}.html" depends="isUptodate_{@ident}.html" unless="isUptodate_{@ident}.html" description="DocuGenCtr2Ant.xslp:Document.html">
    <echo message="generating HTML" />
        <antcall target="gen_{@ident}.html" />
  </target>

  <xsl:variable name="outHtml">
    <xsl:choose><xsl:when test="outHtml">
      <xsl:for-each select="outHtml" >
        <!-- prevent ${curdir} therefore srcpath is empty -->
        <xsl:call-template name="absPathfile" ><xsl:with-param name="srcpath" select="''"/></xsl:call-template>
      </xsl:for-each>
    </xsl:when><xsl:otherwise><xsl:text>../html/</xsl:text><xsl:value-of select="@ident" /><xsl:text>.html</xsl:text>
    </xsl:otherwise></xsl:choose>
  </xsl:variable>
  <xsl:variable name="outHtmlPath">
    <xsl:choose><xsl:when test="outHtml"><xsl:for-each select="outHtml" ><xsl:call-template name="pathPre" /></xsl:for-each>
    </xsl:when><xsl:otherwise><xsl:text>../html</xsl:text>
    </xsl:otherwise></xsl:choose>
  </xsl:variable>
  <!-- gen target to generate isUptodate -->

  <target name="isUptodate_{@ident}.html" description="DocuGenCtr2Ant.xslp:isUptodateHtml">
          <uptodate property="isUptodate_{@ident}.html" targetfile="${'{'}curDir{'}'}/{$outHtml}">
      <srcfiles file="{'${'}curDir{'}'}/{/GenCtrl/@file}" /> <xsl:comment> The NAME.genctrl file itself </xsl:comment>
  <xsl:for-each select="input">
    <!-- isUptodate: all input files are sources to test.
         Algorithm: It is possible to specify either the output file of a prepXml-Block,
         the or ones of the input files of a prepXml-Block, or a file immediately.
         If the output file of prepXml is specified, all of the input files are sources.
         If an input file of prepXml is specified without path, the path is taken from prepXml Block,
         in the otherwise case the file is a immediate source.
         To test this cases, 2 variables are filled with a node set reference.
         If one of this variables are valid, its the choice.
     -->
    <xsl:variable name="input" select="@inputfile" /><!-- ##a -->
    <xsl:variable name="PrepXmlNodeOutput" select="/GenCtrl/prepXml[@outputfile=$input]" />
    <xsl:variable name="PrepXmlNodeInput" select="/GenCtrl/prepXml/input[@file=$input]" />
    <xsl:choose>

      <xsl:when test="boolean($PrepXmlNodeOutput)">
        <!-- an output file of prepXml is given, test as isuptodate-src all its inputs: -->
        <xsl:for-each select="$PrepXmlNodeOutput/input">
      <srcfiles file="{'${'}curDir{'}'}/{@path}{@file}" /><xsl:comment> input of {$PrepXmlNodeOutput/@outputfile} </xsl:comment>
        </xsl:for-each>
      </xsl:when>

      <xsl:when test="boolean($PrepXmlNodeInput)">
        <!-- an input file of prepXml without path is given, test as isuptodate-src with its path: -->
        <xsl:for-each select="$PrepXmlNodeInput[1]">
            <srcfiles file="{'${'}curDir{'}'}/{@path}{@file}" /><xsl:comment> converted to {../@outputfile} </xsl:comment><!-- The inputfile direct as dependenced -->
        </xsl:for-each>
      </xsl:when>

      <xsl:otherwise>
        <srcfiles file="{'${'}curDir{'}'}/{@inputfile}" /><xsl:comment> The inputfile direct as dependenced </xsl:comment>
      </xsl:otherwise>

    </xsl:choose>
  </xsl:for-each>
  <xsl:if test="$dependsOnTools='true'">
    <xsl:for-each select="/GenCtrl/import">
      <!-- dependency from special.xsl (tool) -->
      <xsl:variable name="dependsToolSrc"><xsl:text>${env.ZBNFJAX_HOME}/</xsl:text><xsl:value-of select="@dir" /><xsl:text></xsl:text><xsl:choose><xsl:when test="boolean(@dir)"><xsl:text>/</xsl:text></xsl:when></xsl:choose><xsl:text></xsl:text><xsl:value-of select="@href" /><xsl:text></xsl:text><xsl:value-of select="@type" /><xsl:text></xsl:text></xsl:variable>
      <srcfiles file="{$dependsToolSrc}" />
    </xsl:for-each>
    <srcfiles file="{'${'}env.ZBNFJAX_HOME{'}'}/XmlDocu_xsl/DocuGenCtrl2Xsl.xslp" />
    <srcfiles file="{'${'}env.ZBNFJAX_HOME{'}'}/XmlDocu_xsl/TopicXhtml.xsl" />
    <srcfiles file="{'${'}env.ZBNFJAX_HOME{'}'}/XmlDocu_xsl/Pre2Xhtml.xsl" />
    <srcfiles file="{'${'}env.ZBNFJAX_HOME{'}'}/XmlDocu_xsl/Pre2Word.xsl" />
    <srcfiles file="{'${'}env.ZBNFJAX_HOME{'}'}/zbnf/Cheader.zbnf" />
  </xsl:if>
          </uptodate>
  </target>

  <!-- gen target to generate html -->
  <target name="gen_{@ident}.html" depends="{@ident}.pre.xml" description="DocuGenCtr2Ant.xslp:gen_Document.html">
    <mkdir dir="{$outHtmlPath}" />
    <echo message="prepareHtmlOutput" />
    <!-- Generate HTML output-->
    <exec dir="{'${'}curDir{'}'}" executable= "java" failonerror="true">
      <arg line ="-cp {'${'}env.JAVACP_XSLT{'}'} org.vishia.xml.Xslt" />
            <arg line="-k{'${'}tmp{'}'}/{@ident}.pre.xml" />
            <!-- arg line="-i{'${'}env.ZBNFJAX_HOME{'}'}/XmlDocu_xsl/HtmlFormatStd.xml" / -->
            <arg line="-t{'${'}env.ZBNFJAX_HOME{'}'}/XmlDocu_xsl/Pre2Xhtml.xsl" />
            <arg line="-w+ -y:{$outHtml}" />
            <arg line="--report:{'${'}tmp{'}'}/{@ident}.html.rpt --rlevel:334" />
      <xsl:if test="cssHtml">
        <arg line="cssHtml={cssHtml}" />
      </xsl:if>
           </exec>
    <xsl:if test="not(cssHtml)">
      <copy file="{'${'}env.ZBNFJAX_HOME{'}'}/XmlDocu_xsl/htmlstd.css" tofile="{$outHtmlPath}/htmlstd.css"/>
    </xsl:if>
    <!-- Generate WORD output-->
    <xsl:if test="not(outHtml) or outWord">
      <mkdir dir="{$outHtmlPath}/../word" />
      <exec dir="{'${'}curDir{'}'}" executable= "java" failonerror="true">
        <arg line ="-cp {'${'}env.JAVACP_XSLT{'}'} org.vishia.xml.Xslt" />
        <arg line="-k{'${'}tmp{'}'}/{@ident}.pre.xml" />
        <arg line="-i{'${'}env.ZBNFJAX_HOME{'}'}/XmlDocu_xsl/WordFormatStd.xml" />
        <arg line="-t{'${'}env.ZBNFJAX_HOME{'}'}/XmlDocu_xsl/Pre2Word.xsl" />
        <arg line="-w- -y{$outHtmlPath}/../word/{@ident}.word.xml" />
        <arg line="--report:{'${'}tmp{'}'}/{@ident}.word.rpt --rlevel:334" />
      </exec>
    </xsl:if>
  </target>


  <xsl:comment><xsl:text>
       produce the XhtmlPre File </xsl:text><xsl:value-of select="@ident" /><xsl:text>.pre.xml.
       It is a 3-level-conversion:
       * 1.: Convert the common genctrl file </xsl:text><xsl:value-of select="/GenCtrl/@file" /><xsl:text>.xml to the specific </xsl:text><xsl:value-of select="@ident" /><xsl:text>.genctrl.xsl File, selecting the parametrized document </xsl:text><xsl:value-of select="@ident" /><xsl:text>.
       * 2.: The big XSL-Translation to </xsl:text><xsl:value-of select="@ident" /><xsl:text>.pre1.xml using some inputs and the xsl-file from 1.
       * 3.: CorrectHref, using </xsl:text><xsl:value-of select="/GenCtrl/@file" /><xsl:text>.xml for HyperlinkAssociations, output is </xsl:text><xsl:value-of select="@ident" /><xsl:text>.pre.xml.
       </xsl:text>
   </xsl:comment>
  <xsl:variable name="dependsInputPre">
    <xsl:for-each select="input"><!-- depends on all conversions of inputfiles -->
      <xsl:variable name="input" select="@inputfile" /><!-- ##a -->
      <xsl:for-each select="/GenCtrl/prepXml[@outputfile=$input]">
        <!-- the outputfile is given, it is the dependend target. -->
        <xsl:value-of select="$input" /><xsl:text>, </xsl:text>
      </xsl:for-each>
      <xsl:for-each select="/GenCtrl/prepXml/input[@file=$input]">
        <xsl:choose><xsl:when test="boolean(../@outputfile)"><xsl:value-of select="../@outputfile" /><xsl:text>, </xsl:text>
        </xsl:when><xsl:otherwise><xsl:value-of select="$input" /><xsl:text>.xml, </xsl:text>
        </xsl:otherwise></xsl:choose>
      </xsl:for-each>
    </xsl:for-each>
    <xsl:text>DocuGenCtrl2Xsl.xsl,copy.special.xsl,isUptodate_</xsl:text><xsl:value-of select="@ident" /><xsl:text>.pre.xml</xsl:text>
  </xsl:variable>

  <target name="{@ident}.pre.xml"
    depends="{$dependsInputPre}" unless="isUptodate_{@ident}.pre.xml" description="DocuGenCtr2Ant.xslp:pre.xml">
    <xsl:comment> Generate the XSL translation file for this document: </xsl:comment>
  <!-- exec dir="{'${'}curDir{'}'}" executable= "cmd.exe" failonerror="true">
      <arg line ="/c {'${'}env.ZBNFJAX_HOME{'}'}\xt.exe {'${'}tmp{'}'}/</xsl:text><xsl:value-of select="/GenCtrl/@file" /><xsl:text>.xml {'${'}env.ZBNFJAX_HOME{'}'}/XmlDocu_xsl/gen/DocuGenCtrl2Xsl.xsl {'${'}tmp{'}'}/</xsl:text><xsl:value-of select="@ident" /><xsl:text>.genctrl.xsl document=</xsl:text><xsl:value-of select="@ident" /><xsl:text>"/>
    </exec -->
  <xsl:text>
      </xsl:text>
  <exec dir="{'${'}curDir{'}'}" executable= "java" failonerror="true">
      <arg line ="-cp {'${'}env.JAVACP_XSLT{'}'} net.sf.saxon.Transform" />
      <arg line ="-o {'${'}tmp{'}'}/{@ident}.genctrl.xsl" />
      <arg line ="{'${'}tmp{'}'}/{/GenCtrl/@file}.xml"/>
      <arg line ="{'${'}env.ZBNFJAX_HOME{'}'}/XmlDocu_xsl/gen/DocuGenCtrl2Xsl.xsl"/>
      <arg line ="document={@ident}"/>
    </exec>

    <xsl:comment> Generate the pre1.xml output: </xsl:comment>
    <xsl:text>
      </xsl:text>
    <exec dir="{'${'}curDir{'}'}" executable= "java" failonerror="true">
      <arg line ="-cp {'${'}env.JAVACP_XSLT{'}'} org.vishia.xml.Xslt" />
  <xsl:variable name="Inputs">
    <!-- inputs of conversion to pre.xml, consider all input files:
         Algorithm: It is possible to specify either the output file of a prepXml-Block,
         the or ones of the input files of a prepXml-Block, or a file immediately.
         If the output file of prepXml is specified, it is the input for conversion. That is simple.
         If an input file of prepXml is specified, the appropriate output file is the input for conversion.
         Otherwise the specified file is a immediate source.

         The problem thereby is, an input for conversion may be kept more as one,
         because more as one specified input file can determine the same output of prepXml as input for conversion.
         Thats why the files are collected in this variable Inputs,
         than sorted in InputsSort, and at least evaluate for input of conversion.

         To test the cases of specified the input, 2 variables inside are filled with a node set reference.
         If one of this variables are valid, its the choice.
     -->
    <xsl:for-each select="input">
      <xsl:variable name="input" select="@inputfile" /><!-- ##a -->
      <xsl:variable name="PrepXmlNodeOutput" select="/GenCtrl/prepXml[@outputfile=$input]" />
      <xsl:variable name="PrepXmlNodeInput" select="/GenCtrl/prepXml/input[@file=$input]" />
      <xsl:choose>

        <xsl:when test="boolean($PrepXmlNodeOutput)">
          <!-- an output file of prepXml is given, its the input for conversion. -->
          <xsl:variable name="AttrInput"><xsl:text>${tmp}/</xsl:text><xsl:value-of select="$PrepXmlNodeOutput/@outputfile" /><xsl:text></xsl:text></xsl:variable>
          <input file="{$AttrInput}" comment="output after PrepXml direct"/>
        </xsl:when>

        <xsl:when test="boolean($PrepXmlNodeInput)">
          <!-- an input file of prepXml without path is given, the appropriate output file is input for conversion: -->
          <xsl:variable name="Outputfile">
            <xsl:choose><xsl:when test="boolean($PrepXmlNodeInput/../@outputfile)"><xsl:value-of select="$PrepXmlNodeInput/../@outputfile" />
            </xsl:when><xsl:otherwise><xsl:value-of select="$PrepXmlNodeInput/@file" /><xsl:text>.xml</xsl:text>
            </xsl:otherwise></xsl:choose>
          </xsl:variable>
          <xsl:variable name="Comment"><xsl:text>from </xsl:text><xsl:value-of select="$PrepXmlNodeInput/@file" /><xsl:text></xsl:text></xsl:variable>
          <xsl:variable name="AttrInput"><xsl:text>${tmp}/</xsl:text><xsl:value-of select="$Outputfile" /><xsl:text></xsl:text></xsl:variable>
          <input file="{$AttrInput}" comment="{$Comment}" />
        </xsl:when>

        <xsl:otherwise>
          <xsl:variable name="AttrInput"><xsl:text>${curDir}/</xsl:text><xsl:value-of select="$input" /><xsl:text></xsl:text></xsl:variable>
          <input file="{$AttrInput}" comment="input direct" />
        </xsl:otherwise>

      </xsl:choose>
    </xsl:for-each>
  </xsl:variable>
  <xsl:variable name="InputsSort">
    <xsl:for-each select="$Inputs/input">
    <xsl:sort select="@file" />
      <input file="{@file}" comment="{@comment}" />
    </xsl:for-each>
  </xsl:variable>
  <xsl:for-each select="$InputsSort/input[position()=last() or @file != following-sibling::*[1]/@file]">
  <!-- xsl:for-each select="$InputsSort/input" -->
    <arg line ="-i{@file}" /><xsl:comment><xsl:text> </xsl:text><xsl:value-of select="@comment" /><xsl:text> </xsl:text></xsl:comment>
  </xsl:for-each>
            <arg line ="-i{'${'}tmp{'}'}/{/GenCtrl/@file}.xml" />
      <xsl:comment> the genctrl.xml of this document is also as input available </xsl:comment>
            <xsl:text>
      </xsl:text>
      <arg line ="-t{'${'}tmp{'}'}/{@ident}.genctrl.xsl" />
            <arg line ="-w+ -y{'${'}tmp{'}'}/{@ident}.pre1.xml" />
            <arg line ="--report:{'${'}tmp{'}'}/{@ident}.pre1.rpt --rlevel:334"/>
           </exec>
    <xsl:comment> Generate the pre.xml output after CorrectHref: </xsl:comment>
    <exec dir="{'${'}curDir{'}'}" executable="java" failonerror="true">
      <arg line ="-cp {'${'}env.JAVACP_XSLT{'}'} org.vishia.xml.docuGen.CorrectHref" />
            <arg line ="-i{'${'}tmp{'}'}/{@ident}.pre1.xml" />
            <xsl:choose><xsl:when test="/GenCtrl/hrefCtrl">
        <arg line ="-c{'${'}tmp{'}'}/{/GenCtrl/hrefCtrl/@file}.xml" />
      </xsl:when><xsl:otherwise>
      </xsl:otherwise></xsl:choose>
      <arg line ="-c{'${'}tmp{'}'}/{/GenCtrl/@file}.xml" /><!--since 2009-1211 use own file always, it may contain local HyperlinkAssociation-->
      <arg line ="-o:{$outHtml}" />
      <arg line ="-d:{@ident}" />
      <xsl:for-each select="inputCrossRef">
        <xsl:text>
        </xsl:text>
        <arg line ="-e{@inputfile}" />
      </xsl:for-each>
      <xsl:if test="boolean(xslCrossRef)">
        <xsl:text>
        </xsl:text>
        <arg line ="-t{'${'}tmp{'}'}/{xslCrossRef/@href}.xsl" />
      </xsl:if>
            <xsl:text>
      </xsl:text>
      <arg line ="-y{'${'}tmp{'}'}/{@ident}.pre.xml" />
            <arg line ="--report:{'${'}tmp{'}'}/{@ident}.CorrectHref.rpt --rlevel:334"/>
           </exec>
  </target>
  <target name="isUptodate_{@ident}.pre.xml"  description="DocuGenCtl2Ant: isUptodate_...pre.xml">
          <uptodate property="isUptodate_{@ident}.pre.xml" targetfile="{'${'}tmpAbs{'}'}/{@ident}.pre.xml">
      <srcfiles file="{'${'}curDir{'}'}/{/GenCtrl/@file}" />
  <xsl:for-each select="input">
      <srcfiles file="{'${'}curDir{'}'}/{@inputpath}{@inputfile}" />
  </xsl:for-each>
  <xsl:for-each select="/GenCtrl/import">
      <srcfiles file="{'${'}tmp{'}'}/{@href}.xsl" />
  </xsl:for-each>
      <srcfiles file="{'${'}env.ZBNFJAX_HOME{'}'}/XmlDocu_xsl/DocuGenCtrl2Xsl.xslp" />
            <srcfiles file="{'${'}env.ZBNFJAX_HOME{'}'}/XmlDocu_xsl/TopicXhtml.xsl" />
            <srcfiles file="{'${'}env.ZBNFJAX_HOME{'}'}/XmlDocu_xsl/Pre2Xhtml.xsl" />
            <srcfiles file="{'${'}env.ZBNFJAX_HOME{'}'}/zbnf/Cheader.zbnf" />
          </uptodate>
  </target>




</xsl:template>



<!-- This template translates a Zmake-expression like

     target: tmp/*.xml := TextTopic2Xml(file1.topic, file2.topic);

     in some targets to translate the individually files from xslp via Xsltpre.java to xsl.
     a common target is build with the depends of all some xslp-translating targets.
 -->
<xsl:template name="TextTopic2Xml">
  <xsl:comment>Generated with ZmakeStd.xslp: TextTopic2Xml calling genExecForEachInput: exec_TextTopic2Xml </xsl:comment>
  <xsl:call-template name="genTargetForEachInput">
    <xsl:with-param name="genExecForEachInput" select="'exec_TextTopic2Xml'" />
  </xsl:call-template>
</xsl:template>

<xsl:template name="exec_TextTopic2Xml"><!-- this template will be called inside for each inputfile. -->
<xsl:param name="targetfile" />
<xsl:param name="srcfile" />
<xsl:param name="xmlInputNode" />
<xsl:param name="xmlTargetNode" />
  <!-- the srcfile without extension .h -->
  <xsl:comment>Generated with ZmakeStd.xslp: exec_TextTopic2Xml </xsl:comment>
  <echo message="{'TextTopic2Xml: '}{$targetfile}" />
  <exec dir="{$curDir}" executable= "java" failonerror="true">
    <arg line ="-cp {'${'}env.JAVACP_ZBNF{'}'} org.vishia.zbnf.Zbnf2Xml" />
    <arg line ="--rlevel:334 --report:{$targetfile}.rpt"/>
    <arg line ="-i:{$srcfile} -s:{'${'}env.ZBNFJAX_HOME{'}'}/XmlDocu_xsl/AsciiTopics.zbnf -x:{$targetfile}"/>
  </exec>
</xsl:template>



<!-- This template translates a Zmake-expression like

     target: tmp/*.xml := StateMachine2Xml(file1.stm, file2.stm);

     in some targets to translate the individually files from xslp via Xsltpre.java to xsl.
     a common target is build with the depends of all some xslp-translating targets.
 -->
<xsl:template name="StateMachine2Xml">
  <xsl:comment>Generated with ZmakeStd.xslp: StateMachine2Xml calling genExecForEachInput: exec_StateMachine2Xml </xsl:comment>
  <xsl:call-template name="genTargetForEachInput">
    <xsl:with-param name="genExecForEachInput" select="'exec_StateMachine2Xml'" />
  </xsl:call-template>
</xsl:template>

<xsl:template name="exec_StateMachine2Xml"><!-- this template will be called inside for each inputfile. -->
<xsl:param name="targetfile" />
<xsl:param name="srcfile" />
<xsl:param name="xmlInputNode" />
<xsl:param name="xmlTargetNode" />
  <!-- the srcfile without extension .h -->
  <xsl:comment>Generated with ZmakeStd.xslp: exec_StateMachine2Xml </xsl:comment>
  <echo message="{'StateMachine2Xml: '}{$targetfile}" />
  <exec dir="{$curDir}" executable= "java" failonerror="true">
    <arg line ="-cp {'${'}env.JAVACP_ZBNF{'}'} org.vishia.zbnf.Zbnf2Xml" />
    <arg line ="--rlevel:336 --report:{$targetfile}.rpt"/>
    <arg line ="-i:{$srcfile} -s:{'${'}env.ZBNFJAX_HOME{'}'}/XmlDocu_xsl/StateMachine.zbnf -x:{$targetfile}"/>
  </exec>
</xsl:template>





<xsl:template match="prepXml">
  <xsl:choose><xsl:when test="@translator='Header2Xml'"><xsl:call-template name="prepXml_Header2Xml" />
  </xsl:when><xsl:when test="@translator='Header2Xmi'"><xsl:call-template name="prepXml_Header2Xmi" />
  </xsl:when><xsl:when test="@translator='xmi2xml'"><xsl:call-template name="prepXml_xmi2xml" />
  </xsl:when><xsl:when test="@translator='TextTopic2Xml'"><xsl:call-template name="prepXml_TextTopic2Xml" />
  </xsl:when><xsl:otherwise><xsl:comment><xsl:text> unknown translator: </xsl:text><xsl:value-of select="@translator" /><xsl:text> </xsl:text></xsl:comment>
  </xsl:otherwise></xsl:choose>
</xsl:template>



<xsl:template name= "prepXml_TextTopic2Xml">
  <xsl:variable name="outputfile"><xsl:text></xsl:text><xsl:choose><xsl:when test="boolean(@outputfile)"><xsl:text></xsl:text><xsl:value-of select="@outputfile" /><xsl:text></xsl:text></xsl:when><xsl:otherwise><xsl:text></xsl:text><xsl:value-of select="input/@file" /><xsl:text>.xml</xsl:text></xsl:otherwise></xsl:choose><xsl:text></xsl:text></xsl:variable>

  <xsl:comment> ********************************************************************************************* </xsl:comment>

  <target name="{$outputfile}" depends="isUptodate_{$outputfile}" unless="isUptodate_{$outputfile}"  description="DocuGenCtr2Ant.xslp:TextTopictoXml">
    <echo message="conversion {input/@path}{input/@file}=&amp;gt;tmp/{$outputfile} (DocuGenCtrl2Ant.xsl-template:TextTopic2Xml), using Zbnf2Xml, zbnf/AsciiTopics.zbnf" />
    <exec dir="{'${'}curDir{'}'}" executable= "java" failonerror="true">
      <arg line ="-cp {'${'}env.JAVACP_ZBNF{'}'} org.vishia.zbnf.Zbnf2Xml" />
            <arg line ="--rlevel:334 --report:{'${'}tmp{'}'}/{$outputfile}.rpt"/>
            <arg line ="-i:{input/@path}{input/@file} -s:{'${'}env.ZBNFJAX_HOME{'}'}/XmlDocu_xsl/AsciiTopics.zbnf -x:{'${'}tmp{'}'}/{$outputfile}"/>
           </exec>
  </target>
  <target name="isUptodate_{$outputfile}"  description="DocuGenCtr2Ant.xslp:prepXmlTextTopicIsUptodate">
          <uptodate property="isUptodate_{$outputfile}" targetfile="{'${'}tmp{'}'}/{$outputfile}">
            <srcfiles file="{'${'}curDir{'}'}/{input/@path}{input/@file}" />
            <srcfiles file="{'${'}env.ZBNFJAX_HOME{'}'}/XmlDocu_xsl/AsciiTopics.zbnf" />
          </uptodate>
  </target>

</xsl:template>


<xsl:template name= "prepXml_Header2Xml">
  <xsl:variable name="Outputfile"><xsl:text></xsl:text><xsl:choose><xsl:when test="boolean(@outputfile)"><xsl:text></xsl:text><xsl:value-of select="@outputfile" /><xsl:text></xsl:text></xsl:when><xsl:otherwise><xsl:text></xsl:text><xsl:value-of select="input/@file" /><xsl:text>.xml</xsl:text></xsl:otherwise></xsl:choose><xsl:text></xsl:text></xsl:variable>
  <xsl:comment> ********************************************************************************************* </xsl:comment>
  <xsl:comment> Some Headerfiles: </xsl:comment>

  <target name="{$Outputfile}" depends="isUptodate_{$Outputfile}" unless="isUptodate_{$Outputfile}"  description="DocuGenCtr2Ant.xslp:Header2Xml">
    <xsl:variable name="message"><xsl:text>parsing Header </xsl:text><xsl:value-of select="@inputpath" /><xsl:text></xsl:text><xsl:value-of select="@inputfile" /><xsl:text>=&amp;gt;tmp/</xsl:text><xsl:value-of select="$Outputfile" /><xsl:text> (DocuGenCtrl2Ant.xsl-template:Header2Xml), using Zbnf2Xml, zbnf/Cheader.zbnf</xsl:text></xsl:variable>
    <echo message="{$message}" />
    <exec dir="{'${'}curDir{'}'}" executable= "java" failonerror="true">
            <arg line ="-cp {'${'}env.JAVACP_ZBNF{'}'} org.vishia.zbnf.Zbnf2Xml"/>
            <arg line ="--rlevel:334 --report:{'${'}tmp{'}'}/{$Outputfile}.rpt"/>
            <arg line ="-i:{@inputpath}{@inputfile}"/>
            <arg line ="-s:{'${'}env.ZBNFJAX_HOME{'}'}/zbnf/Cheader.zbnf"/>
            <arg line ="-x:{'${'}tmp{'}'}/{$Outputfile}"/>
           </exec>
  </target>
  <target name="isUptodate_{$Outputfile}"  description="DocuGenCtr2Ant.xslp:Header2XmlUptd">
          <uptodate property="isUptodate_{$Outputfile}" targetfile="{'${'}tmp{'}'}/{$Outputfile}">
    <xsl:for-each select="input">
            <srcfiles file="{'${'}curDir{'}'}/{@path}{@file}" />
    </xsl:for-each>
      <srcfiles file="{'${'}env.ZBNFJAX_HOME{'}'}/zbnf/Cheader.zbnf" />
            <srcfiles file="{'${'}env.ZBNFJAX_HOME{'}'}/XmlDocu_xsl/Header2Xmi.xslp" />
          </uptodate>
  </target>

</xsl:template>


<xsl:template name= "prepXml_Header2Xmi">
  <xsl:variable name="Outputfile"><xsl:text></xsl:text><xsl:choose><xsl:when test="boolean(@outputfile)"><xsl:text></xsl:text><xsl:value-of select="@outputfile" /><xsl:text></xsl:text></xsl:when><xsl:otherwise><xsl:text></xsl:text><xsl:value-of select="input/@file" /><xsl:text>.xmi</xsl:text></xsl:otherwise></xsl:choose><xsl:text></xsl:text></xsl:variable>
  <xsl:comment> ********************************************************************************************* </xsl:comment>
  <xsl:comment> Some Headerfiles collected and converted to XMI: </xsl:comment>
  <xsl:variable name="nameDependsIsUptodateOutput"><xsl:text>isUptodate_</xsl:text><xsl:value-of select="$Outputfile" /><xsl:text></xsl:text></xsl:variable>
  <xsl:variable name="dependsUptodateOutput">
    <xsl:value-of select="$nameDependsIsUptodateOutput" />
    <xsl:for-each select="input">
      <xsl:text>,</xsl:text><xsl:value-of select="$Outputfile" /><xsl:text>-</xsl:text><xsl:value-of select="@file" /><xsl:text></xsl:text>
    </xsl:for-each>
  </xsl:variable>
  <target name="{$Outputfile}" depends="{$dependsUptodateOutput}" unless="{$nameDependsIsUptodateOutput}"  description="DocuGenCtr2Ant.xslp:Header2Xmi">
    <echo message="...running HeaderXmlDissolveTypes.xsl" />
    <exec dir="{'${'}curDir{'}'}" executable= "java" failonerror="true">
      <arg line ="-cp {'${'}env.JAVACP_XSLT{'}'} org.vishia.xml.Xslt" />
  <xsl:for-each select="input">
            <arg line="-i{'${'}tmp{'}'}/{@file}.xml" /><xsl:comment> converted from ZBNF </xsl:comment>
  </xsl:for-each>
      <arg line="-t{'${'}env.ZBNFJAX_HOME{'}'}/xsl/HeaderXmlDissolveTypes.xsl" />
            <arg line="-w+ -y{'${'}tmp{'}'}/{$Outputfile}.types.xml" />
            <arg line="--report:{'${'}tmp{'}'}/{$Outputfile}.types.rpt --rlevel:333" />
           </exec>
    <echo message="...running HeaderXml2xmi.xsl" />
    <exec dir="{'${'}curDir{'}'}" executable= "java" failonerror="true">
      <arg line ="-cp {'${'}env.JAVACP_XSLT{'}'} org.vishia.xml.Xslt" />
  <xsl:for-each select="input">
      <arg line="-i{'${'}tmp{'}'}/{@file}.xml" /><xsl:comment> converted from ZBNF </xsl:comment>
  </xsl:for-each>
      <arg line="-i{'${'}tmp{'}'}/{$Outputfile}.types.xml" />
            <arg line="-t{'${'}env.ZBNFJAX_HOME{'}'}/xsl/HeaderXml2Xmi.xsl" />
            <arg line="-w+ -y{'${'}tmp{'}'}/{$Outputfile}" />
            <arg line="--report:{'${'}tmp{'}'}/{$Outputfile}.rpt --rlevel:333" />
           </exec>
  </target>

  <target name="isUptodate_{$Outputfile}"  description="DocuGenCtr2Ant.xslp:Header2Xmi_uptd">
          <uptodate property="isUptodate_{$Outputfile}" targetfile="{'${'}tmp{'}'}/{$Outputfile}">
    <xsl:for-each select="input">
      <srcfiles file="{'${'}curDir{'}'}/{@path}{@file}" />
    </xsl:for-each>
      <srcfiles file="{'${'}env.ZBNFJAX_HOME{'}'}/zbnf/Cheader.zbnf" />
            <srcfiles file="{'${'}env.ZBNFJAX_HOME{'}'}/XmlDocu_xsl/Header2Xmi.xslp" />
          </uptodate>
  </target>

  <xsl:for-each select="input"><!-- conversion with ZBNF for each input file -->

  <xsl:comment> Headerfile converted with ZBNF: </xsl:comment>
  <target name="{$Outputfile}-{@file}" depends="isUptodate_{$Outputfile}-{@file}" unless="isUptodate_{$Outputfile}-{@file}"  description="DocuGenCtr2Ant.xslp:HeaderZBNF">
    <echo message="...running ZBNF: {@file}" />
    <echo message="parsing Header {@path}{@file}=&amp;gt;tmp/{@file}.xml (DocuGenCtrl2Ant.xsl-template:Header2Xmi), using Zbnf2Xml, zbnf/Cheader.zbnf" />
    <exec dir="{'${'}curDir{'}'}" executable= "java" failonerror="true">
            <arg line ="-cp {'${'}env.JAVACP_ZBNF{'}'} org.vishia.zbnf.Zbnf2Xml"/>
            <arg line ="--rlevel:334 --report:{'${'}tmp{'}'}/{@file}.zbnf.rpt"/>
            <arg line ="-i:{@path}{@file}"/>
            <arg line ="-s:{'${'}env.ZBNFJAX_HOME{'}'}/zbnf/Cheader.zbnf"/>
            <arg line ="-x:{'${'}tmp{'}'}/{@file}.xml"/>
           </exec>
  </target>
  <target name="isUptodate_{$Outputfile}-{@file}" description="DocuGenCtr2Ant.xslp:HeaderZBNFUptd">
          <uptodate property="isUptodate_{$Outputfile}-{@file}" targetfile="{@file}.xml">
            <srcfiles file="{'${'}curDir{'}'}/{@path}{@file}" />
            <srcfiles file="{'${'}env.ZBNFJAX_HOME{'}'}/zbnf/Cheader.zbnf" />
          </uptodate>
  </target>
  </xsl:for-each>
</xsl:template>


<xsl:template name="oldHeader2UmlXml">
  <xsl:variable name="outputfile" />

  <target name="{$outputfile}" depends="isUptodate_{$outputfile}" unless="isUptodate_{$outputfile}"  description="DocuGenCtr2Ant.xslp:old">
    <echo message="update with Header2Xmi, ...running ZBNF" />
    <exec dir="{'${'}curDir{'}'}" executable= "java" failonerror="true">
            <arg line ="-cp {'${'}env.JAVACP_ZBNF{'}'} org.vishia.zbnf.Zbnf2Xml"/>
            <arg line ="--rlevel:334 --report:{'${'}tmp{'}'}/{@outputfile}.rpt"/>
            <arg line ="-i{@inputpath}{@inputfile}"/>
            <arg line ="-s{'${'}env.ZBNFJAX_HOME{'}'}/zbnf/Cheader.zbnf"/>
            <arg line ="-x{'${'}tmp{'}'}/{@inputfile}.xml"/>
           </exec>
    <echo message="...running HeaderXmlDissolveTypes.xsl" />
    <exec dir="{'${'}curDir{'}'}" executable= "java" failonerror="true">
      <arg line ="-cp {'${'}env.JAVACP_XSLT{'}'} org.vishia.xml.Xslt" />
            <arg line="-i{'${'}tmp{'}'}/{@inputfile}.xml" />
            <arg line="-t{'${'}env.ZBNFJAX_HOME{'}'}/XmlDocu_xsl/HeaderXmlDissolveTypes.xsl" />
            <arg line="-w+ -y{'${'}tmp{'}'}/{@inputfile}.types.xml" />
            <arg line="--report:{'${'}tmp{'}'}/{@inputfile}.types.rpt --rlevel:333" />
           </exec>
    <echo message="...running HeaderXml2xmi.xsl" />
    <exec dir="{'${'}curDir{'}'}" executable= "java" failonerror="true">
      <arg line ="-cp {'${'}env.JAVACP_XSLT{'}'} org.vishia.xml.Xslt" />
            <arg line="-i{'${'}tmp{'}'}/{@inputfile}.xml" />
            <arg line="-i{'${'}tmp{'}'}/{@inputfile}.types.xml" />
            <arg line="-t{'${'}env.ZBNFJAX_HOME{'}'}/XmlDocu_xsl/HeaderXml2Xmi.xsl" />
            <arg line="-w+ -y{'${'}tmp{'}'}/{$outputfile}" />
            <arg line="--report:{'${'}tmp{'}'}/{$outputfile}.rpt --rlevel:333" />
           </exec>
  </target>
  <target name="isUptodate_{$outputfile}" description="DocuGenCtr2Ant.xslp:old2" >
          <uptodate property="isUptodate_{$outputfile}" targetfile="{'${'}tmp{'}'}/{$outputfile}">
            <srcfiles file="{'${'}curDir{'}'}/{@inputpath}{@inputfile}" />
            <srcfiles file="{'${'}env.ZBNFJAX_HOME{'}'}/zbnf/Cheader.zbnf" />
            <srcfiles file="{'${'}env.ZBNFJAX_HOME{'}'}/XmlDocu_xsl/HeaderXml2UmlXml.xsl" />
          </uptodate>
  </target>


</xsl:template>




<xsl:template name= "prepXml_xmi2xml">
  <xsl:comment> ********************************************************************************************* </xsl:comment>
  <xsl:comment> xmi2xml: </xsl:comment>

  <target name="{@outputfile}" depends="isUptodate_{@outputfile}" unless="isUptodate_{@outputfile}"  description="DocuGenCtr2Ant.xslp:XmlXmi">
    <echo message="update with Xmi2Xml" />
    <exec dir="{'${'}curDir{'}'}" executable= "cmd.exe" failonerror="true">
            <arg line ="/c {'${'}env.ZBNFJAX_HOME{'}'}/../xmi2xml\xmi2xml.bat {@inputpath}{@inputfile} {'${'}tmp{'}'}/{@outputfile}"/>
           </exec>
  </target>
  <target name="isUptodate_{@outputfile}"  description="DocuGenCtr2Ant.xslp:xmlxmiuptd">
          <uptodate property="isUptodate_{@outputfile}" targetfile="{'${'}tmp{'}'}/{@outputfile}">
            <srcfiles file="{'${'}curDir{'}'}/{@inputpath}{@inputfile}" />
          </uptodate>
  </target>

</xsl:template>


</xsl:stylesheet>

