/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.xml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.vishia.mainCmd.MainCmd;
import org.vishia.mainCmd.MainCmdLoggingStream;
import org.vishia.mainCmd.MainCmdLogging_ifc;
import org.vishia.xml.XmlMReader;
import org.vishia.xml.XmlMTransformer;
import org.vishia.xmlSimple.XmlException;
import org.vishia.xmlSimple.Xsltpre;

public class Xslt {
    public static final String sVersion = "2014-06-01";
    protected String sFileOut = null;
    protected String sFileXslt = null;
    protected String sFileXslp = null;
    protected List<Parameter> params = new LinkedList<Parameter>();
    protected String sTransformer = "net.sf.saxon.TransformerFactoryImpl";
    protected boolean bWikiFormat = false;
    protected XmlMReader xmlMReader;
    private TransformerFactory tfactory;
    MainCmdLogging_ifc console;

    public static void main(String[] stringArray) {
        Xslt.exec(stringArray, true);
    }

    public static String exec(String[] stringArray) {
        return Xslt.exec(stringArray, false);
    }

    private static String exec(String[] stringArray, boolean bl) {
        Xslt xslt;
        Xslt xslt2 = xslt = new Xslt();
        xslt2.getClass();
        CmdLine cmdLine = xslt2.new CmdLine(stringArray);
        xslt.console = cmdLine;
        boolean bl2 = true;
        try {
            Class<?> clazz = Class.forName("org.vishia.xml.XmlMReaderJdomSaxon");
            xslt.xmlMReader = (XmlMReader)clazz.newInstance();
        }
        catch (Exception exception) {
            xslt.console.setExitErrorLevel(5);
            bl2 = false;
        }
        if (bl2) {
            xslt.xmlMReader.setReport(xslt.console);
            try {
                cmdLine.parseArguments();
            }
            catch (Exception exception) {
                xslt.console.setExitErrorLevel(5);
                bl2 = false;
            }
        }
        if (bl2) {
            try {
                xslt.console.reportln(4, "vishia-XSLT with " + xslt.sTransformer);
                System.setProperty("javax.xml.transform.TransformerFactory", xslt.sTransformer);
                xslt.tfactory = TransformerFactory.newInstance();
                xslt.transform();
            }
            catch (Exception exception) {
                xslt.console.report("Uncatched Exception on main level:", (Throwable)exception);
                xslt.console.setExitErrorLevel(3);
            }
        }
        if (bl) {
            cmdLine.exit();
        }
        return cmdLine.getExitErrorLevel() == 0 ? "" : "Xslt error=" + cmdLine.getExitErrorLevel();
    }

    private Xslt() {
    }

    public Xslt(ClassLoader classLoader, String string, String string2) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        ClassLoader classLoader2 = classLoader == null ? this.getClass().getClassLoader() : classLoader;
        Class<?> clazz = classLoader2.loadClass(string);
        this.xmlMReader = (XmlMReader)clazz.newInstance();
        this.tfactory = TransformerFactory.newInstance(string2, classLoader2);
        this.console = MainCmd.getLogging_ifc();
        if (this.console == null) {
            this.console = new MainCmdLoggingStream((OutputStream)System.out, 3);
        }
    }

    public void addInputfile(String string) {
        this.xmlMReader.addInputFile(string);
    }

    public void addInputfileReplaceWith1Space(String string) {
        this.xmlMReader.addInputFile(string, 1);
    }

    public void addInputfileExpandWikiformat(String string) {
        this.xmlMReader.addInputFile(string, 2);
    }

    public void setXsltfile(String string) {
        this.sFileXslt = string;
    }

    public void setXslpfile(String string) {
        this.sFileXslp = string;
    }

    public void setOutputfile(String string) {
        this.sFileOut = string;
    }

    public void transform() throws ParserConfigurationException, FileNotFoundException, IOException, TransformerException, XmlException {
        File file = this.sFileXslp != null ? this.genXslFromXslp() : new File(this.sFileXslt);
        Source source = this.xmlMReader.readInputs(this.tfactory);
        StreamSource streamSource = new StreamSource(file);
        Transformer transformer = this.tfactory.newTransformer(streamSource);
        Properties properties = new Properties();
        for (Parameter object2 : this.params) {
            transformer.setParameter(object2.name, object2.value);
        }
        XmlMTransformer xmlMTransformer = new XmlMTransformer(source, transformer);
        File file2 = new File(this.sFileOut);
        xmlMTransformer.transformToFile(file2);
        this.console.writeInfoln("output written to:" + file2.getAbsolutePath());
        this.console.writeInfoln("");
    }

    private File genXslFromXslp() {
        if (this.sFileXslt == null) {
            int n = this.sFileXslp.lastIndexOf(46);
            this.sFileXslt = n < 0 || this.sFileXslp.endsWith(".xsl") ? this.sFileXslp + ".xsl" : this.sFileXslp.substring(0, n) + ".xsl";
        }
        File file = new File(this.sFileXslt);
        File file2 = new File(this.sFileXslp);
        Xsltpre xsltpre = new Xsltpre(file2, file);
        xsltpre.execute();
        return file;
    }

    class CmdLine
    extends MainCmd {
        private CmdLine(String[] stringArray) {
            super(stringArray);
            super.addAboutInfo("XSLT-Translator");
            super.addAboutInfo("made by Hartmut Schorrig, 2005..2009-03-31");
            super.addHelpInfo("* saxon9.jar, saxon9-jdom.jar, jdom.jar required internally.");
            super.addHelpInfo("* Multiple input files are able too, all XML-inputs are disposed as child of a <root>");
            super.addHelpInfo("* Enhancments of wiki-format texts to XHTML implicitly");
            super.addHelpInfo("* Prepared XSL-Script possible, see org.vishia.xmlSimple.Xsltpre");
            super.addHelpInfo("invoke { -[i|j|k]:INPUT } [-t:XSLT] [-p:XSLP] -y:OUTPUT [-xslt:TRANSFORMER] {PARAM}");
            super.addHelpInfo("-i:INPUT-XML-file");
            super.addHelpInfo("-j:INPUT-XML-file, Whitespaces will replaced with 1 space");
            super.addHelpInfo("-t:XSLT: xsl-script XML2-compatible, it is output if -p:XSLP is given");
            super.addHelpInfo("-p:XSLP: Script pretranslated with Xsltpre, than -t:XSLT will be created if older.");
            super.addHelpInfo("         If no option -t:XSLT is given, XSLT will be created parallel with .xsl as extension.");
            super.addHelpInfo("-y:OUTPUT-file");
            super.addHelpInfo("-xslt:TRANSFORMER Set the class for Transformer-Implementation. Default is " + Xslt.this.sTransformer);
            super.addHelpInfo("PARAM: written in form NAME=VALE or {URI}NAME=VALUE. They are available in the XSLT-script as $NAME.");
            super.addStandardHelpInfo();
        }

        protected boolean testArgument(String string, int n) {
            int n2;
            boolean bl = true;
            int n3 = n2 = string.length() >= 2 && string.charAt(2) == ':' ? 3 : 2;
            if (string.startsWith("-i")) {
                Xslt.this.xmlMReader.addInputFile(this.getArgument(n2));
            } else if (string.startsWith("-j")) {
                Xslt.this.xmlMReader.addInputFile(this.getArgument(n2), 1);
            } else if (string.startsWith("-k")) {
                Xslt.this.xmlMReader.addInputFile(this.getArgument(n2), 2);
            } else if (string.startsWith("-t")) {
                Xslt.this.sFileXslt = this.getArgument(n2);
            } else if (string.startsWith("-p")) {
                Xslt.this.sFileXslp = this.getArgument(n2);
            } else if (string.startsWith("-y")) {
                Xslt.this.sFileOut = this.getArgument(n2);
            } else if (string.startsWith("-xslt:")) {
                Xslt.this.sTransformer = this.getArgument(6);
            } else if (!string.startsWith("-w+") && !string.startsWith("-w-")) {
                int n4 = string.indexOf(61);
                if (n4 > 0) {
                    String string2 = string.substring(0, n4);
                    String string3 = string.substring(n4 + 1);
                    Xslt.this.params.add(new Parameter(string2, string3));
                } else {
                    bl = false;
                }
            }
            return bl;
        }

        protected void callWithoutArguments() throws ParseException {
            super.callWithoutArguments();
        }

        protected boolean checkArguments() {
            boolean bl = true;
            if (Xslt.this.sFileOut == null) {
                this.writeWarning("argument -y: no outputfile is given");
            } else if (Xslt.this.sFileOut.length() == 0) {
                bl = false;
                this.writeError("argument -y: without content");
            }
            if (Xslt.this.sFileXslt == null) {
                this.writeWarning("argument -t: no XSLT-file is given");
            } else if (Xslt.this.sFileXslt.length() == 0) {
                bl = false;
                this.writeError("argument -t: without content");
            }
            if (!bl) {
                this.setExitErrorLevel(5);
            }
            return bl;
        }
    }

    protected class Parameter {
        String name;
        String value;

        public Parameter(String string, String string2) {
            this.name = string;
            this.value = string2;
        }
    }
}

