/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.xml;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;
import org.vishia.mainCmd.Report;
import org.vishia.xml.XmlExtensions;
import org.vishia.xml.XsltException;
import org.vishia.xmlSimple.XmlException;

public class XslTransformer {
    private final Report main;
    private Element xmlRoot;

    XslTransformer(Report report) {
        this.main = report;
    }

    public void transform(List<FileTypeIn> list, File file, File file2, XmlExtensions.XmlMode xmlMode, File file3) throws XsltException, FileNotFoundException, XmlException {
        Element element;
        Object object;
        String string = file2.getAbsolutePath();
        this.xmlRoot = new Element("root");
        for (FileTypeIn fileTypeIn : list) {
            object = fileTypeIn.sName;
            this.main.reportln(3, "reading " + (String)object);
            element = fileTypeIn.readXmlFile();
            element.detach();
            this.xmlRoot.addContent((Content)element);
            this.main.report(3, " ...done.");
        }
        try {
            XmlExtensions.writeXmlDirect(this.xmlRoot, new File(string + ".i.xml"), "ISO-8859-1");
        }
        catch (XmlException xmlException) {
            this.main.report("test", (Throwable)xmlException);
        }
        if (!xmlMode.isText()) {
            if (xmlMode.isXml()) {
                FileTypeIn fileTypeIn;
                fileTypeIn = null;
                object = null;
                this.main.reportln(3, "translating via " + file.getAbsolutePath());
                try {
                    fileTypeIn = XmlExtensions.xslTransformXml(this.xmlRoot, file);
                }
                catch (XmlException xmlException) {
                    object = xmlException;
                }
                if (object != null) {
                    element = new Element("TheInputTreeOnError");
                    this.xmlRoot.detach();
                    element.addContent((Content)this.xmlRoot);
                    if (file3 != null) {
                        try {
                            XmlExtensions.writeXmlFile(element, file3, xmlMode);
                        }
                        catch (XmlException xmlException) {
                            throw new XsltException("ERROR translating and writing:" + file2.getAbsolutePath() + "\n  " + xmlException.getMessage() + ((Throwable)object).getMessage(), 4, (Exception)((Object)xmlException));
                        }
                    }
                    throw new XsltException("ERROR translating with:" + file.getAbsolutePath() + "\n  " + ((Throwable)object).getMessage(), 4, (Exception)object);
                }
                this.main.report(3, " ...done.");
                this.main.reportln(3, "writing " + string);
                try {
                    XmlExtensions.writeXmlDirect((Element)fileTypeIn, new File(string + ".a.xml"), "ISO-8859-1");
                }
                catch (XmlException xmlException) {
                    this.main.report("test-a", (Throwable)xmlException);
                }
                try {
                    XmlExtensions.writeXmlDirect(this.xmlRoot, new File(string + ".b.xml"), "ISO-8859-1");
                }
                catch (XmlException xmlException) {
                    this.main.report("test-b", (Throwable)xmlException);
                }
                if (xmlMode.isIndent()) {
                    fileTypeIn = XmlExtensions.beautificationBewareTextContent((Element)fileTypeIn);
                }
                try {
                    XmlExtensions.writeXmlFile((Element)fileTypeIn, file2, xmlMode);
                }
                catch (XmlException xmlException) {
                    throw new XsltException("ERROR writing:" + file2.getAbsolutePath() + "\n  " + xmlException.getMessage(), 4, (Exception)((Object)xmlException));
                }
                this.main.report(3, " ...done.");
            } else {
                throw new XsltException("failed convert mode", 5);
            }
        }
    }

    public static class FileTypeIn {
        public static final int mReplaceWhiteSpaceWith1Space = 1;
        public static final int mExpandAsciiFormating = 2;
        private final String sName;
        private final int mode;
        private final File fileIn;

        public FileTypeIn(String string, int n) {
            this.sName = string;
            this.fileIn = new File(this.sName);
            this.mode = n;
        }

        public Element readXmlFile() throws XsltException, FileNotFoundException {
            Element element = null;
            try {
                element = (this.mode & 1) != 0 ? XmlExtensions.readXmlFileTrimWhiteSpace(this.fileIn) : XmlExtensions.readXmlFile(this.fileIn);
            }
            catch (XmlException xmlException) {
                throw new XsltException(xmlException.getMessage(), 4, (Exception)((Object)xmlException));
            }
            return element;
        }

        public String getAbsolutePath() {
            return this.fileIn.getAbsolutePath();
        }
    }
}

