/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.xml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import net.sf.saxon.Configuration;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.jdom.DocumentWrapper;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.vishia.mainCmd.MainCmd;
import org.vishia.mainCmd.MainCmdLoggingStream;
import org.vishia.mainCmd.Report;
import org.vishia.xml.XmlExtensions;
import org.vishia.xml.XmlMReader;
import org.vishia.xmlSimple.XmlException;

public class XmlMReaderJdomSaxon
extends XmlMReader {
    XmlMReaderJdomSaxon(Report report) {
        super(report);
    }

    public XmlMReaderJdomSaxon() {
        this.console = MainCmd.getLogging_ifc();
        if (this.console == null) {
            this.console = new MainCmdLoggingStream((OutputStream)System.out, 3);
        }
    }

    private Element readXmlFileJdom(File file, int n) throws FileNotFoundException, XmlException {
        Element element = null;
        element = (n & 1) != 0 ? XmlExtensions.readXmlFileTrimWhiteSpace(file) : XmlExtensions.readXmlFile(file);
        return element;
    }

    public int readInputsToJdomElement(Element element) {
        boolean bl = true;
        int n = 0;
        for (XmlMReader.FileTypeIn fileTypeIn : this.listFileIn) {
            String string = fileTypeIn.sName;
            this.console.writeInfoln("reading " + string);
            try {
                Element element2 = this.readXmlFileJdom(fileTypeIn.getFile(), fileTypeIn.getMode());
                element2.detach();
                element.addContent((Content)element2);
                ++n;
                this.console.writeInfo(" ...done.");
            }
            catch (Exception exception) {
                this.console.writeError("Problem reading " + fileTypeIn.getFile().getAbsolutePath());
                bl = false;
            }
        }
        return bl ? n : -n;
    }

    @Override
    public Source readInputs(TransformerFactory transformerFactory) {
        Document document = new Document();
        Element element = new Element("root");
        this.readInputsToJdomElement(element);
        document.setRootElement(element);
        String string = ((XmlMReader.FileTypeIn)this.listFileIn.get(0)).getFile().getAbsolutePath();
        Configuration configuration = ((TransformerFactoryImpl)transformerFactory).getConfiguration();
        DocumentWrapper documentWrapper = new DocumentWrapper(document, string, configuration);
        return documentWrapper;
    }
}

