/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.xml;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.Parent;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.transform.JDOMResult;
import org.jdom.transform.JDOMSource;
import org.vishia.mainCmd.Report;
import org.vishia.xmlSimple.XmlException;

public class XmlExtensions {
    public static final int kEncoding_ISO_8859_1 = 1;
    public static final int kEncoding_UTF_8 = 2;
    public static final int kEncoding_ASCII = 3;

    public static String getTextFromPath(Element element, String string, boolean bl) {
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer(100);
        boolean bl3 = false;
        Element element2 = element;
        if (bl2) {
            System.out.println(string);
        }
        int n = 0;
        while (n < string.length()) {
            Object object;
            int n2;
            int n3;
            char c = string.charAt(n);
            if (c == '\'' || c == '\"') {
                n3 = string.indexOf(c, n + 1);
                if (n3 < 0) {
                    n3 = string.length();
                }
                stringBuffer.append(string.substring(n + 1, n3));
                n = n3 + 1;
                if (n >= string.length() || (n = string.indexOf(43, n)) >= 0) continue;
                n = string.length();
                continue;
            }
            if (n < string.length() - 1 && string.charAt(n + 1) == '+' || n == string.length() - 1) {
                stringBuffer.append(string.charAt(n));
                n += 2;
                continue;
            }
            if (string.charAt(n) == '{') {
                n = XmlExtensions.getMultiText(stringBuffer, element, string, n);
                continue;
            }
            n3 = string.indexOf(43, n);
            if (n3 < 0) {
                n3 = string.length();
            }
            if ((n2 = string.lastIndexOf(47, n3 - 1)) > 0) {
                if (bl2) {
                    System.out.println("  child:" + string.substring(n, n2) + ":");
                }
                element2 = (object = XmlExtensions.getChildren(element, string.substring(n, n + n2))).size() > 0 ? (Element)object.get(0) : null;
                n = n2 + 1;
            } else {
                element2 = element;
            }
            if (element2 == null) {
                bl3 = true;
            } else if (string.charAt(n) == '@') {
                object = element2.getAttributeValue(string.substring(n + 1, n3));
                if (bl2) {
                    System.out.println("              :" + string.substring(n, n3) + ":" + element2.getName() + "::" + (String)object);
                }
                if (object == null) {
                    bl3 = true;
                } else {
                    stringBuffer.append((String)object);
                }
            } else if ((element2 = element2.getChild(string.substring(n, n3))) == null) {
                bl3 = true;
            } else {
                stringBuffer.append(element2.getTextNormalize());
            }
            n = n3 + 1;
        }
        if (bl3 && !bl) {
            return null;
        }
        return stringBuffer.toString();
    }

    public static List<Parent> getChildren(Element element, String string) {
        List<Object> list;
        int n = 0;
        boolean bl = false;
        while (n < string.length() && !bl) {
            int n2 = string.indexOf(47, n);
            if (n2 >= 0) {
                bl = false;
                if (string.substring(n, n2).equals("..")) {
                    if (element != null) {
                        element = element.getParentElement();
                    }
                } else if (!string.substring(n, n2).equals(".") && element != null) {
                    element = element.getChild(string.substring(n, n2));
                }
                n = n2 + 1;
                continue;
            }
            bl = true;
        }
        if (element != null) {
            if (string.substring(n).equals("..")) {
                list = new LinkedList<Object>();
                list.add(element.getParent());
            } else if (string.substring(n).equals(".")) {
                list = new LinkedList();
                list.add(element);
            } else {
                list = element.getChildren(string.substring(n));
            }
        } else {
            list = null;
        }
        return list;
    }

    private static int getMultiText(StringBuffer stringBuffer, Element element, String string, int n) {
        int n2 = string.indexOf(125, n);
        int n3 = string.indexOf(124, n);
        int n4 = string.indexOf(124, n3 + 1);
        if (n2 < 0 || n3 < 0 || n4 < 0) {
            stringBuffer.append("::ERROR::Syntay {||}:" + string.substring(n));
        } else {
            String string2 = string.substring(n + 1, n3);
            String string3 = string.substring(n3 + 1, n4);
            String string4 = string.substring(n4 + 1, n2);
            List<Parent> list = XmlExtensions.getChildren(element, string2);
            Iterator<Parent> iterator = list.iterator();
            boolean bl = true;
            while (iterator.hasNext()) {
                Element element2 = (Element)iterator.next();
                String string5 = XmlExtensions.getTextFromPath(element2, string3, true);
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(string4);
                }
                stringBuffer.append(string5);
            }
        }
        if (n2 > 0) {
            return n2 + 1;
        }
        return string.length();
    }

    public static boolean setTextToPath(Element element, String string, String string2) {
        boolean bl = false;
        if (string2 == null) {
            string2 = "XXX";
        }
        Element element2 = element;
        int n = 0;
        if (string.length() > 0 && string2 != null) {
            boolean bl2 = true;
            do {
                int n2;
                if ((n2 = string.indexOf(47, n)) < 0) {
                    n2 = string.length();
                    bl2 = false;
                }
                if (string.substring(n, n2).equals("..")) {
                    element2 = element2.getParentElement();
                } else if (!string.substring(n, n2).equals(".")) {
                    if (string.substring(n).startsWith("!")) {
                        bl2 = false;
                    } else if (string.substring(n).startsWith("@")) {
                        bl2 = false;
                    } else if (string.substring(n).startsWith("=")) {
                        element2.setText("");
                    } else {
                        Element element3 = element2.getChild(string.substring(n, n2));
                        element2 = element3 == null ? new Element(string.substring(n, n2)) : element3;
                    }
                }
                if (!bl2) continue;
                n = n2 + 1;
            } while (bl2 && element2 != null);
            if (element2 != null) {
                if (string.charAt(n) == '@') {
                    element2.setAttribute(string.substring(n + 1), string2);
                    bl = true;
                } else if (string.charAt(n) == '!') {
                    element2.setName(string2);
                    bl = true;
                } else {
                    element2.addContent(string2);
                    bl = true;
                }
            }
        }
        return bl;
    }

    public static Element readXmlFile(File file) throws XmlException {
        try {
            SAXBuilder sAXBuilder = new SAXBuilder();
            Document document = sAXBuilder.build(file);
            return document.getRootElement();
        }
        catch (JDOMException jDOMException) {
            throw new XmlException("conversion readed xml-File " + file.getAbsolutePath() + jDOMException.getMessage());
        }
        catch (IOException iOException) {
            throw new XmlException("reading xml-File " + file.getAbsolutePath() + iOException.getMessage());
        }
    }

    public static Element readXmlFileTrimWhiteSpace(File file) throws XmlException {
        class InputStreamSpecial
        extends InputStream {
            private final InputStream in;
            int cNext = -1;
            int lineCt = 0;

            InputStreamSpecial(File file) {
                FileInputStream fileInputStream;
                try {
                    fileInputStream = new FileInputStream(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileInputStream = null;
                }
                this.in = fileInputStream;
            }

            @Override
            public int read() throws IOException {
                if (this.in != null) {
                    int n;
                    if (this.cNext > 0) {
                        n = this.cNext;
                    }
                    if ((n = this.in.read()) == 13 && this.lineCt > 0) {
                        n = 32;
                    }
                    if (n == 10) {
                        if (this.lineCt > 0) {
                            n = 32;
                        }
                        ++this.lineCt;
                    }
                    return n;
                }
                return -1;
            }

            public boolean isReadable() {
                return this.in != null;
            }
        }
        InputStreamSpecial inputStreamSpecial = new InputStreamSpecial(file);
        if (!inputStreamSpecial.isReadable()) {
            try {
                inputStreamSpecial.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new XmlException("file not found: " + file.getAbsolutePath());
        }
        try {
            SAXBuilder sAXBuilder = new SAXBuilder();
            Document document = sAXBuilder.build((InputStream)inputStreamSpecial);
            Element element = document.getRootElement();
            XmlExtensions.replaceWhiteSpaceWith1Space(element, false);
            try {
                inputStreamSpecial.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return element;
        }
        catch (Exception exception) {
            try {
                inputStreamSpecial.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new XmlException("conversion given xml-String " + exception.getMessage());
        }
    }

    public static void replaceWhiteSpaceWith1Space(Element element, boolean bl) {
        Object object;
        boolean bl2 = false;
        if (!bl && ((String)(object = element.getTextNormalize())).length() > 0) {
            bl = true;
            bl2 = true;
        }
        object = element.getContent();
        Iterator iterator = object.iterator();
        boolean bl3 = bl2 = false;
        while (iterator.hasNext()) {
            Content content = (Content)iterator.next();
            if (content instanceof Text && bl) {
                Text text = (Text)content;
                String string = text.getText();
                int n = string.length();
                if (n > 0) {
                    char c = string.charAt(0);
                    char c2 = string.charAt(n - 1);
                    if ((string = Text.normalizeString((String)string)).startsWith("dieses hier")) {
                        string = "dieses hier ";
                    }
                    if (c == ' ' || c == '\n' || c2 == ' ' || c2 == '\n') {
                        string = (!bl3 && c == ' ' ? " " : "") + (!bl3 && c == '\n' ? " " : "") + string + (!(!iterator.hasNext() && bl2 || n <= 1 || string.length() <= 0 || c2 != ' ' && c != '\n') ? " " : "");
                    }
                }
                text.setText(string);
            } else if (content instanceof Element) {
                XmlExtensions.replaceWhiteSpaceWith1Space((Element)content, bl);
            }
            bl3 = false;
        }
    }

    public static Element beautificationBewareTextContent(Element element) {
        return BeautificationNoTextContent.beautificationNoTextContent(element, false, 0);
    }

    public static void reportContentElement(Element element, Report report) {
        report.reportln(3, "reportContentElement: " + element.getName());
    }

    private static void xslTransform(Element element, File file, Result result) throws XmlException {
        if (!file.exists()) {
            throw new XmlException("xslTransformation: xsl-file not found: " + file.getName());
        }
        Transformer transformer = null;
        try {
            transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(file));
        }
        catch (TransformerException transformerException) {
            throw new XmlException("xslTransformation: error in xsl-file: " + file.getName() + transformerException.getMessage());
        }
        Document document = new Document();
        element.detach();
        document.setRootElement(element);
        try {
            transformer.transform((Source)new JDOMSource(document), result);
        }
        catch (TransformerException transformerException) {
            throw new XmlException("xslTransformation: error in xsl-file: " + file.getName() + transformerException.getMessage());
        }
    }

    public static Element xslTransformXml(Element element, File file) throws XmlException {
        JDOMResult jDOMResult = new JDOMResult();
        XmlExtensions.xslTransform(element, file, (Result)jDOMResult);
        if (!jDOMResult.getDocument().hasRootElement()) {
            throw new XmlException("xslTransformationXml: no root element produced");
        }
        Element element2 = jDOMResult.getDocument().getRootElement();
        element2.detach();
        return element2;
    }

    public static String xslTransformString(Element element, File file) throws XmlException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(10000);
        StreamResult streamResult = new StreamResult(byteArrayOutputStream);
        XmlExtensions.xslTransform(element, file, streamResult);
        return byteArrayOutputStream.toString();
    }

    public static void writeXmlBeautificatedTextFile(Element element, File file, Charset charset) throws XmlException, FileNotFoundException {
        Element element2 = XmlExtensions.beautificationBewareTextContent(element);
        XmlMode xmlMode = new XmlMode();
        xmlMode.setEncoding(charset);
        xmlMode.setIndent(null);
        XmlExtensions.writeXmlFile(element2, file, xmlMode);
    }

    public static void writeXmlFile(Element element, String string) throws XmlException, FileNotFoundException {
        XmlMode xmlMode = new XmlMode();
        XmlExtensions.writeXmlFile(element, new File(string), xmlMode);
    }

    public void writeXmlFile(Element element, File file) throws XmlException, FileNotFoundException {
        FileOutputStream fileOutputStream = null;
        fileOutputStream = new FileOutputStream(file);
        Document document = new Document();
        document.setRootElement(element);
        XMLOutputter xMLOutputter = new XMLOutputter();
        Format format = Format.getRawFormat();
        xMLOutputter.setFormat(format);
        try {
            xMLOutputter.output(document, (OutputStream)fileOutputStream);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw new XmlException("Any error writing file:" + iOException.getMessage());
        }
    }

    public static void writeXmlFile(Element element, File file, XmlMode xmlMode) throws XmlException, FileNotFoundException {
        FileOutputStream fileOutputStream = null;
        fileOutputStream = new FileOutputStream(file);
        Document document = new Document();
        document.setRootElement(element);
        XMLOutputter xMLOutputter = new XMLOutputter();
        Format format = Format.getRawFormat();
        format.setEncoding(xmlMode.getEncoding());
        xMLOutputter.setFormat(format);
        try {
            xMLOutputter.output(document, (OutputStream)fileOutputStream);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw new XmlException("Any error writing file:" + iOException.getMessage());
        }
    }

    public static void writeXmlDirect(Element element, File file, String string) throws XmlException, FileNotFoundException {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
            XmlExtensions.writeXmlDirect(element, fileWriter, string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void writeXmlDirect(Element element, Writer writer, String string) throws XmlException, IOException {
        writer.write("<" + element.getName());
        List list = element.getAttributes();
        for (Attribute attribute : list) {
            writer.write(" " + attribute.getName() + "=" + "\"" + attribute.getValue() + "\"");
        }
        writer.write(">");
        list = element.getAdditionalNamespaces();
        if (list.size() > 0) {
            for (Attribute attribute : list) {
                writer.write(" xmlns:" + attribute.getPrefix() + "=\"" + attribute.getURI() + "\"");
            }
        }
        list = element.getContent();
        for (Attribute attribute : list) {
            if (attribute instanceof Text) {
                Text text = (Text)attribute;
                String string2 = text.getText();
                writer.write(string2);
                continue;
            }
            if (!(attribute instanceof Element)) continue;
            XmlExtensions.writeXmlDirect((Element)attribute, writer, string);
        }
    }

    private static class BeautificationNoTextContent {
        static final String sIndent = "\n                                                               ";
        static final int nMaxIndent = "\n                                                               ".length() / 2 - 2;

        private BeautificationNoTextContent() {
        }

        private static Element beautificationNoTextContent(Element element, boolean bl, int n) {
            Element element2 = new Element(element.getName(), element.getNamespace());
            List list = element.getAttributes();
            for (Attribute attribute : list) {
                element2.setAttribute(attribute.getName(), attribute.getValue());
            }
            list = element.getAdditionalNamespaces();
            if (list.size() > 0) {
                for (Attribute attribute : list) {
                    element2.addNamespaceDeclaration((Namespace)attribute);
                }
            }
            if (n > nMaxIndent) {
                n = nMaxIndent;
            }
            list = element.getContent();
            for (Attribute attribute : list) {
                if (attribute instanceof Text) {
                    String string;
                    Text text = (Text)attribute;
                    if (bl) {
                        string = text.getText();
                        element2.addContent(string);
                        continue;
                    }
                    string = text.getText();
                    int n2 = 0;
                    int n3 = string.length();
                    while (!bl && n2 < n3) {
                        char c = string.charAt(n2);
                        if ("\r\n \t".indexOf(c) >= 0) {
                            ++n2;
                            continue;
                        }
                        bl = true;
                    }
                    if (!bl) continue;
                    element2.addContent(string);
                    continue;
                }
                if (!(attribute instanceof Element)) continue;
                if (!bl) {
                    element2.addContent(sIndent.substring(0, 1 + 2 * n));
                }
                element2.addContent((Content)BeautificationNoTextContent.beautificationNoTextContent((Element)attribute, bl, n + 1));
            }
            return element2;
        }
    }

    public static class XmlMode {
        private static final int kConvertText = 1;
        private static final int mConvertXml = 16;
        private static final int kConvertXmlUTF8 = 16;
        private static final int kConvertXmlIso8859 = 17;
        private static final int kConvertXmlASCII = 18;
        private String sEncoding = "ISO-8859-1";
        private int convertMode = 1;
        private String sIndent = "  ";

        public void setIndent(String string) {
            this.sIndent = string;
        }

        public void setText() {
            this.convertMode = 1;
        }

        public void setEncoding(Charset charset) {
            this.sEncoding = charset.name();
        }

        public void setXmlUTF8() {
            this.convertMode = 16;
            this.sEncoding = "UTF-8";
        }

        public void setXmlIso8859() {
            this.convertMode = 17;
            this.sEncoding = "ISO-8859-1";
        }

        public void setXmlASCII() {
            this.convertMode = 18;
            this.sEncoding = "US-ASCII";
        }

        public boolean isText() {
            return this.convertMode == 1;
        }

        public boolean isXml() {
            return (this.convertMode & 0x10) == 16;
        }

        public boolean isIndent() {
            return this.sIndent != null;
        }

        public String getIndent() {
            return this.sIndent;
        }

        public int xxxgetEncoding() throws XmlException {
            switch (this.convertMode) {
                case 16: {
                    return 2;
                }
                case 17: {
                    return 1;
                }
            }
            throw new XmlException("getEncoding? - but unknown");
        }

        public String getEncoding() {
            return this.sEncoding;
        }
    }
}

