/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.xml;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.vishia.mainCmd.MainCmd;
import org.vishia.util.FileSystem;

public class Textfile2Html
extends MainCmd {
    public static final String sVersion = "2015-11-03";
    String sPathIn = null;
    String sPathOut = null;
    String sFile = "";
    int maxLineSize = 120;
    static String sIndent = "                              ";
    private BufferedWriter writer;

    public static void main(String[] stringArray) {
        Textfile2Html textfile2Html = new Textfile2Html(stringArray);
        textfile2Html.execute();
        textfile2Html.exit();
    }

    void execute() {
        boolean bl = true;
        try {
            super.parseArguments();
        }
        catch (Exception exception) {
            this.setExitErrorLevel(5);
            bl = false;
        }
        if (bl) {
            try {
                this.convert();
            }
            catch (Exception exception) {
                this.report("Abort the routine:", exception);
                this.setExitErrorLevel(3);
            }
        }
    }

    Textfile2Html(String[] stringArray) {
        super(stringArray);
        super.addAboutInfo("Translator text files to a html readable represantiation");
        super.addAboutInfo("made by JcHartmut, 2006-02-25");
        super.addHelpInfo("param: -iINPUT -oOUTPUT -fFILE -linesize:size");
        super.addStandardHelpInfo();
        super.addHelpInfo("-iINPUT    inputfilepath, a xml like file.");
        super.addHelpInfo("-oOUTPUT   outputfilepath, this file is written.");
        super.addHelpInfo("-fFILE     if this argument is given, read from INPUT/FILE, write to OUTPUT/FILE.html.");
        super.addHelpInfo("-linesize: length of a line, a wrapping is generated after it.");
    }

    public boolean testArgument(String string, int n) {
        boolean bl = true;
        if (string.startsWith("-i")) {
            this.sPathIn = this.getArgument(2);
        } else if (string.startsWith("-o")) {
            this.sPathOut = this.getArgument(2);
        } else if (string.startsWith("-f")) {
            this.sFile = this.getArgument(2);
        } else if (string.startsWith("-linesize:")) {
            this.maxLineSize = Integer.parseInt(this.getArgument(10));
        } else {
            bl = false;
        }
        return bl;
    }

    protected boolean checkArguments() {
        boolean bl = true;
        if (this.sPathIn == null) {
            bl = false;
            this.writeError("ERROR argument -i is obligat.");
        } else if (this.sPathIn.length() == 0) {
            bl = false;
            this.writeError("ERROR argument -i without content.");
        }
        if (this.sPathOut == null) {
            this.writeWarning("argument -o no outputfile is given, use default");
            this.sPathOut = "out.txt";
        } else if (this.sPathOut.length() == 0) {
            bl = false;
            this.writeError("argument -o without content");
        }
        if (!bl) {
            this.setExitErrorLevel(5);
        }
        return bl;
    }

    void convert() throws Exception {
        String string;
        BufferedReader bufferedReader = null;
        if (this.sFile.length() > 0) {
            this.sPathIn = this.sPathIn + "/" + this.sFile;
        }
        try {
            bufferedReader = new BufferedReader(new FileReader(this.sPathIn));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.writeError("input file not found", fileNotFoundException);
            this.setExitErrorLevel(4);
            throw fileNotFoundException;
        }
        if (this.sFile.length() > 0) {
            this.sPathOut = this.sPathOut + "/" + this.sFile + ".html";
        }
        try {
            FileSystem.mkDirPath((String)this.sPathOut);
            this.writer = new BufferedWriter(new FileWriter(this.sPathOut));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.writeError("output file not found", fileNotFoundException);
            this.setExitErrorLevel(4);
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            throw fileNotFoundException;
        }
        this.report(3, "translate " + this.sPathIn + " to " + this.sPathOut);
        this.writer.write("<html><head><title>" + this.sPathIn + "</title></head>\n<body><pre>\n");
        while ((string = bufferedReader.readLine()) != null) {
            int n;
            int n2 = string.indexOf("html-anchor=\"");
            if (n2 >= 0) {
                n = string.indexOf(34, n2 + 13);
                String string2 = string.substring(n2 + 13, n);
                this.writer.append("\n</pre><a name=\"").append(string2).append("\" /><pre>");
            }
            for (n = 0; string.length() > n && string.charAt(n) == ' '; ++n) {
            }
            string = string.substring(n);
            if (n > sIndent.length() - 2) {
                n = sIndent.length() - 2;
            }
            int n3 = n;
            int n4 = this.maxLineSize - n3;
            while (string.length() > n4) {
                int n5 = string.lastIndexOf(32, n4);
                int n6 = n5 + 1;
                if (n5 < 0) {
                    n6 = n5 = n4;
                }
                this.printLine(sIndent.substring(0, n3) + string.substring(0, n5));
                string = string.substring(n6);
                n3 = n + 2;
                n4 = this.maxLineSize - n3;
            }
            this.printLine(sIndent.substring(0, n3) + string);
        }
        this.writer.write("\n</pre>\n</body></html>\n");
        this.writer.close();
        this.writer = null;
        bufferedReader.close();
        this.reportln(3, "....successfull.");
    }

    void printLine(String string) throws IOException {
        String string2 = string.replaceAll("&", "&amp;");
        string2 = string2.replaceAll("<", "&lt;");
        string2 = string2.replaceAll(">", "&gt;");
        this.writer.write(string2);
        this.writer.write("\n");
    }
}

