/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.zbnf;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.vishia.mainCmd.MainCmdLogging_ifc;
import org.vishia.util.IndexMultiTable;
import org.vishia.util.StringFunctions;
import org.vishia.util.StringPart;
import org.vishia.util.StringPartScan;

public class ZbnfSyntaxPrescript {
    public static final String version = "2018-09-10";
    EType eType;
    final ZbnfSyntaxPrescript parent;
    protected String sSemantic;
    protected boolean bAssignIntoNextComponent = false;
    protected boolean bAddOuterResults = false;
    List<ZbnfSyntaxPrescript> childSyntaxPrescripts;
    boolean bChildSyntaxAreAlternatives = false;
    private boolean alsoEmptyOption;
    protected String sConstantSyntax;
    protected List<String> listStrings;
    double nFloatFactor = 1.0;
    protected int nodeIdent;
    Map<String, String> attributes = null;
    protected String sDefinitionIdent;
    protected String sSubSyntax = null;
    protected String sIndentChars = null;
    private final String sCommentStart1;
    private final String sCommentStart2;
    public boolean bDebugParsing;
    final MainCmdLogging_ifc report;

    private ZbnfSyntaxPrescript(ZbnfSyntaxPrescript zbnfSyntaxPrescript, MainCmdLogging_ifc mainCmdLogging_ifc, boolean bl) {
        this.report = mainCmdLogging_ifc;
        this.sCommentStart1 = zbnfSyntaxPrescript.sCommentStart1;
        this.sCommentStart2 = zbnfSyntaxPrescript.sCommentStart2;
        this.parent = zbnfSyntaxPrescript;
    }

    private ZbnfSyntaxPrescript(MainCmdLogging_ifc mainCmdLogging_ifc, boolean bl, String string, String string2) {
        this.report = mainCmdLogging_ifc;
        this.sCommentStart1 = string;
        this.sCommentStart2 = string2;
        this.parent = null;
    }

    ZbnfSyntaxPrescript(ZbnfSyntaxPrescript zbnfSyntaxPrescript, EType eType) {
        this.eType = eType;
        this.sCommentStart1 = zbnfSyntaxPrescript == null ? null : zbnfSyntaxPrescript.sCommentStart1;
        this.sCommentStart2 = zbnfSyntaxPrescript == null ? null : zbnfSyntaxPrescript.sCommentStart2;
        this.parent = zbnfSyntaxPrescript;
        this.report = null;
    }

    static ZbnfSyntaxPrescript createWithSyntax(StringPartScan stringPartScan, String string, String string2, MainCmdLogging_ifc mainCmdLogging_ifc) throws ParseException {
        ZbnfSyntaxPrescript zbnfSyntaxPrescript = new ZbnfSyntaxPrescript(mainCmdLogging_ifc, true, string, string2);
        zbnfSyntaxPrescript.convertSyntaxDefinition(stringPartScan);
        return zbnfSyntaxPrescript;
    }

    void getSemantic(StringPartScan stringPartScan) {
        String string;
        boolean bl = true;
        char c = stringPartScan.getCurrentChar();
        if (c == '%') {
            this.bDebugParsing = true;
            c = stringPartScan.seek(1).getCurrentChar();
        }
        if (c == '-') {
            this.bAssignIntoNextComponent = true;
            c = stringPartScan.seek(1).getCurrentChar();
        } else if (c == '+') {
            this.bAddOuterResults = true;
            c = stringPartScan.seek(1).getCurrentChar();
        }
        if (c == '!') {
            stringPartScan.seek(1).lentoIdentifier();
            if (stringPartScan.length() > 0) {
                this.sSubSyntax = stringPartScan.getCurrentPart().toString();
            }
            stringPartScan.fromEnd();
            c = stringPartScan.getCurrentChar();
            if (c == '?') {
                c = stringPartScan.seek(1).getCurrentChar();
            } else {
                bl = false;
            }
        }
        if (bl) {
            if (c == '?') {
                stringPartScan.seek(1);
                string = "@";
            } else {
                stringPartScan.lentoAnyChar("?>");
                string = stringPartScan.length() > 0 ? stringPartScan.getCurrentPart().toString() : null;
                stringPartScan.fromEnd();
            }
        } else {
            string = null;
        }
        this.sSemantic = string;
        if (string != null && string.equals("return")) {
            this.stop();
        }
    }

    void getAttribute(StringPartScan stringPartScan) throws ParseException {
        char c;
        stringPartScan.seekPos(1).lentoIdentifier();
        String string = stringPartScan.getCurrentPart().toString();
        if (string.length() == 0) {
            this.throwParseException(stringPartScan, "semantic attribute identifier expected");
        }
        if ((c = stringPartScan.fromEnd().getCurrentChar()) != '=') {
            this.throwParseException(stringPartScan, "attribute value expected, note: no spaces between @name=value");
        }
        stringPartScan.seekPos(1).lentoAnyChar("?>");
        if (!stringPartScan.found()) {
            this.throwParseException(stringPartScan, "> or ? missed for attribute value");
        }
        StringPart.Part part = stringPartScan.getCurrentPart();
        stringPartScan.fromEnd();
        String string2 = part.length() >= 2 && part.charAt(0) == '\"' ? part.subSequence(1, part.length() - 1).toString() : part.toString();
        if (this.attributes == null) {
            this.attributes = new IndexMultiTable<String, String>(IndexMultiTable.providerString);
        }
        this.attributes.put(string, string2);
    }

    void stop() {
    }

    private void convertSyntaxDefinition(StringPartScan stringPartScan) throws ParseException {
        stringPartScan.setIgnoreWhitespaces(true);
        stringPartScan.setIgnoreEndlineComment("##");
        stringPartScan.seekNoWhitespaceOrComments();
        if (stringPartScan.getCurrentChar() == '?') {
            stringPartScan.getCircumScriptionToAnyCharOutsideQuotion(".");
            stringPartScan.seek(1);
        } else {
            stringPartScan.lentoIdentifier();
            if (stringPartScan.length() > 0) {
                this.sSemantic = this.sDefinitionIdent = stringPartScan.getCurrentPart().toString();
                this.eType = EType.kSyntaxDefinition;
                stringPartScan.fromEnd();
            } else {
                this.throwParseException(stringPartScan, "ZbnfSyntaxPrescript - identifier for prescript expected;");
            }
            if (!stringPartScan.seekNoWhitespace().scan().scan("::=").scanOk()) {
                this.throwParseException(stringPartScan, "::= expected");
            }
            this.convertTheStringGivenSyntax(stringPartScan, ".", true, stringPartScan.getCurrent(20));
        }
    }

    boolean convertAssociatedSemantic(StringPartScan stringPartScan) throws ParseException {
        if (stringPartScan.startsWith("<?")) {
            stringPartScan.seek(2);
            this.getSemantic(stringPartScan);
            if (stringPartScan.getCurrentChar() == '>') {
                stringPartScan.seek(1);
            } else {
                this.throwParseException(stringPartScan, "expected \">\" behind semantic");
            }
            return true;
        }
        return false;
    }

    char convertTheStringGivenSyntax(StringPartScan stringPartScan, String string, boolean bl, CharSequence charSequence) throws ParseException {
        CharSequence charSequence2 = stringPartScan.getCurrent(30);
        if (StringFunctions.startsWith(charSequence2, "\\#\\#")) {
            this.stop();
        }
        this.convertAssociatedSemantic(stringPartScan);
        if (stringPartScan.startsWith("<$NoWhiteSpaces>")) {
            bl = false;
            stringPartScan.seek(16);
        }
        int n = 0;
        this.childSyntaxPrescripts = null;
        int n2 = 0;
        while (n == 0) {
            char c;
            if (++n2 > 1000000) {
                this.stop();
            }
            stringPartScan.seekNoWhitespaceOrComments();
            if (stringPartScan.found() && bl) {
                this.childsAdd(new ZbnfSyntaxPrescript(this, EType.kSkipSpaces));
            }
            CharSequence charSequence3 = stringPartScan.getCurrent(20);
            if (stringPartScan.length() > 0) {
                c = stringPartScan.getCurrentChar();
                if (string.indexOf(c) >= 0) {
                    stringPartScan.seek(1);
                    n = c;
                } else if (c == '\u0003') {
                    n = c;
                }
            } else {
                n = 3;
                c = '\u0000';
            }
            if (n != 0) continue;
            charSequence = null;
            switch (c) {
                case '|': {
                    Object object;
                    stringPartScan.seek(1);
                    CharSequence charSequence4 = stringPartScan.getCurrent(30);
                    if (StringFunctions.startsWith(charSequence4, "|<?return")) {
                        this.stop();
                    }
                    if (this.childSyntaxPrescripts == null) {
                        this.alsoEmptyOption = true;
                        break;
                    }
                    do {
                        char c2;
                        if ((c2 = stringPartScan.getCurrentChar()) == ']') {
                            this.alsoEmptyOption = true;
                            stringPartScan.seek(1);
                            n = 93;
                            continue;
                        }
                        object = new ZbnfSyntaxPrescript(this, this.report, true);
                        n = ((ZbnfSyntaxPrescript)object).convertTheStringGivenSyntax(stringPartScan, string + "|", bl, charSequence3);
                        if (!this.bChildSyntaxAreAlternatives) {
                            ZbnfSyntaxPrescript zbnfSyntaxPrescript = new ZbnfSyntaxPrescript(this, this.report, true);
                            zbnfSyntaxPrescript.childSyntaxPrescripts = this.childSyntaxPrescripts;
                            this.childSyntaxPrescripts = new ArrayList<ZbnfSyntaxPrescript>();
                            this.bChildSyntaxAreAlternatives = true;
                            this.childSyntaxPrescripts.add(zbnfSyntaxPrescript);
                        }
                        this.childSyntaxPrescripts.add((ZbnfSyntaxPrescript)object);
                    } while (n == 124);
                    break;
                }
                case '<': {
                    this.childsAdd(this.convertSyntaxComponent(stringPartScan));
                    break;
                }
                case '[': {
                    this.childsAdd(this.convertOptionSyntax(stringPartScan, bl, charSequence3));
                    break;
                }
                case '{': {
                    this.childsAdd(this.convertRepetitionSyntax(stringPartScan, bl, charSequence3));
                    break;
                }
                case '.': 
                case '>': 
                case '?': 
                case ']': 
                case '}': {
                    this.throwParseException(stringPartScan, "unexpected \"" + c + "\", expected endChars are " + string);
                    break;
                }
                default: {
                    char c3 = stringPartScan.getCurrentChar();
                    Object object = new CharSequence[1];
                    char c4 = c3 == '\"' ? c3 : (char)'\u0000';
                    boolean bl2 = stringPartScan.scanStart().scanToAnyChar((CharSequence[])object, "[|]{?}<>. \r\n\t\f\u0003\u0004", '\\', c4, c4).scanOk();
                    assert (bl2);
                    if (object[0].length() > 0) {
                        String string2 = object[0].toString();
                        ZbnfSyntaxPrescript zbnfSyntaxPrescript = new ZbnfSyntaxPrescript(this, this.report, false);
                        zbnfSyntaxPrescript.eType = string2.startsWith(this.sCommentStart1) || string2.startsWith(this.sCommentStart2) ? EType.kTerminalSymbolInComment : EType.kTerminalSymbol;
                        zbnfSyntaxPrescript.sDefinitionIdent = "i-text";
                        zbnfSyntaxPrescript.sConstantSyntax = string2;
                        this.childsAdd(zbnfSyntaxPrescript);
                        break;
                    }
                    this.throwParseException(stringPartScan, "internal error: any constant syntax expected.");
                }
            }
        }
        if (charSequence != null) {
            throw new ParseException("the syntax in this element is empty, it isn't correct:" + charSequence + stringPartScan.getCurrent(30), 0);
        }
        return (char)n;
    }

    private ComplexSyntax convertSyntaxComponent(StringPartScan stringPartScan) throws ParseException {
        ComplexSyntax complexSyntax = new ComplexSyntax(this, this.report, false);
        stringPartScan.seek(1);
        complexSyntax.convertSyntaxComponent(stringPartScan);
        return complexSyntax;
    }

    private ZbnfSyntaxPrescript convertOptionSyntax(StringPartScan stringPartScan, boolean bl, CharSequence charSequence) throws ParseException {
        ZbnfSyntaxPrescript zbnfSyntaxPrescript = new ZbnfSyntaxPrescript(this, this.report, true);
        stringPartScan.seek(1);
        zbnfSyntaxPrescript.convertAssociatedSemantic(stringPartScan);
        if (stringPartScan.startsWith("?")) {
            stringPartScan.seek(1);
            zbnfSyntaxPrescript.convertTheStringGivenSyntax(stringPartScan, "]", bl, charSequence);
            zbnfSyntaxPrescript.eType = EType.kNegativVariant;
        } else if (stringPartScan.startsWith(">")) {
            stringPartScan.seek(1);
            zbnfSyntaxPrescript.convertTheStringGivenSyntax(stringPartScan, "]", bl, charSequence);
            zbnfSyntaxPrescript.eType = EType.kUnconditionalVariant;
        } else if (stringPartScan.startsWith("!")) {
            stringPartScan.seek(1);
            zbnfSyntaxPrescript.convertTheStringGivenSyntax(stringPartScan, "]", bl, charSequence);
            zbnfSyntaxPrescript.eType = EType.kExpectedVariant;
        } else if (stringPartScan.startsWith("|")) {
            stringPartScan.seek(1);
            zbnfSyntaxPrescript.convertTheStringGivenSyntax(stringPartScan, "]", bl, charSequence);
            zbnfSyntaxPrescript.eType = EType.kAlternativeOptionCheckEmptyFirst;
        } else {
            zbnfSyntaxPrescript.convertTheStringGivenSyntax(stringPartScan, "]", bl, charSequence);
            if (!zbnfSyntaxPrescript.isAlternative()) {
                zbnfSyntaxPrescript.alsoEmptyOption = true;
                zbnfSyntaxPrescript.sDefinitionIdent = "i-simpleOption";
                zbnfSyntaxPrescript.eType = EType.kSimpleOption;
            } else if (zbnfSyntaxPrescript.alsoEmptyOption) {
                zbnfSyntaxPrescript.sDefinitionIdent = "i-alternativeOption";
                zbnfSyntaxPrescript.eType = EType.kAlternativeOption;
            } else {
                zbnfSyntaxPrescript.sDefinitionIdent = "i-alternative";
                zbnfSyntaxPrescript.eType = EType.kAlternative;
            }
        }
        return zbnfSyntaxPrescript;
    }

    private RepetitionSyntax convertRepetitionSyntax(StringPartScan stringPartScan, boolean bl, CharSequence charSequence) throws ParseException {
        RepetitionSyntax repetitionSyntax = new RepetitionSyntax(this, this.report, true);
        stringPartScan.seek(1);
        repetitionSyntax.sDefinitionIdent = "i-Repetition";
        repetitionSyntax.eType = EType.kRepetition;
        char c = repetitionSyntax.convertTheStringGivenSyntax(stringPartScan, "?}", bl, charSequence);
        if (c == '?') {
            repetitionSyntax.backward = new ZbnfSyntaxPrescript(this, this.report, true);
            repetitionSyntax.backward.eType = EType.kRepetitionRepeat;
            repetitionSyntax.backward.sDefinitionIdent = "i-RepetitionRepeat";
            repetitionSyntax.backward.convertTheStringGivenSyntax(stringPartScan, "}", bl, charSequence);
        }
        return repetitionSyntax;
    }

    private void childsAdd(ZbnfSyntaxPrescript zbnfSyntaxPrescript) {
        if (this.childSyntaxPrescripts == null) {
            this.childSyntaxPrescripts = new ArrayList<ZbnfSyntaxPrescript>();
        }
        this.childSyntaxPrescripts.add(zbnfSyntaxPrescript);
    }

    Object xxxgetItem(int n) {
        if (n >= this.childSyntaxPrescripts.size()) {
            return null;
        }
        return this.childSyntaxPrescripts.get(n);
    }

    String getDefinitionIdent() {
        return this.sDefinitionIdent;
    }

    String getSubSyntax() {
        return this.sSubSyntax;
    }

    List<ZbnfSyntaxPrescript> getListPrescripts() {
        return this.childSyntaxPrescripts;
    }

    boolean hasAlternatives() {
        return this.eType == EType.kAlternative || this.eType == EType.kAlternativeOption || this.eType == EType.kAlternativeOptionCheckEmptyFirst;
    }

    void reportContent(MainCmdLogging_ifc mainCmdLogging_ifc, int n) {
        this.reportItem(n, "+-", false, mainCmdLogging_ifc);
    }

    private void reportItem(int n, String string, boolean bl, MainCmdLogging_ifc mainCmdLogging_ifc) {
        String string2 = this.toString();
        mainCmdLogging_ifc.reportln(n, 0, "SyntaxPrescript:" + string + string2);
        if (this.childSyntaxPrescripts != null) {
            String string3 = string.substring(0, string.length() - 2) + (bl ? "| " : "  ");
            for (ZbnfSyntaxPrescript zbnfSyntaxPrescript : this.childSyntaxPrescripts) {
                zbnfSyntaxPrescript.reportItem(n, string3 + "+-", false, mainCmdLogging_ifc);
            }
        }
    }

    String getConstantSyntax() {
        return this.sConstantSyntax;
    }

    List<String> getListStrings() {
        return this.listStrings;
    }

    String getSemantic() {
        return this.sSemantic;
    }

    String getIndentChars() {
        return this.sIndentChars;
    }

    double getFloatFactor() {
        return this.nFloatFactor;
    }

    boolean isResultToAssignIntoNextComponent() {
        return this.bAssignIntoNextComponent;
    }

    boolean isToAddOuterResults() {
        return this.bAddOuterResults;
    }

    boolean isAlternative() {
        return this.bChildSyntaxAreAlternatives;
    }

    int getMaxNrofCharsFromComplexItem() {
        if (this instanceof ComplexSyntax) {
            int n = ((ComplexSyntax)this).nMaxChars;
            return n;
        }
        return -1;
    }

    Pattern getRegexPatternFromComplexItem() {
        if (this instanceof ComplexSyntax) {
            return ((ComplexSyntax)this).regex;
        }
        return null;
    }

    EType getType() {
        return this.eType;
    }

    ZbnfSyntaxPrescript xxxgetSyntaxPrescript() {
        return null;
    }

    boolean isPossibleEmptyOption() {
        return this.alsoEmptyOption;
    }

    ZbnfSyntaxPrescript xxxgetRepetitionForwardPrescript() {
        return null;
    }

    ZbnfSyntaxPrescript getRepetitionBackwardPrescript() {
        if (this instanceof RepetitionSyntax) {
            return ((RepetitionSyntax)this).backward;
        }
        return null;
    }

    public String getAttribute(String string) {
        return this.attributes == null ? null : this.attributes.get(string);
    }

    public String toString() {
        String string;
        StringBuilder stringBuilder = new StringBuilder(50);
        if (this.eType == null) {
            string = "?-0-?";
        } else {
            switch (this.eType) {
                case kSyntaxDefinition: {
                    string = "!" + this.getDefinitionIdent() + "::=";
                    break;
                }
                case kTerminalSymbol: {
                    string = ":" + this.sConstantSyntax;
                    break;
                }
                case kSimpleOption: {
                    string = "[...]";
                    break;
                }
                case kAlternativeOption: {
                    string = "[...|...|]";
                    break;
                }
                case kAlternativeOptionCheckEmptyFirst: {
                    string = "[|...|...]";
                    break;
                }
                case kNegativVariant: {
                    string = "[?...|...]";
                    break;
                }
                case kUnconditionalVariant: {
                    string = "[>...|...]";
                    break;
                }
                case kExpectedVariant: {
                    string = "[!...|...]";
                    break;
                }
                case kAlternative: {
                    string = "...|...";
                    break;
                }
                case kRepetition: {
                    string = "{...}";
                    break;
                }
                case kOnlySemantic: {
                    string = "<?";
                    break;
                }
                case kSyntaxComponent: {
                    string = "<" + this.getDefinitionIdent();
                    break;
                }
                case kIdentifier: {
                    string = "<$" + this.getConstantSyntax();
                    break;
                }
                case kRegularExpression: {
                    string = "<!" + this.getConstantSyntax();
                    break;
                }
                case kStringUntilEndchar: {
                    string = "<*C " + this.getConstantSyntax();
                    break;
                }
                case kStringUntilEndcharOutsideQuotion: {
                    string = "<*\"\" " + this.getConstantSyntax();
                    break;
                }
                case kStringUntilEndStringInclusive: {
                    string = "<*+| " + this.getConstantSyntax();
                    break;
                }
                case kStringUntilRightEndchar: {
                    string = "<stringtolastExclChar" + this.getConstantSyntax();
                    break;
                }
                case kStringUntilRightEndcharInclusive: {
                    string = "<stringtolastinclChar" + this.getConstantSyntax();
                    break;
                }
                case kQuotedString: {
                    string = "<\"\" " + this.getConstantSyntax();
                    break;
                }
                case kStringUntilEndString: {
                    string = "<*| " + this.sConstantSyntax;
                    break;
                }
                case kStringUntilEndStringWithIndent: {
                    string = "<+++* " + this.sConstantSyntax;
                    break;
                }
                case kPositivNumber: {
                    string = "<#";
                    break;
                }
                case kIntegerNumber: {
                    string = "<#-";
                    break;
                }
                case kHexNumber: {
                    string = "<#x";
                    break;
                }
                case kFloatNumber: {
                    string = "<#f";
                    break;
                }
                case kFloatWithFactor: {
                    string = "<#f*" + this.nFloatFactor;
                    break;
                }
                case kSkipSpaces: {
                    string = "\\n\\t";
                    break;
                }
                case kNotDefined: {
                    string = "?-0-?";
                    break;
                }
                default: {
                    string = "?-?-?";
                }
            }
        }
        stringBuilder.append(string);
        string = this.getSemantic();
        if (string != null) {
            if (stringBuilder.charAt(0) != '<') {
                stringBuilder.append("<");
            }
            stringBuilder.append("?").append(string).append(">");
        } else if (stringBuilder.charAt(0) == '<') {
            stringBuilder.append(">");
        }
        for (int i = 0; i < stringBuilder.length(); ++i) {
            char c = stringBuilder.charAt(i);
            if (c == '\n') {
                stringBuilder.replace(i, i + 1, "\\n");
            }
            if (c != '\r') continue;
            stringBuilder.replace(i, i + 1, "\\r");
        }
        return stringBuilder.toString();
    }

    protected void throwParseException(StringPartScan stringPartScan, String string) throws ParseException {
        throw new ParseException(string + ", found: " + stringPartScan.getCurrent(60), stringPartScan.getLineAndColumn(null));
    }

    private static class RepetitionSyntax
    extends ZbnfSyntaxPrescript {
        ZbnfSyntaxPrescript backward;

        RepetitionSyntax(ZbnfSyntaxPrescript zbnfSyntaxPrescript, MainCmdLogging_ifc mainCmdLogging_ifc, boolean bl) {
            super(zbnfSyntaxPrescript, mainCmdLogging_ifc, bl);
        }
    }

    private static class ComplexSyntax
    extends ZbnfSyntaxPrescript {
        int nMaxChars = Integer.MAX_VALUE;
        Pattern regex = null;

        ComplexSyntax(ZbnfSyntaxPrescript zbnfSyntaxPrescript, MainCmdLogging_ifc mainCmdLogging_ifc, boolean bl) {
            super(zbnfSyntaxPrescript, mainCmdLogging_ifc, bl);
        }

        void convertSyntaxComponent(StringPartScan stringPartScan) throws ParseException {
            boolean bl;
            String string;
            EType eType;
            String string2;
            char c = stringPartScan.getCurrentChar();
            if (c >= '0' && c <= '9') {
                this.nMaxChars = 0;
                do {
                    this.nMaxChars = 10 * this.nMaxChars + (c - 48);
                    stringPartScan.seek(1);
                } while ((c = stringPartScan.getCurrentChar()) >= '0' && c <= '9');
            }
            if ((c = (string2 = stringPartScan.getCurrentPart().toString()).charAt(0)) == '#') {
                c = stringPartScan.seek(1).getCurrentChar();
                switch (c) {
                    case 'X': {
                        eType = EType.kHexNumber;
                        string = "i-HexNumber";
                        stringPartScan.seek(1);
                        break;
                    }
                    case 'x': {
                        eType = EType.kHexNumber;
                        string = "i-HexNumber";
                        stringPartScan.seek(1);
                        break;
                    }
                    case '-': {
                        eType = EType.kIntegerNumber;
                        string = "i-IntegerNumber";
                        stringPartScan.seek(1);
                        break;
                    }
                    case 'f': {
                        eType = EType.kFloatNumber;
                        string = "i-FloatNumber";
                        stringPartScan.seek(1);
                        if (stringPartScan.scanStart().scan("*").scanFloatNumber().scanOk()) {
                            this.nFloatFactor = stringPartScan.getLastScannedFloatNumber();
                            eType = EType.kFloatWithFactor;
                            string = "i-FloatFactor(" + this.nFloatFactor + ")";
                            break;
                        }
                        eType = EType.kFloatNumber;
                        string = "i-FloatNumber";
                        break;
                    }
                    default: {
                        eType = EType.kPositivNumber;
                        string = "i-PositivNumber";
                        break;
                    }
                }
            } else if (c == '$') {
                eType = EType.kIdentifier;
                string = "i-Identifier";
                stringPartScan.seek(1);
                this.sConstantSyntax = stringPartScan.getCircumScriptionToAnyChar("?>").toString();
            } else if (c == '!') {
                eType = EType.kRegularExpression;
                string = "i-RegularExpression";
                stringPartScan.seek(1);
                this.sConstantSyntax = stringPartScan.getCircumScriptionToAnyChar("?>").toString();
                try {
                    this.regex = Pattern.compile(this.sConstantSyntax);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw new ParseException("failed regex syntax:" + this.sConstantSyntax, 0);
                }
            } else if (string2.startsWith("*|")) {
                eType = EType.kStringUntilEndString;
                string = "i-StringUntilEndString";
                stringPartScan.seek(2);
                this.listStrings = new LinkedList();
                bl = true;
                while (bl) {
                    this.sConstantSyntax = stringPartScan.getCircumScriptionToAnyChar("|?>").toString();
                    this.listStrings.add(this.sConstantSyntax);
                    if (stringPartScan.getCurrentChar() == '|') {
                        stringPartScan.seek(1);
                        continue;
                    }
                    bl = false;
                }
            } else if (string2.startsWith("* |")) {
                eType = EType.kStringUntilEndStringTrim;
                string = "i-StringUntilEndStringTrim";
                stringPartScan.seek(3);
                this.listStrings = new LinkedList();
                bl = true;
                while (bl) {
                    CharSequence[] charSequenceArray = new CharSequence[1];
                    if (stringPartScan.scanStart().scanToAnyChar(charSequenceArray, "|?>", '\\', '\u0000', '\u0000').scanOk()) {
                        this.sConstantSyntax = charSequenceArray[0].toString();
                        this.listStrings.add(this.sConstantSyntax);
                        if (stringPartScan.getCurrentChar() == '|') {
                            stringPartScan.seek(1);
                            continue;
                        }
                        bl = false;
                        continue;
                    }
                    this.throwParseException(stringPartScan, "ZbnfSyntaxPrescript.convertSyntaxComponent - <* |...argument error");
                }
            } else if (string2.startsWith("+|")) {
                eType = EType.kStringUntilEndStringInclusive;
                string = "i-StringUntilEndStringInclusive";
                stringPartScan.seek(2);
                this.listStrings = new LinkedList();
                bl = true;
                while (bl) {
                    this.sConstantSyntax = stringPartScan.getCircumScriptionToAnyChar("|?>").toString();
                    this.listStrings.add(this.sConstantSyntax);
                    if (stringPartScan.getCurrentChar() == '|') {
                        stringPartScan.seek(1);
                        continue;
                    }
                    bl = false;
                }
            } else if (string2.startsWith("*<<")) {
                eType = EType.kStringUntilRightEndchar;
                string = "i-StringUntilRightEndChar";
                stringPartScan.seek(3);
                this.sConstantSyntax = stringPartScan.getCircumScriptionToAnyChar("?>").toString();
            } else if (string2.startsWith("stringtolastExclChar")) {
                eType = EType.kStringUntilRightEndchar;
                string = "i-StringUntilRightEndChar";
                stringPartScan.seek(20);
                this.sConstantSyntax = stringPartScan.getCircumScriptionToAnyChar("?>").toString();
            } else if (string2.startsWith("toLastChar:")) {
                eType = EType.kStringUntilRightEndchar;
                string = "i-StringUntilRightEndChar";
                stringPartScan.seek(11);
                this.sConstantSyntax = stringPartScan.getCircumScriptionToAnyChar("?>").toString();
            } else if (string2.startsWith("+<<")) {
                eType = EType.kStringUntilRightEndcharInclusive;
                string = "i-StringUntilRightEndCharInclusive";
                stringPartScan.seek(3);
                this.sConstantSyntax = stringPartScan.getCircumScriptionToAnyChar("?>").toString();
            } else if (string2.startsWith("stringtolastinclChar")) {
                eType = EType.kStringUntilRightEndcharInclusive;
                string = "i-StringUntilRightEndCharInclusive";
                stringPartScan.seek(20);
                this.sConstantSyntax = stringPartScan.getCircumScriptionToAnyChar("?>").toString();
            } else if (string2.startsWith("toLastCharIncl:")) {
                eType = EType.kStringUntilRightEndcharInclusive;
                string = "i-StringUntilRightEndCharInclusive";
                stringPartScan.seek(15);
                this.sConstantSyntax = stringPartScan.getCircumScriptionToAnyChar("?>").toString();
            } else if (string2.startsWith("*{")) {
                stringPartScan.seek(2);
                this.sIndentChars = stringPartScan.getCircumScriptionToAnyChar("}").toString();
                if (!stringPartScan.found()) {
                    this.throwParseException(stringPartScan, "\"}\"expected");
                }
                stringPartScan.seek(1);
                c = stringPartScan.getCurrentChar();
                if (c == '|') {
                    eType = EType.kStringUntilEndStringWithIndent;
                    string = "i-StringUntilEndStringWithIndent";
                    stringPartScan.seek(1);
                    this.listStrings = new LinkedList();
                    bl = true;
                    while (bl) {
                        this.sConstantSyntax = stringPartScan.getCircumScriptionToAnyChar("|?>").toString();
                        this.listStrings.add(this.sConstantSyntax);
                        if (stringPartScan.getCurrentChar() == '|') {
                            stringPartScan.seek(1);
                            continue;
                        }
                        bl = false;
                    }
                } else {
                    eType = EType.kStringUntilEndcharWithIndent;
                    string = "i-StringUntilEndcharWithIndent";
                    stringPartScan.seek(1);
                    this.sConstantSyntax = stringPartScan.getCircumScriptionToAnyChar("?>").toString();
                }
            } else if (string2.startsWith("*\"\"")) {
                eType = EType.kStringUntilEndcharOutsideQuotion;
                string = "i-StringUntilEndcharOutsideQuotion";
                stringPartScan.seek(3);
                this.sConstantSyntax = stringPartScan.getCircumScriptionToAnyChar("?>").toString();
            } else if (c == '*') {
                eType = EType.kStringUntilEndchar;
                string = "i-StringUntilEndChar";
                stringPartScan.seek(1);
                this.sConstantSyntax = stringPartScan.getCircumScriptionToAnyChar("?>").toString();
            } else if (c == '+') {
                eType = EType.kStringUntilEndcharInclusive;
                string = "i-StringUntilEndCharInclusive";
                stringPartScan.seek(1);
                this.sConstantSyntax = stringPartScan.getCircumScriptionToAnyChar("?>").toString();
            } else if (string2.startsWith("\"\"")) {
                eType = EType.kQuotedString;
                this.sConstantSyntax = "\"\"";
                string = "i-QuotedString";
                stringPartScan.seek(2);
            } else if (string2.startsWith("''")) {
                eType = EType.kQuotedString;
                string = "i-QuotedString";
                this.sConstantSyntax = "''";
                stringPartScan.seek(2);
            } else if (c == '?') {
                eType = EType.kOnlySemantic;
                string = "i-Semantic";
            } else {
                stringPartScan.lentoIdentifier();
                if (stringPartScan.length() > 0) {
                    eType = EType.kSyntaxComponent;
                    string = stringPartScan.getCurrentPart().toString();
                    stringPartScan.fromEnd();
                } else {
                    string = null;
                    eType = EType.kOnlySemantic;
                }
            }
            this.sDefinitionIdent = string;
            this.eType = eType;
            this.sSemantic = "@";
            while ((c = stringPartScan.getCurrentChar()) == '?') {
                stringPartScan.seekPos(1);
                if (stringPartScan.getCurrentChar() == '.') {
                    this.getAttribute(stringPartScan);
                    continue;
                }
                this.getSemantic(stringPartScan);
            }
            c = stringPartScan.getCurrentChar();
            if (c == '>') {
                stringPartScan.seek(1);
            } else {
                this.throwParseException(stringPartScan, "\">\" expected");
            }
        }
    }

    static enum EType {
        kNotDefined(0),
        kSyntaxDefinition(1),
        kTerminalSymbol(2),
        kTerminalSymbolInComment(47),
        kSkipSpaces(3),
        kAlternative(4),
        kAlternativeOption(5),
        kAlternativeOptionCheckEmptyFirst(6),
        kSimpleOption(7),
        kNegativVariant(8),
        kUnconditionalVariant(62),
        kExpectedVariant(33),
        kRepetition(9, '{'),
        kRepetitionRepeat(10),
        kOnlySemantic(11),
        kSyntaxComponent(12, '='),
        kFloatWithFactor(15, 'F'),
        kPositivNumber(16, 'I'),
        kIntegerNumber(17, 'I'),
        kHexNumber(18, 'I'),
        kFloatNumber(19, 'F'),
        kIdentifier(20, 's'),
        kStringUntilEndString(21, 's'),
        kStringUntilEndchar(22, 's'),
        kStringUntilEndcharOutsideQuotion(23, 's'),
        kStringUntilEndcharWithIndent(24, '\t'),
        kStringUntilEndStringWithIndent(25, '\t'),
        kQuotedString(26, 's'),
        kStringUntilRightEndchar(27, 's'),
        kRegularExpression(28, 's'),
        kStringUntilEndStringTrim(37, 's'),
        kStringUntilEndStringInclusive(53, 's'),
        kStringUntilEndcharInclusive(54, 's'),
        kStringUntilRightEndcharInclusive(59, 's');

        int k;
        char type;

        private EType(int n2, char c) {
            this.k = n2;
            this.type = c;
        }

        private EType(int n2) {
            this.k = n2;
            this.type = '\u0000';
        }
    }
}

