/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.xmlReader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.vishia.util.Assert;
import org.vishia.util.DataAccess;
import org.vishia.util.Debugutil;
import org.vishia.util.FileSystem;
import org.vishia.util.IndexMultiTable;
import org.vishia.util.StringFunctions;
import org.vishia.util.StringPart;
import org.vishia.util.StringPartFromFileLines;
import org.vishia.xmlReader.XmlCfg;

public class XmlJzReader {
    public static final String version = "2018-08-15";
    XmlCfg cfg = new XmlCfg();
    final XmlCfg cfgCfg;
    int sizeBuffer = 20000;
    int debugStopLine = -1;
    Map<String, String> namespaces = new IndexMultiTable<String, String>(IndexMultiTable.providerString);

    public XmlJzReader() {
        this.cfgCfg = XmlCfg.newCfgCfg();
    }

    public void setDebugStop(int n) {
        this.debugStopLine = n;
    }

    public void XXXXreadXmlCfg(File file) {
        this.cfg = new XmlCfg();
    }

    public String readXml(File file, Object object, XmlCfg xmlCfg) {
        String string = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            String string2 = FileSystem.normalizePath(file.getAbsoluteFile()).toString();
            string = this.readXml(fileInputStream, string2, object, xmlCfg);
            ((InputStream)fileInputStream).close();
        }
        catch (IOException iOException) {
            string = "XmlReader.readXml(...) file not found: " + file.getAbsolutePath();
        }
        return string;
    }

    public String readZipXml(File file, String string, Object object) {
        String string2 = null;
        try {
            ZipFile zipFile = new ZipFile(file);
            ZipEntry zipEntry = zipFile.getEntry(string);
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            String string3 = file.getAbsolutePath() + ":" + string;
            string2 = this.readXml(inputStream, string3, object, this.cfg);
            inputStream.close();
            zipFile.close();
        }
        catch (Exception exception) {
            string2 = exception.getMessage();
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readXml(InputStream inputStream, String string, Object object, XmlCfg xmlCfg) {
        String string2 = null;
        try (StringPartFromFileLines stringPartFromFileLines = null;){
            stringPartFromFileLines = new StringPartFromFileLines(inputStream, string, this.sizeBuffer, "encoding", null);
            this.readXml(stringPartFromFileLines, object, xmlCfg);
        }
        return string2;
    }

    private void readXml(StringPartFromFileLines stringPartFromFileLines, Object object, XmlCfg xmlCfg) throws Exception {
        stringPartFromFileLines.setIgnoreWhitespaces(true);
        stringPartFromFileLines.seekEnd("<");
        if (stringPartFromFileLines.scan("?").scanOk()) {
            stringPartFromFileLines.seekEnd("?>");
            stringPartFromFileLines.scanOk();
        }
        while (stringPartFromFileLines.seekEnd("<").found()) {
            stringPartFromFileLines.scanOk();
            stringPartFromFileLines.readnextContentFromFile(this.sizeBuffer / 2);
            if (stringPartFromFileLines.scan().scan("!--").scanOk()) {
                stringPartFromFileLines.seekEnd("-->");
                continue;
            }
            this.parseElement(stringPartFromFileLines, object, xmlCfg.rootNode);
        }
        Debugutil.stop();
    }

    private void parseElement(StringPartFromFileLines stringPartFromFileLines, Object object, XmlCfg.XmlCfgNode xmlCfgNode) throws Exception {
        XmlCfg.XmlCfgNode xmlCfgNode2;
        Object object2;
        int n;
        if (this.debugStopLine >= 0 && (n = stringPartFromFileLines.getLineAndColumn(null)) >= this.debugStopLine) {
            Debugutil.stop();
        }
        if (!stringPartFromFileLines.scanIdentifier(null, "-:").scanOk()) {
            throw new IllegalArgumentException("tag name expected");
        }
        CharSequence charSequence = stringPartFromFileLines.getLastScannedString();
        if (charSequence.equals("Object")) {
            Debugutil.stop();
        }
        if (xmlCfgNode == null) {
            object2 = null;
            xmlCfgNode2 = null;
        } else {
            Assert.check(object != null);
            if (charSequence.toString().startsWith("Object@")) {
                Debugutil.stop();
            }
            if (xmlCfgNode.subnodes == null) {
                xmlCfgNode2 = null;
            } else {
                xmlCfgNode2 = xmlCfgNode.subnodes.get(charSequence);
                if (xmlCfgNode2 == null) {
                    xmlCfgNode2 = xmlCfgNode.subnodes.get("?");
                }
            }
            if (xmlCfgNode2 != null && xmlCfgNode2.bStoreAttribsInNewContent) {
                object2 = this.getDataForTheElement(object, xmlCfgNode2, charSequence, null);
                if (object2 == null) {
                    Debugutil.stop();
                }
            } else {
                object2 = null;
            }
        }
        Map[] mapArray = new Map[1];
        CharSequence charSequence2 = this.parseAttributes(stringPartFromFileLines, charSequence, object2, xmlCfgNode2, mapArray);
        if (xmlCfgNode2 != null && !xmlCfgNode2.bStoreAttribsInNewContent && (object2 = this.getDataForTheElement(object, xmlCfgNode2, charSequence, mapArray)) == null) {
            Debugutil.stop();
        }
        if (object2 == null) {
            Debugutil.stop();
        }
        if (charSequence2 == null) {
            object2 = null;
        } else if (charSequence2.length() > 0) {
            xmlCfgNode2 = xmlCfgNode.subnodes == null ? null : xmlCfgNode.subnodes.get(charSequence2);
            Object object3 = object2 = xmlCfgNode2 == null ? null : this.getDataForTheElement(object, xmlCfgNode2, charSequence2, mapArray);
        }
        if (object2 == null && xmlCfgNode2 != null) {
            Debugutil.stop();
        }
        if (!stringPartFromFileLines.scan("/").scan(">").scanOk()) {
            if (stringPartFromFileLines.scan(">").scanOk()) {
                StringBuilder stringBuilder = null;
                while (!stringPartFromFileLines.scan().scan("<").scan("/").scanOk()) {
                    stringPartFromFileLines.readnextContentFromFile(this.sizeBuffer / 2);
                    if (stringPartFromFileLines.scan("<").scanOk()) {
                        if (stringPartFromFileLines.scan("!--").scanOk()) {
                            stringPartFromFileLines.seekEnd("-->");
                            continue;
                        }
                        this.parseElement(stringPartFromFileLines, object2, xmlCfgNode2);
                        continue;
                    }
                    if (stringBuilder == null && object2 != null) {
                        stringBuilder = new StringBuilder(500);
                    }
                    this.parseContent(stringPartFromFileLines, stringBuilder);
                }
                stringPartFromFileLines.readnextContentFromFile(this.sizeBuffer / 2);
                if (!stringPartFromFileLines.scanIdentifier(null, "-:").scanOk()) {
                    throw new IllegalArgumentException("</tag expected");
                }
                stringPartFromFileLines.setLengthMax();
                if (!stringPartFromFileLines.scan(">").scanOk()) {
                    throw new IllegalArgumentException("</tag > expected");
                }
                if (stringBuilder != null && object2 != null) {
                    this.storeContent(stringBuilder, xmlCfgNode2, object2, mapArray);
                }
            } else {
                throw new IllegalArgumentException("either \">\" or \"/>\" expected");
            }
        }
        stringPartFromFileLines.setLengthMax();
    }

    private CharSequence parseAttributes(StringPartFromFileLines stringPartFromFileLines, CharSequence charSequence, Object object, XmlCfg.XmlCfgNode xmlCfgNode, Map<String, String>[] mapArray) throws Exception {
        CharSequence charSequence2 = "";
        StringBuilder stringBuilder = null;
        while (stringPartFromFileLines.scanIdentifier(null, "-:").scan("=").scanOk()) {
            CharSequence charSequence3 = stringPartFromFileLines.getLastScannedString();
            if (!stringPartFromFileLines.scanQuotion("\"", "\"", null).scanOk()) {
                throw new IllegalArgumentException("attr value expected");
            }
            if (xmlCfgNode != null) {
                Object object2;
                Object object3;
                String string = stringPartFromFileLines.getLastScannedString().toString();
                int n = StringFunctions.indexOf(charSequence3, ':');
                if (n >= 0) {
                    String string2;
                    object3 = charSequence3.subSequence(0, n);
                    CharSequence charSequence4 = charSequence3.subSequence(n + 1, charSequence3.length());
                    if (StringFunctions.equals((CharSequence)object3, "xmlns")) {
                        string2 = string.toString();
                        this.namespaces.put(charSequence4.toString(), string2);
                        object2 = null;
                    } else {
                        String string3;
                        string2 = this.namespaces.get(object3);
                        object2 = string2 == null ? null : (xmlCfgNode.cfg.xmlnsAssign != null ? ((string3 = xmlCfgNode.cfg.xmlnsAssign.get(string2)) == null ? null : string3 + ":" + charSequence4) : charSequence3);
                    }
                } else {
                    object2 = charSequence3;
                }
                if (object2 != null) {
                    object3 = null;
                    if (xmlCfgNode.attribs != null && (object3 = xmlCfgNode.attribs.get(object2)) == null) {
                        object3 = xmlCfgNode.attribs.get("?");
                    }
                    if (object3 != null) {
                        if (((XmlCfg.AttribDstCheck)object3).bUseForCheck) {
                            if (stringBuilder == null) {
                                stringBuilder = new StringBuilder(64);
                                stringBuilder.append(charSequence);
                                charSequence2 = stringBuilder;
                            }
                            stringBuilder.append("@").append((CharSequence)object2).append("=\"").append(string).append("\"");
                        } else if (((XmlCfg.AttribDstCheck)object3).daccess != null) {
                            this.storeAttrData(object, ((XmlCfg.AttribDstCheck)object3).daccess, (CharSequence)object2, string);
                        } else if (((XmlCfg.AttribDstCheck)object3).storeInMap != null) {
                            if (mapArray[0] == null) {
                                mapArray[0] = new TreeMap<String, String>();
                            }
                            mapArray[0].put(((XmlCfg.AttribDstCheck)object3).storeInMap, string);
                        }
                    } else if (xmlCfgNode.attribsUnspec != null) {
                        this.storeAttrData(object, xmlCfgNode.attribsUnspec, (CharSequence)object2, string);
                    }
                }
            }
            stringPartFromFileLines.readnextContentFromFile(this.sizeBuffer / 2);
        }
        return charSequence2;
    }

    Object getDataForTheElement(Object object, XmlCfg.XmlCfgNode xmlCfgNode, CharSequence charSequence, Map<String, String>[] mapArray) {
        Object object2;
        if (xmlCfgNode.elementStorePath == null) {
            object2 = object;
        } else {
            try {
                int n = xmlCfgNode.elementStorePath.nrArgNames();
                if (n > 0) {
                    Object[] objectArray = new Object[n];
                    for (int i = 0; i < n; ++i) {
                        String string = xmlCfgNode.elementStorePath.argName(i);
                        if (mapArray != null && mapArray[0] != null && (objectArray[i] = mapArray[0].get(string)) != null) continue;
                        if (string.equals("tag")) {
                            objectArray[i] = charSequence;
                            continue;
                        }
                        throw new IllegalArgumentException("faulty argnument: " + string + " in elementStorePath for: " + charSequence);
                    }
                    object2 = DataAccess.invokeMethod(xmlCfgNode.elementStorePath, null, object, true, false, objectArray);
                } else {
                    object2 = DataAccess.access(xmlCfgNode.elementStorePath, object, true, false, false, null);
                }
                if (object2 == null) {
                    System.err.println("getDataForTheElement \"" + xmlCfgNode.elementStorePath + "\" returns null");
                }
            }
            catch (Exception exception) {
                object2 = null;
                CharSequence charSequence2 = Assert.exceptionInfo("", exception, 1, 30);
                System.err.println("error getDataForTheElement: " + xmlCfgNode.elementStorePath);
                System.err.println("help: ");
                System.err.println(charSequence2);
            }
        }
        return object2;
    }

    void storeAttrData(Object object, DataAccess.DatapathElement datapathElement, CharSequence charSequence, CharSequence charSequence2) {
        try {
            int n = datapathElement.nrArgNames();
            if (n > 0) {
                Object[] objectArray = new Object[n];
                for (int i = 0; i < n; ++i) {
                    String string = datapathElement.argName(i);
                    if (string.equals("name")) {
                        objectArray[i] = charSequence;
                        continue;
                    }
                    if (string.equals("value")) {
                        objectArray[i] = charSequence2;
                        continue;
                    }
                    throw new IllegalArgumentException("argname");
                }
                DataAccess.invokeMethod(datapathElement, null, object, true, false, objectArray);
            } else {
                DataAccess.storeValue(datapathElement, object, (Object)charSequence2, true);
            }
        }
        catch (Exception exception) {
            System.err.println("error storeAttrData: " + exception.getMessage());
        }
    }

    private void setOutputAttr(Object object, DataAccess.DatapathElement datapathElement, CharSequence charSequence, CharSequence charSequence2) {
        if (datapathElement.equals("@") && object instanceof Map) {
            Map map = (Map)object;
            map.put("@" + charSequence, charSequence2.toString());
        }
    }

    private void parseContent(StringPartFromFileLines stringPartFromFileLines, StringBuilder stringBuilder) throws IOException {
        boolean bl;
        int n = stringBuilder == null ? 0 : stringBuilder.length() - 1;
        stringPartFromFileLines.seekNoWhitespace();
        boolean bl2 = false;
        do {
            stringPartFromFileLines.lento('<');
            boolean bl3 = bl = !stringPartFromFileLines.found();
            if (bl) {
                if (bl2) {
                    throw new IllegalArgumentException("Format error in XML file, missing \"<\", file: " + stringPartFromFileLines.getInputfile());
                }
                stringPartFromFileLines.setLengthMax();
            } else {
                stringPartFromFileLines.lenBacktoNoWhiteSpaces();
            }
            StringPart.Part part = stringPartFromFileLines.getCurrentPart();
            stringPartFromFileLines.fromEnd();
            if (stringBuilder != null && stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            if (stringBuilder != null) {
                stringBuilder.append(part);
            }
            bl2 = stringPartFromFileLines.readnextContentFromFile(this.sizeBuffer / 2);
        } while (bl);
        if (stringBuilder != null) {
            while ((n = stringBuilder.indexOf("&", n + 1)) >= 0) {
                if (StringFunctions.startsWith(stringBuilder, n + 1, n + 4, "lt;")) {
                    stringBuilder.replace(n, n + 4, "<");
                    continue;
                }
                if (StringFunctions.startsWith(stringBuilder, n + 1, n + 4, "gt;")) {
                    stringBuilder.replace(n, n + 4, ">");
                    continue;
                }
                if (StringFunctions.startsWith(stringBuilder, n + 1, n + 4, "amp;")) {
                    stringBuilder.replace(n, n + 4, "&");
                    continue;
                }
                if (!StringFunctions.startsWith(stringBuilder, n + 1, n + 4, "auml;")) continue;
                stringBuilder.replace(n, n + 4, "\u00e4");
            }
        }
    }

    private void storeContent(StringBuilder stringBuilder, XmlCfg.XmlCfgNode xmlCfgNode, Object object, Map<String, String>[] mapArray) {
        DataAccess.DatapathElement datapathElement = xmlCfgNode.contentStorePath;
        if (datapathElement != null) {
            try {
                int n = datapathElement.nrArgNames();
                if (n > 0) {
                    Object[] objectArray = new Object[n];
                    for (int i = 0; i < n; ++i) {
                        String string = datapathElement.argName(i);
                        if (mapArray[0] != null && (objectArray[i] = mapArray[0].get(string)) != null) continue;
                        if (string.equals("text")) {
                            objectArray[i] = stringBuilder;
                            continue;
                        }
                        throw new IllegalArgumentException("argname");
                    }
                    DataAccess.invokeMethod(datapathElement, null, object, true, false, objectArray);
                } else {
                    DataAccess.storeValue(datapathElement, object, (Object)stringBuilder, true);
                }
            }
            catch (Exception exception) {
                System.err.println("error storeContent: " + exception.getMessage());
            }
        }
    }

    public void readCfg(File file) {
        this.readXml(file, (Object)this.cfg.rootNode, this.cfgCfg);
        this.cfg.transferNamespaceAssignment(this.namespaces);
    }

    public void readCfgFromJar(String string) throws IOException {
        String string2 = "jar:" + string;
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(string);
        if (inputStream == null) {
            throw new FileNotFoundException(string2);
        }
        this.readXml(inputStream, string2, this.cfg.rootNode, this.cfgCfg);
        inputStream.close();
        this.cfg.transferNamespaceAssignment(this.namespaces);
    }

    public void readXml(File file, Object object) {
        this.readXml(file, object, this.cfg);
    }
}

