/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.util;

import org.vishia.bridgeC.IllegalArgumentExceptionJc;
import org.vishia.util.Debugutil;
import org.vishia.util.Java4C;
import org.vishia.util.StringFunctions;
import org.vishia.util.StringPartScan;

public class StringPart
implements CharSequence,
Comparable<CharSequence> {
    public static final String sVersion = "2016-09-04";
    protected int begin;
    protected int end;
    protected int begiMin;
    protected int endMax;
    protected CharSequence content;
    protected boolean bCurrentOk = true;
    protected boolean bStartScan = true;
    protected int beginLast;
    protected int endLast;
    boolean bFound = true;
    public static final int seekEnd = 1;
    private static final int mSeekBackward_ = 16;
    private static final int mSeekToLeft_ = 64;
    public static final int seekToLeft = 80;
    public static final int seekBack = 48;
    public static final int seekNormal = 0;
    protected int bitMode = 0;
    protected static final int mSkipOverWhitespace_mode = 1;
    protected static final int mSkipOverCommentInsideText_mode = 2;
    protected static final int mSkipOverCommentToEol_mode = 4;
    String sFile;
    String sCommentStart = "/*";
    String sCommentEnd = "*/";
    String sCommentToEol = "//";

    public StringPart() {
        this.content = null;
        this.beginLast = 0;
        this.begin = 0;
        this.begiMin = 0;
        this.end = 0;
        this.endMax = 0;
        this.endLast = 0;
    }

    public StringPart(CharSequence charSequence) {
        this(charSequence, 0, charSequence.length());
    }

    public StringPart(CharSequence charSequence, int n, int n2) {
        this.begiMin = this.begin = n;
        this.endMax = this.end = n2;
        this.content = charSequence;
        assert (n2 <= this.content.length());
    }

    public final void setInputfile(String string) {
        this.sFile = string;
    }

    @Java4C.Retinline
    @Java4C.ReturnThis
    public final StringPart assign(CharSequence charSequence) {
        this.content = charSequence;
        this.setParttoMax();
        return this;
    }

    public final StringPart assignReplaceEnv(StringBuilder stringBuilder) {
        int n = 0;
        int n2 = stringBuilder.length();
        while ((n = stringBuilder.indexOf("$", n)) >= 0) {
            int n3;
            int n4;
            int n5;
            if (stringBuilder.charAt(n + 1) == '(') {
                n5 = n + 2;
                n4 = stringBuilder.indexOf(")", n5);
                n3 = n4 + 1;
            } else {
                n5 = n + 1;
                n4 = n3 = StringFunctions.posAfterIdentifier(stringBuilder, n5, n2);
            }
            String string = System.getenv(stringBuilder.substring(n5, n4));
            if (string == null) {
                string = "";
            }
            stringBuilder.replace(n, n3, string);
            n2 = stringBuilder.length();
        }
        this.content = stringBuilder;
        this.begin = 0;
        this.beginLast = 0;
        this.begiMin = 0;
        this.end = this.endLast = this.content.length();
        this.endMax = this.endLast;
        this.bCurrentOk = true;
        this.bStartScan = true;
        return this;
    }

    public final StringPart assign(StringPart stringPart) {
        if (stringPart == this) {
            this.begiMin = this.beginLast = this.begin;
            this.endMax = this.endLast = this.end;
        } else {
            this.content = stringPart.content;
            this.beginLast = this.begin = stringPart.begin;
            this.begiMin = this.begin;
            this.end = this.endLast = stringPart.end;
            this.endMax = this.endLast;
            assert (this.endMax <= this.content.length());
        }
        return this;
    }

    public final StringPart assignFromEnd(StringPart stringPart) {
        this.content = stringPart.content;
        this.beginLast = this.begin;
        this.begiMin = this.begin = stringPart.end;
        this.endMax = this.end = stringPart.endMax;
        this.endLast = this.end;
        assert (this.endMax <= this.content.length());
        return this;
    }

    public final boolean setIgnoreComment(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = (this.bitMode & 2) != 0;
        this.bitMode = bl ? (this.bitMode |= 2) : (this.bitMode &= 0xFFFFFFFD);
        return bl2;
    }

    public final boolean setIgnoreComment(String string, String string2) {
        boolean bl = (this.bitMode & 2) != 0;
        this.bitMode |= 2;
        this.sCommentStart = string;
        this.sCommentEnd = string2;
        return bl;
    }

    public final boolean setIgnoreEndlineComment(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = (this.bitMode & 4) != 0;
        this.bitMode = bl ? (this.bitMode |= 4) : (this.bitMode &= 0xFFFFFFFB);
        return bl2;
    }

    public final boolean setIgnoreEndlineComment(String string) {
        boolean bl = (this.bitMode & 4) != 0;
        this.bitMode |= 4;
        this.sCommentToEol = string;
        return bl;
    }

    public final boolean setIgnoreWhitespaces(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = (this.bitMode & 1) != 0;
        this.bitMode = bl ? (this.bitMode |= 1) : (this.bitMode &= 0xFFFFFFFE);
        return bl2;
    }

    @Java4C.Retinline
    @Java4C.ReturnThis
    @Java4C.NoStackTrace
    public final StringPart setBeginMaxPart() {
        this.begiMin = this.begin;
        return this;
    }

    @Java4C.Retinline
    @Java4C.ReturnThis
    public final StringPart setParttoMax() {
        this.begin = 0;
        this.beginLast = 0;
        this.begiMin = 0;
        this.end = this.endLast = this.content.length();
        this.endMax = this.endLast;
        this.bCurrentOk = true;
        this.bStartScan = true;
        return this;
    }

    @Java4C.Retinline
    @Java4C.ReturnThis
    @Java4C.NoStackTrace
    public final StringPart fromEnd() {
        this.beginLast = this.begin;
        this.endLast = this.end;
        this.begin = this.end;
        this.end = this.endMax;
        return this;
    }

    @Override
    @Java4C.Retinline
    public final char charAt(int n) {
        return this.absCharAt(this.begin + n);
    }

    @Java4C.Retinline
    public final boolean checkCharAt(int n, String string) {
        return this.begin + n >= this.end ? false : string.indexOf(this.charAt(n)) >= 0;
    }

    @Override
    @Java4C.ReturnInThreadCxt
    public final CharSequence subSequence(int n, int n2) {
        if (n < 0 || n2 > this.end - this.begin) {
            this.throwSubSeqFaulty(n, n2);
            return null;
        }
        Part part = new Part(this.begin + n, this.begin + n2);
        return part;
    }

    private final void throwSubSeqFaulty(int n, int n2) {
        throw new IllegalArgumentException("StringPartBase.subString - faulty;" + n);
    }

    @Override
    public final int length() {
        return this.end - this.begin;
    }

    @Java4C.Retinline
    @Java4C.NoStackTrace
    public final int lengthMaxPart() {
        if (this.endMax > this.begin) {
            return this.endMax - this.begin;
        }
        return 0;
    }

    @Deprecated
    @Java4C.Inline
    @Java4C.ReturnThis
    public final StringPart lento(int n) {
        return this.lentoPos(n);
    }

    public final StringPart lentoPos(int n) throws IndexOutOfBoundsException {
        this.endLast = this.end;
        int n2 = this.begin + n;
        if (n2 < this.begin) {
            this.throwIndexOutOfBoundsException("lento(int) negative:" + (n2 - this.begin));
        }
        if (n2 > this.endMax) {
            this.throwIndexOutOfBoundsException("lento(int) after endMax:" + (n2 - this.endMax));
        }
        this.end = n2;
        return this;
    }

    public final StringPart lento(char c) {
        this.endLast = this.end;
        this.end = this.begin - 1;
        while (++this.end < this.endLast) {
            if (this.content.charAt(this.end) != c) continue;
            this.bFound = true;
            return this;
        }
        this.end = this.begin;
        this.bFound = false;
        return this;
    }

    @Java4C.Retinline
    @Java4C.ReturnThis
    public final StringPart lento(CharSequence charSequence) {
        return this.lento(charSequence, 0);
    }

    public final StringPart lento(CharSequence charSequence, int n) {
        this.endLast = this.end;
        int n2 = StringFunctions.indexOf(this.content, this.begin, this.end, charSequence);
        boolean bl = this.bFound = n2 >= 0;
        if (n2 >= 0) {
            this.end = n2;
            if ((n & 1) != 0) {
                this.end += charSequence.length();
            }
        } else {
            this.end = this.begin;
        }
        return this;
    }

    @Java4C.Retinline
    @Java4C.ReturnThis
    public final StringPart lentoIdentifier() {
        return this.lentoIdentifier(null, null);
    }

    public final StringPart lentoIdentifier(CharSequence charSequence, CharSequence charSequence2) {
        this.endLast = this.end;
        this.end = this.begin;
        if (this.end >= this.endMax) {
            this.bFound = false;
        } else {
            char c = this.content.charAt(this.end);
            if (c == '_' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || charSequence != null && StringFunctions.indexOf(charSequence, c) >= 0) {
                ++this.end;
                while (this.end < this.endMax && ((c = this.content.charAt(this.end)) == '_' || c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || charSequence2 != null && StringFunctions.indexOf(charSequence2, c) >= 0)) {
                    ++this.end;
                }
            }
            this.bFound = this.end > this.begin;
        }
        return this;
    }

    public final StringPart lentoAnyNonEscapedChar(CharSequence charSequence, int n) {
        if (this.bCurrentOk) {
            this.endLast = this.end;
            int n2 = this.indexOfAnyChar(charSequence, 0, n);
            while (n2 > this.begin + 1 && this.content.charAt(n2 - 1) == '\\') {
                n2 = this.indexOfAnyChar(charSequence, n2 + 1 - this.begin, n);
            }
            if (n2 < 0) {
                this.end = this.begin;
                this.bFound = false;
            } else {
                this.end = this.begin + n2;
                this.bFound = true;
            }
        }
        return this;
    }

    public final StringPart lentoNonEscapedString(CharSequence charSequence, int n) {
        if (this.bCurrentOk) {
            this.endLast = this.end;
            int n2 = this.indexOf(charSequence, 0, n);
            while (n2 > this.begin + 1 && this.content.charAt(n2 - 1) == '\\') {
                n2 = this.indexOf(charSequence, n2 + 1 - this.begin, n);
            }
            if (n2 < 0) {
                this.end = this.begin;
                this.bFound = false;
            } else {
                this.end = this.begin + n2;
                this.bFound = true;
            }
        }
        return this;
    }

    public final StringPart line() {
        int n;
        int n2 = StringFunctions.lastIndexOfAnyChar(this.content, this.begiMin, this.begin, "\r\n");
        if (n2 < 0) {
            n2 = this.begiMin;
        }
        if ((n = StringFunctions.indexOfAnyChar(this.content, this.begin, this.endMax, "\r\n")) < 0) {
            n = this.endMax;
        }
        this.begin = n2;
        this.end = n;
        return this;
    }

    @Java4C.ReturnThis
    public final StringPart firstlineMaxpart() {
        this.begin = 0;
        this.begiMin = 0;
        this.endMax = this.end = this.content.length();
        this.lentoAnyChar("\r\n");
        if (!this.found()) {
            this.len0end();
        }
        this.endMax = this.end;
        return this;
    }

    @Java4C.ReturnThis
    public final StringPart nextlineMaxpart() {
        this.begiMin = this.begin = this.endMax;
        this.endMax = this.end = this.content.length();
        if (this.begiMin == this.endMax) {
            this.bFound = false;
        } else {
            if (this.checkCharAt(0, "\n")) {
                this.seekPos(1);
                if (this.found() && this.checkCharAt(0, "\r")) {
                    this.seekPos(1);
                }
            }
            if (this.checkCharAt(0, "\r")) {
                this.seekPos(1);
                if (this.found() && this.checkCharAt(0, "\n")) {
                    this.seekPos(1);
                }
            }
            this.lentoAnyChar("\r\n");
            if (!this.found() && this.begin < this.endMax) {
                this.len0end();
            }
            this.begiMin = this.begin;
            this.endMax = this.end;
        }
        return this;
    }

    @Deprecated
    public final StringPart seek(int n) {
        this.beginLast = this.begin;
        this.begin += n;
        if (this.begin > this.end) {
            this.throwIndexOutOfBoundsException("seek=" + n + " begin=" + (this.begin - n) + " end=" + this.end);
        } else if (this.begin < this.begiMin) {
            this.throwIndexOutOfBoundsException("seek=" + n + " begin=" + (this.begin - n) + " begin-min=" + this.begiMin);
        }
        this.bFound = true;
        return this;
    }

    public final StringPart seekPos(int n) {
        int n2 = this.begin + n;
        if (n2 > this.end || n2 < this.begiMin) {
            this.bFound = false;
        } else {
            this.begin = n2;
            this.bFound = true;
        }
        return this;
    }

    public final StringPart seekPosBack(int n) {
        int n2 = this.end - n;
        if (n2 > this.end || n2 < this.begiMin) {
            this.bFound = false;
        } else {
            this.begin = n2;
            this.bFound = true;
        }
        return this;
    }

    public final StringPart seekNoWhitespace() {
        this.beginLast = this.begin;
        while (this.begin < this.end && " \t\r\n\f".indexOf(this.content.charAt(this.begin)) >= 0) {
            ++this.begin;
        }
        this.bFound = this.begin > this.beginLast;
        return this;
    }

    @Deprecated
    protected final StringPart skipWhitespaceAndComment() {
        return this.seekNoWhitespaceOrComments();
    }

    public final StringPart seekNoWhitespaceOrComments() {
        int n;
        int n2 = this.begin;
        do {
            n = this.begin;
            if ((this.bitMode & 1) != 0) {
                this.seekNoWhitespace();
            }
            if ((this.bitMode & 2) != 0 && StringFunctions.compare(this.content, this.begin, this.sCommentStart, 0, this.sCommentStart.length()) == 0) {
                this.seek(this.sCommentEnd, 1);
            }
            if ((this.bitMode & 4) == 0 || StringFunctions.compare(this.content, this.begin, this.sCommentToEol, 0, this.sCommentToEol.length()) != 0) continue;
            this.seek('\n', 1);
        } while (this.begin != n);
        this.bFound = this.begin > n2;
        return this;
    }

    public final boolean found() {
        return this.bFound;
    }

    public final StringPart seekBegin() {
        this.begin = this.beginLast = this.begiMin;
        return this;
    }

    public final StringPart seek(CharSequence charSequence, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        this.beginLast = this.begin;
        Debugutil.stop();
        if ((n & 0x40) == 64) {
            n5 = this.begin + charSequence.length() - 1;
            if (n5 > this.endMax) {
                n5 = this.endMax;
            }
            n4 = this.begiMin;
            n3 = n5;
            n2 = this.begin;
        } else {
            n4 = this.begin;
            n3 = this.end;
            n2 = this.end;
        }
        n5 = (n & 0x10) == 16 ? StringFunctions.lastIndexOf(this.content, n4, n3, charSequence) : StringFunctions.indexOf(this.content, n4, n3, charSequence);
        if (n5 < 0) {
            this.begin = n2;
            this.bFound = false;
        } else {
            this.bFound = true;
            this.begin = n5;
            if ((n & 1) == 1) {
                this.begin += charSequence.length();
            }
        }
        return this;
    }

    public final StringPart seekBackward(CharSequence charSequence) {
        int n = StringFunctions.lastIndexOf(this.content, this.begin, this.end, charSequence);
        if (n < 0) {
            this.bFound = false;
        } else {
            this.begin = n + charSequence.length();
        }
        return this;
    }

    public final StringPart seekAnyChar(CharSequence charSequence) {
        int n = StringFunctions.indexOfAnyChar(this.content, this.begin, this.end, charSequence);
        if (n < 0) {
            this.bFound = false;
        } else {
            this.begin = n;
        }
        return this;
    }

    public final StringPart seekBackToAnyChar(CharSequence charSequence) {
        int n = StringFunctions.lastIndexOfAnyChar(this.content, this.begin, this.end, charSequence);
        if (n < 0) {
            this.bFound = false;
        } else {
            this.begin = n;
        }
        return this;
    }

    @Java4C.Inline
    public final StringPart seek(CharSequence charSequence) {
        return this.seek(charSequence, 0);
    }

    @Java4C.Exclude
    public final StringPart seekEnd(CharSequence charSequence) {
        return this.seek(charSequence, 1);
    }

    public final StringPart seekAnyString(CharSequence[] charSequenceArray, @Java4C.SimpleVariableRef int[] nArray) {
        this.beginLast = this.begin;
        int n = this.indexOfAnyString(charSequenceArray, 0, Integer.MAX_VALUE, nArray, null);
        if (n < 0) {
            this.bFound = false;
            this.begin = this.end;
        } else {
            this.bFound = true;
            this.begin += n;
        }
        return this;
    }

    public final StringPart seek(char c, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        this.beginLast = this.begin;
        if ((n & 0x40) == 64) {
            n5 = this.begin;
            if (n5 > this.endMax) {
                n5 = this.endMax;
            }
            n4 = this.begiMin;
            n3 = n5;
            n2 = this.begin;
        } else {
            n4 = this.begin;
            n3 = this.end;
            n2 = this.end;
        }
        n5 = (n & 0x10) == 16 ? StringFunctions.lastIndexOf(this.content, n4, n3, c) : StringFunctions.indexOf(this.content, n4, n3, c);
        if (n5 < 0) {
            this.begin = n2;
            this.bFound = false;
        } else {
            this.bFound = true;
            this.begin = n5;
            if ((n & 1) == 1) {
                ++this.begin;
            }
        }
        return this;
    }

    public final StringPart seekNoChar(CharSequence charSequence) {
        this.beginLast = this.begin;
        while (this.begin < this.end && StringFunctions.indexOf(charSequence, this.content.charAt(this.begin)) >= 0) {
            ++this.begin;
        }
        this.bFound = this.begin < this.end;
        return this;
    }

    public final StringPart seekNextLine() {
        this.beginLast = this.begin;
        while (this.begin < this.end && "\n\r".indexOf(this.content.charAt(this.begin)) < 0) {
            ++this.begin;
        }
        while (this.begin < this.end && "\n\r".indexOf(this.content.charAt(this.begin)) >= 0) {
            ++this.begin;
        }
        this.bFound = this.begin < this.end;
        return this;
    }

    public final int indexOfAnyChar(CharSequence charSequence, int n, int n2) {
        int n3;
        int n4 = this.end - (n3 = this.begin + n) < n2 ? this.end : n3 + n2;
        int n5 = StringFunctions.indexOfAnyChar(this.content, n3, n4, charSequence);
        if (n5 < 0) {
            return n5;
        }
        return n5 - this.begin;
    }

    public final int indexOfAnyChar(CharSequence charSequence, int n, int n2, char c, char c2, char c3) {
        int n3 = this.begin + n;
        int n4 = this.end - n3 < n2 ? this.end : this.begin + n2;
        boolean bl = true;
        while (n3 < n4 && bl) {
            char c4 = this.content.charAt(n3);
            if (c4 == c2 && c4 != '\u0000') {
                int n5 = this.indexEndOfQuotation(c3, c, n3 - this.begin, n4 - this.begin);
                if (n5 < 0) {
                    n3 = n4;
                    continue;
                }
                n3 = n5 + this.begin;
                continue;
            }
            if (c4 == c && c4 != '\u0000' && n3 < n4 - 1) {
                n3 += 2;
                continue;
            }
            if (StringFunctions.indexOf(charSequence, c4) >= 0) {
                bl = false;
                continue;
            }
            ++n3;
        }
        if (bl) {
            if (StringFunctions.indexOf(charSequence, '\u0003') >= 0) {
                return n3 - this.begin;
            }
            return -1;
        }
        return n3 - this.begin;
    }

    public final int lastIndexOfAnyChar(CharSequence charSequence, int n, int n2) {
        int n3;
        int n4 = this.begin + n;
        for (n3 = this.end - this.begin < n2 ? this.end - 1 : this.begin + n2 - 1; n3 >= n4 && StringFunctions.indexOf(charSequence, this.content.charAt(n3)) < 0; --n3) {
        }
        int n5 = n3 >= n4 ? n3 - this.begin : -1;
        return n5;
    }

    public final int indexOfAnyString(CharSequence[] charSequenceArray, int n, int n2, @Java4C.SimpleVariableRef int[] nArray, @Java4C.SimpleVariableRef String[] stringArray) {
        int n3;
        assert (n >= 0);
        int n4 = this.end - (n3 = this.begin + n) < n2 ? this.end : n3 + n2;
        int n5 = StringFunctions.indexOfAnyString(this.content, n3, n4, charSequenceArray, nArray, stringArray);
        if (n5 >= 0) assert ((n5 -= this.begin) >= 0);
        return n5;
    }

    public final int indexOfAnyCharOutsideQuotion(CharSequence charSequence, int n, int n2) {
        int n3 = this.begin + n;
        int n4 = this.end - n3 < n2 ? this.end : this.begin + n2;
        boolean bl = true;
        while (n3 < n4 && bl) {
            char c = this.content.charAt(n3);
            if (c == '\"') {
                int n5 = this.indexEndOfQuotion('\"', n3 - this.begin, n4 - this.begin);
                if (n5 < 0) {
                    n3 = n4;
                    continue;
                }
                n3 = n5 + this.begin;
                continue;
            }
            if (StringFunctions.indexOf(charSequence, c) >= 0) {
                bl = false;
                continue;
            }
            ++n3;
        }
        return bl ? -1 : n3 - this.begin;
    }

    public final int indexEndOfQuotion(char c, int n, int n2) {
        int n3 = this.begin + n + 1;
        int n4 = this.end - n3 < n2 ? this.end : n3 + n2;
        boolean bl = true;
        while (n3 < n4 && bl) {
            char c2;
            if ((c2 = this.content.charAt(n3++)) == '\\' && n3 + 1 < n4) {
                ++n3;
                continue;
            }
            if (c2 != c) continue;
            bl = false;
        }
        return bl ? -1 : n3 - this.begin;
    }

    public final int indexEndOfQuotation(char c, char c2, int n, int n2) {
        int n3 = this.begin + n + 1;
        int n4 = this.end - n3 < n2 ? this.end : n3 + n2;
        boolean bl = true;
        while (n3 < n4 && bl) {
            char c3;
            if ((c3 = this.content.charAt(n3++)) == c2 && c3 != '\u0000' && n3 + 1 < n4) {
                ++n3;
                continue;
            }
            if (c3 != c) continue;
            bl = false;
        }
        return bl ? -1 : n3 - this.begin;
    }

    public final int indexOfAnyChar(CharSequence charSequence) {
        return this.indexOfAnyChar(charSequence, 0, Integer.MAX_VALUE);
    }

    public final int indexOfNoChar(CharSequence charSequence, int n) {
        int n2;
        for (n2 = this.begin + n; n2 < this.end && StringFunctions.indexOf(charSequence, this.content.charAt(n2)) >= 0; ++n2) {
        }
        return n2 >= this.end ? -1 : n2 - this.begin;
    }

    public final int indexOfNoChar(CharSequence charSequence) {
        return this.indexOfNoChar(charSequence, 0);
    }

    public final StringPart lentoAnyChar(CharSequence charSequence, int n) {
        return this.lentoAnyChar(charSequence, n, 0);
    }

    public final StringPart lentoAnyChar(CharSequence charSequence, int n, int n2) {
        this.endLast = this.end;
        int n3 = (n2 & 0x10) != 0 ? this.lastIndexOfAnyChar(charSequence, 0, n) : this.indexOfAnyChar(charSequence, 0, n);
        if (n3 < 0) {
            this.end = this.begin;
            this.bFound = false;
        } else {
            this.end = this.begin + n3;
            this.bFound = true;
        }
        return this;
    }

    public final StringPart lentoAnyString(CharSequence[] charSequenceArray, int n) {
        return this.lentoAnyString(charSequenceArray, n, 0);
    }

    public final StringPart lentoAnyString(CharSequence[] charSequenceArray, int n, int n2) {
        this.endLast = this.end;
        String[] stringArray = new String[1];
        int n3 = this.indexOfAnyString(charSequenceArray, 0, n, null, stringArray);
        if (n3 < 0) {
            this.end = this.begin;
            this.bFound = false;
        } else {
            if ((n2 & 1) != 0) {
                n3 += stringArray[0].length();
            }
            this.end = this.begin + n3;
            this.bFound = true;
        }
        return this;
    }

    public final void lentoAnyStringWithIndent(CharSequence[] charSequenceArray, CharSequence charSequence, int n, StringBuilder stringBuilder) {
        assert (this.end <= this.content.length());
        this.endLast = this.end;
        stringBuilder.setLength(0);
        int n2 = this.getCurrentColumn();
        int n3 = this.begin;
        boolean bl = charSequence.charAt(charSequence.length() - 1) == ' ';
        int n4 = this.indexOfAnyString(charSequenceArray, 0, n, null, null);
        if (n4 < 0) {
            this.end = this.begin;
            this.bFound = false;
        } else {
            this.bFound = true;
            this.end = this.begin + n4;
            boolean bl2 = false;
            while (!bl2) {
                n4 = StringFunctions.indexOf(this.content, '\n', n3);
                if (n4 < 0) {
                    n4 = this.end;
                }
                if (n4 > this.end) {
                    n4 = this.end;
                    bl2 = true;
                } else {
                    ++n4;
                }
                stringBuilder.append(this.content.subSequence(n3, n4));
                if (bl2) continue;
                n3 = n4;
                int n5 = n3 + n2;
                if (n5 > this.end) {
                    n5 = this.end;
                }
                while (n3 < n5 && StringFunctions.indexOf(charSequence, this.content.charAt(n3)) >= 0) {
                    ++n3;
                }
                if (!bl) continue;
                while (" \t".indexOf(this.content.charAt(n3)) >= 0) {
                    ++n3;
                }
            }
        }
    }

    public final StringPart lentoAnyCharOutsideQuotion(CharSequence charSequence, int n) {
        this.endLast = this.end;
        int n2 = this.indexOfAnyCharOutsideQuotion(charSequence, 0, n);
        if (n2 < 0) {
            this.end = this.begin;
            this.bFound = false;
        } else {
            this.end = this.begin + n2;
            this.bFound = true;
        }
        return this;
    }

    public final StringPart lentoQuotionEnd(char c, int n) {
        this.endLast = this.end;
        int n2 = this.indexEndOfQuotion(c, 0, n);
        if (n2 < 0) {
            this.end = this.begin;
            this.bFound = false;
        } else {
            this.end = this.begin + n2;
            this.bFound = true;
        }
        return this;
    }

    @Java4C.Retinline
    public final StringPart lentoLineEnd() {
        return this.lentoAnyChar("\n\r\f");
    }

    @Java4C.Retinline
    public final StringPart trimWhiteSpaces() {
        this.seekNoWhitespace();
        this.lenBacktoNoChar(" \t\r\n\f");
        return this;
    }

    public final StringPart lentoAnyChar(CharSequence charSequence) {
        this.lentoAnyChar(charSequence, Integer.MAX_VALUE);
        return this;
    }

    public final StringPart len0end() {
        if (this.end <= this.begin) {
            this.end = this.endMax;
        }
        return this;
    }

    public final StringPart setLengthMax() {
        this.end = this.endMax;
        return this;
    }

    public final StringPart lenBacktoNoChar(CharSequence charSequence) {
        this.endLast = this.end;
        while (this.end > this.begin && StringFunctions.indexOf(charSequence, this.content.charAt(this.end - 1)) >= 0) {
            --this.end;
        }
        if (this.end <= this.begin) {
            this.end = this.begin;
            this.bFound = false;
        } else {
            this.bFound = true;
        }
        return this;
    }

    public final StringPart lenBacktoNoWhiteSpaces() {
        return this.lenBacktoNoChar(" \t\n\r");
    }

    public final StringPart trim() {
        return this.seekNoChar(" \t\n\r").lenBacktoNoChar(" \t\n\r");
    }

    final StringPart trimComment() {
        this.beginLast = this.begin;
        this.endLast = this.end;
        int n = this.indexOf("//");
        if (n >= 0) {
            this.end = this.begin + n;
        }
        this.bFound = this.begin > this.beginLast;
        return this.trim();
    }

    @Override
    public final int compareTo(CharSequence charSequence) {
        return StringFunctions.compare(this, 0, charSequence, 0, Integer.MAX_VALUE);
    }

    public final int indexOf(char c) {
        int n = StringFunctions.indexOf(this.content, this.begin, this.end, c);
        if (n < 0) {
            return -1;
        }
        return n - this.begin;
    }

    public final int indexOf(char c, int n) {
        if (n >= this.end - this.begin || n < 0) {
            return -1;
        }
        int n2 = StringFunctions.indexOf(this.content, this.begin + n, this.end, c);
        if (n2 < 0) {
            return -1;
        }
        return n2 - this.begin + n;
    }

    public final int indexOf(CharSequence charSequence) {
        int n = StringFunctions.indexOf(this.content, this.begin, this.end, charSequence);
        if (n < 0) {
            return -1;
        }
        return n - this.begin;
    }

    public final int XXXindexOf(CharSequence charSequence) {
        int n = StringFunctions.indexOf(this.content, this.begin, this.end, charSequence);
        if (n < 0) {
            return -1;
        }
        return n - this.begin;
    }

    public final int indexOf(CharSequence charSequence, int n, int n2) {
        int n3;
        int n4 = n3 = this.end - this.begin < n2 ? this.end : this.begin + n2;
        if (n >= n3 - this.begin || n < 0) {
            return -1;
        }
        int n5 = StringFunctions.indexOf(this.content, this.begin + n, n3, charSequence);
        if (n5 < 0) {
            return -1;
        }
        return n5 - this.begin + n;
    }

    public final boolean equals(CharSequence charSequence) {
        return StringFunctions.equals(this.content, this.begin, this.end, charSequence);
    }

    public final boolean startsWith(CharSequence charSequence) {
        int n = StringFunctions.indexOf(charSequence, '\u0003', 0);
        if (n >= 0) {
            if (n == 0) {
                return this.begin == this.end;
            }
            return StringFunctions.equals(this.content, this.begin, this.end, charSequence);
        }
        return StringFunctions.startsWith(this.content, this.begin, this.end, charSequence);
    }

    @Java4C.Exclude
    public StringPartScan scan() {
        return (StringPartScan)this;
    }

    public final long getCurrentPosition() {
        return this.begin;
    }

    public final void setCurrentPosition(long l) {
        this.begin = (int)l;
    }

    @Java4C.ReturnInThreadCxt
    public final Part substring(int n, int n2) {
        int n3 = n2 <= 0 ? this.endMax - n2 : n2;
        Part part = new Part(n + this.begiMin, n3);
        return part;
    }

    @Java4C.ReturnInThreadCxt
    public final CharSequence getCurrent(int n) {
        int n2;
        int n3 = n2 = this.endMax - this.begin < n ? this.endMax - this.begin : n;
        if (n2 == 0) {
            return "";
        }
        return new Part(this.begin, this.begin + n2);
    }

    public final char getCurrentChar() {
        if (this.begin < this.endMax) {
            return this.content.charAt(this.begin);
        }
        return '\u0000';
    }

    public int getLineAndColumn(int[] nArray) {
        return 0;
    }

    public final int getCurrentColumn() {
        int n = StringFunctions.lastIndexOf(this.content, 0, this.begin, '\n');
        if (n < 0) {
            return this.begin;
        }
        return this.begin - n - 1;
    }

    public final String getInputfile() {
        return this.sFile;
    }

    @Java4C.ReturnInThreadCxt
    public final Part getCurrentPart() {
        Part part = this.end > this.begin ? new Part(this.begin, this.end) : new Part(this.begin, this.begin);
        return part;
    }

    @Java4C.ReturnInThreadCxt
    public final CharSequence getLastPart() {
        if (this.begin > this.beginLast) {
            Part part = new Part(this.beginLast, this.begin);
            return part;
        }
        return "";
    }

    @Java4C.ReturnInThreadCxt
    public final CharSequence getCurrentPart(int n) {
        int n2;
        int n3 = n < 0 ? this.end : (n2 = this.end - this.begin < n ? this.end : this.begin + n);
        if (this.end > this.begin) {
            Part part = new Part(this.begin, n2);
            return part;
        }
        return "";
    }

    @Java4C.ReturnInThreadCxt
    public final Part getPart(int n, int n2) {
        int n3 = this.endMax - n < n2 ? this.endMax - n : n2;
        Part part = new Part(n, n + n3);
        return part;
    }

    protected final char absCharAt(int n) {
        int n2 = n;
        if (n2 >= 0 && n2 < this.endMax) {
            return this.content.charAt(n2);
        }
        StringPart.throwIllegalArgumentException("StringPartBase.charAt - faulty; ", n);
        return '\u0000';
    }

    protected final String absSubString(int n, int n2) {
        int n3 = n;
        int n4 = n2 - n;
        int n5 = n3 + n4;
        if (this.content == null) {
            return " ??null?? ";
        }
        if (n3 >= 0 && n5 <= this.endMax) {
            CharSequence charSequence = this.content.subSequence(n3, n3 + n4);
            return charSequence.toString();
        }
        StringPart.throwIllegalArgumentException("StringPartBase.subSequence - faulty; ", n);
        return "";
    }

    @Override
    @Java4C.ReturnInThreadCxt
    public String toString() {
        Part part = this.getCurrentPart();
        String string = part.toString();
        return string;
    }

    public final String debugString() {
        int n = this.endMax;
        String string = this.content.subSequence(0, n > 20 ? 20 : n) + "<<<" + this.begin + "," + this.end + ">>>";
        if (this.begin < n) {
            string = string + this.content.subSequence(this.begin, n > this.begin + 20 ? this.begin + 20 : n);
        }
        string = string + "<<<";
        return string;
    }

    private final void throwIndexOutOfBoundsException(String string) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException(string);
    }

    private static final void throwIllegalArgumentException(String string, int n) {
        throw new IllegalArgumentExceptionJc(string, n);
    }

    public void close() {
        this.content = null;
        this.begin = 0;
        this.beginLast = 0;
        this.begiMin = 0;
        this.endLast = 0;
        this.end = 0;
        this.endMax = 0;
        this.bFound = false;
        this.bCurrentOk = false;
    }

    public static CharSequence replace(CharSequence charSequence, CharSequence[] charSequenceArray, CharSequence[] charSequenceArray2, StringBuilder stringBuilder) {
        int n = charSequence.length();
        boolean bl = false;
        int n2 = charSequenceArray.length;
        if (n2 != charSequenceArray2.length) {
            StringPart.throwIllegalArgumentException("token and value should have same size, lesser 20", n2);
            return charSequence;
        }
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder(n + 100);
        }
        int n3 = 0;
        do {
            int[] nArray = new int[1];
            int n4 = StringFunctions.indexOfAnyString(charSequence, n3, charSequence.length(), charSequenceArray, nArray, null);
            if (n4 >= 0) {
                stringBuilder.append(charSequence.subSequence(n3, n4));
                int n5 = nArray[0];
                stringBuilder.append(charSequenceArray2[n5]);
                n3 = n4 + charSequenceArray[n5].length();
                continue;
            }
            stringBuilder.append(charSequence.subSequence(n3, n));
            n3 = -1;
        } while (n3 >= 0);
        return stringBuilder;
    }

    public final class Part
    implements CharSequence {
        int b1;
        int e1;

        protected Part(int n, int n2) {
            assert (n >= 0 && n <= StringPart.this.endMax);
            assert (n2 >= 0 && n2 <= StringPart.this.endMax);
            assert (n <= n2);
            this.b1 = n;
            this.e1 = n2;
        }

        @Override
        public final char charAt(int n) {
            return StringPart.this.absCharAt(this.b1 + n);
        }

        @Override
        public final int length() {
            return this.e1 - this.b1;
        }

        public final boolean equals(Object object) {
            CharSequence charSequence = object instanceof CharSequence ? (CharSequence)object : object.toString();
            int n = this.length();
            if (charSequence.length() != n) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.charAt(i) == charSequence.charAt(i)) continue;
                return false;
            }
            return true;
        }

        @Override
        @Java4C.ReturnInThreadCxt
        public final CharSequence subSequence(int n, int n2) {
            Part part = new Part(this.b1 + n, this.b1 + n2);
            return part;
        }

        @Override
        public final String toString() {
            return StringPart.this.absSubString(this.b1, this.e1);
        }

        @Java4C.ReturnInThreadCxt
        public final Part trim() {
            int n;
            int n2 = this.e1;
            for (n = this.b1; n < n2 && " \r\n\t".indexOf(StringPart.this.content.charAt(n)) >= 0; ++n) {
            }
            while (n2 > n && " \r\n".indexOf(StringPart.this.content.charAt(n2 - 1)) >= 0) {
                --n2;
            }
            Part part = new Part(n, n2);
            return part;
        }
    }
}

