/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.vishia.util.FileSystem;

public class FileCompare {
    public static final int version = 538051076;
    static final int onlyTimestamp = 1;
    static final int content = 2;
    static final int withoutLineend = 4;
    static final int withoutEndlineComment = 8;
    static final int withoutComment = 16;
    final int mode;
    long minDiffTimestamp = 2000L;
    final String[] sIgnores;

    public FileCompare(int n, String[] stringArray, long l) {
        this.mode = n;
        this.sIgnores = stringArray;
        this.minDiffTimestamp = l;
    }

    /*
     * WARNING - void declaration
     */
    public void compare(Result result, String[] stringArray, int n) {
        String string;
        int n2;
        if (n > 100) {
            throw new IllegalArgumentException("deepness");
        }
        int n3 = this.sIgnores != null ? this.sIgnores.length : 0;
        File[] fileArray = result.file1.listFiles();
        File[] fileArray2 = result.file2.listFiles();
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        TreeMap<String, Object> treeMap2 = new TreeMap<String, Object>();
        if (fileArray != null) {
            for (File object2 : fileArray) {
                String string2 = object2.getName();
                boolean bl = FileSystem.isSymbolicLink(object2);
                if (bl) continue;
                n2 = -1;
                while (++n2 < n3) {
                    if (!string2.equals(this.sIgnores[n2])) continue;
                    n2 = 0x7FFFFFFE;
                }
                if (n2 != n3) continue;
                string = object2.isDirectory() ? ":" + string2 : string2;
                treeMap.put(string, object2);
            }
        }
        if (fileArray2 != null) {
            for (File file : fileArray2) {
                boolean bl = FileSystem.isSymbolicLink(file);
                if (bl) continue;
                String string3 = file.getName();
                n2 = -1;
                while (++n2 < n3) {
                    if (!string3.equals(this.sIgnores[n2])) continue;
                    n2 = 0x7FFFFFFE;
                }
                if (n2 != n3) continue;
                string = file.isDirectory() ? ":" + string3 : string3;
                treeMap2.put(string, file);
            }
        }
        Set set = treeMap.entrySet();
        Set set2 = treeMap2.entrySet();
        Iterator iterator = set.iterator();
        Object var12_17 = null;
        Iterator iterator2 = set2.iterator();
        Map.Entry entry = null;
        String string4 = null;
        string = null;
        File file = null;
        File file2 = null;
        boolean bl = true;
        do {
            Result result2;
            void var12_18;
            if (var12_18 == null) {
                Map.Entry entry2;
                Map.Entry entry3 = entry2 = iterator.hasNext() ? (Map.Entry)iterator.next() : null;
                if (entry2 != null) {
                    string4 = (String)entry2.getKey();
                    file = (File)entry2.getValue();
                } else {
                    string4 = null;
                    file = null;
                }
            }
            if (entry == null) {
                Map.Entry entry4 = entry = iterator2.hasNext() ? iterator2.next() : null;
                if (entry != null) {
                    string = (String)entry.getKey();
                    file2 = (File)entry.getValue();
                } else {
                    string = null;
                    file2 = null;
                }
            }
            if (var12_18 != null && entry != null && string4.equals(string)) {
                result2 = new Result(result, file, file2);
                if (string4.startsWith(":")) {
                    this.compare(result2, stringArray, n + 1);
                } else {
                    this.compareFile(result2);
                }
                result.subFiles.add(result2);
                if (!result2.contentEqual) {
                    result.contentEqual = false;
                }
                if (!result2.contentEqualWithoutEndline) {
                    result.contentEqualWithoutEndline = false;
                }
                if (!result2.equal) {
                    result.equal = false;
                }
                if (result2.missingFiles || result2.alone) {
                    result.missingFiles = true;
                }
                if (!result2.equalDaylightSaved) {
                    result.equalDaylightSaved = false;
                }
                if (result2.readProblems) {
                    result.readProblems = true;
                }
                entry = null;
                Object var12_20 = null;
                continue;
            }
            if (entry != null && (var12_18 == null || string4.compareTo(string) > 0)) {
                result2 = new Result(result, null, file2);
                result2.alone = true;
                result.subFiles.add(result2);
                entry = null;
                continue;
            }
            if (var12_18 != null) {
                result2 = new Result(result, file, null);
                result2.alone = true;
                result.subFiles.add(result2);
                Object var12_21 = null;
                continue;
            }
            bl = false;
        } while (bl);
    }

    void compareFile(Result result) {
        long l = result.file1.lastModified();
        long l2 = result.file2.lastModified();
        long l3 = result.file1.length();
        long l4 = result.file1.length();
        if (Math.abs(l - l2) > this.minDiffTimestamp && this.mode == 1) {
            result.contentEqualWithoutEndline = false;
            result.contentEqual = false;
            result.equalDaylightSaved = false;
            result.equal = false;
            result.lenEqual = l3 == l4;
        } else if ((Math.abs(l - l2 + 3600000L) < this.minDiffTimestamp || Math.abs(l - l2 - 3600000L) < this.minDiffTimestamp) && this.mode == 1) {
            result.contentEqualWithoutEndline = false;
            result.contentEqual = false;
            result.equalDaylightSaved = false;
        } else {
            if (l3 != l4) {
                result.lenEqual = false;
                result.contentEqualWithoutEndline = false;
                result.contentEqual = false;
                result.equal = false;
            }
            if (result.file1.getName().equals("MainCmd.java")) {
                result.alone = false;
            }
            result.equal = this.compareFileContent(result);
        }
    }

    boolean compareFileContent(Result result) {
        boolean bl = true;
        BufferedReader bufferedReader = null;
        BufferedReader bufferedReader2 = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new FileReader(result.file1));
            bufferedReader2 = new BufferedReader(new FileReader(result.file2));
            while (bl && (string = bufferedReader.readLine()) != null) {
                String string2 = bufferedReader2.readLine();
                if (string2 != null && string.equals(string2)) continue;
                bl = false;
            }
            bufferedReader.close();
            bufferedReader2.close();
            bufferedReader2 = null;
            bufferedReader = null;
        }
        catch (IOException iOException) {
            result.readProblems = true;
            bl = false;
        }
        FileSystem.close(bufferedReader);
        FileSystem.close(bufferedReader2);
        result.equal = bl;
        return bl;
    }

    void reportResult(PrintStream printStream, List<Result> list) {
        boolean bl = false;
        for (Result result : list) {
            if (result.equal) {
                printStream.append("    ====     ; ").append(result.name).append("\n");
                continue;
            }
            if (result.contentEqual) {
                printStream.append("     ==      ; ").append(result.name).append("\n");
                continue;
            }
            if (result.lenEqual) {
                printStream.append("    =?=      ; ").append(result.name).append("\n");
                continue;
            }
            if (result.alone && result.file1 != null) {
                printStream.append("left         ; ").append(result.name).append("\n");
                continue;
            }
            if (result.alone && result.file2 != null) {
                printStream.append("       right ; ").append(result.name).append("\n");
                continue;
            }
            if (!result.alone && result.subFiles != null) {
                this.reportResult(printStream, result.subFiles);
                continue;
            }
            if (!bl) {
                bl = this.writeDir(printStream, result);
            }
            printStream.append("     ??      ; ").append(result.name).append("\n");
        }
    }

    boolean writeDir(PrintStream printStream, Result result) {
        printStream.append("=========================================").append("\n");
        printStream.append(result.file1.getAbsolutePath()).append("  ==  ").append(result.file2.getAbsolutePath()).append("\n");
        return true;
    }

    public static void main(String[] stringArray) {
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        String[] stringArray2 = new String[]{".bzr"};
        FileCompare fileCompare = new FileCompare(1, stringArray2, 2000L);
        Result result = new Result(null, file, file2);
        fileCompare.compare(result, null, 0);
        fileCompare.reportResult(System.out, result.subFiles);
    }

    public static class Result {
        public final File file1;
        public final File file2;
        public final String name;
        public final List<Result> subFiles;
        public final Result parent;
        public boolean alone;
        public boolean equal;
        public boolean missingFiles;
        public boolean lenEqual;
        public boolean readProblems;
        public boolean equalDaylightSaved;
        public boolean contentEqual;
        public boolean contentEqualWithoutEndline;

        public Result(Result result, File file, File file2) {
            this.parent = result;
            this.file1 = file;
            this.file2 = file2;
            this.name = file != null ? file.getName() : file2.getName();
            this.subFiles = file != null && file2 != null && file.isDirectory() ? new LinkedList<Result>() : null;
            this.alone = false;
            this.readProblems = false;
            this.equal = true;
            this.lenEqual = true;
            this.equalDaylightSaved = true;
            this.contentEqual = true;
            this.missingFiles = false;
            this.contentEqualWithoutEndline = true;
        }

        public void setToEqual() {
            this.alone = false;
            this.missingFiles = false;
            this.readProblems = false;
            this.lenEqual = true;
            this.contentEqual = true;
            this.contentEqualWithoutEndline = true;
            this.equal = true;
            if (this.parent != null) {
                this.adjustParent(this.parent, 0);
            }
        }

        void adjustParent(Result result, int n) {
            if (n > 100) {
                throw new IllegalArgumentException("recursion problem");
            }
            result.contentEqual = true;
            result.contentEqualWithoutEndline = true;
            result.equal = true;
            result.missingFiles = false;
            result.equalDaylightSaved = true;
            result.readProblems = false;
            for (Result result2 : result.subFiles) {
                if (!result2.contentEqual) {
                    result.contentEqual = false;
                }
                if (!result2.contentEqualWithoutEndline) {
                    result.contentEqualWithoutEndline = false;
                }
                if (!result2.equal) {
                    result.equal = false;
                }
                if (result2.missingFiles || result2.alone) {
                    result.missingFiles = true;
                }
                if (!result2.equalDaylightSaved) {
                    result.equalDaylightSaved = false;
                }
                if (!result2.readProblems) continue;
                result.readProblems = true;
            }
            if (result.parent != null) {
                this.adjustParent(result.parent, n + 1);
            }
        }

        public String toString() {
            return this.name;
        }
    }
}

