/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.util;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import org.vishia.util.DataAccess;
import org.vishia.util.Debugutil;
import org.vishia.util.StringFunctions;
import org.vishia.util.StringFunctions_C;
import org.vishia.util.StringPartScan;
import org.vishia.util.StringSeq;

public class CalculatorExpr {
    public static final int version = 538186260;
    protected static final ExpressionType startExpr = new ExpressionType(){

        @Override
        public char typeChar() {
            return '!';
        }

        @Override
        public ExpressionType checkArgument(Value value, Value value2) {
            value.type = value2.type;
            switch (value2.type) {
                case 'I': {
                    value.etype = intExpr;
                    break;
                }
                case 'J': {
                    value.etype = longExpr;
                    break;
                }
                case 'F': {
                    value.etype = floatExpr;
                    break;
                }
                case 'D': {
                    value.etype = doubleExpr;
                    break;
                }
                case 'C': {
                    value.etype = intExpr;
                    break;
                }
                case 'Z': {
                    value.etype = booleanExpr;
                    break;
                }
                case 't': {
                    value.etype = stringExpr;
                    break;
                }
                case 'o': {
                    value.etype = objExpr;
                    break;
                }
                case 'e': {
                    value.etype = variableNotFoundExpr;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("src type");
                }
            }
            return value.etype;
        }

        public String toString() {
            return "Type=!";
        }
    };
    protected static final ExpressionType intExpr = new ExpressionType(){

        @Override
        public char typeChar() {
            return 'I';
        }

        @Override
        public ExpressionType checkArgument(Value value, Value value2) throws Exception {
            switch (value2.type) {
                case 'C': 
                case 'I': {
                    return this;
                }
                case 'J': {
                    value.longVal = value.intVal;
                    value.type = (char)74;
                    value.etype = longExpr;
                    return value.etype;
                }
                case 'F': {
                    value.floatVal = value.intVal;
                    value.type = (char)70;
                    value.etype = floatExpr;
                    return value.etype;
                }
                case 'D': {
                    value.doubleVal = value.intVal;
                    value.type = (char)68;
                    value.etype = doubleExpr;
                    return value.etype;
                }
                case 'Z': {
                    value.boolVal = value.intVal != 0;
                    value.type = (char)90;
                    value.etype = booleanExpr;
                    return value.etype;
                }
                case 'o': {
                    if (value2.oVal instanceof Long) {
                        value2.longVal = (Long)value2.oVal;
                        value.longVal = value.intVal;
                        return longExpr;
                    }
                    if (value2.oVal instanceof Integer) {
                        value2.intVal = (Integer)value2.oVal;
                        return this;
                    }
                    if (value2.oVal instanceof Short) {
                        value2.intVal = ((Short)value2.oVal).shortValue();
                        return this;
                    }
                    if (value2.oVal instanceof Byte) {
                        value2.intVal = ((Byte)value2.oVal).byteValue();
                        return this;
                    }
                    if (value2.oVal instanceof Double) {
                        value2.doubleVal = (Double)value2.oVal;
                        value.doubleVal = value.intVal;
                        return doubleExpr;
                    }
                    if (value2.oVal instanceof Float) {
                        value2.floatVal = ((Float)value2.oVal).floatValue();
                        value.floatVal = value.intVal;
                        return floatExpr;
                    }
                    if (value2.oVal instanceof Boolean) {
                        value2.boolVal = (Boolean)value2.oVal;
                        value.boolVal = value.intVal != 0;
                        return booleanExpr;
                    }
                    if (value2.oVal instanceof Character) {
                        value2.intVal = ((Character)value2.oVal).charValue();
                        return this;
                    }
                    throw new IllegalArgumentException("the value should be of a numeric type");
                }
                case 'e': {
                    throw (Exception)value2.oVal;
                }
                case 't': {
                    try {
                        value2.longVal = Long.parseLong(value2.stringVal.toString());
                        return this;
                    }
                    catch (Exception exception) {
                        throw new IllegalArgumentException("CalculatorExpr - String converion error");
                    }
                }
            }
            throw new IllegalArgumentException("src type");
        }

        public String toString() {
            return "Type=I";
        }
    };
    protected static final ExpressionType longExpr = new ExpressionType(){

        @Override
        public char typeChar() {
            return 'J';
        }

        @Override
        public ExpressionType checkArgument(Value value, Value value2) throws Exception {
            switch (value2.type) {
                case 'C': 
                case 'I': {
                    value2.longVal = value2.intVal;
                    return this;
                }
                case 'J': {
                    return this;
                }
                case 'F': {
                    value.floatVal = value.longVal;
                    value.type = (char)70;
                    value.etype = floatExpr;
                    return value.etype;
                }
                case 'D': {
                    value.doubleVal = value.longVal;
                    value.type = (char)68;
                    value.etype = doubleExpr;
                    return value.etype;
                }
                case 'o': {
                    if (value2.oVal instanceof Long) {
                        value2.longVal = (Long)value2.oVal;
                        return this;
                    }
                    if (value2.oVal instanceof Integer) {
                        value2.longVal = ((Integer)value2.oVal).intValue();
                        return this;
                    }
                    if (value2.oVal instanceof Short) {
                        value2.longVal = ((Short)value2.oVal).shortValue();
                        return this;
                    }
                    if (value2.oVal instanceof Byte) {
                        value2.longVal = ((Byte)value2.oVal).byteValue();
                        return this;
                    }
                    if (value2.oVal instanceof Double) {
                        value2.doubleVal = (Double)value2.oVal;
                        value.doubleVal = value.longVal;
                        return doubleExpr;
                    }
                    if (value2.oVal instanceof Float) {
                        value2.floatVal = ((Float)value2.oVal).floatValue();
                        value.floatVal = value.longVal;
                        return floatExpr;
                    }
                    if (value2.oVal instanceof Boolean) {
                        value2.boolVal = (Boolean)value2.oVal;
                        value.boolVal = value.longVal != 0L;
                        return booleanExpr;
                    }
                    if (value2.oVal instanceof Character) {
                        value2.intVal = ((Character)value2.oVal).charValue();
                        return this;
                    }
                    throw new IllegalArgumentException("the value should be of a numeric type");
                }
                case 'e': {
                    throw (Exception)value2.oVal;
                }
            }
            throw new IllegalArgumentException("src type");
        }

        public String toString() {
            return "Type=J";
        }
    };
    protected static final ExpressionType floatExpr = new ExpressionType(){

        @Override
        public char typeChar() {
            return 'F';
        }

        @Override
        public ExpressionType checkArgument(Value value, Value value2) throws Exception {
            switch (value2.type) {
                case 'C': 
                case 'I': {
                    value2.floatVal = value2.intVal;
                    return this;
                }
                case 'J': {
                    value2.doubleVal = value2.longVal;
                    return doubleExpr;
                }
                case 'F': {
                    return this;
                }
                case 'D': {
                    value.doubleVal = value.floatVal;
                    value.type = (char)68;
                    value.etype = doubleExpr;
                    return value.etype;
                }
                case 'o': {
                    if (value2.oVal instanceof Long) {
                        value2.floatVal = ((Long)value2.oVal).longValue();
                        return this;
                    }
                    if (value2.oVal instanceof Integer) {
                        value2.floatVal = ((Integer)value2.oVal).intValue();
                        return this;
                    }
                    if (value2.oVal instanceof Short) {
                        value2.floatVal = ((Short)value2.oVal).shortValue();
                        return this;
                    }
                    if (value2.oVal instanceof Byte) {
                        value2.floatVal = ((Byte)value2.oVal).byteValue();
                        return this;
                    }
                    if (value2.oVal instanceof Double) {
                        value2.doubleVal = (Double)value2.oVal;
                        value.doubleVal = value.floatVal;
                        return doubleExpr;
                    }
                    if (value2.oVal instanceof Float) {
                        value2.floatVal = ((Float)value2.oVal).floatValue();
                        return this;
                    }
                    if (value2.oVal instanceof Boolean) {
                        value2.boolVal = (Boolean)value2.oVal;
                        value.boolVal = value.floatVal != 0.0f;
                        return booleanExpr;
                    }
                    if (value2.oVal instanceof Character) {
                        value2.floatVal = ((Character)value2.oVal).charValue();
                        return this;
                    }
                    return objExpr;
                }
                case 'e': {
                    throw (Exception)value2.oVal;
                }
            }
            throw new IllegalArgumentException("src type");
        }

        public String toString() {
            return "Type=F";
        }
    };
    protected static final ExpressionType doubleExpr = new ExpressionType(){

        @Override
        public char typeChar() {
            return 'D';
        }

        @Override
        public ExpressionType checkArgument(Value value, Value value2) throws Exception {
            switch (value2.type) {
                case 'C': 
                case 'I': {
                    value2.doubleVal = value2.intVal;
                    return this;
                }
                case 'J': {
                    value2.doubleVal = value2.longVal;
                    return this;
                }
                case 'F': {
                    value2.doubleVal = value2.floatVal;
                    return this;
                }
                case 'D': {
                    return this;
                }
                case 'o': {
                    if (value2.oVal instanceof Long) {
                        value2.doubleVal = ((Long)value2.oVal).longValue();
                        return this;
                    }
                    if (value2.oVal instanceof Integer) {
                        value2.doubleVal = ((Integer)value2.oVal).intValue();
                        return this;
                    }
                    if (value2.oVal instanceof Short) {
                        value2.doubleVal = ((Short)value2.oVal).shortValue();
                        return this;
                    }
                    if (value2.oVal instanceof Byte) {
                        value2.doubleVal = ((Byte)value2.oVal).byteValue();
                        return this;
                    }
                    if (value2.oVal instanceof Double) {
                        value2.doubleVal = (Double)value2.oVal;
                        return this;
                    }
                    if (value2.oVal instanceof Float) {
                        value2.doubleVal = ((Float)value2.oVal).floatValue();
                        return this;
                    }
                    if (value2.oVal instanceof Boolean) {
                        value2.boolVal = (Boolean)value2.oVal;
                        value.boolVal = value.doubleVal != 0.0;
                        return booleanExpr;
                    }
                    if (value2.oVal instanceof Character) {
                        value2.doubleVal = ((Character)value2.oVal).charValue();
                        return this;
                    }
                    throw new IllegalArgumentException("the value should be of a numeric type");
                }
                case 'e': {
                    throw (Exception)value2.oVal;
                }
            }
            throw new IllegalArgumentException("src type");
        }

        public String toString() {
            return "Type=D";
        }
    };
    protected static final ExpressionType booleanExpr = new ExpressionType(){

        @Override
        public char typeChar() {
            return 'Z';
        }

        @Override
        public ExpressionType checkArgument(Value value, Value value2) {
            switch (value2.type) {
                case 'C': 
                case 'I': {
                    value2.boolVal = value2.intVal != 0;
                    break;
                }
                case 'J': {
                    value2.boolVal = value2.longVal != 0L;
                    break;
                }
                case 'F': {
                    value2.boolVal = value2.floatVal != 0.0f;
                    break;
                }
                case 'D': {
                    value2.boolVal = value2.doubleVal != 0.0;
                    break;
                }
                case 't': {
                    value2.boolVal = value2.stringVal != null && value2.stringVal.length() > 0;
                    break;
                }
                case 'o': {
                    value2.boolVal = value2.oVal instanceof Long ? (Long)value2.oVal != 0L : (value2.oVal instanceof Integer ? (Integer)value2.oVal != 0 : (value2.oVal instanceof Short ? (Short)value2.oVal != 0 : (value2.oVal instanceof Byte ? (Byte)value2.oVal != 0 : (value2.oVal instanceof Double ? (Double)value2.oVal != 0.0 : (value2.oVal instanceof Float ? ((Float)value2.oVal).floatValue() != 0.0f : (value2.oVal instanceof Boolean ? (Boolean)value2.oVal : (value2.oVal instanceof Character ? ((Character)value2.oVal).charValue() != '\u0000' : value2.oVal != null)))))));
                    return this;
                }
                case 'e': {
                    value2.boolVal = false;
                    return this;
                }
                case 'Z': {
                    return this;
                }
                default: {
                    throw new IllegalArgumentException("src type");
                }
            }
            return this;
        }

        public String toString() {
            return "Type=Z";
        }
    };
    protected static final ExpressionType finishBooleanExpr = new ExpressionType(){

        @Override
        public char typeChar() {
            return 'z';
        }

        @Override
        public ExpressionType checkArgument(Value value, Value value2) {
            return booleanExpr;
        }

        public String toString() {
            return "Type=z";
        }
    };
    protected static final ExpressionType stringExpr = new ExpressionType(){

        @Override
        public char typeChar() {
            return 't';
        }

        @Override
        public ExpressionType checkArgument(Value value, Value value2) {
            if (value.type != 't') {
                value.stringVal = value.stringValue();
                value.type = (char)116;
            }
            if (value2.type != 't') {
                value2.stringVal = value2.stringValue();
            }
            return this;
        }

        public String toString() {
            return "Type=t";
        }
    };
    protected static final ExpressionType objExpr = new ExpressionType(){

        @Override
        public char typeChar() {
            return 'o';
        }

        @Override
        public ExpressionType checkArgument(Value value, Value value2) throws Exception {
            if (value.type == '?') {
                value.type = value2.type;
                switch (value2.type) {
                    case 'Z': {
                        value.etype = booleanExpr;
                        return value.etype;
                    }
                    case 'D': {
                        value.etype = doubleExpr;
                        return value.etype;
                    }
                    case 'F': {
                        value.etype = floatExpr;
                        return value.etype;
                    }
                    case 'I': {
                        value.etype = intExpr;
                        return value.etype;
                    }
                    case 'J': {
                        value.etype = longExpr;
                        return value.etype;
                    }
                    case 'o': {
                        value.etype = objExpr;
                        return value.etype;
                    }
                    case 'e': {
                        value.etype = objExpr;
                        return value.etype;
                    }
                    case 't': {
                        value.etype = stringExpr;
                        return value.etype;
                    }
                    case '?': {
                        throw new IllegalArgumentException("the type is not determined while operation.");
                    }
                }
                throw new IllegalArgumentException("unknown type char: " + value2.type);
            }
            if (value.type != 't') {
                value.stringVal = value.stringValue();
                value.type = (char)116;
            }
            if (value2.type != 't') {
                value2.stringVal = value2.stringValue();
            }
            value.etype = stringExpr;
            return value.etype;
        }

        public String toString() {
            return "Type=o";
        }
    };
    protected static final ExpressionType variableNotFoundExpr = new ExpressionType(){

        @Override
        public char typeChar() {
            return 'e';
        }

        @Override
        public ExpressionType checkArgument(Value value, Value value2) throws Exception {
            if (value.type == '?') {
                value.type = (char)101;
            }
            value.etype = this;
            return value.etype;
        }

        public String toString() {
            return "Type=e";
        }
    };
    protected final List<Operation> listOperations = new ArrayList<Operation>();
    protected final Stack<Value> stack = new Stack();
    protected Value accu = new Value();
    protected String[] variables;
    protected static Map<String, Operator> operators;

    public CalculatorExpr() {
        if (operators == null) {
            operators = new TreeMap<String, Operator>();
            operators.put("!", Operators.setOperation);
            operators.put("!set", Operators.setOperation);
            operators.put("+", Operators.addOperation);
            operators.put("-", Operators.subOperation);
            operators.put("*", Operators.mulOperation);
            operators.put("/", Operators.divOperation);
            operators.put(">=", Operators.cmpGreaterEqualOperation);
            operators.put(">", Operators.cmpGreaterThanOperation);
            operators.put("<=", Operators.cmpLessEqualOperation);
            operators.put("<", Operators.cmpLessThanOperation);
            operators.put("!=", Operators.cmpNeOperation);
            operators.put("<>", Operators.cmpNeOperation);
            operators.put("==", Operators.cmpEqOperation);
            operators.put("lt", Operators.cmpLessThanOperation);
            operators.put("le", Operators.cmpLessEqualOperation);
            operators.put("gt", Operators.cmpGreaterThanOperation);
            operators.put("ge", Operators.cmpGreaterEqualOperation);
            operators.put("eq", Operators.cmpEqOperation);
            operators.put("ne", Operators.cmpNeOperation);
            operators.put("instanceof", Operators.cmpInstanceofOperation);
            operators.put("!||", Operators.boolCheckOrOperation);
            operators.put("||", Operators.boolOrOperation);
            operators.put("!&&", Operators.boolCheckAndOperation);
            operators.put("&&", Operators.boolAndOperation);
            operators.put("ub", Operators.boolOperation);
            operators.put("u!", Operators.boolNotOperation);
            operators.put("u~", Operators.bitNotOperation);
            operators.put("u-", Operators.negOperation);
        }
    }

    public static String[] splitFnNameAndParams(String string) {
        String[] stringArray = new String[2];
        int n = string.indexOf(40);
        if (n >= 0) {
            stringArray[0] = string.substring(0, n).trim();
            int n2 = string.lastIndexOf(41);
            if (n2 < 0) {
                n2 = string.length();
            }
            stringArray[1] = string.substring(n + 1, n2);
        } else {
            stringArray[0] = string.trim();
            stringArray[1] = null;
        }
        return stringArray;
    }

    public static String[] splitFnParams(String string) {
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim();
        }
        return stringArray;
    }

    public static int sh(int n, int n2) {
        return n2 >= 0 ? n << n2 : n >> -n2;
    }

    public static int shmask(int n, byte by, int n2) {
        return by >= 0 ? n << by & n2 : n >> -by & n2;
    }

    public static int masksh(int n, int n2, byte by) {
        if (by >= 0) {
            return (n & n2) << by;
        }
        int n3 = (n & n2) >> by;
        if (n3 < 0) {
            int n4 = Integer.MAX_VALUE >> -by - 1;
            n3 &= n4;
        }
        return n3;
    }

    public String setExpr(String string, String[] stringArray) {
        this.listOperations().clear();
        this.variables = stringArray;
        StringPartScan stringPartScan = new StringPartScan(string);
        try {
            this.parseAddExpr(stringPartScan, "!", 1);
        }
        catch (ParseException parseException) {
            return parseException.getMessage();
        }
        return null;
    }

    public String setExpr(String string) {
        this.listOperations().clear();
        this.variables = new String[]{"X"};
        StringPartScan stringPartScan = new StringPartScan(string);
        try {
            this.parseAddExpr(stringPartScan, "!", 1);
        }
        catch (ParseException parseException) {
            return parseException.getMessage();
        }
        return null;
    }

    protected void parseAddExpr(StringPartScan stringPartScan, String string, int n) throws ParseException {
        if (n > 1000) {
            throw new RuntimeException("recursion");
        }
        String string2 = string;
        while (string2 != null) {
            this.parseMultExpr(stringPartScan, string2, n + 1);
            if (stringPartScan.scanSkipSpace().length() > 0) {
                char c = stringPartScan.getCurrentChar();
                if ("+-".indexOf(c) >= 0) {
                    stringPartScan.seek(1).scan().scanOk();
                    string2 = "" + c;
                    continue;
                }
                string2 = null;
                continue;
            }
            string2 = null;
        }
    }

    protected String parseMultExpr(StringPartScan stringPartScan, String string, int n) throws ParseException {
        if (n > 1000) {
            throw new RuntimeException("recursion");
        }
        String string2 = null;
        String string3 = string;
        while (string3 != null) {
            this.parseArgument(stringPartScan, string3, n);
            if (stringPartScan.scanSkipSpace().length() > 0) {
                char c = stringPartScan.getCurrentChar();
                if ("*/".indexOf(c) >= 0) {
                    stringPartScan.seek(1).scan().scanOk();
                    string3 = "" + c;
                    continue;
                }
                string3 = null;
                continue;
            }
            string3 = null;
        }
        return string2;
    }

    protected void parseArgument(StringPartScan stringPartScan, String string, int n) throws ParseException {
        if (stringPartScan.scanSkipSpace().scan("(").scanOk()) {
            this.parseAddExpr(stringPartScan, "!", n + 1);
            if (!stringPartScan.scanSkipSpace().scan(")").scanOk()) {
                throw new ParseException(") expected", (int)stringPartScan.getCurrentPosition());
            }
            this.listOperations.add(new Operation(string, -2));
        } else if (stringPartScan.scanSkipSpace().scanIdentifier().scanOk()) {
            int n2;
            CharSequence charSequence = stringPartScan.getLastScannedString();
            for (n2 = 0; n2 < this.variables.length; ++n2) {
                if (!StringFunctions.equals(this.variables[n2], charSequence)) continue;
                this.listOperations.add(new Operation(string, n2));
                n2 = 0x7FFFFFFE;
            }
            if (n2 != Integer.MAX_VALUE) {
                throw new ParseException("Variable not found: " + charSequence, (int)stringPartScan.getCurrentPosition());
            }
        } else if (stringPartScan.scanSkipSpace().scanInteger().scanOk()) {
            Value value = new Value();
            boolean bl = stringPartScan.getLastScannedIntegerSign();
            long l = stringPartScan.getLastScannedIntegerNumber();
            if (stringPartScan.scanFractionalNumber(l, bl).scanOk()) {
                double d = stringPartScan.getLastScannedFloatNumber();
                if (stringPartScan.scan("F").scanOk()) {
                    value.floatVal = (float)d;
                    value.type = (char)70;
                    value.etype = floatExpr;
                } else {
                    value.doubleVal = d;
                    value.type = (char)68;
                    value.etype = doubleExpr;
                }
            } else if (l < 0x80000000L && l >= Integer.MIN_VALUE) {
                value.intVal = (int)l;
                value.type = (char)73;
                value.etype = intExpr;
            } else {
                value.longVal = l;
                value.type = (char)74;
                value.etype = longExpr;
            }
            this.listOperations.add(new Operation(string, value));
        }
    }

    public void addOperation(Operation operation) {
        this.listOperations.add(operation);
    }

    public List<Operation> listOperations() {
        return this.listOperations;
    }

    public static Operator getOperator(String string) {
        return operators.get(string);
    }

    public void XXXaddExprToStack(Object object, String string) {
        Operator operator = operators.get(string);
        if (operator == null) {
            throw new IllegalArgumentException("unknown Operation: " + string);
        }
        Operation operation = new Operation(operator, object);
        this.listOperations.add(operation);
    }

    public void XXXaddExprToStack(int n, String string) {
        Operator operator = operators.get(string);
        if (operator == null) {
            throw new IllegalArgumentException("unknown Operation: " + string);
        }
        Operation operation = new Operation(operator, n);
        this.listOperations.add(operation);
    }

    public double calc(double d) {
        try {
            this.calcDataAccess(null, d);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return this.accu.doubleValue();
    }

    public float Oldcalc(float f) {
        float f2 = 0.0f;
        for (Operation operation : this.listOperations) {
            float f3 = operation.ixVariable >= 0 ? f : (float)operation.value_d;
            switch (operation.operatorChar) {
                case '!': {
                    f2 = f3;
                    break;
                }
                case '+': {
                    f2 += f3;
                    break;
                }
                case '-': {
                    f2 -= f3;
                    break;
                }
                case '*': {
                    f2 *= f3;
                    break;
                }
                case '/': {
                    f2 /= f3;
                }
            }
        }
        return f2;
    }

    public float calc(float f) {
        try {
            this.calcDataAccess(null, Float.valueOf(f));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return this.accu.floatValue();
    }

    public long calcLong(long l) {
        try {
            this.calcDataAccess(null, l);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return (long)this.accu.doubleValue();
    }

    public long calcLong(int n) {
        try {
            this.calcDataAccess(null, n);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return this.accu.intValue();
    }

    public float Oldcalc(int n) {
        float f = 0.0f;
        for (Operation operation : this.listOperations) {
            float f2 = operation.ixVariable >= 0 ? (float)n : (float)operation.value_d;
            switch (operation.operatorChar) {
                case '!': {
                    f = f2;
                    break;
                }
                case '+': {
                    f += f2;
                    break;
                }
                case '-': {
                    f -= f2;
                    break;
                }
                case '*': {
                    f *= f2;
                    break;
                }
                case '/': {
                    f /= f2;
                }
            }
        }
        return f;
    }

    public Value calc(Object ... objectArray) {
        try {
            return this.calcDataAccess(null, objectArray);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public Value calcDataAccess(Map<String, DataAccess.Variable<Object>> map, Object ... objectArray) throws Exception {
        this.accu = new Value();
        Value value = new Value();
        int n = 0;
        int n2 = this.listOperations.size();
        while (n < n2) {
            Value value2;
            Iterator<Operator> iterator;
            Operation operation = this.listOperations.get(n);
            ++n;
            if (!operation.operator.isBoolCheck() && operation.ixVariable >= 0) {
                iterator = objectArray[operation.ixVariable];
                CalculatorExpr.convertObj(value, iterator);
                value2 = value;
            } else if (operation.ixVariable == -2) {
                value2 = this.accu;
                this.accu = this.stack.pop();
            } else if (operation.datapath != null) {
                try {
                    iterator = operation.datapath.access(map, true, false);
                    CalculatorExpr.convertObj(value, iterator);
                    value2 = value;
                }
                catch (Exception exception) {
                    value.type = (char)101;
                    value.oVal = exception;
                    value.etype = variableNotFoundExpr;
                    value2 = value;
                }
            } else {
                value2 = operation.value;
            }
            if (operation.operator == Operators.setOperation && this.accu.type != '?') {
                iterator = this.accu.etype;
                this.stack.push(this.accu);
                this.accu = new Value();
                this.accu.etype = iterator;
            }
            if (!operation.operator.isUnary() && value2 != null) {
                this.accu.etype.checkArgument(this.accu, value2);
            }
            if (operation.unaryOperator != null) {
                if (value2 != null && value2 != value) {
                    value.copy(value2);
                    value2 = value;
                }
                operation.unaryOperator.operate(value2, null);
            } else if (operation.unaryOperators != null) {
                if (value2 != null && value2 != value) {
                    value.copy(value2);
                    value2 = value;
                }
                for (Operator operator : operation.unaryOperators) {
                    operator.operate(value2, null);
                }
            }
            operation.operator.operate(this.accu, value2);
            if (this.accu.etype != finishBooleanExpr) continue;
            n = operation.ixVariable;
        }
        return this.accu;
    }

    static void convertObj(Value value, Object object) {
        value.oVal = object;
        if (object instanceof Value) {
            value.copy((Value)object);
        } else if (object instanceof Long) {
            value.longVal = (Long)object;
            value.type = (char)74;
            value.etype = longExpr;
        } else if (object instanceof Integer) {
            value.intVal = (Integer)object;
            value.type = (char)73;
            value.etype = intExpr;
        } else if (object instanceof Short) {
            value.intVal = ((Short)object).intValue();
            value.type = (char)73;
            value.etype = intExpr;
        } else if (object instanceof Byte) {
            value.intVal = ((Byte)object).intValue();
            value.type = (char)73;
            value.etype = intExpr;
        } else if (object instanceof Boolean) {
            value.boolVal = (Boolean)object;
            value.type = (char)90;
            value.etype = booleanExpr;
        } else if (object instanceof Double) {
            value.doubleVal = (Double)object;
            value.type = (char)68;
            value.etype = doubleExpr;
        } else if (object instanceof Float) {
            value.floatVal = ((Float)object).floatValue();
            value.type = (char)70;
            value.etype = floatExpr;
        } else if (object instanceof StringSeq) {
            value.stringVal = (StringSeq)object;
            value.type = (char)116;
            value.etype = stringExpr;
        } else {
            value.type = (char)111;
            value.etype = objExpr;
        }
    }

    public static class SetExprBase {
        private Operation actOperation;
        public final CalculatorExpr expr;
        protected final Object dbgParent;

        public SetExprBase(boolean bl, Object object) {
            this.expr = new CalculatorExpr();
            this.dbgParent = object;
        }

        public SetExprBase(boolean bl) {
            this.expr = new CalculatorExpr();
            this.dbgParent = null;
        }

        public SetExprBase(CalculatorExpr calculatorExpr) {
            this.expr = calculatorExpr;
            this.dbgParent = null;
        }

        public SetExprBase(SetExprBase setExprBase) {
            this.expr = setExprBase.expr;
            this.dbgParent = setExprBase;
        }

        public class SetExpr {
            public final SetExpr parent;
            private final List<Operator> unaryOperators = new ArrayList<Operator>();
            private final int ixList;

            public SetExpr() {
                this.parent = null;
                this.ixList = 0;
            }

            private SetExpr(SetExpr setExpr) {
                this.parent = setExpr;
                this.ixList = SetExprBase.this.expr.listOperations.size();
            }

            public CalculatorExpr expr() {
                return SetExprBase.this.expr;
            }

            public SetExpr new_parenthesisExpr() {
                if (SetExprBase.this.actOperation != null) {
                    this.addToOperations();
                }
                SetExpr setExpr = new SetExpr(this);
                return setExpr;
            }

            public void add_parenthesisExpr(SetExpr setExpr) {
                setExpr.closeExprPreparation();
            }

            public SetExpr new_boolOrOperation() {
                if (SetExprBase.this.actOperation != null) {
                    this.addToOperations();
                }
                return this;
            }

            public void add_boolOrOperation(SetExpr setExpr) {
                if (SetExprBase.this.actOperation == null) {
                    SetExprBase.this.actOperation = new Operation();
                    SetExprBase.this.actOperation.setStackOperand();
                }
                SetExprBase.this.actOperation.setOperator("||");
                this.addToOperations();
            }

            public SetExpr set_boolCheckAndOperation() {
                if (SetExprBase.this.actOperation != null) {
                    this.addToOperations();
                }
                SetExprBase.this.actOperation = new Operation();
                SetExprBase.this.actOperation.setOperator("!&&");
                ((SetExprBase)SetExprBase.this).actOperation.ixVariable = -6;
                return this;
            }

            public SetExpr set_boolCheckOrOperation() {
                if (SetExprBase.this.actOperation != null) {
                    this.addToOperations();
                }
                SetExprBase.this.actOperation = new Operation();
                SetExprBase.this.actOperation.setOperator("!||");
                ((SetExprBase)SetExprBase.this).actOperation.ixVariable = -6;
                return this;
            }

            public SetExpr new_boolAndOperation() {
                if (SetExprBase.this.actOperation != null) {
                    this.addToOperations();
                }
                return this;
            }

            public void add_boolAndOperation(SetExpr setExpr) {
                if (SetExprBase.this.actOperation == null) {
                    SetExprBase.this.actOperation = new Operation();
                    SetExprBase.this.actOperation.setStackOperand();
                }
                SetExprBase.this.actOperation.setOperator("&&");
                this.addToOperations();
            }

            public void set_boolNot(String string) {
                this.unaryOperators.add(CalculatorExpr.getOperator("u!"));
            }

            public SetExpr new_cmpOperation() {
                if (SetExprBase.this.actOperation != null) {
                    this.addToOperations();
                }
                SetExprBase.this.actOperation = new Operation();
                return this;
            }

            public void add_cmpOperation(SetExpr setExpr) {
                this.addToOperations();
            }

            public void set_cmpOperator(String string) {
                if (SetExprBase.this.actOperation == null) {
                    assert (false);
                    SetExprBase.this.actOperation = new Operation();
                }
                SetExprBase.this.actOperation.setOperator(string);
            }

            public void set_unaryOperator(String string) {
                Operator operator = CalculatorExpr.getOperator("u" + string);
                assert (operator != null);
                this.unaryOperators.add(operator);
            }

            public SetExpr new_addOperation() {
                if (SetExprBase.this.actOperation != null) {
                    this.addToOperations();
                }
                assert (SetExprBase.this.actOperation == null);
                return this;
            }

            public void add_addOperation(SetExpr setExpr) {
                if (SetExprBase.this.actOperation == null) {
                    SetExprBase.this.actOperation = new Operation();
                    SetExprBase.this.actOperation.setStackOperand();
                }
                SetExprBase.this.actOperation.setOperator("+");
                this.addToOperations();
            }

            public SetExpr new_subOperation() {
                if (SetExprBase.this.actOperation != null) {
                    this.addToOperations();
                }
                assert (SetExprBase.this.actOperation == null);
                return this;
            }

            public void add_subOperation(SetExpr setExpr) {
                if (SetExprBase.this.actOperation == null) {
                    SetExprBase.this.actOperation = new Operation();
                    SetExprBase.this.actOperation.setStackOperand();
                }
                SetExprBase.this.actOperation.setOperator("-");
                this.addToOperations();
            }

            public SetExpr new_multOperation() {
                if (SetExprBase.this.actOperation != null) {
                    this.addToOperations();
                }
                assert (SetExprBase.this.actOperation == null);
                return this;
            }

            public void add_multOperation(SetExpr setExpr) {
                if (SetExprBase.this.actOperation == null) {
                    SetExprBase.this.actOperation = new Operation();
                    SetExprBase.this.actOperation.setStackOperand();
                }
                SetExprBase.this.actOperation.setOperator("*");
                this.addToOperations();
            }

            public void set_charValue(String string) {
                if (SetExprBase.this.actOperation == null) {
                    SetExprBase.this.actOperation = new Operation();
                }
                SetExprBase.this.actOperation.set_charValue(string.charAt(0));
            }

            public void set_intValue(int n) {
                if (SetExprBase.this.actOperation == null) {
                    SetExprBase.this.actOperation = new Operation();
                }
                SetExprBase.this.actOperation.set_intValue(n);
            }

            public void set_doubleValue(double d) {
                if (SetExprBase.this.actOperation == null) {
                    SetExprBase.this.actOperation = new Operation();
                }
                SetExprBase.this.actOperation.set_doubleValue(d);
            }

            public void set_textValue(String string) {
                if (SetExprBase.this.actOperation == null) {
                    SetExprBase.this.actOperation = new Operation();
                }
                SetExprBase.this.actOperation.set_textValue(string);
            }

            protected DataAccess.DataAccessSet newDataAccessSet() {
                return new DataAccess.DataAccessSet();
            }

            public DataAccess.DataAccessSet new_dataAccess() {
                if (SetExprBase.this.actOperation != null) {
                    Debugutil.stop();
                }
                if (SetExprBase.this.actOperation == null) {
                    SetExprBase.this.actOperation = new Operation();
                }
                if (((SetExprBase)SetExprBase.this).actOperation.datapath == null) {
                    ((SetExprBase)SetExprBase.this).actOperation.datapath = this.newDataAccessSet();
                }
                return ((SetExprBase)SetExprBase.this).actOperation.datapath;
            }

            public void add_dataAccess(DataAccess.DataAccessSet dataAccessSet) {
            }

            public DataAccess onlyDataAccess() {
                if ((SetExprBase.this.expr.listOperations == null || SetExprBase.this.expr.listOperations.size() == 0) && SetExprBase.this.actOperation != null && this.unaryOperators.size() == 0 && ((SetExprBase)SetExprBase.this).actOperation.unaryOperator == null && ((SetExprBase)SetExprBase.this).actOperation.unaryOperators == null && ((SetExprBase)SetExprBase.this).actOperation.value == null && ((SetExprBase)SetExprBase.this).actOperation.datapath != null) {
                    return ((SetExprBase)SetExprBase.this).actOperation.datapath;
                }
                return null;
            }

            public void closeExprPreparation() {
                if (SetExprBase.this.actOperation != null) {
                    this.addToOperations();
                }
                int n = SetExprBase.this.expr.listOperations.size();
                for (int i = this.ixList; i < n; ++i) {
                    Operation operation = SetExprBase.this.expr.listOperations.get(i);
                    if (operation.ixVariable != -6) continue;
                    operation.ixVariable = n;
                }
            }

            private void addToOperations() {
                if (!SetExprBase.this.actOperation.hasOperator()) {
                    SetExprBase.this.actOperation.setOperator("!set");
                }
                if (this.unaryOperators.size() == 1) {
                    SetExprBase.this.actOperation.addUnaryOperator(this.unaryOperators.get(0));
                } else if (this.unaryOperators.size() > 1) {
                    ListIterator<Operator> listIterator = this.unaryOperators.listIterator();
                    while (listIterator.hasPrevious()) {
                        Operator operator = listIterator.previous();
                        SetExprBase.this.actOperation.addUnaryOperator(operator);
                    }
                }
                this.unaryOperators.clear();
                SetExprBase.this.expr.addOperation(SetExprBase.this.actOperation);
                SetExprBase.this.actOperation = null;
            }

            private void addUnaryToOperations() {
                if (this.unaryOperators != null) {
                    ListIterator<Operator> listIterator = this.unaryOperators.listIterator();
                    while (listIterator.hasNext()) {
                        listIterator.next();
                    }
                    while (listIterator.hasPrevious()) {
                        Operator operator = listIterator.previous();
                        Operation operation = new Operation(operator, -3);
                        SetExprBase.this.expr.addOperation(operation);
                    }
                    this.unaryOperators.clear();
                }
            }
        }
    }

    public static class Operation {
        protected static final int kArgumentUndefined = -4;
        public static final int kConstant = -1;
        public static final int kDatapath = -5;
        public static final int kStackOperand = -2;
        public static final int kUnaryOperation = -3;
        private static final int kCheckBoolExpr = -6;
        @Deprecated
        private char operatorChar;
        protected Operator operator;
        Operator unaryOperator;
        List<Operator> unaryOperators;
        protected int ixVariable;
        @Deprecated
        double value_d;
        @Deprecated
        Object oValue;
        protected Value value;
        protected DataAccess.DataAccessSet datapath;

        public Operation() {
            this.ixVariable = -4;
        }

        public Operation(String string, Value value) {
            this.setOperator(string);
            this.ixVariable = this.operator.isUnary() ? -3 : -4;
            this.value = value;
        }

        public Operation(Operator operator, Value value) {
            this.operator = operator;
            this.operatorChar = operator.name.charAt(0);
            this.ixVariable = this.operator.isUnary() ? -3 : -4;
            this.value = value;
        }

        public Operation(Operator operator, int n) {
            this.operator = operator;
            this.operatorChar = operator.name.charAt(0);
            this.ixVariable = n;
            if (operator.isUnary()) assert (n == -3);
        }

        public Operation(String string, int n) {
            this.setOperator(string);
            this.ixVariable = n;
        }

        Operation(String string, double d) {
            this.value_d = d;
            this.value = new Value(d);
            this.operator = CalculatorExpr.getOperator(string);
            this.operatorChar = this.operator.name.charAt(0);
            this.ixVariable = -1;
            this.oValue = null;
        }

        Operation(Operator operator, Object object) {
            this.value_d = 0.0;
            this.operator = operator;
            this.operatorChar = operator.name.charAt(0);
            this.ixVariable = -1;
            this.oValue = object;
        }

        public boolean hasOperator() {
            return this.operator != null;
        }

        public boolean hasUnaryOperator() {
            return this.unaryOperator != null || this.unaryOperators != null;
        }

        public void add_datapathElement(DataAccess.DatapathElement datapathElement) {
            if (this.datapath == null) {
                this.datapath = new DataAccess.DataAccessSet();
            }
            this.datapath.add_datapathElement(datapathElement);
        }

        public void set_intValue(int n) {
            if (this.value == null) {
                this.value = new Value();
            }
            this.value.type = (char)73;
            this.value.etype = intExpr;
            this.value.intVal = n;
        }

        public void set_doubleValue(double d) {
            if (this.value == null) {
                this.value = new Value();
            }
            this.value.type = (char)68;
            this.value.etype = doubleExpr;
            this.value.doubleVal = d;
        }

        public void set_charValue(char c) {
            if (this.value == null) {
                this.value = new Value();
            }
            this.value.type = (char)67;
            this.value.etype = intExpr;
            this.value.intVal = c;
        }

        public void set_textValue(String string) {
            if (this.value == null) {
                this.value = new Value();
            }
            this.value.type = (char)116;
            this.value.etype = stringExpr;
            this.value.stringVal = StringSeq.create(string);
        }

        public void setStackOperand() {
            this.ixVariable = -2;
        }

        public void addUnaryOperator(Operator operator) {
            if (this.unaryOperators != null) {
                this.unaryOperators.add(operator);
            } else if (this.unaryOperator != null) {
                this.unaryOperators = new ArrayList<Operator>();
                this.unaryOperators.add(this.unaryOperator);
                this.unaryOperators.add(operator);
                this.unaryOperator = null;
            } else {
                this.unaryOperator = operator;
            }
        }

        public boolean addUnaryOperator(String string) {
            Operator operator = operators.get(string);
            if (operator != null) {
                this.addUnaryOperator(operator);
                return true;
            }
            return false;
        }

        public void setOperator(Operator operator) {
            this.operator = operator;
            this.operatorChar = operator.name.charAt(0);
            if (operator.isUnary()) {
                this.ixVariable = -3;
            }
        }

        public boolean setOperator(String string) {
            if (string.equals("?instanceof")) {
                Debugutil.stop();
            }
            Operator operator = operators.get(string);
            this.operatorChar = operator.name.charAt(0);
            if (operator != null) {
                this.setOperator(operator);
            }
            return this.operator != null;
        }

        public DataAccess datapath() {
            return this.datapath;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.operator);
            if (this.unaryOperator != null) {
                stringBuilder.append(" ").append(this.unaryOperator);
            }
            if (this.unaryOperators != null) {
                stringBuilder.append(" ").append(this.unaryOperators);
            }
            stringBuilder.append(' ');
            if (this.ixVariable >= 0) {
                stringBuilder.append(" arg[").append(this.ixVariable).append("]");
            } else if (this.ixVariable == -1) {
                stringBuilder.append(" const ");
            } else if (this.ixVariable == -2) {
                stringBuilder.append(" stack ");
            } else if (this.ixVariable == -3) {
                stringBuilder.append(" unary:accu ");
            } else if (this.ixVariable == -4) {
                stringBuilder.append(" arg undef ");
            } else if (this.ixVariable == -5) {
                stringBuilder.append(" datapath: ");
            } else if (this.ixVariable != 0) {
                stringBuilder.append(" ?unknown ixVariable=").append(this.ixVariable);
            }
            if (this.datapath != null) {
                stringBuilder.append(this.datapath.toString());
            }
            if (this.oValue != null) {
                stringBuilder.append(" oValue:").append(this.oValue.toString());
            }
            if (this.value != null) {
                stringBuilder.append(" ").append(this.value.toString());
            }
            return stringBuilder.toString();
        }
    }

    protected static class Operators {
        protected static final Operator boolOperation = new Operator("bool "){

            @Override
            public void operate(Value value, Value value2) {
                value.boolVal = value.booleanValue();
                value.type = (char)90;
                value.etype = booleanExpr;
            }

            @Override
            public boolean isUnary() {
                return true;
            }

            @Override
            public boolean isBoolCheck() {
                return false;
            }
        };
        protected static final Operator boolNotOperation = new Operator("b!"){

            @Override
            public void operate(Value value, Value value2) {
                value.boolVal = !value.booleanValue();
                value.type = (char)90;
                value.etype = booleanExpr;
            }

            @Override
            public boolean isUnary() {
                return true;
            }

            @Override
            public boolean isBoolCheck() {
                return false;
            }
        };
        protected static final Operator bitNotOperation = new Operator("~u"){

            @Override
            public void operate(Value value, Value value2) throws Exception {
                switch (value.etype.typeChar()) {
                    case 'B': 
                    case 'C': 
                    case 'I': 
                    case 'S': {
                        value.intVal ^= 0xFFFFFFFF;
                        break;
                    }
                    case 'J': {
                        value.longVal ^= 0xFFFFFFFFFFFFFFFFL;
                        break;
                    }
                    case 'Z': {
                        value.boolVal = !value.boolVal;
                        break;
                    }
                    case 'e': {
                        throw (Exception)value.oVal;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown type" + value.etype.toString());
                    }
                }
            }

            @Override
            public boolean isUnary() {
                return true;
            }

            @Override
            public boolean isBoolCheck() {
                return false;
            }
        };
        protected static final Operator negOperation = new Operator("-u"){

            @Override
            public void operate(Value value, Value value2) throws Exception {
                switch (value.etype.typeChar()) {
                    case 'B': 
                    case 'C': 
                    case 'I': 
                    case 'S': {
                        value.intVal = -value.intVal;
                        break;
                    }
                    case 'J': {
                        value.longVal = -value.longVal;
                        break;
                    }
                    case 'D': {
                        value.doubleVal = -value.doubleVal;
                        break;
                    }
                    case 'F': {
                        value.floatVal = -value.floatVal;
                        break;
                    }
                    case 'Z': {
                        value.boolVal = !value.boolVal;
                        break;
                    }
                    case 'e': {
                        throw (Exception)value.oVal;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown type" + value.etype.toString());
                    }
                }
            }

            @Override
            public boolean isUnary() {
                return true;
            }

            @Override
            public boolean isBoolCheck() {
                return false;
            }
        };
        protected static final Operator addOperation = new Operator("+"){

            @Override
            public void operate(Value value, Value value2) throws Exception {
                switch (value.etype.typeChar()) {
                    case 'B': 
                    case 'I': 
                    case 'S': {
                        value.intVal += value2.intVal;
                        break;
                    }
                    case 'J': {
                        value.longVal += value2.longVal;
                        break;
                    }
                    case 'D': {
                        value.doubleVal += value2.doubleVal;
                        break;
                    }
                    case 'F': {
                        value.floatVal += value2.floatVal;
                        break;
                    }
                    case 'Z': {
                        value.boolVal |= value2.boolVal;
                        break;
                    }
                    case 'e': {
                        throw (Exception)value.oVal;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown type" + value.etype.toString());
                    }
                }
            }

            @Override
            public boolean isUnary() {
                return false;
            }

            @Override
            public boolean isBoolCheck() {
                return false;
            }
        };
        protected static final Operator subOperation = new Operator("-"){

            @Override
            public void operate(Value value, Value value2) throws Exception {
                switch (value.etype.typeChar()) {
                    case 'I': {
                        value.intVal -= value2.intVal;
                        break;
                    }
                    case 'J': {
                        value.longVal -= value2.longVal;
                        break;
                    }
                    case 'D': {
                        value.doubleVal -= value2.doubleVal;
                        break;
                    }
                    case 'F': {
                        value.floatVal -= value2.floatVal;
                        break;
                    }
                    case 'e': {
                        throw (Exception)value.oVal;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown type" + value.etype.toString());
                    }
                }
            }

            @Override
            public boolean isUnary() {
                return false;
            }

            @Override
            public boolean isBoolCheck() {
                return false;
            }
        };
        protected static final Operator mulOperation = new Operator("*"){

            @Override
            public void operate(Value value, Value value2) throws Exception {
                switch (value.etype.typeChar()) {
                    case 'I': {
                        value.intVal *= value2.intVal;
                        break;
                    }
                    case 'J': {
                        value.longVal *= value2.longVal;
                        break;
                    }
                    case 'D': {
                        value.doubleVal *= value2.doubleVal;
                        break;
                    }
                    case 'F': {
                        value.floatVal *= value2.floatVal;
                        break;
                    }
                    case 'Z': {
                        value.boolVal &= value2.boolVal;
                        break;
                    }
                    case 'e': {
                        throw (Exception)value.oVal;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown type" + value.etype.toString());
                    }
                }
            }

            @Override
            public boolean isUnary() {
                return false;
            }

            @Override
            public boolean isBoolCheck() {
                return false;
            }
        };
        protected static final Operator divOperation = new Operator("/"){

            @Override
            public void operate(Value value, Value value2) throws Exception {
                switch (value.etype.typeChar()) {
                    case 'I': {
                        value.intVal /= value2.intVal;
                        break;
                    }
                    case 'J': {
                        value.longVal /= value2.longVal;
                        break;
                    }
                    case 'D': {
                        value.doubleVal /= value2.doubleVal;
                        break;
                    }
                    case 'F': {
                        value.floatVal /= value2.floatVal;
                        break;
                    }
                    case 'Z': {
                        value.doubleVal /= value2.doubleVal;
                        break;
                    }
                    case 'e': {
                        throw (Exception)value.oVal;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown type" + value.etype.toString());
                    }
                }
            }

            @Override
            public boolean isUnary() {
                return false;
            }

            @Override
            public boolean isBoolCheck() {
                return false;
            }
        };
        protected static final Operator cmpEqOperation = new Operator(".cmp."){

            @Override
            public void operate(Value value, Value value2) throws Exception {
                switch (value.etype.typeChar()) {
                    case 'I': {
                        value.boolVal = value.intVal == value2.intVal;
                        break;
                    }
                    case 'J': {
                        value.boolVal = value.longVal == value2.longVal;
                        break;
                    }
                    case 'D': {
                        value.boolVal = Math.abs(value.doubleVal - value2.doubleVal) < Math.abs(value.doubleVal) / 100000.0;
                        break;
                    }
                    case 'F': {
                        value.boolVal = Math.abs(value.floatVal - value2.floatVal) < Math.abs(value.floatVal) / 100000.0f;
                        break;
                    }
                    case 'Z': {
                        value.boolVal = value.boolVal == value2.boolVal;
                        break;
                    }
                    case 't': {
                        value.boolVal = StringFunctions.equals(value.stringVal, value2.stringVal);
                        break;
                    }
                    case 'o': {
                        value.boolVal = value.oVal == null && value2.oVal == null || value.oVal != null && value2.oVal != null && value.oVal.equals(value2.oVal);
                        break;
                    }
                    case 'e': {
                        throw (Exception)value.oVal;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown type" + value.etype.toString());
                    }
                }
                value.type = (char)90;
                value.etype = booleanExpr;
            }

            @Override
            public boolean isUnary() {
                return false;
            }

            @Override
            public boolean isBoolCheck() {
                return false;
            }
        };
        protected static final Operator cmpNeOperation = new Operator("!="){

            @Override
            public void operate(Value value, Value value2) throws Exception {
                switch (value.etype.typeChar()) {
                    case 'I': {
                        value.boolVal = value.intVal != value2.intVal;
                        break;
                    }
                    case 'J': {
                        value.boolVal = value.longVal != value2.longVal;
                        break;
                    }
                    case 'D': {
                        value.boolVal = Math.abs(value.doubleVal - value2.doubleVal) >= Math.abs(value.doubleVal) / 100000.0;
                        break;
                    }
                    case 'F': {
                        value.boolVal = Math.abs(value.floatVal - value2.floatVal) >= Math.abs(value.floatVal) / 100000.0f;
                        break;
                    }
                    case 'Z': {
                        value.boolVal = value.boolVal != value2.boolVal;
                        break;
                    }
                    case 't': {
                        value.boolVal = !StringFunctions.equals(value.stringVal, value2.stringVal);
                        break;
                    }
                    case 'o': {
                        value.boolVal = value.oVal != null || value2.oVal != null || value.oVal != null && value2.oVal != null && !value.oVal.equals(value2.oVal);
                        break;
                    }
                    case 'e': {
                        throw (Exception)value.oVal;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown type" + value.etype.toString());
                    }
                }
                value.type = (char)90;
                value.etype = booleanExpr;
            }

            @Override
            public boolean isUnary() {
                return false;
            }

            @Override
            public boolean isBoolCheck() {
                return false;
            }
        };
        protected static final Operator cmpLessThanOperation = new Operator("<"){

            @Override
            public void operate(Value value, Value value2) throws Exception {
                switch (value.etype.typeChar()) {
                    case 'I': {
                        value.boolVal = value.intVal < value2.intVal;
                        break;
                    }
                    case 'J': {
                        value.boolVal = value.longVal < value2.longVal;
                        break;
                    }
                    case 'D': {
                        value.boolVal = value.doubleVal < value2.doubleVal;
                        break;
                    }
                    case 'F': {
                        value.boolVal = value.floatVal < value2.floatVal;
                        break;
                    }
                    case 'Z': {
                        value.boolVal = !value.boolVal && value2.boolVal;
                        break;
                    }
                    case 't': {
                        value.boolVal = StringFunctions.compare(value.stringVal, value2.stringVal) < 0;
                        break;
                    }
                    case 'o': {
                        value.boolVal = value.oVal instanceof Comparable && value2.oVal instanceof Comparable ? ((Comparable)value.oVal).compareTo(value2.oVal) < 0 : false;
                        break;
                    }
                    case 'e': {
                        throw (Exception)value.oVal;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown type" + value.etype.toString());
                    }
                }
                value.type = (char)90;
                value.etype = booleanExpr;
            }

            @Override
            public boolean isUnary() {
                return false;
            }

            @Override
            public boolean isBoolCheck() {
                return false;
            }
        };
        protected static final Operator cmpGreaterEqualOperation = new Operator(">="){

            @Override
            public void operate(Value value, Value value2) throws Exception {
                switch (value.etype.typeChar()) {
                    case 'I': {
                        value.boolVal = value.intVal >= value2.intVal;
                        break;
                    }
                    case 'J': {
                        value.boolVal = value.longVal >= value2.longVal;
                        break;
                    }
                    case 'D': {
                        value.boolVal = value.doubleVal >= value2.doubleVal;
                        break;
                    }
                    case 'F': {
                        value.boolVal = value.floatVal >= value2.floatVal;
                        break;
                    }
                    case 'Z': {
                        value.boolVal = true;
                        break;
                    }
                    case 't': {
                        value.boolVal = StringFunctions.startsWith(value.stringVal, value2.stringVal);
                        break;
                    }
                    case 'o': {
                        value.boolVal = value.oVal instanceof Comparable && value2.oVal instanceof Comparable ? ((Comparable)value.oVal).compareTo(value2.oVal) >= 0 : false;
                        break;
                    }
                    case 'e': {
                        throw (Exception)value.oVal;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown type" + value.etype.toString());
                    }
                }
                value.type = (char)90;
                value.etype = booleanExpr;
            }

            @Override
            public boolean isUnary() {
                return false;
            }

            @Override
            public boolean isBoolCheck() {
                return false;
            }
        };
        protected static final Operator cmpGreaterThanOperation = new Operator(">"){

            @Override
            public void operate(Value value, Value value2) throws Exception {
                switch (value.etype.typeChar()) {
                    case 'I': {
                        value.boolVal = value.intVal > value2.intVal;
                        break;
                    }
                    case 'J': {
                        value.boolVal = value.longVal > value2.longVal;
                        break;
                    }
                    case 'D': {
                        value.boolVal = value.doubleVal > value2.doubleVal;
                        break;
                    }
                    case 'F': {
                        value.boolVal = value.floatVal > value2.floatVal;
                        break;
                    }
                    case 'Z': {
                        value.boolVal = value.boolVal && !value2.boolVal;
                        break;
                    }
                    case 't': {
                        value.boolVal = StringFunctions.compare(value.stringVal, value2.stringVal) > 0;
                        break;
                    }
                    case 'o': {
                        value.boolVal = value.oVal instanceof Comparable && value2.oVal instanceof Comparable ? ((Comparable)value.oVal).compareTo(value2.oVal) > 0 : false;
                        break;
                    }
                    case 'e': {
                        throw (Exception)value.oVal;
                    }
                }
                value.type = (char)90;
                value.etype = booleanExpr;
            }

            @Override
            public boolean isUnary() {
                return false;
            }

            @Override
            public boolean isBoolCheck() {
                return false;
            }
        };
        protected static final Operator cmpLessEqualOperation = new Operator("<="){

            @Override
            public void operate(Value value, Value value2) throws Exception {
                switch (value.etype.typeChar()) {
                    case 'I': {
                        value.boolVal = value.intVal <= value2.intVal;
                        break;
                    }
                    case 'J': {
                        value.boolVal = value.longVal <= value2.longVal;
                        break;
                    }
                    case 'D': {
                        value.boolVal = value.doubleVal <= value2.doubleVal;
                        break;
                    }
                    case 'F': {
                        value.boolVal = value.floatVal <= value2.floatVal;
                        break;
                    }
                    case 'Z': {
                        value.boolVal = true;
                        break;
                    }
                    case 't': {
                        value.boolVal = StringFunctions.compare(value.stringVal, value2.stringVal) <= 0;
                        break;
                    }
                    case 'o': {
                        value.boolVal = value.oVal instanceof Comparable && value2.oVal instanceof Comparable ? ((Comparable)value.oVal).compareTo(value2.oVal) <= 0 : false;
                        break;
                    }
                    case 'e': {
                        throw (Exception)value.oVal;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown type" + value.etype.toString());
                    }
                }
                value.type = (char)90;
                value.etype = booleanExpr;
            }

            @Override
            public boolean isUnary() {
                return false;
            }

            @Override
            public boolean isBoolCheck() {
                return false;
            }
        };
        protected static final Operator boolAndOperation = new Operator("&&"){

            @Override
            public void operate(Value value, Value value2) {
                value.boolVal = value.booleanValue() && value2.booleanValue();
                value.type = (char)90;
                value.etype = booleanExpr;
            }

            @Override
            public boolean isUnary() {
                return false;
            }

            @Override
            public boolean isBoolCheck() {
                return false;
            }
        };
        protected static final Operator boolOrOperation = new Operator("||"){

            @Override
            public void operate(Value value, Value value2) {
                value.boolVal = value.booleanValue() || value2.booleanValue();
                value.type = (char)90;
                value.etype = booleanExpr;
            }

            @Override
            public boolean isUnary() {
                return false;
            }

            @Override
            public boolean isBoolCheck() {
                return false;
            }
        };
        protected static final Operator boolCheckAndOperation = new Operator("!&&"){

            @Override
            public void operate(Value value, Value value2) {
                value.boolVal = value.booleanValue();
                value.type = (char)90;
                value.etype = value.boolVal ? booleanExpr : finishBooleanExpr;
            }

            @Override
            public boolean isUnary() {
                return false;
            }

            @Override
            public boolean isBoolCheck() {
                return true;
            }
        };
        protected static final Operator boolCheckOrOperation = new Operator("!||"){

            @Override
            public void operate(Value value, Value value2) {
                value.boolVal = value.booleanValue();
                value.type = (char)90;
                value.etype = value.boolVal ? finishBooleanExpr : booleanExpr;
            }

            @Override
            public boolean isUnary() {
                return false;
            }

            @Override
            public boolean isBoolCheck() {
                return true;
            }
        };
        protected static final Operator cmpInstanceofOperation = new Operator("?instanceof"){

            @Override
            public void operate(Value value, Value value2) {
                Object object = value2.oVal;
                if (object == null || !(object instanceof Class)) {
                    throw new IllegalArgumentException("\"instanceof\" should compare with a class type instance");
                }
                value.boolVal = value.oVal != null && DataAccess.isOrExtends(value.oVal.getClass(), (Class)object) || object == Float.class && "FISB".indexOf(value.type) >= 0 || object == Double.class && "DFJISB".indexOf(value.type) >= 0 || object == Long.class && "JISB".indexOf(value.type) >= 0 || object == Integer.class && "ISB".indexOf(value.type) >= 0 || object == Short.class && "SB".indexOf(value.type) >= 0 || object == Byte.class && "B".indexOf(value.type) >= 0 || object == Character.class && "C".indexOf(value.type) >= 0 || object == Boolean.class && "Z".indexOf(value.type) >= 0;
                value.type = (char)90;
                value.etype = booleanExpr;
            }

            @Override
            public boolean isUnary() {
                return false;
            }

            @Override
            public boolean isBoolCheck() {
                return false;
            }
        };
        protected static final Operator setOperation = new Operator("!set"){

            @Override
            public void operate(Value value, Value value2) {
                value.type = value2.type;
                value.etype = value2.etype;
                value.oVal = value2.oVal;
                switch (value.type) {
                    case 'B': 
                    case 'C': 
                    case 'I': 
                    case 'S': {
                        value.intVal = value2.intVal;
                        break;
                    }
                    case 'J': {
                        value.longVal = value2.longVal;
                        break;
                    }
                    case 'F': {
                        value.floatVal = value2.floatVal;
                        break;
                    }
                    case 'D': {
                        value.doubleVal = value2.doubleVal;
                        break;
                    }
                    case 'Z': {
                        value.boolVal = value2.boolVal;
                        break;
                    }
                    case 't': {
                        value.stringVal = value2.stringVal;
                        break;
                    }
                    case 'o': {
                        CalculatorExpr.convertObj(value, value2.oVal);
                        break;
                    }
                    case 'e': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown type" + value2.etype.toString());
                    }
                }
            }

            @Override
            public boolean isUnary() {
                return false;
            }

            @Override
            public boolean isBoolCheck() {
                return false;
            }
        };

        protected Operators() {
        }
    }

    public static abstract class Operator {
        protected final String name;

        protected Operator(String string) {
            this.name = string;
        }

        protected abstract void operate(Value var1, Value var2) throws Exception;

        protected abstract boolean isUnary();

        protected abstract boolean isBoolCheck();

        public String toString() {
            return this.name;
        }
    }

    protected static interface ExpressionType {
        public char typeChar();

        public ExpressionType checkArgument(Value var1, Value var2) throws Exception;
    }

    public static class Value {
        protected char type = (char)63;
        ExpressionType etype = startExpr;
        protected long longVal;
        protected int intVal;
        protected double doubleVal;
        protected float floatVal;
        protected boolean boolVal;
        protected CharSequence stringVal;
        protected Object oVal;

        public Value(long l) {
            this.type = (char)74;
            this.etype = longExpr;
            this.longVal = l;
        }

        public Value(int n) {
            this.type = (char)73;
            this.etype = intExpr;
            this.intVal = n;
        }

        public Value(double d) {
            this.type = (char)68;
            this.etype = doubleExpr;
            this.doubleVal = d;
        }

        public Value(float f) {
            this.type = (char)70;
            this.etype = floatExpr;
            this.floatVal = f;
        }

        public Value(boolean bl) {
            this.type = (char)90;
            this.etype = booleanExpr;
            this.boolVal = bl;
        }

        public Value(char c) {
            this.type = (char)67;
            this.etype = intExpr;
            char c2 = c;
            this.intVal = c2;
            this.longVal = c2;
        }

        public Value(String string) {
            this.type = (char)116;
            this.etype = stringExpr;
            this.stringVal = string;
            this.oVal = this.stringVal;
        }

        public Value(Appendable appendable) {
            this.type = (char)97;
            this.etype = objExpr;
            this.oVal = appendable;
        }

        public Value(Object object) {
            this.type = (char)111;
            this.etype = objExpr;
            this.oVal = object;
        }

        public Value() {
            this.type = (char)63;
            this.etype = startExpr;
        }

        public char type() {
            return this.type;
        }

        public void copy(Value value) {
            this.type = value.type;
            this.etype = value.etype;
            this.longVal = value.longVal;
            this.intVal = value.intVal;
            this.doubleVal = value.doubleVal;
            this.floatVal = value.floatVal;
            this.boolVal = value.boolVal;
            this.stringVal = value.stringVal;
            this.oVal = value.oVal;
        }

        public boolean booleanValue() {
            switch (this.type) {
                case 'I': {
                    return this.intVal != 0;
                }
                case 'J': {
                    return this.longVal != 0L;
                }
                case 'D': {
                    return this.doubleVal != 0.0;
                }
                case 'F': {
                    return this.floatVal != 0.0f;
                }
                case 'C': {
                    return this.intVal != 0;
                }
                case 'Z': {
                    return this.boolVal;
                }
                case 't': {
                    return this.stringVal != null && this.stringVal.length() > 0;
                }
                case 'o': {
                    if (this.oVal instanceof Long) {
                        return (Long)this.oVal != 0L;
                    }
                    if (this.oVal instanceof Integer) {
                        return (Integer)this.oVal != 0;
                    }
                    if (this.oVal instanceof Short) {
                        return (Short)this.oVal != 0;
                    }
                    if (this.oVal instanceof Byte) {
                        return (Byte)this.oVal != 0;
                    }
                    if (this.oVal instanceof Double) {
                        return (Double)this.oVal != 0.0;
                    }
                    if (this.oVal instanceof Float) {
                        return ((Float)this.oVal).floatValue() != 0.0f;
                    }
                    if (this.oVal instanceof Boolean) {
                        return (Boolean)this.oVal;
                    }
                    if (this.oVal instanceof Character) {
                        return ((Character)this.oVal).charValue() != '\u0000';
                    }
                    return this.oVal != null;
                }
                case 'e': {
                    return false;
                }
                case '?': {
                    return false;
                }
            }
            throw new IllegalArgumentException("unknown type char: " + this.type);
        }

        public int intValue() {
            switch (this.type) {
                case 'I': {
                    return this.intVal;
                }
                case 'C': {
                    return this.intVal;
                }
                case 'J': {
                    return (int)this.longVal;
                }
                case 'D': {
                    return (int)this.doubleVal;
                }
                case 'F': {
                    return (int)this.floatVal;
                }
                case 'Z': {
                    return this.boolVal ? 1 : 0;
                }
                case 't': {
                    return Integer.parseInt(this.stringVal.toString());
                }
                case 'o': {
                    throw new IllegalArgumentException("Double expected, object given.");
                }
                case '?': {
                    return 7777777;
                }
            }
            throw new IllegalArgumentException("unknown type char: " + this.type);
        }

        public long longValue() {
            switch (this.type) {
                case 'I': {
                    return this.intVal;
                }
                case 'C': {
                    return this.intVal;
                }
                case 'J': {
                    return this.longVal;
                }
                case 'D': {
                    return (long)this.doubleVal;
                }
                case 'F': {
                    return (long)this.floatVal;
                }
                case 'Z': {
                    return this.boolVal ? 1L : 0L;
                }
                case 't': {
                    return Long.parseLong(this.stringVal.toString());
                }
                case 'o': {
                    throw new IllegalArgumentException("Double expected, object given.");
                }
                case '?': {
                    return 777777777777L;
                }
            }
            throw new IllegalArgumentException("unknown type char: " + this.type);
        }

        public double doubleValue() {
            switch (this.type) {
                case 'F': {
                    return this.floatVal;
                }
                case 'I': {
                    return this.intVal;
                }
                case 'C': {
                    return this.intVal;
                }
                case 'J': {
                    return this.longVal;
                }
                case 'D': {
                    return this.doubleVal;
                }
                case 'Z': {
                    return this.boolVal ? 1.0 : 0.0;
                }
                case 't': {
                    return Double.parseDouble(this.stringVal.toString());
                }
                case 'o': {
                    throw new IllegalArgumentException("Double expected, object given.");
                }
                case '?': {
                    return 7777777.0;
                }
            }
            throw new IllegalArgumentException("unknown type char: " + this.type);
        }

        public float floatValue() {
            switch (this.type) {
                case 'I': {
                    return this.intVal;
                }
                case 'C': {
                    return this.intVal;
                }
                case 'J': {
                    return this.longVal;
                }
                case 'D': {
                    return (float)this.doubleVal;
                }
                case 'F': {
                    return this.floatVal;
                }
                case 'Z': {
                    return this.boolVal ? 1.0f : 0.0f;
                }
                case 't': {
                    return Float.parseFloat(this.stringVal.toString());
                }
                case 'o': {
                    throw new IllegalArgumentException("Double expected, object given.");
                }
                case '?': {
                    return 77777.0f;
                }
            }
            throw new IllegalArgumentException("unknown type char: " + this.type);
        }

        public CharSequence stringValue() {
            switch (this.type) {
                case 'I': {
                    return StringSeq.create(Integer.toString(this.intVal));
                }
                case 'J': {
                    return StringSeq.create(Long.toString(this.longVal));
                }
                case 'D': {
                    return StringSeq.create(Double.toString(this.doubleVal));
                }
                case 'F': {
                    return StringSeq.create(Float.toString(this.floatVal));
                }
                case 'C': {
                    return new StringBuilder(1).append((char)this.intVal);
                }
                case 'Z': {
                    return StringSeq.create(Boolean.toString(this.boolVal));
                }
                case 't': {
                    return this.stringVal;
                }
                case 'o': {
                    return StringSeq.create(this.oVal == null ? "null" : this.oVal.toString());
                }
                case 'e': {
                    return StringSeq.create(this.oVal.toString());
                }
                case '?': {
                    return StringSeq.create("??");
                }
            }
            return StringSeq.create("?" + this.type);
        }

        public Object objValue() {
            switch (this.type) {
                case 'I': {
                    return new Integer(this.intVal);
                }
                case 'C': {
                    return new Character((char)this.intVal);
                }
                case 'J': {
                    return new Long(this.longVal);
                }
                case 'D': {
                    return new Double(this.doubleVal);
                }
                case 'F': {
                    return new Float(this.doubleVal);
                }
                case 'Z': {
                    return new Boolean(this.boolVal);
                }
                case 't': {
                    return this.stringVal;
                }
                case 'e': 
                case 'o': {
                    return this.oVal;
                }
            }
            return "?" + this.type;
        }

        public boolean isObjValue() {
            return this.type == 'o';
        }

        public String stringxValue() {
            switch (this.type) {
                case 'I': {
                    return Integer.toString(this.intVal);
                }
                case 'J': {
                    return Long.toString(this.longVal);
                }
                case 'D': {
                    return Double.toString(this.doubleVal);
                }
                case 'F': {
                    return Float.toString(this.floatVal);
                }
                case 'C': {
                    return "" + (char)this.intVal;
                }
                case 'Z': {
                    return Boolean.toString(this.boolVal);
                }
                case 't': {
                    return this.stringVal.toString();
                }
                case 'o': {
                    return this.oVal == null ? "null" : this.oVal.toString();
                }
                case 'e': {
                    return ((Exception)this.oVal).getMessage();
                }
                case '?': {
                    return "??";
                }
            }
            return "?" + this.type;
        }

        public void toNumValue() {
            if ("JISBFD".indexOf(this.type) < 0) {
                String string = this.stringVal != null ? this.stringVal.toString() : (this.oVal != null ? this.oVal.toString() : "0");
                int n = string.length();
                int[] nArray = new int[1];
                long l = StringFunctions_C.parseIntRadix(string, 0, 999999, 10, nArray, " ,'");
                int n2 = nArray[0];
                if (n2 < n && string.charAt(n2) == '.') {
                    long l2 = StringFunctions_C.parseIntRadix(string.substring(n2 + 1), 0, 999999, 10, nArray, " ,'");
                    if (n2 + nArray[0] > 7) {
                        // empty if block
                    }
                }
                if ("DF".indexOf(this.type) < 0) {
                    if (n <= 9) {
                        this.intVal = (int)l;
                        this.type = (char)73;
                        this.etype = intExpr;
                    } else {
                        this.longVal = l;
                        this.type = (char)76;
                        this.etype = longExpr;
                    }
                }
            }
        }

        public String toString() {
            char c = this.etype == null ? (char)'?' : (char)this.etype.typeChar();
            switch (this.type) {
                case 'I': {
                    return c + "I " + Integer.toString(this.intVal);
                }
                case 'J': {
                    return c + "J " + Long.toString(this.longVal);
                }
                case 'D': {
                    return c + "D " + Double.toString(this.doubleVal);
                }
                case 'F': {
                    return c + "F " + Float.toString(this.floatVal);
                }
                case 'C': {
                    return c + "C " + (char)this.intVal;
                }
                case 'Z': {
                    return c + "Z " + Boolean.toString(this.boolVal);
                }
                case 't': {
                    return c + "t " + this.stringVal.toString();
                }
                case 'o': {
                    return c + "o " + (this.oVal == null ? "null" : this.oVal.toString());
                }
                case 'e': {
                    return c + "e " + (this.oVal instanceof Exception ? ((Exception)this.oVal).getMessage() : (this.oVal == null ? "null" : this.oVal.toString()));
                }
                case '?': {
                    return c + "??";
                }
            }
            return c + "?" + this.type;
        }
    }
}

