/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.mainCmd;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import org.vishia.mainCmd.MainCmd;
import org.vishia.mainCmd.MainCmd_ifc;
import org.vishia.msgDispatch.MsgPrintStream;

public class SampleCmdLine {
    public static final int version = 20130223;

    public static void main(String[] stringArray) {
        Args args = new Args();
        CmdLine cmdLine = new CmdLine(stringArray, args);
        boolean bl = true;
        try {
            cmdLine.parseArguments();
        }
        catch (Exception exception) {
            cmdLine.setExitErrorLevel(5);
            bl = false;
        }
        if (bl) {
            MsgPrintStream msgPrintStream = new MsgPrintStream(cmdLine, 15000, 5000, 100);
            System.setErr(msgPrintStream.getPrintStreamLog("err."));
            UserMain userMain = new UserMain(cmdLine);
            try {
                userMain.execute(args);
            }
            catch (Exception exception) {
                cmdLine.report("Uncatched Exception on main level:", exception);
                cmdLine.setExitErrorLevel(3);
            }
        }
        cmdLine.exit();
    }

    public static class UserMain {
        final MainCmd_ifc console;

        public UserMain(MainCmd_ifc mainCmd_ifc) {
            this.console = mainCmd_ifc;
        }

        void execute(Args args) {
            this.console.writeInfoln("Info: read it please!");
            this.console.writeInfo(" ... this is added to the last info.");
            this.console.writeInfoln("Info: second line!");
            this.console.writeInfo(" ... this is added to the second line.");
            System.err.println("SampleCmdLine - testmessage; any information");
            System.err.printf("SampleCmdLine - testmessage; some more information %d\n", 624);
            try {
                this.executeFiles(args);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            StringBuffer stringBuffer = new StringBuffer(2000);
            this.console.executeCmdLine("cmd /C dir", 3, (Appendable)stringBuffer, null);
            System.out.println("TEST DIRECT PRINTLN:" + stringBuffer.toString());
            this.console.executeCmdLine("notepad.exe " + args.sFileOut, 1, null, null);
            this.console.reportln(3, 2, "Output on report");
            this.console.setExitErrorLevel(3);
        }

        void executeFiles(Args args) throws IOException {
            BufferedWriter bufferedWriter = null;
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(args.sFileIn));
            }
            catch (IOException iOException) {
                this.console.writeError("can't open " + args.sFileIn, iOException);
                this.console.setExitErrorLevel(4);
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                throw new IOException("executeFiles");
            }
            try {
                bufferedWriter = new BufferedWriter(new FileWriter(args.sFileOut));
            }
            catch (IOException iOException) {
                this.console.writeError("can't create " + args.sFileOut, iOException);
                this.console.setExitErrorLevel(4);
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
                throw iOException;
            }
            try {
                int n = 1;
                boolean bl = true;
                while (bl) {
                    String string = bufferedReader.readLine();
                    if (string == null) {
                        bl = false;
                        continue;
                    }
                    bufferedWriter.write(n + ": " + string);
                    bufferedWriter.newLine();
                    ++n;
                }
                bufferedReader.close();
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                this.console.writeError("error reading or writing " + args.sFileIn + " / " + args.sFileOut, iOException);
                this.console.setExitErrorLevel(4);
            }
        }
    }

    static class CmdLine
    extends MainCmd {
        final Args cmdlineArgs;

        private CmdLine(String[] stringArray, Args args) {
            super(stringArray);
            this.cmdlineArgs = args;
            super.addAboutInfo("Sample cmdLine");
            super.addAboutInfo("made by JcHartmut, 2006-01-06");
            super.addHelpInfo("Sample of a java programm.");
            super.addHelpInfo("param: -i:INPUT -o:OUTPUT");
            super.addStandardHelpInfo();
            super.addHelpInfo("-i:INPUT    inputfilepath, this file is testing.");
            super.addHelpInfo("-o:OUTPUT   outputfilepath, this file is written.");
        }

        @Override
        protected boolean testArgument(String string, int n) {
            boolean bl = true;
            if (string.startsWith("-i:")) {
                this.cmdlineArgs.sFileIn = this.getArgument(3);
            } else if (string.startsWith("-o:")) {
                this.cmdlineArgs.sFileOut = this.getArgument(3);
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        protected void callWithoutArguments() throws ParseException {
            this.writeAboutInfo(null);
            this.writeHelpInfo(null);
        }

        @Override
        protected boolean checkArguments() {
            boolean bl = true;
            if (this.cmdlineArgs.sFileIn == null) {
                bl = false;
                this.writeError("ERROR argument -i: is obligat.");
            } else if (this.cmdlineArgs.sFileIn.length() == 0) {
                bl = false;
                this.writeError("ERROR argument -i: without content.");
            }
            if (this.cmdlineArgs.sFileOut == null) {
                this.writeWarning("argument -o: no outputfile is given, use default");
                this.cmdlineArgs.sFileOut = "out.txt";
            } else if (this.cmdlineArgs.sFileOut.length() == 0) {
                bl = false;
                this.writeError("argument -o: without content");
            }
            if (!bl) {
                this.setExitErrorLevel(5);
            }
            bl = true;
            return bl;
        }
    }

    static class Args {
        String sFileIn = null;
        String sFileOut = null;

        Args() {
        }
    }
}

