/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.header2Reflection;

import java.io.File;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.vishia.mainCmd.MainCmd_ifc;
import org.vishia.util.Debugutil;
import org.vishia.util.FileSystem;
import org.vishia.zbnf.ZbnfJavaOutput;
import org.vishia.zbnf.ZbnfParseResultItem;
import org.vishia.zbnf.ZbnfParser;

public class CheaderParser {
    public static final String sVersion = "2018-10-11";
    private final MainCmd_ifc console;

    public CheaderParser(MainCmd_ifc mainCmd_ifc) {
        this.console = mainCmd_ifc;
    }

    public ZbnfResultData execute(Args args) {
        ZbnfResultData zbnfResultData = this.parseAndStoreInput(args);
        return zbnfResultData;
    }

    public static String prepareReflName(String string) {
        String string2 = string.replace('.', '_');
        int n = string.length();
        if (n > 30) {
            string = string.substring(0, 15) + "_" + string.substring(n - 14, n);
        }
        return string2;
    }

    private ZbnfResultData parseAndStoreInput(Args args) {
        ZbnfResultData zbnfResultData = new ZbnfResultData();
        ZbnfParser zbnfParser = new ZbnfParser(this.console);
        File file = new File(args.sFileZbnf);
        if (!file.exists()) {
            throw new IllegalArgumentException("CheaderParser - syntax file not found; " + file.getAbsolutePath());
        }
        try {
            zbnfParser.setSyntax(FileSystem.readFile(file));
        }
        catch (ParseException parseException) {
            String string = "CheaderParser - ERROR in syntax prescript; " + parseException.getMessage();
            throw new IllegalArgumentException(string);
        }
        for (SrcFile srcFile : args.srcFiles) {
            Object object;
            System.out.println(srcFile.name);
            File file2 = new File(srcFile.path);
            boolean bl = false;
            try {
                bl = zbnfParser.parseFile(file2);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("CheaderParser - file ERROR; " + file2.getAbsolutePath() + ":" + exception.getMessage());
            }
            ZbnfParseResultItem zbnfParseResultItem = zbnfParser.getFirstParseResult();
            if (!bl) {
                object = zbnfParser.getSyntaxErrorReport();
                System.err.println("ERROR Parsing file: " + file2.getAbsolutePath() + "\n" + (String)object);
                continue;
            }
            object = new ZbnfResultFile(srcFile.name, srcFile.path);
            try {
                ZbnfJavaOutput.setOutput(object, zbnfParseResultItem, this.console);
            }
            catch (Exception exception) {
                throw new IllegalStateException("CheaderParser - internal ERROR storing parse result; " + exception.getMessage());
            }
            zbnfResultData.files.add((ZbnfResultFile)object);
        }
        return zbnfResultData;
    }

    public static class RefCastingValue
    extends Value {
        public Type type;

        RefCastingValue() {
            super('c');
        }
    }

    public static class Variable
    extends ValueEntry {
        public boolean preDecrement;
        public boolean preIncrement;
        public boolean postDecrement;
        public boolean postIncrement;
        public String simpleVariable;
        public ExternObject externObject;
        public Value index;

        public Variable() {
            super('V');
        }
    }

    public static class ExternObject {
        public List<Value> entries;
        public Value index;

        public void set_association(String string) {
            Value value = new Value();
            value.data = string;
            this.addEntry(value);
        }

        private void addEntry(Value value) {
            if (this.entries == null) {
                this.entries = new LinkedList<Value>();
            }
            this.entries.add(value);
        }
    }

    public static class Number
    extends ValueEntry {
        public double number;
        public String floatModifier;
        public String longModifier;

        Number(char c) {
            super(c);
        }

        public Number() {
            super('n');
        }
    }

    public static class ValueEntry {
        public char whatisit;
        public String data;
        public String unaryOperator;

        public ValueEntry(char c, String string) {
            this.whatisit = c;
            this.data = string;
        }

        public ValueEntry(char c) {
            this.whatisit = c;
        }
    }

    public static class Value
    extends ValueEntry {
        public List<ValueEntry> entries = new LinkedList<ValueEntry>();
        ValueEntry entry1;
        public String unaryOperator;
        public String simpleStringLiteral;
        public Value value_true;
        public Value value_false;
        public String conditionDef;

        Value(char c) {
            super(c);
        }

        public Value() {
            super('v');
        }

        public void set_variable(String string) {
        }

        public Variable new_variable() {
            return new Variable();
        }

        public void add_variable(Variable variable) {
            this.entries.add(variable);
        }

        public Value new_value() {
            Value value = new Value();
            value.unaryOperator = this.unaryOperator;
            this.unaryOperator = null;
            return value;
        }

        public void add_value(Value value) {
            this.entries.add(value);
        }

        public Value new_referenceAddress() {
            return new Value();
        }

        public void add_referenceAddress(Value value) {
            value.whatisit = (char)38;
            this.entries.add(value);
        }

        public Assignment new_assignment() {
            Assignment assignment = new Assignment();
            assignment.unaryOperator = this.unaryOperator;
            this.unaryOperator = null;
            return assignment;
        }

        public void add_assignment(Assignment assignment) {
            this.entries.add(assignment);
        }

        public RefCastingValue new_refCastingValue() {
            return new RefCastingValue();
        }

        public void add_refCastingValue(RefCastingValue refCastingValue) {
            this.entries.add(refCastingValue);
        }

        public Number set_number(int n) {
            Number number = new Number('f');
            this.entry1 = number;
            this.entries.add(this.entry1);
            return number;
        }

        public Number set_floatNumber(int n) {
            Number number = new Number('f');
            this.entry1 = number;
            this.entries.add(this.entry1);
            return number;
        }

        public void set_floatModifier(String string) {
            ((Number)this.entry1).floatModifier = string;
        }

        public void set_longModifier(String string) {
            ((Number)this.entry1).floatModifier = string;
        }

        public Number new_number() {
            Number number = new Number('f');
            this.entry1 = number;
            return number;
        }

        public void add_number(Number number) {
            this.entries.add(number);
        }

        public MethodCall new_methodCall() {
            return new MethodCall();
        }

        public void add_methodCall(MethodCall methodCall) {
            this.entries.add(methodCall);
        }

        public void set_conditionDef(String string) {
            this.conditionDef = string;
        }

        public void set_binaryOperator(String string) {
            this.entries.add(new ValueEntry('b', string));
        }
    }

    public static class MethodCall
    extends Statement {
        public ExternObject externObject;
        public String methodname;
        List<Value> args;

        public MethodCall() {
            super('m');
        }

        public Value new_actualParameter() {
            return new Value();
        }

        public void add_actualParameter(Value value) {
            if (this.args == null) {
                this.args = new LinkedList<Value>();
            }
            this.args.add(value);
        }

        public MethodCall new_simpleMethodCall() {
            return this;
        }

        public void add_simpleMethodCall(MethodCall methodCall) {
        }
    }

    public static class ConditionalStatement
    extends Statement {
        public Value condition;
        public StatementBlock statementBlock;

        ConditionalStatement(char c) {
            super(c);
        }

        public StatementBlock new_statement() {
            this.statementBlock = new StatementBlock();
            return this.statementBlock;
        }

        public void set_statement(StatementBlock statementBlock) {
        }
    }

    public static class VariableDefinition
    extends Statement {
        public Description description;
        public Type type;
        public String name;
        public int bitField;
        public Arraysize arraysize;
        public Value defaultValue;
        List<VariableDefinition> moreVariable;

        public VariableDefinition() {
            super('d');
        }

        public VariableDefinition new_name() {
            if (this.name == null) {
                return this;
            }
            if (this.moreVariable == null) {
                this.moreVariable = new LinkedList<VariableDefinition>();
            }
            VariableDefinition variableDefinition = new VariableDefinition();
            variableDefinition.type = this.type;
            this.moreVariable.add(variableDefinition);
            return variableDefinition;
        }

        public Type new_typeRefModifier() {
            return this.type;
        }

        public void add_typeRefModifier(Type type) {
        }

        public String toString() {
            return this.name + ": " + this.type;
        }
    }

    public static class Assignment
    extends Statement {
        public Variable variable;
        public int nrofRefLevels_variable = 0;
        public String assignOperator;
        public Value value;

        public Assignment() {
            super('=');
        }

        public Variable new_Refvariable() {
            this.nrofRefLevels_variable = 1;
            this.variable = new Variable();
            return this.variable;
        }

        public void add_Refvariable(Variable variable) {
        }
    }

    public static class Statement
    extends ValueEntry {
        public Statement(char c) {
            super(c);
        }
    }

    public static class StatementBlock
    extends Statement {
        List<Statement> statements = new LinkedList<Statement>();
        String conditionDef;
        public String sTACKTRC_ENTRY;

        public StatementBlock() {
            super('{');
        }

        public StatementBlock new_statement() {
            return this;
        }

        public void add_statement(StatementBlock statementBlock) {
        }

        public StatementBlock new_statementBlock() {
            return new StatementBlock();
        }

        public void add_statementBlock(StatementBlock statementBlock) {
            this.statements.add(statementBlock);
        }

        public MethodCall new_simpleMethodCall() {
            return new MethodCall();
        }

        public void add_simpleMethodCall(MethodCall methodCall) {
            this.statements.add(methodCall);
        }

        public Assignment new_assignment() {
            return new Assignment();
        }

        public void add_assignment(Assignment assignment) {
            this.statements.add(assignment);
        }

        public VariableDefinition new_variabledefinition() {
            return new VariableDefinition();
        }

        public void add_variabledefinition(VariableDefinition variableDefinition) {
            this.statements.add(variableDefinition);
        }

        public ConditionalStatement new_if_statement() {
            return new ConditionalStatement('i');
        }

        public void add_if_statement(ConditionalStatement conditionalStatement) {
            this.statements.add(conditionalStatement);
        }

        public Value new_returnAssignment() {
            Assignment assignment = new Assignment();
            assignment.assignOperator = "return";
            this.statements.add(assignment);
            assignment.value = new Value();
            return assignment.value;
        }

        public void add_returnAssignment(Value value) {
        }

        public void set_conditionDef(String string) {
            this.conditionDef = string;
        }
    }

    public static class FnPointer
    extends MethodDef {
        FnPointer() {
            super("def_fnPointer");
        }
    }

    public static class MethodTypedef
    extends MethodDef {
        boolean bPointerType;
        String class_;

        MethodTypedef() {
            super("typedef_method");
        }

        public void set_class(String string) {
            this.class_ = string;
        }
    }

    public static class MethodDef
    extends HeaderBlockEntry {
        public Type type;
        public String name;
        public boolean inline;
        public boolean abstract_;
        public List<AttributeOrTypedef> args;
        public boolean variableArgs;
        public boolean declaration;
        StatementBlock body;
        public String modifier;

        MethodDef() {
            super("method");
        }

        MethodDef(String string) {
            super(string);
        }

        public AttributeOrTypedef new_conditionalArgument() {
            return new AttributeOrTypedef();
        }

        public void add_conditionalArgument(AttributeOrTypedef attributeOrTypedef) {
            if (this.args == null) {
                this.args = new LinkedList<AttributeOrTypedef>();
            }
            this.args.add(attributeOrTypedef);
        }

        public AttributeOrTypedef new_typedParameter() {
            return new AttributeOrTypedef();
        }

        public void add_typedParameter(AttributeOrTypedef attributeOrTypedef) {
            if (this.args == null) {
                this.args = new LinkedList<AttributeOrTypedef>();
            }
            this.args.add(attributeOrTypedef);
        }

        public StatementBlock new_statementBlock() {
            this.body = new StatementBlock();
            return this.body;
        }

        public void add_statementBlock(StatementBlock statementBlock) {
        }

        public void set_abstract() {
            this.abstract_ = true;
        }
    }

    public static class Arraysize {
        public int value;
        public String symbolValue;
        public Value exprValue;

        public void set_unknown() {
            this.value = -1;
        }

        public Arraysize new_arraysize() {
            return this;
        }

        public void add_arraysize(Arraysize arraysize) {
        }
    }

    public static class Type {
        public String basename;
        public String name;
        public String forward;
        public boolean constVar;
        public boolean volatileVar;
        public boolean signed;
        public boolean unsigned;
        @Deprecated
        public boolean pointer;
        @Deprecated
        public boolean pointer2;
        @Deprecated
        public String modifier;
        @Deprecated
        public boolean constPointer;
        @Deprecated
        public boolean constPointer2;
        List<Pointer> pointer_;

        public void set_name(String string) {
            this.name = string;
            int n = string.length();
            if (this.forward != null) {
                n = string.endsWith("_") ? --n : (n -= 2);
            } else if (string.endsWith("_s")) {
                n -= 2;
            }
            this.basename = string.substring(0, n);
        }

        public void set_Pointer() {
            this.set_pointer();
        }

        public void set_pointer() {
            if (this.pointer_ == null) {
                this.pointer_ = new LinkedList<Pointer>();
                if (this.constVar) {
                    this.constPointer = true;
                } else {
                    this.pointer = true;
                }
            } else if (this.constVar) {
                this.constPointer = false;
                this.constPointer2 = true;
            } else {
                this.pointer = false;
                this.pointer2 = true;
            }
            Pointer pointer = new Pointer();
            if (this.constVar) {
                pointer.constPointer = true;
                this.constVar = false;
            }
            if (this.volatileVar) {
                pointer.volatilePointer = true;
                this.volatileVar = false;
            }
            this.pointer_.add(pointer);
        }

        public void set_cppRef() {
            if (this.pointer_ == null) {
                this.pointer_ = new LinkedList<Pointer>();
            }
            Pointer pointer = new Pointer();
            pointer.cppRef = true;
            if (this.constVar) {
                pointer.constPointer = true;
                this.constVar = false;
            }
            if (this.volatileVar) {
                pointer.volatilePointer = true;
                this.volatileVar = false;
            }
            this.pointer_.add(pointer);
        }

        public String typeString() {
            String string = this.forward != null ? this.forward + " " + this.name : this.name;
            if (this.pointer_ != null) {
                for (Pointer pointer : this.pointer_) {
                    if (pointer.constPointer) {
                        string = string + " const";
                    }
                    if (pointer.volatilePointer) {
                        string = string + " volatile";
                    }
                    string = string + "*";
                }
            }
            return string;
        }

        public String baseName(String string, String string2) {
            if (this.forward != null && this.name.endsWith(string2)) {
                return this.name.substring(0, this.name.length() - string2.length());
            }
            if (this.name.endsWith(string)) {
                return this.name.substring(0, this.name.length() - string.length());
            }
            return this.name;
        }

        public int pointerDepth() {
            return this.pointer_ != null ? this.pointer_.size() : 0;
        }

        public boolean constPointer() {
            return this.pointer_ == null ? false : this.pointer_.get((int)0).constPointer;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Pointer {
        public boolean constPointer;
        public boolean volatilePointer;
        public boolean cppRef;
    }

    public static class AttribAsMacro
    extends AttributeOrTypedef {
        public String macro;

        AttribAsMacro(String string) {
            this.macro = string;
        }

        AttribAsMacro() {
        }
    }

    public static class AttributeOrTypedef
    extends HeaderBlockEntry {
        public Description description;
        public Type type;
        public String name;
        public String text;
        public int bitField;
        public boolean staticConst;
        public boolean bOS_HandlePointer;
        public String conditionDef;
        public Arraysize arraysize;
        public Value defaultValue;

        AttributeOrTypedef(String string) {
            super(string);
        }

        AttributeOrTypedef() {
            super("Attribute");
        }

        public AttributeOrTypedef new_typedParameter() {
            return this;
        }

        public void set_typedParameter(AttributeOrTypedef attributeOrTypedef) {
        }

        public Description new_description() {
            this.description = new Description();
            return this.description;
        }

        public void add_description(Description description) {
        }

        public String toString() {
            return this.name + ": " + this.type;
        }
    }

    public static class EnumElement
    extends HeaderBlockEntry {
        public String name;
        public long intnumber;
        public long hexnumber;
        public String symbol;

        EnumElement() {
            super("enumElement");
        }
    }

    public static class EnumDefinition
    extends HeaderBlockEntry {
        public String tagname;
        public String name;
        public Map<String, EnumElement> values = new TreeMap<String, EnumElement>();
        public Map<String, DefineDefinition> defines;

        EnumDefinition() {
            super("enumDef");
        }

        public EnumElement new_enumElement() {
            return new EnumElement();
        }

        public void add_enumElement(EnumElement enumElement) {
            this.values.put(enumElement.name, enumElement);
        }

        public DefineDefinition new_defineDefinition() {
            return new DefineDefinition();
        }

        public void add_defineDefinition(DefineDefinition defineDefinition) {
            if (this.defines == null) {
                this.defines = new TreeMap<String, DefineDefinition>();
            }
            this.defines.put(defineDefinition.name, defineDefinition);
        }
    }

    public static class ClassDefinition
    extends HeaderBlock {
        public String name;
        public Superclass superclass;

        ClassDefinition(HeaderBlock headerBlock, String string) {
            super(headerBlock, string);
        }

        public ClassDefinition new_classVisibilityBlock() {
            return this;
        }

        public void add_classVisibilityBlock(ClassDefinition classDefinition) {
        }

        public Constructor new_Constructor() {
            return new Constructor();
        }

        public void add_Constructor(Constructor constructor) {
            constructor.visibility = this.visibility;
            this.entries.add(constructor);
        }

        public Destructor new_Destructor() {
            return new Destructor();
        }

        public void add_Destructor(Destructor destructor) {
            destructor.visibility = this.visibility;
            this.entries.add(destructor);
        }

        public Operator new_operator() {
            return new Operator();
        }

        public void add_operator(Operator operator) {
            operator.visibility = this.visibility;
            this.entries.add(operator);
        }

        public Operator new_virtualOperator() {
            return new Operator();
        }

        public void add_virtualOperator(Operator operator) {
            operator.visibility = this.visibility;
            this.entries.add(operator);
        }
    }

    public static class Operator
    extends MethodDef {
        public String operator;
        public String assignOperator;
        public boolean parenthesis;
        public Type typeConversion;
        public String unaryOperator;
        public String binaryOperator;

        private Operator() {
            super("Operator");
        }

        public Operator new_operator() {
            return this;
        }

        public void add_operator(Operator operator) {
        }
    }

    public static class Destructor
    extends MethodDef {
        public String className;
        public boolean abstract_;
        public boolean virtual;

        private Destructor() {
            super("Destructor");
        }

        @Override
        public void set_abstract() {
            this.abstract_ = true;
        }
    }

    public static class Constructor
    extends MethodDef {
        public List<InitializationInCtor> init = new LinkedList<InitializationInCtor>();
        public String initialization;

        private Constructor() {
            super("Constructor");
        }

        public InitializationInCtor new_initialization() {
            return new InitializationInCtor();
        }

        public void add_initialization(InitializationInCtor initializationInCtor) {
            this.init.add(initializationInCtor);
        }
    }

    public static class InitializationInCtor {
        public String ident;
        public Value value;
    }

    public static class Superclass {
        public String name;
        public String accessRight;
        public boolean isVirtual;

        public Superclass new_visibility() {
            return this;
        }

        public void set_visibility(Superclass superclass) {
        }
    }

    public static class StructDefinition
    extends HeaderBlock {
        public String conditionDef;
        public String conditionDefNot;
        List<AttributeOrTypedef> attribs = new LinkedList<AttributeOrTypedef>();
        public final boolean isUnion;
        public boolean isBasedOnObjectJc;
        public AttributeOrTypedef superclass;
        public String tagname;
        public String name;
        public String implicitName;
        public Arraysize arraysize;

        StructDefinition(HeaderBlock headerBlock, String string, boolean bl) {
            super(headerBlock, string);
            this.isUnion = bl;
        }

        public void set_name(String string) {
            this.name = string;
        }

        public StructDefinition new_implicitStructAttribute() {
            return new StructDefinition(this, "unnamedStructAttr", false);
        }

        public void add_implicitStructAttribute(StructDefinition structDefinition) {
            if (structDefinition.name == null) {
                for (AttributeOrTypedef attributeOrTypedef : structDefinition.attribs) {
                    this.attribs.add(attributeOrTypedef);
                }
            } else {
                String string = this.tagname.endsWith("_t") ? this.tagname.substring(0, this.tagname.length() - 2) : this.tagname;
                string = structDefinition.tagname != null ? string + "_" + structDefinition.tagname : string + "_" + structDefinition.name;
                AttributeOrTypedef attributeOrTypedef = new AttributeOrTypedef();
                attributeOrTypedef.name = structDefinition.name;
                attributeOrTypedef.type = new Type();
                attributeOrTypedef.type.name = string;
                this.attribs.add(attributeOrTypedef);
                if (this.parent != null) {
                    structDefinition.implicitName = structDefinition.name;
                    structDefinition.name = string;
                    structDefinition.whatisit = "structDefinition";
                    this.parent.entries.add(structDefinition);
                }
            }
        }

        public StructDefinition new_implicitUnionAttribute() {
            return new StructDefinition(this.parent, "unnamedUnionAttr", true);
        }

        public void add_implicitUnionAttribute(StructDefinition structDefinition) {
            this.entries.add(structDefinition);
            boolean bl = false;
            if (this.attribs.size() == 0 && (structDefinition.name == null || structDefinition.name.equals("base") || structDefinition.name.equals("super"))) {
                this.isBasedOnObjectJc = structDefinition.isBasedOnObjectJc;
                if (structDefinition.superclass != null) {
                    this.superclass = structDefinition.superclass;
                    this.superclass.description = structDefinition.description;
                    bl = true;
                }
                for (AttributeOrTypedef attributeOrTypedef : structDefinition.attribs) {
                    if (attributeOrTypedef.type.name.equals("ObjectJc") && attributeOrTypedef.type.pointer_ == null) {
                        this.isBasedOnObjectJc = true;
                    }
                    if (this.superclass != null || attributeOrTypedef.type.pointer_ != null) continue;
                    this.superclass = attributeOrTypedef;
                    this.superclass.description = structDefinition.description;
                    bl = true;
                }
            }
            if (!bl) {
                this.add_implicitStructAttribute(structDefinition);
            }
        }

        public void set_XXXimplicitStruct() {
            this.name = "?";
        }

        public void set_XXXvariante(String string) {
        }

        public StructDefinition new_XXXvariante() {
            return this;
        }

        public void add_XXXvariante(StructDefinition structDefinition) {
        }

        @Override
        public void add_attribute(AttributeOrTypedef attributeOrTypedef) {
            super.add_attribute(attributeOrTypedef);
            if (this.attribs.size() == 0 && this.superclass == null) {
                if ((attributeOrTypedef.type.name.equals("ObjectJc") || attributeOrTypedef.name.equals("super")) && attributeOrTypedef.type.pointer_ == null) {
                    this.isBasedOnObjectJc = attributeOrTypedef.type.name.equals("ObjectJc");
                    this.superclass = attributeOrTypedef;
                } else {
                    this.attribs.add(attributeOrTypedef);
                }
            } else {
                this.attribs.add(attributeOrTypedef);
            }
        }

        public AttribAsMacro new_attribMacro() {
            AttribAsMacro attribAsMacro = new AttribAsMacro();
            this.entries.add(attribAsMacro);
            return attribAsMacro;
        }

        public void add_attribMacro(AttribAsMacro attribAsMacro) {
            if (attribAsMacro.macro.equals("OS_HandlePtr") || attribAsMacro.macro.equals("HandlePtr_emC")) {
                attribAsMacro.type.pointer_ = new LinkedList<Pointer>();
                attribAsMacro.type.pointer_.add(new Pointer());
                attribAsMacro.bOS_HandlePointer = true;
                this.attribs.add(attribAsMacro);
            }
        }

        public String baseName(String string) {
            if (this.name.endsWith(string)) {
                return this.name.substring(0, this.name.length() - string.length());
            }
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class FriendClass
    extends HeaderBlockEntry {
        public String name;

        FriendClass() {
            super("friend");
        }
    }

    public static class StructClassDecl
    extends HeaderBlockEntry {
        public String name;

        StructClassDecl(String string) {
            super(string);
        }
    }

    public static class DefineParameter {
        public String name;
    }

    public static class DefineDefinition
    extends HeaderBlockEntry {
        public String name;
        public String specialDefine;
        public Description description;
        public String valueDef = "";
        public int intvalue;
        public int hexvalue;
        public String stringvalue;
        public int fractPart;
        public List<String> args;

        DefineDefinition() {
            super("#define");
        }

        public void set_value(String string) {
            this.valueDef = this.valueDef + string;
        }

        public DefineParameter new_parameter() {
            return new DefineParameter();
        }

        public void add_parameter(DefineParameter defineParameter) {
            if (this.args == null) {
                this.args = new LinkedList<String>();
            }
            this.args.add(defineParameter.name);
        }
    }

    public static class Define
    extends HeaderBlockEntry {
        public String name;

        Define() {
            super("xxdefine");
        }
    }

    public static class ConditionBlock
    extends HeaderBlock {
        public String conditionDef;
        public boolean not;
        public List<OrCondition> orConditions;
        public List<ConditionBlock> elifBlocks;
        public HeaderBlock elseBlock;

        ConditionBlock(HeaderBlock headerBlock) {
            super(headerBlock, "#ifdef");
        }

        public void set_elseConditionBlock(String string) {
        }

        public void conditionDef(String string) {
            this.not = false;
            this.conditionDef = string;
        }

        public void set_conditionDefNot(String string) {
            this.not = true;
            this.conditionDef = string;
        }

        public OrCondition new_OrCondition() {
            return new OrCondition();
        }

        public void add_OrCondition(OrCondition orCondition) {
            if (this.orConditions == null) {
                this.orConditions = new LinkedList<OrCondition>();
            }
            this.orConditions.add(orCondition);
        }

        public ConditionBlock new_elif() {
            return new ConditionBlock(this.parent);
        }

        public void add_elif(ConditionBlock conditionBlock) {
            if (this.elifBlocks == null) {
                this.elifBlocks = new LinkedList<ConditionBlock>();
            }
            this.elifBlocks.add(conditionBlock);
        }

        public HeaderBlock new_elseConditionBlock() {
            return new HeaderBlock();
        }

        public void add_elseConditionBlock(HeaderBlock headerBlock) {
            this.elseBlock = headerBlock;
        }

        public static class OrCondition
        extends ConditionDef {
            public String conditionDef;
            public boolean not;
            public List<ConditionDef> andConditions;

            public ConditionDef new_AndCondition() {
                return new ConditionDef();
            }

            public void add_AndCondition(ConditionDef conditionDef) {
                if (this.andConditions == null) {
                    this.andConditions = new LinkedList<ConditionDef>();
                }
                this.andConditions.add(conditionDef);
            }
        }
    }

    public static class ConditionDef {
        public String conditionDef;
        public boolean not;
        public Value conditionValue;

        public void set_conditionDefNot(String string) {
            this.not = true;
            this.conditionDef = string;
        }

        public Value new_condition() {
            return new Value();
        }

        public void add_condition(Value value) {
            this.conditionValue = value;
        }
    }

    public static class ParamDescription {
        public String name;
        public String text;
    }

    public static class Description
    extends HeaderBlockEntry {
        public String text = "";
        public int accLevel;
        public int chgLevel;
        public String simulinkTag = "";
        public String fnCallVar;
        public String fnCallMask;
        public boolean fnCallMaskAddClass;
        public String vtbl;
        public String refl;
        public SizeofDescription sizeof;
        public boolean noReflection;
        public ParamDescription returnDescription;
        public List<ParamDescription> paramDescriptions;
        public List<ParamDescription> auxDescriptions;
        public String containerType;
        public String containerElementType;
        public boolean referencedContainerElement;
        public boolean noRefl;
        public Type reflType;

        Description(String string) {
            super(string);
        }

        public Description() {
            super("description");
        }

        public void set_text(String string) {
            this.text = this.text + string;
        }

        public void set_simulinkTag(String string) {
            this.simulinkTag = this.simulinkTag + ":" + string + ":";
        }

        public void set_acclevel(String string) {
            this.accLevel = string.charAt(0) - 48;
        }

        public void set_chglevel(String string) {
            this.chgLevel = string.charAt(0) - 48;
        }

        public final ParamDescription new_paramDescription() {
            return new ParamDescription();
        }

        public final void add_paramDescription(ParamDescription paramDescription) {
            if (this.paramDescriptions == null) {
                this.paramDescriptions = new LinkedList<ParamDescription>();
            }
            this.paramDescriptions.add(paramDescription);
        }

        public final ParamDescription new_returnDescription() {
            return new ParamDescription();
        }

        public final void add_returnDescription(ParamDescription paramDescription) {
            paramDescription.name = "return";
            this.returnDescription = paramDescription;
        }

        public final ParamDescription new_auxDescription() {
            return new ParamDescription();
        }

        public final void add_auxDescription(ParamDescription paramDescription) {
            if (this.auxDescriptions == null) {
                this.auxDescriptions = new LinkedList<ParamDescription>();
            }
            this.auxDescriptions.add(paramDescription);
        }

        public final void set_auxDescription(String string) {
        }

        public String toString() {
            return this.text != null ? this.text : "";
        }
    }

    public static class SizeofDescription {
        public int sizeof;
        public String text;
    }

    public static class HeaderBlockEntry {
        public String whatisit;
        public String visibility;
        public Description description;
        public boolean static_;
        public boolean virtual_;
        public List<Description> implementDescriptions;

        HeaderBlockEntry(String string) {
            this.whatisit = string;
        }

        public Description new_implementDescription() {
            return new Description("implementDescription");
        }

        public void add_implementDescription(Description description) {
            if (this.implementDescriptions == null) {
                this.implementDescriptions = new LinkedList<Description>();
            }
            this.implementDescriptions.add(description);
        }
    }

    public static class HeaderBlock
    extends HeaderBlockEntry {
        final HeaderBlock parent;
        List<HeaderBlockEntry> entries = new LinkedList<HeaderBlockEntry>();
        HeaderBlockEntry currEntry;
        HeaderBlock invalidBlock_;
        public String headerBlockName;
        public String headerBlockNameDescr;
        String visibity;
        boolean isConst;
        public String compilerError;

        HeaderBlock() {
            super("{}");
            this.parent = null;
        }

        HeaderBlock(HeaderBlock headerBlock, String string) {
            super(string);
            this.parent = headerBlock;
        }

        public void set_const() {
            this.isConst = true;
        }

        public IncludeDef new_includeDef() {
            return new IncludeDef();
        }

        public void add_includeDef(IncludeDef includeDef) {
        }

        public Define new_undefDefinition() {
            return new Define();
        }

        public void add_undefDefinition(Define define) {
            define.visibility = this.visibility;
            this.entries.add(define);
        }

        public ConditionBlock new_conditionBlock() {
            return new ConditionBlock(this);
        }

        public void add_conditionBlock(ConditionBlock conditionBlock) {
            conditionBlock.visibility = this.visibility;
            this.entries.add(conditionBlock);
        }

        public DefineDefinition new_defineDefinition() {
            return new DefineDefinition();
        }

        public void add_defineDefinition(DefineDefinition defineDefinition) {
            this.entries.add(defineDefinition);
        }

        public DefineDefinition new_null_initializer() {
            return new DefineDefinition();
        }

        public void add_null_initializer(DefineDefinition defineDefinition) {
            defineDefinition.specialDefine = "NULL";
            this.entries.add(defineDefinition);
        }

        public DefineDefinition new_const_initializer() {
            return new DefineDefinition();
        }

        public void add_const_initializer(DefineDefinition defineDefinition) {
            defineDefinition.specialDefine = "CONST";
            this.entries.add(defineDefinition);
        }

        public StructClassDecl new_enumDecl() {
            return new StructClassDecl("enumDecl");
        }

        public void add_enumDecl(StructClassDecl structClassDecl) {
            structClassDecl.visibility = this.visibility;
            this.entries.add(structClassDecl);
        }

        public StructClassDecl new_structDecl() {
            return new StructClassDecl("structDecl");
        }

        public void add_structDecl(StructClassDecl structClassDecl) {
            structClassDecl.visibility = this.visibility;
            this.entries.add(structClassDecl);
        }

        public StructClassDecl new_classDecl() {
            return new StructClassDecl("classDecl");
        }

        public void add_classDecl(StructClassDecl structClassDecl) {
            structClassDecl.visibility = this.visibility;
            this.entries.add(structClassDecl);
        }

        public FriendClass new_friendClassDef() {
            return new FriendClass();
        }

        public void add_friendClassDef(FriendClass friendClass) {
            friendClass.visibility = this.visibility;
            this.entries.add(friendClass);
        }

        public StructDefinition new_structDefinition() {
            return new StructDefinition(this, "structDefinition", false);
        }

        public void add_structDefinition(StructDefinition structDefinition) {
            if (structDefinition.name != null && structDefinition.name.equals("ARRAYJC")) {
                Debugutil.stop();
            }
            structDefinition.visibility = this.visibility;
            this.entries.add(structDefinition);
        }

        public ClassDefinition new_classDef() {
            return new ClassDefinition(this, "classDef");
        }

        public void add_classDef(ClassDefinition classDefinition) {
            classDefinition.visibility = this.visibility;
            this.entries.add(classDefinition);
        }

        public ConditionBlock new_structContentInsideCondition() {
            return new ConditionBlock(this.parent);
        }

        public void add_structContentInsideCondition(ConditionBlock conditionBlock) {
            conditionBlock.visibility = this.visibility;
            this.entries.add(conditionBlock);
        }

        public StructDefinition new_unionDefinition() {
            return new StructDefinition(this, "unionDefinition", true);
        }

        public void add_unionDefinition(StructDefinition structDefinition) {
            structDefinition.visibility = this.visibility;
            this.entries.add(structDefinition);
        }

        public AttributeOrTypedef new_typedef() {
            return new AttributeOrTypedef("typedef");
        }

        public void add_typedef(AttributeOrTypedef attributeOrTypedef) {
            attributeOrTypedef.visibility = this.visibility;
            this.entries.add(attributeOrTypedef);
        }

        public EnumDefinition new_enumDefinition() {
            return new EnumDefinition();
        }

        public void add_enumDefinition(EnumDefinition enumDefinition) {
            enumDefinition.visibility = this.visibility;
            this.entries.add(enumDefinition);
        }

        public FnPointer new_fnPointer() {
            return new FnPointer();
        }

        public void add_fnPointer(FnPointer fnPointer) {
            this.entries.add(fnPointer);
        }

        public AttributeOrTypedef new_attribute() {
            return new AttributeOrTypedef();
        }

        public void add_attribute(AttributeOrTypedef attributeOrTypedef) {
            attributeOrTypedef.visibility = this.visibility;
            this.entries.add(attributeOrTypedef);
        }

        public AttributeOrTypedef new_constDef() {
            return new AttributeOrTypedef();
        }

        public void add_constDef(AttributeOrTypedef attributeOrTypedef) {
            attributeOrTypedef.visibility = this.visibility;
            this.entries.add(attributeOrTypedef);
        }

        public MethodDef new_methodDef() {
            return new MethodDef();
        }

        public void add_methodDef(MethodDef methodDef) {
            methodDef.visibility = this.visibility;
            this.entries.add(methodDef);
        }

        public MethodDef new_virtualMethod() {
            return new MethodDef();
        }

        public void add_virtualMethod(MethodDef methodDef) {
            methodDef.visibility = this.visibility;
            methodDef.virtual_ = true;
            this.entries.add(methodDef);
        }

        public MethodDef new_abstractMethod() {
            return new MethodDef();
        }

        public void add_abstractMethod(MethodDef methodDef) {
            methodDef.visibility = this.visibility;
            methodDef.virtual_ = true;
            this.entries.add(methodDef);
        }

        public MethodDef new_staticMethod() {
            return new MethodDef();
        }

        public void add_staticMethod(MethodDef methodDef) {
            methodDef.visibility = this.visibility;
            methodDef.static_ = true;
            this.entries.add(methodDef);
        }

        public MethodTypedef new_methodTypedef() {
            return new MethodTypedef();
        }

        public void add_methodTypedef(MethodTypedef methodTypedef) {
            methodTypedef.visibility = this.visibility;
            this.entries.add(methodTypedef);
        }

        public MethodTypedef new_methodPtrTypedef() {
            return new MethodTypedef();
        }

        public void add_methodPtrTypedef(MethodTypedef methodTypedef) {
            methodTypedef.visibility = this.visibility;
            methodTypedef.bPointerType = true;
            this.entries.add(methodTypedef);
        }

        public MethodDef new_inlineMethod() {
            return new MethodDef();
        }

        public void add_inlineMethod(MethodDef methodDef) {
            methodDef.inline = true;
            methodDef.visibility = this.visibility;
            this.entries.add(methodDef);
        }

        @Override
        public Description new_implementDescription() {
            return new Description("implementDescription");
        }

        @Override
        public void add_implementDescription(Description description) {
            description.visibility = this.visibility;
            this.entries.add(description);
        }

        public HeaderBlock new_invalidBlock() {
            return new HeaderBlock();
        }

        public void add_invalidBlock(HeaderBlock headerBlock) {
        }

        public void set_modifier(String string) {
        }

        public void set_constDef(String string) {
        }
    }

    public static class ClassC
    extends HeaderBlock {
        public String name;
        public List<IncludeDef> includeDef = new LinkedList<IncludeDef>();

        public HeaderBlock new_HeaderBlock() {
            return this;
        }

        public void add_HeaderBlock(HeaderBlock headerBlock) {
        }

        public String toString() {
            return this.name;
        }
    }

    public static class IncludeDef {
        public String includeGuard;
        public String file;
        public String ext;
        public String path;
        public boolean sysInclude;
    }

    public static class ZbnfResultFile {
        public final String fileName;
        public final String filePath;
        public List<IncludeDef> includeDef = new LinkedList<IncludeDef>();
        public String headerEntry;
        public String headerEntryDef;
        public List<ClassC> listClassC;

        public ZbnfResultFile(String string, String string2) {
            this.fileName = string;
            this.filePath = string2;
        }

        public void set_HeaderEntry(String string) {
        }

        public void set_HeaderEntryDef(String string) {
        }

        public IncludeDef new_includeDef() {
            return new IncludeDef();
        }

        public void add_includeDef(IncludeDef includeDef) {
        }

        public ClassC new_CLASS_C() {
            ClassC classC = new ClassC();
            return classC;
        }

        public void add_CLASS_C(ClassC classC) {
            if (this.listClassC == null) {
                this.listClassC = new LinkedList<ClassC>();
            }
            this.listClassC.add(classC);
        }

        public ClassC new_CLASS_CPP() {
            ClassC classC = new ClassC();
            return classC;
        }

        public void add_CLASS_CPP(ClassC classC) {
            if (this.listClassC == null) {
                this.listClassC = new LinkedList<ClassC>();
            }
            this.listClassC.add(classC);
        }

        public ClassC new_DEFINE_C() {
            ClassC classC = new ClassC();
            return classC;
        }

        public void add_DEFINE_C(ClassC classC) {
            if (this.listClassC == null) {
                this.listClassC = new LinkedList<ClassC>();
            }
            this.listClassC.add(classC);
        }

        public ClassC new_ARRAY() {
            ClassC classC = new ClassC();
            return classC;
        }

        public void add_ARRAY(ClassC classC) {
            if (this.listClassC == null) {
                this.listClassC = new LinkedList<ClassC>();
            }
            this.listClassC.add(classC);
        }

        public ClassC new_INLINE() {
            ClassC classC = new ClassC();
            return classC;
        }

        public void add_INLINE(ClassC classC) {
            if (this.listClassC == null) {
                this.listClassC = new LinkedList<ClassC>();
            }
            this.listClassC.add(classC);
        }

        public ClassC new_outside() {
            ClassC classC = this.new_CLASS_C();
            classC.name = "--outside--";
            return classC;
        }

        public void add_outside(ClassC classC) {
            this.add_CLASS_C(classC);
        }
    }

    public static class ZbnfResultData {
        public List<ZbnfResultFile> files = new LinkedList<ZbnfResultFile>();
    }

    public static class Args {
        List<SrcFile> srcFiles = new LinkedList<SrcFile>();
        String sFileDst;
        String sFileZbnf;

        public void addSrc(String string, String string2) {
            SrcFile srcFile = new SrcFile(string2, string);
            this.srcFiles.add(srcFile);
        }

        public void setZbnfHeader(String string) {
            this.sFileZbnf = string;
        }

        public void setDst(String string) {
            this.sFileDst = string;
        }
    }

    public static class SrcFile {
        public final String name;
        public final String path;

        public SrcFile(CharSequence charSequence, CharSequence charSequence2) {
            this.name = charSequence.toString();
            this.path = charSequence2.toString();
        }
    }
}

