/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.header2Reflection;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.vishia.byteData.Class_Jc;
import org.vishia.byteData.Field_Jc;
import org.vishia.byteData.ObjectArray_Jc;
import org.vishia.byteData.RawDataAccess;
import org.vishia.header2Reflection.ExtReflection_Insp_h;
import org.vishia.util.StdHexFormatWriter;

public class BinOutPrep {
    public static final String version = "2018-09-08";
    private OutputStream fileBin;
    private final byte[] binOutData;
    private final byte[] binOutHeadData;
    private final byte[] binOutClassArrayData;
    private final RawDataAccess binOutClass;
    private final ExtReflection_Insp_h.ExtReflection_Insp binOutHead;
    private final ObjectArray_Jc binOutClassArray;
    private final Class_Jc binClass;
    private final ObjectArray_Jc binFieldArray;
    private final Field_Jc binField;
    private int nrofRelocEntries = 0;
    private int nrofClasses = 0;
    private int nrofFieldsInClass;
    private final Map<String, TypeBinPosition> posClassesInBuffer = new TreeMap<String, TypeBinPosition>();
    private final Map<String, Integer> missingClasses = new TreeMap<String, Integer>();
    private final List<TypeNeedInBinOut> typeBinNeed = new LinkedList<TypeNeedInBinOut>();

    public BinOutPrep(String string, boolean bl, boolean bl2, int n) throws FileNotFoundException {
        File file = new File(string);
        this.fileBin = bl2 ? new StdHexFormatWriter(new File(string)) : new FileOutputStream(file);
        this.binOutData = new byte[2000000];
        this.binOutHeadData = new byte[400000];
        this.binOutClassArrayData = new byte[80000];
        this.binOutHead = new ExtReflection_Insp_h.ExtReflection_Insp(this.binOutHeadData);
        this.binOutHead.setBigEndian(bl);
        this.binOutHead.set_sign(n);
        this.binOutClass = new RawDataAccess();
        this.binOutClass.assignClear(this.binOutData);
        this.binOutClass.setBigEndian(bl);
        this.binOutClassArray = new ObjectArray_Jc();
        this.binOutClassArray.assignClear(this.binOutClassArrayData);
        this.binOutClassArray.setBigEndian(bl);
        this.binOutClassArray.set_sizeElement(4);
        this.binClass = new Class_Jc();
        this.binFieldArray = new ObjectArray_Jc();
        this.binField = new Field_Jc();
    }

    private void setRelocEntry(int n) throws IllegalArgumentException {
        ++this.nrofRelocEntries;
        this.binOutHead.addChildInteger(4, n);
    }

    public int addClass(String string, String string2) throws IllegalArgumentException {
        this.binOutClass.addChild(this.binClass);
        this.binClass.clearData();
        int n = this.binClass.getPositionInBuffer();
        ++this.nrofClasses;
        this.binOutClassArray.addChildInteger(4, n);
        this.binClass.setName(string2);
        this.binClass.set_posObjectBase(0);
        this.binClass.set_nSize(-4096 + this.nrofClasses);
        this.posClassesInBuffer.put(string, new TypeBinPosition(n));
        this.nrofFieldsInClass = 0;
        return this.nrofClasses;
    }

    public void addFieldHead() throws IllegalArgumentException {
        this.binOutClass.addChild(this.binFieldArray);
        this.binFieldArray.clearData();
    }

    public void addField(String string, int n, String string2, int n2, int n3) throws IllegalArgumentException {
        int n4;
        ++this.nrofFieldsInClass;
        int n5 = this.nrofFieldsInClass;
        this.binFieldArray.addChildEmpty(this.binField);
        this.binField.setName(string);
        this.binField.set_nrofArrayElements(n3);
        this.binField.set_position(32768 + n5);
        this.binField.set_offsetToObjectifcBase(0);
        if (n3 > 0) {
            this.stop();
        }
        if (n == -1) {
            n4 = this.binField.getPositionInBuffer_type();
            this.typeBinNeed.add(new TypeNeedInBinOut(string2, n4));
            this.binField.set_type(0);
        } else {
            this.binField.set_type(n);
        }
        this.binField.set_bitModifiers(n2);
        n4 = this.binField.setOffs_declaringClass(this.binClass.getPositionInBuffer());
        this.setRelocEntry(n4);
    }

    void setAttributRef(int n) throws IllegalArgumentException {
        this.binFieldArray.set_length(n);
        int n2 = this.binFieldArray.getPositionInBuffer();
        int n3 = this.binClass.setOffs_attributes(n2);
        this.setRelocEntry(n3);
    }

    public void closeAddClass() {
        this.setAttributRef(this.nrofFieldsInClass);
    }

    public void postProcessBinOut() throws IOException, IllegalArgumentException {
        int n;
        for (TypeNeedInBinOut object : this.typeBinNeed) {
            n = object.posRefInFieldBuffer;
            TypeBinPosition typeBinPosition = this.posClassesInBuffer.get(object.sType);
            if (typeBinPosition != null) {
                int n2 = typeBinPosition.posClassInBuffer;
                int n3 = n2 - n;
                this.binOutClass.setIntVal(n, 4, n3);
                this.setRelocEntry(n);
                continue;
            }
            Integer n4 = this.missingClasses.get(object.sType);
            if (n4 == null) {
                n4 = new Integer(0);
                this.missingClasses.put(object.sType, n4);
            }
            n4 = n4 + 1;
            this.binOutClass.setIntVal(n, 4, 1L);
        }
        for (Map.Entry entry : this.missingClasses.entrySet()) {
            System.err.println("Missing type " + (String)entry.getKey());
        }
        this.binOutClassArray.set_length(this.nrofClasses);
        int n5 = this.binOutHead.getLengthTotal();
        int n6 = this.binOutClassArray.getLengthTotal();
        n = this.binOutClass.getLengthTotal();
        this.binOutHead.set_nrofRelocEntries(this.nrofRelocEntries);
        this.binOutHead.set_arrayClasses(n5);
        this.binOutHead.set_classDataBlock(n5 + n6);
        this.fileBin.write(this.binOutHead.getData(), 0, n5);
        this.fileBin.write(this.binOutClassArray.getData(), 0, n6);
        this.fileBin.write(this.binOutClass.getData(), 0, n);
    }

    public void close() throws IOException {
        this.fileBin.close();
    }

    void stop() {
    }

    private static class TypeNeedInBinOut {
        String sType;
        int posRefInFieldBuffer;

        public TypeNeedInBinOut(String string, int n) {
            this.sType = string;
            this.posRefInFieldBuffer = n;
        }
    }

    private static class TypeBinPosition {
        int posClassInBuffer;

        public TypeBinPosition(int n) {
            this.posClassInBuffer = n;
        }
    }
}

