/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.fileRemote;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.vishia.fileRemote.FileRemote;
import org.vishia.fileRemote.FileRemoteCallback;
import org.vishia.fileRemote.FileRemoteProgressTimeOrder;
import org.vishia.util.SortedTreeWalkerCallback;

public class FileRemoteCallbackCopy
implements FileRemoteCallback {
    public static final String sVersion = "2014-12-14";
    private FileRemote dirDst;
    private boolean first;
    private final FileRemoteProgressTimeOrder timeOrderProgress;
    private final FileRemoteCallback callbackUser;
    int mode;
    byte[] buffer = new byte[16384];
    boolean aborted = false;

    FileRemoteCallbackCopy(FileRemote fileRemote, FileRemoteCallback fileRemoteCallback, FileRemoteProgressTimeOrder fileRemoteProgressTimeOrder) {
        this.timeOrderProgress = fileRemoteProgressTimeOrder;
        this.callbackUser = fileRemoteCallback;
        this.dirDst = fileRemote;
    }

    @Override
    public void start(FileRemote fileRemote) {
        this.first = true;
    }

    @Override
    public SortedTreeWalkerCallback.Result offerParentNode(FileRemote fileRemote) {
        if (this.first) {
            this.first = false;
        } else {
            String string = fileRemote.getName();
            this.dirDst = FileRemote.getDir(this.dirDst.getPathChars() + "/" + string);
        }
        return SortedTreeWalkerCallback.Result.cont;
    }

    @Override
    public SortedTreeWalkerCallback.Result finishedParentNode(FileRemote fileRemote, SortedTreeWalkerCallback.Counters counters) {
        this.dirDst = this.dirDst.getParentFile();
        return SortedTreeWalkerCallback.Result.cont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedTreeWalkerCallback.Result offerLeafNode(FileRemote fileRemote, Object object) {
        FileRemote fileRemote2 = this.dirDst.child(fileRemote.getName());
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = fileRemote.openInputStream(0L);
            outputStream = fileRemote2.openOutputStream(0L);
            if (inputStream != null) {
                if (outputStream == null) {
                } else {
                    int n;
                    int n2 = 0;
                    while ((n = inputStream.read(this.buffer)) > 0) {
                        outputStream.write(this.buffer, 0, n);
                        n2 += n;
                    }
                    if (this.callbackUser != null) {
                        this.callbackUser.offerLeafNode(fileRemote, object);
                    }
                    if (this.timeOrderProgress != null) {
                        this.timeOrderProgress.nrofBytesFile = n2;
                    }
                }
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return SortedTreeWalkerCallback.Result.cont;
    }

    @Override
    public boolean shouldAborted() {
        return this.aborted;
    }

    @Override
    public void finished(FileRemote fileRemote, SortedTreeWalkerCallback.Counters counters) {
        if (this.timeOrderProgress != null) {
            this.timeOrderProgress.bDone = true;
            this.timeOrderProgress.show(FileRemote.CallbackCmd.done, null);
        }
    }
}

