/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.fileRemote;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.vishia.fileRemote.FileRemote;
import org.vishia.fileRemote.FileRemoteCallback;
import org.vishia.fileRemote.FileRemoteProgressTimeOrder;
import org.vishia.util.Assert;
import org.vishia.util.Debugutil;
import org.vishia.util.FileSystem;
import org.vishia.util.SortedTreeWalkerCallback;
import org.vishia.util.StringFunctions;

public class FileRemoteCallbackCmp
implements FileRemoteCallback {
    public static final String sVersion = "2016-12-27";
    private final CompareCtrl cmpCtrl = new CompareCtrl();
    private final FileRemote dir1;
    private final FileRemote dir2;
    private final String basepath1;
    private final int zBasePath1;
    private final FileRemoteProgressTimeOrder timeOrderProgress;
    private final FileRemoteCallback callbackUser;
    int mode;
    long minDiffTimestamp = 2000L;
    static final int cmp_onlyTimestamp = 1;
    static final int cmp_content = 2;
    static final int cmp_withoutLineend = 4;
    static final int cmp_withoutEndlineComment = 8;
    static final int cmp_withoutComment = 16;
    boolean aborted = false;
    final FileRemoteCallback callbackMarkSecondAlone = new FileRemoteCallback(){

        @Override
        public void finished(FileRemote fileRemote, SortedTreeWalkerCallback.Counters counters) {
        }

        @Override
        public SortedTreeWalkerCallback.Result finishedParentNode(FileRemote fileRemote, SortedTreeWalkerCallback.Counters counters) {
            return SortedTreeWalkerCallback.Result.cont;
        }

        @Override
        public SortedTreeWalkerCallback.Result offerParentNode(FileRemote fileRemote) {
            return SortedTreeWalkerCallback.Result.cont;
        }

        @Override
        public SortedTreeWalkerCallback.Result offerLeafNode(FileRemote fileRemote, Object object) {
            fileRemote.setMarked(0x1000000);
            return SortedTreeWalkerCallback.Result.cont;
        }

        @Override
        public void start(FileRemote fileRemote) {
        }

        @Override
        public boolean shouldAborted() {
            return false;
        }
    };

    FileRemoteCallbackCmp(FileRemote fileRemote, FileRemote fileRemote2, FileRemoteCallback fileRemoteCallback, FileRemoteProgressTimeOrder fileRemoteProgressTimeOrder) {
        this.timeOrderProgress = fileRemoteProgressTimeOrder;
        this.callbackUser = fileRemoteCallback;
        this.dir1 = fileRemote;
        this.dir2 = fileRemote2;
        this.basepath1 = FileSystem.normalizePath(fileRemote.getAbsolutePath()).toString();
        this.zBasePath1 = this.basepath1.length();
        this.cmpCtrl.ignoreToEol.add(".file");
        this.cmpCtrl.ignoreToEol.add("//");
        this.cmpCtrl.ignoreToEol.add("Compilation time:");
        this.cmpCtrl.ignoreToEol.add("Compiler options:");
        this.cmpCtrl.ignoreCommentline.add("//");
        this.cmpCtrl.ignoreFromTo.add(new String[]{".epcannot:", ".epcannot.end:"});
        this.cmpCtrl.ignoreFromTo.add(new String[]{".static1:", ".static1.end:"});
    }

    @Override
    public void start(FileRemote fileRemote) {
        if (this.dir1.device == null) {
            this.dir1.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.dir1.getAbsolutePath());
        }
        if (this.dir2.device == null) {
            this.dir2.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.dir2.getAbsolutePath());
        }
        this.dir2.refreshPropertiesAndChildren();
        int n = 0x3D300000;
        this.dir1.resetMarkedRecurs(n, null);
        this.dir2.resetMarkedRecurs(n, null);
        this.dir1.setMarked(0x100000);
        this.dir2.setMarked(0x100000);
    }

    @Override
    public SortedTreeWalkerCallback.Result offerParentNode(FileRemote fileRemote) {
        FileRemote fileRemote2;
        CharSequence charSequence = FileSystem.normalizePath(fileRemote.getAbsolutePath());
        if (charSequence.length() <= this.zBasePath1) {
            fileRemote2 = this.dir2;
        } else {
            CharSequence charSequence2 = charSequence.subSequence(this.zBasePath1 + 1, charSequence.length());
            if (StringFunctions.equals(charSequence2, "functionBlocks")) {
                Debugutil.stop();
            }
            fileRemote2 = this.dir2.subdir(charSequence2);
        }
        if (!fileRemote2.exists()) {
            fileRemote.setMarked(0x1000000);
            fileRemote.mark.setMarkParent(0x10000000, false);
            System.out.println("FileRemoteCallbackCmp - offerDir, not exists; " + fileRemote.getAbsolutePath());
            return SortedTreeWalkerCallback.Result.skipSubtree;
        }
        fileRemote2.resetMarked(0x1000000);
        fileRemote2.device.walkFileTree(fileRemote2, true, true, false, null, 0L, 1, this.callbackMarkSecondAlone);
        System.out.println("FileRemoteCallbackCmp - offerDir, check; " + fileRemote.getAbsolutePath());
        return SortedTreeWalkerCallback.Result.cont;
    }

    @Override
    public SortedTreeWalkerCallback.Result finishedParentNode(FileRemote fileRemote, SortedTreeWalkerCallback.Counters counters) {
        return SortedTreeWalkerCallback.Result.cont;
    }

    @Override
    public SortedTreeWalkerCallback.Result offerLeafNode(FileRemote fileRemote, Object object) {
        FileRemote fileRemote2;
        CharSequence charSequence = FileSystem.normalizePath(fileRemote.getAbsolutePath());
        CharSequence charSequence2 = charSequence.subSequence(this.zBasePath1 + 1, charSequence.length());
        if (StringFunctions.compare(charSequence2, "functionBlocks/AngleBlocks_FB.h") == 0) {
            Assert.stop();
        }
        if (!(fileRemote2 = this.dir2.child(charSequence2)).exists()) {
            if (this.callbackUser != null) {
                this.callbackUser.offerLeafNode(fileRemote, new Integer(0x1000000));
            }
            fileRemote.setMarked(0x1000000);
            fileRemote.mark.setMarkParent(0x10000000, false);
            return SortedTreeWalkerCallback.Result.cont;
        }
        fileRemote2.resetMarked(0x1000000);
        int n = this.compareFile(fileRemote, fileRemote2);
        fileRemote.setMarked(n);
        fileRemote2.setMarked(n);
        if ((n & 0x8000000) != 0) {
            fileRemote.mark.setMarkParent(0x20000000, false);
            fileRemote2.mark.setMarkParent(0x20000000, false);
        }
        if (this.callbackUser != null) {
            this.callbackUser.offerLeafNode(fileRemote, new Integer(n));
        }
        if (this.timeOrderProgress != null) {
            this.timeOrderProgress.currFile = fileRemote;
            ++this.timeOrderProgress.nrFilesProcessed;
            this.timeOrderProgress.show(FileRemote.CallbackCmd.nrofFilesAndBytes, null);
        }
        return SortedTreeWalkerCallback.Result.cont;
    }

    @Override
    public boolean shouldAborted() {
        return this.aborted;
    }

    int compareFile(FileRemote fileRemote, FileRemote fileRemote2) {
        int n;
        boolean bl;
        boolean bl2 = false;
        this.mode = 4;
        if (fileRemote.getName().equals("ReleaseNotes.topic")) {
            Assert.stop();
        }
        long l = fileRemote.lastModified();
        long l2 = fileRemote2.lastModified();
        long l3 = fileRemote.length();
        long l4 = fileRemote2.length();
        if (Math.abs(l - l2) > this.minDiffTimestamp && this.mode == 1) {
            boolean bl3 = false;
            boolean bl4 = false;
            bl2 = false;
            bl = false;
            boolean bl5 = l3 == l4;
        } else if ((Math.abs(l - l2 + 3600000L) < this.minDiffTimestamp || Math.abs(l - l2 - 3600000L) < this.minDiffTimestamp) && this.mode == 1) {
            boolean bl6 = false;
            boolean bl7 = false;
            bl2 = false;
            bl = false;
        } else if (Math.abs(l - l2) < this.minDiffTimestamp && l3 == l4) {
            boolean bl8 = true;
            bl2 = true;
            bl = true;
        } else {
            if (l3 != l4) {
                if ((this.mode & 0x1C) != 0) {
                    n = 1;
                    bl = false;
                } else {
                    boolean bl9 = false;
                    boolean bl10 = false;
                    boolean bl11 = false;
                    bl = false;
                    n = 0;
                }
            } else {
                n = 1;
                bl = false;
            }
            if (n != 0) {
                try {
                    bl = this.compareFileContent(fileRemote, fileRemote2);
                }
                catch (IOException iOException) {
                    boolean bl12 = true;
                    bl = false;
                }
            }
        }
        n = bl ? 0x4000000 : 0x8000000;
        return n;
    }

    boolean compareFileContent(FileRemote fileRemote, FileRemote fileRemote2) throws IOException {
        String string;
        boolean bl = true;
        BufferedReader bufferedReader = null;
        BufferedReader bufferedReader2 = null;
        bufferedReader = new BufferedReader(new FileReader(fileRemote));
        bufferedReader2 = new BufferedReader(new FileReader(fileRemote2));
        while (bl && (string = this.readIgnoreComment(bufferedReader)) != null) {
            int n;
            String string2 = this.readIgnoreComment(bufferedReader2);
            for (String string3 : this.cmpCtrl.ignoreToEol) {
                n = string.indexOf(string3);
                if (n < 0) continue;
                string = string.substring(0, n);
                int n2 = string2.indexOf(string3);
                if (n2 < 0 || n2 != n) break;
                string2 = string2.substring(0, n2);
                break;
            }
            block2: for (String[] stringArray : this.cmpCtrl.ignoreFromTo) {
                String string4;
                int n3;
                String string5;
                n = string.indexOf(stringArray[0]);
                if (n < 0) continue;
                string = string.substring(0, n);
                while ((string5 = this.readIgnoreComment(bufferedReader)) != null) {
                    n3 = string5.indexOf(stringArray[1]);
                    if (n3 < 0) continue;
                    string = string + string5.substring(n3 + stringArray[1].length());
                    break;
                }
                if ((n3 = string2.indexOf(stringArray[0])) < 0) break;
                string2 = string2.substring(0, n3);
                while ((string4 = this.readIgnoreComment(bufferedReader2)) != null) {
                    int n4 = string4.indexOf(stringArray[1]);
                    if (n4 < 0) continue;
                    string2 = string2 + string4.substring(n4 + stringArray[1].length());
                    break block2;
                }
                break block2;
            }
            if (string2 != null && string.equals(string2)) continue;
            bl = false;
        }
        if (this.readIgnoreComment(bufferedReader2) != null) {
            bl = false;
        }
        bufferedReader.close();
        bufferedReader2.close();
        bufferedReader2 = null;
        bufferedReader = null;
        FileSystem.close(bufferedReader);
        FileSystem.close(bufferedReader2);
        return bl;
    }

    private String readIgnoreComment(BufferedReader bufferedReader) throws IOException {
        String string;
        boolean bl;
        block0: do {
            bl = false;
            string = bufferedReader.readLine();
            if (string == null) continue;
            for (String string2 : this.cmpCtrl.ignoreCommentline) {
                if (!string.startsWith(string2)) continue;
                bl = true;
                continue block0;
            }
        } while (bl);
        return string;
    }

    @Override
    public void finished(FileRemote fileRemote, SortedTreeWalkerCallback.Counters counters) {
        if (this.timeOrderProgress != null) {
            this.timeOrderProgress.bDone = true;
            this.timeOrderProgress.show(FileRemote.CallbackCmd.done, null);
        }
    }

    class CompareCtrl {
        final List<String> ignoreToEol = new LinkedList<String>();
        final List<String> ignoreCommentline = new LinkedList<String>();
        final List<String[]> ignoreFromTo = new LinkedList<String[]>();

        CompareCtrl() {
        }
    }
}

