/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.fileLocalAccessor;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.vishia.event.EventCmdtypeWithBackEvent;
import org.vishia.event.EventConsumer;
import org.vishia.event.EventSource;
import org.vishia.event.EventTimerThread;
import org.vishia.fileLocalAccessor.FileAccessorLocalJava6;
import org.vishia.fileLocalAccessor.FileLocalAccessorCopyStateM;
import org.vishia.fileRemote.FileCluster;
import org.vishia.fileRemote.FileRemote;
import org.vishia.fileRemote.FileRemoteAccessor;
import org.vishia.fileRemote.FileRemoteCallback;
import org.vishia.fileRemote.FileRemoteProgressTimeOrder;
import org.vishia.util.Assert;
import org.vishia.util.Debugutil;
import org.vishia.util.FileSystem;
import org.vishia.util.FilepathFilter;
import org.vishia.util.SortedTreeWalkerCallback;
import org.vishia.util.TreeWalkerPathCheck;

public class FileAccessorLocalJava7
extends FileRemoteAccessor {
    public static final String sVersion = "2014-12-21";
    private static final boolean useFileChildren = false;
    private static FileRemoteAccessor instance;
    protected final Class<? extends BasicFileAttributes> systemAttribtype = DosFileAttributes.class;
    protected boolean debugout = false;
    protected final FileLocalAccessorCopyStateM states = new FileLocalAccessorCopyStateM();
    EventSource evSrc = new EventSource("FileLocalAccessor"){

        @Override
        public void notifyDequeued() {
        }

        @Override
        public void notifyConsumed(int n) {
        }

        @Override
        public void notifyRelinquished(int n) {
        }

        @Override
        public void notifyShouldSentButInUse() {
            throw new RuntimeException("event usage error");
        }

        @Override
        public void notifyShouldOccupyButInUse() {
            throw new RuntimeException("event usage error");
        }
    };
    EventTimerThread singleThreadForCommission = new EventTimerThread("FileAccessor-local");
    EventConsumer executerCommission = new EventConsumer(){

        @Override
        public int processEvent(EventObject eventObject) {
            if (eventObject instanceof FileLocalAccessorCopyStateM.EventInternal) {
                FileAccessorLocalJava7.this.states.statesCopy.processEvent(eventObject);
                return 1;
            }
            if (eventObject instanceof FileRemote.CmdEvent) {
                FileAccessorLocalJava7.this.execCommission((FileRemote.CmdEvent)eventObject);
                return 1;
            }
            return 0;
        }

        public String toString() {
            return "FileRemoteAccessorLocal - executerCommision";
        }
    };
    private FileRemote workingDir;
    public static FileRemote.FileRemoteAccessorSelector selectLocalFileAlways;

    public static FileRemoteAccessor getInstance() {
        if (instance == null) {
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            try {
                classLoader.loadClass("java.nio.file.Files");
                instance = new FileAccessorLocalJava7();
            }
            catch (ClassNotFoundException classNotFoundException) {
                instance = new FileAccessorLocalJava6();
            }
        }
        return instance;
    }

    private File getLocalFile(FileRemote fileRemote) {
        if (fileRemote.oFile() == null) {
            String string = fileRemote.getPath();
            fileRemote.setFileObject(new File(string));
        }
        return (File)fileRemote.oFile();
    }

    protected static void setAttributes(FileRemote fileRemote, Path path, BasicFileAttributes basicFileAttributes) {
        FileTime fileTime = basicFileAttributes.lastModifiedTime();
        long l = fileTime.toMillis();
        long l2 = basicFileAttributes.creationTime().toMillis();
        long l3 = basicFileAttributes.lastAccessTime().toMillis();
        long l4 = basicFileAttributes.size();
        int n = -2147483647;
        if (basicFileAttributes.isDirectory()) {
            n |= 0x10;
        }
        if (basicFileAttributes.isSymbolicLink()) {
            try {
                Path path2 = Files.readSymbolicLink(path);
                fileRemote.setSymbolicLinkedPath(path2.toAbsolutePath().toString());
            }
            catch (IOException iOException) {
                System.err.println("FileAccessorLocalJava7 - Problem on SymbolicLinkPath; " + fileRemote.getAbsolutePath());
                fileRemote.setCanonicalAbsPath(fileRemote.getAbsolutePath());
            }
        } else {
            fileRemote.setCanonicalAbsPath(fileRemote.getAbsolutePath());
        }
        int n2 = -2147483631;
        if (basicFileAttributes instanceof DosFileAttributes) {
            DosFileAttributes dosFileAttributes = (DosFileAttributes)basicFileAttributes;
            n2 |= 0xE;
            if (dosFileAttributes.isHidden()) {
                n |= 8;
            }
            if (!dosFileAttributes.isReadOnly()) {
                n |= 4;
            }
            if (basicFileAttributes.isRegularFile()) {
                n |= 2;
            }
        }
        fileRemote.internalAccess().setFlagBits(n2, n);
        fileRemote.internalAccess().setLengthAndDate(l4, l, l2, l3);
    }

    @Override
    public void refreshFileProperties(FileRemote fileRemote, FileRemote.CallbackEvent callbackEvent) {
        RunRefresh runRefresh = new RunRefresh(fileRemote, callbackEvent);
        if (callbackEvent == null) {
            runRefresh.run();
        } else {
            Thread thread = new Thread(runRefresh);
            thread.start();
        }
    }

    @Override
    public void refreshFilePropertiesAndChildren(FileRemote fileRemote, FileRemote.CallbackEvent callbackEvent) {
        RunRefreshWithChildren runRefreshWithChildren = new RunRefreshWithChildren(fileRemote, callbackEvent);
        if (callbackEvent == null) {
            runRefreshWithChildren.run();
        } else if ((fileRemote.getFlags() & 0x20000000) == 0) {
            fileRemote.internalAccess().setFlagBit(0x20000000);
            Thread thread = new Thread(runRefreshWithChildren);
            runRefreshWithChildren.time = System.currentTimeMillis();
            thread.start();
        } else {
            System.err.println("FileRemoteAccessLocalFile.refreshFilePropertiesAndChildren - double call, ignored;");
            callbackEvent.relinquish();
        }
    }

    @Override
    public List<File> getChildren(FileRemote fileRemote, FileFilter fileFilter) {
        File file = (File)fileRemote.oFile();
        File[] fileArray = file.listFiles(fileFilter);
        LinkedList<File> linkedList = new LinkedList<File>();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                linkedList.add(file2);
            }
        }
        return linkedList;
    }

    @Override
    public void walkFileTree(FileRemote fileRemote, boolean bl, boolean bl2, boolean bl3, String string, long l, int n, FileRemoteCallback fileRemoteCallback) {
        if (bl) {
            this.walkFileTreeExecInThisThread(fileRemote, bl2, bl3, string, l, n, fileRemoteCallback);
        } else {
            FileRemoteAccessor.FileWalkerThread fileWalkerThread = new FileRemoteAccessor.FileWalkerThread(fileRemote, bl2, bl3, n, string, l, fileRemoteCallback){

                @Override
                public void run() {
                    try {
                        FileAccessorLocalJava7.this.walkFileTreeExecInThisThread(this.startDir, this.bRefresh, this.resetMark, this.sMask, this.bMarkCheck, this.depth, this.callback);
                    }
                    catch (Exception exception) {
                        CharSequence charSequence = Assert.exceptionInfo("FileAccessorLocalJava7 - RefreshThread Exception; ", exception, 0, 20, true);
                        System.err.println(charSequence);
                    }
                }
            };
            fileWalkerThread.start();
        }
    }

    private void walkFileTreeExecInThisThread(FileRemote fileRemote, boolean bl, boolean bl2, String string, long l, int n, FileRemoteCallback fileRemoteCallback) {
        String string2;
        if (fileRemoteCallback != null) {
            fileRemoteCallback.start(fileRemote);
        }
        if (FileSystem.isRoot(string2 = fileRemote.getAbsolutePath())) {
            Assert.stop();
        }
        Path path = Paths.get(string2, new String[0]);
        if (bl) {
            fileRemote.internalAccess().newChildren();
        }
        int n2 = n == 0 ? Integer.MAX_VALUE : (n < 0 ? -n : n);
        WalkFileTreeVisitor walkFileTreeVisitor = new WalkFileTreeVisitor(fileRemote.itsCluster, bl, bl2, string, l, fileRemoteCallback);
        TreeSet<FileVisitOption> treeSet = new TreeSet<FileVisitOption>();
        try {
            Files.walkFileTree(path, treeSet, n2, walkFileTreeVisitor);
        }
        catch (IOException iOException) {
            System.err.println("FileAccessorLocalData.walkFileTree - unexpected IOException; " + iOException.getMessage());
        }
        if (fileRemoteCallback != null) {
            fileRemoteCallback.finished(fileRemote, walkFileTreeVisitor.cntTotal);
        }
    }

    @Override
    public void walkFileTreeCheck(FileRemote fileRemote, boolean bl, boolean bl2, boolean bl3, String string, long l, int n, FileRemoteCallback fileRemoteCallback) {
        if (bl) {
            this.walkFileTreeCheckInThisThread(fileRemote, bl2, bl3, string, l, n, fileRemoteCallback);
        } else {
            FileRemoteAccessor.FileWalkerThread fileWalkerThread = new FileRemoteAccessor.FileWalkerThread(fileRemote, bl2, bl3, n, string, l, fileRemoteCallback){

                @Override
                public void run() {
                    try {
                        FileAccessorLocalJava7.this.walkFileTreeCheckInThisThread(this.startDir, this.bRefresh, this.resetMark, this.sMask, this.bMarkCheck, this.depth, this.callback);
                    }
                    catch (Exception exception) {
                        CharSequence charSequence = Assert.exceptionInfo("FileAccessorLocalJava7 - RefreshThread Exception; ", exception, 0, 20, true);
                        System.err.println(charSequence);
                    }
                }
            };
            fileWalkerThread.start();
        }
    }

    private void walkFileTreeCheckInThisThread(FileRemote fileRemote, boolean bl, boolean bl2, String string, long l, int n, FileRemoteCallback fileRemoteCallback) {
        String string2;
        WalkFileTreeVisitorCheck walkFileTreeVisitorCheck = new WalkFileTreeVisitorCheck(fileRemote.itsCluster, bl, bl2, string, l, fileRemoteCallback);
        if (fileRemoteCallback != null) {
            fileRemoteCallback.start(fileRemote);
        }
        if (FileSystem.isRoot(string2 = fileRemote.getAbsolutePath())) {
            Assert.stop();
        }
        Path path = Paths.get(string2, new String[0]);
        if (bl) {
            fileRemote.internalAccess().newChildren();
        }
        int n2 = n == 0 ? Integer.MAX_VALUE : (n < 0 ? -n : n);
        TreeSet<FileVisitOption> treeSet = new TreeSet<FileVisitOption>();
        try {
            Files.walkFileTree(path, treeSet, n2, walkFileTreeVisitorCheck);
        }
        catch (IOException iOException) {
            System.err.println("FileAccessorLocalData.walkFileTree - unexpected IOException; " + iOException.getMessage());
        }
        if (fileRemoteCallback != null) {
            fileRemoteCallback.finished(fileRemote, walkFileTreeVisitorCheck.cntTotal);
        }
    }

    @Override
    public boolean setLastModified(FileRemote fileRemote, long l) {
        File file = (File)fileRemote.oFile();
        if (file != null) {
            return file.setLastModified(l);
        }
        return false;
    }

    @Override
    public ReadableByteChannel openRead(FileRemote fileRemote, long l) {
        try {
            FileInputStream fileInputStream = new FileInputStream(fileRemote);
            return fileInputStream.getChannel();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    @Override
    public InputStream openInputStream(FileRemote fileRemote, long l) {
        try {
            FileInputStream fileInputStream = new FileInputStream(fileRemote);
            return fileInputStream;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    @Override
    public OutputStream openOutputStream(FileRemote fileRemote, long l) {
        try {
            FileSystem.mkDirPath(fileRemote);
            FileOutputStream fileOutputStream = new FileOutputStream(fileRemote);
            return fileOutputStream;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    @Override
    public WritableByteChannel openWrite(FileRemote fileRemote, long l) {
        try {
            FileSystem.mkDirPath(fileRemote);
            FileOutputStream fileOutputStream = new FileOutputStream(fileRemote);
            return fileOutputStream.getChannel();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    @Override
    public boolean createNewFile(FileRemote fileRemote, FileRemote.CallbackEvent callbackEvent) throws IOException {
        File file;
        if (fileRemote.oFile() == null) {
            file = new File(fileRemote.getAbsolutePath());
            fileRemote.setFileObject(file);
        } else {
            file = (File)fileRemote.oFile();
        }
        return file.createNewFile();
    }

    @Override
    public boolean mkdir(FileRemote fileRemote, boolean bl, FileRemote.CallbackEvent callbackEvent) {
        File file = (File)fileRemote.oFile();
        if (file == null) {
            file = new File(fileRemote.getAbsolutePath());
            fileRemote.setFileObject(file);
        }
        if (callbackEvent == null) {
            if (bl) {
                return file.mkdirs();
            }
            return file.mkdir();
        }
        FileRemote.CmdEvent cmdEvent = this.prepareCmdEvent(500, callbackEvent);
        cmdEvent.filesrc = fileRemote;
        cmdEvent.filedst = null;
        cmdEvent.sendEvent(bl ? FileRemote.Cmd.mkDirs : FileRemote.Cmd.mkDir);
        return true;
    }

    private void mkdir(boolean bl, FileRemote.CmdEvent cmdEvent) {
        boolean bl2 = this.mkdir(cmdEvent.filesrc, bl, null);
        FileRemote.CallbackEvent callbackEvent = cmdEvent.getOpponent();
        if (callbackEvent.occupy(this.evSrc, true)) {
            callbackEvent.sendEvent(bl2 ? FileRemote.CallbackCmd.done : FileRemote.CallbackCmd.nok);
        }
    }

    @Override
    public boolean delete(FileRemote fileRemote, FileRemote.CallbackEvent callbackEvent) {
        File file = this.getLocalFile(fileRemote);
        if (callbackEvent == null) {
            return file.delete();
        }
        boolean bl = file.delete();
        callbackEvent.occupy(this.evSrc, true);
        callbackEvent.sendEvent(bl ? FileRemote.CallbackCmd.done : FileRemote.CallbackCmd.errorDelete);
        return bl;
    }

    @Override
    public void copyChecked(FileRemote fileRemote, String string, String string2, int n, FileRemoteCallback fileRemoteCallback, FileRemoteProgressTimeOrder fileRemoteProgressTimeOrder) {
        this.states.copyChecked(fileRemote, string, string2, n, fileRemoteCallback, fileRemoteProgressTimeOrder);
    }

    @Override
    public boolean isLocalFileSystem() {
        return true;
    }

    @Override
    public CharSequence getStateInfo() {
        return this.states.getStateInfo();
    }

    @Override
    public FileRemote.CmdEvent prepareCmdEvent(int n, EventCmdtypeWithBackEvent<?, FileRemote.CmdEvent> eventCmdtypeWithBackEvent) {
        FileRemote.CmdEvent cmdEvent;
        if (eventCmdtypeWithBackEvent != null && (cmdEvent = eventCmdtypeWithBackEvent.getOpponent()) != null) {
            if (!cmdEvent.occupy(n, this.evSrc, this.executerCommission, this.singleThreadForCommission)) {
                return null;
            }
        } else {
            cmdEvent = new FileRemote.CmdEvent(this.evSrc, this.executerCommission, this.singleThreadForCommission, (FileRemote.CallbackEvent)eventCmdtypeWithBackEvent);
        }
        return cmdEvent;
    }

    void execCommission(FileRemote.CmdEvent cmdEvent) {
        FileRemote.Cmd cmd = cmdEvent.getCmd();
        switch (cmd) {
            case check: 
            case abortAll: 
            case delChecked: 
            case moveChecked: 
            case copyChecked: {
                this.states.statesCopy.processEvent(cmdEvent);
                break;
            }
            case move: {
                this.states.execMove(cmdEvent);
                break;
            }
            case chgProps: {
                this.execChgProps(cmdEvent);
                break;
            }
            case chgPropsRecurs: {
                this.execChgPropsRecurs(cmdEvent);
                break;
            }
            case countLength: {
                this.execCountLength(cmdEvent);
                break;
            }
            case delete: {
                this.execDel(cmdEvent);
                break;
            }
            case mkDir: {
                this.mkdir(false, cmdEvent);
                break;
            }
            case mkDirs: {
                this.mkdir(true, cmdEvent);
            }
        }
    }

    private void execChgProps(FileRemote.CmdEvent cmdEvent) {
        FileRemote fileRemote;
        boolean bl;
        boolean bl2 = bl = cmdEvent != null;
        if (cmdEvent.newName() != null && !cmdEvent.newName().equals(cmdEvent.filesrc().getName())) {
            File file = new File(cmdEvent.filesrc.getParent(), cmdEvent.newName());
            bl &= cmdEvent.filesrc.renameTo(file);
            fileRemote = FileRemote.fromFile(cmdEvent.filesrc.itsCluster, file);
        } else {
            fileRemote = cmdEvent.filesrc;
        }
        bl = this.chgFile(fileRemote, cmdEvent.maskFlags(), cmdEvent.newFlags(), bl);
        long l = cmdEvent.newDate();
        if (l != 0L) {
            bl &= fileRemote.setLastModified(l);
        }
        FileRemote.CallbackCmd callbackCmd = bl ? FileRemote.CallbackCmd.done : FileRemote.CallbackCmd.nok;
        FileRemote.CallbackEvent callbackEvent = cmdEvent.getOpponent();
        callbackEvent.occupy(this.evSrc, true);
        callbackEvent.sendEvent(callbackCmd);
    }

    private void execChgPropsRecurs(FileRemote.CmdEvent cmdEvent) {
        FileRemote fileRemote;
        Object object;
        boolean bl;
        boolean bl2 = bl = cmdEvent != null;
        if (cmdEvent.newName() != null && !cmdEvent.newName().equals(cmdEvent.filesrc.getName())) {
            object = cmdEvent.filesrc.getParentFile().child(cmdEvent.newName());
            bl &= cmdEvent.filesrc.renameTo((File)object);
            fileRemote = object;
        } else {
            fileRemote = cmdEvent.filesrc;
        }
        bl &= this.chgPropsRecursive(fileRemote, cmdEvent.maskFlags(), cmdEvent.newFlags(), bl, 0);
        object = bl ? FileRemote.CallbackCmd.done : FileRemote.CallbackCmd.error;
        FileRemote.CallbackEvent callbackEvent = cmdEvent.getOpponent();
        callbackEvent.occupy(this.evSrc, true);
        callbackEvent.sendEvent((FileRemote.CallbackCmd)((Object)object));
    }

    private boolean chgPropsRecursive(File file, int n, int n2, boolean bl, int n3) {
        if (n3 > 100) {
            throw new IllegalArgumentException("FileRemoteAccessorLocal.chgProsRecursive: too many recursions ");
        }
        if (file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                bl = this.chgPropsRecursive(file2, n, n2, bl, n3 + 1);
            }
        } else {
            bl = this.chgFile(file, n, n2, bl);
        }
        return bl;
    }

    private boolean chgFile(File file, int n, int n2, boolean bl) {
        int n3 = n;
        for (int i = 1; i != 0; i <<= 1) {
            if ((n3 & i) == 0 || this.chgFile1(file, i, n2)) continue;
            bl = false;
        }
        return bl;
    }

    private boolean chgFile1(File file, int n, int n2) {
        boolean bl;
        boolean bl2 = (n2 & n) != 0;
        switch (n) {
            case 4: {
                bl = file.setWritable(bl2);
                break;
            }
            case 32768: {
                bl = file.setWritable(bl2, true);
                break;
            }
            default: {
                bl = true;
            }
        }
        if (bl && file instanceof FileRemote) {
            FileRemote fileRemote = (FileRemote)file;
            fileRemote.internalAccess().setOrClrFlagBit(n, bl2);
        }
        return bl;
    }

    private void execCountLength(FileRemote.CmdEvent cmdEvent) {
        FileRemote.CallbackCmd callbackCmd;
        long l = this.countLengthDir(cmdEvent.filesrc, 0L, 0);
        FileRemote.CallbackEvent callbackEvent = cmdEvent.getOpponent();
        callbackEvent.occupy(this.evSrc, true);
        if (l >= 0L) {
            callbackCmd = FileRemote.CallbackCmd.done;
            callbackEvent.nrofBytesAll = l;
        } else {
            callbackCmd = FileRemote.CallbackCmd.nok;
        }
        callbackEvent.sendEvent(callbackCmd);
    }

    private long countLengthDir(File file, long l, int n) {
        if (n > 100) {
            throw new IllegalArgumentException("FileRemoteAccessorLocal.chgProsRecursive: too many recursions ");
        }
        if (file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                l = this.countLengthDir(file2, l, n + 1);
            }
        } else {
            l += file.length();
        }
        return l;
    }

    void execDel(FileRemote.CmdEvent cmdEvent) {
        System.err.println("FileRemoteLocal - execDel not implemented yet.");
    }

    @Override
    public void close() throws IOException {
        this.singleThreadForCommission.close();
    }

    static {
        selectLocalFileAlways = new FileRemote.FileRemoteAccessorSelector(){

            @Override
            public FileRemoteAccessor selectFileRemoteAccessor(String string) {
                return FileAccessorLocalJava7.getInstance();
            }
        };
    }

    protected class WalkFileTreeVisitorCheck
    implements FileVisitor<Path> {
        final FileCluster fileCluster;
        final boolean refresh;
        final boolean resetMark;
        private CurrDirChildren curr;
        final int markCheck;
        final SortedTreeWalkerCallback.Counters cntTotal = new SortedTreeWalkerCallback.Counters();
        final TreeWalkerPathCheck checker;
        FileRemoteCallback callback;

        public WalkFileTreeVisitorCheck(FileCluster fileCluster, boolean bl, boolean bl2, String string, long l, FileRemoteCallback fileRemoteCallback) {
            this.fileCluster = fileCluster;
            this.refresh = bl;
            this.resetMark = bl2;
            this.markCheck = (int)(l & 0xFFFFFFFFFFFFFFFFL);
            this.checker = new TreeWalkerPathCheck(string);
            this.callback = fileRemoteCallback;
            this.curr = new CurrDirChildren(null, null);
            this.curr.levelProcessMarked = (int)(l >> 32);
            this.reset();
        }

        private FileVisitResult translateResult(SortedTreeWalkerCallback.Result result) {
            FileVisitResult fileVisitResult;
            switch (result) {
                case cont: {
                    fileVisitResult = FileVisitResult.CONTINUE;
                    break;
                }
                case skipSiblings: {
                    fileVisitResult = FileVisitResult.SKIP_SIBLINGS;
                    break;
                }
                case skipSubtree: {
                    fileVisitResult = FileVisitResult.SKIP_SUBTREE;
                    break;
                }
                case terminate: {
                    fileVisitResult = FileVisitResult.TERMINATE;
                    break;
                }
                default: {
                    fileVisitResult = FileVisitResult.TERMINATE;
                }
            }
            return fileVisitResult;
        }

        private void reset() {
            this.cntTotal.clear();
        }

        @Override
        public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
            SortedTreeWalkerCallback.Result result;
            String string;
            Path path2 = path.getFileName();
            String string2 = string = path2 == null ? "/" : path2.toString();
            if (this.checker != null && (result = this.checker.offerParentNode(string)) != SortedTreeWalkerCallback.Result.cont) {
                return this.translateResult(result);
            }
            CharSequence charSequence = FileSystem.normalizePath(path.toString());
            FileRemote fileRemote = this.fileCluster.getDir(charSequence);
            if (this.curr.levelProcessMarked == 1 && (fileRemote.getMark() & this.markCheck) == 0) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            if (this.resetMark && this.curr.levelProcessMarked <= 0) {
                fileRemote.resetMarked(-1);
            }
            FileAccessorLocalJava7.setAttributes(fileRemote, path, basicFileAttributes);
            if (this.refresh && this.curr != null) {
                fileRemote.internalAccess().clrFlagBit(0x40000000);
            }
            if ((result = this.callback.offerParentNode(fileRemote)) == SortedTreeWalkerCallback.Result.cont) {
                this.curr = new CurrDirChildren(fileRemote, this.curr);
                if (FileAccessorLocalJava7.this.debugout) {
                    System.out.println("FileRemoteAccessorLocalJava7 - callback - pre dir; " + this.curr.dir.getAbsolutePath());
                }
            } else if (FileAccessorLocalJava7.this.debugout) {
                System.out.println("FileRemoteAccessorLocalJava7 - callback - pre dir don't entry; " + this.curr.dir.getAbsolutePath());
            }
            return this.translateResult(result);
        }

        @Override
        public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
            if (this.curr.cnt.nrofParentSelected == this.curr.cnt.nrofParents && this.curr.cnt.nrofLeafSelected == this.curr.cnt.nrofLeafss) {
                if (this.curr.parent != null) {
                    ++this.curr.parent.cnt.nrofParentSelected;
                }
                ++this.cntTotal.nrofParentSelected;
            }
            if (this.checker != null) {
                this.checker.finishedParentNode(this.curr.dir.getName(), this.curr.cnt);
            }
            SortedTreeWalkerCallback.Result result = this.callback.finishedParentNode(this.curr.dir, this.curr.cnt);
            if (this.refresh) {
                this.curr.dir.timeChildren = System.currentTimeMillis();
                this.curr.dir.internalAccess().setChildrenRefreshed();
            }
            if (FileAccessorLocalJava7.this.debugout) {
                System.out.println("FileRemoteAccessorLocalJava7 - callback - post dir; " + this.curr.dir.getAbsolutePath());
            }
            this.curr = this.curr.parent;
            if (this.curr != null) {
                ++this.curr.cnt.nrofParents;
            }
            return this.translateResult(result);
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
            SortedTreeWalkerCallback.Result result;
            FileRemote fileRemote;
            String string = path.getFileName().toString();
            if (this.checker != null && this.checker.offerLeafNode(string, (Object)null) != SortedTreeWalkerCallback.Result.cont) {
                return FileVisitResult.CONTINUE;
            }
            if (FileAccessorLocalJava7.this.debugout) {
                System.out.println("FileRemoteAccessorLocalJava7 - callback - file; " + string);
            }
            if (basicFileAttributes.isDirectory()) {
                ++this.curr.cnt.nrofParents;
                ++this.cntTotal.nrofParents;
            } else {
                ++this.curr.cnt.nrofLeafss;
                ++this.cntTotal.nrofLeafss;
            }
            if (this.curr.dir != null) {
                fileRemote = basicFileAttributes.isDirectory() ? this.curr.dir.subdir(string) : this.curr.dir.child(string);
            } else {
                java.nio.file.FileSystem fileSystem = path.getFileSystem();
                String string2 = path.getParent().toString();
                fileRemote = this.fileCluster.getFile(string2, string);
            }
            if (this.curr.levelProcessMarked > 0 && (fileRemote.getMark() & this.markCheck) == 0) {
                return FileVisitResult.CONTINUE;
            }
            if (this.resetMark) {
                fileRemote.resetMarked(-1);
            }
            FileAccessorLocalJava7.setAttributes(fileRemote, path, basicFileAttributes);
            long l = basicFileAttributes.size();
            if (this.callback.shouldAborted()) {
                result = SortedTreeWalkerCallback.Result.terminate;
            } else {
                if (this.refresh) {
                    fileRemote.internalAccess().clrFlagBit(0x40000000);
                    fileRemote.internalAccess().setRefreshed();
                }
                if (basicFileAttributes.isDirectory()) {
                    ++this.curr.cnt.nrofParentSelected;
                    ++this.cntTotal.nrofParentSelected;
                } else {
                    ++this.curr.cnt.nrofLeafSelected;
                    ++this.cntTotal.nrofLeafSelected;
                }
                this.curr.cnt.nrofBytes += l;
                this.cntTotal.nrofBytes += l;
                result = this.callback.offerLeafNode(fileRemote, null);
            }
            return this.translateResult(result);
        }

        @Override
        public FileVisitResult visitFileFailed(Path path, IOException iOException) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        private class CurrDirChildren {
            FileRemote dir;
            final SortedTreeWalkerCallback.Counters cnt = new SortedTreeWalkerCallback.Counters();
            int levelProcessMarked;
            CurrDirChildren parent;

            CurrDirChildren(FileRemote fileRemote, CurrDirChildren currDirChildren) {
                this.dir = fileRemote;
                this.parent = currDirChildren;
                int n = this.levelProcessMarked = currDirChildren == null ? 0 : currDirChildren.levelProcessMarked - 1;
                if (WalkFileTreeVisitorCheck.this.refresh) {
                    // empty if block
                }
            }
        }
    }

    protected class WalkFileTreeVisitor
    implements FileVisitor<Path> {
        final FileCluster fileCluster;
        final boolean refresh;
        final boolean resetMark;
        final FileRemoteCallback callback;
        private CurrDirChildren curr;
        final int markCheck;
        FilepathFilter mask;
        final SortedTreeWalkerCallback.Counters cntTotal = new SortedTreeWalkerCallback.Counters();

        public WalkFileTreeVisitor(FileCluster fileCluster, boolean bl, boolean bl2, String string, long l, FileRemoteCallback fileRemoteCallback) {
            this.fileCluster = fileCluster;
            this.refresh = bl;
            this.resetMark = bl2;
            this.markCheck = (int)(l & 0xFFFFFFFFFFFFFFFFL);
            this.callback = fileRemoteCallback;
            this.curr = new CurrDirChildren(null, null);
            this.curr.levelProcessMarked = (int)(l >> 32);
            this.mask = new FilepathFilter(string);
            this.reset();
        }

        private FileVisitResult translateResult(SortedTreeWalkerCallback.Result result) {
            FileVisitResult fileVisitResult;
            switch (result) {
                case cont: {
                    fileVisitResult = FileVisitResult.CONTINUE;
                    break;
                }
                case skipSiblings: {
                    fileVisitResult = FileVisitResult.SKIP_SIBLINGS;
                    break;
                }
                case skipSubtree: {
                    fileVisitResult = FileVisitResult.SKIP_SUBTREE;
                    break;
                }
                case terminate: {
                    fileVisitResult = FileVisitResult.TERMINATE;
                    break;
                }
                default: {
                    fileVisitResult = FileVisitResult.TERMINATE;
                }
            }
            return fileVisitResult;
        }

        private void reset() {
            this.cntTotal.clear();
        }

        @Override
        public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
            SortedTreeWalkerCallback.Result result;
            Path path2 = path.getFileName();
            String string = path2 == null ? "/" : path2.toString();
            CharSequence charSequence = FileSystem.normalizePath(path.toString());
            FileRemote fileRemote = this.fileCluster.getDir(charSequence);
            if (this.curr.levelProcessMarked == 1 && (fileRemote.getMark() & this.markCheck) == 0) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            if (this.resetMark && this.curr.levelProcessMarked <= 0) {
                fileRemote.resetMarked(-1);
            }
            FileAccessorLocalJava7.setAttributes(fileRemote, path, basicFileAttributes);
            if (this.refresh && this.curr != null) {
                fileRemote.internalAccess().clrFlagBit(0x40000000);
            }
            SortedTreeWalkerCallback.Result result2 = result = this.callback != null ? this.callback.offerParentNode(fileRemote) : SortedTreeWalkerCallback.Result.cont;
            if (result == SortedTreeWalkerCallback.Result.cont) {
                this.curr = new CurrDirChildren(fileRemote, this.curr);
                if (FileAccessorLocalJava7.this.debugout) {
                    System.out.println("FileRemoteAccessorLocalJava7 - callback - pre dir; " + this.curr.dir.getAbsolutePath());
                }
            } else if (FileAccessorLocalJava7.this.debugout) {
                System.out.println("FileRemoteAccessorLocalJava7 - callback - pre dir don't entry; " + this.curr.dir.getAbsolutePath());
            }
            return this.translateResult(result);
        }

        @Override
        public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
            SortedTreeWalkerCallback.Result result;
            if (this.refresh) {
                this.curr.dir.timeChildren = System.currentTimeMillis();
                this.curr.dir.internalAccess().setChildrenRefreshed();
            }
            if (this.curr.cnt.nrofParentSelected == this.curr.cnt.nrofParents && this.curr.cnt.nrofLeafSelected == this.curr.cnt.nrofLeafss) {
                if (this.curr.parent != null) {
                    ++this.curr.parent.cnt.nrofParentSelected;
                }
                ++this.cntTotal.nrofParentSelected;
            }
            SortedTreeWalkerCallback.Result result2 = result = this.callback != null ? this.callback.finishedParentNode(this.curr.dir, this.curr.cnt) : SortedTreeWalkerCallback.Result.cont;
            if (FileAccessorLocalJava7.this.debugout) {
                System.out.println("FileRemoteAccessorLocalJava7 - callback - post dir; " + this.curr.dir.getAbsolutePath());
            }
            this.curr = this.curr.parent;
            if (this.curr != null) {
                ++this.curr.cnt.nrofParents;
            }
            return this.translateResult(result);
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
            SortedTreeWalkerCallback.Result result;
            FileRemote fileRemote;
            String string = path.getFileName().toString();
            if (string.startsWith("Byte")) {
                Debugutil.stop();
            }
            boolean bl = this.mask.checkName(string);
            if (FileAccessorLocalJava7.this.debugout) {
                System.out.println("FileRemoteAccessorLocalJava7 - callback - file; " + string);
            }
            if (basicFileAttributes.isDirectory()) {
                ++this.curr.cnt.nrofParents;
                ++this.cntTotal.nrofParents;
            } else {
                ++this.curr.cnt.nrofLeafss;
                ++this.cntTotal.nrofLeafss;
            }
            if (this.curr.dir != null) {
                fileRemote = basicFileAttributes.isDirectory() ? this.curr.dir.subdir(string) : this.curr.dir.child(string);
            } else {
                java.nio.file.FileSystem fileSystem = path.getFileSystem();
                String string2 = path.getParent().toString();
                fileRemote = this.fileCluster.getFile(string2, string);
            }
            if (this.curr.levelProcessMarked > 0 && (fileRemote.getMark() & this.markCheck) == 0) {
                return FileVisitResult.CONTINUE;
            }
            if (this.resetMark) {
                fileRemote.resetMarked(-1);
            }
            FileAccessorLocalJava7.setAttributes(fileRemote, path, basicFileAttributes);
            long l = basicFileAttributes.size();
            if (this.callback != null && this.callback.shouldAborted()) {
                result = SortedTreeWalkerCallback.Result.terminate;
            } else {
                if (this.refresh) {
                    fileRemote.internalAccess().clrFlagBit(0x40000000);
                    fileRemote.internalAccess().setRefreshed();
                }
                if (this.callback != null) {
                    if (bl) {
                        if (basicFileAttributes.isDirectory()) {
                            ++this.curr.cnt.nrofParentSelected;
                            ++this.cntTotal.nrofParentSelected;
                        } else {
                            ++this.curr.cnt.nrofLeafSelected;
                            ++this.cntTotal.nrofLeafSelected;
                        }
                        this.curr.cnt.nrofBytes += l;
                        this.cntTotal.nrofBytes += l;
                        result = this.callback.offerLeafNode(fileRemote, null);
                    } else {
                        result = SortedTreeWalkerCallback.Result.cont;
                    }
                } else {
                    result = SortedTreeWalkerCallback.Result.cont;
                }
            }
            return this.translateResult(result);
        }

        @Override
        public FileVisitResult visitFileFailed(Path path, IOException iOException) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        private class CurrDirChildren {
            FileRemote dir;
            final SortedTreeWalkerCallback.Counters cnt = new SortedTreeWalkerCallback.Counters();
            int levelProcessMarked;
            CurrDirChildren parent;

            CurrDirChildren(FileRemote fileRemote, CurrDirChildren currDirChildren) {
                this.dir = fileRemote;
                this.parent = currDirChildren;
                int n = this.levelProcessMarked = currDirChildren == null ? 0 : currDirChildren.levelProcessMarked - 1;
                if (WalkFileTreeVisitor.this.refresh) {
                    // empty if block
                }
            }
        }
    }

    private class RunRefreshWithChildren
    implements Runnable {
        long time;
        final FileRemote fileRemote;
        final FileRemote.CallbackEvent callback;

        RunRefreshWithChildren(FileRemote fileRemote, FileRemote.CallbackEvent callbackEvent) {
            this.fileRemote = fileRemote;
            this.callback = callbackEvent;
        }

        @Override
        public void run() {
            try {
                long l;
                this.time = System.currentTimeMillis();
                FileAccessorLocalJava7.this.refreshFileProperties(this.fileRemote, null);
                File file = FileAccessorLocalJava7.this.getLocalFile(this.fileRemote);
                if (file.exists()) {
                    l = System.currentTimeMillis();
                    if (FileAccessorLocalJava7.this.debugout) {
                        System.out.println("FileAccessorLocalJava7.refreshFilePropertiesAndChildren - start listFiles; dt=" + (l - this.time));
                    }
                    File[] fileArray = file.listFiles();
                    l = System.currentTimeMillis();
                    if (FileAccessorLocalJava7.this.debugout) {
                        System.out.println("FileAccessorLocalJava7.refreshFilePropertiesAndChildren - ok listFiles; dt=" + (l - this.time));
                    }
                    if (fileArray != null) {
                        Map<String, FileRemote> map = this.fileRemote.children();
                        this.fileRemote.internalAccess().newChildren();
                        int n = -1;
                        for (File file2 : fileArray) {
                            String string = file2.getName();
                            FileRemote fileRemote = null;
                            if (map != null) {
                                fileRemote = map.remove(string);
                            }
                            if (fileRemote == null) {
                                int n2 = file2.isDirectory() ? 16 : 0;
                                fileRemote = this.fileRemote.internalAccess().newChild(string, 0L, 0L, 0L, 0L, n2, file2);
                            } else if (!fileRemote.isTested(this.time - 1000L)) {
                                // empty if block
                            }
                            this.fileRemote.internalAccess().putNewChild(fileRemote);
                        }
                        if (FileAccessorLocalJava7.this.debugout) {
                            System.out.println("FileAccessorLocalJava7.refreshFilePropertiesAndChildren - ok refresh; " + fileArray.length + " files; dt=" + (System.currentTimeMillis() - this.time));
                        }
                    }
                }
                this.fileRemote.timeChildren = System.currentTimeMillis();
                if (this.callback != null) {
                    this.callback.occupy(FileAccessorLocalJava7.this.evSrc, true);
                    l = System.currentTimeMillis();
                    if (FileAccessorLocalJava7.this.debugout) {
                        System.out.println("FileAccessorLocalJava7.refreshFilePropertiesAndChildren - callback listFiles; dt=" + (l - this.time));
                    }
                    this.callback.sendEvent(FileRemote.CallbackCmd.done);
                    l = System.currentTimeMillis();
                    if (FileAccessorLocalJava7.this.debugout) {
                        System.out.println("FileAccessorLocalJava7.refreshFilePropertiesAndChildren - finish listFiles; dt=" + (l - this.time));
                    }
                }
                this.fileRemote.internalAccess().clrFlagBit(0x20000000);
            }
            catch (Exception exception) {
                System.err.println("FileAccessorLocalJava7.refreshFilePropertiesAndChildren - Thread Excpetion;" + exception.getMessage());
            }
        }
    }

    private class RunRefresh
    implements Runnable {
        final FileRemote fileRemote;
        final FileRemote.CallbackEvent callback;

        RunRefresh(FileRemote fileRemote, FileRemote.CallbackEvent callbackEvent) {
            this.fileRemote = fileRemote;
            this.callback = callbackEvent;
        }

        @Override
        public void run() {
            String string = this.fileRemote.getAbsolutePath();
            Path path = Paths.get(string, new String[0]);
            try {
                BasicFileAttributes basicFileAttributes = Files.readAttributes(path, FileAccessorLocalJava7.this.systemAttribtype, new LinkOption[0]);
                FileAccessorLocalJava7.setAttributes(this.fileRemote, path, basicFileAttributes);
            }
            catch (IOException iOException) {
                this.fileRemote.internalAccess().clrFlagBit(1);
            }
            this.fileRemote.timeRefresh = System.currentTimeMillis();
            if (this.callback != null) {
                this.callback.occupy(FileAccessorLocalJava7.this.evSrc, true);
                this.callback.sendEvent(FileRemote.CallbackCmd.done);
            }
        }
    }
}

