/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.docuGen;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.vishia.mainCmd.MainCmd;
import org.vishia.mainCmd.MainCmd_ifc;
import org.vishia.util.DataShow;
import org.vishia.util.FilePath;
import org.vishia.util.FileSystem;
import org.vishia.zbnf.ZbnfJavaOutput;

public class DocuGen {
    public static final String sVersion = "2015-12-05";
    final MainCmd_ifc console;

    public static void main(String[] stringArray) {
        Args args = new Args();
        CmdLine cmdLine = new CmdLine(args, stringArray);
        boolean bl = true;
        try {
            cmdLine.parseArguments();
        }
        catch (Exception exception) {
            cmdLine.setExitErrorLevel(5);
            bl = false;
        }
        if (bl) {
            DocuGen docuGen = new DocuGen(cmdLine);
            try {
                docuGen.execute(args);
            }
            catch (Exception exception) {
                docuGen.console.report("Uncatched Exception on main level:", exception);
                docuGen.console.setExitErrorLevel(3);
            }
        }
        cmdLine.exit();
    }

    public DocuGen(MainCmd_ifc mainCmd_ifc) {
        this.console = mainCmd_ifc;
    }

    void execute(Args args) throws IOException, IllegalAccessException {
        ZbnfDocuGenCtrl zbnfDocuGenCtrl = this.parseAndStoreInput(args);
        if (zbnfDocuGenCtrl != null) {
            this.prepareDocuGenCtrl(zbnfDocuGenCtrl);
            if (args.sCheckDataHtml != null) {
                FileWriter fileWriter = new FileWriter(args.sCheckDataHtml);
                DataShow.outHtml(zbnfDocuGenCtrl, fileWriter);
                ((Writer)fileWriter).close();
            }
        } else {
            this.console.writeInfoln("ERROR");
        }
    }

    private void prepareDocuGenCtrl(ZbnfDocuGenCtrl zbnfDocuGenCtrl) {
    }

    private ZbnfDocuGenCtrl parseAndStoreInput(Args args) {
        ZbnfDocuGenCtrl zbnfDocuGenCtrl = new ZbnfDocuGenCtrl();
        File file = new File(args.sCurrDir + "/" + args.sCtrlFile);
        File file2 = new File(args.sDirZbnfJax + "/zdocu/DocuGenCtrl.zbnf");
        String string = ZbnfJavaOutput.parseFileAndFillJavaObject(zbnfDocuGenCtrl.getClass(), zbnfDocuGenCtrl, file, file2, this.console, 1200);
        if (string != null) {
            this.console.writeError("ERROR Parsing file: " + file.getAbsolutePath() + "\n" + string);
            return null;
        }
        this.console.writeInfoln("SUCCESS parsed: " + file.getAbsolutePath());
        return zbnfDocuGenCtrl;
    }

    public static class HyperlinkAssociation {
        public String href;
        public String dst;
        public String content;
    }

    public static class Inset {
        public String label;
        public String topic;
    }

    public static class Topic
    extends Content {
        boolean bTree = false;
        public String select;
    }

    public static class Content {
    }

    public static class DocuInput {
        FilePath inputFile;

        public void set_inputfile(String string) {
            this.inputFile = new FilePath(string);
        }
    }

    public static class Document {
        public String title;
        public String ident;
        public FilePath outHtml;
        public FilePath outWord;
        public FilePath cssHtml;
        public List<DocuInput> inputs = new ArrayList<DocuInput>();
        public List<Content> content = new ArrayList<Content>();
        public String crossRef;
        public String filePath;
        public Map<String, HyperlinkAssociation> hyperlinkAssociations;
        public Map<String, Inset> insets;

        public Document new_outHtml() {
            return this;
        }

        public void set_outHtml(Document document) {
            this.outHtml = new FilePath(this.filePath);
        }

        public Document new_outWord() {
            return this;
        }

        public void set_outWord(Document document) {
            this.outWord = new FilePath(this.filePath);
        }

        public void set_cssHtml(String string) {
            this.cssHtml = new FilePath(string);
        }

        public DocuInput new_input() {
            return new DocuInput();
        }

        public void add_input(DocuInput docuInput) {
            this.inputs.add(docuInput);
        }

        public Topic new_topictree() {
            Topic topic = new Topic();
            topic.bTree = true;
            return topic;
        }

        public void add_topictree(Topic topic) {
            this.content.add(topic);
        }

        public Topic new_topic() {
            Topic topic = new Topic();
            topic.bTree = false;
            return topic;
        }

        public void add_topic(Topic topic) {
            this.content.add(topic);
        }

        public void set_crossRef(String string) {
            this.crossRef = string;
        }

        public HyperlinkAssociation new_HyperlinkAssociation() {
            return new HyperlinkAssociation();
        }

        public void add_HyperlinkAssociation(HyperlinkAssociation hyperlinkAssociation) {
            if (this.hyperlinkAssociations == null) {
                this.hyperlinkAssociations = new TreeMap<String, HyperlinkAssociation>();
            }
            this.hyperlinkAssociations.put(hyperlinkAssociation.href, hyperlinkAssociation);
        }

        public Inset new_inset() {
            return new Inset();
        }

        public void add_inset(Inset inset) {
            if (this.insets == null) {
                this.insets = new TreeMap<String, Inset>();
            }
            this.insets.put(inset.label, inset);
        }
    }

    public static class Target {
        public String target;
        public String translator;
        public FilePath output;
        public FilePath srcpath;
        public List<FilePath> inputs = new ArrayList<FilePath>();

        public void set_output(String string) {
            this.output = new FilePath(string);
        }

        public void set_srcpath(String string) {
            this.srcpath = new FilePath(string);
        }

        public void set_inputfile(String string) {
            FilePath filePath = new FilePath(string);
            this.inputs.add(filePath);
        }
    }

    public static class ZbnfDocuGenCtrl {
        public String file;
        public String hrefCtrl;
        public List<Target> target = new ArrayList<Target>();
        public Map<String, Document> documents = new TreeMap<String, Document>();
        public Map<String, HyperlinkAssociation> hyperlinkAssociations;

        public void set_hrefCtrl(String string) {
            this.hrefCtrl = string;
        }

        public Document new_document() {
            return new Document();
        }

        public void add_document(Document document) {
            String string = document.ident != null ? document.ident : "???";
            this.documents.put(string, document);
        }

        public HyperlinkAssociation new_HyperlinkAssociation() {
            return new HyperlinkAssociation();
        }

        public void add_HyperlinkAssociation(HyperlinkAssociation hyperlinkAssociation) {
            if (this.hyperlinkAssociations == null) {
                this.hyperlinkAssociations = new TreeMap<String, HyperlinkAssociation>();
            }
            this.hyperlinkAssociations.put(hyperlinkAssociation.href, hyperlinkAssociation);
        }
    }

    public static class CmdLine
    extends MainCmd {
        Args cmdlineArgs;
        protected final MainCmd.Argument[] arglist1 = new MainCmd.Argument[]{new MainCmd.Argument("-checkdata", "=CHECK.html if given then a html file for debugging will be written", new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                cmdlineArgs.sCheckDataHtml = string;
                return true;
            }
        }), new MainCmd.Argument("-zbnfjax", ":<Path> to the script directory zbnfjax", new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                cmdlineArgs.sDirZbnfJax = string;
                return true;
            }
        }), new MainCmd.Argument("", " <Path> to the docu generation control file. Its directory is the current directory", new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                String string2 = FileSystem.absolutePath(string, null);
                int n = string2.lastIndexOf(47);
                cmdlineArgs.sCurrDir = string2.substring(0, n);
                cmdlineArgs.sCtrlFile = string2.substring(n + 1);
                return true;
            }
        })};

        public CmdLine(Args args, String[] stringArray) {
            super(stringArray);
            this.cmdlineArgs = args;
            for (MainCmd.Argument argument : this.arglist1) {
                this.argList.add(argument);
            }
            super.addHelpInfo("==Standard arguments of MainCmd==");
            super.addStandardHelpInfo();
        }

        @Override
        protected boolean checkArguments() {
            boolean bl = true;
            if (this.cmdlineArgs.sCtrlFile == null) {
                bl = false;
                this.writeError("ERROR argument -iInputfile is obligate.");
            }
            if (!bl) {
                this.setExitErrorLevel(5);
            }
            return bl;
        }
    }

    public static class Args {
        public String sDirZbnfJax;
        public String sCurrDir;
        public String sCtrlFile;
        public String sCheckDataHtml;
    }
}

