/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.checkDeps_C;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.vishia.checkDeps_C.CfgData;
import org.vishia.checkDeps_C.InputSrc;
import org.vishia.mainCmd.MainCmdLogging_ifc;
import org.vishia.util.FileSystem;

public class ParserConfigFile {
    public static final int version = 20121225;
    private final MainCmdLogging_ifc console;
    private final Map<String, String> indexEnvirVariables = new TreeMap<String, String>();
    private final CfgData data;
    private final File currdir;

    public ParserConfigFile(CfgData cfgData, MainCmdLogging_ifc mainCmdLogging_ifc, File file) {
        this.console = mainCmdLogging_ifc;
        this.data = cfgData;
        this.currdir = file;
    }

    String parseConfigFile(String string) {
        try {
            String string2;
            File file = new File(this.currdir, string);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            block6: while ((string2 = bufferedReader.readLine()) != null) {
                int n = string2.indexOf(35);
                if (n >= 0) {
                    string2 = string2.substring(0, n);
                }
                if ((string2 = string2.trim()).startsWith("-s=")) {
                    this.parseCfgIncludeLine(string2, 's');
                    continue;
                }
                if (string2.startsWith("-i=")) {
                    this.parseCfgIncludeLine(string2, 'i');
                    continue;
                }
                if (string2.startsWith("-j=")) {
                    this.parseCfgIncludeLine(string2, 'j');
                    continue;
                }
                if (string2.startsWith("-g=")) {
                    this.parseCfgIncludeLine(string2, 'g');
                    continue;
                }
                if (string2.startsWith("-y=")) {
                    this.parseCfgIncludeLine(string2, 'y');
                    continue;
                }
                if (string2.length() <= 1) continue;
                switch (string2.charAt(0)) {
                    case '$': {
                        this.parseCfgEnvironmentVariable(string2);
                        continue block6;
                    }
                }
                throw new IllegalArgumentException("config file - error in line; " + string2);
            }
            bufferedReader.close();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return "CheckDeps -" + illegalArgumentException.getMessage();
        }
        catch (IOException iOException) {
            return "CheckDeps - config file read error;" + iOException.getMessage();
        }
        return null;
    }

    private void parseCfgEnvironmentVariable(String string) {
        int n = string.indexOf(61);
        String string2 = string.substring(1, n).trim();
        String string3 = string.substring(n + 1).trim();
        this.indexEnvirVariables.put(string2, string3);
    }

    private void parseCfgIncludeLine(String string, char c) {
        boolean bl;
        File file;
        String string2;
        int n;
        StringBuilder stringBuilder = new StringBuilder(string.substring(3));
        while ((n = stringBuilder.indexOf("$")) >= 0) {
            int n2 = stringBuilder.indexOf(")", n + 2);
            if (stringBuilder.charAt(n + 1) != '(' || n2 < 0) {
                throw new IllegalArgumentException("Error in cfg-file: Write $(name). Line;" + string);
            }
            String string3 = stringBuilder.substring(n + 2, n2);
            string2 = this.indexEnvirVariables.get(string3);
            if (string2 == null) {
                string2 = System.getenv(string3);
            }
            if (string2 == null) {
                string2 = System.getProperty(string3);
            }
            if (string2 == null) {
                throw new IllegalArgumentException("config file - env-variable not found; " + string3);
            }
            stringBuilder.replace(n, n2 + 1, string2);
        }
        String string4 = stringBuilder.toString();
        int n3 = string4.indexOf(58, 2);
        if (n3 > 0) {
            stringBuilder.setCharAt(n3, '/');
        }
        File file2 = file = (bl = FileSystem.isAbsolutePath(string2 = stringBuilder.toString())) ? new File(string2) : new File(this.currdir, string2);
        if (!file.exists()) {
            this.console.writeWarning("config file - include path not found; " + string2);
        } else if (!file.isDirectory()) {
            this.console.writeWarning("config file - include path is not a directory; " + string2);
        } else {
            switch (c) {
                case 'i': 
                case 's': {
                    InputSrc inputSrc = new InputSrc(string4, this.currdir);
                    this.data.listSourcePaths.add(inputSrc);
                    this.data.listInclPaths.add(file);
                    if (c != 's') break;
                    this.data.listProcessPaths.add(inputSrc);
                    break;
                }
                case 'j': {
                    this.data.listInclPaths.add(file);
                    break;
                }
                case 'y': {
                    this.data.listSystemInclPaths.add(file);
                    break;
                }
                case 'g': {
                    this.data.listGenSrcInclPaths.add(file);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
    }
}

