/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.byteData;

import org.vishia.byteData.ByteDataAccessBase;

public class ByteDataVariable {
    public static final String version = "2018-09-18";

    public static class Uint32Array {
        private final int ixData;
        private final int lengthData;
        private final ByteDataAccessBase acc;
        public final Uint32[] array;

        public int get(int n) {
            return this.acc.getUint32(this.ixData, n, this.lengthData);
        }

        public void set(int n, int n2) {
            this.acc.setUint32(this.ixData, n, this.lengthData, n2);
        }

        public Uint32Array(ByteDataAccessBase byteDataAccessBase, int n, int n2) {
            this.acc = byteDataAccessBase;
            this.ixData = n;
            this.lengthData = n2;
            this.array = new Uint32[n2];
            for (int i = 0; i < n2; ++i) {
                this.array[i] = new Uint32(byteDataAccessBase, n + 4 * i);
            }
        }

        public String toString() {
            return "[" + Integer.toString(this.lengthData) + "] @" + Integer.toString(this.ixData) + "=0x" + Integer.toHexString(this.ixData);
        }
    }

    public static class Uint32 {
        private final int ixData;
        private final ByteDataAccessBase acc;

        public int get() {
            return this.acc.getUint32(this.ixData);
        }

        public void set(int n) {
            this.acc.setUint32(this.ixData, n);
        }

        public Uint32(ByteDataAccessBase byteDataAccessBase, int n) {
            this.acc = byteDataAccessBase;
            this.ixData = n;
        }

        public String toString() {
            int n = this.get();
            return Integer.toString(n) + " = 0x" + Integer.toHexString(n) + " @" + Integer.toString(this.ixData) + "=0x" + Integer.toHexString(this.ixData);
        }
    }

    public static class Uint16Array {
        private final int ixData;
        private final int lengthData;
        private final ByteDataAccessBase acc;
        public final Uint16[] array;

        public int get(int n) {
            return this.acc.getUint16(this.ixData, n, this.lengthData);
        }

        public void set(int n, int n2) {
            this.acc.setUint16(this.ixData, n, this.lengthData, n2);
        }

        public Uint16Array(ByteDataAccessBase byteDataAccessBase, int n, int n2) {
            this.acc = byteDataAccessBase;
            this.ixData = n;
            this.lengthData = n2;
            this.array = new Uint16[n2];
            for (int i = 0; i < n2; ++i) {
                this.array[i] = new Uint16(byteDataAccessBase, n + 2 * i);
            }
        }

        public String toString() {
            return "[" + Integer.toString(this.lengthData) + "] @" + Integer.toString(this.ixData) + "=0x" + Integer.toHexString(this.ixData);
        }
    }

    public static class Uint16 {
        private final int ixData;
        private final ByteDataAccessBase acc;

        public int get() {
            return this.acc.getUint16(this.ixData);
        }

        public void set(int n) {
            this.acc.setUint16(this.ixData, n);
        }

        public Uint16(ByteDataAccessBase byteDataAccessBase, int n) {
            this.acc = byteDataAccessBase;
            this.ixData = n;
        }

        public String toString() {
            int n = this.get();
            return Integer.toString(n) + " = 0x" + Integer.toHexString(n) + " @" + Integer.toString(this.ixData) + "=0x" + Integer.toHexString(this.ixData);
        }
    }

    public static class Int16 {
        private final int ixData;
        private final ByteDataAccessBase acc;

        public short get() {
            return this.acc.getInt16(this.ixData);
        }

        public void set(int n) {
            this.acc.setInt16(this.ixData, n);
        }

        public Int16(ByteDataAccessBase byteDataAccessBase, int n) {
            this.acc = byteDataAccessBase;
            this.ixData = n;
        }

        public String toString() {
            short s = this.get();
            return Integer.toString(s) + " = 0x" + Integer.toHexString(s) + " @" + Integer.toString(this.ixData) + "=0x" + Integer.toHexString(this.ixData);
        }
    }

    public static class Int32Array {
        private final int ixData;
        private final int lengthData;
        private final ByteDataAccessBase acc;
        public final Int32[] array;

        public int get(int n) {
            return this.acc.getInt32(this.ixData, n, this.lengthData);
        }

        public void set(int n, int n2) {
            this.acc.setInt32(this.ixData, n, this.lengthData, n2);
        }

        public Int32Array(ByteDataAccessBase byteDataAccessBase, int n, int n2) {
            this.acc = byteDataAccessBase;
            this.ixData = n;
            this.lengthData = n2;
            this.array = new Int32[n2];
            for (int i = 0; i < n2; ++i) {
                this.array[i] = new Int32(byteDataAccessBase, n + 4 * i);
            }
        }

        public String toString() {
            return "[" + Integer.toString(this.lengthData) + "] @" + Integer.toString(this.ixData) + "=0x" + Integer.toHexString(this.ixData);
        }
    }

    public static class Int32 {
        private final int ixData;
        private final ByteDataAccessBase acc;

        public int get() {
            return this.acc.getInt32(this.ixData);
        }

        public void set(int n) {
            this.acc.setInt32(this.ixData, n);
        }

        public Int32(ByteDataAccessBase byteDataAccessBase, int n) {
            this.acc = byteDataAccessBase;
            this.ixData = n;
        }

        public String toString() {
            int n = this.get();
            return Integer.toString(n) + " = 0x" + Integer.toHexString(n) + " @" + Integer.toString(this.ixData) + "=0x" + Integer.toHexString(this.ixData);
        }
    }
}

