/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.byteData;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.vishia.util.InfoFormattedAppend;
import org.vishia.util.Java4C;
import org.vishia.util.RetOrException;
import org.vishia.util.StringFormatter;

@Java4C.ExcludeInterface(value="InfoFormattedAppend")
public class ByteDataAccessBase
implements InfoFormattedAppend {
    public static final String version = "2018-09-18";
    protected final int sizeHead;
    @Java4C.PtrVal
    protected byte[] data;
    private int ixBegin;
    private int ixBeginLocal;
    private int ixNextChild;
    private int ixEnd;
    private boolean bExpand;
    protected boolean bBigEndian;
    protected boolean bExc = true;
    private ByteDataAccessBase parent;
    private ByteDataAccessBase currChild;
    @Java4C.SimpleRef
    private Charset charset = Charset.forName("ISO-8859-1");
    @Java4C.Exclude
    protected StringFormatter toStringformatter = null;

    public ByteDataAccessBase(int n) {
        this.sizeHead = n;
    }

    protected ByteDataAccessBase(int n, int n2) {
        assert (n >= 0);
        assert (n2 > 0);
        this.sizeHead = n;
        this.ixBegin = 0;
        this.ixBeginLocal = 0;
        this.ixEnd = n2;
        this.bExpand = false;
        this.ixNextChild = n;
        this.parent = null;
    }

    @Java4C.Inline
    public final void setBigEndian(boolean bl) {
        this.bBigEndian = bl;
    }

    @Java4C.Inline
    public final void setException(boolean bl) {
        this.bExc = bl;
    }

    @Java4C.Exclude
    public final void setCharset(String string) {
        this.charset = Charset.forName(string);
    }

    @Java4C.NoStackTrace
    protected final long _getLong(int n, int n2) {
        int n3;
        long l;
        int n4;
        int n5;
        boolean bl;
        int n6;
        if (!this.checkData()) {
            return 0L;
        }
        long l2 = 0L;
        if (n2 >= 0) {
            n6 = n2;
            bl = false;
        } else {
            n6 = -n2;
            bl = true;
        }
        if (this.bBigEndian) {
            n5 = this.ixBegin + n;
            n4 = 1;
        } else {
            n5 = this.ixBegin + n + n6 - 1;
            n4 = -1;
        }
        int n7 = n6;
        while (true) {
            l2 |= (long)(this.data[n5] & 0xFF);
            if (--n7 <= 0) break;
            l2 <<= 8;
            n5 += n4;
        }
        if (bl && (l2 & (l = 1L << (n3 = n6 * 8 - 1))) != 0L) {
            long l3 = -1L << n3;
            l2 |= l3;
        }
        return l2;
    }

    @Java4C.NoStackTrace
    protected final int _getInt(int n, int n2) {
        int n3;
        long l;
        int n4;
        int n5;
        boolean bl;
        int n6;
        if (!this.checkData()) {
            return 0;
        }
        int n7 = 0;
        if (n2 >= 0) {
            n6 = n2;
            bl = false;
        } else {
            n6 = -n2;
            bl = true;
        }
        if (this.bBigEndian) {
            n5 = this.ixBegin + n;
            n4 = 1;
        } else {
            n5 = this.ixBegin + n + n6 - 1;
            n4 = -1;
        }
        int n8 = n6;
        while (true) {
            n7 |= this.data[n5] & 0xFF;
            if (--n8 <= 0) break;
            n7 <<= 8;
            n5 += n4;
        }
        if (bl && ((long)n7 & (l = 1L << (n3 = n6 * 8 - 1))) != 0L) {
            long l2 = -1L << n3;
            n7 = (int)((long)n7 | l2);
        }
        return n7;
    }

    @Java4C.NoStackTrace
    protected final void _setLong(int n, int n2, long l) {
        int n3;
        int n4;
        if (!this.checkData()) {
            return;
        }
        int n5 = n2;
        long l2 = l;
        if (this.bBigEndian) {
            n4 = this.ixBegin + n + n2 - 1;
            n3 = -1;
        } else {
            n4 = this.ixBegin + n;
            n3 = 1;
        }
        while (true) {
            this.data[n4] = (byte)l2;
            if (--n5 <= 0) break;
            l2 >>= 8;
            n4 += n3;
        }
    }

    @Java4C.NoStackTrace
    protected final void _setInt(int n, int n2, int n3) {
        int n4;
        int n5;
        if (!this.checkData()) {
            return;
        }
        int n6 = n2;
        int n7 = n3;
        if (this.bBigEndian) {
            n5 = this.ixBegin + n + n2 - 1;
            n4 = -1;
        } else {
            n5 = this.ixBegin + n;
            n4 = 1;
        }
        while (true) {
            this.data[n5] = (byte)n7;
            if (--n6 <= 0) break;
            n7 >>= 8;
            n5 += n4;
        }
    }

    private final void _expand(int n, int n2) {
        assert (n2 < 0 || n2 >= this.ixBegin + this.sizeHead);
        if (!this.checkData()) {
            return;
        }
        if (n2 > this.data.length) {
            throw new IllegalArgumentException("child long as data, data.length= " + this.data.length + ", ixChildEndNew= " + n2);
        }
        if (this.bExpand) {
            if (this.ixEnd < n2) {
                this.ixEnd = n2;
            }
            if (this.ixEnd < n) {
                this.ixEnd = n;
            }
            if (this.parent != null) {
                this.parent._expand(this.ixEnd, this.ixEnd);
            }
        } else {
            if (n2 >= 0) {
                this.ixEnd = n2;
            }
            if (this.parent != null) {
                this.parent._expand(n2, -1);
            }
        }
        if (this.ixNextChild < n) {
            if (n > this.ixEnd) {
                throw new IllegalArgumentException("next child pos after ixend = " + this.ixEnd + ", ixNextChilNew= " + n);
            }
            this.ixNextChild = n;
        }
    }

    @Java4C.Exclude
    protected void assignDataToFixChildren() {
    }

    public final void assign(@Java4C.PtrVal byte[] byArray, int n, int n2) throws IllegalArgumentException {
        assert (n2 >= 0 && this.sizeHead >= 0);
        this.detach();
        this.data = byArray;
        this.ixBegin = n2;
        this.ixBeginLocal = n2;
        this.parent = null;
        this.currChild = null;
        this.bExpand = n < this.sizeHead;
        this.ixNextChild = this.ixBegin + this.sizeHead;
        int n3 = this.ixEnd = this.bExpand ? this.ixBegin + this.sizeHead : this.ixBegin + n;
        if (this.data != null && this.ixEnd > this.data.length) {
            String string = "not enough data bytes, requested=" + this.ixEnd + ", buffer-length=" + this.data.length;
            throw new IllegalArgumentException(string);
        }
    }

    @Java4C.Inline
    public final void assign(@Java4C.PtrVal byte[] byArray, int n) {
        this.assign(byArray, n, 0);
    }

    @Java4C.Inline
    public final void assign(@Java4C.PtrVal byte[] byArray) {
        if (byArray == null) {
            this.detach();
        } else {
            this.assign(byArray, byArray.length, 0);
        }
    }

    @Java4C.Inline
    public final void assignClear(@Java4C.PtrVal byte[] byArray) {
        Arrays.fill(byArray, (byte)0);
        this.assign(byArray, -1, 0);
    }

    @Java4C.Inline
    public final void assignAt(int n, int n2, ByteDataAccessBase byteDataAccessBase) throws IllegalArgumentException {
        if (this == byteDataAccessBase) {
            if (n != 0) {
                throw new IllegalArgumentException("TODO");
            }
        } else {
            this.detach();
            this.bBigEndian = byteDataAccessBase.bBigEndian;
            this.bExc = byteDataAccessBase.bExc;
            this.parent = byteDataAccessBase;
            this.ixBegin = byteDataAccessBase.ixBegin + n;
            this.ixBeginLocal = n;
            this.currChild = null;
            this.bExpand = n2 < this.sizeHead;
            this.ixNextChild = this.ixBegin + this.sizeHead;
            this.ixEnd = this.bExpand ? this.ixBegin + this.sizeHead : this.ixBegin + n2;
        }
    }

    @Java4C.Inline
    public final void assignAt(int n, ByteDataAccessBase byteDataAccessBase) throws IllegalArgumentException {
        this.assignAt(n, this.sizeHead, byteDataAccessBase);
    }

    @Java4C.Inline
    protected final void assignCasted(ByteDataAccessBase byteDataAccessBase, int n, int n2) throws IllegalArgumentException {
        this.assign(byteDataAccessBase.data(), byteDataAccessBase.ixEnd, byteDataAccessBase.ixBegin + n);
        this.bExpand = byteDataAccessBase.bExpand;
        this.bBigEndian = byteDataAccessBase.bBigEndian;
        this.bExc = byteDataAccessBase.bExc;
        if (n2 > 0) {
            this.setLengthElement(n2);
        }
    }

    @Java4C.Retinline
    public final boolean isExpandable() {
        return this.bExpand;
    }

    @Java4C.Retinline
    public final int sizeHead() {
        return this.sizeHead;
    }

    @Java4C.Retinline
    @Java4C.PtrVal
    public final byte[] getData() {
        return this.getData(99);
    }

    @Java4C.Retinline
    @Java4C.PtrVal
    public final byte[] data() {
        return this.getData(99);
    }

    private final byte[] getData(int n) {
        if (this.data == null && this.parent != null) {
            if (--n < 0) {
                this.throwexc("too many recursions in parent relation", 0);
                return null;
            }
            this.data = this.parent.getData(n - 1);
            this.bBigEndian = this.parent.bBigEndian;
        }
        return this.data;
    }

    @Java4C.Inline
    public final void XXXrewind() {
        this.ixNextChild = this.ixBegin + this.sizeHead;
        if (this.currChild != null) {
            this.currChild.detach();
            this.currChild = null;
        }
    }

    @Java4C.Retinline
    public final int getLengthHead() {
        return this.sizeHead;
    }

    @Java4C.Retinline
    public final int getLengthCurrent() {
        return this.ixNextChild - this.ixBegin;
    }

    @Java4C.Retinline
    public final int getLength() {
        return this.ixEnd - this.ixBegin;
    }

    @Java4C.Retinline
    public final int getLengthTotal() {
        return this.ixEnd;
    }

    @Java4C.Retinline
    public final int getMaxNrofBytes() {
        if (!this.checkData()) {
            return 0;
        }
        if (this.bExpand) {
            return this.data.length - this.ixBegin;
        }
        return this.ixEnd - this.ixBegin;
    }

    @Java4C.Retinline
    public final boolean checkLengthElement(int n) {
        return n >= this.sizeHead && this.getMaxNrofBytes() >= n;
    }

    @Java4C.Retinline
    public final boolean getBigEndian() {
        return this.bBigEndian;
    }

    @Java4C.Inline
    public final void setLengthElement(int n) {
        this.bExpand = false;
        this._expand(0, this.ixBegin + n);
    }

    @Java4C.Inline
    public final void clearHead() {
        if (!this.checkData()) {
            return;
        }
        Arrays.fill(this.data, this.ixBegin, this.ixBegin + this.sizeHead, (byte)0);
    }

    @Java4C.Inline
    public final void clearData() {
        if (!this.checkData()) {
            return;
        }
        Arrays.fill(this.data, this.ixBegin, this.ixEnd, (byte)0);
    }

    @Java4C.Retinline
    public final boolean isInUse() {
        return this.data() != null;
    }

    public final boolean sufficingBytesForNextChild(int n) throws IllegalArgumentException {
        int n2 = this.getMaxNrofBytesForNextChild();
        return n < 0 ? false : n2 >= n;
    }

    @Java4C.Retinline
    public final int getMaxNrofBytesForNextChild() throws IllegalArgumentException {
        if (!this.checkData()) {
            return 0;
        }
        return (this.bExpand ? this.data.length : this.ixEnd) - this.ixNextChild;
    }

    public final boolean addChild(ByteDataAccessBase byteDataAccessBase, int n) throws IllegalArgumentException {
        if (!this.checkData()) {
            return false;
        }
        byteDataAccessBase.detach();
        assert (n == 0 || n >= byteDataAccessBase.sizeHead);
        assert (byteDataAccessBase.sizeHead >= 0);
        int n2 = this.setIdxtoNextCurrentChild(n == 0 ? byteDataAccessBase.sizeHead : n);
        if (n2 < 0) {
            return false;
        }
        byteDataAccessBase.ixBegin = n2;
        byteDataAccessBase.ixBeginLocal = byteDataAccessBase.ixBegin - this.ixBegin;
        byteDataAccessBase.bBigEndian = this.bBigEndian;
        byteDataAccessBase.bExc = this.bExc;
        byteDataAccessBase.bExpand = this.bExpand;
        byteDataAccessBase.data = this.data;
        byteDataAccessBase.parent = this;
        byteDataAccessBase.charset = this.charset;
        byteDataAccessBase.ixNextChild = byteDataAccessBase.ixBegin + byteDataAccessBase.sizeHead;
        byteDataAccessBase.ixEnd = this.ixEnd;
        this.currChild = byteDataAccessBase;
        return true;
    }

    @Java4C.Retinline
    public final boolean addChild(ByteDataAccessBase byteDataAccessBase) {
        return this.addChild(byteDataAccessBase, byteDataAccessBase.sizeHead);
    }

    public final boolean addChildEmpty(ByteDataAccessBase byteDataAccessBase) {
        if (this.addChild(byteDataAccessBase)) {
            byteDataAccessBase.clearHead();
            return true;
        }
        return false;
    }

    public final boolean addChildEmpty(ByteDataAccessBase byteDataAccessBase, int n) {
        if (this.addChild(byteDataAccessBase, n)) {
            byteDataAccessBase.clearData();
            return true;
        }
        return false;
    }

    public final void addChildAt(int n, ByteDataAccessBase byteDataAccessBase, int n2) throws IllegalArgumentException {
        int n3;
        assert (byteDataAccessBase.sizeHead >= 0);
        assert (n2 >= byteDataAccessBase.sizeHead);
        if (!this.checkData()) {
            return;
        }
        if (byteDataAccessBase.parent != null && byteDataAccessBase.parent.currChild == byteDataAccessBase) {
            byteDataAccessBase.parent.currChild = null;
        }
        byteDataAccessBase.data = this.data;
        byteDataAccessBase.ixBegin = n3 = this.ixBegin + n;
        byteDataAccessBase.ixBeginLocal = n;
        byteDataAccessBase.ixEnd = n3 + n2;
        byteDataAccessBase.ixNextChild = n3 + byteDataAccessBase.sizeHead;
        byteDataAccessBase.bBigEndian = this.bBigEndian;
        byteDataAccessBase.bExc = this.bExc;
        byteDataAccessBase.bExpand = this.bExpand;
        byteDataAccessBase.parent = this;
        this._expand(byteDataAccessBase.ixNextChild, byteDataAccessBase.ixEnd);
    }

    @Java4C.Retinline
    public final void addChildAt(int n, ByteDataAccessBase byteDataAccessBase) throws IllegalArgumentException {
        this.addChildAt(n, byteDataAccessBase, byteDataAccessBase.sizeHead);
    }

    public final boolean addChildInt(int n, int n2) throws IllegalArgumentException {
        assert (n > 0);
        int n3 = this.setIdxtoNextCurrentChild(n);
        if (n3 < 0) {
            return false;
        }
        this._setInt(n3 - this.ixBegin, n, n2);
        return true;
    }

    public final boolean addChildInteger(int n, long l) throws IllegalArgumentException {
        assert (n > 0);
        int n2 = this.setIdxtoNextCurrentChild(n);
        if (n2 < 0) {
            return false;
        }
        this._setLong(n2 - this.ixBegin, n, l);
        return true;
    }

    public final boolean addChildFloat(float f) throws IllegalArgumentException {
        int n = this.setIdxtoNextCurrentChild(4);
        if (n < 0) {
            return false;
        }
        this.setFloat(n - this.ixBegin, f);
        return true;
    }

    public final boolean addChildString(String string, String string2, boolean bl) throws IllegalArgumentException, UnsupportedEncodingException {
        int n = string.length();
        int n2 = this.setIdxtoNextCurrentChild(n);
        if (n2 < 0) {
            return false;
        }
        this._setString(n2 - this.ixBegin, n, string, string2, bl);
        return true;
    }

    public final boolean addChildString(CharSequence charSequence, String string) throws IllegalArgumentException, UnsupportedEncodingException {
        if (!this.checkData()) {
            return false;
        }
        int n = charSequence.length();
        int n2 = this.setIdxtoNextCurrentChild(n);
        if (n2 < 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            byte by;
            this.data[n2 + i] = by = (byte)charSequence.charAt(i);
        }
        return true;
    }

    @Java4C.Inline
    public final void addChildString(CharSequence charSequence) throws IllegalArgumentException {
        try {
            this.addChildString(charSequence, null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    @Java4C.Retinline
    public final short getChildInt16() {
        int n = this.setIdxtoNextCurrentChild(2);
        if (n < 0) {
            return 0;
        }
        return this.getInt16(n - this.ixBegin);
    }

    @Java4C.Retinline
    public final int getChildUint16() {
        int n = this.setIdxtoNextCurrentChild(2);
        if (n < 0) {
            return 0;
        }
        return this.getUint16(n - this.ixBegin);
    }

    @Java4C.Retinline
    public final short getChildUint8() {
        int n = this.setIdxtoNextCurrentChild(1);
        if (n < 0) {
            return 0;
        }
        return this.getUint8(n - this.ixBegin);
    }

    public final long getChildInteger(int n) throws IllegalArgumentException {
        int n2 = n < 0 ? -n : n;
        int n3 = this.setIdxtoNextCurrentChild(n2);
        if (n3 < 0) {
            return 0L;
        }
        long l = this._getLong(n3 - this.ixBegin, n);
        return l;
    }

    public final int getChildInt(int n) throws IllegalArgumentException {
        int n2 = n < 0 ? -n : n;
        int n3 = this.setIdxtoNextCurrentChild(n2);
        if (n3 < 0) {
            return 0;
        }
        int n4 = this._getInt(n3 - this.ixBegin, n);
        return n4;
    }

    public final float getChildFloat() throws IllegalArgumentException {
        int n = this.setIdxtoNextCurrentChild(4);
        if (n < 0) {
            return 0.0f;
        }
        int n2 = (int)this._getLong(n - this.ixBegin, 4);
        return Float.intBitsToFloat(n2);
    }

    public final double getChildDouble() throws IllegalArgumentException {
        int n = this.setIdxtoNextCurrentChild(8);
        if (n < 0) {
            return 0.0;
        }
        long l = this._getLong(n - this.ixBegin, 8);
        return Double.longBitsToDouble(l);
    }

    public final String getChildString(int n) {
        assert (n >= 0);
        int n2 = this.setIdxtoNextCurrentChild(n);
        if (n2 < 0) {
            return null;
        }
        return this.getString(n2 - this.ixBegin, n);
    }

    @Java4C.Inline
    public final void removeChild() throws IllegalArgumentException {
        if (this.currChild == null) {
            throw new IllegalStateException("programming error - a current child is not known yet.");
        }
        this.removeChild(this.currChild);
    }

    public final void removeChild(ByteDataAccessBase byteDataAccessBase) {
        if (byteDataAccessBase.parent != this) {
            throw new IllegalArgumentException("programming error - child is not parent of this.");
        }
        this.ixNextChild = byteDataAccessBase.ixBegin;
        if (this.bExpand) {
            this.ixEnd = this.ixNextChild;
        }
        if (this.currChild != null) {
            this.currChild.detach();
        }
    }

    @Java4C.Inline
    public final void removeChildren() {
        if (this.currChild != null) {
            this.currChild.detach();
            this.currChild = null;
        }
        this.ixNextChild = this.ixBegin + this.sizeHead;
        if (this.bExpand) {
            this.ixEnd = this.ixBegin + this.sizeHead;
        }
    }

    public final void detach() {
        if (this.parent != null && this.parent.currChild == this) {
            this.parent.currChild = null;
        }
        if (this.currChild != null) {
            this.currChild.detach();
            this.currChild = null;
        }
        this.data = null;
        this.parent = null;
        this.ixEnd = 0;
        this.ixBegin = 0;
        this.ixNextChild = 0;
        this.bExpand = false;
    }

    @Java4C.Retinline
    public final int getPositionInBuffer() {
        return this.ixBegin;
    }

    @Java4C.Retinline
    public final int getPositionNextChildInBuffer() {
        return this.ixNextChild;
    }

    public final void copyDataFrom(ByteDataAccessBase byteDataAccessBase) throws IllegalArgumentException {
        if (!this.checkData()) {
            return;
        }
        int n = byteDataAccessBase.getLength();
        if (n > this.ixEnd - this.ixBegin) {
            n = this.ixEnd - this.ixBegin;
        }
        if (this.data.length < this.ixBegin + n) {
            this.throwexc("copy, dst to small", n);
        }
        System.arraycopy(byteDataAccessBase.data, byteDataAccessBase.ixBegin, this.data, this.ixBegin, n);
    }

    public final void copyData(int[] nArray) {
        int n = this.ixEnd - this.ixBegin;
        if (n / 4 > nArray.length) {
            n = 4 * nArray.length;
        }
        int n2 = 0;
        for (int i = 0; i < n; i += 4) {
            nArray[n2++] = (int)this._getLong(i, 4);
        }
    }

    protected final String getString(int n, int n2) {
        if (!this.checkData()) {
            return null;
        }
        int n3 = n + this.ixBegin;
        int n4 = n3 + n2;
        assert (n4 <= this.ixEnd && n4 <= this.data.length);
        while (this.data[--n4] == 0 && n4 > n3) {
        }
        int n5 = n4 + 1 - n3;
        String string = new String(this.data, n3, n5, this.charset);
        return string;
    }

    protected final int setString(int n, int n2, String string) {
        byte[] byArray;
        if (!this.checkData()) {
            return 0;
        }
        if (string.length() > n2) {
            string = string.substring(0, n2);
        }
        try {
            byArray = string.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = null;
        }
        int n3 = byArray.length;
        if (n3 > n2) {
            n3 = n2;
        }
        System.arraycopy(byArray, 0, this.data, this.ixBegin + n, n3);
        return n3;
    }

    protected final void _setString(int n, int n2, String string, String string2, boolean bl) throws UnsupportedEncodingException {
        byte[] byArray;
        int n3;
        if (!this.checkData()) {
            return;
        }
        int n4 = n + this.ixBegin;
        int n5 = n4 + n2;
        if (string2 == null) {
            string2 = "ISO-8859-1";
        }
        if ((n3 = (byArray = string.getBytes(string2)).length) > n2) {
            n3 = n2;
        }
        for (int i = 0; i < n3; ++i) {
            int n6 = byArray[i];
            if (bl && n6 < 32) {
                n6 = 63;
            }
            this.data[n4++] = n6;
        }
        while (n4 < n5) {
            this.data[n4++] = 0;
        }
    }

    @Java4C.Retinline
    @Java4C.NoStackTrace
    protected final float getFloat(int n) {
        int n2 = this.getInt32(n);
        float f = Float.intBitsToFloat(n2);
        return f;
    }

    @Java4C.Retinline
    @Java4C.NoStackTrace
    protected final double getDouble(int n) {
        long l = this._getLong(n, 8);
        return Double.longBitsToDouble(l);
    }

    @Java4C.Retinline
    @Java4C.NoStackTrace
    protected final long getInt64(int n) {
        int n2;
        int n3;
        if (this.bBigEndian) {
            n3 = this.getInt32(n);
            n2 = this.getInt32(n + 4);
        } else {
            n3 = this.getInt32(n + 4);
            n2 = this.getInt32(n);
        }
        long l = n2 << 32;
        return l |= (long)(n3 & 0xFFFFFFFF);
    }

    @Java4C.NoStackTrace
    protected final int getInt32(int n) {
        if (!this.checkData()) {
            return 0;
        }
        int n2 = this.bBigEndian ? this.data[this.ixBegin + n] << 24 | this.data[this.ixBegin + n + 1] << 16 & 0xFF0000 | this.data[this.ixBegin + n + 2] << 8 & 0xFF00 | this.data[this.ixBegin + n + 3] & 0xFF : this.data[this.ixBegin + n + 3] << 24 | this.data[this.ixBegin + n + 2] << 16 & 0xFF0000 | this.data[this.ixBegin + n + 1] << 8 & 0xFF00 | this.data[this.ixBegin + n] & 0xFF;
        return n2;
    }

    @Java4C.Retinline
    @Java4C.NoStackTrace
    protected final int getUint32(int n) {
        return this.getInt32(n);
    }

    @Java4C.NoStackTrace
    protected final int getUint16(int n) {
        if (!this.checkData()) {
            return 0;
        }
        int n2 = this.bBigEndian ? this.data[this.ixBegin + n] << 8 & 0xFF00 | this.data[this.ixBegin + n + 1] & 0xFF : this.data[this.ixBegin + n + 1] << 8 & 0xFF00 | this.data[this.ixBegin + n] & 0xFF;
        return n2;
    }

    @Java4C.NoStackTrace
    protected final short getInt16(int n) {
        if (!this.checkData()) {
            return 0;
        }
        int n2 = this.bBigEndian ? this.data[this.ixBegin + n] << 8 & 0xFF00 | this.data[this.ixBegin + n + 1] & 0xFF : this.data[this.ixBegin + n + 1] << 8 & 0xFF00 | this.data[this.ixBegin + n] & 0xFF;
        return (short)n2;
    }

    @Java4C.NoStackTrace
    protected final char getChar(int n) {
        if (!this.checkData()) {
            return '\u0000';
        }
        char c = (char)this.data[this.ixBegin + n];
        return c;
    }

    @Java4C.NoStackTrace
    protected final byte getInt8(int n) {
        if (!this.checkData()) {
            return 0;
        }
        byte by = this.data[this.ixBegin + n];
        return by;
    }

    @Java4C.NoStackTrace
    protected final short getUint8(int n) {
        if (!this.checkData()) {
            return 0;
        }
        short s = this.data[this.ixBegin + n];
        if (s < 0) {
            s = (short)(s + 256);
        }
        return s;
    }

    protected final int getUint32(int n, int n2, int n3) {
        if (n2 >= n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("getUint32:" + n2);
        }
        return this.getUint32(n + 4 * n2);
    }

    protected final int getInt32(int n, int n2, int n3) {
        if (n2 >= n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("getInt32:" + n2);
        }
        return this.getInt32(n + 4 * n2);
    }

    protected final int getInt16(int n, int n2, int n3) {
        if (n2 >= n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("getInt16:" + n2);
        }
        return this.getInt16(n + 2 * n2);
    }

    protected final int getInt8(int n, int n2, int n3) {
        if (n2 >= n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("getInt8:" + n2);
        }
        return this.getInt8(n + n2);
    }

    protected final int getUint16(int n, int n2, int n3) {
        if (n2 >= n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("getUint16:" + n2);
        }
        return this.getUint16(n + 2 * n2);
    }

    protected final int getUint8(int n, int n2, int n3) {
        if (n2 >= n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("getUint8:" + n2);
        }
        return this.getInt8(n + n2);
    }

    protected final float getFloat(int n, int n2, int n3) {
        if (n2 >= n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("getFloat:" + n2);
        }
        return this.getFloat(n + 4 * n2);
    }

    @Java4C.Inline
    protected final void setFloat(int n, float f) {
        int n2 = Float.floatToRawIntBits(f);
        this._setLong(n, 4, n2);
    }

    @Java4C.Inline
    protected final void setDouble(int n, double d) {
        long l = Double.doubleToRawLongBits(d);
        this._setLong(n, 8, l);
    }

    protected final void setInt32(int n, int n2) {
        if (!this.checkData()) {
            return;
        }
        if (this.bBigEndian) {
            this.data[this.ixBegin + n] = (byte)(n2 >> 24 & 0xFF);
            this.data[this.ixBegin + n + 1] = (byte)(n2 >> 16 & 0xFF);
            this.data[this.ixBegin + n + 2] = (byte)(n2 >> 8 & 0xFF);
            this.data[this.ixBegin + n + 3] = (byte)(n2 & 0xFF);
        } else {
            this.data[this.ixBegin + n + 3] = (byte)(n2 >> 24 & 0xFF);
            this.data[this.ixBegin + n + 2] = (byte)(n2 >> 16 & 0xFF);
            this.data[this.ixBegin + n + 1] = (byte)(n2 >> 8 & 0xFF);
            this.data[this.ixBegin + n] = (byte)(n2 & 0xFF);
        }
    }

    @Java4C.Inline
    protected final void setInt8(int n, int n2) {
        if (!this.checkData()) {
            return;
        }
        this.data[this.ixBegin + n] = (byte)(n2 & 0xFF);
    }

    @Java4C.Inline
    protected final void setUint8(int n, int n2) {
        this.setInt8(n, n2);
    }

    protected final void setUint32(int n, long l) {
        if (!this.checkData()) {
            return;
        }
        if (this.bBigEndian) {
            this.data[this.ixBegin + n] = (byte)(l >> 24 & 0xFFL);
            this.data[this.ixBegin + n + 1] = (byte)(l >> 16 & 0xFFL);
            this.data[this.ixBegin + n + 2] = (byte)(l >> 8 & 0xFFL);
            this.data[this.ixBegin + n + 3] = (byte)(l & 0xFFL);
        } else {
            this.data[this.ixBegin + n + 3] = (byte)(l >> 24 & 0xFFL);
            this.data[this.ixBegin + n + 2] = (byte)(l >> 16 & 0xFFL);
            this.data[this.ixBegin + n + 1] = (byte)(l >> 8 & 0xFFL);
            this.data[this.ixBegin + n] = (byte)(l & 0xFFL);
        }
    }

    protected final void setInt16(int n, int n2) {
        if (!this.checkData()) {
            return;
        }
        if (this.bBigEndian) {
            this.data[this.ixBegin + n] = (byte)(n2 >> 8 & 0xFF);
            this.data[this.ixBegin + n + 1] = (byte)(n2 & 0xFF);
        } else {
            this.data[this.ixBegin + n + 1] = (byte)(n2 >> 8 & 0xFF);
            this.data[this.ixBegin + n] = (byte)(n2 & 0xFF);
        }
    }

    @Java4C.Inline
    protected final void setUint16(int n, int n2) {
        this.setInt16(n, n2);
    }

    private final void throwexc(String string, int n) {
        String string2 = string + n;
        throw new IndexOutOfBoundsException(string2);
    }

    @Java4C.Inline
    protected final void setUint32(int n, int n2, int n3, int n4) {
        if (n2 >= n3 || n2 < 0) {
            this.throwexc("setUint32:", n2);
        }
        this.setUint32(n + 4 * n2, n4);
    }

    @Java4C.Inline
    protected final void setInt32(int n, int n2, int n3, int n4) {
        if (n2 >= n3 || n2 < 0) {
            this.throwexc("setInt32:", n2);
        }
        this.setInt32(n + 4 * n2, n4);
    }

    @Java4C.Inline
    protected final void setInt16(int n, int n2, int n3, int n4) {
        if (n2 >= n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("getInt16:" + n2);
        }
        this.setInt16(n + 2 * n2, n4);
    }

    @Java4C.Inline
    protected final void setInt8(int n, int n2, int n3, int n4) {
        if (n2 >= n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("getInt16:" + n2);
        }
        this.setInt8(n + n2, n4);
    }

    @Java4C.Inline
    protected final void setUint16(int n, int n2, int n3, int n4) {
        if (n2 >= n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("getInt16:" + n2);
        }
        this.setUint16(n + 2 * n2, n4);
    }

    @Java4C.Inline
    protected final void setUint8(int n, int n2, int n3, int n4) {
        if (n2 >= n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("getInt16:" + n2);
        }
        this.setUint8(n + n2, n4);
    }

    @Java4C.Inline
    protected final void setFloat(int n, int n2, int n3, float f) {
        if (n2 >= n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("getInt16:" + n2);
        }
        this.setFloat(n + 4 * n2, f);
    }

    private final int setIdxtoNextCurrentChild(int n) {
        int n2;
        assert (n >= 0);
        assert (this.ixNextChild >= 0);
        if (!this.checkData()) {
            return 0;
        }
        int n3 = n2 = this.bExpand ? this.data.length : this.ixEnd;
        if (this.ixNextChild + n > n2) {
            return RetOrException.illegalArgument(this.bExc, -1, "child on limit of expand");
        }
        int n4 = this.ixNextChild;
        this.ixNextChild += n;
        this._expand(this.ixNextChild, this.ixEnd);
        return n4;
    }

    protected final int ixBegin() {
        return this.ixBegin;
    }

    protected final int ixNextChild() {
        return this.ixNextChild;
    }

    protected final int ixEnd() {
        return this.ixEnd;
    }

    boolean checkData() {
        if (this.data == null && this.parent != null) {
            this.data = this.parent.getData(99);
            this.bBigEndian = this.parent.bBigEndian;
        }
        if (this.data == null) {
            this.throwexc("--no data--", 0);
            return false;
        }
        return true;
    }

    @Override
    @Java4C.Exclude
    public void infoFormattedAppend(StringFormatter stringFormatter) {
        if (!this.checkData()) {
            stringFormatter.add("--no-data--");
            return;
        }
        int n = this.getLengthHead();
        if (n > 16) {
            n = 16;
        }
        if (n < 0) {
            n = 0;
        }
        if (this.ixBegin + n > this.data.length) {
            n = this.data.length - this.ixBegin;
        }
        this.infoAppendHead(stringFormatter, n);
        if (n < 24 && this.currChild == null) {
            int n2 = this.ixEnd - this.ixBegin - this.sizeHead;
            if (n2 > 24 - n) {
                n2 = 24 - n;
            }
            if (n2 > 0) {
                stringFormatter.add(": ").addHexLine(this.data, this.ixBegin + this.sizeHead, n2, this.bBigEndian ? (short)36 : 4);
            }
        } else if (this.currChild != null && stringFormatter.length() < 2200) {
            stringFormatter.add(", child ");
            this.currChild.infoFormattedAppend(stringFormatter);
        }
    }

    @Java4C.Exclude
    protected void infoAppendHead(StringFormatter stringFormatter, int n) {
        stringFormatter.addint(this.ixBegin, "333331").add("..").addint(this.ixBegin + this.sizeHead, "333331").add("..").addint(this.ixNextChild, "333331").add(this.bExpand ? (char)'+' : ':').addint(this.ixEnd, "333331").add(":");
        if (!this.checkData()) {
            stringFormatter.add("--no-data--");
            return;
        }
        stringFormatter.addHexLine(this.data(), this.ixBegin, n, this.bBigEndian ? (short)36 : 4);
    }

    @Java4C.Exclude
    public String toString() {
        if (this.data == null) {
            return "no data";
        }
        if (this.toStringformatter == null) {
            this.toStringformatter = new StringFormatter();
        } else {
            this.toStringformatter.reset();
        }
        this.infoFormattedAppend(this.toStringformatter);
        String string = this.toStringformatter.toString();
        return string;
    }
}

