package org.vishia.odt.readOdt;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;

import javax.imageio.ImageIO;

import org.vishia.msgDispatch.LogMessageStream;
import org.vishia.util.Arguments;
import org.vishia.util.Debugutil;
import org.vishia.util.ExcUtil;
import org.vishia.util.FileFunctions;
import org.vishia.util.StringFunctions;
import org.vishia.util.StringFunctions_C;
import org.vishia.xmlReader.XmlCfg;
import org.vishia.xmlSimple.XmlSequWriter;
import org.vishia.zip.ZipUtils;


public class WriteOdt extends TranslateOdtCommon {

  
  /**Version, history and license.
   * <ul>
   * <li>2024-12-13 bug: It has often missing a page break on a new included chapter.
   *     Hartmut fix: {@link #searchFirstHeaderLine()} now new, called only on the main file to detect the first line
   *     which starts with "=" in ZmL. This should not done if {@link #parseZmlWriteOdt()} is started again after an included file.
   *     The cause was, that this has skipped the '<::pageBreak.>' line in the main file because continued with the next chapter content.
   * <li>2024-12-13 cleanup: #XXXfinitParagr() and #XXXnParagr removed, really without functionality. 
   * <li>2024-05-29 Hartmut creation. Necessity to handle Libre Office writer content.  
   * </ul>
   *
   * 
   * <b>Copyright/Copyleft</b>:
   * For this source the LGPL Lesser General Public License,
   * published by the Free Software Foundation is valid.
   * It means:
   * <ol>
   * <li> You can use this source without any restriction for any desired purpose.
   * <li> You can redistribute copies of this source to everybody.
   * <li> Every user of this source, also the user of redistribute copies
   *    with or without payment, must accept this license for further using.
   * <li> But the LPGL ist not appropriate for a whole software product,
   *    if this source is only a part of them. It means, the user
   *    must publish this part of source,
   *    but don't need to publish the whole source of the own product.
   * <li> You can study and modify (improve) this source
   *    for own using or for redistribution, but you have to license the
   *    modified sources likewise under this LGPL Lesser General Public License.
   *    You mustn't delete this Copyright/Copyleft inscription in this source file.
   * </ol>
   * If you are intent to use this sources without publishing its usage, you can get
   * a second license subscribing a special contract with the author. 
   * 
   * @author Hartmut Schorrig = hartmut.schorrig@vishia.de
   * 
   * 
   */
  //@SuppressWarnings("hiding")
  public final static String version = "2025-10-10";

  
  public static class DirPrepareJavadoc {
    
    /**Directory as relative path starting from the document directory where the javadoc is found. 
     * it should refer the basic directory where the package tree is started from. */
    public File dirBase;
    
    /**Directory as relative path to {@link #dirBase} as selection which files should be used
     * from a possible greater package tree.
     * It is a directory from a definitive package. This package and all sub packages are used.
     */
    public String sLocal;
    
    /**Start of the hlink for www access. */
    String swww;
  }

  
  public static class CmdArgs extends TranslateOdtCommon.CommonArgs {
    
    File dirDbg;
    
    File fOdtStyles;
    
 //   String sName, sExtIn;
    
    /**True then read adoc, false specific markup. */
    boolean bReadAdoc;
    
    /**A configuartion file to read. */
    File fCfg;
    
    
    //String sExtLabel;
    
    
    File fDirOdt, fOutOdt;
    
    /**An XML file to write. */
    File fOutXml;
    
    
    /**If a www link starts with this, replace also the absolute link if an anchor is replaced.
     * 
     */
    String swwwRoot = "XXX";  // initialvalue not found in sRef
    
 
    /**If true then call {@link GenXmlCfgJavaData} with the used existing XmlCfg. */
    File dirCreateCfgJavaData;
    
    /**If true then write with the only one read #fIn a new analyzed XmlCfg to this file. */
    File fWriteXmlStruct;
    
    /**from '-javadoc:', contains paths which directories should be regard in JavaDoc
     * 
     */
    List<DirPrepareJavadoc> listDirJavadoc;
    
    /**from '-reportJavadocClasses:path/to/file' to write out the list of supported classes for JavaDoc detection.
     * 
     */
    File fRptClassesJavadoc;
    
    float pixelPerPageWidth = 1024;
    
    /**If true then it tries to rename an image with that name which is given in title. 
     * This is helpful for example if an exporter writes "Img12.png" with current number and the images should have a proper name.
     */
    boolean bRenameImageFiles = false;
    
    /**Default false, set to true with -extRefs. Decides to write a list of all extern references to related docu. 
     * This is currently not recommended. This information are also available in the *.Labels.txt files,
     * see {@link TranslateOdtCommon.CommonArgs#dirLabel} and argument -labels:...*/
    boolean bWriteExternRefs = false;
    
    /**This array describes the commands with its help and stores the result to CmdArgs. More is not necessary. 
     * @since 2023-09-23 moved from {@link org.vishia.fbcl.readSmlk.GenSmlk2FBcl}, there was using the older concept with {@link org.vishia.mainCmd.MainCmd.Arguments}
     *   now proper to {@link Arguments}. This list is possible, alternatively to direct instantiating in ctor.
     * */
    Argument[] argList1 = {
          new Argument("-cfg", ":path/file.cfg a plain text file with config entries", new SetArgument(){ 
          @Override public boolean setArgument(String val) throws FileNotFoundException { 
            CmdArgs.this.fCfg = new File(val).getAbsoluteFile();  
            return CmdArgs.this.fCfg.exists();
          }})
        , new Argument("-i", ":path/file.ZmL markup file for input", new SetArgument(){ 
          @Override public boolean setArgument(String val) throws FileNotFoundException { 
            int posWildcard = val.indexOf('*');
            int posName = val.lastIndexOf('\\')+1;
            int posName2 = val.lastIndexOf('/')+1;
            if(posName2 > posName) { posName = posName2; }
            int posDot = val.lastIndexOf('.');
            String sIn;
            if( posWildcard <0 
             && (sIn = FileFunctions.getCanonicalPath(new File(val))).startsWith(CmdArgs.this.sCurrDir)) {
              posDot = sIn.lastIndexOf('.');
              CmdArgs.this.sNameDoc = sIn.substring(CmdArgs.this.sCurrDir.length()+1, posDot);
              CmdArgs.this.sExtZmL = sIn.substring(posDot);
              CmdArgs.this.dirZml = CmdArgs.this.dirIn = new File(CmdArgs.this.sCurrDir);
            } else {
              CmdArgs.this.sNameDoc = posWildcard == posName ? CmdArgs.this.sNameDoc : val.substring(posName, posDot);
              CmdArgs.this.dirZml = CmdArgs.this.dirIn = new File(posName == 0 ? "." : val.substring(0, posName)).getAbsoluteFile();
              CmdArgs.this.sExtZmL = val.substring(posDot);
            }
            CmdArgs.this.fIn = new File(CmdArgs.this.dirIn, CmdArgs.this.sNameDoc + CmdArgs.this.sExtZmL).getAbsoluteFile();  
            return CmdArgs.this.fIn.exists();
          }})
        , new Argument("-a", ":<path/file.adoc>  pure asciidoc file for input", new SetArgument(){ 
          @Override public boolean setArgument(String val) throws FileNotFoundException { 
            CmdArgs.this.fIn = new File(val).getAbsoluteFile(); 
            CmdArgs.this.dirIn = CmdArgs.this.fIn.getParentFile();
            CmdArgs.this.bReadAdoc = true;
            return CmdArgs.this.fIn.exists();
          }})
        , new Argument("-oxml", ":path/to/contentXY.xml used content.xml temporary" +
                     "\n      default is <dirDbg>/content.xml or beside the odg file", new SetArgument(){ 
          @Override public boolean setArgument(String val) throws FileNotFoundException { 
            DirName dirExt = getDirNameReplaceSrcCmpn(val);
            File dirXml = dirExt.dir;
            FileFunctions.mkDir(dirXml);
            CmdArgs.this.fOutXml = new File(dirXml, dirExt.name).getAbsoluteFile();
            return true;
          }})
        , new Argument("-odtStyles", ":Styles.odt used with styles instead given odt", new SetArgument(){ 
          @Override public boolean setArgument(String val) throws FileNotFoundException { 
            CmdArgs.this.fOdtStyles = new File(val).getAbsoluteFile();  
            return CmdArgs.this.fOdtStyles.exists();
          }})
        , new Argument("-odt", ":<path/ODT>  file.odt for odt output", new SetArgument(){ 
          @Override public boolean setArgument(String val) throws FileNotFoundException { 
            DirName dirName = getDirNameReplaceSrcCmpn(val);
            int posDot = dirName.name.indexOf('.');
            int posWildcards = val.indexOf('*');
            if(posWildcards <0) {                //---------- only if val does not contain '/*' the it determines the sNameDoc,
              CmdArgs.this.sNameDoc = dirName.name.substring(0, posDot);  // else sNameDoc is used because of the wildcard.
            }
            CmdArgs.this.sExtOut = dirName.name.substring(posDot);
            CmdArgs.this.fDirOdt = dirName.dir.getAbsoluteFile();
            CmdArgs.this.fOutOdt = new File(CmdArgs.this.fDirOdt, dirName.name).getAbsoluteFile();  
            return CmdArgs.this.fDirOdt.exists(); 
          }})
        , new Argument("-www", ":<wwwRoot>>  root for www access to replace operation link anchors", new SetArgument(){ 
          @Override public boolean setArgument(String val) throws FileNotFoundException { 
            CmdArgs.this.swwwRoot = val;  
            return true;
          }})
        , new Argument("-genJavaData", ":<path>  Generates new versions of Java data in pkg path from -analyzeXmlStruct or from given XmlCfg", new SetArgument(){ 
          @Override public boolean setArgument(String val) throws IOException { 
            File dirJava = new File(val).getAbsoluteFile();
            if(!dirJava.exists() || !dirJava.isDirectory()) {
              return CmdArgs.this.errMsg("-genJavaData:%s ERROR not found as directory", dirJava );
            } else {
              CmdArgs.this.dirCreateCfgJavaData = dirJava;
              return true;
          }}})
        , new Argument("-extRefs", " write external references", new SetArgument() {
          @Override public boolean setArgument(String val) throws FileNotFoundException { 
            CmdArgs.this.bWriteExternRefs = true;  
            return true;
          }})
        , new Argument("-analyzeXmlStruct", ":D:/path/to/xmlCfg.txt optional, first analyze the input xml data and generate a new XmlCfg text file", new SetArgument() {
          @Override public boolean setArgument(String val) throws FileNotFoundException { 
            CmdArgs.this.fWriteXmlStruct = new File(val) ;  
            File dirWriteXmlStruct = CmdArgs.this.fWriteXmlStruct.getParentFile();
            FileFunctions.mkDir(dirWriteXmlStruct);
            return dirWriteXmlStruct.exists();
          }})
        , new Argument("-javadoc", ":../path/to/Javadoc:org/vishia/odg:@https://wwwlink analyze this directory tree, more as one possible", new SetArgument() {
          @Override public boolean setArgument(String val) throws FileNotFoundException { 
            int posWWW = val.indexOf(":@");
            String sWWW;
            if(posWWW >0) { sWWW = val.substring(posWWW+2); }
            else { posWWW = val.length(); sWWW = null; }
            int posSep = val.indexOf(':', 2);
            File dirJavadoc;
            String subdirJavadoc;
            if(posSep >=0 && posSep < posWWW) { 
              dirJavadoc = new File(val.substring(0, posSep));
              if(!dirJavadoc.exists()) return false;
              subdirJavadoc = val.substring(posSep+1, posWWW);
              if(!dirJavadoc.exists()) return false;
            } else { 
              dirJavadoc = new File(val.substring(0, posWWW));
              if(!dirJavadoc.exists()) return false;
              subdirJavadoc = null;
            }
            DirPrepareJavadoc dirs = new DirPrepareJavadoc();
            dirs.dirBase = dirJavadoc; dirs.sLocal = subdirJavadoc; dirs.swww = sWWW;
            if(CmdArgs.this.listDirJavadoc == null) { CmdArgs.this.listDirJavadoc = new LinkedList<>(); }
            CmdArgs.this.listDirJavadoc.add(dirs);  
            return true;
          }})
        , new Argument("-reportJavadocClasses", ":path/to/reportJavaDocClasses.txt", new SetArgument() {
          @Override public boolean setArgument(String val) throws FileNotFoundException { 
            DirName dirName = getDirNameReplaceSrcCmpn(val);
            CmdArgs.this.fRptClassesJavadoc = new File(dirName.dir, dirName.name) ;  
            FileFunctions.mkDir(dirName.dir);
            return dirName.dir.exists();
          }})
      };
    
    
    CmdArgs(){
      super();
      super.aboutInfo = "...Reader content from odg for FunctionBlockGrafic";
      super.helpInfo="obligate args: -o:... ...input";
      for(Argument arg: this.argListCommon) { addArg(arg); }
      for(Argument arg: this.argList1) { addArg(arg); }
    }
  
    @Override public boolean testConsistence ( Appendable msg ) {
      boolean bOk = true;
      if(this.fOutXml == null) {
        File dirXml = this.dirDbg !=null ? this.dirDbg : this.fIn.getParentFile();
        this.fOutXml = new File(dirXml, "content.xml");
      }
      try {
        if(!CmdArgs.this.fOutOdt.exists() && !CmdArgs.this.fOdtStyles.exists()) {
          msg.append("either -odtStyles:path/file.odt or -odt:file.odt should be existing");
          return false;
        }
        if(false) { msg.append("-dirFBcl:path/to/outdir is obligate\n"); bOk = false; }
      } catch(IOException exc) {
        System.err.println("Fatal Error, msg as Appendable has IOException " + exc.getMessage());
      }
      if(!bOk) {
        super.showHelp(msg);
      }
      return bOk;
    }
  }

  
  
  
  private static class Cfg {
    
    boolean useItalicBold;
    
    String sImgCaptionStart = "Figure ";
    String sImgCaption2 = ": ";
    int eImgKindNr = 1;
  }
  
  
  
  
  
  
  
  /**main for this class, with given prepared arguments 
   * Does not catch unexpected exceptions and does not System.exit(...), use it to execute in a Java environment. 
   * @param args prepared cmd line arguments
   * @return 0 if all is ok
   * @throws IOException 
   * @throws Exception if unexpected.
   */
  public static int amain ( CmdArgs args) throws IOException {
    WriteOdt thiz = new WriteOdt(args);
    thiz.execute();
    thiz.log.close();
    return 0;
  }
  
  
  
  
  
  /**main gets the arguments as String, 
   * but does not catch unexpected exceptions and does not System.exit(...), use it to execute in a Java environment. 
   * @param sArgs
   * @return 0 if all is ok
   * @throws IOException 
   * @throws Exception if unexpected.
   */
  public static int smain ( String[] sArgs, Appendable logHelp, Appendable logError) throws IOException {
    CmdArgs args = new CmdArgs();
    if(sArgs.length ==0) {
      args.showHelp(logHelp);
      return(1);                // no arguments, help is shown.
    }
    args.setCurrDir();
    if(  ! args.parseArgs(sArgs, logError)
      || ! args.testConsistence(logError)
      ) { 
      return(2);                    // argument error
    }
    //LogMessageStream log = new LogMessageStream(System.out);
    int exitCode = amain(args);
    System.out.printf("\n*** finished %s @%s", args.fOutOdt.getName(), args.fOutOdt.getParent()  );
    System.out.printf(" EXIT-code=%d", exitCode);
    System.out.println();
    return exitCode;
  }
  
  
  
  /**main for WriteOdt, invoked from cmd line. 
   * Catch and report an unexpected exceptions via console error output, returns an exit code 
   * @param sArgs
   * @return 0 if all is ok
   */
  public static void main ( String[] sArgs) { //Test include ZmL: <::main.>
    try {
      int exitCode = smain(sArgs, System.out, System.err);  //<:@exit.>
      System.exit(exitCode);
    } catch (Exception e) {                 //    <:@exc.>
      System.err.println("Unexpected: " + e.getMessage()); //<:-main.>
      e.printStackTrace(System.err);
      System.exit(255);                     //<:+main.>
    }
  } //<:.main.>


  final CmdArgs args;
  
  
  final Cfg cfg = new Cfg();
  
  final XmlCfg xmlCfgOdt = new XmlCfg(true);
  
  BufferedReader rZmL;
  
  Stack<BufferedReader> stack_rAdoc = new Stack<>();
  
  //private static int nBookmarkDefault = 100;
  
  /**Last read line from aDoc. */
  String sLineNext;
  
  
  /**If not null then a <code>[.style] was read.
   * Valid for the next paragraph.
   */
  String sStyleParagr;
  
  
  /**true only immediately after set &lt;text:p ...>*/
  boolean bParagrFirstline;
  
  /**>=1 then the deepness of nesting section nodes. */
  int nSection;
  
  /**>=1 then the deepness of nesting list nodes. */
  int nList;
  
  /**true then a &lt;text:list-item... is opened in the moment. */
  boolean bInsideListItem;
  
  /**True then a "'''" was seen before. It is in html an horizontal line. 
   * It means the next paragraph makes a page break or column break: */
  boolean bPageBreakBefore, bColumnBreakBefore;
  
  boolean bInsideColumn2;
  
  
  boolean bPage2Start = true;
  
  int nrSectionName =0;
  
  int nrTableName =0;
  
  int nrFrameImgName =-1;
  
  /**Set {@link #nrChapter} from ZmL should only done one time,
   * then this flag should be set to false.
   */
  boolean bSetNrChapter = true;
  
  int[] nrChapter = new int[6]; 

  Map<String, String> idxLabelIntern = new TreeMap<String, String>();
  
  /**Index of all book marks of related docu suite (adequate option -labels:*.Labels.text)
   * filled from this files.
   * See {@link #readLabelFile(File, String)}.
   * This index is used for {@link #writeChapterRef(String)} and {@link #writeInternalRefPage(String)}
   * to write the external link. */
  Map<String, ReadOdt.LabelRef> idxLabelExternRef = new TreeMap<String, ReadOdt.LabelRef>();
  
  /**Same content as {@link #idxLabelExternRef} but sorted to document and chapter number
   * to write out {@link #writeExternReferences()}. */
  Map<String, ReadOdt.LabelRef> idxChnrExternRef = new TreeMap<String, ReadOdt.LabelRef>();
  
  
  /**If set (not null) then the next lines till "----" should be written as &lt;text:p... with this style.
   * It is for code snippets.
   */
  String sCodeStyle;
  
  boolean bInsideCode;
  
  
  /**It is set if a ref to bookmark was created.
   * Use the same bookmark to create a page ref.
   * 
   */
  String sRefBookmark;
  
  /**Stores a [#label] for the next header or paragraph. */
  String sXXXLabel;
  
  /**If !=null then this is the label after '__PART_...' to include another file.
   * It is also used as bookmark for the first chapter title of the included file.
   */
  String sInclude;

  final StringBuilder sbo = new StringBuilder(16384);
  
  private Writer wrRep;
  
  /**Opened writer to write the label file.*/
  //private Writer wrLabel;
  
  /**The last anchor which is replaced for operation arguments. */
  private String lastAnchorReplaced = "";
  
  final XmlSequWriter xmlWr = new XmlSequWriter();
  
  
  /**
   * Note: close of LogMessageStream as in {@link #amain(CmdArgs)} where this instance is constructed.
   * This closes also a given {@link TranslateOdtCommon.CommonArgs#fLog} because of 
   * call {@link LogMessageStream#LogMessageStream(java.io.OutputStream, java.io.OutputStream, Appendable, Appendable, boolean, Charset) }
   * with trut for argument closeOnClose.
   * @param args
   */
  @SuppressWarnings("resource") protected WriteOdt(CmdArgs args) {
    super(new LogMessageStream(args.fLog, null, System.out, System.err, true, Charset.forName("UTF-8")));
    this.args = args;
 
  }

  
  private void wrRep(CharSequence line) throws IOException {
    if(this.wrRep !=null) {
      this.wrRep.append(line).append("\n");
    }
  }
  

  
  
  public void execute() throws IOException {
    showArguments(); 
    if(this.args.dirLabel !=null) {
      readOwnLabels();
      List<File> listFiles = new LinkedList<>();
      FileFunctions.addFileToList(this.args.dirLabel, this.args.sNameLabel, listFiles);
      for(File fLabel: listFiles) {
        String name = fLabel.getName();
        name = name.substring(0, name.indexOf('.'));
        if(!name.equals(this.args.sNameDoc)) {  // do not read the own label file
          readLabelFile(fLabel, name);
        }
      }
      //this.wrLabel = new OutputStreamWriter(new FileOutputStream(new File(this.args.dirLabel, this.args.sName)), "UTF-8");
    }
    
    if(this.args.listDirJavadoc !=null) {
      super.javadocLabel.analyzeAllJavadocFiles(this.args.listDirJavadoc, this.args.fDirOdt);
      if(this.args.fRptClassesJavadoc !=null) {
        super.javadocLabel.reportClassesJavadoc(this.args.fRptClassesJavadoc);
      }
    }
    
    
    //------------------------------------------------------- read cfg, same as for parse odt, for namespace declaration:
    this.xmlCfgOdt.readFromJar(WriteOdt.class, "xmlCfgOdtNonSemantic.txt", this.log);
    //
    if(this.args.fCfg !=null) {    //======================== read some config data from file.
      InputStream fCfg = new FileInputStream(this.args.fCfg);
      Arguments.readConfig(this.cfg, fCfg, null, this.log);
      fCfg.close();
    }
    //
    this.rZmL = new BufferedReader(new InputStreamReader(new FileInputStream(this.args.fIn), "UTF-8"));
    
    this.wrRep = this.args.fReport == null ? null :new OutputStreamWriter(new FileOutputStream(this.args.fReport), "UTF-8");
   
    //TODO-2 may read first styles.xml from -outOdt to check it.    
    //
    this.xmlWr.open(this.args.fOutXml, "UTF-8", this.sbo);  // foutXml is either in -dbgdir or manual given or it is content.xml
    try {
      this.xmlWr.writeElement("office:document-content");
      for(Map.Entry<String, String > eNs  : this.xmlCfgOdt.iterNamespace()) {
        String ns = eNs.getKey();
        String alias = eNs.getValue();
        String key = "xmlns:" + alias;
        this.xmlWr.writeAttribute(key, ns);
      }
      this.xmlWr.writeElement("office:scripts");
      this.xmlWr.writeElementEnd();
      this.xmlWr.writeElement("office:font-face-decls");
      this.xmlWr.writeElementEnd();
      this.xmlWr.writeElement("office:automatic-styles");
      writeStyleSections();
      this.xmlWr.writeElementEnd();
      this.xmlWr.writeElement("office:body");
      this.xmlWr.writeElement("office:text");
      this.xmlWr.writeElement("text:sequence-decls");
      this.xmlWr.writeElementEnd();
    } catch(Exception exc) {
      this.log.writeError("Unexpected, will close xml and odt: ", exc);
      this.xmlWr.writeText(exc.getMessage(), true);
    }
    searchFirstHeaderLine();
    do {            //======================================= loop for possible opened included files
      try {  //======>>>>
        parseZmlWriteOdt();             //<<<<=============== main loop
      } catch(Exception exc) {
        this.log.writeError("Unexpected, will close xml and odt: ", exc);
        this.xmlWr.writeText(exc.getMessage(), true);
      }
      this.rZmL.close();
      if(this.stack_rAdoc.isEmpty()) {
        this.rZmL = null;
      } else {
        this.rZmL = this.stack_rAdoc.pop();
        this.sInclude = "";    // empty sInclude to create __PART_END_ on next chapter title if __PART_ is not found.
      }
    } while(this.rZmL !=null);
    if(this.xmlWr.elementCurrTag().equals("text:section")) { 
      this.xmlWr.writeElementEnd("text:section");
    }
    if(this.args.bWriteExternRefs) {
      writeExternReferences();
    }
    this.xmlWr.writeElementEnd("office:text");
    this.xmlWr.writeElementEnd("office:body");
    this.xmlWr.writeElementEnd("office:document-content");
    this.xmlWr.close();
    if(this.wrRep !=null) {
      this.wrRep.append("\n");
      this.wrRep.close();
      this.wrRep = null;
    }
//    if(this.wrLabel !=null) {
//      this.wrLabel.append("\n");
//      this.wrLabel.close();
//      this.wrLabel = null;
//    }
    //======================================================= if fOutOdt is given, then writes back
    writeBackupFile(this.args.fOutOdt, this.args.dirOutBack, this.args.sExtOut, this.args);
    if(this.args.fOutOdt !=null) {                         //  the new created fOutXml to the odt zip archiv.: 
      if(this.args.fOdtStyles !=null) {
        System.out.printf("\nUsed '%s' as template with styles.", this.args.fOdtStyles);
        FileFunctions.copyFile(this.args.fOdtStyles, this.args.fOutOdt);
      }
      ZipUtils.replaceFile(this.args.fOutOdt.getAbsolutePath(), this.args.fOutXml.getAbsolutePath(), "content.xml");
    }
  }
  
  
  
  private void showArguments () {
    System.out.printf("\n*** org.vishia.idt.readOdt.WriteOdt version %s", version);
    System.out.printf("\n  input=%s", this.args.fIn );
    System.out.printf("\n  output=%s", this.args.fOutOdt );
    System.out.printf("\n  -odtStyles=%s", this.args.fOdtStyles );
    System.out.printf("\n  SrcCmpn=%s", this.args.sDirSrcCmpn );
    System.out.printf("\n  currDir=%s", this.args.sCurrDir );
    System.out.printf("\n  Backup-dir %s", this.args.dirOutBack);
    System.out.printf("\n  -report=%s", this.args.fReport);
    System.out.printf("\n  -dirDbg=%s", this.args.dirDbg);
    System.out.printf("\n  Labels read from=%s/*.%s", this.args.dirLabel, this.args.sNameLabel);
    System.out.printf("\n  www-root=%s", this.args.swwwRoot);
    System.out.printf("\n  -wrelhtml=%s", this.args.sRefBesideInWWWHtml);
    System.out.printf("\n  -wrelpdf=%s", this.args.sRefBesideInWWWPdf);
    System.out.printf("\n  -alinkhtml=%s", this.args.sRefBesideHtml);
    System.out.printf("\n  -alinkpdf=%s", this.args.sRefBesidePdf);
    System.out.printf("\n  sExtRefBesideHtml=%s", this.args.sExtRefBesideHtml);
    System.out.printf("\n  sExtRefBesidePdf=%s", this.args.sExtRefBesidePdf);
    
    if(this.args.dirCreateCfgJavaData !=null) {
      System.out.printf("\n  -genJavaData=%s", this.args.dirCreateCfgJavaData);
    }
    
  }

  
  /**Switches to the file to include due to Label '__PART_Name' or __PART_RD_Name'
   * @param sFileArg the line after the label '__PART_' or '__PART_RD_', start of file name
   * @return false if the file to include is not found.
   *   Then should continue with the given chaper header.
   * @throws IOException
   */
  private boolean switchToInclude(String sFileArg) throws IOException {
    boolean bOk = false;
    BufferedReader rIncl = null;
    int posSep = sFileArg.indexOf(':');
    int posEnd = sFileArg.indexOf('#', posSep +1);  // from 0 if posSep == -1
    if(posEnd <0 ) { posEnd = sFileArg.length(); }
    final String sNameIncl, sLabelIncl;
    if(posSep >0) {
      sNameIncl = sFileArg.substring(0, posSep);
      sLabelIncl = sFileArg.substring(posSep+1, posEnd);
    } else {
      sNameIncl = sFileArg.substring(0, posEnd);
      sLabelIncl = null;
//      int posDot = sNameIncl.lastIndexOf('.');
//      sLabelIncl = sNameIncl.substring(0, posDot);         // sLabelIncl without the extension.
    }
    
    File fInclude = new File(this.args.dirZml, sNameIncl + this.args.sExtZmL);
    if(!fInclude.exists()) {
      this.log.writeError("ERROR include file not found: %s @%s", sNameIncl, this.args.dirIn.getPath());
    } else {
      try {
        rIncl = new BufferedReader(new InputStreamReader(new FileInputStream(fInclude), "UTF-8"));
      } catch (Exception exc) {
        this.log.writeError("ERROR include file Exception: ", exc);
      }
    }
    if(rIncl !=null) {
      this.log.writef("\nRead included: %s", sNameIncl);
      this.stack_rAdoc.push(this.rZmL);                   // save the BufferedReader for using later again.
      this.rZmL = rIncl;                                  // now it continues in this opened file.
      String line;
      while( (line = this.rZmL.readLine()) !=null) {      // skip over all lines before includeStart
        if(line.startsWith("==") && (sLabelIncl ==null || line.contains("#" + sLabelIncl))) {     // this is the title line 
          this.sLineNext = line;                           // repeat read the same line for the chapter header also for the included file
          break;                                           // skip over all lines till inclusively '<:#__PART_LABEL...'
        }
      }
      bOk = true;
    } else {                           //-------------------- on error in include file continue with the given
      assert(true);                                        // TODO write a message in the document.
    }
    return bOk;
  }
  
  
  private void readOwnLabels () throws IOException {
    this.rZmL = new BufferedReader(new InputStreamReader(new FileInputStream(this.args.fIn), "UTF-8"));
    String line;
    while( (line = this.rZmL.readLine()) !=null) {
      if(line.startsWith("==")) {
        int posLabel = line.indexOf("<:#");
        if(posLabel >0) {
          int posLabelEnd;
          do {
            posLabel +=3;  // after '<:#'
            posLabelEnd = line.indexOf('>', posLabel);
            if(line.charAt(posLabelEnd-1) == '.') { posLabelEnd -=1; }
            String sLabel = line.substring(posLabel, posLabelEnd);
            int posLabelEnd1;
            posLabel = 0;      // now related to sLabel
            String sLabel1;
            while( (posLabelEnd1 = sLabel.indexOf('#', posLabel)) >0) { // label1#label2
              sLabel1 = sLabel.substring(posLabel, posLabelEnd1);
              this.idxLabelIntern.put(sLabel1, sLabel1);
              posLabel = posLabelEnd1 +1;
            }
            sLabel1 = sLabel.substring(posLabel);
            this.idxLabelIntern.put(sLabel1, sLabel1);        //.:#label.><:#label3.>
          } while( posLabelEnd > 0 && (posLabel = line.indexOf("<:#", posLabelEnd)) >0);
        } 
      }
    }
    this.rZmL.close();
    this.rZmL = null;
  }
  

  
  private void readLabelFile(File fLabel, String nameRefFile) {
    try {
      BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(fLabel), "UTF-8"));
      String line;
      while((line = r.readLine()) !=null) {
        if(line.startsWith("#")) {
          int posSpace = line.indexOf(' ');
          String sLabel = line.substring(1, posSpace);
          if(this.idxLabelIntern.get(sLabel) == null) {    // not an intern label
            int posPage = line.lastIndexOf('@');
            if(!sLabel.startsWith("?") && posPage >=0) {
              String sTitle = line.substring(posSpace+1, posPage).trim();
              String sPage = line.substring(posPage+1).trim();
              ReadOdt.LabelRef labelRef = this.idxLabelExternRef.get(sLabel);
              if( labelRef !=null) {
                if(labelRef.idxLabel.get(sLabel) !=null) {
                  this.log.writef("\n#%s already contained in bookmarks: >>%s<<, new: >>%s<<", sLabel, this.idxLabelExternRef.get(sLabel), sTitle);
                } else {
                  labelRef.idxLabel.put(sLabel, sLabel);
                }
              } else {
                List<String> listLabel = new LinkedList<>();
                listLabel.add(sLabel);
                labelRef = new ReadOdt.LabelRef(nameRefFile, null, listLabel, sTitle, sPage);
                this.idxLabelExternRef.put(sLabel, labelRef);
                this.idxChnrExternRef.put(nameRefFile + sTitle, labelRef); // assume sTitle has a number on start, then sorted by this nr
              }
            }
        } } // only if not intern label
      }
      r.close();
    } catch (IOException exc) {
      System.err.print("\nERROR reading " + fLabel.getAbsolutePath());
    }
    
  }
  
  
  
  private void writeStyleSections () throws IOException {
    //======================================================= SectTOC as section style 
    this.xmlWr.writeElement("style:style");
    this.xmlWr.writeAttribute("style:name", "SectTOC");    // Note: section styles are not part of style sheets
    this.xmlWr.writeAttribute("style:family", "section");  // Can only be provide as direct style in office:automatic-styles
    this.xmlWr.writeElement("style:section-properties");
    this.xmlWr.writeAttribute("style:editable", "false");
    this.xmlWr.writeElement("style:columns");
    this.xmlWr.writeAttribute("fo:column-count", "1");
    this.xmlWr.writeAttribute("fo:column-gap", "0mm");
    this.xmlWr.writeElementEnd("style:columns");  //style:columns
    this.xmlWr.writeElementEnd("style:section-properties");  //style:section-properties
    this.xmlWr.writeElementEnd("style:style");  //style:style
    //======================================================= SectTOCc as section style 
    this.xmlWr.writeElement("style:style");
    this.xmlWr.writeAttribute("style:name", "Contents_20_Heading_pg");    // Note: section styles are not part of style sheets
    this.xmlWr.writeAttribute("style:family", "paragraph");  // Can only be provide as direct style in office:automatic-styles
    this.xmlWr.writeElement("style:paragraph-properties");
    this.xmlWr.writeAttribute("fo:break-before", "page");
    this.xmlWr.writeElementEnd("style:paragraph-properties");  //style:section-properties
    this.xmlWr.writeElementEnd("style:style");  //style:style
    //======================================================= Column2 as section style 
    this.xmlWr.writeElement("style:style");
    this.xmlWr.writeAttribute("style:name", "Column22");    // Note: section styles are not part of style sheets
    this.xmlWr.writeAttribute("style:family", "section");  // Can only be provide as direct style in office:automatic-styles
    this.xmlWr.writeElement("style:section-properties");
    this.xmlWr.writeAttribute("text:dont-balance-text-columns", "false");
    this.xmlWr.writeAttribute("style:editable", "false");
    this.xmlWr.writeElement("style:columns");
    this.xmlWr.writeAttribute("fo:column-count", "2");
    this.xmlWr.writeAttribute("fo:column-gap", "7mm");
    this.xmlWr.writeElement("style:column");
    this.xmlWr.writeAttribute("style:rel-width", "32767*");
    this.xmlWr.writeAttribute("fo:start-indent", "0mm");
    this.xmlWr.writeAttribute("fo:end-indent", "3.5mm");
    this.xmlWr.writeElementEnd();
    this.xmlWr.writeElement("style:column");
    this.xmlWr.writeAttribute("style:rel-width", "32768*");
    this.xmlWr.writeAttribute("fo:start-indent", "3.5mm");
    this.xmlWr.writeAttribute("fo:end-indent", "0mm");
    this.xmlWr.writeElementEnd();
    this.xmlWr.writeElementEnd();  //style:columns
    this.xmlWr.writeElementEnd();  //style:section-properties
    this.xmlWr.writeElementEnd("style:style");  //style:style
    //======================================================= Column2 as section style 
    this.xmlWr.writeElement("style:style");
    this.xmlWr.writeAttribute("style:name", "Column2");    // Note: section styles are not part of style sheets
    this.xmlWr.writeAttribute("style:family", "section");  // Can only be provide as direct style in office:automatic-styles
    this.xmlWr.writeElement("style:section-properties");
    this.xmlWr.writeAttribute("text:dont-balance-text-columns", "true");
    this.xmlWr.writeAttribute("style:editable", "false");
    this.xmlWr.writeElement("style:columns");
    this.xmlWr.writeAttribute("fo:column-count", "2");
    this.xmlWr.writeAttribute("fo:column-gap", "7mm");
    this.xmlWr.writeElement("style:column"); 
    this.xmlWr.writeAttribute("style:rel-width", "32767*");
    this.xmlWr.writeAttribute("fo:start-indent", "0mm");
    this.xmlWr.writeAttribute("fo:end-indent", "3.5mm");
    this.xmlWr.writeElementEnd();
    this.xmlWr.writeElement("style:column");
    this.xmlWr.writeAttribute("style:rel-width", "32768*");
    this.xmlWr.writeAttribute("fo:start-indent", "3.5mm");
    this.xmlWr.writeAttribute("fo:end-indent", "0mm");
    this.xmlWr.writeElementEnd();
    this.xmlWr.writeElementEnd();  //style:columns
    this.xmlWr.writeElementEnd();  //style:section-properties
    this.xmlWr.writeElementEnd("style:style");  //style:style
    //======================================================= Title_pg as paragraph style with page break before and start with page1 
    this.xmlWr.writeElement("style:style");
    this.xmlWr.writeAttribute("style:name", "Title_pg1");       // Note: Should refer the parent style Headind_20_2 
    this.xmlWr.writeAttribute("style:family", "paragraph");  // 
    this.xmlWr.writeAttribute("style:parent-style-name", "Title");  // Can only be provide as direct style in office:automatic-styles
    this.xmlWr.writeAttribute("style:master-page-name", "First_20_Page");  // use standard LOffc "First Page"
    this.xmlWr.writeElement("style:paragraph-properties");
    this.xmlWr.writeAttribute("fo:break-before", "page");
    this.xmlWr.writeAttribute("style:page-number", "1");
    this.xmlWr.writeElementEnd("style:paragraph-properties");
    this.xmlWr.writeElementEnd("style:style");  //style:style
    //======================================================= H1pg2 as heading style with page break before, set Page style and page2 
    this.xmlWr.writeElement("style:style");
    this.xmlWr.writeAttribute("style:name", "H1pg2");       // Note: Should refer the parent style Headind_20_2 
    this.xmlWr.writeAttribute("style:family", "paragraph");  // 
    this.xmlWr.writeAttribute("style:master-page-name", "Standard");  //Default Page Style  
    this.xmlWr.writeAttribute("style:parent-style-name", "Heading_20_1");  // Can only be provide as direct style in office:automatic-styles
    this.xmlWr.writeElement("style:paragraph-properties");
    this.xmlWr.writeAttribute("style:page-number", "2");
    this.xmlWr.writeAttribute("fo:break-before", "page");
    this.xmlWr.writeElementEnd("style:paragraph-properties");
    this.xmlWr.writeElementEnd("style:style");  //style:style
    //======================================================= H2pg2 as heading style with page break before, set Page style and page2 
    this.xmlWr.writeElement("style:style");
    this.xmlWr.writeAttribute("style:name", "H2pg2");       // Note: Should refer the parent style Headind_20_2 
    this.xmlWr.writeAttribute("style:family", "paragraph");  // 
    this.xmlWr.writeAttribute("style:master-page-name", "Standard");  //Default Page Style  
    this.xmlWr.writeAttribute("style:parent-style-name", "Heading_20_2");  // Can only be provide as direct style in office:automatic-styles
    this.xmlWr.writeElement("style:paragraph-properties");
    this.xmlWr.writeAttribute("style:page-number", "2");
    this.xmlWr.writeAttribute("fo:break-before", "page");
    this.xmlWr.writeElementEnd("style:paragraph-properties");
    this.xmlWr.writeElementEnd("style:style");  //style:style
    //======================================================= H2pg as heading style with page break before 
    this.xmlWr.writeElement("style:style");
    this.xmlWr.writeAttribute("style:name", "H2pg");       // Note: Should refer the parent style Headind_20_2 
    this.xmlWr.writeAttribute("style:family", "paragraph");  // 
    this.xmlWr.writeAttribute("style:parent-style-name", "Heading_20_2");  // Can only be provide as direct style in office:automatic-styles
    this.xmlWr.writeElement("style:paragraph-properties");
    this.xmlWr.writeAttribute("fo:break-before", "page");
    this.xmlWr.writeElementEnd("style:paragraph-properties");
    this.xmlWr.writeElementEnd("style:style");  //style:style
    //======================================================= H3pg as heading style with page break before 
    this.xmlWr.writeElement("style:style");
    this.xmlWr.writeAttribute("style:name", "H3pg");       // Note: Should refer the parent style Headind_20_2 
    this.xmlWr.writeAttribute("style:family", "paragraph");  // 
    this.xmlWr.writeAttribute("style:parent-style-name", "Heading_20_3");  // Can only be provide as direct style in office:automatic-styles
    this.xmlWr.writeElement("style:paragraph-properties");
    this.xmlWr.writeAttribute("fo:break-before", "page");
    this.xmlWr.writeElementEnd("style:paragraph-properties");
    this.xmlWr.writeElementEnd("style:style");  //style:style
    //======================================================= H4pg as heading style with page break before 
    this.xmlWr.writeElement("style:style");
    this.xmlWr.writeAttribute("style:name", "H4pg");       // Note: Should refer the parent style Headind_20_2 
    this.xmlWr.writeAttribute("style:family", "paragraph");  // 
    this.xmlWr.writeAttribute("style:parent-style-name", "Heading_20_4");  // Can only be provide as direct style in office:automatic-styles
    this.xmlWr.writeElement("style:paragraph-properties");
    this.xmlWr.writeAttribute("fo:break-before", "page");
    this.xmlWr.writeElementEnd("style:paragraph-properties");
    this.xmlWr.writeElementEnd("style:style");  //style:style
    //======================================================= H5pg as heading style with page break before 
    this.xmlWr.writeElement("style:style");
    this.xmlWr.writeAttribute("style:name", "H5pg");       // Note: Should refer the parent style Headind_20_2 
    this.xmlWr.writeAttribute("style:family", "paragraph");  // 
    this.xmlWr.writeAttribute("style:parent-style-name", "Heading_20_5");  // Can only be provide as direct style in office:automatic-styles
    this.xmlWr.writeElement("style:paragraph-properties");
    this.xmlWr.writeAttribute("fo:break-before", "page");
    this.xmlWr.writeElementEnd("style:paragraph-properties");
    this.xmlWr.writeElementEnd("style:style");  //style:style
    //======================================================= H3col as heading style with page break before 
    this.xmlWr.writeElement("style:style");
    this.xmlWr.writeAttribute("style:name", "H3col");       // Note: Should refer the parent style Headind_20_2 
    this.xmlWr.writeAttribute("style:family", "paragraph");  // 
    this.xmlWr.writeAttribute("style:parent-style-name", "Heading_20_3");  // Can only be provide as direct style in office:automatic-styles
    this.xmlWr.writeElement("style:paragraph-properties");
    this.xmlWr.writeAttribute("fo:break-before", "column");
    this.xmlWr.writeElementEnd("style:paragraph-properties");
    this.xmlWr.writeElementEnd("style:style");  //style:style
    //======================================================= H4col as heading style with page break before 
    this.xmlWr.writeElement("style:style");
    this.xmlWr.writeAttribute("style:name", "H4col");       // Note: Should refer the parent style Headind_20_2 
    this.xmlWr.writeAttribute("style:family", "paragraph");  // 
    this.xmlWr.writeAttribute("style:parent-style-name", "Heading_20_4");  // Can only be provide as direct style in office:automatic-styles
    this.xmlWr.writeElement("style:paragraph-properties");
    this.xmlWr.writeAttribute("fo:break-before", "column");
    this.xmlWr.writeElementEnd("style:paragraph-properties");
    this.xmlWr.writeElementEnd("style:style");  //style:style
    //======================================================= H5col as heading style with page break before 
    this.xmlWr.writeElement("style:style");
    this.xmlWr.writeAttribute("style:name", "H5col");       // Note: Should refer the parent style Headind_20_2 
    this.xmlWr.writeAttribute("style:family", "paragraph");  // 
    this.xmlWr.writeAttribute("style:parent-style-name", "Heading_20_5");  // Can only be provide as direct style in office:automatic-styles
    this.xmlWr.writeElement("style:paragraph-properties");
    this.xmlWr.writeAttribute("fo:break-before", "column");
    this.xmlWr.writeElementEnd("style:paragraph-properties");
    this.xmlWr.writeElementEnd("style:style");  //style:style

    //======================================================= text_List1 as heading style with page break before 
    this.xmlWr.writeElement("style:style");
    this.xmlWr.writeAttribute("style:name", "text_List1");       // Note: Should refer the parent style Headind_20_2 
    this.xmlWr.writeAttribute("style:family", "paragraph");  // 
    this.xmlWr.writeAttribute("style:parent-style-name", "Text");  // Can only be provide as direct style in office:automatic-styles
    this.xmlWr.writeAttribute("style:list-style-name", "List_20_1");  // Can only be provide as direct style in office:automatic-styles
    this.xmlWr.writeElementEnd("style:style");  //style:style
    //======================================================= text_List2 as heading style with page break before 
    this.xmlWr.writeElement("style:style");
    this.xmlWr.writeAttribute("style:name", "text_List2");       // Note: Should refer the parent style Headind_20_2 
    this.xmlWr.writeAttribute("style:family", "paragraph");  // 
    this.xmlWr.writeAttribute("style:parent-style-name", "Text");  // Can only be provide as direct style in office:automatic-styles
    this.xmlWr.writeAttribute("style:list-style-name", "List_20_2");  // Can only be provide as direct style in office:automatic-styles
    this.xmlWr.writeElementEnd("style:style");  //style:style
    //======================================================= text_List3 as heading style with page break before 
    this.xmlWr.writeElement("style:style");
    this.xmlWr.writeAttribute("style:name", "text_List3");       // Note: Should refer the parent style Headind_20_2 
    this.xmlWr.writeAttribute("style:family", "paragraph");  // 
    this.xmlWr.writeAttribute("style:parent-style-name", "Text");  // Can only be provide as direct style in office:automatic-styles
    this.xmlWr.writeAttribute("style:list-style-name", "List_20_3");  // Can only be provide as direct style in office:automatic-styles
    this.xmlWr.writeElementEnd("style:style");  //style:style
    //======================================================= text_List4 as heading style with page break before 
    this.xmlWr.writeElement("style:style");
    this.xmlWr.writeAttribute("style:name", "text_List4");       // Note: Should refer the parent style Headind_20_2 
    this.xmlWr.writeAttribute("style:family", "paragraph");  // 
    this.xmlWr.writeAttribute("style:parent-style-name", "Text");  // Can only be provide as direct style in office:automatic-styles
    this.xmlWr.writeAttribute("style:list-style-name", "List_20_4");  // Can only be provide as direct style in office:automatic-styles
    this.xmlWr.writeElementEnd("style:style");  //style:style
    //======================================================= italic text style 
    this.xmlWr.writeElement("style:style");
    this.xmlWr.writeAttribute("style:name", "modif_i");
    this.xmlWr.writeAttribute("style:family", "text");
    this.xmlWr.writeElement("style:text-properties");
    this.xmlWr.writeAttribute("fo:font-style", "italic");  
    this.xmlWr.writeAttribute("fo:font-style-asian", "italic");  
    this.xmlWr.writeAttribute("fo:font-style-complex", "italic");  
    this.xmlWr.writeElementEnd("style:text-properties");
    this.xmlWr.writeElementEnd("style:style");
    //======================================================= bold text style 
    this.xmlWr.writeElement("style:style");
    this.xmlWr.writeAttribute("style:name", "modif_b");
    this.xmlWr.writeAttribute("style:family", "text");
    this.xmlWr.writeElement("style:text-properties");
    this.xmlWr.writeAttribute("fo:font-weight", "bold");  
    this.xmlWr.writeAttribute("fo:font-weight-asian", "bold");  
    this.xmlWr.writeAttribute("fo:font-weight-complex", "bold");  
    this.xmlWr.writeElementEnd("style:text-properties");
    this.xmlWr.writeElementEnd("style:style");
    //======================================================= italic bold text style 
    this.xmlWr.writeElement("style:style");
    this.xmlWr.writeAttribute("style:name", "modif_ib");
    this.xmlWr.writeAttribute("style:family", "text");
    this.xmlWr.writeElement("style:text-properties");
    this.xmlWr.writeAttribute("fo:font-style", "italic");  
    this.xmlWr.writeAttribute("fo:font-style-asian", "italic");  
    this.xmlWr.writeAttribute("fo:font-style-complex", "italic");  
    this.xmlWr.writeAttribute("fo:font-weight", "bold");  
    this.xmlWr.writeAttribute("fo:font-weight-asian", "bold");  
    this.xmlWr.writeAttribute("fo:font-weight-complex", "bold");  
    this.xmlWr.writeElementEnd("style:text-properties");
    this.xmlWr.writeElementEnd("style:style");
    //======================================================= table style 
    this.xmlWr.writeElement("style:style");
    this.xmlWr.writeAttribute("style:name", "Table1");
    this.xmlWr.writeAttribute("style:family", "table");
    this.xmlWr.writeElement("style:table-properties");
    this.xmlWr.writeAttribute("style:width", "8.9cm");  
    this.xmlWr.writeAttribute("table:align", "margins");  
    this.xmlWr.writeElementEnd("style:table-properties");
    this.xmlWr.writeElementEnd("style:style");
    //
    this.xmlWr.writeElement("style:style");
    this.xmlWr.writeAttribute("style:name", "Table1.A");
    this.xmlWr.writeAttribute("style:family", "table-column");
    this.xmlWr.writeElement("style:table-column-properties");
    this.xmlWr.writeAttribute("style:column-width", "1.78cm");  
    this.xmlWr.writeAttribute("style:rel-column-width", "13107*");  
    this.xmlWr.writeElementEnd("style:table-column-properties");
    this.xmlWr.writeElementEnd("style:style");
    //
    this.xmlWr.writeElement("style:style");
    this.xmlWr.writeAttribute("style:name", "Table1.A1");
    this.xmlWr.writeAttribute("style:family", "table-cell");
    this.xmlWr.writeElement("style:table-cell-properties");
    this.xmlWr.writeAttribute("fo:padding", "0cm");  
    this.xmlWr.writeAttribute("fo:border", "none");  
    this.xmlWr.writeAttribute("style:writing-mode", "page");  
    this.xmlWr.writeElementEnd("style:table-cell-properties");
    this.xmlWr.writeElementEnd("style:style");
    //
    //------------------------------------------------------- Graphic
    this.xmlWr.writeElement("style:style");
    this.xmlWr.writeAttribute("style:name", "ImgFromTop");
    this.xmlWr.writeAttribute("style:family", "graphic");
    this.xmlWr.writeAttribute("style:parent", "Img");
    this.xmlWr.writeElement("style:graphic-properties");
    this.xmlWr.writeAttribute("style:vertical-pos", "from-top");  
    this.xmlWr.writeAttribute("style:vertical-rel", "paragraph");  
    this.xmlWr.writeAttribute("style:horizontal-pos", "center");  
    this.xmlWr.writeAttribute("style:horizontal-rel", "paragraph-content");  
    this.xmlWr.writeElementEnd("style:graphic-properties");
    this.xmlWr.writeElementEnd("style:style");
  }
  

  
  /**This is called one time on start of the main file.
   * It searches the first line starting with "=", which is the title or the first header line.
   * @throws IOException
   */
  public void searchFirstHeaderLine () throws IOException {
    String line;
    int lineCt = 15;
    do {  //================================================= first search the first line of '=title'
      line = this.rZmL.readLine();                         // the lines before may contain comment or unix-script lines.
      if(line !=null && line.startsWith("=") || line.startsWith("<::ZmL.>")) {
        this.sLineNext = line;                             // start line found.
        break;
      }
    } while(--lineCt >=0);
  }

  
  
  public void parseZmlWriteOdt () throws IOException {
    String line;
    do {  //===============================================__ loop over all
      if(this.sLineNext !=null) {
        line = this.sLineNext; this.sLineNext = null;
      } else {
        line = this.rZmL.readLine();
      }
      if(line !=null) {
        int pos = line.length();
        while(--pos >=0 && line.charAt(pos) == ' ' );
        pos +=1;
        if(pos < line.length()) {
          line = line.substring(0, pos);   //------------------ remove trailing spaces generally
        }
        if(this.args.bReadAdoc) {
          parseAdocLine(line);
        } else {
          parseAdocM(line);
        }
      }
    } while(line !=null); 
    Debugutil.stop();            // It comes here also after finish an included file.
  }
  
  
  
  private static String[] specificLineStarts = { "*", "//", "<:td.>", "<:tr.>", "<.table>"};
  

  
  
  
  /**Parse a new line for paragraph etc, not the continued lines from a paragraph.
   * @param line found line
   * @return
   * @throws IOException
   */
  protected String parseAdocLine (String line) throws IOException {
    String error = null;
    if(line.startsWith("It should be presumed that"))
      Debugutil.stop();
    if(line.length() >=1) {
      char c1 = line.charAt(0); 
      if(c1 !='*' && this.nList >0) {
        finitList(0);
      }
      switch(c1) {
      case ':': break;       // ctrl for Adoc generation
      case '[': return parseWriteParagrStyleLabel(line);
      case '=': return writeHeaderLine(line);
      case '/': return checkParseCommentLine(line);
      //case '\'': return checkParsePageColumnBreak(line);
      case '*': return parseList(line);
      case ' ': return parseWriteCodeBlock(line);
      default: 
        if(line.startsWith("image::")) return parseImage(line, true);
        else if(line.startsWith("----")) return parseWriteCodeBlock(line);
        else return parseWriteParagr(line, null);
      }
    }
    return error;
  }
  
  
  /**Parse a new line for paragraph etc, not the continued lines from a paragraph.
   * @param line found line
   * @return
   * @throws IOException
   */
  private String parseAdocM (String line) throws IOException {
    String error = null;
    if(line.startsWith("It should be presumed that"))
      Debugutil.stop();
    if(line.length() >=1) {
      char c1 = line.charAt(0); 
      if(c1 !='*' && this.nList >0) {
        finitList(0);
      }
      switch(c1) {
      case '=': return writeHeaderLine(line);
      case '*': return parseList(line);
      default: 
        if(line.startsWith("##")) return null; //comment internal
        //if(line.startsWith("<:image:")) return parseImage(line);
        if(line.startsWith("<:Code:")) return parseWriteCodeBlock(line);
        if(line.startsWith("<::TOC-")) return writeTableOfContents(line.substring(7));
        if(line.startsWith("<::pageBreak.>")) { 
          this.bPageBreakBefore = true; return null; 
        }
        if(line.startsWith("<::columnBreak.>")) { 
          this.bColumnBreakBefore = true; return null; 
        }
        if(line.startsWith("<:p:")) return parseWriteParagrStyleLabel(line);
        if(line.startsWith("<::table")) return parseWriteTable(line);
        if(line.startsWith("<::Section:")) return parseWriteSection(line);
        if(line.startsWith("<.Section>")) return writeSectionEnd(line);
        if(line.startsWith("<:@include:")) return null; //switchToInclude(line.substring(11));
        if(line.startsWith("<::ZmL.>")) {
          return writeHeaderLine(line);
        }
        else return parseWriteParagr(line, null);
      }
    }
    return error;
  }
  
  
  private boolean isEmptyLine (String line, int fromPos) {
    if(line == null) return true;
    int nLine = line.length();
    for(int ix = fromPos; ix < nLine; ++ix) {
      if(" \t".indexOf(line.charAt(ix)) <0) return false;
    }
    return true;
  }
  
  
  private String writeHeaderLine(String lineArg) throws IOException {
    StringBuilder allLines = readAllTextLinesOfParagraph(lineArg);
    String line = allLines.toString();
    finitList(0);
    String error = null;
    if(line.contains("One letter for the base type"))
      Debugutil.stop();
    if(this.nSection >0)
      Debugutil.stop();
    int zLine = line.length();
    int pos = 0;
    int nHeader;
    if(line.startsWith("<::ZmL.>")) {
      nHeader = 0;
      pos = 8;
    } else {
      while(++pos < zLine && line.charAt(pos) == '=');       // skips over all ===, pos is first pos after ===
      nHeader = pos -1;                                  // level of the header 0 = only one "="
    }
    while(pos < zLine && line.charAt(pos)==' ') { pos +=1; } // skip leading spaces between == Title or <::Zml.>  Title
    pos = readHeaderNr(line, zLine, pos, nHeader);          // reads the 1.2.3 from ZmL line to nrHeader
    //while(++pos < zLine && line.charAt(pos) == ' ');       // skips over all spaces 

//    if(this.bPageBreakBefore)
//      Debugutil.stop();
    final String sTitle;
    int posLabel = line.indexOf("<:#");
    List<String> labels = new LinkedList<>();
    if(this.stack_rAdoc.size()>0 && this.sInclude !=null && this.sInclude.length() > 0) {
      int posSep = this.sInclude.indexOf('#');   //---------- Second call in the included file:
      if(posSep >0) {
        labels.add("__PART_" + this.sInclude.substring(0, posSep));
      } else {
        labels.add("__PART_" + this.sInclude);   //-------- mark the chapter title with the bookmark '__PART_includeFile' to write from odt to ZmL as include.
      }
      this.sInclude = null;
    }
    if(posLabel >0) {
      sTitle = line.substring(pos, posLabel).trim();
      int posLabelEnd;
      do {
        posLabel +=3;  // after '<:#'
        posLabelEnd = line.indexOf('>', posLabel);
        if(line.charAt(posLabelEnd-1) == '.') { posLabelEnd -=1; }
        String sLabel = line.substring(posLabel, posLabelEnd);
        if(sLabel.startsWith("__PART_END") && this.stack_rAdoc.size()==0) {
          this.sInclude = null;                            // That is the end marker for output files.
        } else if(sLabel.startsWith("__PART_RD_") && this.stack_rAdoc.size()==0) {
          this.sInclude = sLabel.substring(10);            // for read only includes
        } else if(sLabel.startsWith("__PART_") && this.stack_rAdoc.size()==0) {
          this.sInclude = sLabel.substring(7);             // 
        }
        int posLabelEnd1;
        posLabel = 0;      // now related to sLabel
        while( (posLabelEnd1 = sLabel.indexOf('#', posLabel)) >0) { // label1#label2
          labels.add(sLabel.substring(posLabel, posLabelEnd1));
          posLabel = posLabelEnd1 +1;
        }
        labels.add(sLabel.substring(posLabel));        //.:#label.><:#label3.>
      } while( posLabelEnd > 0 && (posLabel = line.indexOf("<:#", posLabelEnd)) >0);
    } else {
      sTitle = line.substring(pos).trim();
    }
    final boolean bInclude;
    if(this.sInclude !=null && this.sInclude.length()>0) {
      bInclude = switchToInclude(this.sInclude);
    }
    else if(sTitle.length()==0) {
      this.log.writef("\nWARNING empty %s found, ignored", line);
      bInclude = false;
    } 
    else {
      if(this.sInclude !=null ) {
        assert(this.sInclude.length()==0);
        labels.add("__PART_END_");                  //-------- mark the chapter title with the bookmark '__PART_END_' to close writing from odt to ZmL as include.
      }
      bInclude = false;
    }
    if(!bInclude) {
      this.sInclude = null;
      if(nHeader >0 ) { //&& this.nrChapter[nHeader-1] !=0) { 
        this.nrChapter[nHeader-1] +=1;
      }
      for(int ix = nHeader; ix < this.nrChapter.length; ++ix) {
        this.nrChapter[ix] = 0;
      }
      String style;
      if(nHeader ==0) {    //==============================__ write the start of the document till title __====================
        this.xmlWr.writeElement("text:p");
        this.xmlWr.writeAttribute("text:style-name", "text");
        this.xmlWr.writeText("(left empty side before page 1)", false);
        this.xmlWr.writeElementEnd();
        this.xmlWr.writeElement("text:p");
        this.xmlWr.writeAttribute("text:style-name", "text");
        this.xmlWr.writeText("Note: Most of Browser pdf presentations does not support the book mode.", false);
        this.xmlWr.writeElementEnd();
        this.xmlWr.writeElement("text:p");
        this.xmlWr.writeAttribute("text:style-name", "text");
        this.xmlWr.writeText("Remove this page if you want to have a PDF file in book mode.", false);
        this.xmlWr.writeElementEnd();
        style = "Title";
      } else if(this.bPage2Start) {
        style = "H" + nHeader + "pg2";
        this.bPage2Start = false;
      } else {
        style = this.bPageBreakBefore && nHeader >1       // Heading_20_1 is always with page break. Not an extra 
              ? "H" + nHeader + "pg" 
              : this.bColumnBreakBefore && nHeader >1       // Heading_20_1 is always with page break. Not an extra 
              ? "H" + nHeader + "col" 
              : "Heading_20_" + nHeader;
      }
      this.bPageBreakBefore = this.bColumnBreakBefore = false; // flag is only for this paragraph
      this.xmlWr.writeElement("text:h");
      this.xmlWr.writeAttribute("text:style-name", style);
      this.xmlWr.writeAttribute("text:outline-level", "" + nHeader);
      this.bParagrFirstline = true;
      ListIterator<String> iterLabels = labels.listIterator();
      while(iterLabels.hasNext()) { iterLabels.next(); }  // got after last element
      while(iterLabels.hasPrevious()) {
        String sLabel = iterLabels.previous();
        this.xmlWr.writeElementInline("text:bookmark-start");
        if(!sLabel.startsWith("__PART_")) {
          sLabel = "__Link_" + sLabel;
        } else {
          Debugutil.stop();
        }
        this.xmlWr.writeAttribute("text:name", sLabel);
        this.xmlWr.writeElementEnd("text:bookmark-start");
      }
      String sNumber = "";
      for(int ix = 0; ix < nHeader; ++ix ) {
        sNumber += this.nrChapter[ix];
        if(ix < nHeader-1) {
          sNumber += '.';                   // . between nr '1.2.3 '
        } else {
          sNumber += ' ';                   // space after nr
        }
      }
      error = parseWriteText(sNumber + sTitle, false);
      //parseParagrNextLine(line.substring(pos +1));
      for(String sLabel: labels) {  
      //for(String sLabel: labels) {  
        this.xmlWr.writeElementInline("text:bookmark-end");
        if(!sLabel.startsWith("__PART_")) {
          sLabel = "__Link_" + sLabel;
        } else {
          Debugutil.stop();
        }
        this.xmlWr.writeAttribute("text:name", sLabel);
        this.xmlWr.writeElementEnd("text:bookmark-end");
      }
      this.sXXXLabel = null;
      this.xmlWr.writeElementEndInline("text:h");
      
      wrRep(line);
    }
    return error;
  }
  
  
  
  /**Reads the number before the chapter title (header).
   * If {@link #bSetNrChapter} is true, then the read number is written to {@link #nrChapter},
   * but with -1 subtracted because it will be incremented. 
   * This is the numbering of the first chapter in this odt.
   * After detection the first chapter in first ZmL, {@link #bSetNrChapter} is set to false. 
   * Then, all other chapters are incremented and set back to 0 if a parent chapter is offered.
   * @param line the header line with '=== 2.3.4 Title' from ZmL
   * @param zLine line length
   * @param pos0 Position after '===' as start
   * @param nHeader The number of '===', nHeader ==0 for one '=', for the title.
   * @return the position of begin of header title after numbers, '.' and spaces
   */
  private int readHeaderNr (String line, int zLine, int pos0, int nHeader) {
    int pos = pos0;
    char cc;
    int nrLevel = 0;
    boolean isNr = false;
    for(int ix = nHeader; ix < this.nrChapter.length; ++ix) {
      if(this.nrChapter[ix] == 0) { this.nrChapter[ix] = 0; }                              // initial number of chapter.
    }
    while( pos < zLine && ( (isNr = (cc = line.charAt(pos)) >='0' && cc <= '9') // set first cc, then set isNr
                         || cc == ' ' || cc == '.'         // not isNr, then the others
                          )) {
      int[] nrDigits = new int[1];
      if(isNr && this.bSetNrChapter ) {     //--------------- read the chapter number as start, only for first chapter of the odt.
        this.nrChapter[nrLevel] = StringFunctions_C.parseIntRadix(line, pos, 99, 10, nrDigits);
        nrLevel +=1;
        pos += nrDigits[0];
      } else {                              // increment over " ." and also over 0..9 if !this.bSetChapter
        pos +=1; 
      }
    }
    if(this.bSetNrChapter && nrLevel >0) { this.nrChapter[nrLevel-1] -=1; }   // decrement the last chapter nr because it will be increment later.
    //
    if(nHeader >0 && this.nrChapter[nHeader-1] ==0) {      //
      this.nrChapter[nHeader-1] = 0;
    }
    if(nHeader >0) {                        //------------- first header read, which is not the title
      this.bSetNrChapter = false;
    }
    return pos;
  }
  
  
  
  private String checkParseCommentLine(String line) throws IOException {
    int nLine = line.length();
    //if(nLine <2 || !(line.charAt(1)=='/')) return parseParagrNextLine(line);         // a line not with "//" is not a comment
    if(line.startsWith("//Section:")) {
      parseWriteSection(line);
    }
    else if(line.startsWith("//End-Section")) {
      writeSectionEnd(line);
    }
    else if(line.startsWith("//TOC-")) {
      writeTableOfContents(line.substring(6));
    }
    String error = null;
    return error;
    
  }
  
  
  
  private String parseWriteSection(String line) throws IOException {
    int posSection = line.indexOf(':', 3);  // 3: do not find "<:Sec..."
    int pos2 = line.indexOf('>');
    if(pos2 <0) { pos2 = line.length(); }
    String sSect = line.substring(posSection+1, pos2).trim();
    if(sSect.startsWith("Column")) {
      this.bInsideColumn2 = true;
    }
    finitList(0);
    this.xmlWr.writeElement("text:section");
    this.xmlWr.writeAttribute("text:style-name", sSect);
    this.xmlWr.writeAttribute("text:name", "Section" + (++this.nrSectionName));
    this.nSection +=1;
    return null;
  }

  
  
  private String writeSectionEnd(String line) throws IOException {
    if(this.nSection >0) {
      finitSection(this.nSection-1);
      this.bInsideColumn2 = false;
    }
    return null;
  }

  
  

  private String parseWriteParagrStyleLabel(String line) throws IOException {
    String error = null;
    //int nLine = line.length();
    char cEnd = this.args.bReadAdoc ? ']' : '>';
    int pos9 = line.indexOf(cEnd);
    if(pos9 <0) return "ERROR in Asciidoc, missing "+ cEnd + " in line: " + line;
    if(line.charAt(pos9-1) == '.') { pos9 -=1; }
    String sLabel = null;
    if(!this.args.bReadAdoc) {     //------------------------- MUv: <:p: style : #label >
      int posLabel = line.indexOf(":", 4);
      if(posLabel >=0 && posLabel < pos9) {
        sLabel = line.substring(posLabel +1, pos9).trim();
        pos9 = posLabel;
      }
      this.sStyleParagr = line.substring(4, pos9).trim();
    } else if(line.startsWith("[.")) { //-------------------- Adoc: [.style] it is a special paragraph format
        String style = line.substring(2,pos9);
      this.sStyleParagr = style;
    }
    else if(line.startsWith("[Source,")) {     //------------ Adoc: [source, style] a source block
      this.sCodeStyle = line.substring(8, pos9).trim();
    }
    else if(line.startsWith("[#")) {          //------------- Adoch: [#Label]
      sLabel = line.substring(2, pos9).trim();
    }
    int posNext = line.charAt(pos9) == '.' ? pos9+2 : pos9+1;
    String sLineRest = line.substring(posNext).trim();
    
    return parseWriteParagr(sLineRest, sLabel);
  }
  
  
  /**
   * @param line This is only the start (first) line. All other lines will be read here
   *   calling {@link #readAllTextLinesOfParagraph(String)}
   * @param sLabel null or a label (bookmark) for this paragraph TODO not implemented yet.
   * @return
   * @throws IOException
   */
  private String parseWriteParagr(String line, String sLabel) throws IOException {
    if(line.startsWith("LibreOffice and Asciidoc are two very different approaches"))
      Debugutil.stop();
    String error = null;
    finitList(0);
    this.xmlWr.writeElement("text:p");
    if(this.bColumnBreakBefore)
      Debugutil.stop();
    if(this.sStyleParagr ==null) {
      this.sStyleParagr = this.bPageBreakBefore ? "TextPg" : this.bColumnBreakBefore ? "TextCol" : "Text";
    }
    this.bPageBreakBefore = this.bColumnBreakBefore = false; // flag is only for this paragraph
    this.bParagrFirstline = false; // because it writes immediately the first line.
    StringBuilder allLines = readAllTextLinesOfParagraph(line);
    error = parseWriteText(allLines, false);

    this.xmlWr.writeElementEndInline("text:p");
    return error;
  }
  
  
  
  
  
  private String parseList (String line) throws IOException {
    String error = null;
    //finitParagr();
    if(this.bInsideListItem) {
      this.xmlWr.writeElementEnd("text:list-item");
      this.bInsideListItem = false;
    }
    int nLine = line.length();
    int pos = 0;
    while(++pos < nLine && line.charAt(pos) == '*');       // skips over all ===, pos is first pos after ===
    int nList = pos;
    while(this.nList < nList) {
      this.nList +=1;
      this.xmlWr.writeElement("text:list");
      this.xmlWr.writeAttribute("text:style-name", "List_20_" + this.nList);
      this.xmlWr.writeElement("text:list-item");
      this.bInsideListItem = true;
    }
    if(!this.bInsideListItem) {
      this.xmlWr.writeElement("text:list-item");
      this.bInsideListItem = true;
    }
    finitList(nList); 
    this.xmlWr.writeElement("text:p");
    this.xmlWr.writeAttribute("text:style-name", "text_List" + this.nList);
    this.bParagrFirstline = true;
    if(line.length()> pos+1) {
      StringBuilder allLines = readAllTextLinesOfParagraph(line.substring(pos+1));
      error = parseWriteText(allLines, false);
    }
    this.xmlWr.writeElementEndInline("text:p");
    this.xmlWr.writeElementEnd("text:list-item");
    this.bInsideListItem = false;
    return error;
  }
  
  
  /**Replacement of special characters.
   * <ul>
   * <li>[0]https://op.europa.eu/de/web/eu-vocabularies/formex/physical-specifications/character-encoding/quotation-marks
   * <li>[1] the subscription in ZmL
   * <li>[1] subscription in Asciidoc
   * <li>[3] subscription using for technical paths, "x"=use as given in [0], " " can be removed in a file system path.
   */
  static String[][] sTextReplace = 
    { {  "\\",     "\\\\" , "\\"      , "x" }  //backslash itself, detect first to prevent first detect one backslash and a following char.
    , {  "<:",     "<\\:" , "<:"      , "x" }  //Special replacement for <: in text
    , {  "<.",     "<\\." , "<."      , "x" }  //Special replacement for <. in text
    , {  ".>",     ".\\>" , ".>"      , "x" }  //Special replacement for .> in text
    , {  "\uff0d", "\\---", "{fmin}"  , "-" }  //Fullwidth Hyphen-Minus, dash    －     https://en.wikipedia.org/wiki/Halfwidth_and_Fullwidth_Forms_(Unicode_block)
    , {  "\u2013", "\\--" , "{fmin}"  , "-" }  //width Hyphen-Minus, dash –             //?? https://jakubmarian.com/hyphen-minus-en-dash-and-em-dash-difference-and-usage-in-english/
    , {  "\u00a0", "\\ "  , "{nbsp}"  , " " }  //non breaking space
    , {  "\u2008", "\\:"  , "{dsp}"   , " " }  //space width as a dot
    , {  "\u200b", "\\|"  , "{zwsp}"  , " " }  //no width optional break
    , {  "\n",     "\\n " , " +\n"    , " " }  //! executes <text:line-break>
    , {  "\t",     "\\t " , "{tab}"   , " " }  //! executes insert tab
    , {  "\u2060", "\\+"  , "{wj}"    , " " }  //word joiner, no break here possible
    , {  "\u2011", "\\-"  , "{nbhy}"  , "-" }  //non breaking hyphen
    , {  "\u00ad", "\\~"  , "{zhy}"   , "-" }  //soft hyphen, possible hyphenation
    , {  "\u00ab", "\\<<" , "{ldaquo}", "x" }  //left pointing guillemet (ISO: left-pointing double angle quotation mark)
    , {  "\u00bb", "\\>>" , "{rdaquo}", "x" }  //right pointing guillemet (ISO: right-pointing double angle quotation mark)
    , {  "\u2039", "\\<"  , "{lsaquo}", "x" }  //single left angle quotation mark
    , {  "\u203a", "\\>"  , "{rsaquo}", "x" }  //single right angle quotation mark
    , {  "\u201c", "\\\"" , "{ldquo}" , "x" }  // English left, German right quotation 
    , {  "\u201d", "\\''" , "{rdquo}" , "x" }  // English right double quotation 
    , {  "\u2018", "\\'"  , "{lsquo}" , "'" }  // 
//  , {  "\u201f", "\\``" , "{rxdquo}", "`" }  // ?? 
     , {  "\u2019", "\\^" , "{rsquo}" , "^" }  // right single quotation
//   , {  "\u201b", "\\`" , "{lsrquo}", "`" }  // single reversed comma quotation mark
    , {  "\u201e", "\\,," , "{lbdquo}", "\"" }  // German double low quotation mark 
    , {  "\u201a", "\\,"  , "{llsquo}", "\"" }  // low single comma quotation mark
    , {  "\u2017", "\\_"  , "{rxdquo}", "_" }  // double underliner   xxx ?? 
    , {  "\u2023", "\\*>" , "*"       , "x" }  // bullet point triangle to right
    , {  "\u25cf", "\\**" , "*"       , "x" }  // bullet point larger
    , {  "\u2022", "\\*"  , "*"       , "x" }  // bullet point standard
    };
  
  
  /**Single characters to replace with {@link #sTextReplace} proper for StringFunctions# 
   * 
   */
  static String sTextReplaceChars;
  static {
    char[] cc = new char[sTextReplace.length];
    int ix = -1;
    for(String[] check: sTextReplace ) {
      cc[++ix] = check[0].charAt(0);
    }
    sTextReplaceChars = new String(cc);
  }
  

  
  /**This Strings are replaced from Asciidoc to LibreOffice.
   * It means if Asciidoc contains it, they will be replaced with the UTF-16 character or UTF-8 used for LibreOffice
   * but they are not replaced backward.
   * It means for generated Asciidoc UTF-8 should be used in editor and files. 
   * 
   */
  static String[][] sTextReplaceAsciidoc = 
    { { " " , "\0", "{sp}"   }
    , { "'" , "\\0", "{apos}" }
    , { "\"", "\\0", "{quot}" }
    , { "°" , "\\0", "{deg}"  }
    , { "+" , "\\0", "{plus}" }
    , { "|" , "\\0", "{vbar}" }
       
    };
  
//  static String[][] sCheckReplace = new String[ WriteOdt.sTextReplace.length 
//                                                + WriteOdt.sTextReplaceAsciidoc.length]
//                                                [];
//  static { 
//    int ix=-1;
//    for(String[] check : WriteOdt.sTextReplace) {
//      sCheckReplace[++ix] = check;
//    }
//    for(String[] check : WriteOdt.sTextReplaceAsciidoc) {
//      sCheckReplace[++ix] = check;
//    }
//  }

  
  /**Builds the search Strings for replacing from ZmL to character in {@link #sTextReplace} [0].*/
  static String[] sCheckTextReplZmL = new String[ WriteOdt.sTextReplace.length ];
  static { 
    int ix=-1;
    for(String[] check : WriteOdt.sTextReplace) {
      sCheckTextReplZmL[++ix] = check[1];
    }
  }

      
  static String[][] sTextCtrlCommon = 
    { { "<:i:", ".>", "__", "__", "modif_i"}
    , { "<:b:", ".>", "**", "**", "modif_b"}               // A citation is using a particular idea that you got from another author.
    , { "<:ib:", ".>", "__**", "**__", "modif_ib"}         // A quotation is using the exact words of another author.
    , { "<:I:", ".>", "[I]`", "`", "Citation"}             // Note that some people refer to a "citation" as a "paraphrase."
    //, { "<:Q:", ".>", "[Q]`", "`", "Quotation"}            // https://cegepenglish.zendesk.com/hc/en-us/articles/204546435-What-is-the-Difference-Between-a-Quotation-and-a-Citation
    , { "<:Q:", ".>", "[Q]`", "`", "Citation"}             // Note: there is a confusion in LibreOffice between Citation and Quotation
    , { "<:E:", ".>", "[E]`", "`", "Emphasis"}
    , { "<:S:", ".>", "[S]`", "`", "Strong_20_Emphasis"}
    , { "<:2:", ".>", "[?]`", "`", "Superscript"}
    , { "<:1:", ".>", "[=]`", "`", "Subscript"}
    , { "<:c:", ".>", "`", "`", "ccode"}
    , { "<:@ref:", ".>", "<<#", ">>", "!llink"}
    , { "<:#", ".>", "<<#", ">>", "!llink"}
    , { "<:@link:", ".>", "link:", "]", "!glink"}
    , { "<:@image:", ".>", "image::", "]", "!image"}
    , { "\0", "\0", "pass:[", "]", "!pass"}
    , { "\0", "\0", "+", "+", "!pass+"}
    , { "<:@page:", ".>", "PDF@", "99","!plink"}
    , { "<:@page", ".>", "PDF@", "99","!plink"}
    , { "<:", ".>", "[", "`", "!Tstyle"}                   // after other "<:..": this is a character style
    , { "  ", "", "  ", "", "!spaces"}                   // to detect more as one space one after another.
    };
  
  
  
  /**Contains the Strings to search in Markup source to replace with function or style..
   * It is the {@link #sTextCtrlCommon}[...][0]
   */
  static String[] sTextCtrlCommonSearchMu = new String[sTextCtrlCommon.length];
  static {
    int ix = -1;
    for(String[] s : sTextCtrlCommon) {
      sTextCtrlCommonSearchMu[++ix] = s[0];
    }
  }
  
  
  
  /**Contains the Strings to search in Markup source to replace with function or style..
   * 
   */
  static String[] sTextCtrlCommonSearchAsciidoc = new String[sTextCtrlCommon.length];
  static {
    int ix = -1;
    for(String[] s : sTextCtrlCommon) {
      sTextCtrlCommonSearchAsciidoc[++ix] = s[2];
    }
  }
  
  
  
  
  
  /**Reads all text lines till empty line or till specific such as "* " for a list.
   * @param sLineStart The first line.
   * @return StringBuilder with all lines. 
   *   A read line which is not used is stored in {@link #sLineNext} for using for the next paragraph, especially a list.
   * @throws IOException
   */
  private StringBuilder readAllTextLinesOfParagraph(String sLineStart) throws IOException {
    if(sLineStart.startsWith("The element"))
      Debugutil.stop();
    StringBuilder sbLine = new StringBuilder(512);
    String sLine = sLineStart;
    if(sLineStart !=null) { 
      if(!this.args.bReadAdoc) { sLine = sLineStart.trim(); }  // without especially leading spaces, remove intendation, but not for Asciidoc
      sbLine.append(sLine); 
    }
    do {               //length() is 0 on first call, do not insert a space if line before ends with .>
      boolean bSpace = sLine.length() >0 && !sLine.endsWith("::");
//      if(!bSpace)
//        Debugutil.stop();
      sLine = this.rZmL.readLine();
      if(sLine !=null && sLine.startsWith("<.")) {             // stop on '<.', it is a control text
        this.sLineNext = sLine;
        sLine = null;
      } else if(isEmptyLine(sLine,0)) {                    // an empty line is the end of the paragraph
        sLine = null;
      } else {
        if(!this.args.bReadAdoc) { sLine = sLine.trim(); } // without especially leading spaces, remove indendation, but not for Asciidoc
        for(String sStart : specificLineStarts) { //--------- check specific line starts also inside consequently lines
          if(sLine.startsWith(sStart)) {                   // abort the paragraph lines if another kind of line comes.
            this.sLineNext = sLine;                        // store the read line for next evaluation.
            sLine = null;
            break;   
          }
        }
      }
      if(sLine !=null) {   //----------------------- paragraph lines are aborted here.
        if(bSpace) { sbLine.append(' '); }
        sbLine.append(sLine);
      }
    } while(sLine !=null);
    return sbLine;
  }
  
  

  /**Analyzes the given line where interpretation are necessrary, and writes it with &lt:text:span... > in the given line, 
   * writes the text with {@link #writeText(String, boolean)} outside interpreations stuff.
   * Which is regarded: see {@link #sTextCtrlCommon}, {@link #sTextCtrlItalicBold}, {@link #sTextCtrlStyleForItalicBold}.
   * The {@link Cfg#useItalicBold} decides whether <code>__textInItalic__</code> etc. is outputted as indirect style italic 
   * or as direct style "Quotation". Both is possible.
   * @param line
   * @return
   * @throws IOException
   */
  private String parseWriteText(CharSequence clineArg, boolean bIndentSpaces) throws IOException {
    int posText = 0;
    CharSequence cline = clineArg; //replaceBackslasSubscription(clineArg, null);   //====>> replace all \" etc.
    //String line = cline.toString();    // it is a cheap operation if cline is a string.
    StringBuilder line = cline instanceof StringBuilder ? (StringBuilder) cline: new StringBuilder(cline);
    if(line.toString().startsWith("Test ")) Debugutil.stopp();
    int ixTransscriptedInTextReplace = this.args.bReadAdoc ? 2 : 1;
    int pos = 0;
    int posEnd = line.length();
    if(StringFunctions.startsWith(line, " "))   //----------- if the paragraph or span begins with spaces,
      posText = writeSpaceSupplement(line);                // then always (also on one space) write <text:s ..../>
    if(line.indexOf("etc.")>=0)
      Debugutil.stop();
    int p1;
    if( (p1 = line.indexOf("etc."))>=0)
      Debugutil.stop();
    int[] ixFound = new int[1];
    do {
      int posTextEnd = posEnd;
      int posTextSpan = -1, posTextEndSpan = -1;
      int posTextNext = posEnd;
      String style = null;

      int pos3, pos4;
      //----------------------------------------------------- check base style/replacing possibility in sTextCtrls:
      
      String[] sFound = new String[1];    //----------------- search one of "<:I:", "<:C:", <:@ref:" etc. inside the text.
      int pos1 = StringFunctions.indexOfAnyString(line, posText, posEnd, sTextCtrlCommonSearchMu, ixFound, sFound);
      if(pos1 >=0) {                      //----------------- found, then 
        String[] check = sTextCtrlCommon[ixFound[0]];
        posTextSpan = pos1 + check[0].length();
        int pos2 = StringFunctions.indexOf(line, posTextSpan, posEnd, check[1]);
        if(pos2 >=0) {
          style = check[4];            //<<<<---------------- The content after this start code till end code, usual till ".>"
          posTextEnd = pos1;                               // pos of the non span text before and after.
          posTextEndSpan = pos2;
          posTextNext = pos2 + check[1].length();
        }
      }
      if(this.sStyleParagr !=null && ( style == null || !style.equals("!image") 
           || posTextEnd > posText || posTextNext < posEnd)
        ) {
        this.xmlWr.writeAttribute("text:style-name", this.sStyleParagr);
        this.sStyleParagr = null;
      }
      final boolean bPossibleCodeLink;                     // set true if 'TEXT>><:style:SPAN.> is detected.
      final String sPossibleCodeLink = ">>";               // '>>' before '<:style:text.>
      if(posTextEnd > posText) {     //---------------------- write the text before <:... or the whole text
        bPossibleCodeLink = style !=null && style.equals("!Tstyle") && posTextEnd >= posText +2 
         && line.substring(posTextEnd-2, posTextEnd).equals(sPossibleCodeLink);
        final int posTextEndWr = bPossibleCodeLink ? posTextEnd -2 : posTextEnd;  // do not write ">>" before possible code link
        CharSequence textw = replaceBackslasSubscription(line.substring(posText, posTextEndWr), null, false, false);
        writeText(textw, bIndentSpaces);
      } else {
        bPossibleCodeLink = false;
      }
      if(style !=null) { //posTextSpan < posTextEndSpan) {    //--------------- <:span:...> found
//        String sSpanTest = line.substring(posTextSpan, posTextEndSpan);
//        if(sSpanTest.contains("\\\\**"))
//          Debugutil.stop();
        String sSpan = replaceBackslasSubscription(line.substring(posTextSpan, posTextEndSpan), null, false, false).toString();
        char cStyle = style.charAt(0);                     // is it necessary to convert the sSpan with BackslashSubscription?
        if(cStyle == '*' || cStyle == '+') {
          this.xmlWr.writeText(sSpan, false);              // result of pass:[textSpan]
        } else if(style.charAt(0) == '!') {  //============== starting with "!..." it is a specific handling
          switch(style.charAt(1)) {
          case 'l': writeChapterRef(sSpan); break;        // <:@ref:#  --> "!llink" Note: sSpan without # though given
          case 'p': writeInternalRefPage(sSpan); break;    // <:@page:  --> "!plink" Note: sSpan with # if reference given
          case 'g': writeLink(sSpan);; break;              // "!plink"
          case 'i': {                                      // "!image"
            boolean bOnlyImage = this.sStyleParagr !=null    // it has not a started paragraph before
                              && posTextNext == posEnd;      // and no more follows.
              parseImage(sSpan, bOnlyImage);
          } break;         
          case 'T': {          //---------------------------- "!Tstyle", a named character style     
            int posStyle2 = StringFunctions.indexOf(line, posTextSpan, posTextEndSpan, ':'); // '<:cJ:text.>
            if(posStyle2 >0) {                             //                                        ^- search second colon
              String styleChars = line.substring(posTextSpan, posStyle2);  // the given character style
              CharSequence textw = replaceBackslasSubscription(line.substring(posStyle2+1, posTextEndSpan), null, false, false);
              boolean bLinkWritten = false;
              if(bPossibleCodeLink) {
                bLinkWritten = writeJavadocLink(textw, styleChars);    // check and write link, or not.
              }
              if(!bLinkWritten) {
                if(bPossibleCodeLink) {
                  writeText(sPossibleCodeLink, false);                  // write the detected but not used ">>" before span
                }
                this.xmlWr.writeElementInline("text:span");
                this.xmlWr.writeAttribute("text:style-name", styleChars);
                writeText(textw, bIndentSpaces);           // do not check content again, write text inside span as given. 
                this.xmlWr.writeElementEnd("text:span");
              }
            }
          } break;
          case 's':                                        // "!spaces"
            posTextNext = posTextEnd + writeSpaceSupplement(line.substring(posTextEnd)); break;
          } //switch
        }
        else {         //------------------------------------ not starting with "!...", it is a style
          this.xmlWr.writeElementInline("text:span");
          this.xmlWr.writeAttribute("text:style-name", style);
          parseWriteText(sSpan, bIndentSpaces);
          this.xmlWr.writeElementEnd("text:span");
        }
        
      }
      posText = posTextNext;
    } while(posText < posEnd);
    if(posText < posEnd) {
      CharSequence textw = replaceBackslasSubscription(line.substring(posText), null, false, false);
      writeText(textw, false);
    }
    return null;
  }
  
  
  
  
  /**Writes a link to a Javadoc/...html entry. 
   * <ul>
   * <li>It writes '>>Class#element' whereby under ">>" the www-link is written,
   *   and under the "Class#element" the locale link is written. 
   * <li>The given short label in ZmL is expanded to the correct target label in the html target file,
   *   using the known and analyzed Javadoc.html files.
   * </ul>  
   * @param textw the "Class" or "Class#element" itself 
   * @param styleChars "cJ" as style definition
   * @return
   * @throws IOException
   */
  private boolean writeJavadocLink(CharSequence textw, String styleChars) throws IOException {
    try {
      int posEndClass = StringFunctions.indexOf(textw, '#'); // search "ClassName#field" or "ClassName#operation()"
      int zText = textw.length();
      if(posEndClass <0) {
        int posEndSearch = zText;
        int posParenthOperation = StringFunctions.indexOf(textw, '('); // Class.operation(...)
        if(posParenthOperation >0) {                         // Class.operation(...): "(" found, but # not found
          posEndSearch = posParenthOperation;
        }
        posEndClass = StringFunctions.lastIndexOf(textw, 0, posEndSearch, '.');  // search "Classname.field" or "Classname.operation()"
        if( posParenthOperation <0                           // Class.Operation(..." do not test lower case after '.' 
         && posEndClass < posEndSearch-1 && Character.isUpperCase(textw.charAt(posEndClass+1))) {
          posEndClass = posEndSearch;                        // "... .UppercaseClassname" found, not the posEndClass
        }                                                    // The posEndClass is posEndSearch which is textw.length().
      }
      String sClassName;
      String sTarget;
      int posDel;
      final String sRemoveCharsInLink = "\u200b \n\r";       // this characters may be part of the link text, but not for the link itself.
      if(posEndClass >=0 && posEndClass <zText) {
        sClassName = textw.subSequence(0, posEndClass).toString();
        sTarget = textw.subSequence(posEndClass +1, zText).toString();
        StringBuilder sbTarget = null;
        posDel = StringFunctions.indexOfAnyChar(sTarget, 0, -1, sRemoveCharsInLink);
        while( posDel >=0) {
          if(sbTarget == null) { sbTarget = new StringBuilder(sTarget); }
          sbTarget.deleteCharAt(posDel);
          posDel = StringFunctions.indexOfAnyChar(sbTarget, posDel, -1, sRemoveCharsInLink);
        }
        if(sbTarget !=null) { sTarget = sbTarget.toString(); }
      } else {
        sClassName = textw.toString();
        sTarget = null;
      }
      StringBuilder sbClassName = null;
      posDel = StringFunctions.indexOfAnyChar(sClassName, 0, -1, sRemoveCharsInLink);
      while( posDel >=0) {
        if(sbClassName == null) { sbClassName = new StringBuilder(sClassName); }
        sbClassName.deleteCharAt(posDel);
        posDel = StringFunctions.indexOfAnyChar(sbClassName, posDel, -1, sRemoveCharsInLink);
      }
      if(sbClassName !=null) { sClassName = sbClassName.toString(); }
      GetJavadocLabel.Link javadocLink = this.javadocLabel.idxClass2Html.get(sClassName);
      if(javadocLink !=null) {
        if(sTarget !=null && (sTarget.indexOf("(...)") >0 || sTarget.indexOf("()") >0))   {
          sTarget = searchForReplacingLinkOperationLabel(javadocLink.sLocal, sTarget, this.args.fDirOdt);
        }
        final String sWWW, sLocal;
        if(sTarget !=null) {
          sWWW = javadocLink.sWWW + '#' + sTarget;
          sLocal = javadocLink.sLocal + '#' + sTarget;
        } else {
          sWWW = javadocLink.sWWW;
          sLocal = javadocLink.sLocal;
        }
        this.xmlWr.writeElementInline("text:a");
        this.xmlWr.writeAttribute("xlink:type", "simple");
        this.xmlWr.writeAttribute("xlink:href", sWWW);
        this.xmlWr.writeAttribute("text:style-name", "Internet_20_link");
        this.xmlWr.writeAttribute("text:visited-style-name", "Visited_20_Internet_20_Link");
        writeText(">>", false);           // do not check content again, write text inside span as given. 
        this.xmlWr.writeElementEnd("text:a");
        //
        this.xmlWr.writeElementInline("text:a");
        this.xmlWr.writeAttribute("xlink:type", "simple");
        this.xmlWr.writeAttribute("xlink:href", "." + sLocal);
        this.xmlWr.writeAttribute("text:style-name", styleChars);
        this.xmlWr.writeAttribute("text:visited-style-name", styleChars);  //? 3a8
        writeText(textw, false);           // do not check content again, write text inside span as given. 
        this.xmlWr.writeElementEnd("text:a");
        //
        return true;
      } else return false;
    } catch(Exception exc) {
      this.log.writeError("unexpected", exc);
    }
    return false;
  }
  
  
  private int writeSpaceSupplement(CharSequence spaces) throws IOException {
    int end = 0;
    int zSpaces = spaces.length();
    while(end < zSpaces && spaces.charAt(end) == ' ') { end +=1; }
    this.xmlWr.writeElementInline("text:s");
    this.xmlWr.writeAttribute("text:c", "" + (end));
    this.xmlWr.writeElementEnd("text:s");
    return end;
  }
  
  
  
  /**Writes a link to a chapter due to &lt;@ref:Label:....>.
   * It checkes {@link #idxLabelExternRef} {@link #idxChnrExternRef}
   * @param refArg
   * @throws IOException
   */
  private void writeChapterRef (String refArg) throws IOException {
    try {
      int posSep = refArg.indexOf(this.args.bReadAdoc ? ',' : ':');    // Adoc: <<#ref,text>>  Mu: <:ref:#ref:text.>
      String ref = (posSep >0 ? refArg.substring(0, posSep) : refArg);
      if(!ref.startsWith("#")) {
        this.log.writef("\nWARNING <:@ref:%s without # is ignored.", refArg);
      } else {
        this.sRefBookmark = ref;
        //if(ref.startsWith("#Impl")) Debugutil.stopp();
        ref = ref.substring(1);  // use ist without starting "#..."
        ReadOdt.LabelRef labelRef = this.idxLabelExternRef.get(ref); // try fist with immediately given reference
        boolean bImgRef = ref.startsWith("__Img_");          // Image refs should start with __Img_
        if(bImgRef)
          Debugutil.stop();
        String linkRef = ref;
        if(!bImgRef && !ref.startsWith("__Link_")) {         // Chapter ref may start with __Link_ 
          linkRef = "__Link_" + ref;                             // nor __Img_ and _Link_: need the __Link_
        }
        if(labelRef == null) { 
          labelRef = this.idxLabelExternRef.get(linkRef);
        }
        String text = posSep >0 ? refArg.substring(posSep+1) : refArg;
        if(labelRef !=null) {   //=========================== The bookmark is found in one of the "-labels:files"
          writeChapterRefExtern(ref, labelRef);
        } else {                //=========================== internal chapter ref
          this.xmlWr.writeElementInline("text:span");
          this.xmlWr.writeAttribute("text:style-name", "Reference");
          if(false && !bImgRef) {               //----------- Image reference needs no chapter ref because non automatic number incrementation.
            this.xmlWr.writeElementInline("text:bookmark-ref");  // but chapter ref needs it, 
            this.xmlWr.writeAttribute("text:reference-format", "chapter"); // format = "chapter"
            this.xmlWr.writeAttribute("text:ref-name", linkRef);
            this.xmlWr.writeText("7", false);
            this.xmlWr.writeElementEnd("text:bookmark-ref");
            this.xmlWr.writeElementInline("text:s");
            this.xmlWr.writeElementEnd("text:s");
          }
          this.xmlWr.writeElementInline("text:bookmark-ref");
          this.xmlWr.writeAttribute("text:reference-format", "text");
          this.xmlWr.writeAttribute("text:ref-name", linkRef);
          this.xmlWr.writeText(text, false);
          this.xmlWr.writeElementEnd("text:bookmark-ref");
          this.xmlWr.writeElementEndInline("text:span");
        }
      }
    } catch(Exception exc) {      //========================= should be used as template for all how to write unexpected Exceptions. 
      CharSequence sExc = ExcUtil.exceptionInfo("", exc, 0, 20);
      this.log.writef("\nException %s", sExc);
      sExc = ExcUtil.exceptionInfo("Exception: ", exc, 0, 2);
      this.xmlWr.writeElementInline("text:span");
      this.xmlWr.writeAttribute("text:style-name", "Emphasis");
      writeText("Exception: ", false);   //NOTE replace \\ etc. not done here
      writeText(sExc, false);   //NOTE replace \\ etc. not done here
      this.xmlWr.writeElementEndInline("text:span");
    }
   
  }
  
  
  /**Writes links to pdf and html www and local in the following form:
   * <ul>
   * <br>'>>docu.pdf[] >>1.2 Chapter page 23'<br>
   * Whereas:
   * <ul>
   * <li>The first '>>' contains the pdf link to www, if given, else '>>' is not written. 
   * <li>The 'docu.pdf' is a Hyperlink to the local file, or without Hyperlink if a local file is not given.
   * <li>The [] is a hidden text with '@ref#sRefZmL' with the given sRefZml.
   * <li>The second '>>' is the link of the given www html file inclusively the intern label.
   *   It is the same label is in '[]'.
   * <li>Under the '1.2 Chapter' the link to a local html file is hyperlinked.
   * </ul>   
   * @param sRefZmL reference as given in ZmL after '@ref:#' without leading '#'
   * @param labelRef
   * @throws IOException
   */
  private void writeChapterRefExtern (String sRefZmL, ReadOdt.LabelRef labelRef) throws IOException {
    try {
      // Note: the ../ is necessary inside LOffc, additional to the link from the odt file.
      String sHref = this.args.sRefBesideHtml != null ? this.args.sRefBesideHtml + labelRef.sRefHeading + this.args.sExtRefBesideHtml + "#" + sRefZmL 
                   : null;
      String sHwww = this.args.sRefBesideInWWWHtml != null ? this.args.sRefBesideInWWWHtml + labelRef.sRefHeading + this.args.sExtRefBesideHtml + "#" + sRefZmL
                   : null;
      String sPDFref = this.args.sRefBesidePdf == null ? null
                     : this.args.sRefBesidePdf + labelRef.sRefHeading + this.args.sExtRefBesidePdf;
      String sPDFwww = this.args.sRefBesideInWWWPdf == null ? null
                     : this.args.sRefBesideInWWWPdf + labelRef.sRefHeading + this.args.sExtRefBesidePdf;
      if(!FileFunctions.isAbsolutePath(sHref)) {           // the relative path inside content.xml should refer one level outer (from inner content.xml).
        if(sHref.startsWith("./")) { sHref = "." + sHref; }
        else { sHref = "../" + sHref; }
      }
      if(!FileFunctions.isAbsolutePath(sPDFref)) {           // the relative path inside content.xml should refer one level outer (from inner content.xml).
        if(sPDFref.startsWith("./")) { sPDFref = "." + sPDFref; }
        else { sPDFref = "../" + sPDFref; }
      }
      if(sPDFwww !=null) {     //---------- both pdf www and local is given: 
        this.xmlWr.writeElementInline("text:a");           // write '>>' as sPDFwww link.
        this.xmlWr.writeAttribute("xlink:type", "simple");
        this.xmlWr.writeAttribute("xlink:href", sPDFwww);
        this.xmlWr.writeAttribute("text:style-name", "Internet_20_link");
        this.xmlWr.writeAttribute("text:visited-style-name", "Visited_20_Internet_20_Link");
        writeText(">>>", false);           // do not check content again, write text inside span as given. 
        this.xmlWr.writeElementEnd("text:a");
        //
      }
      if(sPDFref !=null) {
        this.xmlWr.writeElementInline("text:a");
        this.xmlWr.writeAttribute("xlink:type", "simple");
        this.xmlWr.writeAttribute("xlink:href", sPDFref == null ? sPDFwww == null ? sHref : sPDFwww : sPDFref);
        if(sPDFwww ==null) {
          this.xmlWr.writeAttribute("text:style-name", "Internet_20_link");
          this.xmlWr.writeAttribute("text:visited-style-name", "Visited_20_Internet_20_Link");
        } else {
          this.xmlWr.writeAttribute("text:style-name", "Reference");
          this.xmlWr.writeAttribute("text:visited-style-name", "Reference");
        }
        writeText(labelRef.sRefHeading, false);   //NOTE replace \\ etc. not done here
        writeText(".pdf", false);
        this.xmlWr.writeElementEnd("text:a");
      }
      if(sHwww == null && sHref == null) {         // the sHwww and the sHref contains the label also, the hidden-text is not necessay.
        this.xmlWr.writeElementInline("text:hidden-text");
        this.xmlWr.writeAttribute("text:condition", "ooow:");
        this.xmlWr.writeAttribute("text:string-value", "@ref#" + sRefZmL);
        this.xmlWr.writeAttribute("text:is-hidden", "true");
        this.xmlWr.writeElementEnd("text:hidden-text");
      }
      writeText(": ", false);
      if(sHwww !=null) {
        this.xmlWr.writeElementInline("text:a");
        this.xmlWr.writeAttribute("xlink:type", "simple");
        this.xmlWr.writeAttribute("xlink:href", sHwww);
        this.xmlWr.writeAttribute("text:style-name", "Internet_20_link");
        this.xmlWr.writeAttribute("text:visited-style-name", "Visited_20_Internet_20_Link");
        writeText(">>>", false);
        this.xmlWr.writeElementEnd("text:a");
      }
      if(sHref !=null) {
        this.xmlWr.writeElementInline("text:a");
        this.xmlWr.writeAttribute("xlink:type", "simple");
        this.xmlWr.writeAttribute("xlink:href", sHref);
        this.xmlWr.writeAttribute("text:style-name", "Reference");
        this.xmlWr.writeAttribute("text:visited-style-name", "Reference");  //? 3a8
        writeText(labelRef.sTitle, false);           // do not check content again, write text inside span as given. 
        this.xmlWr.writeElementEnd("text:a");
      } else {
        this.xmlWr.writeElementInline("text:span");
        this.xmlWr.writeAttribute("text:style-name", "Reference");
        writeText(labelRef.sTitle, false);   //NOTE replace \\ etc. not done here
        this.xmlWr.writeElementEndInline("text:span");
      }
//        writeText(" page ", false);
//        writeText(labelRef.sPage, false);   //NOTE replace \\ etc. not done here
      
    } catch(Exception exc) {      //========================= should be used as template for all how to write unexpected Exceptions. 
      CharSequence sExc = ExcUtil.exceptionInfo("", exc, 0, 20);
      this.log.writef("\nException %s", sExc);
      sExc = ExcUtil.exceptionInfo("Exception: ", exc, 0, 2);
      this.xmlWr.writeElementInline("text:span");
      this.xmlWr.writeAttribute("text:style-name", "Emphasis");
      writeText("Exception: ", false);   //NOTE replace \\ etc. not done here
      writeText(sExc, false);   //NOTE replace \\ etc. not done here
      this.xmlWr.writeElementEndInline("text:span");
    }
    
  }
  
  
  
  /**Writes a page reference due to given &lt;:@page:sRef.> 
   * @param sRef can be empty or only consist of a max 3-digit number, 
   *   then it is ignored, instead the reference use on last called {@link #writeChapterRef(String)} is used here also.
   *   This is sensible if the &lt;:@page:.> follows after the &lt;:@ref:sRef:Title.>.
   *   If sRef is given, it can be used only for a page reference without reference text.
   * @throws IOException
   */
  private void writeInternalRefPage (String sRefArg) throws IOException {
    String sRef;
    ReadOdt.LabelRef extLabelRef = null;
    if(sRefArg == null || !sRefArg.startsWith("#")) {
      sRef = this.sRefBookmark;     // Note: Any sRefBookmark has the #. Maybe in future other designations.
    } else {                        //======================= similar algorithm as in writeInternalRef (...)
      sRef = sRefArg;
    }
    if(sRef == null) {
      this.log.writef("\nERROR <:@page.> without any <:@ref:... before");
      return;
    }
    sRef = sRef.substring(1);                              // use ist without starting "#..."
    extLabelRef = this.idxLabelExternRef.get(sRef);             // try fist with immediately given reference
    boolean bImgRef = sRef.startsWith("__Img_");           // Image refs should start with __Img_
    if(!bImgRef && !sRef.startsWith("__Link_")) {          // Chapter ref may start with __Link_ 
      sRef = "__Link_" + sRef;                             // nor __Img_ and _Link_: need the __Link_
    }
    if(extLabelRef == null) { 
      extLabelRef = this.idxLabelExternRef.get(sRef);
    }
    if(extLabelRef !=null) {               //---------------- write only the page number from the external ref
      this.xmlWr.writeElementInline("text:span");
      this.xmlWr.writeAttribute("text:style-name", "Reference");
      this.xmlWr.writeText(extLabelRef.sPage, false);
      this.xmlWr.writeElementEndInline("text:span");
    } else {                               //---------------- write a page bookmark ref to allow adjust page nr in LibreOffice
      this.xmlWr.writeElementInline("text:span");
      this.xmlWr.writeAttribute("text:style-name", "Reference");
      this.xmlWr.writeElementInline("text:bookmark-ref");
      this.xmlWr.writeAttribute("text:reference-format", "page");
      this.xmlWr.writeAttribute("text:ref-name", sRef);
      this.xmlWr.writeText("78", false);                   // only a dummy text will be replaced.
      this.xmlWr.writeElementEnd("text:bookmark-ref");
      this.xmlWr.writeElementEndInline("text:span");
    }
  }
  
  
  static String[] sWwwLink = {"www.", "http:", "https:"};
  
  
  
  private void writeLink(String sLink) throws IOException {
    String sRef;              // "theLink"
    String text;
    if(this.args.bReadAdoc) {
      int pos1 = sLink.indexOf('[');    //--------------------- link:theLink[theText]
      if(pos1 <0) {                                          //     "theLink[theText" := sLink
        this.xmlWr.writeText("link:" + sLink + "]", false);  // not able to resolve.
        sRef = null;
        text = null;
      } else {
        sRef = sLink.substring(0, pos1);              // "theLink"
        text = sRef;
      }
    } else {
      int pos1 = sLink.indexOf("::");
      if(pos1 >=0) {
        sRef = sLink.substring(0, pos1);
        text = sLink.substring(pos1+2);
      } else {
        sRef = text = sLink;
      }
    }
    if(sRef !=null) {
      if(StringFunctions.indexOfAnyString(sRef, 0, 6, sWwwLink, null, null) ==0) {  // sRef is an internet link: 0 = starts at pos 0 with "www..." etc.
        sRef = checkReplaceLinkOperationLabel(sRef);
      } else {
        int posFileEnd = sRef.indexOf(".html#");
        int posNameOperEnd;
        if(posFileEnd>0 && (( posNameOperEnd = sRef.indexOf("(...)")) >0 || ( posNameOperEnd = sRef.indexOf("()")) >0))   {
          String sHtml = sRef.substring(0, posFileEnd+5);
          String sTarget = sRef.substring(posFileEnd+6);
          String sTarget2 = searchForReplacingLinkOperationLabel(sHtml, sTarget, this.args.fDirOdt);
          sRef = sHtml + '#' + sTarget2;
        }
        int posStartRealPath = StringFunctions.indexAfterAnyChar(sRef, 0, -1, "/.");
        this.lastAnchorReplaced = sRef.substring(posStartRealPath);
        if(sRef.startsWith("./")) {  //------------------------ ./relativ/link 
          sRef = "." + sRef;                               // changed to: ../relative/link necessary for LibreOffc
        } else {
          sRef = "../" + sRef;                  // add one directory level from inside odg to odg file level.
        }
      }
      this.xmlWr.writeElementInline("text:a");
      this.xmlWr.writeAttribute("xlink:type", "simple");
      this.xmlWr.writeAttribute("xlink:href", sRef);
      this.xmlWr.writeAttribute("text:style-name", "Internet_20_link");
      this.xmlWr.writeAttribute("text:visited-style-name", "Visited_20_Internet_20_Link");
      writeText(text, false);                 //Note: replace \\ etc. not done here.
      this.xmlWr.writeElementEnd("text:a");
    }
  }
  
  
  
  private String checkReplaceLinkOperationLabel ( String sRef) {
    String retRef = sRef;
    int posHashRef = sRef.indexOf('#');
    int posEllipsis = sRef.indexOf("...");
    if(posEllipsis >0)
      Debugutil.stop();
    if( (posHashRef >0 || posEllipsis >0) && this.lastAnchorReplaced.length()>0 && sRef.startsWith(this.args.swwwRoot)) {
      if(posEllipsis >0) {
        retRef = sRef.substring(0, posEllipsis) + this.lastAnchorReplaced;
      } else {
        int posHashRepl = this.lastAnchorReplaced.indexOf('#');
        String sFile = this.lastAnchorReplaced.substring(0, posHashRepl+1);
        int posFileWww = sRef.indexOf(sFile);                // the same file should be used
        if(posFileWww >0) {
          retRef = sRef.substring(0, posFileWww) + this.lastAnchorReplaced;
        }
      }
    } 
    this.lastAnchorReplaced = "";  // always after next request, also on error. The next next is improper.
    return retRef;
  }
  
  
  /**Writes the pure text to XML, whereby spaces are replaced by &lt;text:s...>
   * and also \n and \t are replaced by elements &lt;text:line-break/> and &lt;text:tab/>
   * as necessary in LibreOffice
   * See also {@link #parseWriteText(String)}
   * @param txtArg
   * @param bNewline
   * @return
   * @throws IOException
   */
  private String writeText(CharSequence txtArg, boolean bNewline) throws IOException {
    StringBuilder sbText = null;
    CharSequence sText = txtArg;
//    if(StringFunctions.startsWith(txtArg, " is not true"))
//      Debugutil.stop();
//    if(txtArg.charAt(0)== ' ')
//      Debugutil.stop();
    if(sText instanceof StringBuilder) {
      sbText = (StringBuilder) sText;
    }
    int pos = -1;
    int zTxt = sText.length();
    pos = zTxt;
    int posw1 = 0, posw2 = posw1;
    //------------------------------------------------------- replace leading spaces because LOffc may ignore them on start of a line.
    // But if this is after span, one space is also replaced, though it might be unnecessary, but it works. 
    // the argument bNewline should designate, whether this is a writeText on start of line or not. Yet not used.
    // Do not remove this argument, may be necessary. Check whether this argument bNewline is ok. 
    while(posw2 < zTxt && sText.charAt(posw2) == ' ') { posw2 +=1; };
    if(posw2 > posw1) {
      this.xmlWr.writeElementInline("text:s");
      int nrSpaces = posw2 - posw1;  // LOffc: if text:c is not given on start of line, it is ok, if it is not given in the line, chaos.
      this.xmlWr.writeAttribute("text:c", "" + nrSpaces);  // seems to be that if not given, the same nrSpaces are written as the line.length, why ever?
      this.xmlWr.writeElementEnd("text:s");
      posw1 = posw2;
    }
    //while( (posw2 = StringFunctions.indexOfAnyChar(sText, posw1, -1, "\n\t")) >=0) {
    String[] findNlTabSpaces = {"\n", "\t", "  "};
    int[] nrFound = new int[1];
    while( (posw2 = StringFunctions.indexOfAnyString(sText, posw1, -1, findNlTabSpaces , nrFound, null)) >=0) {
      //char cWhat = sText.charAt(posw2);
      if(posw2 > posw1) {
        this.xmlWr.writeText(sText.subSequence(posw1, posw2), false);
      }
      switch( nrFound[0]) {
      case 0: {
        this.xmlWr.writeElementInline("text:line-break");
        this.xmlWr.writeElementEndInline("text:line-break");
      } break;
      case 1: {
        this.xmlWr.writeElementInline("text:tab");
        this.xmlWr.writeElementEndInline("text:tab");
      } break;
      case 2: {
        int posw3 = posw2;
        while(posw2 < zTxt && sText.charAt(posw2) == ' ') { posw2 +=1; }  //----- replace leading spaces only if the text should start in a newline.
        this.xmlWr.writeElementInline("text:s");
        int nrSpaces = posw2 - posw3;
        if(nrSpaces >1 ) { this.xmlWr.writeAttribute("text:c", "" + nrSpaces); }
        this.xmlWr.writeElementEnd("text:s");
        posw2 -=1;
      } break;
      default: // do nothing with
      } // switch
      posw1 = posw2 +1;
    }
    if(posw1 < sText.length()) {
      this.xmlWr.writeText(sText.subSequence(posw1, sText.length()), false);
    }
    if(pos< zTxt) {
      this.xmlWr.writeElementInline("text:s");
      if(pos < zTxt-1) { this.xmlWr.writeAttribute("text:c", "" + (zTxt-pos)); }
      this.xmlWr.writeElementEnd("text:s");
    }
    return null;
  }
  
  
  
  /**Replace the ZmL specific backslash subscription by the specific UTF16 character to save in odg.
   * @param txtArg If given use it. If it is a StringBuilder, use it already for return.
   * @param sbTextArg If given use it.
   * @return text with specific UTF16 chars. For the content.xml there will be replaced in the specific XML way.
   *   It is either txtArg as String, if no changes are done, or txtArg as given as StringBuilder, in the Stringbuilder changes or made;
   *   or it is the given sbTextArg which may be changed if txtArg is not a StringBuilder.
   */
  private CharSequence replaceBackslasSubscription(CharSequence txtArg, StringBuilder sbTextArg, boolean bReplaceToAscii, boolean bRemoveSpace) {
    StringBuilder sbText = txtArg instanceof StringBuilder ? (StringBuilder) txtArg : sbTextArg;  // use a given unknown StringBuilder.
    CharSequence sText = txtArg;
//    if(sText.toString().contains("Note that a "))
//      Debugutil.stop();
    int pos = 0;
    int[] ixFound = new int[1];
    int ixTransscriptedInTextReplace = this.args.bReadAdoc ? 2 : 1;
    do {
      pos = StringFunctions.indexOfAnyString(sText, pos, 9999, sCheckTextReplZmL, ixFound, null);
      if(pos >=0) {
        if(sbText == null) {
          sbText = new StringBuilder(sText);
          sText = sbText;
        }
        String[] sReplA = sTextReplace[ixFound[0]];;
        char cReplAscii = sReplA[3].charAt(0);
        String sRepl;
        if(bReplaceToAscii) {
          sRepl = cReplAscii=='x' ? sReplA[0]              // take the normal replacement by more as one character in ASCII
                : cReplAscii==' ' && bRemoveSpace ? ""     // remove spaces
                : sReplA[3];                               // take instead the ASCII character.
        } else {
          sRepl = sReplA[0];
        }
        sbText.replace(pos, pos+sReplA[ixTransscriptedInTextReplace].length(), sRepl);  // replace at position with non transcript text.
        pos += sRepl.length();                          // continue after replaced position.
      }
    } while(pos >=0);
    return sText;
  }
  

  
  

  
 
  
  /**Writes a block as code, write each line as extra &lt;text:p....
   * The content of lines are evaluated with {@link #parseWriteText(String)}.
   * It means, also here character mark up (span) and character replacements 
   * ({@link #replaceBackslasSubscription(CharSequence, StringBuilder)} are also done here.
   * <br>
   * <br>
   * A line starting with &lt;:include:PATH/TO/File::tag> includes a source part,
   * see {@link #includeSrcCode(String)}.
   *  
   * @param sStartLine first line of code block, containing the &lt;:Code....
   * @return
   * @throws IOException
   */
  private String parseWriteCodeBlock (String sStartLine) throws IOException {
    if(!this.args.bReadAdoc) {
      int pos1 = sStartLine.indexOf(':', 2);
      int pos2 = sStartLine.indexOf('>');
      if(pos2 == pos1+1)
        Debugutil.stop();
      if(pos1 >0 && pos2 > pos1) {
        this.sCodeStyle = "Code" + sStartLine.substring(pos1+1, pos2);
      } else {
        this.sCodeStyle = "Code";
        this.log.writeError("WARNING faulty %s\n", sStartLine);
      }
    }
    String sLineNext;
    sLineNext = this.rZmL.readLine();
//    if(sLineNext.contains("<\\:pageBreak.\\>"))
//      Debugutil.stop();
//    if(sLineNext.contains("void calc_ifFB"))
//      Debugutil.stop();
    do {
//      if(sLineNext.contains("Condition Bits"))
//        Debugutil.stop();
      if(sLineNext.startsWith("<::include:")) {
        StringBuilder allLines = readAllTextLinesOfParagraph(sLineNext);
        String sLineIncl = allLines.toString();
        int endPos = sLineIncl.lastIndexOf(".>");
        if(endPos <0) { endPos = sLineIncl.length(); }
        includeSrcCode(sLineIncl.substring(3, endPos), this.sCodeStyle);
      } else if(sLineNext.startsWith("<.Code")|| this.args.bReadAdoc && sLineNext.startsWith("----")) {
        break;
      } else {
        this.xmlWr.writeElement("text:p");
        this.xmlWr.writeAttribute("text:style-name", this.sCodeStyle);
        parseWriteText(sLineNext, false);    // ==============>> parseWriteText() interpret text formatting also in code blocks.
        //writeText(sLineNext, true);           // ============>> writeText as given, without interpretation.
        this.xmlWr.writeElementEndInline("text:p");
      }
      if(this.sLineNext == null) { 
        sLineNext = this.rZmL.readLine(); 
      } else {
        sLineNext = this.sLineNext;
        this.sLineNext = null;
      }
    } while(sLineNext !=null);
    this.sCodeStyle = null;
    this.bInsideCode = false;
    return null;
  }
    
  
  
  /**Includes lines from a source file. Syntax example:<pre>
   * &lt;::include:../path/to/src::TAG::44::4:marker,6:-,8:+,10:-.> </pre>
   * Syntax in ZBNF: <pre>
   * includeCode::=\&lt;::include:&lt;*|::?PATH>::&lt;*|::?TAG>
   *     [::&lt;#?LineWidth>][::-&lt;*|::?removeComment>]
   *     [{[+&lt;?nextLine>]&lt;#?LINE>[,&lt;#?COLUMN>][:&lt;*:\.?MARKER>?::}]:;.
   * </pre>
   * It means:
   * <ul>
   * <li>PATH is the path from the ZmL file to the source, usual starting with <code>../../path/to/source.c</code>
   * <li>'TAG' is the tag searched in the source. If TAG=="$" then the source is taken from the first line.
   * <li>if TAG starts with ' (ASCII 0x27, apostrophe), then a text in the source is searched as start tag
   *   and this text is not suppressed.
   * <li>LineWidth is the max line length, src lines are shorten and ends with ... if necessary.
   *   This is optional, if not given 44 is taken.
   * <li>::-//:: if this is written after the LineWidth, then removes empty lines and only comment lines 
   *   and comments in the line, which starts with the given String removeComment, here with //.
   *   This is sensible if the comment in code is irritating, because the code is commented in docu by the markers.  
   * <li>The part in [{....}] is an optional repetition of:
   * <li>LINE A line number starting from 1 for the showed line in the docu (with the start tag)
   * <li>optional COLUMN for the column of the marker:
   * <li>MARKER after a colon: 
   * <li>If the MARKER is '-' (written "...::12:-" then the code shown is switched off from this line.
   * <li>If the MARKER is '+' (written "...::12:+" then the code shown is switched on again from this line.
   * <li>Else: The marker is shown in docu with this text on this line and column.
   * <li>?, means: The combination of LINE[,COLUMN}:MARKER can be repeated with comma as separator.
   * </ul>
   * For the TAG a sub syntax is valid:
   * <pre>
   * </pre>
   * Examples:
   * <ul><li><code>&lt;::include:../path/to/source.c::startTAG::80.></code>
   *   includes the lines from &lt::startTag> to &lt.startTag> with a line width of max 80 character.
   * <li><code>&lt;::include:../path/to/source.c::'code text'::80::16:-.></code>
   *   includes from the line which contains "code text", 16 lines.
   * </ul>    
   * Source:<ul>
   * <li> &lt::TAG.> If contains anywhere in the line, this is the first line to get.
   * <li> &lt::~TAG.> If contains anywhere in the line, the next line is the first line to get.
   * <li> &lt.TAG.> Marked with this, it is the last line to contain, then include is stopped.
   * <li> &lt.~TAG.> Marked with this, from this line include is stopped.
   * <li> &lt:-TAG> This line and following are omitted and replaced by " ....."
   * <li> &lt:+TAG> from this line insertion is recovered
   * <li> Markers can also contain in the source in the form <:marker.>
   * </ul>
   * Examples:
   * <ul><li><code>&lt;::include:../path/to/source.c::startTAG::80.></code>
   *   includes the lines from &lt::startTag> to &lt.startTag> with a line width of max 80 character.
   * <li><code>&lt;::include:../path/to/source.c::'code text'::80::16:-.></code>
   *   includes from the line which contains "code text", 16 lines.
   * <li><code>&lt;::include:../path/to/source.c::'code text'::80::4:MARKER::16:-.></code>
   *   as above, writes on end of line 4 "MARKER"
   * <li><code>&lt;::include:../path/to/source.c::'code text'::80::4:MARKER::7,25:M2::16:-.></code>
   *   as above, writes in line 7 column 25 "M2"
   * </ul>    
   * @param sLineIncl
   * @throws IOException 
   */
  private void includeSrcCode (String sLineInclArg, String sCodeStyle) throws IOException {
    //if(sLineInclArg.contains("../../ExmplBandpassFilter/cmpGen/genSrcCmp1/FBcl/ArrayBandpassFilter.fbd")) Debugutil.stopp();
    //if(sLineInclArg.contains("include:../../BasicTest/cmpGen/genSrcCmp/setVariantOut.c::2'bool cond1'*2!1")) Debugutil.stopp();
    String sLineInclParse = replaceBackslasSubscription(sLineInclArg, null, true, true).toString();
    String sLineInclOdt = replaceBackslasSubscription(sLineInclArg, null, false, false).toString();
    CodeIncludeInfo info = new CodeIncludeInfo(sLineInclParse);
    this.xmlWr.writeElement("text:p");        //------------- write head information 'include:path::TAG::44:1:M'
    String style = this.bPageBreakBefore ? "CaptionCodePg" : this.bColumnBreakBefore ? "CaptionCodeCol" : "CaptionCode";
    this.bPageBreakBefore = this.bColumnBreakBefore = false;
    this.xmlWr.writeAttribute("text:style-name", style);
    writeText(sLineInclOdt, false);
    this.xmlWr.writeElementEndInline("text:p");
    if(info.sErrorMsg != null) {
      this.xmlWr.writeElement("text:p");        //------------- write head information 'include:path::TAG::44:1:M'
      this.xmlWr.writeAttribute("text:style-name", sCodeStyle);  // use the codeStyle for the error message, important to reconstrcut the code style for odt2ZmL 
      this.xmlWr.writeText("Error: " + info.sErrorMsg, false);
      this.xmlWr.writeElementEndInline("text:p");
      this.log.writef("\nERROR <::include: %s %s" ,info.sErrorMsg, sLineInclParse);
    } else {
      
      File fIncl = new File(info.sFile);
      BufferedReader frIncl;
      try {
        frIncl = new BufferedReader(new InputStreamReader(new FileInputStream(fIncl)));
      } catch(FileNotFoundException exc) {
        frIncl = null;
        String sFaultypath = FileFunctions.absolutePath(info.sFile, null);
        this.xmlWr.writeElement("text:p");        //------------- write head information 'include:path::TAG::44:1:M'
        this.xmlWr.writeAttribute("text:style-name", sCodeStyle);  // use the codeStyle for the error message, important to reconstrcut the code style for odt2ZmL 
        this.xmlWr.writeText("File not found: >>" + info.sFile + "<< " + sFaultypath , false);
        this.xmlWr.writeElementEndInline("text:p");
        this.log.writef("\nERROR file not found: %s (%s)",info.sFile, sFaultypath);
      }
      if(frIncl !=null) {   //===============================__ file to include is opened, transfer content
        String sLine;                                        // bTag is the state whether the include is in the tagged range to present.
        boolean bTag = info.sTagStart.equals("<::$.>");      // tag '::$' means, include all, hence start from first line
        int ctStartTag = info.tagStartRepeat;
        int ctEndTag = info.tagEndRepeat;
        Iterator<CodeIncludeInfo.MarkerLine> iterMarkerLine = info.markerLines == null ? null: info.markerLines.iterator();
        CodeIncludeInfo.MarkerLine markerLine = iterMarkerLine == null ? null : iterMarkerLine.next();
        int nLine = bTag ? 0 : -1;          // count of Line after marker, starts with 0, +=1 =:1 for first line
        int nLineMarkerNext = markerLine == null ? -1 : markerLine.line;  // maybe -1 if 'text' is given.
        int markerColumn = 0;
        int nrofLinesIncluded = info.nrLines;
        while( (nrofLinesIncluded >0 || ctEndTag>0 ) && (sLine = frIncl.readLine()) !=null) { // while search <::~tag.>, write till <:~tag.> 
          String sText;
          int posTag;
          String sMarker = null;                   //<<<<------ sMarker is a marker to show in document with style 'cM'
          if(nLine >=0) {                          //--------vv count the line from first sStartTag found
            //if(nLine <=1 && sLineIncl.contains("../../ExmplBandpassFilter/cmpGen/genSrcCmp/FBcl/ArrayBandpassFilter.fbd::")) Debugutil.stopp();
            if( markerLine !=null
             && ( nLine == nLineMarkerNext
               || markerLine.sSearch !=null && sLine.indexOf(markerLine.sSearch) >=0
              ) ) {
              sMarker = markerLine.marker;         //--------vv planned marker because of line Number in this line.
              markerColumn = markerLine.column;
              markerLine = iterMarkerLine == null || !iterMarkerLine.hasNext() ? null : iterMarkerLine.next();
              nLineMarkerNext = markerLine == null ? -1    // it gets -1 if 'text' is given.
                  : markerLine.line <0 ? -1 
                  : markerLine.bLineNext ? nLine + markerLine.line // increment from the last line with marker designation
                  : markerLine.line <= nLine ? nLine +1    // if the line is before current, use the next line for marker.
                  : markerLine.line;                       // or the line from start of the included text
            }
            nLine +=1;                                       // independent of pause lines, there are also counted.
          }
          boolean bIncludeInfoUsed = false;
          if(!bTag) {                    //==================vv currently not in a line to copy to document:
            if( (posTag = sLine.indexOf(info.sTagStart)) >=0      // search the <:@tag.> or starttext
             && --ctStartTag ==0) {
              bTag = true;                                   // found
              nLine = 1;
              sText = info.bWriteTag ? sLine: sLine.substring(0, posTag);
            } else if(info.sTagStartNextLine !=null && sLine.indexOf(info.sTagStartNextLine) >=0) {
              bTag = true;
              sText = null;
            } else if( info.sTagCont !=null && (posTag = sLine.indexOf(info.sTagCont)) >=0
                    || sMarker !=null && sMarker.equals("+")
                       && (posTag = sLine.length()) >0
                    ) {
              bTag = true;
              sText = sLine.substring(0, posTag);
              sMarker = null;    // remove the "+", not a marker
            } else {
              sText = null;
            }
          } // if !bTag                  //==================^^ currently not in a line to copy to document:
          //                               ==================vv next check some occurrences in the line to control stop, tags
          else if( info.sTagEnd !=null && (posTag = sLine.indexOf(info.sTagEnd)) >=0  //---vv tagEnd found either <:.TAG.> or the specific text
              && checkIndentation(info.indentEnd, info.nrofSpacesIndent, posTag, sLine) // only if specific text, check indentation
          ) {   // search the <:@tag.>
            ctEndTag -=1;                                      // if 0, finish copying from source
            sText = info.bWriteTag ? sLine: sLine.substring(0, posTag);
          } 
          else if(info.sTagEndExclLine !=null && (posTag = sLine.indexOf(info.sTagEndExclLine)) >=0) {  
              ctEndTag -=1;                          //--------vv <:.~EndTAG.> found, excluding this line
              sText = null;                                  // finish file
          } else if( info.sTagPause !=null &&  (posTag = sLine.indexOf(info.sTagPause)) >=0
                   || ( bIncludeInfoUsed = sMarker !=null && sMarker.equals("-"))) { // '-' switches off the lines
            sText = "    ......";
            bTag = false;
            if( bIncludeInfoUsed                   //--------vv if the '-' from includeInfo.sMarker was detected
             && markerLine == null) {                        // and the '-' is the last entry of marker lines:
              ctEndTag = 0;                                  // then end of code.
              sText = null;          // write nothing more
            }
            sMarker = null;          // not to use further as marker
          } else {                                 //--------vv continue with text from source.
            sText = sLine;
          }
          //                               ==================^^ check some occurrences in the line to control stop, tags
          //                               ==================vv is sText !=null then handle this line from source.
          if(sText !=null) {
            nrofLinesIncluded -=1;                 //<<<<    // count the lines to include if in this mode
            //if(sMarker !=null) Debugutil.stopp();
            int posMarker = info.maxLineLen;                 // important if sMarker is already set by ZmL
            if( sMarker == null                              // not a marker given from CodeIncludeInfo, this would be first. 
             && (posMarker = sLine.indexOf("<:@")) >=0) {    // search <:@MARKER.>
              int pos2 = sLine.indexOf(".>", posMarker+3);
              if(pos2 <0) { pos2 = sLine.indexOf('>', posMarker+3); }  // fallback <:@MARKER>
              if(pos2 >0) {
                sMarker = sLine.substring(posMarker+3, pos2);// sMarker set to show
              }
            }
            int length = sText.length();
            int lenLine2;
            if(sMarker == null) { lenLine2 = info.maxLineLen; }
            else {                       //------------------vv sMarker given
              lenLine2 = info.maxLineLen - sMarker.length();      // marker should have place right.
              if(lenLine2 > posMarker) { lenLine2 = posMarker; }  // line till max the marker, it is right side.
            }
            int posComment;
            if(info.sComment !=null) {   //------------------vv cut comment 
              posComment = sText.indexOf(info.sComment);
              if(posComment >=0) {
                sText = sText.substring(0, posComment);
              }
              length = sText.length();   //check whether line is empty
              int ix;
              for(ix = length-1; ix >=0; --ix) {
                if(" \t".indexOf(sText.charAt(ix))<0) { break; }
              }
              if(ix <0) { sText = null; }
            }                            //------------------^^ cut comment
            if(sText !=null) {    // it is null on empty line
              while(length > lenLine2 && sText.charAt(length-1) == ' ' ) {
                length -=1;                                  // shorten trailing spaces.
              }
              if(length > lenLine2) {
                sText = sLine.substring(0, lenLine2 -3) + "..."; // change to truncated text...
              }
              this.xmlWr.writeElement("text:p");
              this.xmlWr.writeAttribute("text:style-name", sCodeStyle);
              writeText(sText, false);
              if(sMarker !=null) {
                if(length < markerColumn) {
                  int nSpaces = markerColumn - length;         // wr line ....spaces.... <MARKER> due to markerColumn
                  this.xmlWr.writeElementInline("text:s");
                  this.xmlWr.writeAttribute("text:c", "" + nSpaces);
                  this.xmlWr.writeElementEnd("text:s");
                }
                this.xmlWr.writeElementInline("text:span");
                this.xmlWr.writeAttribute("text:style-name", "cM");
                this.xmlWr.writeText(sMarker, false);                // do not check content again, write text inside span as given. 
                this.xmlWr.writeElementEnd("text:span");
              
              }
              this.xmlWr.writeElementEndInline("text:p");
            }
          }
        }
        if(ctEndTag>0 &&  !bTag && info.sTagStart !=null) {
          this.xmlWr.writeElement("text:p");        //------------- write head information 'include:path::TAG::44:1:M'
          this.xmlWr.writeAttribute("text:style-name", sCodeStyle);  // use the codeStyle for the error message, important to reconstrcut the code style for odt2ZmL 
          this.xmlWr.writeText("Tag not found in file: `" + info.sFile + "`' tag=`" + info.sTagStart + "' " , false);
          this.xmlWr.writeElementEndInline("text:p");
          this.log.writef("\n Problem with source include from '%s', tag '%s' not found", info.sFile, info.sTagStart);
        }
        if(ctEndTag>0 && info.sTagStart !=null && !info.sTagStart.equals("<::$.>")) {
          this.xmlWr.writeElement("text:p");        //------------- write head information 'include:path::TAG::44:1:M'
          this.xmlWr.writeAttribute("text:style-name", sCodeStyle);  // use the codeStyle for the error message, important to reconstrcut the code style for odt2ZmL 
          this.xmlWr.writeText("End tag not found in file: `" + info.sFile + "' tag=`" + info.sTagStart + "' " , false);
          this.xmlWr.writeElementEndInline("text:p");
          this.log.writef("\n Problem with source include from %s with end tag=", info.sFile, info.sTagStart);
        }
        frIncl.close();
      }
    } //if(frIncl !=null) //===============================^^ file to include content is transfered
  }

  
  
  /**Checks whether the line has the requested indentation, in cohesion with searching a tag.
   * @param nrIndent number of indentation levels required
   * @param nrofSpacesIndent number of spaces presents one indentation level
   * @param posTag
   * @param sLine
   * @return
   */
  private static boolean checkIndentation (int nrIndent, int nrofSpacesIndent, int posTag, String sLine) {
    if(nrIndent <0) { return true; }
    else {
      int ctIndent = 0;
      int ctSpacesIndent = nrofSpacesIndent;
      int pos0 = posTag-1;
      while(ctIndent <= nrIndent && pos0 >=0) {
        char cs = sLine.charAt(pos0);
        if(cs == ' ') { 
          pos0 -=1; 
          if(--ctSpacesIndent <=0) {  // spaces for one indentation reached
            ctIndent +=1; ctSpacesIndent = nrofSpacesIndent;
          }
        }
        else if(cs == '\t') { pos0 -= 1; ctIndent -=1; }
        else return false;             // other character than tab or space
      }
      return ctIndent == nrIndent && pos0 <0;  // reached start of line after correct indentation
    }
  }
  
  
  
  
  private String writeTableOfContents (String line) throws IOException {
    finitList(0);
    int posChapter = line.indexOf("chapter-");
    int posDeepness = posChapter >=0 ? posChapter + 8 : 0;
    int nDeepness = StringFunctions_C.parseIntRadix(line, posDeepness, 9999, 10, null);
    if(nDeepness ==0) return "ERROR " + line;
    int posColon = line.indexOf(':');
    String sTitle = posColon >0 ? line.substring(posColon +1).trim() : "Table of Contents"; 
//    this.xmlWr.writeElement("text:section");
//    this.xmlWr.writeAttribute("text:style-name", "SectTOC");
//    this.xmlWr.writeAttribute("text:name", "content");
    //
    this.xmlWr.writeElement("text:table-of-content");
    this.xmlWr.writeAttribute("text:style-name", "SectTOCc");
    this.xmlWr.writeAttribute("text:protected", "true");
    //this.xmlWr.writeAttribute("text:name", "TOC1");
    //
    this.xmlWr.writeElement("text:table-of-content-source");
    this.xmlWr.writeAttribute("text:outline-level", "" + nDeepness);
    if(posChapter >=0) {
      this.xmlWr.writeAttribute("text:index-scope", "chapter");
    }
    //
    this.xmlWr.writeElement("text:index-title-template");
    this.xmlWr.writeAttribute("text:style-name", "Contents_20_Heading");
    this.xmlWr.writeText(sTitle, false);
    this.xmlWr.writeElementEnd("text:index-title-template");
    //
    this.xmlWr.writeElementEnd("text:table-of-content-source");
    //
    this.xmlWr.writeElement("text:index-body");
    this.xmlWr.writeElement("text:index-title");
    this.xmlWr.writeElement("text:p");
    String style = this.bPageBreakBefore ? "Contents_20_Heading_pg" : this.bColumnBreakBefore ? "Contents_20_Heading_col" : "Contents_20_Heading";
    this.bPageBreakBefore = this.bColumnBreakBefore = false; // flag is only for this paragraph
    this.xmlWr.writeAttribute("text:style-name", style);
    this.xmlWr.writeText(sTitle, false);
    this.xmlWr.writeElementEndInline("text:p");
    this.xmlWr.writeElementEnd("text:index-title");
    this.xmlWr.writeElementEnd("text:index-body");
    //
    this.xmlWr.writeElementEnd("text:table-of-content");
//    this.xmlWr.writeElementEnd("text:section");

    return null;
  }
  
  
  
  /**Writes a list of external references with the labels.
   * For that the odt should contain the paragraph styles 'ExternRefTitle' and 'ExternRefList'.
   * It is not necessary and only activated with the command line option '-extRefs'.
   * The information are also contained in the files due to the option '-labels:*.Labels.txt'.
   * @throws IOException
   */
  private void writeExternReferences () throws IOException {
    String sFile = "?";
    for(ReadOdt.LabelRef labelRef : this.idxChnrExternRef.values()) {
      if(!labelRef.sRefHeading.equals(sFile)) {            // contains the file name
        this.xmlWr.writeElement("text:p");
        this.xmlWr.writeAttribute("text:style-name", "ExternRefTitle");
        writeText("Docu file: ", false);
        writeText(labelRef.sRefHeading, false);
        this.xmlWr.writeElementEndInline("text:p");
        sFile = labelRef.sRefHeading;
      }
      for(String sLabel : labelRef.idxLabel.values()) {
        this.xmlWr.writeElement("text:p");
        this.xmlWr.writeAttribute("text:style-name", "ExternRefList");
        this.xmlWr.writeElementInline("text:bookmark-start");
        this.xmlWr.writeAttribute("text:name", "__Link_" + sLabel);
        this.xmlWr.writeElementEnd("text:bookmark-start");
        String sTitle = labelRef.sTitle;
        int posNrEnd = sTitle.indexOf(' ');
        if(posNrEnd >0) {                                  // replace first space with tab
          sTitle = sTitle.substring(0, posNrEnd) + '\t' + sTitle.substring(posNrEnd+1);
        }
        writeText(sTitle, false);
        writeText(" page ", false);
        writeText(labelRef.sPage, false);
        writeText(" (#", false);
        writeText(sLabel, false);
        writeText(")", false);
        this.xmlWr.writeElementInline("text:bookmark-end");
        this.xmlWr.writeAttribute("text:name", "__Link_" + sLabel);
        this.xmlWr.writeElementEnd("text:bookmark-end");
        this.xmlWr.writeElementEndInline("text:p");
      }
    }
    return;
  }
  
  private void finitList( int nList) throws IOException {
    while(this.nList > nList) {
      if(this.bInsideListItem) {
        this.xmlWr.writeElementEnd("text:list-item");
      }
      this.bInsideListItem = false;
      this.xmlWr.writeElementEnd("text:list");
      this.nList -=1;
    }
  }

  
  private void finitSection(int toLevel) throws IOException {
    finitList(0);
    while(this.nSection >toLevel) {
      this.xmlWr.writeElementEnd();                    // write </text:p> etc. to finish paragraph in odt
      this.nSection -=1;
    }
    
  }

  
  
  
  private String parseWriteTable(String line) throws IOException {
    String error = null;
    int posColon = line.indexOf(':', 2);
    int posEnd = line.indexOf('>');
    if(posEnd <0) return "missing > on <::table";
    String nrCol = "2";
    while( posColon >=0 && posColon < posEnd) {  //---------- read some attributes of a table
      int posColonNext = line.indexOf(':', posColon+1);
      if(posColonNext <0 || posColonNext > posEnd) {
        posColonNext = posEnd;
      }
      String sAttr = line.substring(posColon+1, posColonNext).trim();
      if(sAttr.startsWith("col=")) { nrCol = sAttr.substring(4); }   //:col= number of columns
      posColon = posColonNext;
    }
    this.xmlWr.writeElement("table:table");
    this.xmlWr.writeAttribute("table:name", "Table" + (++this.nrTableName));
    this.xmlWr.writeAttribute("table:style-name", "Table1");
    this.xmlWr.writeAttribute("table:template-name", "Elegant");
    this.xmlWr.writeElement("table:table-column");
    this.xmlWr.writeAttribute("table:style-name", "Table1.A");
    this.xmlWr.writeAttribute("table:number-columns-repeated", nrCol);
    this.xmlWr.writeElementEnd("table:table-column");
    String sLineNext;
    boolean bInTable = true;
    while ( error == null && bInTable && (sLineNext = this.sLineNext !=null ? this.sLineNext : this.rZmL.readLine()) !=null) {
      this.sLineNext = null;  //used
      sLineNext = sLineNext.trim();
      if(isEmptyLine(sLineNext,0)) {                       // an empty line is the end of the paragraph
      } 
      else if(sLineNext.startsWith("<.table>")){
        bInTable = false;
      }
      else if(sLineNext.startsWith("<:tr.>")){
        error = parseTableRow(sLineNext.substring(6));
      }
    }
    this.xmlWr.writeElementEnd("table:table");
    return error;  
  }

  
  
  private String parseTableRow(String line) throws IOException {
    String error = null;
    this.xmlWr.writeElement("table:table-row");
    this.xmlWr.writeAttribute("table:style-name", "Table1.A");
    String sLineNext;
    boolean bInRow = true;
    while ( bInRow && (sLineNext = this.sLineNext !=null ? this.sLineNext : this.rZmL.readLine()) !=null) {
      this.sLineNext = null;   //used
      sLineNext = sLineNext.trim();
      if(isEmptyLine(sLineNext,0)) {                       // an empty line is the end of the paragraph
      } 
      else if(sLineNext.startsWith("<.table>") || sLineNext.startsWith("<:tr.>")){
        bInRow = false;
        this.sLineNext = sLineNext;
      }
      else if(sLineNext.startsWith("<:td")){
        this.xmlWr.writeElement("table:table-cell");
        this.xmlWr.writeAttribute("table:style-name", "Table1.A1");
        this.xmlWr.writeAttribute("office:value-type", "string");
        int pos2 = sLineNext.indexOf(".>");
        int pos9 = pos2 +2;
        if(pos2 <0) { pos2 = sLineNext.indexOf(".>"); pos9 = pos2 +1; }
        if(pos2 <0) return "ERROR missing > in <:td...";
        int pos3 = sLineNext.indexOf(":spanned=");
        if( pos3>=0) {
          String spanned = sLineNext.substring(pos3+9, pos2).trim(); 
          this.xmlWr.writeAttribute("table:number-columns-spanned", spanned);
        }
        int posP = sLineNext.indexOf("<:p:");
        if(posP >0) { parseWriteParagrStyleLabel(sLineNext.substring(posP)); }
        else { parseWriteParagr(sLineNext.substring(pos9), null); }
        this.xmlWr.writeElementEnd("table:table-cell");
      }
    }
    this.xmlWr.writeElementEnd("table:table-row");
    return error;
  }

  
  
  
  
  
  /**Writes an image with given arguments from the text <:image:....>
   * @param args starts with the path to the image, contains all after "<:image:"
   * @param bOnlyImage true then the paragraph contains only the image.
   *   Note in LibreOffice an image is always embedded in a paragraph.
   * @return null if no error
   * @throws IOException
   */
  private String parseImage(String args, boolean bOnlyImage) throws IOException{
    if(args.contains("exmpTrueFalseComplex_ifFB.png"))
      Debugutil.stop();
    String error = null;
    String sSepAttribs = this.args.bReadAdoc ? "," : "::";
    int zSepAttribs = sSepAttribs.length();
    int pos2 = this.args.bReadAdoc ? args.indexOf('[') : args.indexOf(sSepAttribs);
    int posAttribs;
    if(this.args.bReadAdoc) {
      if(pos2 <0) return "image:: without []";
      posAttribs = args.charAt(pos2+1) == ']' ? 0 :pos2+1;
    } else {
      if(pos2 <0) { pos2 = args.length(); args.indexOf('>'); posAttribs = 0; }
      else { posAttribs = pos2 + zSepAttribs; }
      if(pos2 <0) return "ERROR <image:... without >";
    }
    //if(line.indexOf(this.args.bReadAdoc ? ']' : '>') <0) return "image:: right ] missing";
    int posLink = this.args.bReadAdoc ? 7 : 0;// 8;
    String sLink = args.substring(posLink, pos2).trim();
    String sId = null;
    String sX = null;
    String sY = null;
    String pX=null, pY=null;
    String DPIx="150", DPIy="150";   //default 150 DPI means 1024 x 768 ~ 6in*4.5in = 15cm*12cm
    String sTitle = null;
    String styleImg = null;
    boolean bFloat = false;
    int nrArg = 0;
    while(posAttribs >0) {   //============================!= read all attributes from ZmL
      nrArg +=1;
      int pos4 = args.indexOf('=', posAttribs);
      if(pos4 <0) pos4 = args.length();
      String key = args.substring(posAttribs, pos4).trim();
      int pos5 = args.indexOf(sSepAttribs, pos4);
      if(pos5 <0 ) { 
        pos5 = args.length();
        posAttribs = -1;         //last
      } else {
        posAttribs = pos5 + zSepAttribs;
      }
      String value = args.substring(pos4+1, pos5).trim();
      int posXy = value.indexOf('*');   // separator between x and y
      if(key.equals("id")) {                     //---------- id
        sId = value;
      }
      else if(key.equals("size")) {
        if(posXy >0) {
          sX = value.substring(0,posXy).trim();
          sY = value.substring(posXy+1).trim();
        } else {
          sX = value; sY = null;
        }
      }
      else if(key.equals("px")) {
        if(posXy >0) {
          pX = value.substring(0,posXy).trim();
          pY = value.substring(posXy+1).trim();
        } else {
          pX = pY = value;
        }
      }
      else if(key.equals("DPI")) {
        if(posXy >0) {
          DPIx = value.substring(0,posXy).trim();
          DPIy = value.substring(posXy+1).trim();
        } else {
          DPIx = DPIy = value;
        }
      }
      else if(key.equals("width")) {
        sX = value;
      }
      else if(key.equals("height")) {
        sY = value;
      }
      else if(key.equals("title")) {
        sTitle = replaceBackslasSubscription(value, null, false, false).toString();
      }
      else if(key.equals("float")) {
        styleImg = "ImageFloat" + value;
        bFloat = true;
      }
      else if(key.equals("style")) {
        styleImg = value;
      }
      else if(nrArg == 1){
        sTitle = key;
      } 
      else if(key.equals("anchor")) {
        
      }
      else if(key.equals("sRelX")) {
        
      }
      else if(key.equals("sRelY")) {
        
      }
      else {
        Debugutil.stop();
      }
    } // while   //========================================^== Read all attributes from ZmL
    //
    if(sTitle !=null && sTitle.startsWith(this.cfg.sImgCaptionStart)) {  //reduce the sTitle if is contains the standard pre text "Image 12: "
      int posEnd = sTitle.indexOf(this.cfg.sImgCaption2);  // the standard pre text will be completed later again, maybe with another number!
      if(posEnd >0) {
        if(this.nrFrameImgName == -1) {
          int posDigit = posEnd-1; char cc;
          while( posDigit>=0 && (cc = sTitle.charAt(posDigit)) >='0' && cc <='9') { posDigit -=1; }
          this.nrFrameImgName = StringFunctions_C.parseIntRadix(sTitle, posDigit+1, 99, 10, null);
        }
        sTitle = sTitle.substring(posEnd + this.cfg.sImgCaption2.length());
      } else {
        //reduce sTitle if not start with pre text, nothing to do.
      }
      
    }
    if(styleImg == null) { styleImg = "ImageCenter"; }
    String[] sLinkUse = new String[1];
    final File fImg;
    if(this.args.bRenameImageFiles && sTitle !=null) {
      fImg = checkAndChangeFileImage(sLinkUse, this.args.fDirOdt, sLink, sTitle);
    } else {
      fImg = new File(this.args.fDirOdt, sLink);
      sLinkUse[0] = sLink;
    }
    sLink = sLinkUse[0];
    if(sLink.startsWith("./")) {
      sLink = "." + sLink;
    } else if(sLink.startsWith("../")) {
      sLink = "../" + sLink;
    } else {
      System.err.println("\nERROR img absolute: " + sLink);
      // do nothing for absolute link or link inside odt.
    }
    int[] nChars = new int[1];
    float nX =0, nY =0; String sMeas = null;
    if(sX !=null) {
      nX = StringFunctions_C.parseFloat(sX, 0, 99, nChars);
      sMeas = sX.substring(nChars[0]);
    }
    if(sY !=null) {
      nY = StringFunctions_C.parseFloat(sY, 0, 99, nChars);
      sMeas = sY.substring(nChars[0]);
    }
    if(sMeas == null) { sMeas = "in"; }
    float nScale = 1.0f;  // scale from inches to given unit. 
    if(sMeas.equals("cm")) { nScale = 2.54f; }
    else if(sMeas.equals("mm")) { nScale = 25.4f;  }
    else if(sMeas.equals("pt")) { nScale = 72; }
    else if(sMeas.equals("in")) { nScale = 1.0f; }
    else if(sMeas.equals("Pica")) { nScale = 6; }
    float dyFrame = 0.25f * nScale;
    String sYframe;
    if(sX == null || sY == null) {     //-------------------- The image size is not given:
      if(pX == null || pY == null) {
        if(fImg.exists()) {              //-------------------- read it from the real exist image.
          BufferedImage myPicture = ImageIO.read(fImg);
          WritableRaster raster = myPicture.getRaster();
          pX = "" + raster.getWidth();
          pY = "" + raster.getHeight();
        } else {
          System.out.printf("\nImage not found: %s", fImg.getAbsolutePath());
          pX = "1024";
          pY = "768";
        }
      }
      float npX = StringFunctions_C.parseIntRadix(pX, 0, 99, 10, null);
      float npY = StringFunctions_C.parseIntRadix(pY, 0, 99, 10, null);
      int nDPIx = StringFunctions_C.parseIntRadix(DPIx, 0, 99, 10, null);
      int nDPIy = StringFunctions_C.parseIntRadix(DPIy, 0, 99, 10, null);
      if(nX >0) {   //--------------------------------------- The width is given, it is often, 
        nY = nX * npY/npX;                                 // sY from given sX and natural relation of the image
      } else {
        nX = npX / nDPIx;                                  // sX, sY via given pixel and DPI
        nY = npY / nDPIy;
      }
    }
    if(nX > 7.1f * nScale) {
      nY = 7.1f * nScale / nX * nY;
      nX = 7.1f * nScale;                      // A4 site width
      sX = null; sY = null;  // to build newly
    }
    if(sX == null) { sX = String.format(Locale.ENGLISH, "%2.2f%s",nX, sMeas); }
    if(sY == null) { sY = String.format(Locale.ENGLISH, "%2.2f%s",nY, sMeas); }
    sYframe = String.format(Locale.ENGLISH, "%2.2f%s", (nY + dyFrame), sMeas);
//    String styleFrame = "Frame" + style.substring(3);
    this.bPageBreakBefore = this.bColumnBreakBefore = false; // flag is only for this paragraph
    //this.xmlWr.writeElement("draw:frame");
    //this.xmlWr.writeAttribute("draw:style-name", style);
    //this.xmlWr.writeAttribute("draw:name", "Frame" + (this.nrFrameImgName));
    //String sAnchor = bOnlyImage ? "as-char" : "paragraph";  // assign to character "char" produces only one line height in the paragraph
    String sAnchor = "paragraph";  // assign to character "char" produces only one line height in the paragraph
    //this.xmlWr.writeAttribute("text:anchor-type", sAnchor);
    //this.xmlWr.writeAttribute("svg:width", sX);
    //this.xmlWr.writeAttribute("svg:height", sYframe);
    //this.xmlWr.writeElement("draw:text-box");
    //this.xmlWr.writeElement("text:p");
    //this.xmlWr.writeAttribute("text:style-name", "Figure");
    if(bOnlyImage) {
      assert(this.sStyleParagr !=null);
      String sStyle = "ImgCaption" + this.sStyleParagr; //"Text"; //"Text" or "TextPg" or "TextCol"
//      if(this.bBreakBefore) {
//        sStyle += this.bInsideColumn2 ? "Col" : "Pg";
//      }
      this.xmlWr.writeAttribute("text:style-name", sStyle);
      this.sStyleParagr = null;
    }
    this.xmlWr.writeElement("draw:frame");
    this.xmlWr.writeAttribute("draw:name", "Image" + this.nrFrameImgName);
    this.xmlWr.writeAttribute("draw:style-name", styleImg);
    //this.xmlWr.writeAttribute("text:anchor-type", "paragraph");  // inside the frame image to the paragraph which is the caption text
    this.xmlWr.writeAttribute("text:anchor-type", sAnchor);  // inside the frame image to the paragraph which is the caption text
    //this.xmlWr.writeAttribute("svg:x", "0in");
    //this.xmlWr.writeAttribute("svg:y", "0in");
    this.xmlWr.writeAttribute("svg:width", sX);
    this.xmlWr.writeAttribute("svg:height", sY);
    this.xmlWr.writeElement("draw:image");
    this.xmlWr.writeAttribute("xlink:href", sLink);
    this.xmlWr.writeAttribute("xlink:type", "simple");
    this.xmlWr.writeAttribute("xlink:show", "embed");
    this.xmlWr.writeAttribute("xlink:actuate", "onLoad");
    this.xmlWr.writeAttribute("draw:mime-type", "image/png");
    this.xmlWr.writeElementEnd("draw:image");  //draw:image
    this.xmlWr.writeElementEnd("draw:frame"); //draw:frame
//    this.xmlWr.writeElementInline("text:bookmark-start");
//    this.xmlWr.writeAttribute("draw:name", "__RefNumPara__" + sId);
//    this.xmlWr.writeElementEnd("text:bookmark-start");
    this.bParagrFirstline = true;
//    writeText(sTitle, false);
//    this.xmlWr.writeElementInline("text:bookmark-end");
//    this.xmlWr.writeAttribute("draw:name", "__RefNumPara__" + sId);
//    this.xmlWr.writeElementEnd("text:bookmark-end"); //text:bookmark-end
//    this.xmlWr.writeElementEndInline("text:p"); //draw:h
//    this.xmlWr.writeElementEnd("draw:text-box"); //draw:h
//    this.xmlWr.writeElementEnd("draw:frame"); //draw:h
    if(!bFloat) {
      Debugutil.stop();
//      this.xmlWr.writeElementInline("text:line-break");
//      this.xmlWr.writeElementEnd("text:line-break");
    }
    String sBookmark;
    if(sId == null) {                       //--------------- id not given in ZmL:
      int posName = sLink.lastIndexOf('/') +1;             // then build automatically the bookmark only from the file name.
      int posDir = sLink.lastIndexOf('/', posName-2) +1;   // optional with the dir before it is not "./" or "../"
      int posExt = sLink.lastIndexOf('.');                 
      if(posDir >0 && sLink.charAt(posDir) !='.') {
        sBookmark = "__Img_" + sLink.substring(posDir, posName-1) + "_" + sLink.substring(posName, posExt);
      } else {
        sBookmark = "__Img_" + sLink.substring(posName, posExt);
      }
    } else if(sId.startsWith("__Img")) {    //--------------- a given user Id "__img_..."
      sBookmark = sId;
    } else {                                //--------------- a given user Id
      sBookmark = "__Img_" + sId;                          // the bookmark for images should always start with __Img
    }
    String sBookmark1 = sBookmark;
//    int nrBookmark = 0;
//    while(this.idxBookmark.get(sBookmark) !=null) {
//      sBookmark = sBookmark1 + "_" + (++nrBookmark); 
//    }
//    this.idxBookmark.put(sBookmark, sBookmark);
    if(bOnlyImage) {
      StringBuilder sCap = new StringBuilder(100);
      sCap.append(this.cfg.sImgCaptionStart);
      if(this.cfg.eImgKindNr == 1) {
        sCap.append(this.nrFrameImgName);
      }
      sCap.append(this.cfg.sImgCaption2);
      if(sTitle !=null) {
        sCap.append(sTitle);
      }
      this.xmlWr.writeElementInline("text:bookmark-start");
      this.xmlWr.writeAttribute("text:name", sBookmark);
      this.xmlWr.writeElementEnd("text:bookmark-start");
      this.xmlWr.writeText(sCap, false);
      this.xmlWr.writeElementInline("text:bookmark-end");
      this.xmlWr.writeAttribute("text:name", sBookmark);
      this.xmlWr.writeElementEnd("text:bookmark-end"); //text:bookmark-end
    } else {
    }
    this.nrFrameImgName +=1;
    wrRep("  " + sBookmark + ": " + sTitle);
    return error;
  }
  

  
  private File checkAndChangeFileImage (String[] sLinkUse, File dirOdt, String sLink, String sTitle) {
    sLinkUse[0] = sLink;                                   //default
    File fLink = new File(dirOdt, sLink);
    if(sTitle == null) return fLink ;
    int posName = sLink.lastIndexOf('/')+1;
    int posExt = sLink.lastIndexOf('.');
    int posEndTitleFile = StringFunctions.indexOfAnyChar(sTitle, 0, -1, ": ;&");
    if(posEndTitleFile <0) { posEndTitleFile = sTitle.length(); }
    int posExtTitle = sTitle.lastIndexOf('.', posEndTitleFile);
    if( posExtTitle >0 && posEndTitleFile > posExtTitle+1                 // sTitle has the form of a filename.ext: till faultyChars 
     && sLink.substring(posExt).equals(sTitle.substring(posExtTitle, posEndTitleFile))  // title contains the same extension
      ) {
     String sTitleFileName = sTitle.substring(0, posEndTitleFile);
      String sTitleFile = sLink.substring(0, posName) + sTitleFileName;
      File fLinkTitle = new File(dirOdt, sTitleFile);
      if(fLinkTitle.exists()) {
        sLinkUse[0] = sTitleFile;
        return fLinkTitle;                                 // The file name is taken from sTitle, exists.
      } else {
        if(fLink.exists()) {
          if(fLink.renameTo(fLinkTitle)) {                 // success renamed the linked file.
            sLinkUse[0] = sTitleFile;
            return fLinkTitle;
          }
        }
      }
    }
    return fLink;
  }
  
  
  


}
