package org.vishia.odt.readOdt;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import org.vishia.msgDispatch.LogMessage;
import org.vishia.util.Debugutil;
import org.vishia.util.FileFunctions;
import org.vishia.util.StringFunctions;

public class GetJavadocLabel {

  
  static class Link {
    String sLocal; String sWWW;
  }
  
  
  private LogMessage log;
  
  /**Index of Files, for which an index of all unique operation anchors are built already.
   * The inner Map is filled with {@link #createHtmlAnchorOperations(String)}
   */
  Map<String, Map<String, String>> idxHtmlFilesAnchors = new TreeMap<>();
  
  /**Index of all class names which are found in all '-javadoc=...' trees.
   * This allows to associate from a simple class name written as Java identifier
   * to the link relative to local JavaDoc as also to the internet.
   * <ul>
   * <li>This helps to find the correct link for a given class name in codeJava. 
   *   'codeJava' is a text block with <code>&lt;cJ:Class#field.></code> or <code>&lt;cJ:Class#operation(...).></code>
   *   or also <code>&lt;cJ:pkg.pkg1.Class.InnerClass#field.></code>.
   *   If this parts are found in ZmL a link is automatically created if the class is known here.
   * <li>The value String is the relative file name as it may be already evaluated in {@link #idxHtmlFilesAnchors}
   * respectively as used for the relative link, also manually written. 
   * <li>It starts always with "./" as usual for the relative links in ZmL
   * <li>The key is built always from the primary class name of the file.
   * <li>Inner classes have the key "OuterClass.InnerClass". This should be given in a codeJava-text.
   *   Only the inner class name is not sufficient (because it may not be unique).
   * <li>Additionally the one and two package identifier are stored also.
   *   It means the same value is addressed also by the key "pkg1.ClassName" and "pkg2.pkg1.ClassName".
   *   This allows to write this string in Javacode text.
   * <li>Classes with the same name in different packages are not stored, because the name is not unique.
   *   But of course the "pkg.name" is stored. This should be used in codeJava text.    
   * </ul> 
   */
  Map<String, Link> idxClass2Html = new TreeMap<>();
  
  GetJavadocLabel(LogMessage log) {
    this.log = log;
  }
  
  /**Creates all labels to unique operations of the given html file.
   * @param sHtml
   * @param dirBase
   * @return
   * @throws IOException
   */
  Map<String, String> createHtmlAnchorOperations (String sHtml, File dirBase) throws IOException{
    Map<String, String> idxOperations = new TreeMap<>();
    BufferedReader rHtml = new BufferedReader(new FileReader(new File(dirBase, sHtml)));
    String sLine;
    while((sLine = rHtml.readLine()) !=null) {
      int posEndName;
      if( sLine.startsWith("<a name=\"")                   // regard the structure of Javadoc result of Standard Java8
       && (posEndName = StringFunctions.indexAfterIdentifier(sLine, 9, -1, null)) >0
       && sLine.charAt(posEndName) == '-'                  // <a name="operationName- 
        ) {
        String operationName;
        if(sLine.charAt(posEndName+1) == '-') {
          operationName = sLine.substring(9, posEndName) + "()";
        } else {
          operationName = sLine.substring(9, posEndName);
        }
        int posAnchorEnd = sLine.indexOf('\"', posEndName);
        String sAnchor = sLine.substring(9, posAnchorEnd);
        String sExists = idxOperations.get(operationName);
        if(sExists !=null) {
          this.log.writeInfo("Info: operation twice: %s", sExists);
          idxOperations.put(operationName, sExists + "?"); // mark with "...?" for non unique operation
        } else {
          idxOperations.put(operationName, sAnchor);
        }
      }
    }
    rHtml.close();
    this.idxHtmlFilesAnchors.put(sHtml, idxOperations);
    return idxOperations;
  }
  

  
  void analyzeAllJavadocFiles (List<WriteOdt.DirPrepareJavadoc> listDirJavadoc, File fDirOdt) throws IOException {
    for(WriteOdt.DirPrepareJavadoc dirs : listDirJavadoc) {
      //String sPath = dirs.dirBase.getPath() + ":" + dirs.sLocal;
      String sBasePath = FileFunctions.normalizePath(dirs.dirBase.getPath()) + "/";
      //List<File> listFiles = new LinkedList<>();
      String sPathSearch = ":" + dirs.sLocal + "/**/*.html";
      
      List<FileFunctions.FileAndBasePath> listFiles = new LinkedList<>();
      boolean bFollowSymLinks = true;
      FileFunctions.addFilesWithBasePath(dirs.dirBase, sPathSearch, listFiles, bFollowSymLinks); 
      if(listFiles.size()==0) {
        this.log.writef("\nERROR no files found for anylyzeAllJavadocFiles(): %s:%s", sBasePath, dirs.sLocal);
      }
      //FileFunctions.addFileToList(sPathSearch, listFiles);
      for(FileFunctions.FileAndBasePath file: listFiles) {
        String sFileName = file.file.getName();
        //String sFile1 = "./" + FileFunctions.normalizePath(sFile);
        if(sFileName.endsWith(".html") && Character.isUpperCase(sFileName.charAt(0))) {
          String sFile1 = file.localPath;
          int posEnd = sFile1.length()-5;
          int[] posSlash = new int[3];
          posSlash[0] = sFile1.lastIndexOf('/');
          posSlash[1] = sFile1.lastIndexOf('/', posSlash[0]-1);
          posSlash[2] = sFile1.lastIndexOf('/', posSlash[1]-1);
          for(int ix = 0; ix < posSlash.length; ++ix) {
            String key = sFile1.substring(posSlash[ix] +1, posEnd);
            Link link = new Link();
            link.sLocal = "./" + sBasePath + file.localPath;  // start the relative local path with "./"
            link.sWWW = dirs.swww + "/" + file.localPath ;
            this.idxClass2Html.put(key, link);
          }
        }
      }
      
      Debugutil.stop();
    }
  }
  
  
  public void reportClassesJavadoc(File fOut) throws IOException {
    Writer wOut = new FileWriter(fOut);
    for(Map.Entry<String, Link> e: this.idxClass2Html.entrySet()) {
      String key = e.getKey();
      Link value = e.getValue();
      wOut.append(key).append(":    ").append(value.sLocal).append("   @").append(value.sWWW).append("\n");
    }
    wOut.close();
  }
  
  
}
