package org.vishia.odt.readOdt;

import java.util.LinkedList;
import java.util.List;

import org.vishia.util.Debugutil;
import org.vishia.util.StringFunctions;
import org.vishia.util.StringFunctions_C;

/**Parses the &lt;::include:... line and stores values.
 * @author hartmut Schorrig
 *
 */
public class CodeIncludeInfo {

  final String sErrorMsg;
  
  //final String sLineIncl;
  
  final String sFile;
  
  final String sTagStart, sTagEnd;
  
  /**Simple case, a number of lines given after ::...'searchText'3::*/
  final int nrLines;
  
  final int indentStart, indentEnd;
  
  final int tagStartRepeat, tagEndRepeat;
  
  final String sTagStartNextLine;

  final String sTagEndExclLine;
  
  final String sTagPause;
  
  final String sTagCont;

  
  final boolean bWriteTag;
  
  final String sComment;
  
  final int maxLineLen;
  
  final int nrofSpacesIndent;
  
  final List<CodeIncludeInfo.MarkerLine> markerLines;
  
  /**
   * Syntax in ZBNF: <pre>
   * includeInfo::=&lt;*|::?PATH>::&lt;*|::?TAG>
   *     [::&lt;#?LineWidth>][::-&lt;*|::?removeComment>]
   *     [{[+&lt;?nextLine>]&lt;#?LINE>[,&lt;#?COLUMN>][:&lt;*,\.?MARKER>}].
   * </pre>
   * @param line Starting from the path after 'include:' till exclusive '.>',
   *        both usable for
   *         the CaptionCode paragraph text for odt2VML and also '&lt;:include:...' for VML2odt
   */
  public CodeIncludeInfo ( String sLineInclArg) {
    //if(sLineInclArg.contains("include:../../BasicTest/cpp/genSrc/ArraySlideDemux.c::'step_FBx(&thiz->fb1a'#6::45")) Debugutil.stopp();
    //if(sLineInclArg.contains("::':args ##':-cfg::93")) Debugutil.stopp();
    int markerColumn = 0;
    final int posPathStart = 8;                            // before is 'include:' 8 character.
    int posPathEnd = sLineInclArg.indexOf("::");              //     posPathEnd---------+                 +---posEnd
    String sErrorMsg = null;
    if(posPathEnd <0) {
      this.sFile = null;
      sErrorMsg = String.format("\nERROR %s, '::TAG' missing", sLineInclArg);
//      this.sLineIncl = sLineInclArg;
      this.sTagStart = this.sTagEnd = null;
      this.sTagStartNextLine = this.sTagEndExclLine = null;
      this.sTagPause = this.sTagCont = null;
      this.nrLines = -1;
      this.indentStart = this.indentEnd = -1;
      this.tagStartRepeat = this.tagEndRepeat = -1;
      this.bWriteTag = false;
      this.sComment = null;
      this.maxLineLen = -1;
      this.nrofSpacesIndent = 2;
      this.markerLines = null;
    } else {
      this.sFile = sLineInclArg.substring(posPathStart, posPathEnd).trim();  
      int posEnd = sLineInclArg.indexOf(".>", posPathEnd +2);   //  include:path/to/file.c::TAG::44::2:a,4:B.>
      //if(posEnd <0) { posEnd = sLineInclArg.indexOf('>', posPathEnd +2); } //fallback          |   | 2:a,4:B> 
      assert(posEnd <0);
      if(posEnd <0) { posEnd = sLineInclArg.length(); }
      final String sLineIncl;
      if(posEnd >=0) {
        sLineIncl = sLineInclArg.substring(0, posEnd);
      } else {  
        sLineIncl = sLineInclArg;
        posEnd = sLineIncl.length();          // in odt                      |   |
      }
//      this.sLineIncl = sLineIncl;
      //
      int posStartText = sLineIncl.indexOf('\'', posPathEnd+2)+1;  //Note: not found -1 ist then 0!
      int posEnd_Tag;
      //
      //
      //=============================================================================
      //=============================================================================
      //===================================================vvvv==== set sTagStart etc.
      //
      if(posStartText >0) {            //==================vv use 'starttext to search text in code as start, not a <::TAG:>
        this.bWriteTag = true;                             // write line inclusively this starttext
        //
        int posEnd_StartText = sLineIncl.indexOf('\'',posStartText); // search the second '
        int pos_EndText, posEnd_EndText;
        char c1;
        if(posEnd_StartText < 0) {
          posEnd_Tag = posEnd_StartText = sLineIncl.indexOf("::",posStartText);  // <::include:file::'start::.>
          pos_EndText = posEnd_EndText = -1;
        }
        else if( (c1 = sLineIncl.charAt(posEnd_StartText+1)) =='#' // 'startText'#nrofLines, here is no reason for third '
              || c1 ==':'                                  // 'startText':: also no third '
          ) {                                    //--------vv # * ! does not follow, do not search a next '...' 
          pos_EndText = c1 == '#' ? posEnd_StartText +1 : -1; // no end text if '#12 not follow, but pos_EndText necessary to parse #12
          posEnd_EndText = -1;               
          posEnd_Tag = sLineIncl.indexOf("::",posEnd_StartText);  // <::include:file::'start'#12::.>
        }
        else {                         //------------------vv second ' found: <::include:file::'start'... .>
          //
          int pos3 = sLineIncl.indexOf('\'',posEnd_StartText+1)+1; //<::include:file::'start'...'...::.>
          if(pos3 <= 0) {                                   //                         v---------pos_EndText
            pos_EndText = posEnd_StartText +1;             // <::include:file::'start'end::91.>
            posEnd_EndText =  posEnd_Tag = sLineIncl.indexOf("::",pos_EndText);      //  ^------posEnd_EndText
          } 
          else {                       //------------------vv pos3 >0: <::include:file::'start'...'.>
            int pos4 = sLineIncl.indexOf('\'',pos3);
            if(pos4 <0) {              //------------------vv forth ' not found:                     
              posEnd_Tag = sLineIncl.indexOf("::",pos3);                       //pos3------v
              if(posEnd_Tag != pos3) {                   // <::include:file::*2'start'end'::91.>
                sErrorMsg = "faulty character after 3th ' ";     //                         ^--------posEnd_Tag
              }
              pos_EndText = posEnd_StartText +1;           // <::include:file::*2'start'endText'.>
              posEnd_EndText = pos3-1     ;                //     posEnd_StartText-----^        ^---pos3
            } 
            else {                     //------------------vv forth ' definitely found: <::include:file::'start'...'end'.>
              posEnd_Tag = sLineIncl.indexOf("::",pos4);   // pos4 is important if endText contains also a '::'
              pos_EndText = pos3;
              posEnd_EndText = pos4;
              
            }
          }
        }
        this.sTagStart = sLineIncl.substring(posStartText, posEnd_StartText);
        if(this.sTagStart.length()==0) {
          sErrorMsg = "empty startText not admissible.";
        }
        //
        //                             //------------------vv <::include:file::2*3!4'start....
        if(posStartText > posPathEnd+3) {                  // posPathEnd-----^ ^     ^-----posStartText
          int pos = posPathEnd +2;                         //    pos-----------+ 
          int[] parsedChars = new int[1];                  // 2... then this is the number of indentation spaces in source:
          int nrofSpacesIndent = StringFunctions_C.parseIntRadix(sLineIncl, pos, posStartText-1, 10, parsedChars);
          if(parsedChars[0]>0) { this.nrofSpacesIndent = nrofSpacesIndent; pos += parsedChars[0]; }
          else { this.nrofSpacesIndent = 2; }
          //
          if( sLineIncl.charAt(pos) == '*') {                  // *2'starttext  should be taken only 2th time occurring
            this.tagStartRepeat = StringFunctions_C.parseIntRadix(sLineIncl, pos+1, -1, 10, parsedChars);
            pos += 1 + parsedChars[0];
          } else {
            this.tagStartRepeat = 1;
          }
          //
          if( sLineIncl.charAt(pos) == '!') {                  // !1'startText; then this is left with indent
            this.indentStart = StringFunctions_C.parseIntRadix(sLineIncl, pos+1, -1, 10, parsedChars);
            pos += 1 + parsedChars[0];
          } else {
            this.indentStart = -1;
          }
          if(pos+1 != posStartText) {                      // pos is now on ', start text following.
            sErrorMsg = "faulty syntax before 'startText";
          }
        } else {
          this.nrofSpacesIndent = 2;
          this.tagStartRepeat = 1;
          this.indentStart = -1;
        }
        //
        int[] parsedChars = new int[1];                  //------------------vv <::include:file::...'start'...'end'...::
        int nrLines = -1;
        if(pos_EndText <0) {
          this.nrLines = 99999;  // note: the source file may be so long, not the output
          this.sTagEnd = null;   // not given, all till end of file
          this.tagEndRepeat =-1;
          this.indentEnd = -1;
        } else {
          if(sLineIncl.charAt(pos_EndText) == '#') {  //---------- <::include:file::'start'#3::... .>
            nrLines = StringFunctions_C.parseIntRadix(sLineIncl, pos_EndText+1, -1, 10, parsedChars);
            if(parsedChars[0] ==0) {
              nrLines = 1;                           // <::include:file::...'start'#99::... .>
            }
            this.nrLines = nrLines;
            this.sTagEnd = null;
            this.tagEndRepeat =-1;
            this.indentEnd = -1;
          }
          else {
            this.nrLines = -1;                             // <::include:file::'start'end::... .>
            this.sTagEnd = sLineIncl.substring(pos_EndText, posEnd_EndText);
            
            if(pos_EndText > posEnd_StartText+1) {         // <::include:file::'start'*2'end::... .>
              int pos = posEnd_StartText +1;                         // after file::
              //
              if( sLineIncl.charAt(pos) == '*') {                  // *2'starttext  should be taken only 2th time occurring
                this.tagEndRepeat = StringFunctions_C.parseIntRadix(sLineIncl, pos+1, -1, 10, parsedChars);
                pos += 1 + parsedChars[0];
              } else {
                this.tagEndRepeat = 1;
              }
              //
              if( sLineIncl.charAt(pos) == '!') {                  // !1'startText; then this is left with indent
                this.indentEnd = StringFunctions_C.parseIntRadix(sLineIncl, pos+1, -1, 10, parsedChars);
                pos += 1 + parsedChars[0];
              } else {
                this.indentEnd = -1;
              }
            } else {
              this.tagEndRepeat = 1;
              this.indentEnd = -1;
            }
          }
        }
        this.sTagEndExclLine = null;
        this.sTagStartNextLine = null;
        this.sTagCont = this.sTagPause = null;
      }                                 
      //===================================================^^^^ use 'starttext' to search text in code as start: 
      //=============================================================================
      //=============================================================================
      //
      //
      //=============================================================================
      //=============================================================================
      //===================================================vvvv==== set sTagStart etc.
      //
      else {                           //------------------vv build '<::TAG.> etc. as search text.
        this.indentStart = this.indentEnd = -1;
        this.tagEndRepeat = this.tagStartRepeat = 1;
        this.nrLines = -1;
        posEnd_Tag = sLineIncl.indexOf("::", posPathEnd +2);//     posTagEnd---------------+   |
        //
        //
        if(posEnd_Tag <0) { posEnd_Tag = posEnd; }           // fallback no ::43.> given, line length
        String sTag = sLineIncl.substring(posPathEnd+2, posEnd_Tag).trim();
        this.bWriteTag = false;   //-----------------------vv Tag should be given as <::sTag.> in the source
        this.nrofSpacesIndent = -1;
        this.sTagStart = "<::" + sTag + ".>";
        this.sTagStartNextLine = "<::~" + sTag + ".>";
        this.sTagEndExclLine = "<:.~" + sTag + ".>";
        this.sTagEnd = "<:." + sTag + ".>";
        this.sTagPause = "<:-" + sTag + ".>";
        this.sTagCont = "<:+" + sTag + ".>";
      } //=================================================^^^^ set sTagStart etc. ==================================
      //=============================================================================
      //=============================================================================
      //
      //
      //
      //=============================================================================
      //=============================================================================
      //===================================================vvvv read maxLineLen, sComment, markers
      //                                                                posTagEnd-----------+   +----posLenEnd
      int posLenEnd = sLineIncl.indexOf("::", posEnd_Tag +2); //<:include:path/to/file.c::TAG::77::.>
      if(posLenEnd <0) { posLenEnd = posEnd; }               //<:include:path/to/file.c::TAG::77.>
      if(posLenEnd == posEnd_Tag+2) {             //----------  <:include:path/to/file.c::TAG.>
        this.maxLineLen = 44;                              // then default len, no more comment, no markerLines
        this.markerLines = null;
        this.sComment = null;
      } else {                                   //----------  <:include:path/to/file.c::TAG::77.......>
        int maxLineLen = StringFunctions_C.parseIntRadix(sLineIncl, posEnd_Tag+2, 99, 10, null);
        if(maxLineLen >30) {
          this.maxLineLen = maxLineLen;
        } else {
          this.maxLineLen = 30;  // prevent later an StringIndexOutOfBoundsException, min 3..4 char width is necessary
        }
        int pos = posLenEnd;
        if(posEnd > pos + 3 && sLineIncl.substring(pos, pos+3).equals("::-")) {  
          int pos2 = sLineIncl.indexOf("::", pos+3);         // '::-lineEndComment start string::' remove the line end comment
          if(pos2 <0) pos2 = posEnd;
          this.sComment = sLineIncl.substring(pos+3, pos2);
          pos = pos2;
        } else {
          this.sComment = null;
        }
        //
        //========vvvv=======================================vv build this.markerLines
        //  
        if(posEnd > pos +2) {
          this.markerLines = new LinkedList<>();
          int[] len = new int[1];
          //int nrLine = 0;
          while(posEnd > pos+2 && sLineIncl.substring(pos, pos+2).equals("::")) {
            pos +=2;   //first ok, second: after ','
            CodeIncludeInfo.MarkerLine m = new CodeIncludeInfo.MarkerLine();
            //boolean bincrLine = false;
            if(sLineIncl.charAt(pos) == '\'') {            // ::'searchTextForMarker'
              int posEndM = sLineIncl.indexOf('\'', pos+1);
              if(posEndM <0) { posEndM = sLineIncl.indexOf(':', pos+1) -1; }
              if(posEndM <0) {posEndM = posEnd; }
              m.sSearch = sLineIncl.substring(pos+1, posEndM);
              m.line = -1;
              pos = posEndM +1;
            } else {
              if(sLineIncl.charAt(pos) == '+') {
                m.bLineNext = true; pos +=1; 
              }
              int line = StringFunctions_C.parseIntRadix(sLineIncl, pos, 99, 10, len);
              //nrLine = bincrLine ? nrLine += line : line;
              m.line = line; //nrLine;
              m.sSearch = null;
              pos += len[0];
            }
            if(pos < posEnd && sLineIncl.charAt(pos) == ',') {             // ::2,35
              pos +=1;                                     //    ^---- column given
              markerColumn = StringFunctions_C.parseIntRadix(sLineIncl, pos, 99, 10, len);
              pos += len[0];
            } // else: use the last value of markerColumn.
            m.column = markerColumn;                       //       v-------- text starts after
            char c1;
            if(pos < posEnd && ((c1 = sLineIncl.charAt(pos)) == '=' || c1 == ':' )) {      // ::2,35=text::
              pos +=1;                                     //            ^--- end of the text
              int pos2 = StringFunctions.indexOfAnyString(sLineIncl, pos, posEnd, new String[] { "::", ".>"}, null, null);
              if(pos2 <0) { pos2 = posEnd; }
              m.marker = sLineIncl.substring(pos, pos2);
              pos = pos2;
            } else {
              m.marker = "-";                              // may be the last one, then switch off.
            }
            this.markerLines.add(m);
          } 
        } else {
          this.markerLines = null;
        }
        //
        //========^^^^=======================================^^ build this.markerLines
        //
      }
      //===================================================vvvv read maxLineLen, sComment
      //=============================================================================
      //=============================================================================
      //
    } // else posPathEnd found, file set. 
    this.sErrorMsg = sErrorMsg;
  }
  
  
  
  
  static class MarkerLine { String sSearch; int line; boolean bLineNext; int column; String marker;}

}
