package org.vishia.libOffc.styles;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import org.vishia.util.Debugutil;
import org.vishia.util.OutTextPreparer;

/**This class manages write and re-read of textual presentations of the styles. 
 * It works together with the style data in {@link LOffcStyle} and referenced in {@link XmlDataLOffcStyles_Base}
 * as read from XML. 
 */
public class RdWrStyle2Text_LOffc {

  
  final OutTextPreparer gtxtHeadStyle  = new OutTextPreparer(  "headStyle", null, "stD, NEWLINE==nli",
      "==Style: <&stD.style_family>.<&stD.style_name>"
  );
  
  final OutTextPreparer gtxtTextStyle  = new OutTextPreparer(  "textStyle", null, "stD, NEWLINE==nli",
      "==Text: font<&stD.font_family()><&stD.font_style()>:<&stD.font_size()><&stD.font_variant()><&stD.font_weight()>"
  );
  
  final OutTextPreparer gtxtDrawStyle  = new OutTextPreparer(  "drawStyle", null, "stD, NEWLINE==nli",
      ", Draw: fill=<&stD.draw_fill><&stD.draw_fill_color>"
      + "<:if:stD.draw_line_distance> lineDist=<&stD.draw_line_distance><.if>"
      + "<:if:stD.draw_marker_start> mStart=<&stD.draw_marker_start> <&stD.draw_marker_start_width><.if>"
      + "<:if:stD.draw_marker_end> mEnd=<&stD.draw_marker_end> <&stD.draw_marker_end_width>"
      + "<:elsif:stD.draw_marker_end_width> mEndWidth=<&stD.draw_marker_end_width><.if>"  

  );
  
  final String nl = "\n                                                        ";
  
  
  final Map<String, OutTextPreparer.DataTextPreparer> idxOtxdata = new TreeMap<String, OutTextPreparer.DataTextPreparer>();

  List<LOffcStyle> parents = new LinkedList<>(); 
  Map<String, LOffcStyle> idxStyles = new TreeMap<>(); 
  
  RdWrStyle2Text_LOffc () {
    Debugutil.stop();
  }
  
  void init () {
    
  }
  
  /**Gets the proper instance of DataTextPreparer to run {@link OutTextPreparer#exec(Appendable, org.vishia.util.OutTextPreparer.DataTextPreparer)} 
   * running repeatedly in the same thread.
   * Hint: For more as one thread use different instances. Use the threadId also as key.
   * @param otx
   * @return data instance for the exec(...) call.
   */
  OutTextPreparer.DataTextPreparer getCreateOtxData(OutTextPreparer otx, int nIndent) {
    OutTextPreparer.DataTextPreparer ret = this.idxOtxdata.get(otx.sIdent);
    if(ret == null) {
      ret = otx.createArgumentDataObj();
      ret.setExecObj(this);                                // always the same argument
      this.idxOtxdata.put(otx.sIdent, ret);
    }
    ret.setArgumentOptional("nli", this.nl.substring(0, 2*nIndent+1));   // current arguments.
    return ret;
  }
  
  
  public void writeStyleDetToText (XmlDataLOffcStyles_Zbnf data, File fout) {
    Iterable<XmlDataLOffcStyles.Style_style> listStyles = data.dataroot.get_office_document_styles().get_office_styles().get_style_style();
    for(XmlDataLOffcStyles.Style_style style: listStyles) {
      String name = style.get_style_name();
      if(this.idxStyles.get(name) !=null) {
        Debugutil.stop();
      }
      this.idxStyles.put(name, new LOffcStyle(style));
    }
    for(LOffcStyle style: this.idxStyles.values()) {
      String name = style.styleXml.get_style_name();
      String parentStyle = style.styleXml.get_style_parent_style_name();
      if(parentStyle == null) {
        this.parents.add(style);
      } else {
        LOffcStyle styleParent = this.idxStyles.get(parentStyle);
        if(styleParent == null) {
          Debugutil.stopp();
        } else {
          styleParent.addChildAndSetParentonChild(style);
        }
      }
    }
    try {
      FileWriter wr = new FileWriter(fout);
      OutTextPreparer.WriteDst out = new OutTextPreparer.WriteDst(wr, 0);
      for(LOffcStyle style: this.parents) {      //========vv for all absolute parents:
        writeStyleAndChildren(style, out, 0);              // write the style tree
      }
      out.close();
      wr.close();
    } catch(IOException exc) {
      Debugutil.stopp();
    }
    Debugutil.stop();
  }

  
  
  /**Write textual the style and all chiildren.
   * @param style
   * @param out
   * @param recursion
   * @throws IOException
   */
  public void writeStyleAndChildren (LOffcStyle style, OutTextPreparer.WriteDst out, int recursion) throws IOException {
    if(recursion >10) {
      Debugutil.stopp(); return;
    }
    String sFamily = style.styleXml.style_family;        // style:style
    OutTextPreparer.DataTextPreparer data = getCreateOtxData(this.gtxtHeadStyle, recursion);
    data.setArgument("stD", style.styleXml);
    this.gtxtHeadStyle.exec(out, data);
    if(style.styleXml.style_graphic_properties !=null) for(XmlDataLOffcStyles.Style_graphic_properties styleGr: style.styleXml.style_graphic_properties) {
      OutTextPreparer.DataTextPreparer datagr = getCreateOtxData(this.gtxtDrawStyle, recursion+1);
      datagr.setArgument("stD", styleGr);
      this.gtxtDrawStyle.exec(out, datagr);
      
    }
    if(style.stylesChildren !=null) for(LOffcStyle style1 : style.stylesChildren) {
      writeStyleAndChildren(style1, out, recursion+1);
    }
    Debugutil.stop();
  }



  
  final void writeTextStyle (Map<String, LOffcStyle> idxStyles) {
    for(LOffcStyle style: idxStyles.values()) {
      Debugutil.stop();

    }
  }
  
  
  final void writeDrawStyle (Map<String, LOffcStyle> idxStyles) {
  
    
    for(LOffcStyle style: idxStyles.values()) {
      Debugutil.stop();

    }
  }
  
  
  
}
